/*
 * Decompiled with CFR 0.152.
 */
package hex.util;

import Jama.CholeskyDecomposition;
import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import hex.DataInfo;
import hex.FrameTask;
import hex.ToEigenVec;
import hex.gram.Gram;
import water.DKV;
import water.Job;
import water.Key;
import water.Keyed;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.util.ArrayUtils;

public class LinearAlgebraUtils {
    public static ToEigenVec toEigen = new ToEigenVec(){

        public Vec toEigenVec(Vec src) {
            return LinearAlgebraUtils.toEigen(src);
        }
    };

    public static double[] forwardSolve(double[][] L, double[] b) {
        assert (L != null && L.length == L[0].length && L.length == b.length);
        double[] res = new double[b.length];
        for (int i = 0; i < b.length; ++i) {
            res[i] = b[i];
            for (int j = 0; j < i; ++j) {
                int n = i;
                res[n] = res[n] - L[i][j] * res[j];
            }
            int n = i;
            res[n] = res[n] / L[i][i];
        }
        return res;
    }

    private static double modifyNumeric(double x, int col, DataInfo dinfo) {
        double y;
        double d = y = Double.isNaN(x) && dinfo._imputeMissing ? dinfo._numMeans[col] : x;
        if (dinfo._normSub != null && dinfo._normMul != null) {
            y = (y - dinfo._normSub[col]) * dinfo._normMul[col];
        }
        return y;
    }

    public static double[] expandRow(double[] row, DataInfo dinfo, double[] tmp, boolean modify_numeric) {
        for (int col = 0; col < dinfo._cats; ++col) {
            int cidx;
            if (Double.isNaN(row[col])) {
                if (dinfo._imputeMissing) {
                    cidx = dinfo.catNAFill()[col];
                } else {
                    if (!dinfo._catMissing[col]) continue;
                    cidx = dinfo._catOffsets[col + 1] - 1;
                }
            } else {
                cidx = dinfo.getCategoricalId(col, (int)row[col]);
            }
            if (cidx < 0) continue;
            tmp[cidx] = 1.0;
        }
        int chk_cnt = dinfo._cats;
        int exp_cnt = dinfo.numStart();
        for (int col = 0; col < dinfo._nums; ++col) {
            tmp[exp_cnt] = modify_numeric ? LinearAlgebraUtils.modifyNumeric(row[chk_cnt], col, dinfo) : row[chk_cnt];
            ++exp_cnt;
            ++chk_cnt;
        }
        return tmp;
    }

    public static double[][] computeR(Key<Job> jobKey, DataInfo yinfo, boolean transpose) {
        Gram.GramTask gtsk = new Gram.GramTask(jobKey, yinfo);
        gtsk.doAll(yinfo._adaptedFrame);
        Matrix ygram = new Matrix(gtsk._gram.getXX());
        CholeskyDecomposition chol = new CholeskyDecomposition(ygram);
        double[][] L = chol.getL().getArray();
        ArrayUtils.mult((double[][])L, (double)Math.sqrt(gtsk._nobs));
        return transpose ? L : ArrayUtils.transpose((double[][])L);
    }

    public static double computeQ(Key<Job> jobKey, DataInfo yinfo, Frame ywfrm) {
        double[][] cholL = LinearAlgebraUtils.computeR(jobKey, yinfo, true);
        ForwardSolve qrtsk = new ForwardSolve(yinfo, cholL);
        qrtsk.doAll(ywfrm);
        return qrtsk._sse;
    }

    public static void computeQInPlace(Key<Job> jobKey, DataInfo yinfo) {
        double[][] cholL = LinearAlgebraUtils.computeR(jobKey, yinfo, true);
        ForwardSolveInPlace qrtsk = new ForwardSolveInPlace(yinfo, cholL);
        qrtsk.doAll(yinfo._adaptedFrame);
    }

    public static int numColsExp(Frame fr, boolean useAllFactorLevels) {
        int uAFL = useAllFactorLevels ? 0 : 1;
        int cols = 0;
        for (Vec vec : fr.vecs()) {
            cols += vec.isCategorical() && vec.domain() != null ? vec.domain().length - uAFL : 1;
        }
        return cols;
    }

    static double[] multiple(double[] diagYY, int nTot, int nVars) {
        int ny = diagYY.length;
        int i = 0;
        while (i < ny) {
            int n = i++;
            diagYY[n] = diagYY[n] * (double)nTot;
        }
        double[][] uu = new double[ny][ny];
        for (int i2 = 0; i2 < ny; ++i2) {
            for (int j = 0; j < ny; ++j) {
                double yyij = i2 == j ? diagYY[i2] : 0.0;
                uu[i2][j] = (yyij - diagYY[i2] * diagYY[j] / (double)nTot) / ((double)nVars * Math.sqrt(diagYY[i2] * diagYY[j]));
                if (!Double.isNaN(uu[i2][j])) continue;
                uu[i2][j] = 0.0;
            }
        }
        EigenvalueDecomposition eigen = new EigenvalueDecomposition(new Matrix(uu));
        double[] eigenvalues = eigen.getRealEigenvalues();
        double[][] eigenvectors = eigen.getV().getArray();
        int maxIndex = ArrayUtils.maxIndex((double[])eigenvalues);
        return eigenvectors[maxIndex];
    }

    public static Vec toEigen(Vec src) {
        Frame train = new Frame(Key.make(), new String[]{"enum"}, new Vec[]{src});
        DataInfo dinfo = new DataInfo(train, null, 0, true, DataInfo.TransformType.NONE, DataInfo.TransformType.NONE, false, true, false, false, false, false, false);
        DKV.put((Keyed)dinfo);
        Gram.GramTask gtsk = (Gram.GramTask)new Gram.GramTask(null, dinfo).doAll(dinfo._adaptedFrame);
        double[] rounded = new double[gtsk._gram._diag.length];
        for (int i = 0; i < rounded.length; ++i) {
            rounded[i] = (float)gtsk._gram._diag[i];
        }
        dinfo.remove();
        Vec v = ((ProjectOntoEigenVector)new ProjectOntoEigenVector(LinearAlgebraUtils.multiple(rounded, (int)gtsk._nobs, 1)).doAll(1, (byte)3, train)).outputFrame().anyVec();
        return v;
    }

    static class ProjectOntoEigenVector
    extends MRTask<ProjectOntoEigenVector> {
        final double[] _yCoord;

        ProjectOntoEigenVector(double[] yCoord) {
            this._yCoord = yCoord;
        }

        public void map(Chunk[] cs, NewChunk[] nc) {
            for (int i = 0; i < cs[0]._len; ++i) {
                if (cs[0].isNA(i)) {
                    nc[0].addNA();
                    continue;
                }
                int which = (int)cs[0].at8(i);
                nc[0].addNum((double)((float)this._yCoord[which]));
            }
        }
    }

    public static class ForwardSolveInPlace
    extends MRTask<ForwardSolveInPlace> {
        final DataInfo _ainfo;
        final int _ncols;
        final double[][] _L;

        public ForwardSolveInPlace(DataInfo ainfo, double[][] L) {
            assert (L != null && L.length == L[0].length && L.length == ainfo._adaptedFrame.numCols());
            this._ainfo = ainfo;
            this._ncols = ainfo._adaptedFrame.numCols();
            this._L = L;
        }

        public void map(Chunk[] cs) {
            assert (this._ncols == cs.length);
            Chunk[] achks = new Chunk[this._ncols];
            System.arraycopy(cs, 0, achks, 0, this._ncols);
            for (int row = 0; row < cs[0]._len; ++row) {
                DataInfo.Row arow = this._ainfo.newDenseRow();
                this._ainfo.extractDenseRow(achks, row, arow);
                if (arow.isBad()) continue;
                double[] aexp = arow.expandCats();
                double[] qrow = LinearAlgebraUtils.forwardSolve(this._L, aexp);
                assert (qrow.length == this._ncols);
                for (int d = 0; d < this._ncols; ++d) {
                    cs[d].set(row, qrow[d]);
                }
            }
        }
    }

    public static class ForwardSolve
    extends MRTask<ForwardSolve> {
        final DataInfo _ainfo;
        final int _ncols;
        final double[][] _L;
        public double _sse;

        public ForwardSolve(DataInfo ainfo, double[][] L) {
            assert (L != null && L.length == L[0].length && L.length == ainfo._adaptedFrame.numCols());
            this._ainfo = ainfo;
            this._ncols = ainfo._adaptedFrame.numCols();
            this._L = L;
            this._sse = 0.0;
        }

        public void map(Chunk[] cs) {
            assert (2 * this._ncols == cs.length);
            Chunk[] achks = new Chunk[this._ncols];
            System.arraycopy(cs, 0, achks, 0, this._ncols);
            for (int row = 0; row < cs[0]._len; ++row) {
                DataInfo.Row arow = this._ainfo.newDenseRow();
                this._ainfo.extractDenseRow(achks, row, arow);
                if (arow.isBad()) continue;
                double[] aexp = arow.expandCats();
                double[] qrow = LinearAlgebraUtils.forwardSolve(this._L, aexp);
                int i = 0;
                for (int d = this._ncols; d < 2 * this._ncols; ++d) {
                    double qold = cs[d].atd(row);
                    double diff = qrow[i] - qold;
                    this._sse += diff * diff;
                    cs[d].set(row, qrow[i++]);
                }
                assert (i == qrow.length);
            }
        }
    }

    public static class SMulTask
    extends MRTask<SMulTask> {
        final DataInfo _ainfo;
        final int _ncolA;
        final int _ncolExp;
        final int _ncolQ;
        public double[][] _atq;

        public SMulTask(DataInfo ainfo, int ncolQ) {
            this._ainfo = ainfo;
            this._ncolA = ainfo._adaptedFrame.numCols();
            this._ncolExp = LinearAlgebraUtils.numColsExp(ainfo._adaptedFrame, true);
            this._ncolQ = ncolQ;
        }

        public void map(Chunk[] cs) {
            assert (this._ncolA + this._ncolQ == cs.length);
            this._atq = new double[this._ncolExp][this._ncolQ];
            for (int k = this._ncolA; k < this._ncolA + this._ncolQ; ++k) {
                for (int p = 0; p < this._ainfo._cats; ++p) {
                    for (int row = 0; row < cs[0]._len; ++row) {
                        int cidx;
                        if (cs[p].isNA(row) && this._ainfo._skipMissing) continue;
                        double q = cs[k].atd(row);
                        double a = cs[p].atd(row);
                        if (Double.isNaN(a)) {
                            if (this._ainfo._imputeMissing) {
                                cidx = this._ainfo.catNAFill()[p];
                            } else {
                                if (!this._ainfo._catMissing[p]) continue;
                                cidx = this._ainfo._catOffsets[p + 1] - 1;
                            }
                        } else {
                            cidx = this._ainfo.getCategoricalId(p, (int)a);
                        }
                        if (cidx < 0) continue;
                        double[] dArray = this._atq[cidx];
                        int n = k - this._ncolA;
                        dArray[n] = dArray[n] + q;
                    }
                }
                int pnum = 0;
                int pexp = this._ainfo.numStart();
                for (int p = this._ainfo._cats; p < this._ncolA; ++p) {
                    for (int row = 0; row < cs[0]._len; ++row) {
                        if (cs[p].isNA(row) && this._ainfo._skipMissing) continue;
                        double q = cs[k].atd(row);
                        double a = cs[p].atd(row);
                        a = LinearAlgebraUtils.modifyNumeric(a, pnum, this._ainfo);
                        double[] dArray = this._atq[pexp];
                        int n = k - this._ncolA;
                        dArray[n] = dArray[n] + q * a;
                    }
                    ++pexp;
                    ++pnum;
                }
                assert (pexp == this._atq.length);
            }
        }

        public void reduce(SMulTask other) {
            ArrayUtils.add((double[][])this._atq, (double[][])other._atq);
        }
    }

    public static class BMulInPlaceTask
    extends MRTask<BMulInPlaceTask> {
        final DataInfo _xinfo;
        final double[][] _yt;
        final int _ncolX;

        public BMulInPlaceTask(DataInfo xinfo, double[][] yt) {
            assert (yt != null && yt[0].length == LinearAlgebraUtils.numColsExp(xinfo._adaptedFrame, true));
            this._xinfo = xinfo;
            this._ncolX = xinfo._adaptedFrame.numCols();
            this._yt = yt;
        }

        public void map(Chunk[] cs) {
            assert (cs.length == this._ncolX + this._yt.length);
            Chunk[] xchk = new Chunk[this._ncolX];
            DataInfo.Row xrow = this._xinfo.newDenseRow();
            System.arraycopy(cs, 0, xchk, 0, this._ncolX);
            for (int row = 0; row < cs[0]._len; ++row) {
                this._xinfo.extractDenseRow(xchk, row, xrow);
                if (xrow.isBad()) continue;
                int bidx = this._ncolX;
                for (double[] ps : this._yt) {
                    double sum = xrow.innerProduct(ps);
                    cs[bidx].set(row, sum);
                    ++bidx;
                }
                assert (bidx == cs.length);
            }
        }
    }

    public static class BMulTask
    extends FrameTask<BMulTask> {
        final double[][] _yt;

        public BMulTask(Key<Job> jobKey, DataInfo dinfo, double[][] yt) {
            super(jobKey, dinfo);
            this._yt = yt;
        }

        @Override
        protected void processRow(long gid, DataInfo.Row row, NewChunk[] outputs) {
            for (int p = 0; p < this._yt.length; ++p) {
                double x = row.innerProduct(this._yt[p]);
                outputs[p].addNum(x);
            }
        }
    }
}

