/*
 * Decompiled with CFR 0.152.
 */
package hex.deepwater;

import hex.Model;
import hex.ModelMojoWriter;
import hex.deepwater.DeepWaterModel;
import hex.deepwater.DeepWaterModelInfo;
import hex.deepwater.DeepWaterModelOutput;
import hex.deepwater.DeepWaterParameters;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import water.H2O;

public class DeepwaterMojoWriter
extends ModelMojoWriter<DeepWaterModel, DeepWaterParameters, DeepWaterModelOutput> {
    private DeepWaterParameters _parms;
    private DeepWaterModelInfo _model_info;
    private DeepWaterModelOutput _output;

    public DeepwaterMojoWriter() {
    }

    public DeepwaterMojoWriter(DeepWaterModel model) {
        super((Model)model);
        this._parms = model.get_params();
        this._model_info = model.model_info();
        this._output = (DeepWaterModelOutput)model._output;
        if (this._model_info._unstable) {
            throw new UnsupportedOperationException(H2O.technote((int)4, (String)"Refusing to create a MOJO for an unstable model."));
        }
    }

    public String mojoVersion() {
        return "1.00";
    }

    protected void writeModelData() throws IOException {
        String meanImage;
        this.writekv("backend", (Object)this._parms._backend);
        this.writekv("problem_type", (Object)this._parms._problem_type);
        this.writekv("mini_batch_size", this._parms._mini_batch_size);
        this.writekv("height", this._model_info._height);
        this.writekv("width", this._model_info._width);
        this.writekv("channels", this._model_info._channels);
        this.writekv("nums", this._output._nums);
        this.writekv("cats", this._output._cats);
        this.writekv("cat_offsets", this._output._catOffsets);
        this.writekv("norm_mul", this._output._normMul);
        this.writekv("norm_sub", this._output._normSub);
        this.writekv("norm_resp_mul", this._output._normRespMul);
        this.writekv("norm_resp_sub", this._output._normRespSub);
        this.writekv("use_all_factor_levels", this._output._useAllFactorLevels);
        this.writekv("gpu", this._parms._gpu);
        this.writekv("device_id", this._parms._device_id);
        this.writeblob("model_network", this._model_info._network);
        this.writeblob("model_params", this._model_info._modelparams);
        if (this._parms._problem_type == DeepWaterParameters.ProblemType.image && (meanImage = this._parms._mean_image_file) != null && !meanImage.isEmpty()) {
            byte[] data = new byte[(int)new File(meanImage).length()];
            FileInputStream is = new FileInputStream(meanImage);
            is.read(data);
            is.close();
            this.writeblob("mean_image_file", data);
        }
    }
}

