/*
 * Decompiled with CFR 0.152.
 */
package hex.svd;

import hex.DataInfo;
import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.ModelMetricsUnsupervised;
import hex.svd.SVD;
import water.AutoBuffer;
import water.DKV;
import water.Futures;
import water.Job;
import water.Key;
import water.Keyed;
import water.MRTask;
import water.codegen.CodeGeneratorPipeline;
import water.exceptions.JCodeSB;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.util.JCodeGen;
import water.util.SBPrintStream;

public class SVDModel
extends Model<SVDModel, SVDParameters, SVDOutput> {
    public SVDModel(Key<SVDModel> selfKey, SVDParameters parms, SVDOutput output) {
        super(selfKey, (Model.Parameters)parms, (Model.Output)output);
    }

    protected Futures remove_impl(Futures fs) {
        if (null != ((SVDOutput)this._output)._u_key) {
            ((SVDOutput)this._output)._u_key.remove(fs);
        }
        if (null != ((SVDOutput)this._output)._v_key) {
            ((SVDOutput)this._output)._v_key.remove(fs);
        }
        return super.remove_impl(fs);
    }

    protected AutoBuffer writeAll_impl(AutoBuffer ab) {
        ab.putKey(((SVDOutput)this._output)._u_key);
        ab.putKey(((SVDOutput)this._output)._v_key);
        return super.writeAll_impl(ab);
    }

    protected Keyed readAll_impl(AutoBuffer ab, Futures fs) {
        ab.getKey(((SVDOutput)this._output)._u_key, fs);
        ab.getKey(((SVDOutput)this._output)._v_key, fs);
        return super.readAll_impl(ab, fs);
    }

    public ModelMetrics.MetricBuilder makeMetricBuilder(String[] domain) {
        return new ModelMetricsSVD.SVDModelMetrics(((SVDParameters)this._parms)._nv);
    }

    protected Frame predictScoreImpl(Frame orig, Frame adaptedFr, String destination_key, final Job j, boolean computeMetrics) {
        Frame adaptFrm = new Frame(adaptedFr);
        for (int i = 0; i < ((SVDParameters)this._parms)._nv; ++i) {
            adaptFrm.add("PC" + String.valueOf(i + 1), adaptFrm.anyVec().makeZero());
        }
        new MRTask(){

            public void map(Chunk[] chks) {
                if (this.isCancelled() || j != null && j.stop_requested()) {
                    return;
                }
                double[] tmp = new double[((SVDOutput)SVDModel.this._output)._names.length];
                double[] preds = new double[((SVDParameters)SVDModel.this._parms)._nv];
                for (int row = 0; row < chks[0]._len; ++row) {
                    double[] p = SVDModel.this.score0(chks, row, tmp, preds);
                    for (int c = 0; c < preds.length; ++c) {
                        chks[((SVDOutput)SVDModel.this._output)._names.length + c].set(row, p[c]);
                    }
                }
                if (j != null) {
                    j.update(1L);
                }
            }
        }.doAll(adaptFrm);
        int x = ((SVDOutput)this._output)._names.length;
        int y = adaptFrm.numCols();
        Frame f = adaptFrm.extractFrame(x, y);
        f = new Frame(Key.make((String)destination_key), f.names(), f.vecs());
        DKV.put((Keyed)f);
        this.makeMetricBuilder(null).makeModelMetrics((Model)this, orig, null, null);
        return f;
    }

    protected double[] score0(double[] data, double[] preds) {
        int numStart = ((SVDOutput)this._output)._catOffsets[((SVDOutput)this._output)._catOffsets.length - 1];
        assert (data.length == ((SVDOutput)this._output)._permutation.length);
        for (int i = 0; i < ((SVDParameters)this._parms)._nv; ++i) {
            preds[i] = 0.0;
            for (int j = 0; j < ((SVDOutput)this._output)._ncats; ++j) {
                int level;
                double tmp = data[((SVDOutput)this._output)._permutation[j]];
                int last_cat = ((SVDOutput)this._output)._catOffsets[j + 1] - ((SVDOutput)this._output)._catOffsets[j] - 1;
                int n = Double.isNaN(tmp) ? last_cat : (level = (int)tmp - (((SVDParameters)this._parms)._use_all_factor_levels ? 0 : 1));
                if (level < 0 || level > last_cat) continue;
                int n2 = i;
                preds[n2] = preds[n2] + ((SVDOutput)this._output)._v[((SVDOutput)this._output)._catOffsets[j] + level][i];
            }
            int dcol = ((SVDOutput)this._output)._ncats;
            int vcol = numStart;
            for (int j = 0; j < ((SVDOutput)this._output)._nnums; ++j) {
                int n = i;
                preds[n] = preds[n] + (data[((SVDOutput)this._output)._permutation[dcol]] - ((SVDOutput)this._output)._normSub[j]) * ((SVDOutput)this._output)._normMul[j] * ((SVDOutput)this._output)._v[vcol][i];
                ++dcol;
                ++vcol;
            }
        }
        return preds;
    }

    protected SBPrintStream toJavaInit(SBPrintStream sb, CodeGeneratorPipeline fileCtx) {
        sb = super.toJavaInit(sb, fileCtx);
        sb.ip("public boolean isSupervised() { return " + this.isSupervised() + "; }").nl();
        sb.ip("public int nfeatures() { return " + ((SVDOutput)this._output).nfeatures() + "; }").nl();
        sb.ip("public int nclasses() { return " + ((SVDParameters)this._parms)._nv + "; }").nl();
        if (((SVDOutput)this._output)._nnums > 0) {
            JCodeGen.toStaticVar((JCodeSB)sb, (String)"NORMMUL", (double[])((SVDOutput)this._output)._normMul, (String)"Standardization/Normalization scaling factor for numerical variables.");
            JCodeGen.toStaticVar((JCodeSB)sb, (String)"NORMSUB", (double[])((SVDOutput)this._output)._normSub, (String)"Standardization/Normalization offset for numerical variables.");
        }
        JCodeGen.toStaticVar((JCodeSB)sb, (String)"CATOFFS", (int[])((SVDOutput)this._output)._catOffsets, (String)"Categorical column offsets.");
        JCodeGen.toStaticVar((JCodeSB)sb, (String)"PERMUTE", (int[])((SVDOutput)this._output)._permutation, (String)"Permutation index vector.");
        JCodeGen.toStaticVar((JCodeSB)sb, (String)"EIGVECS", (double[][])((SVDOutput)this._output)._v, (String)"Eigenvector matrix.");
        return sb;
    }

    protected void toJavaPredictBody(SBPrintStream bodySb, CodeGeneratorPipeline classCtx, CodeGeneratorPipeline fileCtx, boolean verboseCode) {
        bodySb.i().p("java.util.Arrays.fill(preds,0);").nl();
        int cats = ((SVDOutput)this._output)._ncats;
        int nums = ((SVDOutput)this._output)._nnums;
        bodySb.i().p("final int nstart = CATOFFS[CATOFFS.length-1];").nl();
        bodySb.i().p("for(int i = 0; i < ").p(((SVDParameters)this._parms)._nv).p("; i++) {").nl();
        bodySb.i(1).p("for(int j = 0; j < ").p(cats).p("; j++) {").nl();
        bodySb.i(2).p("double d = data[PERMUTE[j]];").nl();
        bodySb.i(2).p("int last = CATOFFS[j+1]-CATOFFS[j]-1;").nl();
        bodySb.i(2).p("int c = Double.isNaN(d) ? last : (int)d").p(((SVDParameters)this._parms)._use_all_factor_levels ? ";" : "-1;").nl();
        bodySb.i(2).p("if(c < 0 || c > last) continue;").nl();
        bodySb.i(2).p("preds[i] += EIGVECS[CATOFFS[j]+c][i];").nl();
        bodySb.i(1).p("}").nl();
        bodySb.i(1).p("for(int j = 0; j < ").p(nums).p("; j++) {").nl();
        bodySb.i(2).p("preds[i] += (data[PERMUTE[j" + (cats > 0 ? "+" + cats : "") + "]]-NORMSUB[j])*NORMMUL[j]*EIGVECS[j" + (cats > 0 ? "+ nstart" : "") + "][i];").nl();
        bodySb.i(1).p("}").nl();
        bodySb.i().p("}").nl();
    }

    public static class ModelMetricsSVD
    extends ModelMetricsUnsupervised {
        public ModelMetricsSVD(Model model, Frame frame) {
            super(model, frame, 0L, Double.NaN);
        }

        public static class SVDModelMetrics
        extends ModelMetricsUnsupervised.MetricBuilderUnsupervised<SVDModelMetrics> {
            public SVDModelMetrics(int dims) {
                this._work = new double[dims];
            }

            public double[] perRow(double[] preds, float[] dataRow, Model m) {
                return preds;
            }

            public ModelMetrics makeModelMetrics(Model m, Frame f, Frame adaptedFrame, Frame preds) {
                return m.addModelMetrics((ModelMetrics)new ModelMetricsSVD(m, f));
            }
        }
    }

    public static class SVDOutput
    extends Model.Output {
        public int _iterations;
        public double[][] _v;
        public Key<Frame> _v_key;
        public double[] _d;
        public Key<Frame> _u_key;
        public int _ncats;
        public int _nnums;
        public long _nobs;
        public double _total_variance;
        public int[] _catOffsets;
        public double[] _normSub;
        public double[] _normMul;
        public int[] _permutation;
        public String[] _names_expanded;

        public SVDOutput(SVD b) {
            super((ModelBuilder)b);
        }

        public ModelCategory getModelCategory() {
            return ModelCategory.DimReduction;
        }
    }

    public static class SVDParameters
    extends Model.Parameters {
        public DataInfo.TransformType _transform = DataInfo.TransformType.NONE;
        public Method _svd_method = Method.GramSVD;
        public int _nv = 1;
        public int _max_iterations = 1000;
        public String _u_name;
        public String _v_name;
        public boolean _keep_u = true;
        public boolean _save_v_frame = true;
        public boolean _only_v = false;
        public boolean _use_all_factor_levels = true;
        public boolean _impute_missing = false;

        public String algoName() {
            return "SVD";
        }

        public String fullName() {
            return "Singular Value Decomposition";
        }

        public String javaName() {
            return SVDModel.class.getName();
        }

        public long progressUnits() {
            switch (this._svd_method) {
                case GramSVD: {
                    return 2L;
                }
                case Power: {
                    return 1 + this._nv;
                }
                case Randomized: {
                    return 5 + this._max_iterations;
                }
            }
            return this._nv;
        }

        public static enum Method {
            GramSVD,
            Power,
            Randomized;

        }
    }
}

