/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.genmodel.algos.tree.SharedTreeMojoModel;
import hex.tree.SharedTreeModel;
import hex.tree.TreeVisitor;
import java.util.Random;
import water.Key;
import water.Keyed;
import water.util.IcedBitSet;
import water.util.SB;

public class CompressedTree
extends Keyed<CompressedTree> {
    final byte[] _bits;
    final int _nclass;
    final long _seed;

    public CompressedTree(byte[] bits, int nclass, long seed, int tid, int cls) {
        super(CompressedTree.makeTreeKey(tid, cls));
        this._bits = bits;
        this._nclass = nclass;
        this._seed = seed;
    }

    public double score(double[] row) {
        return SharedTreeMojoModel.scoreTree((byte[])this._bits, (double[])row, (int)this._nclass, (boolean)false);
    }

    public String getDecisionPath(double[] row) {
        double d = SharedTreeMojoModel.scoreTree((byte[])this._bits, (double[])row, (int)this._nclass, (boolean)true);
        return SharedTreeMojoModel.getDecisionPath((double)d);
    }

    public Random rngForChunk(int cidx) {
        Random rand = new Random(this._seed);
        for (int i = 0; i < cidx; ++i) {
            rand.nextLong();
        }
        long seed = rand.nextLong();
        return new Random(seed);
    }

    public String toString(SharedTreeModel.SharedTreeOutput tm) {
        final String[] names = tm._names;
        final SB sb = new SB();
        new TreeVisitor<RuntimeException>(this){

            @Override
            protected void pre(int col, float fcmp, IcedBitSet gcmp, int equal, int naSplitDirInt) {
                if (naSplitDirInt == DhnasdNaVsRest) {
                    sb.p("!Double.isNaN(" + sb.i().p(names[col]).p(")"));
                } else if (naSplitDirInt == DhnasdNaLeft) {
                    sb.p("Double.isNaN(" + sb.i().p(names[col]).p(") || "));
                } else if (equal == 1) {
                    sb.p("!Double.isNaN(" + sb.i().p(names[col]).p(") && "));
                }
                if (naSplitDirInt != DhnasdNaVsRest) {
                    sb.i().p(names[col]).p(' ');
                    if (equal == 0) {
                        sb.p("< ").p(fcmp);
                    } else if (equal == 1) {
                        sb.p("!=").p(fcmp);
                    } else {
                        sb.p("in ").p(gcmp);
                    }
                }
                sb.ii(1).nl();
            }

            @Override
            protected void post(int col, float fcmp, int equal) {
                sb.di(1);
            }

            @Override
            protected void leaf(float pred) {
                sb.i().p("return ").p(pred).nl();
            }
        }.visit();
        return sb.toString();
    }

    public static Key<CompressedTree> makeTreeKey(int treeId, int clazz) {
        return Key.makeSystem((String)("tree_" + treeId + "_" + clazz + "_" + Key.rand()));
    }

    protected long checksum_impl() {
        throw new UnsupportedOperationException();
    }
}

