/*
 * Decompiled with CFR 0.152.
 */
package hex.glm;

import hex.DataInfo;
import hex.GLMMetrics;
import hex.Model;
import hex.ModelBuilder;
import hex.ModelMetrics;
import hex.ScoreKeeper;
import hex.api.MakeGLMModelHandler;
import hex.deeplearning.DeepLearningModel;
import hex.glm.GLM;
import hex.glm.GLMMetricBuilder;
import hex.glm.GLMMojoWriter;
import hex.glm.GLMScore;
import java.util.Arrays;
import java.util.HashMap;
import java.util.NoSuchElementException;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.distribution.TDistribution;
import water.H2O;
import water.Iced;
import water.Job;
import water.Key;
import water.MemoryManager;
import water.codegen.CodeGenerator;
import water.codegen.CodeGeneratorPipeline;
import water.exceptions.JCodeSB;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.ArrayUtils;
import water.util.JCodeGen;
import water.util.Log;
import water.util.MathUtils;
import water.util.SBPrintStream;
import water.util.TwoDimTable;

public class GLMModel
extends Model<GLMModel, GLMParameters, GLMOutput> {
    public final double _lambda_max;
    public final double[] _ymu;
    public final long _nullDOF;
    public final double _ySigma;
    public final long _nobs;
    private static String[] binomialClassNames = new String[]{"0", "1"};
    private static ThreadLocal<double[]> _eta = new ThreadLocal();

    public GLMModel(Key selfKey, GLMParameters parms, GLM job, double[] ymu, double ySigma, double lambda_max, long nobs) {
        super(selfKey, (Model.Parameters)parms, (Model.Output)(job == null ? new GLMOutput() : new GLMOutput(job)));
        this._ymu = ymu;
        this._ySigma = ySigma;
        this._lambda_max = lambda_max;
        this._nobs = nobs;
        this._nullDOF = nobs - (long)(parms._intercept ? 1 : 0);
    }

    public RegularizationPath getRegularizationPath() {
        RegularizationPath rp = new RegularizationPath();
        rp._coefficient_names = ((GLMOutput)this._output)._coefficient_names;
        int N = ((GLMOutput)this._output)._submodels.length;
        int P = ((GLMOutput)this._output)._dinfo.fullN() + 1;
        rp._lambdas = new double[N];
        rp._coefficients = new double[N][];
        rp._explained_deviance_train = new double[N];
        if (((GLMParameters)this._parms)._valid != null) {
            rp._explained_deviance_valid = new double[N];
        }
        if (((GLMParameters)this._parms)._standardize) {
            rp._coefficients_std = new double[N][];
        }
        for (int i = 0; i < N; ++i) {
            Submodel sm = ((GLMOutput)this._output)._submodels[i];
            rp._lambdas[i] = sm.lambda_value;
            rp._coefficients[i] = sm.getBeta(MemoryManager.malloc8d((int)P));
            if (((GLMParameters)this._parms)._standardize) {
                rp._coefficients_std[i] = rp._coefficients[i];
                rp._coefficients[i] = ((GLMOutput)this._output)._dinfo.denormalizeBeta(rp._coefficients_std[i]);
            }
            rp._explained_deviance_train[i] = 1.0 - (double)((GLMOutput)this._output)._training_metrics._nobs * sm.devianceTrain / ((GLMMetrics)((GLMOutput)this._output)._training_metrics).null_deviance();
            if (rp._explained_deviance_valid == null) continue;
            rp._explained_deviance_valid[i] = 1.0 - (double)((GLMOutput)this._output)._validation_metrics._nobs * sm.devianceTest / ((GLMMetrics)((GLMOutput)this._output)._validation_metrics).null_deviance();
        }
        return rp;
    }

    protected boolean toJavaCheckTooBig() {
        if (this.beta() != null && this.beta().length > 10000) {
            Log.warn((Object[])new Object[]{"toJavaCheckTooBig must be overridden for this model type to render it in the browser"});
            return true;
        }
        return false;
    }

    public DataInfo dinfo() {
        return ((GLMOutput)this._output)._dinfo;
    }

    private int rank(double[] ds) {
        int res = 0;
        for (double d : ds) {
            if (d == 0.0) continue;
            ++res;
        }
        return res;
    }

    public ModelMetrics.MetricBuilder makeMetricBuilder(String[] domain) {
        if (domain == null && ((GLMParameters)this._parms)._family == GLMParameters.Family.binomial) {
            domain = binomialClassNames;
        }
        return new GLMMetricBuilder(domain, this._ymu, new GLMWeightsFun((GLMParameters)this._parms), ((GLMOutput)this._output).bestSubmodel().rank(), true, ((GLMParameters)this._parms)._intercept);
    }

    protected double[] beta_internal() {
        if (((GLMParameters)this._parms)._family == GLMParameters.Family.multinomial) {
            return ArrayUtils.flat((double[][])((GLMOutput)this._output)._global_beta_multinomial);
        }
        return ((GLMOutput)this._output)._global_beta;
    }

    public double[] beta() {
        return ((GLMOutput)this._output)._global_beta;
    }

    public double[] beta(double lambda) {
        for (int i = 0; i < ((GLMOutput)this._output)._submodels.length; ++i) {
            if (((GLMOutput)this._output)._submodels[i].lambda_value != lambda) continue;
            return ((GLMOutput)this._output)._dinfo.denormalizeBeta(((GLMOutput)this._output)._submodels[i].getBeta(MemoryManager.malloc8d((int)(((GLMOutput)this._output)._dinfo.fullN() + 1))));
        }
        throw new RuntimeException("no such lambda value, lambda = " + lambda);
    }

    public double[] beta_std(double lambda) {
        for (int i = 0; i < ((GLMOutput)this._output)._submodels.length; ++i) {
            if (((GLMOutput)this._output)._submodels[i].lambda_value != lambda) continue;
            return ((GLMOutput)this._output)._submodels[i].getBeta(MemoryManager.malloc8d((int)(((GLMOutput)this._output)._dinfo.fullN() + 1)));
        }
        throw new RuntimeException("no such lambda value, lambda = " + lambda);
    }

    public String[] names() {
        return ((GLMOutput)this._output)._names;
    }

    public double deviance(double w, double y, double f) {
        if (w == 0.0) {
            return 0.0;
        }
        if (w == 1.0) {
            return ((GLMParameters)this._parms).deviance(y, f);
        }
        return Double.NaN;
    }

    public GLMModel addSubmodel(Submodel sm) {
        ((GLMOutput)this._output)._submodels = (Submodel[])ArrayUtils.append((Object[])((GLMOutput)this._output)._submodels, (Object[])new Submodel[]{sm});
        ((GLMOutput)this._output).setSubmodelIdx(((GLMOutput)this._output)._submodels.length - 1);
        return this;
    }

    public GLMModel updateSubmodel(Submodel sm) {
        assert (sm.lambda_value == ((GLMOutput)this._output)._submodels[((GLMOutput)this._output)._submodels.length - 1].lambda_value);
        ((GLMOutput)this._output)._submodels[((GLMOutput)this._output)._submodels.length - 1] = sm;
        return this;
    }

    public void update(double[] beta, double devianceTrain, double devianceTest, int iter) {
        int id = ((GLMOutput)this._output)._submodels.length - 1;
        ((GLMOutput)this._output)._submodels[id] = new Submodel(((GLMOutput)this._output)._submodels[id].lambda_value, beta, iter, devianceTrain, devianceTest);
        ((GLMOutput)this._output).setSubmodelIdx(id);
    }

    public GLMModel clone2() {
        GLMModel res = (GLMModel)this.clone();
        res._output = (GLMOutput)((GLMOutput)res._output).clone();
        return res;
    }

    protected String[][] scoringDomains() {
        String[][] domains = ((GLMOutput)this._output)._domains;
        if (((GLMParameters)this._parms)._family == GLMParameters.Family.binomial && ((GLMOutput)this._output)._domains[((GLMOutput)this._output)._dinfo.responseChunkId(0)] == null) {
            domains = (String[][])domains.clone();
            domains[((GLMOutput)this._output)._dinfo.responseChunkId((int)0)] = binomialClassNames;
        }
        return domains;
    }

    public void setZValues(double[] zValues, double dispersion, boolean dispersionEstimated) {
        GLMOutput.access$002((GLMOutput)this._output, zValues);
        ((GLMOutput)this._output)._dispersion = dispersion;
        ((GLMOutput)this._output)._dispersionEstimated = dispersionEstimated;
    }

    public HashMap<String, Double> coefficients() {
        HashMap<String, Double> res = new HashMap<String, Double>();
        double[] b = this.beta();
        if (b != null) {
            for (int i = 0; i < b.length; ++i) {
                res.put(((GLMOutput)this._output)._coefficient_names[i], b[i]);
            }
        }
        return res;
    }

    public TwoDimTable generateSummary(Key train, int iter) {
        int intercept;
        String[] names = new String[]{"Family", "Link", "Regularization", "Number of Predictors Total", "Number of Active Predictors", "Number of Iterations", "Training Frame"};
        String[] types = new String[]{"string", "string", "string", "int", "int", "int", "string"};
        String[] formats = new String[]{"%s", "%s", "%s", "%d", "%d", "%d", "%s"};
        if (((GLMParameters)this._parms)._lambda_search) {
            names = new String[]{"Family", "Link", "Regularization", "Lambda Search", "Number of Predictors Total", "Number of Active Predictors", "Number of Iterations", "Training Frame"};
            types = new String[]{"string", "string", "string", "string", "int", "int", "int", "string"};
            formats = new String[]{"%s", "%s", "%s", "%s", "%d", "%d", "%d", "%s"};
        }
        ((GLMOutput)this._output)._model_summary = new TwoDimTable("GLM Model", "summary", new String[]{""}, names, types, formats, "");
        ((GLMOutput)this._output)._model_summary.set(0, 0, (Object)((GLMParameters)this._parms)._family.toString());
        ((GLMOutput)this._output)._model_summary.set(0, 1, (Object)((GLMParameters)this._parms)._link.toString());
        String regularization = "None";
        if (((GLMParameters)this._parms)._lambda != null && (((GLMParameters)this._parms)._lambda.length != 1 || ((GLMParameters)this._parms)._lambda[0] != 0.0)) {
            regularization = ((GLMParameters)this._parms)._alpha[0] == 0.0 ? "Ridge ( lambda = " : (((GLMParameters)this._parms)._alpha[0] == 1.0 ? "Lasso (lambda = " : "Elastic Net (alpha = " + MathUtils.roundToNDigits((double)((GLMParameters)this._parms)._alpha[0], (int)4) + ", lambda = ");
            regularization = regularization + MathUtils.roundToNDigits((double)((GLMParameters)this._parms)._lambda[((GLMOutput)this._output)._selected_lambda_idx], (int)4) + " )";
        }
        ((GLMOutput)this._output)._model_summary.set(0, 2, (Object)regularization);
        int lambdaSearch = 0;
        if (((GLMParameters)this._parms)._lambda_search) {
            lambdaSearch = 1;
            ((GLMOutput)this._output)._model_summary.set(0, 3, (Object)("nlambda = " + ((GLMParameters)this._parms)._nlambdas + ", lambda.max = " + MathUtils.roundToNDigits((double)this._lambda_max, (int)4) + ", lambda.min = " + MathUtils.roundToNDigits((double)((GLMOutput)this._output).lambda_best(), (int)4) + ", lambda.1se = " + MathUtils.roundToNDigits((double)((GLMOutput)this._output).lambda_1se(), (int)4)));
        }
        int n = intercept = ((GLMParameters)this._parms)._intercept ? 1 : 0;
        if (((GLMOutput)this._output).nclasses() > 2) {
            ((GLMOutput)this._output)._model_summary.set(0, 3 + lambdaSearch, (Object)(((GLMOutput)this._output).nclasses() * ((GLMOutput)this._output)._coefficient_names.length));
            ((GLMOutput)this._output)._model_summary.set(0, 4 + lambdaSearch, (Object)Integer.toString(((GLMOutput)this._output).rank() - ((GLMOutput)this._output).nclasses() * intercept));
        } else {
            ((GLMOutput)this._output)._model_summary.set(0, 3 + lambdaSearch, (Object)(this.beta().length - 1));
            ((GLMOutput)this._output)._model_summary.set(0, 4 + lambdaSearch, (Object)Integer.toString(((GLMOutput)this._output).rank() - intercept));
        }
        ((GLMOutput)this._output)._model_summary.set(0, 5 + lambdaSearch, (Object)iter);
        ((GLMOutput)this._output)._model_summary.set(0, 6 + lambdaSearch, (Object)train.toString());
        return ((GLMOutput)this._output)._model_summary;
    }

    public long checksum_impl() {
        if (((GLMParameters)this._parms)._train == null) {
            return 0L;
        }
        return super.checksum_impl();
    }

    public double[] scoreRow(DataInfo.Row r, double o, double[] preds) {
        if (((GLMParameters)this._parms)._family == GLMParameters.Family.multinomial) {
            int c;
            double[] eta = _eta.get();
            if (eta == null || eta.length != ((GLMOutput)this._output).nclasses()) {
                eta = MemoryManager.malloc8d((int)((GLMOutput)this._output).nclasses());
                _eta.set(eta);
            }
            double[][] bm = ((GLMOutput)this._output)._global_beta_multinomial;
            double sumExp = 0.0;
            double maxRow = 0.0;
            for (c = 0; c < bm.length; ++c) {
                eta[c] = r.innerProduct(bm[c]) + o;
                if (!(eta[c] > maxRow)) continue;
                maxRow = eta[c];
            }
            for (c = 0; c < bm.length; ++c) {
                eta[c] = Math.exp(eta[c] - maxRow);
                sumExp += eta[c];
            }
            sumExp = 1.0 / sumExp;
            for (c = 0; c < bm.length; ++c) {
                preds[c + 1] = eta[c] * sumExp;
            }
            preds[0] = ArrayUtils.maxIndex((double[])eta);
        } else {
            double mu = ((GLMParameters)this._parms).linkInv(r.innerProduct(this.beta()) + o);
            if (((GLMParameters)this._parms)._family == GLMParameters.Family.binomial) {
                preds[0] = mu >= this.defaultThreshold() ? 1.0 : 0.0;
                preds[1] = 1.0 - mu;
                preds[2] = mu;
            } else {
                preds[0] = mu;
            }
        }
        return preds;
    }

    protected double[] score0(double[] data, double[] preds) {
        return this.score0(data, preds, 1.0, 0.0);
    }

    protected double[] score0(double[] data, double[] preds, double w, double o) {
        if (((GLMParameters)this._parms)._family == GLMParameters.Family.multinomial) {
            int c;
            if (o != 0.0) {
                throw H2O.unimpl((String)"Offset is not implemented for multinomial.");
            }
            double[] eta = _eta.get();
            if (eta == null || eta.length < ((GLMOutput)this._output).nclasses()) {
                eta = MemoryManager.malloc8d((int)((GLMOutput)this._output).nclasses());
                _eta.set(eta);
            }
            double[][] bm = ((GLMOutput)this._output)._global_beta_multinomial;
            double sumExp = 0.0;
            double maxRow = 0.0;
            for (c = 0; c < bm.length; ++c) {
                double e = bm[c][bm[c].length - 1];
                double[] b = bm[c];
                for (int i = 0; i < ((GLMOutput)this._output)._dinfo._cats; ++i) {
                    e += b[((GLMOutput)this._output)._dinfo.getCategoricalId(i, data[i])];
                }
                int coff = ((GLMOutput)this._output)._dinfo._cats;
                int boff = ((GLMOutput)this._output)._dinfo.numStart();
                for (int i = 0; i < ((GLMOutput)this._output)._dinfo._nums; ++i) {
                    double d = data[coff + i];
                    if (!((GLMOutput)this._output)._dinfo._skipMissing && Double.isNaN(d)) {
                        d = ((GLMOutput)this._output)._dinfo._numMeans[i];
                    }
                    e += d * b[boff + i];
                }
                if (e > maxRow) {
                    maxRow = e;
                }
                eta[c] = e;
            }
            for (c = 0; c < bm.length; ++c) {
                eta[c] = Math.exp(eta[c] - maxRow);
                sumExp += eta[c];
            }
            sumExp = 1.0 / sumExp;
            for (c = 0; c < bm.length; ++c) {
                preds[c + 1] = eta[c] * sumExp;
            }
            preds[0] = ArrayUtils.maxIndex((double[])eta);
        } else {
            double[] b = this.beta();
            double eta = b[b.length - 1] + o;
            for (int i = 0; i < ((GLMOutput)this._output)._dinfo._cats && !Double.isNaN(eta); ++i) {
                int l = ((GLMOutput)this._output)._dinfo.getCategoricalId(i, data[i]);
                if (l < 0) continue;
                eta += b[l];
            }
            int numStart = ((GLMOutput)this._output)._dinfo.numStart();
            int ncats = ((GLMOutput)this._output)._dinfo._cats;
            for (int i = 0; i < ((GLMOutput)this._output)._dinfo._nums && !Double.isNaN(eta); ++i) {
                double d = data[ncats + i];
                if (!((GLMOutput)this._output)._dinfo._skipMissing && Double.isNaN(d)) {
                    d = ((GLMOutput)this._output)._dinfo._numMeans[i];
                }
                eta += b[numStart + i] * d;
            }
            double mu = ((GLMParameters)this._parms).linkInv(eta);
            if (((GLMParameters)this._parms)._family == GLMParameters.Family.binomial) {
                preds[0] = mu >= this.defaultThreshold() ? 1.0 : 0.0;
                preds[1] = 1.0 - mu;
                preds[2] = mu;
            } else {
                preds[0] = mu;
            }
        }
        return preds;
    }

    protected void toJavaPredictBody(SBPrintStream body, CodeGeneratorPipeline classCtx, CodeGeneratorPipeline fileCtx, boolean verboseCode) {
        classCtx.add((Object)new CodeGenerator(){

            public void generate(JCodeSB out) {
                JCodeGen.toClassWithArray((JCodeSB)out, (String)"public static", (String)"BETA", (double[])GLMModel.this.beta_internal());
                JCodeGen.toClassWithArray((JCodeSB)out, (String)"static", (String)"NUM_MEANS", (double[])((GLMOutput)GLMModel.this._output)._dinfo._numMeans, (String)"Imputed numeric values");
                JCodeGen.toClassWithArray((JCodeSB)out, (String)"static", (String)"CAT_MODES", (int[])((GLMOutput)GLMModel.this._output)._dinfo.catNAFill(), (String)"Imputed categorical values.");
                JCodeGen.toStaticVar((JCodeSB)out, (String)"CATOFFS", (int[])GLMModel.this.dinfo()._catOffsets, (String)"Categorical Offsets");
            }
        });
        body.ip("final double [] b = BETA.VALUES;").nl();
        if (((GLMParameters)this._parms)._missing_values_handling == DeepLearningModel.DeepLearningParameters.MissingValuesHandling.MeanImputation) {
            body.ip("for(int i = 0; i < " + ((GLMOutput)this._output)._dinfo._cats + "; ++i) if(Double.isNaN(data[i])) data[i] = CAT_MODES.VALUES[i];").nl();
            body.ip("for(int i = 0; i < " + ((GLMOutput)this._output)._dinfo._nums + "; ++i) if(Double.isNaN(data[i + " + ((GLMOutput)this._output)._dinfo._cats + "])) data[i+" + ((GLMOutput)this._output)._dinfo._cats + "] = NUM_MEANS.VALUES[i];").nl();
        }
        if (((GLMParameters)this._parms)._family != GLMParameters.Family.multinomial) {
            body.ip("double eta = 0.0;").nl();
            if (!((GLMParameters)this._parms)._use_all_factor_levels) {
                body.ip("for(int i = 0; i < CATOFFS.length-1; ++i) if(data[i] != 0) {").nl();
                body.ip("  int ival = (int)data[i] - 1;").nl();
                body.ip("  if(ival != data[i] - 1) throw new IllegalArgumentException(\"categorical value out of range\");").nl();
                body.ip("  ival += CATOFFS[i];").nl();
                body.ip("  if(ival < CATOFFS[i + 1])").nl();
                body.ip("    eta += b[ival];").nl();
            } else {
                body.ip("for(int i = 0; i < CATOFFS.length-1; ++i) {").nl();
                body.ip("  int ival = (int)data[i];").nl();
                body.ip("  if(ival != data[i]) throw new IllegalArgumentException(\"categorical value out of range\");").nl();
                body.ip("  ival += CATOFFS[i];").nl();
                body.ip("  if(ival < CATOFFS[i + 1])").nl();
                body.ip("    eta += b[ival];").nl();
            }
            body.ip("}").nl();
            int noff = this.dinfo().numStart() - this.dinfo()._cats;
            body.ip("for(int i = ").p(this.dinfo()._cats).p("; i < b.length-1-").p(noff).p("; ++i)").nl();
            body.ip("eta += b[").p(noff).p("+i]*data[i];").nl();
            body.ip("eta += b[b.length-1]; // reduce intercept").nl();
            if (((GLMParameters)this._parms)._family != GLMParameters.Family.tweedie) {
                body.ip("double mu = hex.genmodel.GenModel.GLM_").p(((GLMParameters)this._parms)._link.toString()).p("Inv(eta");
            } else {
                body.ip("double mu = hex.genmodel.GenModel.GLM_tweedieInv(eta," + ((GLMParameters)this._parms)._tweedie_link_power);
            }
            body.p(");").nl();
            if (((GLMParameters)this._parms)._family == GLMParameters.Family.binomial) {
                body.ip("preds[0] = (mu >= ").p(this.defaultThreshold()).p(") ? 1 : 0").p("; // threshold given by ROC").nl();
                body.ip("preds[1] = 1.0 - mu; // class 0").nl();
                body.ip("preds[2] =       mu; // class 1").nl();
            } else {
                body.ip("preds[0] = mu;").nl();
            }
        } else {
            int P = ((GLMOutput)this._output)._global_beta_multinomial[0].length;
            body.ip("preds[0] = 0;").nl();
            body.ip("for(int c = 0; c < " + ((GLMOutput)this._output)._nclasses + "; ++c){").nl();
            body.ip("  preds[c+1] = 0;").nl();
            if (this.dinfo()._cats > 0) {
                if (!((GLMParameters)this._parms)._use_all_factor_levels) {
                    body.ip("  for(int i = 0; i < CATOFFS.length-1; ++i) if(data[i] != 0) {").nl();
                    body.ip("    int ival = (int)data[i] - 1;").nl();
                    body.ip("    if(ival != data[i] - 1) throw new IllegalArgumentException(\"categorical value out of range\");").nl();
                    body.ip("    ival += CATOFFS[i];").nl();
                    body.ip("    if(ival < CATOFFS[i + 1])").nl();
                    body.ip("      preds[c+1] += b[ival+c*" + P + "];").nl();
                } else {
                    body.ip("  for(int i = 0; i < CATOFFS.length-1; ++i) {").nl();
                    body.ip("    int ival = (int)data[i];").nl();
                    body.ip("    if(ival != data[i]) throw new IllegalArgumentException(\"categorical value out of range\");").nl();
                    body.ip("    ival += CATOFFS[i];").nl();
                    body.ip("    if(ival < CATOFFS[i + 1])").nl();
                    body.ip("      preds[c+1] += b[ival+c*" + P + "];").nl();
                }
                body.ip("  }").nl();
            }
            int noff = this.dinfo().numStart();
            body.ip("  for(int i = 0; i < " + this.dinfo()._nums + "; ++i)").nl();
            body.ip("    preds[c+1] += b[" + noff + "+i + c*" + P + "]*data[i];").nl();
            body.ip("  preds[c+1] += b[" + (P - 1) + " + c*" + P + "]; // reduce intercept").nl();
            body.ip("}").nl();
            body.ip("double max_row = 0;").nl();
            body.ip("for(int c = 1; c < preds.length; ++c) if(preds[c] > max_row) max_row = preds[c];").nl();
            body.ip("double sum_exp = 0;").nl();
            body.ip("for(int c = 1; c < preds.length; ++c) { sum_exp += (preds[c] = Math.exp(preds[c]-max_row));}").nl();
            body.ip("sum_exp = 1/sum_exp;").nl();
            body.ip("double max_p = 0;").nl();
            body.ip("for(int c = 1; c < preds.length; ++c) if((preds[c] *= sum_exp) > max_p){ max_p = preds[c]; preds[0] = c-1;};").nl();
        }
    }

    protected SBPrintStream toJavaInit(SBPrintStream sb, CodeGeneratorPipeline fileCtx) {
        sb.nl();
        sb.ip("public boolean isSupervised() { return true; }").nl();
        sb.ip("public int nfeatures() { return " + ((GLMOutput)this._output).nfeatures() + "; }").nl();
        sb.ip("public int nclasses() { return " + ((GLMOutput)this._output).nclasses() + "; }").nl();
        return sb;
    }

    private GLMScore makeScoringTask(Frame adaptFrm, boolean generatePredictions, Job j) {
        boolean computeMetrics;
        boolean bl = computeMetrics = adaptFrm.vec(((GLMOutput)this._output).responseName()) != null && !adaptFrm.vec(((GLMOutput)this._output).responseName()).isBad();
        String[] domain = ((GLMOutput)this._output).nclasses() <= 1 ? null : (!computeMetrics ? ((GLMOutput)this._output)._domains[((GLMOutput)this._output)._domains.length - 1] : adaptFrm.lastVec().domain());
        return new GLMScore(j, this, ((GLMOutput)this._output)._dinfo.scoringInfo(((GLMOutput)this._output)._names, adaptFrm), domain, computeMetrics, generatePredictions);
    }

    protected Frame predictScoreImpl(Frame fr, Frame adaptFrm, String destination_key, Job j, boolean computeMetrics) {
        String[] names = this.makeScoringNames();
        String[][] domains = new String[names.length][];
        GLMScore gs = (GLMScore)this.makeScoringTask(adaptFrm, true, j).doAll(names.length, (byte)3, adaptFrm);
        if (gs._computeMetrics) {
            gs._mb.makeModelMetrics((Model)this, fr, adaptFrm, gs.outputFrame());
        }
        domains[0] = gs._domain;
        return gs.outputFrame(Key.make((String)destination_key), names, domains);
    }

    protected ModelMetrics.MetricBuilder scoreMetrics(Frame adaptFrm) {
        return ((GLMScore)this.makeScoringTask((Frame)adaptFrm, (boolean)false, null).doAll((Frame)adaptFrm))._mb;
    }

    public GLMMojoWriter getMojo() {
        return new GLMMojoWriter(this);
    }

    static /* synthetic */ String[] access$302(String[] x0) {
        binomialClassNames = x0;
        return x0;
    }

    public static class GLMOutput
    extends Model.Output {
        Submodel[] _submodels = new Submodel[0];
        DataInfo _dinfo;
        String[] _coefficient_names;
        public int _best_lambda_idx;
        public int _lambda_1se = -1;
        public int _selected_lambda_idx;
        double[] _global_beta;
        private double[] _zvalues;
        private double _dispersion;
        private boolean _dispersionEstimated;
        double[][] _global_beta_multinomial;
        final int _nclasses;
        public boolean _binomial;
        public boolean _multinomial;

        public double lambda_best() {
            return this._submodels.length == 0 ? -1.0 : this._submodels[this._best_lambda_idx].lambda_value;
        }

        public double lambda_1se() {
            return this._lambda_1se == -1 || this._lambda_1se >= this._submodels.length ? -1.0 : (this._submodels.length == 0 ? -1.0 : this._submodels[this._lambda_1se].lambda_value);
        }

        public double lambda_selected() {
            return this._submodels[this._selected_lambda_idx].lambda_value;
        }

        public boolean hasPValues() {
            return this._zvalues != null;
        }

        public double[] stdErr() {
            double[] res = (double[])this._zvalues.clone();
            for (int i = 0; i < res.length; ++i) {
                res[i] = this._global_beta[i] / this._zvalues[i];
            }
            return res;
        }

        protected long checksum_impl() {
            long d = this._global_beta == null ? 1L : (long)Arrays.hashCode(this._global_beta);
            return d * super.checksum_impl();
        }

        public double[] zValues() {
            return (double[])this._zvalues.clone();
        }

        public double[] pValues() {
            double[] res = this.zValues();
            TDistribution rd = this._dispersionEstimated ? new TDistribution((double)this._training_metrics.residual_degrees_of_freedom()) : new NormalDistribution();
            for (int i = 0; i < res.length; ++i) {
                res[i] = 2.0 * rd.cumulativeProbability(-Math.abs(res[i]));
            }
            return res;
        }

        public int rank() {
            return this._submodels[this._selected_lambda_idx].rank();
        }

        public boolean isStandardized() {
            return this._dinfo._predictor_transform == DataInfo.TransformType.STANDARDIZE;
        }

        public String[] coefficientNames() {
            return this._coefficient_names;
        }

        public boolean isSupervised() {
            return true;
        }

        public String[] interactions() {
            return this._dinfo._interactionColumns;
        }

        public static Frame expand(Frame fr, String[] interactions, boolean useAll, boolean standardize, boolean skipMissing) {
            return MakeGLMModelHandler.oneHot(fr, interactions, useAll, standardize, false, skipMissing);
        }

        public GLMOutput(DataInfo dinfo, String[] column_names, String[][] domains, String[] coefficient_names, boolean binomial) {
            super(dinfo._weights, dinfo._offset, dinfo._fold);
            this._dinfo = (DataInfo)dinfo.clone();
            this._names = column_names;
            this._domains = domains;
            this._coefficient_names = coefficient_names;
            this._binomial = binomial;
            int n = this._nclasses = binomial ? 2 : 1;
            if (this._binomial && domains[domains.length - 1] != null) {
                assert (domains[domains.length - 1].length == 2) : "Unexpected domains " + Arrays.toString((Object[])domains);
                GLMModel.access$302(domains[domains.length - 1]);
            }
        }

        public GLMOutput(DataInfo dinfo, String[] column_names, String[][] domains, String[] coefficient_names, boolean binomial, double[] beta) {
            this(dinfo, column_names, domains, coefficient_names, binomial);
            assert (!ArrayUtils.hasNaNsOrInfs((double[])beta));
            this._global_beta = beta;
            this._submodels = new Submodel[]{new Submodel(0.0, beta, -1, Double.NaN, Double.NaN)};
        }

        public GLMOutput() {
            this._isSupervised = true;
            this._nclasses = -1;
        }

        public GLMOutput(GLM glm) {
            super((ModelBuilder)glm);
            int id;
            this._dinfo = (DataInfo)glm._dinfo.clone();
            this._dinfo._adaptedFrame = null;
            String[] cnames = glm._dinfo.coefNames();
            Object[] names = glm._dinfo._adaptedFrame._names;
            String[][] domains = glm._dinfo._adaptedFrame.domains();
            int n = id = glm._generatedWeights == null ? -1 : ArrayUtils.find((Object[])names, (Object)glm._generatedWeights);
            if (id >= 0) {
                this._dinfo._weights = false;
                String[] ns = new String[names.length - 1];
                String[][] ds = new String[domains.length - 1][];
                System.arraycopy(names, 0, ns, 0, id);
                System.arraycopy(domains, 0, ds, 0, id);
                System.arraycopy(names, id + 1, ns, id, ns.length - id);
                System.arraycopy(domains, id + 1, ds, id, ds.length - id);
                names = ns;
                domains = ds;
            }
            this._names = names;
            this._domains = domains;
            this._coefficient_names = Arrays.copyOf(cnames, cnames.length + 1);
            this._coefficient_names[this._coefficient_names.length - 1] = "Intercept";
            this._binomial = ((GLMParameters)glm._parms)._family == GLMParameters.Family.binomial;
            this._nclasses = glm.nclasses();
            this._multinomial = this._nclasses > 2;
        }

        public int nclasses() {
            return this._nclasses;
        }

        public String[] classNames() {
            String[] res = super.classNames();
            if (res == null && this._binomial) {
                return binomialClassNames;
            }
            return res;
        }

        public Submodel pickBestModel() {
            int bestId = 0;
            Submodel best = this._submodels[0];
            for (int i = 1; i < this._submodels.length; ++i) {
                Submodel sm = this._submodels[i];
                if (sm.devianceTest > best.devianceTest || !(sm.devianceTrain < best.devianceTrain)) continue;
                bestId = i;
                best = sm;
            }
            this._best_lambda_idx = bestId;
            this.setSubmodelIdx(this._best_lambda_idx);
            return best;
        }

        public double[] getNormBeta() {
            return this._submodels[this._selected_lambda_idx].getBeta(MemoryManager.malloc8d((int)(this._dinfo.fullN() + 1)));
        }

        public double[][] getNormBetaMultinomial() {
            return this.getNormBetaMultinomial(this._selected_lambda_idx);
        }

        public double[][] getNormBetaMultinomial(int idx) {
            if (this._submodels == null || this._submodels.length == 0) {
                return null;
            }
            double[][] res = new double[this.nclasses()][];
            Submodel sm = this._submodels[idx];
            int N = this._dinfo.fullN() + 1;
            double[] beta = sm.beta;
            if (sm.idxs != null) {
                beta = ArrayUtils.expandAndScatter((double[])beta, (int)(this.nclasses() * (this._dinfo.fullN() + 1)), (int[])sm.idxs);
            }
            for (int i = 0; i < res.length; ++i) {
                res[i] = Arrays.copyOfRange(beta, i * N, (i + 1) * N);
            }
            return res;
        }

        public double[][] get_global_beta_multinomial() {
            return this._global_beta_multinomial;
        }

        public void setSubmodelIdx(int l) {
            this._selected_lambda_idx = l;
            if (this._multinomial) {
                this._global_beta_multinomial = this.getNormBetaMultinomial(l);
                for (int i = 0; i < this._global_beta_multinomial.length; ++i) {
                    this._global_beta_multinomial[i] = this._dinfo.denormalizeBeta(this._global_beta_multinomial[i]);
                }
            } else {
                if (this._global_beta == null) {
                    this._global_beta = MemoryManager.malloc8d((int)this._coefficient_names.length);
                } else {
                    Arrays.fill(this._global_beta, 0.0);
                }
                this._submodels[l].getBeta(this._global_beta);
                this._global_beta = this._dinfo.denormalizeBeta(this._global_beta);
            }
        }

        public double[] beta() {
            return this._global_beta;
        }

        public Submodel bestSubmodel() {
            return this._submodels[this._best_lambda_idx];
        }

        public void setSubmodel(double lambdaCVEstimate) {
            for (int i = 0; i < this._submodels.length; ++i) {
                if (this._submodels[i] == null || this._submodels[i].lambda_value != lambdaCVEstimate) continue;
                this.setSubmodelIdx(i);
                return;
            }
            throw new NoSuchElementException("has no model for lambda = " + lambdaCVEstimate);
        }

        public Submodel getSubmodel(double lambdaCVEstimate) {
            for (int i = 0; i < this._submodels.length; ++i) {
                if (this._submodels[i] == null || this._submodels[i].lambda_value != lambdaCVEstimate) continue;
                return this._submodels[i];
            }
            return null;
        }

        static /* synthetic */ double[] access$002(GLMOutput x0, double[] x1) {
            x0._zvalues = x1;
            return x1;
        }
    }

    public static class Submodel
    extends Iced {
        public final double lambda_value;
        public final int iteration;
        public final double devianceTrain;
        public final double devianceTest;
        public final int[] idxs;
        public final double[] beta;

        public double[] getBeta(double[] beta) {
            if (this.idxs != null) {
                for (int i = 0; i < this.idxs.length; ++i) {
                    beta[this.idxs[i]] = this.beta[i];
                }
            } else {
                System.arraycopy(this.beta, 0, beta, 0, beta.length);
            }
            return beta;
        }

        public int rank() {
            return this.idxs != null ? this.idxs.length : ArrayUtils.countNonzeros((double[])this.beta);
        }

        public Submodel(double lambda, double[] beta, int iteration, double devTrain, double devTest) {
            this.lambda_value = lambda;
            this.iteration = iteration;
            this.devianceTrain = devTrain;
            this.devianceTest = devTest;
            int r = 0;
            if (beta != null) {
                for (int i = 0; i < beta.length; ++i) {
                    if (beta[i] == 0.0) continue;
                    ++r;
                }
                if (r < beta.length) {
                    this.idxs = MemoryManager.malloc4((int)r);
                    int j = 0;
                    for (int i = 0; i < beta.length; ++i) {
                        if (beta[i] == 0.0) continue;
                        this.idxs[j++] = i;
                    }
                    this.beta = ArrayUtils.select((double[])beta, (int[])this.idxs);
                } else {
                    this.beta = (double[])beta.clone();
                    this.idxs = null;
                }
            } else {
                this.beta = null;
                this.idxs = null;
            }
        }
    }

    public static class GLMWeightsFun
    extends Iced {
        final GLMParameters.Family _family;
        final GLMParameters.Link _link;
        final double _var_power;
        final double _link_power;

        public GLMWeightsFun(GLMParameters parms) {
            this(parms._family, parms._link, parms._tweedie_variance_power, parms._tweedie_link_power);
        }

        public GLMWeightsFun(GLMParameters.Family fam, GLMParameters.Link link, double var_power, double link_power) {
            this._family = fam;
            this._link = link;
            this._var_power = var_power;
            this._link_power = link_power;
        }

        public final double link(double x) {
            switch (this._link) {
                case identity: {
                    return x;
                }
                case logit: {
                    assert (0.0 <= x && x <= 1.0) : "x out of bounds, expected <0,1> range, got " + x;
                    return Math.log(x / (1.0 - x));
                }
                case log: 
                case multinomial: {
                    return Math.log(x);
                }
                case inverse: {
                    double xx = x < 0.0 ? Math.min(-1.0E-5, x) : Math.max(1.0E-5, x);
                    return 1.0 / xx;
                }
                case tweedie: {
                    return this._link_power == 0.0 ? Math.log(x) : Math.pow(x, this._link_power);
                }
            }
            throw new RuntimeException("unknown link function " + (Object)((Object)this));
        }

        public final double linkDeriv(double x) {
            switch (this._link) {
                case logit: {
                    double div = x * (1.0 - x);
                    if (div < 1.0E-6) {
                        return 1000000.0;
                    }
                    return 1.0 / div;
                }
                case identity: {
                    return 1.0;
                }
                case log: {
                    return 1.0 / x;
                }
                case inverse: {
                    return -1.0 / (x * x);
                }
                case tweedie: {
                    return this._link_power == 0.0 ? 1.0 / Math.max(2.0E-16, x) : this._link_power * Math.pow(x, this._link_power - 1.0);
                }
            }
            throw H2O.unimpl();
        }

        public final double linkInv(double x) {
            switch (this._link) {
                case identity: {
                    return x;
                }
                case logit: {
                    return 1.0 / (Math.exp(-x) + 1.0);
                }
                case log: {
                    return Math.exp(x);
                }
                case inverse: {
                    double xx = x < 0.0 ? Math.min(-1.0E-5, x) : Math.max(1.0E-5, x);
                    return 1.0 / xx;
                }
                case tweedie: {
                    return this._link_power == 0.0 ? Math.max(2.0E-16, Math.exp(x)) : Math.pow(x, 1.0 / this._link_power);
                }
            }
            throw new RuntimeException("unexpected link function id  " + (Object)((Object)this._link));
        }

        public final double variance(double mu) {
            switch (this._family) {
                case gaussian: {
                    return 1.0;
                }
                case binomial: 
                case quasibinomial: {
                    double res = mu * (1.0 - mu);
                    return res < 1.0E-6 ? 1.0E-6 : res;
                }
                case poisson: {
                    return mu;
                }
                case gamma: {
                    return mu * mu;
                }
                case tweedie: {
                    return Math.pow(mu, this._var_power);
                }
            }
            throw new RuntimeException("unknown family Id " + (Object)((Object)this._family));
        }

        public final double deviance(double yr, double ym) {
            double y1 = yr == 0.0 ? 0.1 : yr;
            switch (this._family) {
                case gaussian: {
                    return (yr - ym) * (yr - ym);
                }
                case quasibinomial: {
                    if (yr == ym) {
                        return 0.0;
                    }
                    if (ym > 1.0) {
                        return -2.0 * (yr * Math.log(ym));
                    }
                    double res = -2.0 * (yr * Math.log(ym) + (1.0 - yr) * Math.log(1.0 - ym));
                    return res;
                }
                case binomial: {
                    return 2.0 * (MathUtils.y_log_y((double)yr, (double)ym) + MathUtils.y_log_y((double)(1.0 - yr), (double)(1.0 - ym)));
                }
                case poisson: {
                    if (yr == 0.0) {
                        return 2.0 * ym;
                    }
                    return 2.0 * (yr * Math.log(yr / ym) - (yr - ym));
                }
                case gamma: {
                    if (yr == 0.0) {
                        return -2.0;
                    }
                    return -2.0 * (Math.log(yr / ym) - (yr - ym) / ym);
                }
                case tweedie: {
                    double theta = this._var_power == 1.0 ? Math.log(y1 / ym) : (Math.pow(y1, 1.0 - this._var_power) - Math.pow(ym, 1.0 - this._var_power)) / (1.0 - this._var_power);
                    double kappa = this._var_power == 2.0 ? Math.log(y1 / ym) : (Math.pow(yr, 2.0 - this._var_power) - Math.pow(ym, 2.0 - this._var_power)) / (2.0 - this._var_power);
                    return 2.0 * (yr * theta - kappa);
                }
            }
            throw new RuntimeException("unknown family " + (Object)((Object)this._family));
        }

        public final double deviance(float yr, float ym) {
            return this.deviance((double)yr, (double)ym);
        }

        public final void likelihoodAndDeviance(double yr, GLMWeights x, double w) {
            double ym = x.mu;
            switch (this._family) {
                case gaussian: {
                    x.dev = w * (yr - ym) * (yr - ym);
                    x.l = 0.5 * x.dev;
                    break;
                }
                case quasibinomial: {
                    x.l = yr == ym ? 0.0 : (ym > 1.0 ? -(yr * Math.log(ym)) : -(yr * Math.log(ym) + (1.0 - yr) * Math.log(1.0 - ym)));
                    x.dev = 2.0 * x.l;
                    break;
                }
                case binomial: {
                    x.l = ym == yr ? 0.0 : w * (MathUtils.y_log_y((double)yr, (double)ym) + MathUtils.y_log_y((double)(1.0 - yr), (double)(1.0 - ym)));
                    x.dev = 2.0 * x.l;
                    break;
                }
                case poisson: 
                case gamma: 
                case tweedie: {
                    x.l = x.dev = w * this.deviance(yr, ym);
                    break;
                }
                default: {
                    throw new RuntimeException("unknown family " + (Object)((Object)this._family));
                }
            }
        }

        public final double likelihood(double yr, double ym) {
            switch (this._family) {
                case gaussian: {
                    return 0.5 * (yr - ym) * (yr - ym);
                }
                case binomial: 
                case quasibinomial: {
                    if (yr == ym) {
                        return 0.0;
                    }
                    return 0.5 * this.deviance(yr, ym);
                }
                case poisson: {
                    if (yr == 0.0) {
                        return 2.0 * ym;
                    }
                    return 2.0 * (yr * Math.log(yr / ym) - (yr - ym));
                }
                case gamma: {
                    if (yr == 0.0) {
                        return -2.0;
                    }
                    return -2.0 * (Math.log(yr / ym) - (yr - ym) / ym);
                }
                case tweedie: {
                    return this.deviance(yr, ym);
                }
            }
            throw new RuntimeException("unknown family " + (Object)((Object)this._family));
        }

        public GLMWeights computeWeights(double y, double eta, double off, double w, GLMWeights x) {
            double etaOff = eta + off;
            x.mu = this.linkInv(etaOff);
            double var = this.variance(x.mu);
            double d = this.linkDeriv(x.mu);
            x.w = w / (var * d * d);
            x.z = eta + (y - x.mu) * d;
            this.likelihoodAndDeviance(y, x, w);
            return x;
        }
    }

    public static class GLMWeights {
        public double mu = 0.0;
        public double w = 1.0;
        public double z = 0.0;
        public double l = 0.0;
        public double dev = Double.NaN;
    }

    public static class GLMParameters
    extends Model.Parameters {
        public boolean _standardize = true;
        public Family _family;
        public Link _link = Link.family_default;
        public Solver _solver = Solver.AUTO;
        public double _tweedie_variance_power;
        public double _tweedie_link_power;
        public double[] _alpha = null;
        public double[] _lambda = null;
        public DeepLearningModel.DeepLearningParameters.MissingValuesHandling _missing_values_handling = DeepLearningModel.DeepLearningParameters.MissingValuesHandling.MeanImputation;
        public double _prior = -1.0;
        public boolean _lambda_search = false;
        public int _nlambdas = -1;
        public boolean _non_negative = false;
        public boolean _exactLambdas = false;
        public double _lambda_min_ratio = -1.0;
        public boolean _use_all_factor_levels = false;
        public int _max_iterations = -1;
        public boolean _intercept = true;
        public double _beta_epsilon = 1.0E-4;
        public double _objective_epsilon = -1.0;
        public double _gradient_epsilon = -1.0;
        public double _obj_reg = -1.0;
        public boolean _compute_p_values = false;
        public boolean _remove_collinear_columns = false;
        public String[] _interactions = null;
        public boolean _early_stopping = true;
        public Key<Frame> _beta_constraints = null;
        public int _max_active_predictors = -1;
        public boolean _stdOverride;

        public String algoName() {
            return "GLM";
        }

        public String fullName() {
            return "Generalized Linear Modeling";
        }

        public String javaName() {
            return GLMModel.class.getName();
        }

        public long progressUnits() {
            return 1000000L;
        }

        public void validate(GLM glm) {
            if (this._alpha != null && (1.0 < this._alpha[0] || this._alpha[0] < 0.0)) {
                glm.error("_alpha", "alpha parameter must from (inclusive) [0,1] range");
            }
            if (this._compute_p_values && this._solver != Solver.AUTO && this._solver != Solver.IRLSM) {
                glm.error("_compute_p_values", "P values can only be computed with IRLSM solver, go solver = " + (Object)((Object)this._solver));
            }
            if (this._compute_p_values && (this._lambda == null || this._lambda[0] > 0.0)) {
                glm.error("_compute_p_values", "P values can only be computed with NO REGULARIZATION (lambda = 0)");
            }
            if (this._compute_p_values && this._family == Family.multinomial) {
                glm.error("_compute_p_values", "P values are currently not supported for family=multinomial");
            }
            if (this._compute_p_values && this._non_negative) {
                glm.error("_compute_p_values", "P values are currently not supported for family=multinomial");
            }
            if (this._weights_column != null && this._offset_column != null && this._weights_column.equals(this._offset_column)) {
                glm.error("_offset_column", "Offset must be different from weights");
            }
            if (this._alpha != null && (this._alpha[0] < 0.0 || this._alpha[0] > 1.0)) {
                glm.error("_alpha", "Alpha value must be between 0 and 1");
            }
            if (this._lambda != null && this._lambda[0] < 0.0) {
                glm.error("_lambda", "Lambda value must be >= 0");
            }
            if (this._obj_reg != -1.0 && this._obj_reg <= 0.0) {
                glm.error("obj_reg", "Must be positive or -1 for default");
            }
            if (this._prior != -1.0 && this._prior <= 0.0 || this._prior >= 1.0) {
                glm.error("_prior", "Prior must be in (exclusive) range (0,1)");
            }
            if (this._prior != -1.0 && this._family != Family.binomial) {
                glm.error("_prior", "Prior is only allowed with family = binomial.");
            }
            if (this._family != Family.tweedie) {
                glm.hide("_tweedie_variance_power", "Only applicable with Tweedie family");
                glm.hide("_tweedie_link_power", "Only applicable with Tweedie family");
            }
            if (this._remove_collinear_columns && !this._intercept) {
                glm.error("_intercept", "Remove colinear columns option is currently not supported without intercept");
            }
            if (this._beta_constraints != null) {
                Vec v;
                Frame f;
                if (this._family == Family.multinomial) {
                    glm.error("beta_constraints", "beta constraints are not supported for family = multionomial");
                }
                if ((f = (Frame)this._beta_constraints.get()) == null) {
                    glm.error("beta_constraints", "Missing frame for beta constraints");
                }
                if ((v = f.vec("names")) == null) {
                    glm.error("beta_constraints", "Beta constraints parameter must have names column with valid coefficient names");
                }
                if ((v = f.vec("upper_bounds")) != null && !v.isNumeric()) {
                    glm.error("beta_constraints", "upper_bounds must be numeric if present");
                }
                v = f.vec("upper_bounds");
                v = f.vec("lower_bounds");
                if (v != null && !v.isNumeric()) {
                    glm.error("beta_constraints", "lower_bounds must be numeric if present");
                }
                if ((v = f.vec("beta_given")) != null && !v.isNumeric()) {
                    glm.error("beta_constraints", "beta_given must be numeric if present");
                }
                v = f.vec("upper_bounds");
                v = f.vec("beta_start");
                if (v != null && !v.isNumeric()) {
                    glm.error("beta_constraints", "beta_start must be numeric if present");
                }
            }
            if (!this._lambda_search) {
                glm.hide("_lambda_min_ratio", "only applies if lambda search is on.");
                glm.hide("_nlambdas", "only applies if lambda search is on.");
                glm.hide("_early_stopping", "only applies if lambda search is on.");
            }
            if (this._link != Link.family_default) {
                switch (this._family) {
                    case gaussian: {
                        if (this._link == Link.identity || this._link == Link.log || this._link == Link.inverse) break;
                        throw new IllegalArgumentException("Incompatible link function for selected family. Only identity, log and inverse links are allowed for family=gaussian.");
                    }
                    case binomial: {
                        if (this._link == Link.logit) break;
                        throw new IllegalArgumentException("Incompatible link function for selected family. Only logit is allowed for family=binomial. Got " + (Object)((Object)this._link));
                    }
                    case poisson: {
                        if (this._link == Link.log || this._link == Link.identity) break;
                        throw new IllegalArgumentException("Incompatible link function for selected family. Only log and identity links are allowed for family=poisson.");
                    }
                    case gamma: {
                        if (this._link == Link.inverse || this._link == Link.log || this._link == Link.identity) break;
                        throw new IllegalArgumentException("Incompatible link function for selected family. Only inverse, log and identity links are allowed for family=gamma.");
                    }
                    case tweedie: {
                        if (this._link == Link.tweedie) break;
                        throw new IllegalArgumentException("Incompatible link function for selected family. Only tweedie link allowed for family=tweedie.");
                    }
                    case multinomial: {
                        if (this._link == Link.multinomial) break;
                        throw new IllegalArgumentException("Incompatible link function for selected family. Only multinomial link allowed for family=multinomial.");
                    }
                    default: {
                        H2O.fail();
                    }
                }
            }
        }

        public GLMParameters() {
            this(Family.gaussian, Link.family_default);
            assert (this._link == Link.family_default);
            this._stopping_rounds = 3;
            this._stopping_metric = ScoreKeeper.StoppingMetric.deviance;
            this._stopping_tolerance = 1.0E-4;
        }

        public GLMParameters(Family f) {
            this(f, f.defaultLink);
        }

        public GLMParameters(Family f, Link l) {
            this(f, l, null, null, 0.0, 1.0);
        }

        public GLMParameters(Family f, Link l, double[] lambda, double[] alpha, double twVar, double twLnk) {
            this(f, l, lambda, alpha, twVar, twLnk, null);
        }

        public GLMParameters(Family f, Link l, double[] lambda, double[] alpha, double twVar, double twLnk, String[] interactions) {
            this._lambda = lambda;
            this._alpha = alpha;
            this._tweedie_variance_power = twVar;
            this._tweedie_link_power = twLnk;
            this._interactions = interactions;
            this._family = f;
            this._link = l;
        }

        public final double variance(double mu) {
            switch (this._family) {
                case gaussian: {
                    return 1.0;
                }
                case binomial: 
                case multinomial: 
                case quasibinomial: {
                    return mu * (1.0 - mu);
                }
                case poisson: {
                    return mu;
                }
                case gamma: {
                    return mu * mu;
                }
                case tweedie: {
                    return Math.pow(mu, this._tweedie_variance_power);
                }
            }
            throw new RuntimeException("unknown family Id " + (Object)((Object)this._family));
        }

        public final boolean canonical() {
            switch (this._family) {
                case gaussian: {
                    return this._link == Link.identity;
                }
                case binomial: {
                    return this._link == Link.logit;
                }
                case poisson: {
                    return this._link == Link.log;
                }
                case gamma: {
                    return this._link == Link.inverse;
                }
            }
            throw H2O.unimpl();
        }

        public final double deviance(double yr, double ym) {
            double y1 = yr == 0.0 ? 0.1 : yr;
            switch (this._family) {
                case gaussian: {
                    return (yr - ym) * (yr - ym);
                }
                case binomial: 
                case quasibinomial: {
                    return 2.0 * (GLMParameters.y_log_y(yr, ym) + GLMParameters.y_log_y(1.0 - yr, 1.0 - ym));
                }
                case poisson: {
                    if (yr == 0.0) {
                        return 2.0 * ym;
                    }
                    return 2.0 * (yr * Math.log(yr / ym) - (yr - ym));
                }
                case gamma: {
                    if (yr == 0.0) {
                        return -2.0;
                    }
                    return -2.0 * (Math.log(yr / ym) - (yr - ym) / ym);
                }
                case tweedie: {
                    double theta = this._tweedie_variance_power == 1.0 ? Math.log(y1 / ym) : (Math.pow(y1, 1.0 - this._tweedie_variance_power) - Math.pow(ym, 1.0 - this._tweedie_variance_power)) / (1.0 - this._tweedie_variance_power);
                    double kappa = this._tweedie_variance_power == 2.0 ? Math.log(y1 / ym) : (Math.pow(yr, 2.0 - this._tweedie_variance_power) - Math.pow(ym, 2.0 - this._tweedie_variance_power)) / (2.0 - this._tweedie_variance_power);
                    return 2.0 * (yr * theta - kappa);
                }
            }
            throw new RuntimeException("unknown family " + (Object)((Object)this._family));
        }

        public final double deviance(float yr, float ym) {
            return this.deviance((double)yr, (double)ym);
        }

        public final double likelihood(double yr, double ym) {
            return 0.5 * this.deviance(yr, ym);
        }

        public final double linkDeriv(double x) {
            switch (this._link) {
                case logit: {
                    double div = x * (1.0 - x);
                    if (div < 1.0E-6) {
                        return 1000000.0;
                    }
                    return 1.0 / div;
                }
                case identity: {
                    return 1.0;
                }
                case log: {
                    return 1.0 / x;
                }
                case inverse: {
                    return -1.0 / (x * x);
                }
                case tweedie: {
                    return this._tweedie_link_power == 0.0 ? 1.0 / Math.max(2.0E-16, x) : this._tweedie_link_power * Math.pow(x, this._tweedie_link_power - 1.0);
                }
            }
            throw H2O.unimpl();
        }

        public final double linkInv(double x) {
            switch (this._link) {
                case identity: {
                    return x;
                }
                case logit: {
                    return 1.0 / (Math.exp(-x) + 1.0);
                }
                case log: {
                    return Math.exp(x);
                }
                case inverse: {
                    double xx = x < 0.0 ? Math.min(-1.0E-5, x) : Math.max(1.0E-5, x);
                    return 1.0 / xx;
                }
                case tweedie: {
                    return this._tweedie_link_power == 0.0 ? Math.max(2.0E-16, Math.exp(x)) : Math.pow(x, 1.0 / this._tweedie_link_power);
                }
            }
            throw new RuntimeException("unexpected link function id  " + (Object)((Object)this));
        }

        public final double linkInvDeriv(double x) {
            switch (this._link) {
                case identity: {
                    return 1.0;
                }
                case logit: {
                    double g = Math.exp(-x);
                    double gg = (g + 1.0) * (g + 1.0);
                    return g / gg;
                }
                case log: {
                    return Math.max(Math.exp(x), Double.MIN_NORMAL);
                }
                case inverse: {
                    double xx = x < 0.0 ? Math.min(-1.0E-5, x) : Math.max(1.0E-5, x);
                    return -1.0 / (xx * xx);
                }
            }
            throw new RuntimeException("unexpected link function id  " + (Object)((Object)this));
        }

        static final double y_log_y(double y, double mu) {
            if (y == 0.0) {
                return 0.0;
            }
            if (mu < Double.MIN_NORMAL) {
                mu = Double.MIN_NORMAL;
            }
            return y * Math.log(y / mu);
        }

        public static enum Solver {
            AUTO,
            IRLSM,
            L_BFGS,
            COORDINATE_DESCENT_NAIVE,
            COORDINATE_DESCENT;

        }

        public static enum Link {
            family_default,
            identity,
            logit,
            log,
            inverse,
            tweedie,
            multinomial;

        }

        public static enum Family {
            gaussian(Link.identity),
            binomial(Link.logit),
            quasibinomial(Link.logit),
            poisson(Link.log),
            gamma(Link.inverse),
            multinomial(Link.multinomial),
            tweedie(Link.tweedie);

            public final Link defaultLink;

            private Family(Link link) {
                this.defaultLink = link;
            }
        }
    }

    public static class RegularizationPath
    extends Iced {
        public double[] _lambdas;
        public double[] _explained_deviance_train;
        public double[] _explained_deviance_valid;
        public double[][] _coefficients;
        public double[][] _coefficients_std;
        public String[] _coefficient_names;
    }
}

