/*
 * Decompiled with CFR 0.152.
 */
package hex.glm;

import hex.DataInfo;
import hex.Model;
import hex.ModelMetrics;
import hex.glm.GLMModel;
import java.util.Arrays;
import water.Job;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.util.FrameUtils;

public class GLMScore
extends MRTask<GLMScore> {
    final GLMModel _m;
    final Job _j;
    ModelMetrics.MetricBuilder _mb;
    final DataInfo _dinfo;
    final boolean _sparse;
    final String[] _domain;
    final boolean _computeMetrics;
    final boolean _generatePredictions;

    public GLMScore(Job j, GLMModel m, DataInfo dinfo, String[] domain, boolean computeMetrics, boolean generatePredictions) {
        this._j = j;
        this._m = m;
        this._dinfo = dinfo;
        this._computeMetrics = computeMetrics;
        this._sparse = FrameUtils.sparseRatio((Frame)dinfo._adaptedFrame) < 0.5;
        this._domain = domain;
        this._generatePredictions = generatePredictions;
    }

    private void processRow(DataInfo.Row r, float[] res, double[] ps, NewChunk[] preds, int ncols) {
        if (this._dinfo._responses != 0) {
            res[0] = (float)r.response[0];
        }
        if (r.predictors_bad) {
            Arrays.fill(ps, Double.NaN);
        } else if (r.weight == 0.0) {
            Arrays.fill(ps, 0.0);
        } else {
            this._m.scoreRow(r, r.offset, ps);
            if (this._computeMetrics && !r.response_bad) {
                this._mb.perRow(ps, res, r.weight, r.offset, (Model)this._m);
            }
        }
        if (this._generatePredictions) {
            for (int c = 0; c < ncols; ++c) {
                preds[c].addNum(ps[c]);
            }
        }
    }

    public void map(Chunk[] chks, NewChunk[] preds) {
        int ncols;
        double[] ps;
        if (this.isCancelled() || this._j != null && this._j.stop_requested()) {
            return;
        }
        if (this._computeMetrics) {
            this._mb = this._m.makeMetricBuilder(this._domain);
            ps = this._mb._work;
        } else {
            ps = new double[((GLMModel.GLMOutput)this._m._output)._nclasses + 1];
        }
        float[] res = new float[1];
        int nc = ((GLMModel.GLMOutput)this._m._output).nclasses();
        int n = ncols = nc == 1 ? 1 : nc + 1;
        if (this._sparse) {
            for (DataInfo.Row r : this._dinfo.extractSparseRows(chks)) {
                this.processRow(r, res, ps, preds, ncols);
            }
        } else {
            DataInfo.Row r = this._dinfo.newDenseRow();
            for (int rid = 0; rid < chks[0]._len; ++rid) {
                this._dinfo.extractDenseRow(chks, rid, r);
                this.processRow(r, res, ps, preds, ncols);
            }
        }
        if (this._j != null) {
            this._j.update(1L);
        }
    }

    public void reduce(GLMScore bs) {
        if (this._mb != null) {
            this._mb.reduce(bs._mb);
        }
    }

    protected void postGlobal() {
        if (this._mb != null) {
            this._mb.postGlobal();
        }
    }
}

