/*
 * Decompiled with CFR 0.152.
 */
package hex.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import water.util.PrettyPrint;
import water.util.TwoDimTable;

public class DimensionReductionUtils {
    public static void generateIPC(double[] std_deviation, double totVar, double[] vars, double[] prop_var, double[] cum_var) {
        int arrayLen = std_deviation.length;
        if (totVar > 0.0) {
            for (int i = 0; i < arrayLen; ++i) {
                vars[i] = std_deviation[i] * std_deviation[i];
                prop_var[i] = vars[i] / totVar;
                cum_var[i] = i == 0 ? prop_var[0] : cum_var[i - 1] + prop_var[i];
            }
        }
    }

    public static TwoDimTable createScoringHistoryTableDR(LinkedHashMap<String, ArrayList> scoreTable, String tableName, long startTime) {
        ArrayList<String> colHeaders = new ArrayList<String>();
        ArrayList<String> colTypes = new ArrayList<String>();
        ArrayList<String> colFormat = new ArrayList<String>();
        ArrayList<String> otherTableEntries = new ArrayList<String>();
        for (String fieldName : scoreTable.keySet()) {
            if (fieldName.equals("Timestamp")) {
                colHeaders.add("Timestamp");
                colTypes.add("string");
                colFormat.add("%s");
                colHeaders.add("Duration");
                colTypes.add("string");
                colFormat.add("%s");
                colHeaders.add("Iteration");
                colTypes.add("long");
                colFormat.add("%d");
                continue;
            }
            otherTableEntries.add(fieldName);
            colHeaders.add(fieldName);
            colTypes.add("double");
            colFormat.add("%.5f");
        }
        int rows = scoreTable.get("Timestamp").size();
        TwoDimTable table = new TwoDimTable(tableName, null, new String[rows], colHeaders.toArray(new String[0]), colTypes.toArray(new String[0]), colFormat.toArray(new String[0]), "");
        assert (rows <= table.getRowDim());
        for (int row = 0; row < rows; ++row) {
            int col = 0;
            DateTimeFormatter fmt = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
            table.set(row, col++, (Object)fmt.print(((Long)scoreTable.get("Timestamp").get(row)).longValue()));
            table.set(row, col++, (Object)PrettyPrint.msecs((long)((Long)scoreTable.get("Timestamp").get(row) - startTime), (boolean)true));
            table.set(row, col++, (Object)row);
            for (int remaining_cols = 0; remaining_cols < otherTableEntries.size(); ++remaining_cols) {
                table.set(row, col++, (Object)((Double)scoreTable.get(otherTableEntries.get(remaining_cols)).get(row)));
            }
        }
        return table;
    }
}

