/*
 * Decompiled with CFR 0.152.
 */
package hex.pca;

import Jama.Matrix;
import Jama.SingularValueDecomposition;
import hex.DataInfo;
import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.genmodel.algos.glrm.GlrmInitialization;
import hex.genmodel.algos.glrm.GlrmLoss;
import hex.genmodel.algos.glrm.GlrmRegularizer;
import hex.glrm.GLRM;
import hex.glrm.GLRMModel;
import hex.gram.Gram;
import hex.pca.PCAModel;
import hex.svd.SVD;
import hex.svd.SVDModel;
import hex.util.DimensionReductionUtils;
import hex.util.LinearAlgebraUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import water.DKV;
import water.H2O;
import water.HeartBeat;
import water.Iced;
import water.Job;
import water.Key;
import water.fvec.Frame;
import water.rapids.Rapids;
import water.util.ArrayUtils;
import water.util.PrettyPrint;
import water.util.TwoDimTable;

public class PCA
extends ModelBuilder<PCAModel, PCAModel.PCAParameters, PCAModel.PCAOutput> {
    private transient int _ncolExp;
    boolean _wideDataset = false;

    protected PCADriver trainModelImpl() {
        return new PCADriver();
    }

    public ModelCategory[] can_build() {
        return new ModelCategory[]{ModelCategory.Clustering};
    }

    public boolean isSupervised() {
        return false;
    }

    public boolean havePojo() {
        return true;
    }

    public boolean haveMojo() {
        return false;
    }

    protected void checkMemoryFootPrint() {
        HeartBeat hb = H2O.SELF._heartbeat;
        double p = LinearAlgebraUtils.numColsExp(this._train, true);
        double r = this._train.numRows();
        boolean useGramSVD = ((PCAModel.PCAParameters)this._parms)._pca_method == PCAModel.PCAParameters.Method.GramSVD;
        boolean usePower = ((PCAModel.PCAParameters)this._parms)._pca_method == PCAModel.PCAParameters.Method.Power;
        long mem_usage = useGramSVD || usePower ? (long)((double)hb._cpus_allowed * p * p * 8.0 * Math.log(this._train.lastVec().nChunks()) / Math.log(2.0)) : 1L;
        long mem_usage_w = useGramSVD || usePower ? (long)((double)hb._cpus_allowed * r * r * 8.0 * Math.log(this._train.lastVec().nChunks()) / Math.log(2.0)) : 1L;
        long max_mem = hb.get_free_mem();
        if (mem_usage > max_mem && mem_usage_w > max_mem) {
            String msg = "Gram matrices (one per thread) won't fit in the driver node's memory (" + PrettyPrint.bytes((long)mem_usage) + " > " + PrettyPrint.bytes((long)max_mem) + ") - try reducing the number of columns and/or the number of categorical factors.";
            this.error("_train", msg);
        }
        if (mem_usage > mem_usage_w) {
            this._wideDataset = true;
        }
    }

    public void setWideDataset(boolean isWide) {
        this._wideDataset = isWide;
    }

    public PCA(PCAModel.PCAParameters parms) {
        super((Model.Parameters)parms);
        this.init(false);
    }

    public PCA(boolean startup_once) {
        super((Model.Parameters)new PCAModel.PCAParameters(), startup_once);
    }

    public void init(boolean expensive) {
        super.init(expensive);
        if (((PCAModel.PCAParameters)this._parms)._max_iterations < 1 || (double)((PCAModel.PCAParameters)this._parms)._max_iterations > 1000000.0) {
            this.error("_max_iterations", "max_iterations must be between 1 and 1e6 inclusive");
        }
        if (this._train == null) {
            return;
        }
        this._ncolExp = LinearAlgebraUtils.numColsExp(this._train, ((PCAModel.PCAParameters)this._parms)._use_all_factor_levels);
        int k_min = (int)Math.min((long)this._ncolExp, this._train.numRows());
        if (((PCAModel.PCAParameters)this._parms)._k < 1 || ((PCAModel.PCAParameters)this._parms)._k > k_min) {
            this.error("_k", "_k must be between 1 and " + k_min);
        }
        if (!((PCAModel.PCAParameters)this._parms)._use_all_factor_levels && ((PCAModel.PCAParameters)this._parms)._pca_method == PCAModel.PCAParameters.Method.GLRM) {
            this.error("_use_all_factor_levels", "GLRM only implemented for _use_all_factor_levels = true");
        }
        if (((PCAModel.PCAParameters)this._parms)._pca_method != PCAModel.PCAParameters.Method.GLRM && expensive && this.error_count() == 0 && (!this._train.hasNAs() || ((PCAModel.PCAParameters)this._parms)._impute_missing)) {
            this.checkMemoryFootPrint();
        }
    }

    class PCADriver
    extends ModelBuilder.Driver {
        PCADriver() {
            super((ModelBuilder)PCA.this);
        }

        protected void buildTables(PCAModel pca, String[] rowNames) {
            Object[] colTypes = new String[((PCAModel.PCAParameters)PCA.this._parms)._k];
            Object[] colFormats = new String[((PCAModel.PCAParameters)PCA.this._parms)._k];
            String[] colHeaders = new String[((PCAModel.PCAParameters)PCA.this._parms)._k];
            Arrays.fill(colTypes, "double");
            Arrays.fill(colFormats, "%5f");
            assert (rowNames.length == ((PCAModel.PCAOutput)pca._output)._eigenvectors_raw.length);
            for (int i = 0; i < colHeaders.length; ++i) {
                colHeaders[i] = "PC" + String.valueOf(i + 1);
            }
            ((PCAModel.PCAOutput)pca._output)._eigenvectors = new TwoDimTable("Rotation", null, rowNames, colHeaders, (String[])colTypes, (String[])colFormats, "", (String[][])new String[((PCAModel.PCAOutput)pca._output)._eigenvectors_raw.length][], ((PCAModel.PCAOutput)pca._output)._eigenvectors_raw);
            double[] vars = new double[((PCAModel.PCAOutput)pca._output)._std_deviation.length];
            double[] prop_var = new double[((PCAModel.PCAOutput)pca._output)._std_deviation.length];
            double[] cum_var = new double[((PCAModel.PCAOutput)pca._output)._std_deviation.length];
            DimensionReductionUtils.generateIPC(((PCAModel.PCAOutput)pca._output)._std_deviation, ((PCAModel.PCAOutput)pca._output)._total_variance, vars, prop_var, cum_var);
            ((PCAModel.PCAOutput)pca._output)._model_summary = ((PCAModel.PCAOutput)pca._output)._importance = new TwoDimTable("Importance of components", null, new String[]{"Standard deviation", "Proportion of Variance", "Cumulative Proportion"}, colHeaders, (String[])colTypes, (String[])colFormats, "", (String[][])new String[3][], (double[][])new double[][]{((PCAModel.PCAOutput)pca._output)._std_deviation, prop_var, cum_var});
        }

        protected void computeStatsFillModel(PCAModel pca, SVDModel svd, Gram gram) {
            ((PCAModel.PCAOutput)pca._output)._normSub = ((SVDModel.SVDOutput)svd._output)._normSub;
            ((PCAModel.PCAOutput)pca._output)._normMul = ((SVDModel.SVDOutput)svd._output)._normMul;
            ((PCAModel.PCAOutput)pca._output)._permutation = ((SVDModel.SVDOutput)svd._output)._permutation;
            ((PCAModel.PCAOutput)pca._output)._nnums = ((SVDModel.SVDOutput)svd._output)._nnums;
            ((PCAModel.PCAOutput)pca._output)._ncats = ((SVDModel.SVDOutput)svd._output)._ncats;
            ((PCAModel.PCAOutput)pca._output)._catOffsets = ((SVDModel.SVDOutput)svd._output)._catOffsets;
            ((PCAModel.PCAOutput)pca._output)._nobs = ((SVDModel.SVDOutput)svd._output)._nobs;
            ((PCAModel.PCAOutput)pca._output)._std_deviation = ArrayUtils.mult((double[])((SVDModel.SVDOutput)svd._output)._d, (double)(1.0 / Math.sqrt((double)((SVDModel.SVDOutput)svd._output)._nobs - 1.0)));
            ((PCAModel.PCAOutput)pca._output)._eigenvectors_raw = ((SVDModel.SVDOutput)svd._output)._v;
            ((PCAModel.PCAOutput)pca._output)._total_variance = gram.diagSum() * (double)((PCAModel.PCAOutput)pca._output)._nobs / ((double)((PCAModel.PCAOutput)pca._output)._nobs - 1.0);
            this.buildTables(pca, ((SVDModel.SVDOutput)svd._output)._names_expanded);
        }

        protected void computeStatsFillModel(PCAModel pca, GLRMModel glrm, Gram gram) {
            assert (((GLRMModel.GLRMParameters)glrm._parms)._recover_svd);
            ((PCAModel.PCAOutput)pca._output)._normSub = ((GLRMModel.GLRMOutput)glrm._output)._normSub;
            ((PCAModel.PCAOutput)pca._output)._normMul = ((GLRMModel.GLRMOutput)glrm._output)._normMul;
            ((PCAModel.PCAOutput)pca._output)._permutation = ((GLRMModel.GLRMOutput)glrm._output)._permutation;
            ((PCAModel.PCAOutput)pca._output)._nnums = ((GLRMModel.GLRMOutput)glrm._output)._nnums;
            ((PCAModel.PCAOutput)pca._output)._ncats = ((GLRMModel.GLRMOutput)glrm._output)._ncats;
            ((PCAModel.PCAOutput)pca._output)._catOffsets = ((GLRMModel.GLRMOutput)glrm._output)._catOffsets;
            ((PCAModel.PCAOutput)pca._output)._objective = ((GLRMModel.GLRMOutput)glrm._output)._objective;
            double dfcorr = 1.0 / Math.sqrt((double)PCA.this._train.numRows() - 1.0);
            ((PCAModel.PCAOutput)pca._output)._std_deviation = new double[((PCAModel.PCAParameters)PCA.this._parms)._k];
            ((PCAModel.PCAOutput)pca._output)._eigenvectors_raw = ((GLRMModel.GLRMOutput)glrm._output)._eigenvectors_raw;
            ((PCAModel.PCAOutput)pca._output)._nobs = PCA.this._train.numRows();
            if (gram._diagN == 0) {
                for (int i = 0; i < ((GLRMModel.GLRMOutput)glrm._output)._singular_vals.length; ++i) {
                    ((PCAModel.PCAOutput)pca._output)._std_deviation[i] = dfcorr * ((GLRMModel.GLRMOutput)glrm._output)._singular_vals[i];
                }
                ((PCAModel.PCAOutput)pca._output)._total_variance = gram.diagSum() * (double)((PCAModel.PCAOutput)pca._output)._nobs / ((double)((PCAModel.PCAOutput)pca._output)._nobs - 1.0);
            } else {
                ((PCAModel.PCAOutput)pca._output)._std_deviation = ((GLRMModel.GLRMOutput)glrm._output)._std_deviation;
                ((PCAModel.PCAOutput)pca._output)._total_variance = ((GLRMModel.GLRMOutput)glrm._output)._total_variance;
            }
            this.buildTables(pca, ((GLRMModel.GLRMOutput)glrm._output)._names_expanded);
        }

        protected void computeStatsFillModel(PCAModel pca, DataInfo dinfo, double[] sval, double[][] eigvec, Gram gram, long nobs) {
            int i;
            double[] dArray = ((PCAModel.PCAOutput)pca._output)._normSub = dinfo._normSub == null ? new double[dinfo._nums] : dinfo._normSub;
            if (dinfo._normMul == null) {
                ((PCAModel.PCAOutput)pca._output)._normMul = new double[dinfo._nums];
                Arrays.fill(((PCAModel.PCAOutput)pca._output)._normMul, 1.0);
            } else {
                ((PCAModel.PCAOutput)pca._output)._normMul = dinfo._normMul;
            }
            ((PCAModel.PCAOutput)pca._output)._permutation = dinfo._permutation;
            ((PCAModel.PCAOutput)pca._output)._nnums = dinfo._nums;
            ((PCAModel.PCAOutput)pca._output)._ncats = dinfo._cats;
            ((PCAModel.PCAOutput)pca._output)._catOffsets = dinfo._catOffsets;
            double dfcorr = (double)nobs / ((double)nobs - 1.0);
            ((PCAModel.PCAOutput)pca._output)._std_deviation = new double[((PCAModel.PCAParameters)PCA.this._parms)._k];
            for (i = 0; i < ((PCAModel.PCAParameters)PCA.this._parms)._k; ++i) {
                sval[i] = dfcorr * sval[i];
                ((PCAModel.PCAOutput)pca._output)._std_deviation[i] = Math.sqrt(sval[i]);
            }
            ((PCAModel.PCAOutput)pca._output)._eigenvectors_raw = new double[eigvec.length][((PCAModel.PCAParameters)PCA.this._parms)._k];
            for (i = 0; i < eigvec.length; ++i) {
                System.arraycopy(eigvec[i], 0, ((PCAModel.PCAOutput)pca._output)._eigenvectors_raw[i], 0, ((PCAModel.PCAParameters)PCA.this._parms)._k);
            }
            ((PCAModel.PCAOutput)pca._output)._total_variance = dfcorr * gram.diagSum();
            this.buildTables(pca, dinfo.coefNames());
        }

        protected void computeStatsFillModel(PCAModel pca, DataInfo dinfo, SingularValueDecomposition svd, Gram gram, long nobs) {
            this.computeStatsFillModel(pca, dinfo, svd.getSingularValues(), svd.getV().getArray(), gram, nobs);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void computeImpl() {
            PCAModel model = null;
            DataInfo dinfo = null;
            DataInfo tinfo = null;
            Object AE = null;
            Gram gram = null;
            try {
                Model.Parameters parms;
                PCA.this.init(true);
                if (PCA.this.error_count() > 0) {
                    throw new IllegalArgumentException("Found validation errors: " + PCA.this.validationErrors());
                }
                model = new PCAModel(PCA.this.dest(), (PCAModel.PCAParameters)PCA.this._parms, new PCAModel.PCAOutput(PCA.this));
                model.delete_and_lock(PCA.this._job);
                Frame tranRebalanced = new Frame(PCA.this._train);
                if (!((PCAModel.PCAParameters)PCA.this._parms)._impute_missing) {
                    PCA.this._job.warn("_train: Dataset used may contain fewer number of rows due to removal of rows with NA/missing values.  If this is not desirable, set impute_missing argument in pca call to TRUE/True/true/... depending on the client language.");
                }
                if (!((PCAModel.PCAParameters)PCA.this._parms)._impute_missing && tranRebalanced.hasNAs()) {
                    tinfo = new DataInfo(PCA.this._train, PCA.this._valid, 0, ((PCAModel.PCAParameters)PCA.this._parms)._use_all_factor_levels, ((PCAModel.PCAParameters)PCA.this._parms)._transform, DataInfo.TransformType.NONE, !((PCAModel.PCAParameters)PCA.this._parms)._impute_missing, ((PCAModel.PCAParameters)PCA.this._parms)._impute_missing, false, false, false, false, false);
                    DKV.put((Key)tinfo._key, (Iced)tinfo);
                    DKV.put((Key)tranRebalanced._key, (Iced)tranRebalanced);
                    PCA.this._train = Rapids.exec((String)String.format("(na.omit %s)", tranRebalanced._key)).getFrame();
                    DKV.remove((Key)tranRebalanced._key);
                    PCA.this.checkMemoryFootPrint();
                }
                dinfo = new DataInfo(PCA.this._train, PCA.this._valid, 0, ((PCAModel.PCAParameters)PCA.this._parms)._use_all_factor_levels, ((PCAModel.PCAParameters)PCA.this._parms)._transform, DataInfo.TransformType.NONE, !((PCAModel.PCAParameters)PCA.this._parms)._impute_missing, ((PCAModel.PCAParameters)PCA.this._parms)._impute_missing, false, false, false, false, false);
                DKV.put((Key)dinfo._key, (Iced)dinfo);
                if (!((PCAModel.PCAParameters)PCA.this._parms)._impute_missing && tranRebalanced.hasNAs()) {
                    dinfo._normMul = tinfo._normMul;
                    dinfo._numMeans = tinfo._numMeans;
                    dinfo._normSub = tinfo._normSub;
                }
                if (((PCAModel.PCAParameters)PCA.this._parms)._pca_method == PCAModel.PCAParameters.Method.GramSVD) {
                    PCA.this._job.update(1L, "Begin distributed calculation of Gram matrix");
                    Gram.OuterGramTask ogtsk = null;
                    Gram.GramTask gtsk = null;
                    if (PCA.this._wideDataset) {
                        ogtsk = (Gram.OuterGramTask)new Gram.OuterGramTask((Key<Job>)PCA.this._job._key, dinfo).doAll(dinfo._adaptedFrame);
                        gram = ogtsk._gram;
                        ((PCAModel.PCAOutput)model._output)._nobs = ogtsk._nobs;
                    } else {
                        gtsk = (Gram.GramTask)new Gram.GramTask((Key<Job>)PCA.this._job._key, dinfo).doAll(dinfo._adaptedFrame);
                        gram = gtsk._gram;
                        assert (gram.fullN() == PCA.this._ncolExp);
                        ((PCAModel.PCAOutput)model._output)._nobs = gtsk._nobs;
                    }
                    if (((PCAModel.PCAOutput)model._output)._nobs == 0L || ((PCAModel.PCAOutput)model._output)._nobs < (long)((PCAModel.PCAParameters)PCA.this._parms)._k) {
                        PCA.this.error("_train", "Number of row in _train is less than k. Consider setting impute_missing = TRUE or using pca_method = 'GLRM' instead or reducing the value of parameter k.");
                    }
                    if (PCA.this.error_count() > 0) {
                        throw new IllegalArgumentException("Found validation errors: " + PCA.this.validationErrors());
                    }
                    PCA.this._job.update(1L, "Calculating SVD of Gram matrix locally");
                    Matrix gramJ = PCA.this._wideDataset ? new Matrix(ogtsk._gram.getXX()) : new Matrix(gtsk._gram.getXX());
                    SingularValueDecomposition svdJ = gramJ.svd();
                    PCA.this._job.update(1L, "Computing stats from SVD");
                    if (PCA.this._wideDataset) {
                        double[][] eigenVecs = DimensionReductionUtils.transformEigenVectors(dinfo, svdJ.getV().getArray());
                        this.computeStatsFillModel(model, dinfo, svdJ.getSingularValues(), eigenVecs, gram, ((PCAModel.PCAOutput)model._output)._nobs);
                    } else {
                        this.computeStatsFillModel(model, dinfo, svdJ, gram, ((PCAModel.PCAOutput)model._output)._nobs);
                    }
                    ((PCAModel.PCAOutput)model._output)._training_time_ms.add(System.currentTimeMillis());
                    LinkedHashMap<String, ArrayList> scoreTable = new LinkedHashMap<String, ArrayList>();
                    scoreTable.put("Timestamp", ((PCAModel.PCAOutput)model._output)._training_time_ms);
                    ((PCAModel.PCAOutput)model._output)._scoring_history = DimensionReductionUtils.createScoringHistoryTableDR(scoreTable, "Scoring History for GramSVD", PCA.this._job.start_time());
                } else if (((PCAModel.PCAParameters)PCA.this._parms)._pca_method == PCAModel.PCAParameters.Method.Power || ((PCAModel.PCAParameters)PCA.this._parms)._pca_method == PCAModel.PCAParameters.Method.Randomized) {
                    parms = new SVDModel.SVDParameters();
                    parms._train = ((PCAModel.PCAParameters)PCA.this._parms)._train;
                    parms._valid = ((PCAModel.PCAParameters)PCA.this._parms)._valid;
                    parms._ignored_columns = ((PCAModel.PCAParameters)PCA.this._parms)._ignored_columns;
                    parms._ignore_const_cols = ((PCAModel.PCAParameters)PCA.this._parms)._ignore_const_cols;
                    parms._score_each_iteration = ((PCAModel.PCAParameters)PCA.this._parms)._score_each_iteration;
                    parms._use_all_factor_levels = ((PCAModel.PCAParameters)PCA.this._parms)._use_all_factor_levels;
                    parms._transform = ((PCAModel.PCAParameters)PCA.this._parms)._transform;
                    parms._nv = ((PCAModel.PCAParameters)PCA.this._parms)._k;
                    parms._max_iterations = ((PCAModel.PCAParameters)PCA.this._parms)._max_iterations;
                    parms._seed = ((PCAModel.PCAParameters)PCA.this._parms)._seed;
                    parms._impute_missing = ((PCAModel.PCAParameters)PCA.this._parms)._impute_missing;
                    if (((PCAModel.PCAParameters)PCA.this._parms)._pca_method == PCAModel.PCAParameters.Method.Power) {
                        parms._svd_method = SVDModel.SVDParameters.Method.Power;
                    } else if (((PCAModel.PCAParameters)PCA.this._parms)._pca_method == PCAModel.PCAParameters.Method.Randomized) {
                        parms._svd_method = SVDModel.SVDParameters.Method.Randomized;
                    }
                    parms._only_v = false;
                    parms._keep_u = false;
                    parms._save_v_frame = false;
                    SVD svdP = new SVD((SVDModel.SVDParameters)parms, PCA.this._job);
                    svdP.setWideDataset(PCA.this._wideDataset);
                    SVDModel svd = (SVDModel)svdP.trainModelNested(tranRebalanced);
                    if (PCA.this.stop_requested()) {
                        return;
                    }
                    svd.remove();
                    PCA.this._job.update(1L, "Computing stats from SVD");
                    Gram.GramTask gtsk = (Gram.GramTask)new Gram.GramTask((Key<Job>)PCA.this._job._key, dinfo).doAll(dinfo._adaptedFrame);
                    gram = gtsk._gram;
                    this.computeStatsFillModel(model, svd, gram);
                    ((PCAModel.PCAOutput)model._output)._scoring_history = ((SVDModel.SVDOutput)svd._output)._scoring_history;
                } else if (((PCAModel.PCAParameters)PCA.this._parms)._pca_method == PCAModel.PCAParameters.Method.GLRM) {
                    parms = new GLRMModel.GLRMParameters();
                    parms._train = ((PCAModel.PCAParameters)PCA.this._parms)._train;
                    parms._valid = ((PCAModel.PCAParameters)PCA.this._parms)._valid;
                    parms._ignored_columns = ((PCAModel.PCAParameters)PCA.this._parms)._ignored_columns;
                    parms._ignore_const_cols = ((PCAModel.PCAParameters)PCA.this._parms)._ignore_const_cols;
                    parms._score_each_iteration = ((PCAModel.PCAParameters)PCA.this._parms)._score_each_iteration;
                    parms._transform = ((PCAModel.PCAParameters)PCA.this._parms)._transform;
                    parms._k = ((PCAModel.PCAParameters)PCA.this._parms)._k;
                    parms._max_iterations = ((PCAModel.PCAParameters)PCA.this._parms)._max_iterations;
                    parms._seed = ((PCAModel.PCAParameters)PCA.this._parms)._seed;
                    parms._recover_svd = true;
                    parms._loss = GlrmLoss.Quadratic;
                    parms._gamma_y = 0.0;
                    parms._gamma_x = 0.0;
                    parms._regularization_x = GlrmRegularizer.None;
                    parms._regularization_y = GlrmRegularizer.None;
                    parms._init = dinfo._cats > 0 ? GlrmInitialization.PlusPlus : GlrmInitialization.SVD;
                    GLRMModel glrm = (GLRMModel)new GLRM((GLRMModel.GLRMParameters)parms, (Job<GLRMModel>)PCA.this._job).trainModelNested(tranRebalanced);
                    if (PCA.this.stop_requested()) {
                        return;
                    }
                    ((Frame)((GLRMModel.GLRMOutput)glrm._output)._representation_key.get()).delete();
                    glrm.remove();
                    PCA.this._job.update(1L, "Computing stats from GLRM decomposition");
                    Gram.GramTask gtsk = (Gram.GramTask)new Gram.GramTask((Key<Job>)PCA.this._job._key, dinfo).doAll(dinfo._adaptedFrame);
                    gram = gtsk._gram;
                    this.computeStatsFillModel(model, glrm, gram);
                    ((PCAModel.PCAOutput)model._output)._scoring_history = ((GLRMModel.GLRMOutput)glrm._output)._scoring_history;
                    ((PCAModel.PCAOutput)model._output)._scoring_history.setTableHeader("Scoring history from GLRM");
                }
                PCA.this._job.update(1L, "Scoring and computing metrics on training data");
                if (((PCAModel.PCAParameters)PCA.this._parms)._compute_metrics) {
                    ModelMetrics mm;
                    model.score(((PCAModel.PCAParameters)PCA.this._parms).train()).delete();
                    ((PCAModel.PCAOutput)model._output)._training_metrics = mm = ModelMetrics.getFromDKV((Model)model, (Frame)((PCAModel.PCAParameters)PCA.this._parms).train());
                }
                PCA.this._job.update(1L, "Scoring and computing metrics on validation data");
                if (PCA.this._valid != null) {
                    model.score(((PCAModel.PCAParameters)PCA.this._parms).valid()).delete();
                    ((PCAModel.PCAOutput)model._output)._validation_metrics = ModelMetrics.getFromDKV((Model)model, (Frame)((PCAModel.PCAParameters)PCA.this._parms).valid());
                }
                model.update(PCA.this._job);
            }
            finally {
                if (model != null) {
                    model.unlock(PCA.this._job);
                }
                if (dinfo != null) {
                    dinfo.remove();
                }
                if (tinfo != null) {
                    tinfo.remove();
                }
                if (AE != null) {
                    AE.remove();
                }
            }
        }
    }
}

