/*
 * Decompiled with CFR 0.152.
 */
package hex.deepwater;

import hex.DataInfo;
import hex.Distribution;
import hex.Model;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.ModelMetricsAutoEncoder;
import hex.ModelMetricsBinomial;
import hex.ModelMetricsMultinomial;
import hex.ModelMetricsRegression;
import hex.ModelMetricsSupervised;
import hex.ScoreKeeper;
import hex.ScoringInfo;
import hex.ToEigenVec;
import hex.VarImp;
import hex.deepwater.DeepWaterDatasetIterator;
import hex.deepwater.DeepWaterImageIterator;
import hex.deepwater.DeepWaterIterator;
import hex.deepwater.DeepWaterModelInfo;
import hex.deepwater.DeepWaterModelOutput;
import hex.deepwater.DeepWaterParameters;
import hex.deepwater.DeepWaterScoringInfo;
import hex.deepwater.DeepWaterTextIterator;
import hex.deepwater.DeepwaterMojoWriter;
import hex.genmodel.GenModel;
import hex.genmodel.utils.DistributionFamily;
import hex.schemas.DeepWaterModelV3;
import hex.util.LinearAlgebraUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Random;
import water.AutoBuffer;
import water.DKV;
import water.Freezable;
import water.Futures;
import water.H2O;
import water.H2ONode;
import water.Iced;
import water.IcedUtils;
import water.Job;
import water.Key;
import water.KeySnapshot;
import water.Keyed;
import water.Scope;
import water.Value;
import water.api.schemas3.ModelSchemaV3;
import water.exceptions.H2OIllegalArgumentException;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.util.FrameUtils;
import water.util.Log;
import water.util.PrettyPrint;
import water.util.RandomUtils;

public class DeepWaterModel
extends Model<DeepWaterModel, DeepWaterParameters, DeepWaterModelOutput>
implements Model.DeepFeatures {
    private volatile DeepWaterModelInfo model_info;
    private long total_checkpointed_run_time_ms;
    private long total_training_time_ms;
    private long total_scoring_time_ms;
    long total_setup_time_ms;
    private long time_of_start_ms;
    long actual_train_samples_per_iteration;
    long time_for_iteration_overhead_ms;
    double epoch_counter;
    int iterations;
    private boolean stopped_early;
    long training_rows;
    long validation_rows;
    private float _bestLoss = Float.POSITIVE_INFINITY;
    Key actual_best_model_key;
    static final String unstable_msg = H2O.technote((int)4, (String)"\n\nTrying to predict with an unstable model.\nJob was aborted due to observed numerical instability (exponential growth).\nEither the weights or the bias values are unreasonably large or lead to large activation values.\nTry a different network architecture, a bounded activation function (tanh), adding regularization\n(via dropout) or use a smaller learning rate and/or momentum.");
    long _timeLastIterationEnter;
    private long _timeLastScoreStart;
    private long _timeLastScoreEnd;
    private long _timeLastPrintStart;
    private int backendCount = 0;
    static String CACHE_MARKER = "__d33pW473r_1n73rn4l__";

    public DeepwaterMojoWriter getMojo() {
        return new DeepwaterMojoWriter(this);
    }

    public ModelSchemaV3 schema() {
        return new DeepWaterModelV3();
    }

    void set_model_info(DeepWaterModelInfo mi) {
        this.model_info = mi;
    }

    public final DeepWaterModelInfo model_info() {
        return this.model_info;
    }

    public ToEigenVec getToEigenVec() {
        return LinearAlgebraUtils.toEigen;
    }

    public DeepWaterScoringInfo last_scored() {
        return (DeepWaterScoringInfo)super.last_scored();
    }

    public final DeepWaterParameters get_params() {
        return this.model_info.get_params();
    }

    public ModelMetrics.MetricBuilder makeMetricBuilder(String[] domain) {
        switch (((DeepWaterModelOutput)this._output).getModelCategory()) {
            case Binomial: {
                return new ModelMetricsBinomial.MetricBuilderBinomial(domain);
            }
            case Multinomial: {
                return new ModelMetricsMultinomial.MetricBuilderMultinomial(((DeepWaterModelOutput)this._output).nclasses(), domain);
            }
            case Regression: {
                return new ModelMetricsRegression.MetricBuilderRegression();
            }
            case AutoEncoder: {
                return new ModelMetricsAutoEncoder.MetricBuilderAutoEncoder(((DeepWaterModelOutput)this._output).nfeatures());
            }
        }
        throw H2O.unimpl((String)("Invalid ModelCategory " + ((DeepWaterModelOutput)this._output).getModelCategory()));
    }

    static DataInfo makeDataInfo(Frame train, Frame valid, DeepWaterParameters parms) {
        double x = 0.782347234;
        boolean identityLink = new Distribution((Model.Parameters)parms).link(x) == x;
        return new DataInfo(train, valid, parms._autoencoder ? 0 : 1, parms._autoencoder || parms._use_all_factor_levels, parms._standardize ? (parms._autoencoder ? DataInfo.TransformType.NORMALIZE : (parms._sparse ? DataInfo.TransformType.DESCALE : DataInfo.TransformType.STANDARDIZE)) : DataInfo.TransformType.NONE, !parms._standardize || train.lastVec().isCategorical() ? DataInfo.TransformType.NONE : (identityLink ? DataInfo.TransformType.STANDARDIZE : DataInfo.TransformType.NONE), parms._missing_values_handling == DeepWaterParameters.MissingValuesHandling.Skip, false, true, parms._weights_column != null, parms._offset_column != null, parms._fold_column != null);
    }

    public DeepWaterModel(Key<DeepWaterModel> destKey, DeepWaterParameters parms, DeepWaterModel cp, DataInfo dataInfo) {
        super(destKey, (Model.Parameters)(parms == null ? (DeepWaterParameters)((DeepWaterParameters)cp._parms).clone() : (DeepWaterParameters)IcedUtils.deepCopy((Iced)parms)), (Model.Output)((DeepWaterModelOutput)((DeepWaterModelOutput)cp._output).clone()));
        DeepWaterParameters.Sanity.modifyParms((DeepWaterParameters)this._parms, (DeepWaterParameters)this._parms, ((DeepWaterModelOutput)cp._output).nclasses());
        assert (this._parms != cp._parms);
        assert (((DeepWaterParameters)this._parms)._checkpoint == cp._key);
        this.model_info = (DeepWaterModelInfo)IcedUtils.deepCopy((Iced)cp.model_info);
        this.model_info._dataInfo = dataInfo;
        assert (this.model_info._network != null);
        assert (this.model_info._modelparams != null);
        this.model_info.javaToNative();
        this._dist = new Distribution((Model.Parameters)this.get_params());
        assert (this._dist.distribution != DistributionFamily.AUTO);
        this.actual_best_model_key = cp.actual_best_model_key;
        if (this.actual_best_model_key.get() == null) {
            DeepWaterModel best = (DeepWaterModel)IcedUtils.deepCopy((Iced)cp);
            this.actual_best_model_key = Key.make((H2ONode)H2O.SELF);
            DKV.put((Key)this.actual_best_model_key, (Iced)best);
        }
        this.time_of_start_ms = cp.time_of_start_ms;
        this.total_training_time_ms = cp.total_training_time_ms;
        this.total_checkpointed_run_time_ms = cp.total_training_time_ms;
        this.total_scoring_time_ms = cp.total_scoring_time_ms;
        this.total_setup_time_ms = cp.total_setup_time_ms;
        this.training_rows = cp.training_rows;
        this.validation_rows = cp.validation_rows;
        this._bestLoss = cp._bestLoss;
        this.epoch_counter = cp.epoch_counter;
        this.iterations = cp.iterations;
        this.scoringInfo = (ScoringInfo[])cp.scoringInfo.clone();
        for (int i = 0; i < this.scoringInfo.length; ++i) {
            this.scoringInfo[i] = (ScoringInfo)IcedUtils.deepCopy((Iced)cp.scoringInfo[i]);
        }
        ((DeepWaterModelOutput)this._output).errors = this.last_scored();
        ((DeepWaterModelOutput)this._output)._scoring_history = DeepWaterScoringInfo.createScoringHistoryTable((ScoringInfo[])this.scoringInfo, (null != this.get_params()._valid ? 1 : 0) != 0, (boolean)false, (ModelCategory)((DeepWaterModelOutput)this._output).getModelCategory(), (boolean)((DeepWaterModelOutput)this._output).isAutoencoder());
        ((DeepWaterModelOutput)this._output)._variable_importances = ModelMetrics.calcVarImp((VarImp)this.last_scored().variable_importances);
        if (dataInfo != null) {
            ((DeepWaterModelOutput)this._output).setNames(dataInfo._adaptedFrame.names());
            ((DeepWaterModelOutput)this._output)._domains = dataInfo._adaptedFrame.domains();
        }
        assert (this._key.equals(destKey));
    }

    private void setDataInfoToOutput(DataInfo dinfo) {
        if (dinfo == null) {
            return;
        }
        ((DeepWaterModelOutput)this._output).setNames(dinfo._adaptedFrame.names());
        ((DeepWaterModelOutput)this._output)._domains = dinfo._adaptedFrame.domains();
        ((DeepWaterModelOutput)this._output)._nums = dinfo._nums;
        ((DeepWaterModelOutput)this._output)._cats = dinfo._cats;
        ((DeepWaterModelOutput)this._output)._catOffsets = dinfo._catOffsets;
        ((DeepWaterModelOutput)this._output)._normMul = dinfo._normMul;
        ((DeepWaterModelOutput)this._output)._normSub = dinfo._normSub;
        ((DeepWaterModelOutput)this._output)._normRespMul = dinfo._normRespMul;
        ((DeepWaterModelOutput)this._output)._normRespSub = dinfo._normRespSub;
        ((DeepWaterModelOutput)this._output)._useAllFactorLevels = dinfo._useAllFactorLevels;
    }

    public DeepWaterModel(Key<DeepWaterModel> destKey, DeepWaterParameters params, DeepWaterModelOutput output, Frame train, Frame valid, int nClasses) {
        super(destKey, (Model.Parameters)params, (Model.Output)output);
        if (H2O.getCloudSize() != 1) {
            throw new IllegalArgumentException("Deep Water currently only supports execution of 1 node.");
        }
        ((DeepWaterModelOutput)this._output)._origNames = ((Frame)params._train.get()).names();
        ((DeepWaterModelOutput)this._output)._origDomains = ((Frame)params._train.get()).domains();
        DeepWaterParameters parms = (DeepWaterParameters)params.clone();
        DeepWaterParameters.Sanity.modifyParms(parms, parms, nClasses);
        DataInfo dinfo = null;
        if (parms._problem_type == DeepWaterParameters.ProblemType.dataset) {
            dinfo = DeepWaterModel.makeDataInfo(train, valid, parms);
            DKV.put((Keyed)dinfo);
            this.setDataInfoToOutput(dinfo);
            if (parms._image_shape != null && parms._image_shape[0] != 0) {
                if (parms._image_shape[0] < 0) {
                    throw new IllegalArgumentException("image_shape must either have both values == 0 or both values >= 1 for " + ((Object)((Object)parms._problem_type)).getClass().toString() + "=" + parms._problem_type.toString());
                }
                if (parms._image_shape[1] <= 0) {
                    throw new IllegalArgumentException("image_shape must either have both values == 0 or both values >= 1 for " + ((Object)((Object)parms._problem_type)).getClass().toString() + "=" + parms._problem_type.toString());
                }
                if (parms._channels <= 0) {
                    throw new IllegalArgumentException("channels must be >= 1 when image_shape is provided for " + ((Object)((Object)parms._problem_type)).getClass().toString() + "=" + parms._problem_type.toString());
                }
                if (dinfo.fullN() != parms._image_shape[0] * parms._image_shape[1] * parms._channels) {
                    throw new IllegalArgumentException("Data input size mismatch: Expect image_shape[0] x image_shape[1] x channels == #cols(H2OFrame), but got: " + parms._image_shape[0] + " x " + parms._image_shape[1] + " x " + parms._channels + " != " + dinfo.fullN() + ". Check these parameters, or disable ignore_const_cols.");
                }
            }
        }
        this.model_info = new DeepWaterModelInfo(parms, nClasses, dinfo != null ? dinfo.fullN() : -1);
        this.model_info._dataInfo = dinfo;
        if (dinfo != null) {
            FrameUtils.printTopCategoricalLevels((Frame)dinfo._adaptedFrame, (dinfo.fullN() > 10000 ? 1 : 0) != 0, (int)10);
            Log.info((Object[])new Object[]{"Building the model on " + dinfo.numNums() + " numeric features and " + dinfo.numCats() + " (one-hot encoded) categorical features."});
        }
        this._dist = new Distribution((Model.Parameters)this.get_params());
        assert (this._dist.distribution != DistributionFamily.AUTO);
        this.actual_best_model_key = Key.make((H2ONode)H2O.SELF);
        if (this.get_params()._nfolds != 0) {
            this.actual_best_model_key = null;
        }
        if (!this.get_params()._autoencoder) {
            this.scoringInfo = new DeepWaterScoringInfo[1];
            this.scoringInfo[0] = new DeepWaterScoringInfo();
            this.scoringInfo[0].validation = this.get_params()._valid != null;
            this.scoringInfo[0].time_stamp_ms = System.currentTimeMillis();
            ((DeepWaterModelOutput)this._output).errors = this.last_scored();
            ((DeepWaterModelOutput)this._output)._scoring_history = DeepWaterScoringInfo.createScoringHistoryTable((ScoringInfo[])this.scoringInfo, (null != this.get_params()._valid ? 1 : 0) != 0, (boolean)false, (ModelCategory)((DeepWaterModelOutput)this._output).getModelCategory(), (boolean)((DeepWaterModelOutput)this._output).isAutoencoder());
            ((DeepWaterModelOutput)this._output)._variable_importances = ModelMetrics.calcVarImp((VarImp)this.last_scored().variable_importances);
        }
        this.time_of_start_ms = System.currentTimeMillis();
        assert (this._key.equals(destKey));
        boolean fail = false;
        long byte_size = 0L;
        try {
            byte_size = new AutoBuffer().put((Freezable)this).buf().length;
        }
        catch (Throwable t) {
            fail = true;
        }
        if (byte_size > Integer.MAX_VALUE || fail) {
            throw new IllegalArgumentException(H2O.technote((int)5, (String)("Model is too large to fit into the DKV (larger than " + PrettyPrint.bytes((long)Integer.MAX_VALUE) + ").")));
        }
    }

    private void checkTimingConsistency() {
        assert (this.total_scoring_time_ms <= this.total_training_time_ms);
        assert (this.total_setup_time_ms <= this.total_training_time_ms);
        assert (this.total_setup_time_ms + this.total_scoring_time_ms <= this.total_training_time_ms);
        assert (this.total_training_time_ms >= this.total_checkpointed_run_time_ms);
        assert (this.total_checkpointed_run_time_ms >= 0L);
        assert (this.total_training_time_ms >= 0L);
        assert (this.total_scoring_time_ms >= 0L);
    }

    private void updateTiming(Key<Job> job_key) {
        long now = System.currentTimeMillis();
        long start_time_current_model = ((Job)job_key.get()).start_time();
        this.total_training_time_ms = this.total_checkpointed_run_time_ms + (now - start_time_current_model);
        this.checkTimingConsistency();
    }

    boolean doScoring(Frame fTrain, Frame fValid, Key<Job> jobKey, int iteration, boolean finalScoring) {
        long now = System.currentTimeMillis();
        double time_since_last_iter = now - this._timeLastIterationEnter;
        this.updateTiming(jobKey);
        this._timeLastIterationEnter = now;
        this.epoch_counter = (double)this.model_info().get_processed_total() / (double)this.training_rows;
        if (this.get_params()._train_samples_per_iteration == -2L && iteration > 1) {
            Log.debug((Object[])new Object[]{"Auto-tuning train_samples_per_iteration."});
            if (this.time_for_iteration_overhead_ms > 10L) {
                Log.debug((Object[])new Object[]{"  Time taken for per-iteration comm overhead: " + PrettyPrint.msecs((long)this.time_for_iteration_overhead_ms, (boolean)true)});
                Log.debug((Object[])new Object[]{"  Time taken for Map/Reduce iteration: " + PrettyPrint.msecs((long)((long)time_since_last_iter), (boolean)true)});
                double comm_to_work_ratio = (double)this.time_for_iteration_overhead_ms / time_since_last_iter;
                Log.debug((Object[])new Object[]{"  Ratio of per-iteration comm overhead to computation: " + String.format("%.5f", comm_to_work_ratio)});
                Log.debug((Object[])new Object[]{"  target_comm_to_work: " + this.get_params()._target_ratio_comm_to_comp});
                Log.debug((Object[])new Object[]{"Old value of train_samples_per_iteration: " + this.actual_train_samples_per_iteration});
                double correction = this.get_params()._target_ratio_comm_to_comp / comm_to_work_ratio;
                correction = Math.max(0.5, Math.min(2.0, correction));
                if (Math.abs(correction) < 0.8 || Math.abs(correction) > 1.2) {
                    this.actual_train_samples_per_iteration = (long)((double)this.actual_train_samples_per_iteration / correction);
                    this.actual_train_samples_per_iteration = Math.max(1L, this.actual_train_samples_per_iteration);
                    Log.debug((Object[])new Object[]{"New value of train_samples_per_iteration: " + this.actual_train_samples_per_iteration});
                } else {
                    Log.debug((Object[])new Object[]{"Keeping value of train_samples_per_iteration the same (would deviate too little from previous value): " + this.actual_train_samples_per_iteration});
                }
            } else {
                Log.debug((Object[])new Object[]{"Iteration overhead is faster than 10 ms. Not modifying train_samples_per_iteration: " + this.actual_train_samples_per_iteration});
            }
        }
        boolean keep_running = this.epoch_counter < this.get_params()._epochs && !this.stopped_early;
        long sinceLastScore = now - this._timeLastScoreStart;
        if (!keep_running || this.get_params()._score_each_iteration || (double)sinceLastScore > this.get_params()._score_interval * 1000.0 && (double)(this._timeLastScoreEnd - this._timeLastScoreStart) / (double)sinceLastScore < this.get_params()._score_duty_cycle) {
            ModelMetrics mtrain;
            String m;
            Log.info((Object[])new Object[]{DeepWaterModel.logNvidiaStats()});
            ((Job)jobKey.get()).update(0L, "Scoring on " + fTrain.numRows() + " training samples" + (fValid != null ? ", " + fValid.numRows() + " validation samples" : ""));
            boolean printme = !this.get_params()._quiet_mode;
            this._timeLastScoreStart = System.currentTimeMillis();
            DeepWaterScoringInfo scoringInfo = new DeepWaterScoringInfo();
            scoringInfo.time_stamp_ms = this._timeLastScoreStart;
            this.updateTiming(jobKey);
            scoringInfo.total_training_time_ms = this.total_training_time_ms;
            scoringInfo.total_scoring_time_ms = this.total_scoring_time_ms;
            scoringInfo.total_setup_time_ms = this.total_setup_time_ms;
            scoringInfo.epoch_counter = this.epoch_counter;
            scoringInfo.iterations = this.iterations;
            scoringInfo.training_samples = this.model_info().get_processed_total();
            scoringInfo.validation = fValid != null;
            scoringInfo.score_training_samples = fTrain.numRows();
            scoringInfo.score_validation_samples = this.get_params()._score_validation_samples;
            scoringInfo.is_classification = ((DeepWaterModelOutput)this._output).isClassifier();
            scoringInfo.is_autoencoder = ((DeepWaterModelOutput)this._output).isAutoencoder();
            if (printme) {
                Log.info((Object[])new Object[]{"Scoring the model."});
            }
            if ((m = this.model_info().toString()).length() > 0) {
                Log.info((Object[])new Object[]{m});
            }
            boolean needPreds = ((DeepWaterModelOutput)this._output).nclasses() == 2 || this.get_params()._distribution == DistributionFamily.huber;
            Frame preds = null;
            if (needPreds) {
                preds = this.score(fTrain);
                mtrain = ModelMetrics.getFromDKV((Model)this, (Frame)fTrain);
            } else {
                ModelMetrics.MetricBuilder mb = this.scoreMetrics(fTrain);
                mtrain = mb.makeModelMetrics((Model)this, fTrain, fTrain, null);
            }
            if (preds != null) {
                preds.remove();
            }
            ((DeepWaterModelOutput)this._output)._training_metrics = mtrain;
            scoringInfo.scored_train = new ScoreKeeper(mtrain);
            ModelMetricsSupervised mm1 = (ModelMetricsSupervised)mtrain;
            if (mm1 instanceof ModelMetricsBinomial) {
                ModelMetricsBinomial mm = (ModelMetricsBinomial)mm1;
                scoringInfo.training_AUC = mm._auc;
            }
            ((DeepWaterModelOutput)this._output)._training_metrics._description = fTrain.numRows() != this.training_rows ? "Metrics reported on temporary training frame with " + fTrain.numRows() + " samples" : (fTrain._key != null && fTrain._key.toString().contains("chunks") ? "Metrics reported on temporary (load-balanced) training frame" : "Metrics reported on full training frame");
            if (fValid != null) {
                ModelMetrics mvalid;
                preds = null;
                if (needPreds) {
                    preds = this.score(fValid);
                    mvalid = ModelMetrics.getFromDKV((Model)this, (Frame)fValid);
                } else {
                    ModelMetrics.MetricBuilder mb = this.scoreMetrics(fValid);
                    mvalid = mb.makeModelMetrics((Model)this, fValid, fValid, null);
                }
                if (preds != null) {
                    preds.remove();
                }
                ((DeepWaterModelOutput)this._output)._validation_metrics = mvalid;
                scoringInfo.scored_valid = new ScoreKeeper(mvalid);
                if (mvalid != null) {
                    if (mvalid instanceof ModelMetricsBinomial) {
                        ModelMetricsBinomial mm = (ModelMetricsBinomial)mvalid;
                        scoringInfo.validation_AUC = mm._auc;
                    }
                    ((DeepWaterModelOutput)this._output)._validation_metrics._description = fValid.numRows() != this.validation_rows ? "Metrics reported on temporary validation frame with " + fValid.numRows() + " samples" : (fValid._key != null && fValid._key.toString().contains("chunks") ? "Metrics reported on temporary (load-balanced) validation frame" : "Metrics reported on full validation frame");
                }
            }
            this._timeLastScoreEnd = System.currentTimeMillis();
            long scoringTime = this._timeLastScoreEnd - this._timeLastScoreStart;
            this.total_scoring_time_ms += scoringTime;
            this.updateTiming(jobKey);
            scoringInfo.total_training_time_ms = this.total_training_time_ms;
            scoringInfo.total_scoring_time_ms = this.total_scoring_time_ms;
            scoringInfo.this_scoring_time_ms = scoringTime;
            if (this.scoringInfo == null) {
                this.scoringInfo = new DeepWaterScoringInfo[]{scoringInfo};
            } else {
                DeepWaterScoringInfo[] err2 = new DeepWaterScoringInfo[this.scoringInfo.length + 1];
                System.arraycopy(this.scoringInfo, 0, err2, 0, this.scoringInfo.length);
                err2[err2.length - 1] = scoringInfo;
                this.scoringInfo = err2;
            }
            ((DeepWaterModelOutput)this._output).errors = this.last_scored();
            ((DeepWaterModelOutput)this._output)._scoring_history = DeepWaterScoringInfo.createScoringHistoryTable((ScoringInfo[])this.scoringInfo, (null != this.get_params()._valid ? 1 : 0) != 0, (boolean)false, (ModelCategory)((DeepWaterModelOutput)this._output).getModelCategory(), (boolean)((DeepWaterModelOutput)this._output).isAutoencoder());
            ((DeepWaterModelOutput)this._output)._variable_importances = ModelMetrics.calcVarImp((VarImp)this.last_scored().variable_importances);
            ((DeepWaterModelOutput)this._output)._model_summary = this.model_info.createSummaryTable();
            if (!finalScoring) {
                if (this.actual_best_model_key != null && this.get_params()._overwrite_with_best_model && (DKV.get((Key)this.actual_best_model_key) != null && !(this.loss() >= ((DeepWaterModel)DKV.get((Key)this.actual_best_model_key).get()).loss()) || DKV.get((Key)this.actual_best_model_key) == null && this.loss() < this._bestLoss)) {
                    this._bestLoss = this.loss();
                    this.model_info.nativeToJava();
                    this.putMeAsBestModel(this.actual_best_model_key);
                }
                if (keep_running && printme) {
                    Log.info((Object[])new Object[]{this.toString()});
                }
                if (ScoreKeeper.stopEarly((ScoreKeeper[])ScoringInfo.scoreKeepers((ScoringInfo[])this.scoring_history()), (int)this.get_params()._stopping_rounds, (boolean)((DeepWaterModelOutput)this._output).isClassifier(), (ScoreKeeper.StoppingMetric)this.get_params()._stopping_metric, (double)this.get_params()._stopping_tolerance, (String)"model's last", (boolean)true)) {
                    Log.info((Object[])new Object[]{"Convergence detected based on simple moving average of the loss function for the past " + this.get_params()._stopping_rounds + " scoring events. Model building completed."});
                    this.stopped_early = true;
                }
                if (printme) {
                    Log.info((Object[])new Object[]{"Time taken for scoring and diagnostics: " + PrettyPrint.msecs((long)scoringInfo.this_scoring_time_ms, (boolean)true)});
                }
            }
        }
        if (this.stopped_early) {
            ((Job)DKV.getGet(jobKey)).update((long)(this.get_params()._epochs * (double)this.training_rows));
            this.update(jobKey);
            return false;
        }
        this.progressUpdate(jobKey, keep_running);
        return keep_running;
    }

    private void putMeAsBestModel(Key bestModelKey) {
        DKV.put((Key)bestModelKey, (Iced)IcedUtils.deepCopy((Iced)this));
        assert (DKV.get((Key)bestModelKey) != null);
        assert (((DeepWaterModel)DKV.getGet((Key)bestModelKey)).compareTo(this) <= 0);
    }

    private void progressUpdate(Key<Job> job_key, boolean keep_running) {
        this.updateTiming(job_key);
        Job job = (Job)job_key.get();
        double progress = job.progress();
        float speed = (float)((double)this.model_info().get_processed_total() * 1000.0 / (double)(this.total_training_time_ms - this.total_scoring_time_ms - this.total_setup_time_ms));
        assert (speed >= 0.0f) : "negative speed computed! (total_run_time: " + this.total_training_time_ms + ", total_scoring_time: " + this.total_scoring_time_ms + ", total_setup_time: " + this.total_setup_time_ms + ")";
        String msg = "Iterations: " + String.format("%,d", this.iterations) + ". Epochs: " + String.format("%g", this.epoch_counter) + ". Speed: " + (speed > 10.0f ? String.format("%d", (int)speed) : String.format("%g", Float.valueOf(speed))) + " samples/sec." + (progress == 0.0 ? "" : " Estimated time left: " + PrettyPrint.msecs((long)((long)((double)this.total_training_time_ms * (1.0 - progress) / progress)), (boolean)true));
        job.update(this.actual_train_samples_per_iteration, msg);
        long now = System.currentTimeMillis();
        long sinceLastPrint = now - this._timeLastPrintStart;
        if (!keep_running || (double)sinceLastPrint > this.get_params()._score_interval * 1000.0) {
            this._timeLastPrintStart = now;
            if (!this.get_params()._quiet_mode) {
                Log.info((Object[])new Object[]{"Training time: " + PrettyPrint.msecs((long)this.total_training_time_ms, (boolean)true) + " (scoring: " + PrettyPrint.msecs((long)this.total_scoring_time_ms, (boolean)true) + "). " + "Processed " + String.format("%,d", this.model_info().get_processed_total()) + " samples" + " (" + String.format("%.3f", this.epoch_counter) + " epochs).\n"});
                Log.info((Object[])new Object[]{msg});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupBigScorePredict() {
        DeepWaterModelInfo deepWaterModelInfo = this.model_info();
        synchronized (deepWaterModelInfo) {
            ++this.backendCount;
            if (null == this.model_info()._backend) {
                this.model_info().javaToNative();
            }
            if (null == this.model_info().getModel().get()) {
                this.model_info().initModel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeBigScorePredict() {
        DeepWaterModelInfo deepWaterModelInfo = this.model_info();
        synchronized (deepWaterModelInfo) {
            if (0 == --this.backendCount) {
                this.model_info().nukeBackend();
            } else if (null != this.model_info().getModel().get()) {
                this.model_info().nukeModel();
            }
        }
    }

    protected double[] score0(double[] data, double[] preds) {
        float[] f = new float[((DeepWaterParameters)this._parms)._mini_batch_size * data.length];
        for (int i = 0; i < data.length; ++i) {
            f[i] = (float)data[i];
        }
        float[] predFloats = this.model_info._backend.predict(this.model_info.getModel().get(), f);
        if (((DeepWaterModelOutput)this._output).nclasses() >= 2) {
            for (int i = 1; i < ((DeepWaterModelOutput)this._output).nclasses() + 1; ++i) {
                preds[i] = predFloats[i];
            }
        } else {
            preds[0] = predFloats[0];
        }
        return preds;
    }

    public double[] score0(double[] data, double[] preds, double offset) {
        assert (offset == 0.0);
        return this.score0(data, preds);
    }

    protected long checksum_impl() {
        return super.checksum_impl() * ((DeepWaterModelOutput)this._output)._run_time + (long)this.model_info().hashCode();
    }

    public Frame scoreAutoEncoder(Frame frame, Key destination_key, boolean reconstruction_error_per_feature) {
        throw H2O.unimpl();
    }

    public Frame scoreDeepFeatures(Frame frame, int layer) {
        throw H2O.unimpl();
    }

    public Frame scoreDeepFeatures(Frame frame, int layer, Job j) {
        throw H2O.unimpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Frame scoreDeepFeatures(Frame frame, String layer, Job job) {
        boolean makeNative;
        int ridx;
        if (layer == null) {
            throw new H2OIllegalArgumentException("must give hidden layer (symbol) name to extract - cannot be null");
        }
        if (this.isSupervised() && (ridx = frame.find(((DeepWaterModelOutput)this._output).responseName())) != -1) {
            frame = new Frame(frame);
            frame.remove(ridx);
        }
        Frame adaptFrm = new Frame(frame);
        Scope.enter();
        this.adaptTestForTrain(adaptFrm, true, false);
        Frame _fr = adaptFrm;
        DataInfo di = this.model_info()._dataInfo;
        if (di != null) {
            di = (DataInfo)IcedUtils.deepCopy((Iced)di);
            di._adaptedFrame = _fr;
        }
        boolean dataIdx = false;
        int weightIdx = _fr.find(this.get_params()._weights_column);
        int batch_size = this.get_params()._mini_batch_size;
        ArrayList<Integer> score_data = new ArrayList<Integer>();
        ArrayList<Integer> skipped = new ArrayList<Integer>();
        long seed = 912559L + 53261L * this.model_info().get_processed_global();
        Random rng = RandomUtils.getRNG((long[])new long[]{seed});
        BufferedString bs = new BufferedString();
        if ((long)((int)_fr.numRows()) != _fr.numRows()) {
            throw new IllegalArgumentException("Cannot handle datasets with more than 2 billion rows.");
        }
        int i = 0;
        while ((long)i < _fr.numRows()) {
            double weight;
            double d = weight = weightIdx == -1 ? 1.0 : _fr.vec(weightIdx).at((long)i);
            if (weight == 0.0) {
                skipped.add(i);
            } else if (this.model_info().get_params()._problem_type == DeepWaterParameters.ProblemType.image || this.model_info().get_params()._problem_type == DeepWaterParameters.ProblemType.text) {
                BufferedString file = _fr.vec(0).atStr(bs, (long)i);
                if (file != null) {
                    score_data.add((Integer)((Object)file.toString()));
                }
            } else if (this.model_info().get_params()._problem_type == DeepWaterParameters.ProblemType.dataset) {
                score_data.add(i);
            } else {
                throw H2O.unimpl();
            }
            ++i;
        }
        while (score_data.size() % batch_size != 0) {
            int pick = rng.nextInt(score_data.size());
            score_data.add((Integer)score_data.get(pick));
        }
        assert (this.isSupervised());
        boolean bl = makeNative = this.model_info()._backend == null;
        if (makeNative) {
            this.model_info().javaToNative();
        }
        Frame _predFrame = null;
        try {
            int skippedRow;
            DeepWaterIterator iter;
            if (this.model_info().get_params()._problem_type == DeepWaterParameters.ProblemType.image) {
                int width = this.model_info()._width;
                int height = this.model_info()._height;
                int channels = this.model_info()._channels;
                iter = new DeepWaterImageIterator(score_data, null, this.model_info()._meanData, batch_size, width, height, channels, this.model_info().get_params()._cache_data);
            } else if (this.model_info().get_params()._problem_type == DeepWaterParameters.ProblemType.dataset) {
                iter = new DeepWaterDatasetIterator(score_data, null, di, batch_size, this.model_info().get_params()._cache_data);
            } else if (this.model_info().get_params()._problem_type == DeepWaterParameters.ProblemType.text) {
                iter = new DeepWaterTextIterator(score_data, null, batch_size, 56, this.model_info().get_params()._cache_data);
            } else {
                throw H2O.unimpl();
            }
            float[] data = iter.getData();
            float[] predFloats = this.model_info().extractLayer(layer, data);
            if (predFloats.length == 0) {
                throw new IllegalArgumentException(this.model_info().listAllLayers());
            }
            int cols = predFloats.length;
            assert (cols % batch_size == 0);
            Vec[] predVecs = new Vec[cols /= batch_size];
            for (int i2 = 0; i2 < cols; ++i2) {
                predVecs[i2] = _fr.anyVec().makeZero();
            }
            _predFrame = new Frame(predVecs);
            String[] names = new String[cols];
            for (int j = 0; j < cols; ++j) {
                names[j] = "DF." + layer + ".C" + (j + 1);
            }
            _predFrame.setNames(names);
            Vec.Writer[] vw = new Vec.Writer[cols];
            for (int i3 = 0; i3 < vw.length; ++i3) {
                vw[i3] = _predFrame.vec(i3).open();
            }
            long row = 0L;
            int skippedIdx = 0;
            int n = skippedRow = skipped.isEmpty() ? -1 : (Integer)skipped.get(skippedIdx);
            if (this.model_info().get_params()._problem_type == DeepWaterParameters.ProblemType.image) {
                int width = this.model_info()._width;
                int height = this.model_info()._height;
                int channels = this.model_info()._channels;
                iter = new DeepWaterImageIterator(score_data, null, this.model_info()._meanData, batch_size, width, height, channels, this.model_info().get_params()._cache_data);
            } else if (this.model_info().get_params()._problem_type == DeepWaterParameters.ProblemType.dataset) {
                iter = new DeepWaterDatasetIterator(score_data, null, di, batch_size, this.model_info().get_params()._cache_data);
            } else if (this.model_info().get_params()._problem_type == DeepWaterParameters.ProblemType.text) {
                iter = new DeepWaterTextIterator(score_data, null, batch_size, 56, this.model_info().get_params()._cache_data);
            } else {
                throw H2O.unimpl();
            }
            Futures fs = new Futures();
            while (((DeepWaterIterator)iter).Next(fs)) {
                float[] data2 = iter.getData();
                float[] predFloats2 = this.model_info().extractLayer(layer, data2);
                for (int j = 0; j < batch_size; ++j) {
                    while (row == (long)skippedRow) {
                        assert (weightIdx == -1 || _fr.vec(weightIdx).at(row) == 0.0);
                        if (skipped.size() > skippedIdx + 1) {
                            skippedRow = (Integer)skipped.get(++skippedIdx);
                        }
                        ++row;
                    }
                    if (row >= _fr.numRows()) break;
                    for (int i4 = 0; i4 < cols; ++i4) {
                        vw[i4].set(row, predFloats2[j * cols + i4]);
                    }
                    ++row;
                }
                for (Vec.Writer aVw : vw) {
                    aVw.close(fs);
                }
                fs.blockForPending();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (makeNative) {
                this.model_info().nukeBackend();
            }
            return _predFrame;
        }
    }

    protected Frame predictScoreImpl(Frame fr, Frame adaptFrm, String destination_key, Job j, boolean computeMetrics) {
        boolean makeNative;
        boolean bl = makeNative = this.model_info()._backend == null;
        if (makeNative) {
            this.model_info().javaToNative();
        }
        String[] names = this.makeScoringNames();
        String[][] domains = new String[names.length][];
        domains[0] = names.length == 1 ? null : (!computeMetrics ? ((DeepWaterModelOutput)this._output)._domains[((DeepWaterModelOutput)this._output)._domains.length - 1] : adaptFrm.lastVec().domain());
        Model.BigScore bs = (Model.BigScore)new DeepWaterBigScore(domains[0], names.length, adaptFrm.means(), ((DeepWaterModelOutput)this._output).hasWeights() && adaptFrm.find(((DeepWaterModelOutput)this._output).weightsName()) >= 0, computeMetrics, true, j).doAll(adaptFrm);
        if (computeMetrics) {
            bs._mb.makeModelMetrics((Model)this, fr, adaptFrm, bs.outputFrame());
        }
        if (makeNative) {
            this.removeNativeState();
        }
        return bs.outputFrame(null == destination_key ? Key.make() : Key.make((String)destination_key), names, domains);
    }

    protected ModelMetrics.MetricBuilder scoreMetrics(Frame adaptFrm) {
        boolean makeNative;
        boolean bl = makeNative = this.model_info()._backend == null;
        if (makeNative) {
            this.model_info().javaToNative();
        }
        boolean computeMetrics = !this.isSupervised() || adaptFrm.vec(((DeepWaterModelOutput)this._output).responseName()) != null && !adaptFrm.vec(((DeepWaterModelOutput)this._output).responseName()).isBad();
        String[] domain = !computeMetrics ? ((DeepWaterModelOutput)this._output)._domains[((DeepWaterModelOutput)this._output)._domains.length - 1] : adaptFrm.lastVec().domain();
        Model.BigScore bs = (Model.BigScore)new DeepWaterBigScore(domain, 0, adaptFrm.means(), ((DeepWaterModelOutput)this._output).hasWeights() && adaptFrm.find(((DeepWaterModelOutput)this._output).weightsName()) >= 0, computeMetrics, false, null).doAll(adaptFrm);
        if (makeNative) {
            this.removeNativeState();
        }
        return bs._mb;
    }

    void removeNativeState() {
        this.model_info().nukeBackend();
    }

    protected Futures remove_impl(Futures fs) {
        this.cleanUpCache(fs);
        this.removeNativeState();
        if (this.actual_best_model_key != null) {
            DKV.remove((Key)this.actual_best_model_key);
        }
        if (this.model_info()._dataInfo != null) {
            this.model_info()._dataInfo.remove(fs);
        }
        return super.remove_impl(fs);
    }

    void exportNativeModel(String path, int iteration) {
        this.model_info().saveNativeState(path, iteration);
    }

    void cleanUpCache() {
        this.cleanUpCache(null);
    }

    private void cleanUpCache(Futures fs) {
        Key[] cacheKeys = KeySnapshot.globalSnapshot().filter(new KeySnapshot.KVFilter(){

            public boolean filter(KeySnapshot.KeyInfo k) {
                return Value.isSubclassOf((int)k._type, DeepWaterImageIterator.IcedImage.class) && k._key.toString().contains(CACHE_MARKER) || Value.isSubclassOf((int)k._type, DeepWaterDatasetIterator.IcedRow.class) && k._key.toString().contains(CACHE_MARKER);
            }
        }).keys();
        if (fs == null) {
            fs = new Futures();
        }
        for (Key k : cacheKeys) {
            DKV.remove((Key)k, (Futures)fs);
        }
        fs.blockForPending();
    }

    private static String getNvidiaStats() throws IOException {
        String s;
        String cmd = "nvidia-smi";
        InputStream stdin = Runtime.getRuntime().exec(cmd).getInputStream();
        InputStreamReader isr = new InputStreamReader(stdin);
        BufferedReader br = new BufferedReader(isr);
        StringBuilder sb = new StringBuilder();
        while ((s = br.readLine()) != null) {
            sb.append(s).append("\n");
        }
        return sb.toString();
    }

    private static String logNvidiaStats() {
        try {
            return DeepWaterModel.getNvidiaStats();
        }
        catch (IOException e) {
            return null;
        }
    }

    class DeepWaterBigScore
    extends Model.BigScore {
        Frame _predFrame;

        public Frame outputFrame(Key<Frame> key, String[] names, String[][] domains) {
            this._predFrame = new Frame(key, names, this._predFrame.vecs());
            if (domains != null) {
                this._predFrame.vec(0).setDomain(domains[0]);
            }
            if (this._predFrame._key != null) {
                DKV.put((Keyed)this._predFrame);
            }
            return this._predFrame;
        }

        public void map(Chunk[] chks, NewChunk[] cpreds) {
        }

        public void reduce(Model.BigScore bs) {
        }

        protected void setupLocal() {
            if (((DeepWaterModel)DeepWaterModel.this).model_info._unstable) {
                Log.err((Object[])new Object[]{"Cannot score with an _unstable model."});
                Log.err((Object[])new Object[]{unstable_msg});
                throw new UnsupportedOperationException(unstable_msg);
            }
            DataInfo di = DeepWaterModel.this.model_info()._dataInfo;
            if (di != null) {
                di = (DataInfo)IcedUtils.deepCopy((Iced)di);
                di._adaptedFrame = this._fr;
            }
            boolean dataIdx = false;
            int weightIdx = this._fr.find(DeepWaterModel.this.get_params()._weights_column);
            int respIdx = this._fr.find(DeepWaterModel.this.get_params()._response_column);
            int batch_size = DeepWaterModel.this.get_params()._mini_batch_size;
            int classes = ((DeepWaterModelOutput)DeepWaterModel.this._output).nclasses();
            ArrayList<Integer> score_data = new ArrayList<Integer>();
            ArrayList<Integer> skipped = new ArrayList<Integer>();
            long seed = 912559L + 53261L * DeepWaterModel.this.model_info().get_processed_global();
            Random rng = RandomUtils.getRNG((long[])new long[]{seed});
            BufferedString bs = new BufferedString();
            if ((long)((int)this._fr.numRows()) != this._fr.numRows()) {
                throw new IllegalArgumentException("Cannot handle datasets with more than 2 billion rows.");
            }
            int i = 0;
            while ((long)i < this._fr.numRows()) {
                double weight;
                if (this.isCancelled() || this._j != null && this._j.stop_requested()) {
                    return;
                }
                double d = weight = weightIdx == -1 ? 1.0 : this._fr.vec(weightIdx).at((long)i);
                if (weight == 0.0) {
                    skipped.add(i);
                } else if (DeepWaterModel.this.model_info().get_params()._problem_type == DeepWaterParameters.ProblemType.image || DeepWaterModel.this.model_info().get_params()._problem_type == DeepWaterParameters.ProblemType.text) {
                    BufferedString file = this._fr.vec(0).atStr(bs, (long)i);
                    if (file != null) {
                        score_data.add((Integer)((Object)file.toString()));
                    }
                } else if (DeepWaterModel.this.model_info().get_params()._problem_type == DeepWaterParameters.ProblemType.dataset) {
                    score_data.add(i);
                } else {
                    throw H2O.unimpl();
                }
                ++i;
            }
            while (score_data.size() % batch_size != 0) {
                int pick = rng.nextInt(score_data.size());
                score_data.add((Integer)score_data.get(pick));
            }
            this._mb = DeepWaterModel.this.makeMetricBuilder(this._domain);
            assert (DeepWaterModel.this.isSupervised());
            int cols = ((DeepWaterModelOutput)DeepWaterModel.this._output).nclasses() + (((DeepWaterModelOutput)DeepWaterModel.this._output).isClassifier() ? 1 : 0);
            if (this._makePreds) {
                Vec[] predVecs = new Vec[cols];
                for (int i2 = 0; i2 < cols; ++i2) {
                    predVecs[i2] = this._fr.anyVec().makeZero();
                }
                this._predFrame = new Frame(predVecs);
            }
            try {
                DeepWaterIterator iter;
                Vec.Writer[] vw = new Vec.Writer[cols];
                if (this._makePreds) {
                    for (int i3 = 0; i3 < vw.length; ++i3) {
                        vw[i3] = this._predFrame.vec(i3).open();
                    }
                }
                long row = 0L;
                int skippedIdx = 0;
                int skippedRow = skipped.isEmpty() ? -1 : (Integer)skipped.get(skippedIdx);
                double mul = 1.0;
                double sub = 0.0;
                if (((DeepWaterModelOutput)DeepWaterModel.this._output)._normRespMul != null && ((DeepWaterModelOutput)DeepWaterModel.this._output)._normRespSub != null) {
                    mul = ((DeepWaterModelOutput)DeepWaterModel.this._output)._normRespMul[0];
                    sub = ((DeepWaterModelOutput)DeepWaterModel.this._output)._normRespSub[0];
                }
                if (DeepWaterModel.this.model_info().get_params()._problem_type == DeepWaterParameters.ProblemType.image) {
                    int width = DeepWaterModel.this.model_info()._width;
                    int height = DeepWaterModel.this.model_info()._height;
                    int channels = DeepWaterModel.this.model_info()._channels;
                    iter = new DeepWaterImageIterator(score_data, null, DeepWaterModel.this.model_info()._meanData, batch_size, width, height, channels, DeepWaterModel.this.model_info().get_params()._cache_data);
                } else if (DeepWaterModel.this.model_info().get_params()._problem_type == DeepWaterParameters.ProblemType.dataset) {
                    iter = new DeepWaterDatasetIterator(score_data, null, di, batch_size, DeepWaterModel.this.model_info().get_params()._cache_data);
                } else if (DeepWaterModel.this.model_info().get_params()._problem_type == DeepWaterParameters.ProblemType.text) {
                    iter = new DeepWaterTextIterator(score_data, null, batch_size, 56, DeepWaterModel.this.model_info().get_params()._cache_data);
                } else {
                    throw H2O.unimpl();
                }
                Futures fs = new Futures();
                while (iter.Next(fs)) {
                    if (this.isCancelled() || this._j != null && this._j.stop_requested()) {
                        return;
                    }
                    float[] data = iter.getData();
                    float[] predFloats = DeepWaterModel.this.model_info().predict(data);
                    boolean unstable = false;
                    for (int j = 0; j < batch_size; ++j) {
                        while (row == (long)skippedRow) {
                            assert (weightIdx == -1 || this._fr.vec(weightIdx).at(row) == 0.0);
                            if (skipped.size() > skippedIdx + 1) {
                                skippedRow = (Integer)skipped.get(++skippedIdx);
                            }
                            ++row;
                        }
                        if (row >= this._fr.numRows()) break;
                        float[] actual = null;
                        if (this._computeMetrics) {
                            actual = new float[]{(float)this._fr.vec(respIdx).at(row)};
                        }
                        if (((DeepWaterModelOutput)DeepWaterModel.this._output).isClassifier()) {
                            int i4;
                            double[] preds = new double[classes + 1];
                            for (i4 = 0; i4 < classes; ++i4) {
                                int idx = j * classes + i4;
                                preds[1 + i4] = predFloats[idx];
                                if (!Double.isNaN(preds[1 + i4])) continue;
                                unstable = true;
                            }
                            if (((DeepWaterParameters)DeepWaterModel.this._parms)._balance_classes) {
                                GenModel.correctProbabilities((double[])preds, (double[])((DeepWaterModelOutput)DeepWaterModel.this._output)._priorClassDist, (double[])((DeepWaterModelOutput)DeepWaterModel.this._output)._modelClassDist);
                            }
                            preds[0] = GenModel.getPrediction((double[])preds, (double[])((DeepWaterModelOutput)DeepWaterModel.this._output)._priorClassDist, null, (double)DeepWaterModel.this.defaultThreshold());
                            if (this._makePreds) {
                                for (i4 = 0; i4 <= classes; ++i4) {
                                    vw[i4].set(row, preds[i4]);
                                }
                            }
                            if (this._computeMetrics) {
                                this._mb.perRow(preds, actual, (Model)DeepWaterModel.this);
                            }
                        } else {
                            double pred = (double)predFloats[j] * mul + sub;
                            if (Double.isNaN(pred)) {
                                unstable = true;
                            }
                            if (this._makePreds) {
                                vw[0].set(row, pred);
                            }
                            if (this._computeMetrics) {
                                this._mb.perRow(new double[]{pred}, actual, (Model)DeepWaterModel.this);
                            }
                        }
                        ++row;
                    }
                    if (this._makePreds) {
                        for (Vec.Writer aVw : vw) {
                            aVw.close(fs);
                        }
                        fs.blockForPending();
                    }
                    if (!unstable) continue;
                    ((DeepWaterModel)DeepWaterModel.this).model_info._unstable = true;
                    Log.err((Object[])new Object[]{unstable_msg});
                    throw new UnsupportedOperationException(unstable_msg);
                }
                if (this._j != null) {
                    this._j.update((long)this._fr.anyVec().nChunks());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        DeepWaterBigScore(String[] domain, int ncols, double[] mean, boolean testHasWeights, boolean computeMetrics, boolean makePreds, Job j) {
            super((Model)DeepWaterModel.this, domain, ncols, mean, testHasWeights, computeMetrics, makePreds, j);
        }
    }
}

