/*
 * Decompiled with CFR 0.152.
 */
package hex.deepwater;

import hex.deepwater.DeepWaterModelInfo;
import hex.deepwater.DeepWaterTask;
import water.Job;
import water.Key;
import water.MRTask;
import water.fvec.Frame;

class DeepWaterTask2
extends MRTask<DeepWaterTask2> {
    private final Key _jobKey;
    private final Frame _fr;
    private DeepWaterModelInfo _sharedmodel;
    private final float _sync_fraction;
    private DeepWaterTask _res;

    DeepWaterTask2(Key jobKey, Frame train, DeepWaterModelInfo model_info, float sync_fraction, int iteration) {
        assert (sync_fraction > 0.0f);
        this._jobKey = jobKey;
        this._fr = train;
        this._sharedmodel = model_info;
        this._sync_fraction = sync_fraction;
    }

    public DeepWaterModelInfo model_info() {
        return this._sharedmodel;
    }

    public void setupLocal() {
        super.setupLocal();
        this._res = new DeepWaterTask(this._sharedmodel, this._sync_fraction, (Job)this._jobKey.get());
        this.addToPendingCount(1);
        this._res.dfork(null, this._fr, true);
    }

    public void reduce(DeepWaterTask2 drt) {
        if (this._res == null) {
            this._res = drt._res;
        } else {
            this._res.model_info().add(drt._res.model_info());
        }
        assert (this._res.model_info().get_params()._replicate_training_data);
    }

    protected void postGlobal() {
        assert (this._res.model_info().get_params()._replicate_training_data);
        super.postGlobal();
        this._res.model_info().add_processed_global(this._res.model_info().get_processed_local());
        this._res.model_info().set_processed_local(0L);
        this._sharedmodel = this._res.model_info();
    }
}

