/*
 * Decompiled with CFR 0.152.
 */
package hex.ensemble;

import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.StackedEnsembleModel;
import hex.deeplearning.DeepLearning;
import hex.deeplearning.DeepLearningModel;
import hex.glm.GLM;
import hex.glm.GLMModel;
import hex.tree.drf.DRF;
import hex.tree.drf.DRFModel;
import hex.tree.gbm.GBM;
import hex.tree.gbm.GBMModel;
import java.util.ArrayList;
import java.util.Arrays;
import water.DKV;
import water.Job;
import water.Key;
import water.Keyed;
import water.exceptions.H2OIllegalArgumentException;
import water.exceptions.H2OModelBuilderIllegalArgumentException;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.Log;

public class StackedEnsemble
extends ModelBuilder<StackedEnsembleModel, StackedEnsembleModel.StackedEnsembleParameters, StackedEnsembleModel.StackedEnsembleOutput> {
    StackedEnsembleDriver _driver;
    protected StackedEnsembleModel _model;

    public StackedEnsemble(StackedEnsembleModel.StackedEnsembleParameters parms) {
        super((Model.Parameters)parms);
        this.init(false);
    }

    public StackedEnsemble(boolean startup_once) {
        super((Model.Parameters)new StackedEnsembleModel.StackedEnsembleParameters(), startup_once);
    }

    public ModelCategory[] can_build() {
        return new ModelCategory[]{ModelCategory.Regression, ModelCategory.Binomial, ModelCategory.Multinomial};
    }

    public ModelBuilder.BuilderVisibility builderVisibility() {
        return ModelBuilder.BuilderVisibility.Stable;
    }

    public boolean isSupervised() {
        return true;
    }

    protected StackedEnsembleDriver trainModelImpl() {
        this._driver = new StackedEnsembleDriver();
        return this._driver;
    }

    public boolean haveMojo() {
        return true;
    }

    public static void addModelPredictionsToLevelOneFrame(Model aModel, Frame aModelsPredictions, Frame levelOneFrame) {
        if (aModel._output.isBinomialClassifier()) {
            Vec preds = aModelsPredictions.vec(2);
            levelOneFrame.add(aModel._key.toString(), preds);
        } else if (aModel._output.isMultinomialClassifier()) {
            levelOneFrame.add(aModelsPredictions);
        } else {
            if (aModel._output.isAutoencoder()) {
                throw new H2OIllegalArgumentException("Don't yet know how to stack autoencoders: " + aModel._key);
            }
            if (!aModel._output.isSupervised()) {
                throw new H2OIllegalArgumentException("Don't yet know how to stack unsupervised models: " + aModel._key);
            }
            levelOneFrame.add(aModel._key.toString(), aModelsPredictions.vec("predict"));
        }
    }

    private class StackedEnsembleDriver
    extends ModelBuilder.Driver {
        private StackedEnsembleDriver() {
            super((ModelBuilder)StackedEnsemble.this);
        }

        private Frame prepareLevelOneFrame(String levelOneKey, Model[] baseModels, Frame[] baseModelPredictions, Frame actuals) {
            if (null == baseModels) {
                throw new H2OIllegalArgumentException("Base models array is null.");
            }
            if (null == baseModelPredictions) {
                throw new H2OIllegalArgumentException("Base model predictions array is null.");
            }
            if (baseModels.length == 0) {
                throw new H2OIllegalArgumentException("Base models array is empty.");
            }
            if (baseModelPredictions.length == 0) {
                throw new H2OIllegalArgumentException("Base model predictions array is empty.");
            }
            if (baseModels.length != baseModelPredictions.length) {
                throw new H2OIllegalArgumentException("Base models and prediction arrays are different lengths.");
            }
            if (null == levelOneKey) {
                levelOneKey = "levelone_" + StackedEnsemble.this._model._key.toString();
            }
            Frame levelOneFrame = new Frame(Key.make((String)levelOneKey));
            for (int i = 0; i < baseModels.length; ++i) {
                Model baseModel = baseModels[i];
                Frame baseModelPreds = baseModelPredictions[i];
                if (null == baseModel) {
                    Log.warn((Object[])new Object[]{"Failed to find base model; skipping: " + baseModels[i]});
                    continue;
                }
                if (null == baseModelPreds) {
                    Log.warn((Object[])new Object[]{"Failed to find base model " + baseModel + " predictions; skipping: " + baseModelPreds._key});
                    continue;
                }
                StackedEnsemble.addModelPredictionsToLevelOneFrame(baseModel, baseModelPreds, levelOneFrame);
            }
            if (((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms)._metalearner_fold_column != null) {
                levelOneFrame.add(((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms)._metalearner_fold_column, actuals.vec(((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms)._metalearner_fold_column));
            }
            levelOneFrame.add(StackedEnsemble.this._model.responseColumn, actuals.vec(StackedEnsemble.this._model.responseColumn));
            Frame old = (Frame)DKV.getGet((Key)levelOneFrame._key);
            if (old != null && old instanceof Frame) {
                Frame oldFrame = old;
                oldFrame.removeAll();
                oldFrame.write_lock(StackedEnsemble.this._job);
                oldFrame.update(StackedEnsemble.this._job);
                oldFrame.unlock(StackedEnsemble.this._job);
            }
            levelOneFrame.delete_and_lock(StackedEnsemble.this._job);
            levelOneFrame.unlock(StackedEnsemble.this._job);
            Log.info((Object[])new Object[]{"Finished creating \"level one\" frame for stacking: " + levelOneFrame.toString()});
            DKV.put((Keyed)levelOneFrame);
            return levelOneFrame;
        }

        private Frame prepareTrainingLevelOneFrame(StackedEnsembleModel.StackedEnsembleParameters parms) {
            String levelOneKey = "levelone_training_" + StackedEnsemble.this._model._key.toString();
            ArrayList<Model> baseModels = new ArrayList<Model>();
            ArrayList<Frame> baseModelPredictions = new ArrayList<Frame>();
            for (Key<Model> k : parms._base_models) {
                Model aModel = (Model)DKV.getGet(k);
                if (null == aModel) {
                    throw new H2OIllegalArgumentException("Failed to find base model: " + k);
                }
                if (null == aModel._output._cross_validation_holdout_predictions_frame_id) {
                    throw new H2OIllegalArgumentException("Failed to find the xval predictions frame id. . .  Looks like keep_cross_validation_predictions wasn't set when building the models.");
                }
                Frame aFrame = (Frame)DKV.getGet((Key)aModel._output._cross_validation_holdout_predictions_frame_id);
                if (null == aFrame) {
                    throw new H2OIllegalArgumentException("Failed to find the xval predictions frame. . .  Looks like keep_cross_validation_predictions wasn't set when building the models, or the frame was deleted.");
                }
                baseModels.add(aModel);
                if (!aModel._output.isMultinomialClassifier()) {
                    baseModelPredictions.add(aFrame);
                    continue;
                }
                ArrayList<String> predColNames = new ArrayList<String>(Arrays.asList(aFrame.names()));
                predColNames.remove("predict");
                String[] multClassNames = predColNames.toArray(new String[0]);
                baseModelPredictions.add(aFrame.subframe(multClassNames));
            }
            return this.prepareLevelOneFrame(levelOneKey, baseModels.toArray(new Model[0]), baseModelPredictions.toArray(new Frame[0]), ((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms).train());
        }

        private Key<Frame> buildPredsKey(Key model_key, long model_checksum, Key frame_key, long frame_checksum) {
            return Key.make((String)("preds_" + model_checksum + "_on_" + frame_checksum));
        }

        private Key<Frame> buildPredsKey(Model model, Frame frame) {
            return frame == null || model == null ? null : this.buildPredsKey(model._key, model.checksum(), frame._key, frame.checksum());
        }

        private Frame prepareValidationLevelOneFrame(String levelOneKey, Key<Model>[] baseModelKeys, Frame actuals) {
            ArrayList<Model> baseModels = new ArrayList<Model>();
            ArrayList<Frame> baseModelPredictions = new ArrayList<Frame>();
            for (Key<Model> k : baseModelKeys) {
                Model aModel = (Model)DKV.getGet(k);
                if (null == aModel) {
                    throw new H2OIllegalArgumentException("Failed to find base model: " + k);
                }
                Key<Frame> predsKey = this.buildPredsKey(aModel, actuals);
                Frame aPred = aModel.score(actuals, predsKey.toString());
                baseModels.add(aModel);
                if (!aModel._output.isMultinomialClassifier()) {
                    baseModelPredictions.add(aPred);
                    continue;
                }
                ArrayList<String> predColNames = new ArrayList<String>(Arrays.asList(aPred.names()));
                predColNames.remove("predict");
                String[] multClassNames = predColNames.toArray(new String[0]);
                baseModelPredictions.add(aPred.subframe(multClassNames));
            }
            Frame levelOne = this.prepareLevelOneFrame(levelOneKey, baseModels.toArray(new Model[0]), baseModelPredictions.toArray(new Frame[0]), actuals);
            for (Frame aPred : baseModelPredictions) {
                Frame.deleteTempFrameAndItsNonSharedVecs((Frame)aPred, (Frame)levelOne);
            }
            return levelOne;
        }

        public void computeImpl() {
            StackedEnsemble.this.init(true);
            if (StackedEnsemble.this.error_count() > 0) {
                throw H2OModelBuilderIllegalArgumentException.makeFromBuilder((ModelBuilder)StackedEnsemble.this);
            }
            StackedEnsemble.this._model = new StackedEnsembleModel(StackedEnsemble.this.dest(), (StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._parms, new StackedEnsembleModel.StackedEnsembleOutput(StackedEnsemble.this));
            StackedEnsemble.this._model.delete_and_lock(StackedEnsemble.this._job);
            StackedEnsemble.this._model.checkAndInheritModelProperties();
            Frame levelOneTrainingFrame = this.prepareTrainingLevelOneFrame((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._parms);
            Frame levelOneValidationFrame = null;
            if (((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms).valid() != null) {
                String levelOneKey = "levelone_validation_" + StackedEnsemble.this._model._key.toString();
                levelOneValidationFrame = this.prepareValidationLevelOneFrame(levelOneKey, ((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms)._base_models, ((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms).valid());
            }
            this.computeMetaLearner(levelOneTrainingFrame, levelOneValidationFrame, ((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms)._metalearner_algorithm);
        }

        private void computeMetaLearner(Frame levelOneTrainingFrame, Frame levelOneValidationFrame, StackedEnsembleModel.StackedEnsembleParameters.MetalearnerAlgorithm metalearner_algo) {
            Key metalearnerKey = Key.make((String)("metalearner_" + (Object)((Object)((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms)._metalearner_algorithm) + "_" + StackedEnsemble.this._model._key));
            Job job = new Job(metalearnerKey, ((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms)._metalearner_algorithm.toString(), "StackingEnsemble metalearner (" + (Object)((Object)((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms)._metalearner_algorithm) + ")");
            if (metalearner_algo.equals((Object)StackedEnsembleModel.StackedEnsembleParameters.MetalearnerAlgorithm.AUTO)) {
                GLM metaGLMBuilder = (GLM)ModelBuilder.make((String)"GLM", (Job)job, (Key)metalearnerKey);
                ((GLMModel.GLMParameters)metaGLMBuilder._parms)._non_negative = true;
                ((GLMModel.GLMParameters)metaGLMBuilder._parms)._train = levelOneTrainingFrame._key;
                ((GLMModel.GLMParameters)metaGLMBuilder._parms)._valid = levelOneValidationFrame == null ? null : levelOneValidationFrame._key;
                ((GLMModel.GLMParameters)metaGLMBuilder._parms)._response_column = StackedEnsemble.this._model.responseColumn;
                if (((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms)._metalearner_fold_column == null) {
                    ((GLMModel.GLMParameters)metaGLMBuilder._parms)._nfolds = ((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms)._metalearner_nfolds;
                    if (((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms)._metalearner_nfolds > 1) {
                        ((GLMModel.GLMParameters)metaGLMBuilder._parms)._fold_assignment = ((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms)._metalearner_fold_assignment == null ? Model.Parameters.FoldAssignmentScheme.AUTO : ((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms)._metalearner_fold_assignment;
                    }
                } else {
                    ((GLMModel.GLMParameters)metaGLMBuilder._parms)._fold_column = ((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms)._metalearner_fold_column;
                }
                if (((GLMModel.GLMParameters)metaGLMBuilder._parms)._valid != null) {
                    ((GLMModel.GLMParameters)metaGLMBuilder._parms)._lambda_search = true;
                    ((GLMModel.GLMParameters)metaGLMBuilder._parms)._early_stopping = false;
                }
                if (StackedEnsemble.this._model.modelCategory == ModelCategory.Regression) {
                    ((GLMModel.GLMParameters)metaGLMBuilder._parms)._family = GLMModel.GLMParameters.Family.gaussian;
                } else if (StackedEnsemble.this._model.modelCategory == ModelCategory.Binomial) {
                    ((GLMModel.GLMParameters)metaGLMBuilder._parms)._family = GLMModel.GLMParameters.Family.binomial;
                } else if (StackedEnsemble.this._model.modelCategory == ModelCategory.Multinomial) {
                    ((GLMModel.GLMParameters)metaGLMBuilder._parms)._family = GLMModel.GLMParameters.Family.multinomial;
                } else {
                    throw new H2OIllegalArgumentException("Family " + StackedEnsemble.this._model.modelCategory + "  is not supported.");
                }
                metaGLMBuilder.init(false);
                Job j = metaGLMBuilder.trainModel();
                while (j.isRunning()) {
                    try {
                        StackedEnsemble.this._job.update(j._work, "training metalearner(" + (Object)((Object)((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms)._metalearner_algorithm) + ")");
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                Log.info((Object[])new Object[]{"Finished training metalearner model(" + (Object)((Object)((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms)._metalearner_algorithm) + ")."});
                ((StackedEnsembleModel.StackedEnsembleOutput)StackedEnsemble.this._model._output)._metalearner = metaGLMBuilder.get();
                StackedEnsemble.this._model.doScoreOrCopyMetrics(StackedEnsemble.this._job);
                if (((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._parms)._keep_levelone_frame) {
                    ((StackedEnsembleModel.StackedEnsembleOutput)StackedEnsemble.this._model._output)._levelone_frame_id = levelOneTrainingFrame;
                } else {
                    DKV.remove((Key)levelOneTrainingFrame._key);
                }
                if (null != levelOneValidationFrame) {
                    DKV.remove((Key)levelOneValidationFrame._key);
                }
                StackedEnsemble.this._model.update(StackedEnsemble.this._job);
                StackedEnsemble.this._model.unlock(StackedEnsemble.this._job);
            } else if (metalearner_algo.equals((Object)StackedEnsembleModel.StackedEnsembleParameters.MetalearnerAlgorithm.glm)) {
                GLM metaGLMBuilder = (GLM)ModelBuilder.make((String)"GLM", (Job)job, (Key)metalearnerKey);
                ((GLMModel.GLMParameters)metaGLMBuilder._parms)._train = levelOneTrainingFrame._key;
                ((GLMModel.GLMParameters)metaGLMBuilder._parms)._valid = levelOneValidationFrame == null ? null : levelOneValidationFrame._key;
                ((GLMModel.GLMParameters)metaGLMBuilder._parms)._response_column = StackedEnsemble.this._model.responseColumn;
                ((GLMModel.GLMParameters)metaGLMBuilder._parms)._nfolds = ((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms)._metalearner_nfolds;
                if (((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms)._metalearner_fold_column == null) {
                    ((GLMModel.GLMParameters)metaGLMBuilder._parms)._nfolds = ((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms)._metalearner_nfolds;
                    if (((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms)._metalearner_nfolds > 1) {
                        ((GLMModel.GLMParameters)metaGLMBuilder._parms)._fold_assignment = ((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms)._metalearner_fold_assignment == null ? Model.Parameters.FoldAssignmentScheme.AUTO : ((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms)._metalearner_fold_assignment;
                    }
                } else {
                    ((GLMModel.GLMParameters)metaGLMBuilder._parms)._fold_column = ((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms)._metalearner_fold_column;
                }
                if (StackedEnsemble.this._model.modelCategory == ModelCategory.Regression) {
                    ((GLMModel.GLMParameters)metaGLMBuilder._parms)._family = GLMModel.GLMParameters.Family.gaussian;
                } else if (StackedEnsemble.this._model.modelCategory == ModelCategory.Binomial) {
                    ((GLMModel.GLMParameters)metaGLMBuilder._parms)._family = GLMModel.GLMParameters.Family.binomial;
                } else if (StackedEnsemble.this._model.modelCategory == ModelCategory.Multinomial) {
                    ((GLMModel.GLMParameters)metaGLMBuilder._parms)._family = GLMModel.GLMParameters.Family.multinomial;
                } else {
                    throw new H2OIllegalArgumentException("Family " + StackedEnsemble.this._model.modelCategory + "  is not supported.");
                }
                metaGLMBuilder.init(false);
                Job j = metaGLMBuilder.trainModel();
                while (j.isRunning()) {
                    try {
                        StackedEnsemble.this._job.update(j._work, "training metalearner(" + (Object)((Object)((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms)._metalearner_algorithm) + ")");
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                Log.info((Object[])new Object[]{"Finished training metalearner model(" + (Object)((Object)((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms)._metalearner_algorithm) + ")."});
                ((StackedEnsembleModel.StackedEnsembleOutput)StackedEnsemble.this._model._output)._metalearner = metaGLMBuilder.get();
                StackedEnsemble.this._model.doScoreOrCopyMetrics(StackedEnsemble.this._job);
                if (((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._parms)._keep_levelone_frame) {
                    ((StackedEnsembleModel.StackedEnsembleOutput)StackedEnsemble.this._model._output)._levelone_frame_id = levelOneTrainingFrame;
                } else {
                    DKV.remove((Key)levelOneTrainingFrame._key);
                }
                if (null != levelOneValidationFrame) {
                    DKV.remove((Key)levelOneValidationFrame._key);
                }
                StackedEnsemble.this._model.update(StackedEnsemble.this._job);
                StackedEnsemble.this._model.unlock(StackedEnsemble.this._job);
            } else if (metalearner_algo.equals((Object)StackedEnsembleModel.StackedEnsembleParameters.MetalearnerAlgorithm.gbm)) {
                GBM metaGBMBuilder = (GBM)ModelBuilder.make((String)"GBM", (Job)job, (Key)metalearnerKey);
                ((GBMModel.GBMParameters)metaGBMBuilder._parms)._train = levelOneTrainingFrame._key;
                ((GBMModel.GBMParameters)metaGBMBuilder._parms)._valid = levelOneValidationFrame == null ? null : levelOneValidationFrame._key;
                ((GBMModel.GBMParameters)metaGBMBuilder._parms)._response_column = StackedEnsemble.this._model.responseColumn;
                ((GBMModel.GBMParameters)metaGBMBuilder._parms)._nfolds = ((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms)._metalearner_nfolds;
                if (((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms)._metalearner_fold_column == null) {
                    ((GBMModel.GBMParameters)metaGBMBuilder._parms)._nfolds = ((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms)._metalearner_nfolds;
                    if (((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms)._metalearner_nfolds > 1) {
                        ((GBMModel.GBMParameters)metaGBMBuilder._parms)._fold_assignment = ((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms)._metalearner_fold_assignment == null ? Model.Parameters.FoldAssignmentScheme.AUTO : ((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms)._metalearner_fold_assignment;
                    }
                } else {
                    ((GBMModel.GBMParameters)metaGBMBuilder._parms)._fold_column = ((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms)._metalearner_fold_column;
                }
                metaGBMBuilder.init(false);
                Job j = metaGBMBuilder.trainModel();
                while (j.isRunning()) {
                    try {
                        StackedEnsemble.this._job.update(j._work, "training metalearner(" + (Object)((Object)((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms)._metalearner_algorithm) + ")");
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                Log.info((Object[])new Object[]{"Finished training metalearner model(" + (Object)((Object)((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms)._metalearner_algorithm) + ")."});
                ((StackedEnsembleModel.StackedEnsembleOutput)StackedEnsemble.this._model._output)._metalearner = metaGBMBuilder.get();
                StackedEnsemble.this._model.doScoreOrCopyMetrics(StackedEnsemble.this._job);
                if (((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._parms)._keep_levelone_frame) {
                    ((StackedEnsembleModel.StackedEnsembleOutput)StackedEnsemble.this._model._output)._levelone_frame_id = levelOneTrainingFrame;
                } else {
                    DKV.remove((Key)levelOneTrainingFrame._key);
                }
                if (null != levelOneValidationFrame) {
                    DKV.remove((Key)levelOneValidationFrame._key);
                }
                StackedEnsemble.this._model.update(StackedEnsemble.this._job);
                StackedEnsemble.this._model.unlock(StackedEnsemble.this._job);
            } else if (metalearner_algo.equals((Object)StackedEnsembleModel.StackedEnsembleParameters.MetalearnerAlgorithm.drf)) {
                DRF metaDRFBuilder = (DRF)ModelBuilder.make((String)"DRF", (Job)job, (Key)metalearnerKey);
                ((DRFModel.DRFParameters)metaDRFBuilder._parms)._train = levelOneTrainingFrame._key;
                ((DRFModel.DRFParameters)metaDRFBuilder._parms)._valid = levelOneValidationFrame == null ? null : levelOneValidationFrame._key;
                ((DRFModel.DRFParameters)metaDRFBuilder._parms)._response_column = StackedEnsemble.this._model.responseColumn;
                ((DRFModel.DRFParameters)metaDRFBuilder._parms)._nfolds = ((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms)._metalearner_nfolds;
                if (((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms)._metalearner_fold_column == null) {
                    ((DRFModel.DRFParameters)metaDRFBuilder._parms)._nfolds = ((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms)._metalearner_nfolds;
                    if (((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms)._metalearner_nfolds > 1) {
                        ((DRFModel.DRFParameters)metaDRFBuilder._parms)._fold_assignment = ((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms)._metalearner_fold_assignment == null ? Model.Parameters.FoldAssignmentScheme.AUTO : ((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms)._metalearner_fold_assignment;
                    }
                } else {
                    ((DRFModel.DRFParameters)metaDRFBuilder._parms)._fold_column = ((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms)._metalearner_fold_column;
                }
                metaDRFBuilder.init(false);
                Job j = metaDRFBuilder.trainModel();
                while (j.isRunning()) {
                    try {
                        StackedEnsemble.this._job.update(j._work, "training metalearner(" + (Object)((Object)((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms)._metalearner_algorithm) + ")");
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                Log.info((Object[])new Object[]{"Finished training metalearner model(" + (Object)((Object)((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms)._metalearner_algorithm) + ")."});
                ((StackedEnsembleModel.StackedEnsembleOutput)StackedEnsemble.this._model._output)._metalearner = metaDRFBuilder.get();
                StackedEnsemble.this._model.doScoreOrCopyMetrics(StackedEnsemble.this._job);
                if (((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._parms)._keep_levelone_frame) {
                    ((StackedEnsembleModel.StackedEnsembleOutput)StackedEnsemble.this._model._output)._levelone_frame_id = levelOneTrainingFrame;
                } else {
                    DKV.remove((Key)levelOneTrainingFrame._key);
                }
                if (null != levelOneValidationFrame) {
                    DKV.remove((Key)levelOneValidationFrame._key);
                }
                StackedEnsemble.this._model.update(StackedEnsemble.this._job);
                StackedEnsemble.this._model.unlock(StackedEnsemble.this._job);
            } else if (metalearner_algo.equals((Object)StackedEnsembleModel.StackedEnsembleParameters.MetalearnerAlgorithm.deeplearning)) {
                DeepLearning metaDeepLearningBuilder = (DeepLearning)ModelBuilder.make((String)"DeepLearning", (Job)job, (Key)metalearnerKey);
                ((DeepLearningModel.DeepLearningParameters)metaDeepLearningBuilder._parms)._train = levelOneTrainingFrame._key;
                ((DeepLearningModel.DeepLearningParameters)metaDeepLearningBuilder._parms)._valid = levelOneValidationFrame == null ? null : levelOneValidationFrame._key;
                ((DeepLearningModel.DeepLearningParameters)metaDeepLearningBuilder._parms)._response_column = StackedEnsemble.this._model.responseColumn;
                ((DeepLearningModel.DeepLearningParameters)metaDeepLearningBuilder._parms)._nfolds = ((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms)._metalearner_nfolds;
                if (((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms)._metalearner_fold_column == null) {
                    ((DeepLearningModel.DeepLearningParameters)metaDeepLearningBuilder._parms)._nfolds = ((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms)._metalearner_nfolds;
                    if (((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms)._metalearner_nfolds > 1) {
                        ((DeepLearningModel.DeepLearningParameters)metaDeepLearningBuilder._parms)._fold_assignment = ((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms)._metalearner_fold_assignment == null ? Model.Parameters.FoldAssignmentScheme.AUTO : ((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms)._metalearner_fold_assignment;
                    }
                } else {
                    ((DeepLearningModel.DeepLearningParameters)metaDeepLearningBuilder._parms)._fold_column = ((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms)._metalearner_fold_column;
                }
                metaDeepLearningBuilder.init(false);
                Job j = metaDeepLearningBuilder.trainModel();
                while (j.isRunning()) {
                    try {
                        StackedEnsemble.this._job.update(j._work, "training metalearner(" + (Object)((Object)((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms)._metalearner_algorithm) + ")");
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                Log.info((Object[])new Object[]{"Finished training metalearner model(" + (Object)((Object)((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms)._metalearner_algorithm) + ")."});
                ((StackedEnsembleModel.StackedEnsembleOutput)StackedEnsemble.this._model._output)._metalearner = metaDeepLearningBuilder.get();
                StackedEnsemble.this._model.doScoreOrCopyMetrics(StackedEnsemble.this._job);
                if (((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._parms)._keep_levelone_frame) {
                    ((StackedEnsembleModel.StackedEnsembleOutput)StackedEnsemble.this._model._output)._levelone_frame_id = levelOneTrainingFrame;
                } else {
                    DKV.remove((Key)levelOneTrainingFrame._key);
                }
                if (null != levelOneValidationFrame) {
                    DKV.remove((Key)levelOneValidationFrame._key);
                }
                StackedEnsemble.this._model.update(StackedEnsemble.this._job);
                StackedEnsemble.this._model.unlock(StackedEnsemble.this._job);
            } else {
                throw new H2OIllegalArgumentException("Invalid `metalearner_algorithm`. Passed in " + (Object)((Object)((StackedEnsembleModel.StackedEnsembleParameters)StackedEnsemble.this._model._parms)._metalearner_algorithm) + " but must be one of 'glm', 'gbm', 'randomForest', or 'deeplearning'.");
            }
        }
    }
}

