/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.genmodel.utils.DistributionFamily;
import hex.tree.DHistogram;
import hex.tree.DTree;
import water.H2O;
import water.MRTask;
import water.fvec.C0DChunk;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.util.ArrayUtils;

public class ScoreBuildHistogram
extends MRTask<ScoreBuildHistogram> {
    final int _k;
    final int _ncols;
    final int _nbins;
    final int _nbins_cats;
    final DTree _tree;
    final int _leaf;
    DHistogram[][] _hcs;
    final DistributionFamily _family;
    final int _weightIdx;
    final int _workIdx;
    final int _nidIdx;
    public static final int DECIDED_ROW = -1;
    public static final int OUT_OF_BAG = -2;
    public static final int MISSING_RESPONSE = -1;
    public static final int UNDECIDED_CHILD_NODE_ID = -1;
    public static final int FRESH = 0;

    public ScoreBuildHistogram(H2O.H2OCountedCompleter cc, int k, int ncols, int nbins, int nbins_cats, DTree tree, int leaf, DHistogram[][] hcs, DistributionFamily family, int weightIdx, int workIdx, int nidIdx) {
        super(cc);
        this._k = k;
        this._ncols = ncols;
        this._nbins = nbins;
        this._nbins_cats = nbins_cats;
        this._tree = tree;
        this._leaf = leaf;
        this._hcs = hcs;
        this._family = family;
        this._weightIdx = weightIdx;
        this._workIdx = workIdx;
        this._nidIdx = nidIdx;
    }

    public ScoreBuildHistogram dfork2(byte[] types, Frame fr, boolean run_local) {
        return (ScoreBuildHistogram)this.dfork(types, fr, run_local);
    }

    public static boolean isOOBRow(int nid) {
        return nid <= -2;
    }

    public static boolean isDecidedRow(int nid) {
        return nid == -1;
    }

    public static int oob2Nid(int oobNid) {
        return -oobNid + -2;
    }

    public static int nid2Oob(int nid) {
        return -nid + -2;
    }

    public void setupLocal() {
        this._tree.init_tree();
        for (int l = this._leaf; l < this._tree._len; ++l) {
            DTree.UndecidedNode udn = this._tree.undecided(l);
            DHistogram[] hs = this._hcs[l - this._leaf];
            int[] sCols = udn._scoreCols;
            if (sCols != null) {
                for (int col : sCols) {
                    hs[col].init();
                }
                continue;
            }
            for (int j = 0; j < this._ncols; ++j) {
                if (hs[j] == null) continue;
                hs[j].init();
            }
        }
    }

    public void map(Chunk[] chks) {
        Chunk wrks = chks[this._workIdx];
        Chunk nids = chks[this._nidIdx];
        C0DChunk weight = this._weightIdx >= 0 ? chks[this._weightIdx] : new C0DChunk(1.0, chks[0].len());
        int[] nnids = new int[nids._len];
        if (this._leaf > 0) {
            this.score_decide(chks, nids, nnids);
        } else {
            for (int row = 0; row < nids._len; ++row) {
                if (weight.atd(row) == 0.0 || !ScoreBuildHistogram.isDecidedRow((int)nids.atd(row))) continue;
                nnids[row] = -1;
            }
        }
        this.accum_all(chks, wrks, (Chunk)weight, nnids);
    }

    public void reduce(ScoreBuildHistogram sbh) {
        if (sbh._hcs == this._hcs) {
            return;
        }
        for (int i = 0; i < this._hcs.length; ++i) {
            DHistogram[] hs1 = this._hcs[i];
            DHistogram[] hs2 = sbh._hcs[i];
            if (hs1 == null) {
                this._hcs[i] = hs2;
                continue;
            }
            if (hs2 == null) continue;
            for (int j = 0; j < hs1.length; ++j) {
                if (hs1[j] == null) {
                    hs1[j] = hs2[j];
                    continue;
                }
                if (hs2[j] == null) continue;
                hs1[j].add(hs2[j]);
            }
        }
    }

    protected void score_decide(Chunk[] chks, Chunk nids, int[] nnids) {
        for (int row = 0; row < nids._len; ++row) {
            DTree.DecidedNode dn;
            int nid = (int)nids.at8(row);
            if (ScoreBuildHistogram.isDecidedRow(nid)) {
                nnids[row] = nid - this._leaf;
                continue;
            }
            boolean oob = ScoreBuildHistogram.isOOBRow(nid);
            if (oob) {
                nid = ScoreBuildHistogram.oob2Nid(nid);
            }
            if ((dn = this._tree.decided(nid)) == null || dn._split == null) {
                if (DTree.isRootNode(dn)) {
                    nnids[row] = nid - this._leaf;
                    continue;
                }
                nid = dn._pid;
                int xnid = oob ? ScoreBuildHistogram.nid2Oob(nid) : nid;
                nids.set(row, (long)xnid);
                nnids[row] = xnid - this._leaf;
                dn = this._tree.decided(nid);
            }
            assert (!ScoreBuildHistogram.isDecidedRow(nid));
            nid = dn.getChildNodeID(chks, row);
            if (!ScoreBuildHistogram.isDecidedRow(nid)) {
                if (oob) {
                    nid = ScoreBuildHistogram.nid2Oob(nid);
                }
                nids.set(row, (long)nid);
            }
            nnids[row] = nid - this._leaf;
        }
    }

    private void accum_subset(Chunk[] chks, Chunk wrks, Chunk weight, int[] nnids) {
        for (int row = 0; row < nnids.length; ++row) {
            double w;
            int nid = nnids[row];
            if (nid < 0 || (w = weight.atd(row)) == 0.0) continue;
            double resp = wrks.atd(row);
            assert (!Double.isNaN(wrks.atd(row)));
            DHistogram[] nhs = this._hcs[nid];
            int[] sCols = this._tree.undecided((int)(nid + this._leaf))._scoreCols;
            if (sCols == null) {
                for (int col = 0; col < nhs.length; ++col) {
                    if (nhs[col] == null) continue;
                    nhs[col].incr(chks[col].atd(row), resp, w);
                }
                continue;
            }
            for (int col : sCols) {
                nhs[col].incr(chks[col].atd(row), resp, w);
            }
        }
    }

    private void accum_all(Chunk[] chks, Chunk wrks, Chunk weight, int[] nnids) {
        int[] nh = new int[this._hcs.length + 1];
        for (int i : nnids) {
            if (i < 0) continue;
            int n = i + 1;
            nh[n] = nh[n] + 1;
        }
        for (int i = 0; i < this._hcs.length; ++i) {
            int n = i + 1;
            nh[n] = nh[n] + nh[i];
        }
        int[] rows = new int[nnids.length];
        for (int row = 0; row < nnids.length; ++row) {
            if (nnids[row] < 0) continue;
            int n = nnids[row];
            int n2 = nh[n];
            nh[n] = n2 + 1;
            rows[n2] = row;
        }
        DHistogram[][] hcs = this._hcs;
        if (hcs.length == 0) {
            return;
        }
        LocalHisto lh = new LocalHisto(Math.max(this._nbins, this._nbins_cats));
        int cols = this._ncols;
        int hcslen = hcs.length;
        double[] ws = new double[chks[0]._len];
        double[] cs = new double[chks[0]._len];
        double[] ys = new double[chks[0]._len];
        weight.getDoubles(ws, 0, ws.length);
        wrks.getDoubles(ys, 0, ys.length);
        for (int c = 0; c < cols; ++c) {
            boolean extracted = false;
            for (int n = 0; n < hcslen; ++n) {
                DHistogram h;
                int[] sCols = this._tree.undecided((int)(n + this._leaf))._scoreCols;
                if (sCols != null && ArrayUtils.find((int[])sCols, (int)c) < 0) continue;
                if (!extracted) {
                    chks[c].getDoubles(cs, 0, cs.length);
                    extracted = true;
                }
                if ((h = hcs[n][c]) == null) continue;
                lh.resizeIfNeeded(h._nbin);
                h.updateSharedHistosAndReset(lh, ws, cs, ys, rows, nh[n], n == 0 ? 0 : nh[n - 1]);
            }
        }
    }

    static class LocalHisto {
        private double[] bins;
        private double[] sums;
        private double[] ssqs;

        public void wAdd(int b, double val) {
            int n = b;
            this.bins[n] = this.bins[n] + val;
        }

        public void wYAdd(int b, double val) {
            int n = b;
            this.sums[n] = this.sums[n] + val;
        }

        public void wYYAdd(int b, double val) {
            int n = b;
            this.ssqs[n] = this.ssqs[n] + val;
        }

        public void wClear(int b) {
            this.bins[b] = 0.0;
        }

        public void wYClear(int b) {
            this.sums[b] = 0.0;
        }

        public void wYYClear(int b) {
            this.ssqs[b] = 0.0;
        }

        public double w(int b) {
            return this.bins[b];
        }

        public double wY(int b) {
            return this.sums[b];
        }

        public double wYY(int b) {
            return this.ssqs[b];
        }

        LocalHisto(int len) {
            this.bins = new double[len];
            this.sums = new double[len];
            this.ssqs = new double[len];
        }

        void resizeIfNeeded(int len) {
            if (len > this.bins.length) {
                this.bins = new double[len];
                this.sums = new double[len];
                this.ssqs = new double[len];
            }
        }
    }
}

