/*
 * Decompiled with CFR 0.152.
 */
package hex.coxph;

import hex.DataInfo;
import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.ModelMetricsRegression;
import hex.coxph.CoxPH;
import hex.schemas.CoxPHModelV3;
import water.Key;
import water.MemoryManager;
import water.api.schemas3.ModelSchemaV3;
import water.fvec.Vec;

public class CoxPHModel
extends Model<CoxPHModel, CoxPHParameters, CoxPHOutput> {
    public ModelMetrics.MetricBuilder makeMetricBuilder(String[] domain) {
        return new ModelMetricsRegression.MetricBuilderRegression();
    }

    public ModelSchemaV3 schema() {
        return new CoxPHModelV3();
    }

    public final CoxPHParameters get_params() {
        return (CoxPHParameters)this._parms;
    }

    public CoxPHModel(Key destKey, CoxPHParameters parms, CoxPHOutput output) {
        super(destKey, (Model.Parameters)parms, (Model.Output)output);
    }

    public double[] score0(double[] data, double[] preds) {
        int j;
        int n_offsets = ((CoxPHParameters)this._parms)._offset_column == null ? 0 : 1;
        int n_time = ((CoxPHOutput)this._output)._time.length;
        int n_coef = ((CoxPHOutput)this._output)._coef.length;
        int n_cats = ((CoxPHOutput)this._output).data_info._cats;
        int n_nums = ((CoxPHOutput)this._output).data_info._nums;
        int n_data = n_cats + n_nums;
        int n_full = n_coef + n_offsets;
        int numStart = ((CoxPHOutput)this._output).data_info.numStart();
        boolean catsAllNA = true;
        boolean catsHasNA = false;
        boolean numsHasNA = false;
        for (j = 0; j < n_cats; ++j) {
            catsAllNA &= Double.isNaN(data[j]);
            catsHasNA |= Double.isNaN(data[j]);
        }
        for (j = n_cats; j < n_data; ++j) {
            numsHasNA |= Double.isNaN(data[j]);
        }
        if (numsHasNA || catsHasNA && !catsAllNA) {
            for (int i = 1; i <= 2 * n_time; ++i) {
                preds[i] = Double.NaN;
            }
        } else {
            int t;
            int j2;
            int j3;
            double[] full_data = MemoryManager.malloc8d((int)n_full);
            for (j3 = 0; j3 < n_cats; ++j3) {
                if (Double.isNaN(data[j3])) {
                    int kst = ((CoxPHOutput)this._output).data_info._catOffsets[j3];
                    int klen = ((CoxPHOutput)this._output).data_info._catOffsets[j3 + 1] - kst;
                    System.arraycopy(((CoxPHOutput)this._output)._x_mean_cat, kst, full_data, kst, klen);
                    continue;
                }
                if (data[j3] == 0.0) continue;
                full_data[((CoxPHOutput)this._output).data_info._catOffsets[j3] + (int)(data[j3] - 1.0)] = 1.0;
            }
            for (j3 = 0; j3 < n_nums; ++j3) {
                full_data[numStart + j3] = data[n_cats + j3] - ((CoxPHOutput)this._output).data_info._normSub[j3];
            }
            double logRisk = 0.0;
            for (j2 = 0; j2 < n_coef; ++j2) {
                logRisk += full_data[j2] * ((CoxPHOutput)this._output)._coef[j2];
            }
            for (j2 = n_coef; j2 < full_data.length; ++j2) {
                logRisk += full_data[j2];
            }
            double risk = Math.exp(logRisk);
            for (t = 0; t < n_time; ++t) {
                preds[t + 1] = risk * ((CoxPHOutput)this._output)._cumhaz_0[t];
            }
            for (t = 0; t < n_time; ++t) {
                double cumhaz_0_t = ((CoxPHOutput)this._output)._cumhaz_0[t];
                double var_cumhaz_2_t = 0.0;
                for (int j4 = 0; j4 < n_coef; ++j4) {
                    double sum = 0.0;
                    for (int k = 0; k < n_coef; ++k) {
                        sum += ((CoxPHOutput)this._output)._var_coef[j4][k] * (full_data[k] * cumhaz_0_t - ((CoxPHOutput)this._output)._var_cumhaz_2[t][k]);
                    }
                    var_cumhaz_2_t += (full_data[j4] * cumhaz_0_t - ((CoxPHOutput)this._output)._var_cumhaz_2[t][j4]) * sum;
                }
                preds[t + 1 + n_time] = risk * Math.sqrt(((CoxPHOutput)this._output)._var_cumhaz_1[t] + var_cumhaz_2_t);
            }
        }
        preds[0] = Double.NaN;
        return preds;
    }

    public static class CoxPHOutput
    extends Model.Output {
        DataInfo data_info;
        double[] gradient;
        double[][] hessian;
        String[] _coef_names;
        double[] _coef;
        double[] _exp_coef;
        double[] _exp_neg_coef;
        double[] _se_coef;
        double[] _z_coef;
        double[][] _var_coef;
        double _null_loglik;
        double _loglik;
        double _loglik_test;
        double _wald_test;
        double _score_test;
        double _rsq;
        double _maxrsq;
        double _lre;
        int _iter;
        double[] _x_mean_cat;
        double[] _x_mean_num;
        double[] _mean_offset;
        String[] _offset_names;
        long _n;
        long _n_missing;
        long _total_event;
        long _min_time;
        long _max_time;
        long[] _time;
        double[] _n_risk;
        double[] _n_event;
        double[] _n_censor;
        double[] _cumhaz_0;
        double[] _var_cumhaz_1;
        double[][] _var_cumhaz_2;
        CoxPHParameters.CoxPHTies _ties;
        String _rcall;

        public CoxPHOutput(CoxPH coxPH) {
            super((ModelBuilder)coxPH);
            this._ties = ((CoxPHParameters)coxPH._parms)._ties;
            this._rcall = ((CoxPHParameters)coxPH._parms)._rcall;
        }

        public ModelCategory getModelCategory() {
            return ModelCategory.CoxPH;
        }
    }

    public static class CoxPHParameters
    extends Model.Parameters {
        public String _start_column;
        public String _stop_column;
        public CoxPHTies _ties = CoxPHTies.efron;
        public String _rcall;
        public double _init = 0.0;
        public double _lre_min = 9.0;
        public int _iter_max = 20;

        public String algoName() {
            return "CoxPH";
        }

        public String fullName() {
            return "Cox Proportional Hazards";
        }

        public String javaName() {
            return CoxPHModel.class.getName();
        }

        public long progressUnits() {
            return this._iter_max;
        }

        Vec startVec() {
            return this.train().vec(this._start_column);
        }

        Vec stopVec() {
            return this.train().vec(this._stop_column);
        }

        public static enum CoxPHTies {
            efron,
            breslow;

        }
    }
}

