/*
 * Decompiled with CFR 0.152.
 */
package hex.glm;

import hex.GainsLift;
import hex.Model;
import hex.ModelMetrics;
import hex.ModelMetricsBinomial;
import hex.ModelMetricsBinomialGLM;
import hex.ModelMetricsMultinomial;
import hex.ModelMetricsOrdinal;
import hex.ModelMetricsRegression;
import hex.ModelMetricsRegressionGLM;
import hex.ModelMetricsSupervised;
import hex.glm.GLMModel;
import water.H2O;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.ArrayUtils;
import water.util.MathUtils;

public class GLMMetricBuilder
extends ModelMetricsSupervised.MetricBuilderSupervised<GLMMetricBuilder> {
    double residual_deviance;
    double null_devince;
    long _nobs;
    double _aic;
    private double _aic2;
    final GLMModel.GLMWeightsFun _glmf;
    private final int _rank;
    ModelMetrics.MetricBuilder _metricBuilder;
    final boolean _intercept;
    private final double[] _ymu;
    final boolean _computeMetrics;
    transient double[] _ds = new double[3];
    transient float[] _yact = new float[1];

    public GLMMetricBuilder(String[] domain, double[] ymu, GLMModel.GLMWeightsFun glmf, int rank, boolean computeMetrics, boolean intercept) {
        super(domain == null ? 0 : domain.length, domain);
        this._rank = rank;
        this._glmf = glmf;
        this._computeMetrics = computeMetrics;
        this._intercept = intercept;
        this._ymu = ymu;
        if (this._computeMetrics) {
            switch (this._glmf._family) {
                case binomial: 
                case quasibinomial: {
                    this._metricBuilder = new ModelMetricsBinomial.MetricBuilderBinomial(domain);
                    break;
                }
                case multinomial: {
                    this._metricBuilder = new ModelMetricsMultinomial.MetricBuilderMultinomial(domain.length, domain);
                    ((ModelMetricsMultinomial.MetricBuilderMultinomial)this._metricBuilder)._priorDistribution = ymu;
                    break;
                }
                case ordinal: {
                    this._metricBuilder = new ModelMetricsOrdinal.MetricBuilderOrdinal(domain.length, domain);
                    ((ModelMetricsOrdinal.MetricBuilderOrdinal)this._metricBuilder)._priorDistribution = ymu;
                    break;
                }
                default: {
                    this._metricBuilder = new ModelMetricsRegression.MetricBuilderRegression();
                }
            }
        }
    }

    public double explainedDev() {
        throw H2O.unimpl();
    }

    public double[] perRow(double[] ds, float[] yact, Model m) {
        return this.perRow(ds, yact, 1.0, 0.0, m);
    }

    public double[] perRow(double[] ds, float[] yact, double weight, double offset, Model m) {
        if (weight == 0.0) {
            return ds;
        }
        this._metricBuilder.perRow(ds, yact, weight, offset, m);
        if (!ArrayUtils.hasNaNsOrInfs((double[])ds) && !ArrayUtils.hasNaNsOrInfs((float[])yact)) {
            if (this._glmf._family == GLMModel.GLMParameters.Family.multinomial || this._glmf._family == GLMModel.GLMParameters.Family.ordinal) {
                this.add2((double)yact[0], ds, weight, offset);
            } else if (this._glmf._family == GLMModel.GLMParameters.Family.binomial || this._glmf._family == GLMModel.GLMParameters.Family.quasibinomial) {
                this.add2((double)yact[0], ds[2], weight, offset);
            } else {
                this.add2((double)yact[0], ds[0], weight, offset);
            }
        }
        return ds;
    }

    public void add(double yreal, double[] ymodel, double weight, double offset) {
        if (weight == 0.0) {
            return;
        }
        this._yact[0] = (float)yreal;
        if (this._computeMetrics) {
            this._metricBuilder.perRow(ymodel, this._yact, weight, offset, null);
        }
        this.add2(yreal, ymodel, weight, offset);
    }

    public void add(double yreal, double ymodel, double weight, double offset) {
        if (weight == 0.0) {
            return;
        }
        this._yact[0] = (float)yreal;
        if (this._glmf._family == GLMModel.GLMParameters.Family.binomial || this._glmf._family == GLMModel.GLMParameters.Family.quasibinomial) {
            this._ds[1] = 1.0 - ymodel;
            this._ds[2] = ymodel;
        } else {
            this._ds[0] = ymodel;
        }
        if (this._computeMetrics) {
            assert (!(this._metricBuilder instanceof ModelMetricsMultinomial.MetricBuilderMultinomial) && !(this._metricBuilder instanceof ModelMetricsOrdinal.MetricBuilderOrdinal)) : "using incorrect add call for multinomial/ordinal";
            this._metricBuilder.perRow(this._ds, this._yact, weight, offset, null);
        }
        this.add2(yreal, ymodel, weight, offset);
    }

    private void add2(double yreal, double[] ymodel, double weight, double offset) {
        this._wcount += weight;
        ++this._nobs;
        int c = (int)yreal;
        this.residual_deviance -= 2.0 * weight * Math.log(ymodel[c + 1]);
        this.null_devince -= 2.0 * weight * Math.log(this._ymu[c]);
    }

    private void add2(double yreal, double ymodel, double weight, double offset) {
        this._wcount += weight;
        ++this._nobs;
        this.residual_deviance += weight * this._glmf.deviance(yreal, ymodel);
        this.null_devince = offset == 0.0 ? (this.null_devince += weight * this._glmf.deviance(yreal, this._ymu[0])) : (this.null_devince += weight * this._glmf.deviance(yreal, this._glmf.linkInv(offset + this._glmf.link(this._ymu[0]))));
        if (this._glmf._family == GLMModel.GLMParameters.Family.poisson) {
            long y = Math.round(yreal);
            double logfactorial = MathUtils.logFactorial((long)y);
            this._aic2 += weight * (yreal * Math.log(ymodel) - logfactorial - ymodel);
        }
    }

    public void reduce(GLMMetricBuilder v) {
        if (this._computeMetrics) {
            this._metricBuilder.reduce(v._metricBuilder);
        }
        this.residual_deviance += v.residual_deviance;
        this.null_devince += v.null_devince;
        this._nobs += v._nobs;
        this._aic2 += v._aic2;
        this._wcount += v._wcount;
    }

    public final double residualDeviance() {
        return this.residual_deviance;
    }

    public final long nullDOF() {
        return this._nobs - (long)(this._intercept ? 1 : 0);
    }

    public final long resDOF() {
        if (this._glmf._family == GLMModel.GLMParameters.Family.ordinal) {
            return this._nobs - (long)(this._rank / (this._nclasses - 1) + this._nclasses - 2);
        }
        return this._nobs - (long)this._rank;
    }

    protected void computeAIC() {
        this._aic = 0.0;
        switch (this._glmf._family) {
            case gaussian: {
                this._aic = (double)this._nobs * (Math.log(this.residual_deviance / (double)this._nobs * 2.0 * Math.PI) + 1.0) + 2.0;
                break;
            }
            case binomial: 
            case quasibinomial: {
                this._aic = this.residual_deviance;
                break;
            }
            case poisson: {
                this._aic = -2.0 * this._aic2;
                break;
            }
            case gamma: {
                this._aic = Double.NaN;
                break;
            }
            case multinomial: 
            case ordinal: 
            case tweedie: {
                this._aic = Double.NaN;
                break;
            }
            default: {
                assert (false) : "missing implementation for family " + (Object)((Object)this._glmf._family);
                break;
            }
        }
        this._aic += (double)(2 * this._rank);
    }

    public ModelMetrics makeModelMetrics(Model m, Frame f, Frame adaptedFrame, Frame preds) {
        GLMModel gm = (GLMModel)m;
        this.computeAIC();
        ModelMetrics metrics = this._metricBuilder.makeModelMetrics((Model)gm, f, null, null);
        if (this._glmf._family == GLMModel.GLMParameters.Family.binomial || this._glmf._family == GLMModel.GLMParameters.Family.quasibinomial) {
            ModelMetricsBinomial metricsBinommial = (ModelMetricsBinomial)metrics;
            GainsLift gl = null;
            if (preds != null) {
                Vec resp = f.vec(m._parms._response_column);
                Vec weights = f.vec(m._parms._weights_column);
                if (resp != null) {
                    gl = new GainsLift(preds.lastVec(), resp, weights);
                    gl.exec(m._output._job);
                }
            }
            metrics = new ModelMetricsBinomialGLM(m, f, metrics._nobs, metrics._MSE, this._domain, metricsBinommial._sigma, metricsBinommial._auc, metricsBinommial._logloss, this.residualDeviance(), this.null_devince, this._aic, this.nullDOF(), this.resDOF(), gl, this._customMetric);
        } else if (this._glmf._family == GLMModel.GLMParameters.Family.multinomial) {
            ModelMetricsMultinomial metricsMultinomial = (ModelMetricsMultinomial)metrics;
            metrics = new ModelMetricsBinomialGLM.ModelMetricsMultinomialGLM(m, f, metricsMultinomial._nobs, metricsMultinomial._MSE, metricsMultinomial._domain, metricsMultinomial._sigma, metricsMultinomial._cm, metricsMultinomial._hit_ratios, metricsMultinomial._logloss, this.residualDeviance(), this.null_devince, this._aic, this.nullDOF(), this.resDOF(), this._customMetric);
        } else if (this._glmf._family == GLMModel.GLMParameters.Family.ordinal) {
            ModelMetricsOrdinal metricsOrdinal = (ModelMetricsOrdinal)metrics;
            metrics = new ModelMetricsBinomialGLM.ModelMetricsOrdinalGLM(m, f, metricsOrdinal._nobs, metricsOrdinal._MSE, metricsOrdinal._domain, metricsOrdinal._sigma, metricsOrdinal._cm, metricsOrdinal._hit_ratios, metricsOrdinal._logloss, this.residualDeviance(), this.null_devince, this._aic, this.nullDOF(), this.resDOF(), this._customMetric);
        } else {
            ModelMetricsRegression metricsRegression = (ModelMetricsRegression)metrics;
            metrics = new ModelMetricsRegressionGLM(m, f, metricsRegression._nobs, metricsRegression._MSE, metricsRegression._sigma, metricsRegression._mean_absolute_error, metricsRegression._root_mean_squared_log_error, this.residualDeviance(), this.residualDeviance() / this._wcount, this.null_devince, this._aic, this.nullDOF(), this.resDOF(), this._customMetric);
        }
        return gm.addModelMetrics(metrics);
    }
}

