/*
 * Decompiled with CFR 0.152.
 */
package hex.api;

import hex.DataInfo;
import hex.Model;
import hex.glm.GLMModel;
import hex.gram.Gram;
import hex.schemas.DataInfoFrameV3;
import hex.schemas.GLMModelV3;
import hex.schemas.GLMRegularizationPathV3;
import hex.schemas.GramV3;
import hex.schemas.MakeGLMModelV3;
import java.util.Arrays;
import java.util.HashMap;
import water.DKV;
import water.Iced;
import water.Key;
import water.Keyed;
import water.MRTask;
import water.api.Handler;
import water.api.schemas3.KeyV3;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.InteractionWrappedVec;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.util.ArrayUtils;

public class MakeGLMModelHandler
extends Handler {
    public GLMModelV3 make_model(int version, MakeGLMModelV3 args) {
        GLMModel model = (GLMModel)DKV.getGet((Key)args.model.key());
        if (model == null) {
            throw new IllegalArgumentException("missing source model " + args.model);
        }
        String[] names = ((GLMModel.GLMOutput)model._output).coefficientNames();
        HashMap<String, Double> coefs = model.coefficients();
        for (int i = 0; i < args.names.length; ++i) {
            coefs.put(args.names[i], args.beta[i]);
        }
        double[] beta = (double[])model.beta().clone();
        for (int i = 0; i < beta.length; ++i) {
            beta[i] = (Double)coefs.get(names[i]);
        }
        GLMModel m = new GLMModel(args.dest != null ? args.dest.key() : Key.make(), (GLMModel.GLMParameters)model._parms, null, model._ymu, Double.NaN, Double.NaN, -1L);
        DataInfo dinfo = model.dinfo();
        dinfo.setPredictorTransform(DataInfo.TransformType.NONE);
        m._output = new GLMModel.GLMOutput(model.dinfo(), ((GLMModel.GLMOutput)model._output)._names, ((GLMModel.GLMOutput)model._output)._domains, ((GLMModel.GLMOutput)model._output).coefficientNames(), ((GLMModel.GLMOutput)model._output)._binomial, beta);
        DKV.put((Key)m._key, (Iced)m);
        GLMModelV3 res = new GLMModelV3();
        res.fillFromImpl(m);
        return res;
    }

    public GLMRegularizationPathV3 extractRegularizationPath(int v, GLMRegularizationPathV3 args) {
        GLMModel model = (GLMModel)DKV.getGet((Key)args.model.key());
        if (model == null) {
            throw new IllegalArgumentException("missing source model " + args.model);
        }
        return (GLMRegularizationPathV3)new GLMRegularizationPathV3().fillFromImpl(model.getRegularizationPath());
    }

    public DataInfoFrameV3 getDataInfoFrame(int version, DataInfoFrameV3 args) {
        Frame fr = (Frame)DKV.getGet((Key)args.frame.key());
        if (null == fr) {
            throw new IllegalArgumentException("no frame found");
        }
        args.result = new KeyV3.FrameKeyV3(MakeGLMModelHandler.oneHot((Frame)fr, (Model.InteractionSpec)Model.InteractionSpec.allPairwise((String[])args.interactions), (boolean)args.use_all, (boolean)args.standardize, (boolean)args.interactions_only, (boolean)true)._key);
        return args;
    }

    public static Frame oneHot(Frame fr, Model.InteractionSpec interactions, boolean useAll, boolean standardize, boolean interactionsOnly, final boolean skipMissing) {
        Frame res;
        final DataInfo dinfo = new DataInfo(fr, null, 1, useAll, standardize ? DataInfo.TransformType.STANDARDIZE : DataInfo.TransformType.NONE, DataInfo.TransformType.NONE, skipMissing, false, false, false, false, false, interactions);
        if (interactionsOnly) {
            if (null == dinfo._interactionVecs) {
                throw new IllegalArgumentException("no interactions");
            }
            int noutputs = 0;
            final int[] colIds = new int[dinfo._interactionVecs.length];
            final int[] offsetIds = new int[dinfo._interactionVecs.length];
            int idx = 0;
            String[] coefNames = dinfo.coefNames();
            for (int i : dinfo._interactionVecs) {
                int n = idx++;
                int n2 = ((InteractionWrappedVec)dinfo._adaptedFrame.vec(i)).expandedLength();
                offsetIds[n] = n2;
                noutputs += n2;
            }
            String[] names = new String[noutputs];
            idx = 0;
            int offset = 0;
            int namesIdx = 0;
            for (int i = 0; i < dinfo._adaptedFrame.numCols(); ++i) {
                Vec v = dinfo._adaptedFrame.vec(i);
                if (v instanceof InteractionWrappedVec) {
                    colIds[idx] = offset;
                    for (int nid = 0; nid < offsetIds[idx]; ++nid) {
                        names[namesIdx++] = coefNames[offset++];
                    }
                    if (++idx <= dinfo._interactionVecs.length) continue;
                    break;
                }
                if (v.isCategorical()) {
                    offset += v.domain().length - (useAll ? 0 : 1);
                    continue;
                }
                ++offset;
            }
            res = new MRTask(){

                public void map(Chunk[] cs, NewChunk[] ncs) {
                    DataInfo.Row r = dinfo.newDenseRow();
                    for (int i = 0; i < cs[0]._len; ++i) {
                        r = dinfo.extractDenseRow(cs, i, r);
                        if (skipMissing && r.isBad()) continue;
                        int newChkIdx = 0;
                        for (int idx = 0; idx < colIds.length; ++idx) {
                            int startOffset;
                            for (int start = startOffset = colIds[idx]; start < startOffset + offsetIds[idx]; ++start) {
                                ncs[newChkIdx++].addNum(r.get(start));
                            }
                        }
                    }
                }
            }.doAll(noutputs, (byte)3, dinfo._adaptedFrame).outputFrame(Key.make(), names, (String[][])null);
        } else {
            byte[] types = new byte[dinfo.fullN()];
            Arrays.fill(types, (byte)3);
            res = new MRTask(){

                public void map(Chunk[] cs, NewChunk[] ncs) {
                    DataInfo.Row r = dinfo.newDenseRow();
                    for (int i = 0; i < cs[0]._len; ++i) {
                        r = dinfo.extractDenseRow(cs, i, r);
                        if (skipMissing && r.isBad()) continue;
                        for (int n = 0; n < ncs.length; ++n) {
                            ncs[n].addNum(r.get(n));
                        }
                    }
                }
            }.doAll(types, dinfo._adaptedFrame.vecs()).outputFrame(Key.make((String)("OneHot" + Key.make().toString())), dinfo.coefNames(), (String[][])null);
        }
        dinfo.dropInteractions();
        dinfo.remove();
        return res;
    }

    public GramV3 computeGram(int v, GramV3 input) {
        Key k;
        if (DKV.get((Key)input.X.key()) == null) {
            throw new IllegalArgumentException("Frame " + input.X.key() + " does not exist.");
        }
        Frame fr = (Frame)input.X.key().get();
        Frame frcpy = new Frame((String[])fr._names.clone(), (Vec[])fr.vecs().clone());
        String wname = null;
        Vec weight = null;
        if (input.W != null && !input.W.column_name.isEmpty()) {
            wname = input.W.column_name;
            if (fr.find(wname) == -1) {
                throw new IllegalArgumentException("Did not find weight vector " + wname);
            }
            weight = frcpy.remove(wname);
        }
        DataInfo dinfo = new DataInfo(frcpy, null, 0, input.use_all_factor_levels, input.standardize ? DataInfo.TransformType.STANDARDIZE : DataInfo.TransformType.NONE, DataInfo.TransformType.NONE, input.skip_missing, false, !input.skip_missing, false, false, false, true);
        DKV.put((Keyed)dinfo);
        if (weight != null) {
            dinfo.setWeights(wname, weight);
        }
        Gram.GramTask gt = (Gram.GramTask)new Gram.GramTask(null, dinfo, false, true).doAll(dinfo._adaptedFrame);
        double[][] gram = gt._gram.getXX();
        dinfo.remove();
        String[] names = (String[])ArrayUtils.append((Object[])dinfo.coefNames(), (Object[])new String[]{"Intercept"});
        Vec[] vecs = new Vec[gram.length];
        Key[] keys = new Vec.VectorGroup().addVecs(vecs.length);
        for (int i = 0; i < vecs.length; ++i) {
            vecs[i] = Vec.makeVec((double[])gram[i], (Key)keys[i]);
        }
        input.destination_frame = new KeyV3.FrameKeyV3();
        String keyname = input.X.key().toString();
        if (keyname.endsWith(".hex")) {
            keyname = keyname.substring(0, keyname.lastIndexOf("."));
        }
        keyname = keyname + "_gram";
        if (weight != null) {
            keyname = keyname + "_" + wname;
        }
        if (DKV.get((Key)(k = Key.make((String)keyname))) != null) {
            int cnt;
            for (cnt = 0; cnt < 1000 && DKV.get((Key)(k = Key.make((String)(keyname + "_" + cnt)))) != null; ++cnt) {
            }
            if (cnt == 1000) {
                throw new IllegalArgumentException("unable to make unique key");
            }
        }
        input.destination_frame.fillFromImpl((Iced)k);
        DKV.put((Keyed)new Frame(k, names, vecs));
        return input;
    }
}

