/*
 * Decompiled with CFR 0.152.
 */
package hex.glm;

import hex.DataInfo;
import hex.FrameTask2;
import hex.glm.GLMModel;
import hex.glm.GLMValidation;
import hex.gram.Gram;
import java.util.Arrays;
import jsr166y.CountedCompleter;
import water.DKV;
import water.Futures;
import water.H2O;
import water.Iced;
import water.Key;
import water.MRTask;
import water.MemoryManager;
import water.fvec.C0DChunk;
import water.fvec.CBSChunk;
import water.fvec.Chunk;
import water.fvec.Vec;
import water.util.ArrayUtils;

public abstract class GLMTask {

    public static class GLMGenerateWeightsTask
    extends MRTask<GLMGenerateWeightsTask> {
        final GLMModel.GLMParameters _params;
        final double[] _betaw;
        double[] denums;
        double wsum;
        double wsumu;
        DataInfo _dinfo;
        double _likelihood;

        public GLMGenerateWeightsTask(Key jobKey, DataInfo dinfo, GLMModel.GLMParameters glm, double[] betaw) {
            this._params = glm;
            this._betaw = betaw;
            this._dinfo = dinfo;
        }

        public void map(Chunk[] chunks) {
            Chunk wChunk = chunks[chunks.length - 4];
            Chunk zChunk = chunks[chunks.length - 3];
            Chunk zTilda = chunks[chunks.length - 2];
            Chunk fChunk = chunks[chunks.length - 1];
            chunks = Arrays.copyOf(chunks, chunks.length - 4);
            this.denums = new double[this._dinfo.fullN() + 1];
            DataInfo.Row r = this._dinfo.newDenseRow();
            for (int i = 0; i < chunks[0]._len; ++i) {
                int j;
                double mu;
                double z;
                double w;
                if (fChunk.at8(i) == 1L) continue;
                this._dinfo.extractDenseRow(chunks, i, r);
                if (r.bad || r.weight == 0.0) {
                    return;
                }
                double y = r.response(0);
                assert (this._params._family != GLMModel.GLMParameters.Family.gamma || y > 0.0) : "illegal response column, y must be > 0  for family=Gamma.";
                assert (this._params._family != GLMModel.GLMParameters.Family.binomial || 0.0 <= y && y <= 1.0) : "illegal response column, y must be <0,1>  for family=Binomial. got " + y;
                int numStart = this._dinfo.numStart();
                double d = 1.0;
                double eta = r.innerProduct(this._betaw);
                if (this._params._family == GLMModel.GLMParameters.Family.gaussian && this._params._link == GLMModel.GLMParameters.Link.identity) {
                    w = r.weight;
                    z = y - r.offset;
                    mu = 0.0;
                } else {
                    mu = this._params.linkInv(eta + r.offset);
                    double var = Math.max(1.0E-6, this._params.variance(mu));
                    d = this._params.linkDeriv(mu);
                    z = eta + (y - mu) * d;
                    w = r.weight / (var * d * d);
                }
                this._likelihood += this._params.likelihood(y, mu);
                zTilda.set(i, eta - this._betaw[this._betaw.length - 1]);
                assert (w >= 0.0 || Double.isNaN(w)) : "invalid weight " + w;
                wChunk.set(i, w);
                zChunk.set(i, z);
                this.wsum += w;
                this.wsumu += r.weight;
                for (j = 0; j < r.nBins; ++j) {
                    int n = r.binIds[j];
                    this.denums[n] = this.denums[n] + w;
                }
                for (j = 0; j < r.nNums; ++j) {
                    int id;
                    int n = id = r.numIds == null ? j + numStart : r.numIds[j];
                    this.denums[n] = this.denums[n] + w * r.get(id) * r.get(id);
                }
            }
        }

        public void reduce(GLMGenerateWeightsTask git) {
            ArrayUtils.add((double[])this.denums, (double[])git.denums);
            this.wsum += git.wsum;
            this.wsumu += git.wsumu;
            this._likelihood += git._likelihood;
            super.reduce((MRTask)git);
        }
    }

    public static class GLMCoordinateDescentTaskSeqIntercept
    extends MRTask<GLMCoordinateDescentTaskSeqIntercept> {
        final double[] _betaold;
        public double _temp;
        DataInfo _dinfo;

        public GLMCoordinateDescentTaskSeqIntercept(double[] betaold, DataInfo dinfo) {
            this._betaold = betaold;
            this._dinfo = dinfo;
        }

        public void map(Chunk[] chunks) {
            int cnt = 0;
            Chunk wChunk = chunks[cnt++];
            Chunk zChunk = chunks[cnt++];
            Chunk filterChunk = chunks[cnt++];
            DataInfo.Row r = this._dinfo.newDenseRow();
            for (int i = 0; i < chunks[0]._len; ++i) {
                if (filterChunk.atd(i) == 1.0) continue;
                this._dinfo.extractDenseRow(chunks, i, r);
                this._temp = (double)wChunk.at8(i) * (zChunk.atd(i) - r.innerProduct(this._betaold));
            }
        }

        public void reduce(GLMCoordinateDescentTaskSeqIntercept git) {
            this._temp += git._temp;
            super.reduce((MRTask)git);
        }
    }

    public static class GLMCoordinateDescentTaskSeqNaive
    extends MRTask<GLMCoordinateDescentTaskSeqNaive> {
        public double[] _normMulold;
        public double[] _normSubold;
        public double[] _normMulnew;
        public double[] _normSubnew;
        final double[] _betaold;
        final double[] _betanew;
        final int[] _catLvls_new;
        final int[] _catLvls_old;
        public double[] _temp;
        boolean _skipFirst;
        long _nobs;
        int _cat_num;
        boolean _interceptnew;
        boolean _interceptold;

        public GLMCoordinateDescentTaskSeqNaive(boolean interceptold, boolean interceptnew, int cat_num, double[] betaold, double[] betanew, int[] catLvlsold, int[] catLvlsnew, double[] normMulold, double[] normSubold, double[] normMulnew, double[] normSubnew, boolean skipFirst) {
            this._normMulold = normMulold;
            this._normSubold = normSubold;
            this._normMulnew = normMulnew;
            this._normSubnew = normSubnew;
            this._cat_num = cat_num;
            this._betaold = betaold;
            this._betanew = betanew;
            this._interceptold = interceptold;
            this._interceptnew = interceptnew;
            this._catLvls_old = catLvlsold;
            this._catLvls_new = catLvlsnew;
            this._skipFirst = skipFirst;
        }

        public void map(Chunk[] chunks) {
            int cnt = 0;
            Chunk wChunk = chunks[cnt++];
            Chunk zChunk = chunks[cnt++];
            Chunk ztildaChunk = chunks[cnt++];
            Chunk filterChunk = chunks[cnt++];
            Chunk xpChunk = null;
            Chunk xChunk = null;
            this._temp = new double[this._betaold.length];
            if (this._interceptnew) {
                xChunk = new C0DChunk(1.0, chunks[0]._len);
                xpChunk = chunks[cnt++];
            } else if (this._interceptold) {
                xChunk = chunks[cnt++];
                xpChunk = new C0DChunk(1.0, chunks[0]._len);
            } else {
                xChunk = chunks[cnt++];
                xpChunk = chunks[cnt++];
            }
            for (int i = 0; i < chunks[0]._len; ++i) {
                double betanew = 0.0;
                double betaold = 0.0;
                ++this._nobs;
                if (filterChunk.atd(i) == 1.0) continue;
                int observation_level = 0;
                int observation_level_p = 0;
                double val = 1.0;
                double valp = 1.0;
                if (this._cat_num == 1) {
                    observation_level = (int)xChunk.at8(i);
                    if (this._catLvls_old != null) {
                        observation_level = Arrays.binarySearch(this._catLvls_old, observation_level);
                    }
                    observation_level_p = (int)xpChunk.at8(i);
                    if (this._catLvls_new != null) {
                        observation_level_p = Arrays.binarySearch(this._catLvls_new, observation_level_p);
                    }
                    if (this._skipFirst) {
                        --observation_level;
                        --observation_level_p;
                    }
                } else if (this._cat_num == 2) {
                    val = xChunk.atd(i);
                    if (this._normMulold != null && this._normSubold != null) {
                        val = (val - this._normSubold[0]) * this._normMulold[0];
                    }
                    observation_level_p = (int)xpChunk.at8(i);
                    if (this._catLvls_new != null) {
                        observation_level_p = Arrays.binarySearch(this._catLvls_new, observation_level_p);
                    }
                    if (this._skipFirst) {
                        --observation_level_p;
                    }
                } else if (this._cat_num == 3) {
                    val = xChunk.atd(i);
                    if (this._normMulold != null && this._normSubold != null) {
                        val = (val - this._normSubold[0]) * this._normMulold[0];
                    }
                    valp = xpChunk.atd(i);
                    if (this._normMulnew != null && this._normSubnew != null) {
                        valp = (valp - this._normSubnew[0]) * this._normMulnew[0];
                    }
                } else if (this._cat_num == 4) {
                    observation_level = (int)xChunk.at8(i);
                    if (this._catLvls_old != null) {
                        observation_level = Arrays.binarySearch(this._catLvls_old, observation_level);
                    }
                    if (this._skipFirst) {
                        --observation_level;
                    }
                    valp = xpChunk.atd(i);
                    if (this._normMulnew != null && this._normSubnew != null) {
                        valp = (valp - this._normSubnew[0]) * this._normMulnew[0];
                    }
                }
                if (observation_level >= 0) {
                    betaold = this._betaold[observation_level];
                }
                if (observation_level_p >= 0) {
                    betanew = this._betanew[observation_level_p];
                }
                if (this._interceptnew) {
                    ztildaChunk.set(i, ztildaChunk.atd(i) - betaold + valp * betanew);
                    this._temp[0] = this._temp[0] + wChunk.atd(i) * (zChunk.atd(i) - ztildaChunk.atd(i));
                    continue;
                }
                ztildaChunk.set(i, ztildaChunk.atd(i) - val * betaold + valp * betanew);
                if (observation_level < 0) continue;
                int n = observation_level;
                this._temp[n] = this._temp[n] + wChunk.atd(i) * val * (zChunk.atd(i) - ztildaChunk.atd(i));
            }
        }

        public void reduce(GLMCoordinateDescentTaskSeqNaive git) {
            ArrayUtils.add((double[])this._temp, (double[])git._temp);
            this._nobs += git._nobs;
            super.reduce((MRTask)git);
        }
    }

    public static class GLMIterationTask
    extends FrameTask2<GLMIterationTask> {
        final GLMModel.GLMParameters _params;
        final double[] _beta;
        protected Gram _gram;
        double[] _xy;
        double _wz;
        double _yy;
        GLMValidation _val;
        final double _ymu;
        long _nobs;
        final boolean _validate;
        int[] _ti;
        public double _likelihood;
        final double _lambda;
        double wsum;
        double wsumu;

        public GLMIterationTask(Key jobKey, DataInfo dinfo, double lambda, GLMModel.GLMParameters glm, boolean validate, double[] beta, double ymu, Vec rowFilter, H2O.H2OCountedCompleter cmp) {
            super(cmp, dinfo, jobKey, rowFilter);
            this._params = glm;
            this._beta = beta;
            this._ymu = ymu;
            this._validate = validate;
            this._lambda = lambda;
        }

        @Override
        public boolean handlesSparseData() {
            return true;
        }

        @Override
        public double sparseOffset() {
            double etaOffset = 0.0;
            if (this._dinfo._normMul != null && this._dinfo._normSub != null && this._beta != null) {
                int ns = this._dinfo.numStart();
                for (int i = 0; i < this._dinfo._nums; ++i) {
                    etaOffset -= this._beta[i + ns] * this._dinfo._normSub[i] * this._dinfo._normMul[i];
                }
            }
            return etaOffset;
        }

        @Override
        public void chunkInit() {
            this._gram = new Gram(this._dinfo.fullN(), this._dinfo.largestCat(), this._dinfo._nums, this._dinfo._cats, true);
            if (this._validate) {
                String[] domain;
                int rank = 0;
                if (this._beta != null) {
                    for (double d : this._beta) {
                        if (d == 0.0) continue;
                        ++rank;
                    }
                }
                if ((domain = this._dinfo._adaptedFrame.lastVec().domain()) == null && this._params._family == GLMModel.GLMParameters.Family.binomial) {
                    domain = new String[]{"0", "1"};
                }
                this._val = new GLMValidation(domain, true, this._ymu, this._params, rank, 0.5, true);
            }
            this._xy = MemoryManager.malloc8d((int)(this._dinfo.fullN() + 1));
            if (this._params._family == GLMModel.GLMParameters.Family.binomial && this._validate) {
                this._ti = new int[2];
            }
        }

        @Override
        protected void processRow(DataInfo.Row r) {
            int i;
            double eta;
            double mu;
            double z;
            double w;
            if (r.bad || r.weight == 0.0) {
                return;
            }
            ++this._nobs;
            double y = r.response(0);
            assert (this._params._family != GLMModel.GLMParameters.Family.gamma || y > 0.0) : "illegal response column, y must be > 0  for family=Gamma.";
            assert (this._params._family != GLMModel.GLMParameters.Family.binomial || 0.0 <= y && y <= 1.0) : "illegal response column, y must be <0,1>  for family=Binomial. got " + y;
            int numStart = this._dinfo.numStart();
            double d = 1.0;
            if (this._params._family == GLMModel.GLMParameters.Family.gaussian && this._params._link == GLMModel.GLMParameters.Link.identity) {
                w = r.weight;
                z = y - r.offset;
                eta = mu = 0.0;
            } else {
                eta = r.innerProduct(this._beta);
                mu = this._params.linkInv(eta + r.offset);
                double var = Math.max(1.0E-6, this._params.variance(mu));
                d = this._params.linkDeriv(mu);
                z = eta + (y - mu) * d;
                w = r.weight / (var * d * d);
            }
            if (this._validate) {
                this._val.add(y, mu, r.weight, r.offset);
            }
            this._likelihood += r.weight * this._params.likelihood(y, mu);
            assert (w >= 0.0 || Double.isNaN(w)) : "invalid weight " + w;
            this.wsum += w;
            this.wsumu += r.weight;
            double wz = w * z;
            this._wz += wz;
            this._yy += wz * z;
            for (i = 0; i < r.nBins; ++i) {
                int n = r.binIds[i];
                this._xy[n] = this._xy[n] + wz;
            }
            for (i = 0; i < r.nNums; ++i) {
                int id = r.numIds == null ? i + numStart : r.numIds[i];
                double val = r.numVals[i];
                int n = id;
                this._xy[n] = this._xy[n] + wz * val;
            }
            if (this._dinfo._intercept) {
                int n = this._xy.length - 1;
                this._xy[n] = this._xy[n] + wz;
            }
            this._gram.addRow(r, w);
        }

        public void reduce(GLMIterationTask git) {
            ArrayUtils.add((double[])this._xy, (double[])git._xy);
            this._gram.add(git._gram);
            this._yy += git._yy;
            this._nobs += git._nobs;
            this._wz += git._wz;
            this.wsum += git.wsum;
            this.wsumu += git.wsumu;
            if (this._validate) {
                this._val.reduce(git._val);
            }
            this._likelihood += git._likelihood;
            super.reduce((MRTask)git);
        }

        protected void postGlobal() {
            if (this._sparse && this._dinfo._normSub != null) {
                int i;
                int ns = this._dinfo.numStart();
                int interceptIdx = this._xy.length - 1;
                double[] interceptRow = this._gram._xx[interceptIdx - this._gram._diagN];
                double nobs = interceptRow[interceptRow.length - 1];
                for (i = ns; i < this._dinfo.fullN(); ++i) {
                    int j;
                    double iMean = this._dinfo._normSub[i - ns] * this._dinfo._normMul[i - ns];
                    for (j = 0; j < ns; ++j) {
                        double[] dArray = this._gram._xx[i - this._gram._diagN];
                        int n = j;
                        dArray[n] = dArray[n] - interceptRow[j] * iMean;
                    }
                    for (j = ns; j <= i; ++j) {
                        double jMean = this._dinfo._normSub[j - ns] * this._dinfo._normMul[j - ns];
                        double[] dArray = this._gram._xx[i - this._gram._diagN];
                        int n = j;
                        dArray[n] = dArray[n] - (interceptRow[i] * jMean + interceptRow[j] * iMean - nobs * iMean * jMean);
                    }
                }
                if (this._dinfo._intercept) {
                    for (int j = ns; j < this._dinfo.fullN(); ++j) {
                        int n = j;
                        interceptRow[n] = interceptRow[n] - nobs * this._dinfo._normSub[j - ns] * this._dinfo._normMul[j - ns];
                    }
                }
                for (i = ns; i < this._dinfo.fullN(); ++i) {
                    int n = i;
                    this._xy[n] = this._xy[n] - this._xy[this._xy.length - 1] * this._dinfo._normSub[i - ns] * this._dinfo._normMul[i - ns];
                }
            }
            if (this._val != null) {
                this._val.computeAIC();
            }
        }

        public boolean hasNaNsOrInf() {
            return ArrayUtils.hasNaNsOrInfs((double[])this._xy) || this._gram.hasNaNsOrInfs();
        }
    }

    public static class LBFGS_LogisticGradientTask
    extends GLMGradientTask {
        public LBFGS_LogisticGradientTask(DataInfo dinfo, GLMModel.GLMParameters params, double lambda, double[] beta, double reg, Vec rowFilter) {
            super(dinfo, params, lambda, beta, reg, rowFilter);
        }

        @Override
        protected void goByRows(Chunk[] chks, boolean[] skp) {
            DataInfo.Row row = this._dinfo.newDenseRow();
            double[] g = this._gradient;
            double[] b = this._beta;
            for (int rid = 0; rid < chks[0]._len; ++rid) {
                if (skp[rid]) continue;
                row = this._dinfo.extractDenseRow(chks, rid, row);
                double y = -1.0 + 2.0 * row.response(0);
                if (row.bad) continue;
                ++this._nobs;
                double eta = row.innerProduct(b) + row.offset;
                double d = 1.0 + Math.exp(-y * eta);
                this._likelihood += row.weight * Math.log(d);
                double gval = row.weight * -y * (1.0 - 1.0 / d);
                for (int i = 0; i < row.nBins; ++i) {
                    int n = row.binIds[i];
                    g[n] = g[n] + gval;
                }
                int off = this._dinfo.numStart();
                for (int j = 0; j < this._dinfo._nums; ++j) {
                    int n = j + off;
                    g[n] = g[n] + row.numVals[j] * gval;
                }
                if (!this._dinfo._intercept) continue;
                int n = g.length - 1;
                g[n] = g[n] + gval;
            }
        }

        @Override
        protected void goByCols(Chunk[] chks, boolean[] skp) {
            int r;
            int i;
            int numStart = this._dinfo.numStart();
            double[] eta = this.computeEtaByCols(chks, skp);
            double[] g = this._gradient;
            Chunk offsetChunk = null;
            int nxs = chks.length - 1;
            if (this._dinfo._offset) {
                offsetChunk = chks[--nxs];
            }
            Chunk responseChunk = chks[nxs];
            C0DChunk weightsChunk = this._dinfo._weights ? chks[this._dinfo.weightChunkId()] : new C0DChunk(1.0, chks[0]._len);
            double eta_sum = 0.0;
            for (int r2 = 0; r2 < chks[0]._len; ++r2) {
                double w = weightsChunk.atd(r2);
                if (skp[r2] || responseChunk.isNA(r2)) continue;
                ++this._nobs;
                double off = this._dinfo._offset ? offsetChunk.atd(r2) : 0.0;
                double e = eta[r2] + off;
                switch (this._params._family) {
                    case gaussian: {
                        double diff = e - responseChunk.atd(r2);
                        this._likelihood += w * diff * diff;
                        eta[r2] = diff;
                        break;
                    }
                    case binomial: {
                        double y = -1.0 + 2.0 * responseChunk.atd(r2);
                        double d = 1.0 + Math.exp(-y * e);
                        this._likelihood += w * Math.log(d);
                        eta[r2] = w * -y * (1.0 - 1.0 / d);
                        break;
                    }
                    default: {
                        throw H2O.unimpl();
                    }
                }
                eta_sum += eta[r2];
            }
            if (this._dinfo._intercept) {
                g[g.length - 1] = eta_sum;
            }
            if (this._dinfo._normMul != null && this._dinfo._normSub != null) {
                for (i = 0; i < this._dinfo._nums; ++i) {
                    g[numStart + i] = -this._dinfo._normSub[i] * this._dinfo._normMul[i] * eta_sum;
                }
            }
            for (i = 0; i < this._dinfo._cats; ++i) {
                Chunk c = chks[i];
                for (r = 0; r < c._len; ++r) {
                    int off;
                    if (skp[r] || (off = this._dinfo.getCategoricalId(i, (int)chks[i].at8(r))) == -1) continue;
                    int n = off;
                    g[n] = g[n] + eta[r];
                }
            }
            for (i = 0; i < this._dinfo._nums; ++i) {
                Chunk c = chks[i + this._dinfo._cats];
                r = c.nextNZ(-1);
                while (r < c._len) {
                    if (!skp[r] && !c.isNA(r)) {
                        double d = c.atd(r);
                        if (this._dinfo._normMul != null) {
                            d *= this._dinfo._normMul[i];
                        }
                        int n = numStart + i;
                        g[n] = g[n] + eta[r] * d;
                    }
                    r = c.nextNZ(r);
                }
            }
            this._skip = skp;
        }
    }

    static class GLMWeightsTask
    extends MRTask<GLMWeightsTask> {
        final GLMModel.GLMParameters _params;

        GLMWeightsTask(GLMModel.GLMParameters params) {
            this._params = params;
        }

        public void map(Chunk[] chks) {
            Chunk yChunk = chks[0];
            Chunk zChunk = chks[1];
            Chunk wChunk = chks[2];
            Chunk eChunk = chks[3];
            for (int i = 0; i < yChunk._len; ++i) {
                double y = yChunk.atd(i);
                double eta = eChunk.atd(i);
                double mu = this._params.linkInv(eta);
                double var = Math.max(1.0E-6, this._params.variance(mu));
                double d = this._params.linkDeriv(mu);
                zChunk.set(i, eta + (y - mu) * d);
                wChunk.set(i, 1.0 / (var * d * d));
            }
        }

        public void reduce(GLMWeightsTask gwt) {
        }
    }

    static class GLMGradientTask
    extends MRTask<GLMGradientTask> {
        final GLMModel.GLMParameters _params;
        GLMValidation _val;
        double _currentLambda;
        final double[] _beta;
        protected final DataInfo _dinfo;
        final double _reg;
        public double[] _gradient;
        public double _likelihood;
        protected transient boolean[] _skip;
        boolean _validate;
        Vec _rowFilter;
        long _nobs;
        double _wsum;
        double _ymu;
        private boolean _forceRows;
        private boolean _forceCols;

        public GLMGradientTask(DataInfo dinfo, GLMModel.GLMParameters params, double lambda, double[] beta, double reg, Vec rowFilter) {
            this(dinfo, params, lambda, beta, reg, rowFilter, null);
        }

        public GLMGradientTask(DataInfo dinfo, GLMModel.GLMParameters params, double lambda, double[] beta, double reg, Vec rowFilter, H2O.H2OCountedCompleter cc) {
            super(cc);
            this._dinfo = dinfo;
            this._params = params;
            this._beta = beta;
            this._reg = reg;
            this._currentLambda = lambda;
            this._rowFilter = rowFilter;
        }

        public GLMGradientTask setValidate(double ymu, boolean validate) {
            this._ymu = ymu;
            this._validate = validate;
            return this;
        }

        protected void goByRows(Chunk[] chks, boolean[] skp) {
            DataInfo.Row row = this._dinfo.newDenseRow();
            double[] g = this._gradient;
            double[] b = this._beta;
            for (int rid = 0; rid < chks[0]._len; ++rid) {
                if (skp[rid]) continue;
                row = this._dinfo.extractDenseRow(chks, rid, row);
                if (row.bad || row.weight == 0.0) continue;
                ++this._nobs;
                this._wsum += row.weight;
                double eta = row.innerProduct(b) + row.offset;
                double mu = this._params.linkInv(eta);
                this._val.add(row.response(0), mu, row.weight, row.offset);
                this._likelihood += row.weight * this._params.likelihood(row.response(0), mu);
                double var = this._params.variance(mu);
                if (var < 1.0E-6) {
                    var = 1.0E-6;
                }
                double gval = row.weight * (mu - row.response(0)) / (var * this._params.linkDeriv(mu));
                for (int i = 0; i < row.nBins; ++i) {
                    int n = row.binIds[i];
                    g[n] = g[n] + gval;
                }
                int off = this._dinfo.numStart();
                for (int j = 0; j < this._dinfo._nums; ++j) {
                    int n = j + off;
                    g[n] = g[n] + row.numVals[j] * gval;
                }
                if (!this._dinfo._intercept) continue;
                int n = g.length - 1;
                g[n] = g[n] + gval;
            }
        }

        public void postGlobal() {
            ArrayUtils.mult((double[])this._gradient, (double)this._reg);
            for (int j = 0; j < this._beta.length - (this._dinfo._intercept ? 1 : 0); ++j) {
                int n = j;
                this._gradient[n] = this._gradient[n] + this._currentLambda * this._beta[j];
            }
        }

        protected final double[] computeEtaByCols(Chunk[] chks, boolean[] skip) {
            int r;
            double[] eta = MemoryManager.malloc8d((int)chks[0]._len);
            if (this._dinfo._intercept) {
                Arrays.fill(eta, this._beta[this._beta.length - 1]);
            }
            if (this._dinfo._offset) {
                for (int i = 0; i < eta.length; ++i) {
                    if (skip[i]) continue;
                    int n = i;
                    eta[n] = eta[n] + chks[this._dinfo.offsetChunkId()].atd(i);
                    if (!Double.isNaN(eta[i])) continue;
                    skip[i] = true;
                }
            }
            double[] b = this._beta;
            for (int i = 0; i < this._dinfo._cats; ++i) {
                Chunk c = chks[i];
                for (int r2 = 0; r2 < c._len; ++r2) {
                    if (skip[r2] || c.isNA(r2)) {
                        skip[r2] = true;
                        continue;
                    }
                    int off = this._dinfo.getCategoricalId(i, (int)c.at8(r2));
                    if (off == -1) continue;
                    int n = r2;
                    eta[n] = eta[n] + b[off];
                }
            }
            int numStart = this._dinfo.numStart();
            if (this._dinfo._normMul != null && this._dinfo._normSub != null) {
                double off = 0.0;
                for (int i = 0; i < this._dinfo._nums; ++i) {
                    off -= b[numStart + i] * this._dinfo._normSub[i] * this._dinfo._normMul[i];
                }
                r = 0;
                while (r < chks[0]._len) {
                    int n = r++;
                    eta[n] = eta[n] + off;
                }
            }
            for (int i = 0; i < this._dinfo._nums; ++i) {
                Chunk c = chks[i + this._dinfo._cats];
                r = c.nextNZ(-1);
                while (r < c._len) {
                    if (skip[r] || c.isNA(r)) {
                        skip[r] = true;
                    } else {
                        double d = c.atd(r);
                        if (this._dinfo._normMul != null) {
                            d *= this._dinfo._normMul[i];
                        }
                        int n = r;
                        eta[n] = eta[n] + b[numStart + i] * d;
                    }
                    r = c.nextNZ(r);
                }
            }
            return eta;
        }

        protected void goByCols(Chunk[] chks, boolean[] skp) {
            int r;
            int i;
            int numStart = this._dinfo.numStart();
            double[] eta = this.computeEtaByCols(chks, skp);
            double[] b = this._beta;
            double[] g = this._gradient;
            C0DChunk offsetChunk = this._dinfo._offset ? chks[this._dinfo.offsetChunkId()] : new C0DChunk(0.0, chks[0]._len);
            C0DChunk weightChunk = this._dinfo._weights ? chks[this._dinfo.weightChunkId()] : new C0DChunk(1.0, chks[0]._len);
            Chunk responseChunk = chks[this._dinfo.responseChunkId()];
            double eta_sum = 0.0;
            for (int r2 = 0; r2 < chks[0]._len; ++r2) {
                double w;
                if (skp[r2] || responseChunk.isNA(r2) || (w = weightChunk.atd(r2)) == 0.0 || Double.isNaN(w)) continue;
                ++this._nobs;
                this._wsum += w;
                double y = responseChunk.atd(r2);
                double mu = this._params.linkInv(eta[r2]);
                this._val.add(y, mu, w, offsetChunk.atd(r2));
                this._likelihood += w * this._params.likelihood(y, mu);
                double var = this._params.variance(mu);
                if (var < 1.0E-6) {
                    var = 1.0E-6;
                }
                eta[r2] = w * (mu - y) / (var * this._params.linkDeriv(mu));
                eta_sum += eta[r2];
            }
            if (this._dinfo._intercept) {
                g[g.length - 1] = eta_sum;
            }
            if (this._dinfo._normMul != null && this._dinfo._normSub != null) {
                for (i = 0; i < this._dinfo._nums; ++i) {
                    g[numStart + i] = -this._dinfo._normSub[i] * this._dinfo._normMul[i] * eta_sum;
                }
            }
            for (i = 0; i < this._dinfo._cats; ++i) {
                Chunk c = chks[i];
                for (r = 0; r < c._len; ++r) {
                    int off;
                    if (skp[r] || (off = this._dinfo.getCategoricalId(i, (int)chks[i].at8(r))) == -1) continue;
                    int n = off;
                    g[n] = g[n] + eta[r];
                }
            }
            for (i = 0; i < this._dinfo._nums; ++i) {
                Chunk c = chks[i + this._dinfo._cats];
                r = c.nextNZ(-1);
                while (r < c._len) {
                    if (!skp[r] && !c.isNA(r)) {
                        double d = c.atd(r);
                        if (this._dinfo._normMul != null) {
                            d *= this._dinfo._normMul[i];
                        }
                        int n = numStart + i;
                        g[n] = g[n] + eta[r] * d;
                    }
                    r = c.nextNZ(r);
                }
            }
            this._skip = skp;
        }

        private boolean mostlySparse(Chunk[] chks) {
            int cnt = 0;
            for (Chunk chk : chks) {
                if (!chk.isSparse()) continue;
                ++cnt;
            }
            return cnt >= chks.length >> 1;
        }

        public GLMGradientTask forceColAccess() {
            this._forceCols = true;
            this._forceRows = false;
            return this;
        }

        public GLMGradientTask forceRowAccess() {
            this._forceCols = false;
            this._forceRows = true;
            return this;
        }

        public void map(Chunk[] chks) {
            int rank = 0;
            for (int i = 0; i < this._beta.length; ++i) {
                if (this._beta[i] == 0.0) continue;
                ++rank;
            }
            this._gradient = MemoryManager.malloc8d((int)this._beta.length);
            String[] domain = this._dinfo._adaptedFrame.lastVec().domain();
            if (domain == null && this._params._family == GLMModel.GLMParameters.Family.binomial) {
                domain = new String[]{"0", "1"};
            }
            this._val = new GLMValidation(domain, this._params._intercept, this._ymu, this._params, rank, 0.0, this._validate);
            boolean[] skp = MemoryManager.mallocZ((int)chks[0]._len);
            if (this._rowFilter != null) {
                Chunk c = this._rowFilter.chunkForChunkIdx(chks[0].cidx());
                for (int r = 0; r < chks[0]._len; ++r) {
                    skp[r] = c.at8(r) == 1L;
                }
            }
            if (this._forceCols || !this._forceRows && (chks.length >= 100 || this.mostlySparse(chks))) {
                this.goByCols(chks, skp);
            } else {
                this.goByRows(chks, skp);
            }
        }

        public void reduce(GLMGradientTask grt) {
            this._likelihood += grt._likelihood;
            this._nobs += grt._nobs;
            this._wsum += grt._wsum;
            this._val.reduce(grt._val);
            ArrayUtils.add((double[])this._gradient, (double[])grt._gradient);
        }
    }

    static class GLMLineSearchTask
    extends MRTask<GLMLineSearchTask> {
        final DataInfo _dinfo;
        final double[] _beta;
        final double[] _direction;
        final double _step;
        final double _initStep;
        final int _nSteps;
        final GLMModel.GLMParameters _params;
        final double _reg;
        Vec _rowFilter;
        boolean _useFasterMetrics = false;
        long _nobs;
        double[] _likelihoods;

        public GLMLineSearchTask(DataInfo dinfo, GLMModel.GLMParameters params, double reg, double[] beta, double[] direction, double initStep, double step, int nsteps, Vec rowFilter) {
            this(dinfo, params, reg, beta, direction, initStep, step, nsteps, rowFilter, null);
        }

        public GLMLineSearchTask(DataInfo dinfo, GLMModel.GLMParameters params, double reg, double[] beta, double[] direction, double initStep, double step, int nsteps, Vec rowFilter, CountedCompleter cc) {
            super((H2O.H2OCountedCompleter)cc);
            this._dinfo = dinfo;
            this._reg = reg;
            this._beta = beta;
            this._direction = direction;
            this._step = step;
            this._nSteps = nsteps;
            this._params = params;
            this._rowFilter = rowFilter;
            this._initStep = initStep;
        }

        public GLMLineSearchTask setFasterMetrics(boolean b) {
            this._useFasterMetrics = b;
            return this;
        }

        public void map(Chunk[] chks) {
            int i;
            int r;
            Chunk rowFilter = this._rowFilter != null ? this._rowFilter.chunkForChunkIdx(chks[0].cidx()) : null;
            Chunk responseChunk = chks[this._dinfo.responseChunkId()];
            boolean[] skip = MemoryManager.mallocZ((int)chks[0]._len);
            if (rowFilter != null) {
                for (int r2 = 0; r2 < skip.length; ++r2) {
                    skip[r2] = rowFilter.at8(r2) == 1L;
                }
            }
            double[][] eta = new double[responseChunk._len][this._nSteps];
            if (this._dinfo._offset) {
                Chunk offsetChunk = chks[this._dinfo.offsetChunkId()];
                for (int r3 = 0; r3 < eta.length; ++r3) {
                    Arrays.fill(eta[r3], offsetChunk.atd(r3));
                }
            }
            C0DChunk weightsChunk = this._dinfo._weights ? chks[this._dinfo.weightChunkId()] : new C0DChunk(1.0, chks[0]._len);
            double[] beta = this._beta;
            double[] pk = this._direction;
            for (int r4 = 0; r4 < eta.length; ++r4) {
                double b = beta[beta.length - 1];
                double t = pk[beta.length - 1] * this._initStep;
                int j = 0;
                while (j < this._nSteps) {
                    double[] dArray = eta[r4];
                    int n = j++;
                    dArray[n] = dArray[n] + (b + t);
                    t *= this._step;
                }
            }
            for (int i2 = 0; i2 < this._dinfo._cats; ++i2) {
                Chunk c = chks[i2];
                for (r = 0; r < c._len; ++r) {
                    if (skip[r] || c.isNA(r)) {
                        skip[r] = true;
                        continue;
                    }
                    int off = this._dinfo.getCategoricalId(i2, (int)c.at8(r));
                    if (off == -1) continue;
                    double t = pk[off] * this._initStep;
                    double b = beta[off];
                    int j = 0;
                    while (j < this._nSteps) {
                        double[] dArray = eta[r];
                        int n = j++;
                        dArray[n] = dArray[n] + (b + t);
                        t *= this._step;
                    }
                }
            }
            int numStart = this._dinfo.numStart();
            double[] off = new double[this._nSteps];
            if (this._dinfo._normMul != null && this._dinfo._normSub != null) {
                for (i = 0; i < this._dinfo._nums; ++i) {
                    double b = beta[numStart + i];
                    double s = pk[numStart + i] * this._initStep;
                    double d = this._dinfo._normSub[i] * this._dinfo._normMul[i];
                    int j = 0;
                    while (j < this._nSteps) {
                        int n = j++;
                        off[n] = off[n] - (b + s) * d;
                        s *= this._step;
                    }
                }
            }
            for (i = 0; i < this._dinfo._nums; ++i) {
                Chunk c = chks[i + this._dinfo._cats];
                int r5 = c.nextNZ(-1);
                while (r5 < c._len) {
                    if (skip[r5] || c.isNA(r5)) {
                        skip[r5] = true;
                    } else {
                        double d = c.atd(r5);
                        if (this._dinfo._normMul != null) {
                            d *= this._dinfo._normMul[i];
                        }
                        double b = beta[numStart + i];
                        double s = pk[numStart + i] * this._initStep;
                        int j = 0;
                        while (j < this._nSteps) {
                            double[] dArray = eta[r5];
                            int n = j++;
                            dArray[n] = dArray[n] + (b + s) * d;
                            s *= this._step;
                        }
                    }
                    r5 = c.nextNZ(r5);
                }
            }
            this._likelihoods = MemoryManager.malloc8d((int)this._nSteps);
            for (r = 0; r < chks[0]._len; ++r) {
                double w = weightsChunk.atd(r);
                if (skip[r] || responseChunk.isNA(r)) continue;
                ++this._nobs;
                double y = responseChunk.atd(r);
                double yy = -1.0 + 2.0 * y;
                for (int i3 = 0; i3 < this._nSteps; ++i3) {
                    double e = eta[r][i3] + off[i3];
                    if (this._params._family == GLMModel.GLMParameters.Family.binomial && this._useFasterMetrics) {
                        int n = i3;
                        this._likelihoods[n] = this._likelihoods[n] + w * Math.log(1.0 + Math.exp(-yy * e));
                        continue;
                    }
                    double mu = this._params.linkInv(e);
                    int n = i3;
                    this._likelihoods[n] = this._likelihoods[n] + w * this._params.likelihood(y, mu);
                }
            }
        }

        public void reduce(GLMLineSearchTask glt) {
            ArrayUtils.add((double[])this._likelihoods, (double[])glt._likelihoods);
            this._nobs += glt._nobs;
        }
    }

    static class YMUTask
    extends MRTask<YMUTask> {
        double _ymu;
        double _yMin = Double.POSITIVE_INFINITY;
        double _yMax = Double.NEGATIVE_INFINITY;
        long _nobs;
        double _wsum;
        final Vec _fVec;
        final int _responseId;
        final int _weightId;
        final int _offsetId;
        final int _nums;
        final int _numOff;
        final boolean _comupteWeightedSigma = true;
        double[] _xsum;
        double[] _xxsum;

        public YMUTask(DataInfo dinfo, Vec mVec, H2O.H2OCountedCompleter cmp) {
            super(cmp);
            this._fVec = mVec;
            this._nums = dinfo._nums;
            this._numOff = dinfo._cats;
            this._responseId = dinfo.responseChunkId();
            this._weightId = dinfo._weights ? dinfo.weightChunkId() : -1;
            this._offsetId = dinfo._offset ? dinfo.offsetChunkId() : -1;
        }

        public void setupLocal() {
            this._fVec.preWriting();
        }

        public void map(Chunk[] chunks) {
            boolean[] skip = MemoryManager.mallocZ((int)chunks[0]._len);
            for (int i = 0; i < chunks.length; ++i) {
                int r = chunks[i].nextNZ(-1);
                while (r < chunks[i]._len) {
                    int n = r;
                    skip[n] = skip[n] | chunks[i].isNA(r);
                    r = chunks[i].nextNZ(r);
                }
            }
            Chunk response = chunks[this._responseId];
            C0DChunk weight = this._weightId >= 0 ? chunks[this._weightId] : new C0DChunk(1.0, chunks[0]._len);
            this._xsum = MemoryManager.malloc8d((int)this._nums);
            this._xxsum = MemoryManager.malloc8d((int)this._nums);
            for (int r = 0; r < response._len; ++r) {
                if (skip[r]) continue;
                double w = weight.atd(r);
                if (w == 0.0) {
                    skip[r] = true;
                    continue;
                }
                int i = 0;
                while (i < this._nums) {
                    double d = chunks[i + this._numOff].atd(r);
                    int n = i;
                    this._xsum[n] = this._xsum[n] + w * d;
                    int n2 = i++;
                    this._xxsum[n2] = this._xxsum[n2] + w * d * d;
                }
                this._wsum += w;
                double d = w * response.atd(r);
                assert (!Double.isNaN(d));
                assert (!Double.isNaN(this._ymu + d)) : "got NaN by adding " + this._ymu + " + " + d;
                this._ymu += d;
                if (d < this._yMin) {
                    this._yMin = d;
                }
                if (d > this._yMax) {
                    this._yMax = d;
                }
                ++this._nobs;
            }
            if (this._fVec != null) {
                DKV.put((Key)this._fVec.chunkKey(chunks[0].cidx()), (Iced)new CBSChunk(skip));
            }
        }

        public void postGlobal() {
            this._ymu /= this._wsum;
            Futures fs = new Futures();
            this._fVec.postWrite(fs);
            fs.blockForPending();
        }

        public void reduce(YMUTask ymt) {
            if (this._nobs > 0L && ymt._nobs > 0L) {
                this._wsum += ymt._wsum;
                this._ymu += ymt._ymu;
                this._nobs += ymt._nobs;
                if (this._yMin > ymt._yMin) {
                    this._yMin = ymt._yMin;
                }
                if (this._yMax < ymt._yMax) {
                    this._yMax = ymt._yMax;
                }
                ArrayUtils.add((double[])this._xsum, (double[])ymt._xsum);
                ArrayUtils.add((double[])this._xxsum, (double[])ymt._xxsum);
            } else if (this._nobs == 0L) {
                this._wsum = ymt._wsum;
                this._ymu = ymt._ymu;
                this._nobs = ymt._nobs;
                this._yMin = ymt._yMin;
                this._yMax = ymt._yMax;
                this._xsum = ymt._xsum;
                this._xxsum = ymt._xxsum;
            }
        }
    }
}

