/*
 * Decompiled with CFR 0.152.
 */
package hex.schemas;

import com.google.gson.Gson;
import hex.Model;
import hex.grid.Grid;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import water.H2O;
import water.Key;
import water.api.API;
import water.api.JobV3;
import water.api.KeyV3;
import water.api.ModelParametersSchema;
import water.api.Schema;
import water.util.IcedHashMap;
import water.util.ReflectionUtils;

public class GridSearchSchema<G extends Grid<MP>, S extends GridSearchSchema<G, S, MP, P>, MP extends Model.Parameters, P extends ModelParametersSchema>
extends Schema<G, S> {
    @API(help="Basic model builder parameters.", direction=API.Direction.INPUT)
    public P parameters = this.createParametersSchema();
    @API(help="Grid search parameters.", direction=API.Direction.INOUT)
    public IcedHashMap<String, Object[]> hyper_parameters;
    @API(help="Destination id for this grid; auto-generated if not specified", required=false, direction=API.Direction.INOUT)
    public KeyV3.GridKeyV3 grid_id;
    @API(help="Number of all models generated by grid search.", direction=API.Direction.OUTPUT)
    public int total_models;
    @API(help="Job Key.", direction=API.Direction.OUTPUT)
    public JobV3 job;

    public S fillFromParms(Properties parms) {
        if (parms.containsKey("hyper_parameters")) {
            String parameters = parms.getProperty("hyper_parameters");
            this.hyper_parameters = GridSearchSchema.parseJsonMap(parameters, new IcedHashMap());
            parms.remove("hyper_parameters");
        }
        if (parms.containsKey("grid_id")) {
            this.grid_id = new KeyV3.GridKeyV3(Key.make((String)parms.getProperty("grid_id")));
            parms.remove("grid_id");
        }
        this.parameters.fillFromParms(parms, false);
        return (S)((Object)this);
    }

    public S fillFromImpl(G impl) {
        GridSearchSchema s = (GridSearchSchema)super.fillFromImpl(impl);
        s.parameters = this.createParametersSchema();
        s.parameters.fillFromImpl((Model.Parameters)this.parameters.createImpl());
        return (S)((Object)s);
    }

    final P createParametersSchema() {
        ModelParametersSchema impl = null;
        if (GridSearchSchema.class == ((Object)((Object)this)).getClass()) {
            return (P)new ModelParametersSchema();
        }
        try {
            Class parameters_class = ReflectionUtils.findActualClassParameter(((Object)((Object)this)).getClass(), (int)3);
            impl = (ModelParametersSchema)parameters_class.newInstance();
        }
        catch (Exception e) {
            throw H2O.fail((String)("Caught exception trying to instantiate a builder instance for ModelBuilderSchema: " + (Object)((Object)this) + ": " + e), (Throwable)e);
        }
        return (P)impl;
    }

    public static <T extends Map<String, Object[]>> T parseJsonMap(String json, T map) {
        Gson gson = new Gson();
        Map m = (Map)gson.fromJson(json, map.getClass());
        for (Map.Entry e : m.entrySet()) {
            if (e.getValue() instanceof List) {
                map.put(e.getKey(), (Object[])((List)e.getValue()).toArray());
                continue;
            }
            map.put(e.getKey(), (Object[])new Object[]{e.getValue()});
        }
        return map;
    }
}

