/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.DataInfo;
import water.DKV;
import water.H2O;
import water.Job;
import water.Key;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.FrameUtils;

public abstract class FrameTask2<T extends FrameTask2<T>>
extends MRTask<T> {
    protected boolean _sparse;
    final Key _jobKey;
    public final Vec _rowFilter;
    protected final DataInfo _dinfo;

    public FrameTask2(H2O.H2OCountedCompleter cmp, DataInfo dinfo, Key jobKey) {
        this(cmp, dinfo, jobKey, null);
    }

    public FrameTask2(H2O.H2OCountedCompleter cmp, DataInfo dinfo, Key jobKey, Vec rowFilter) {
        super(cmp);
        this._dinfo = dinfo;
        this._jobKey = jobKey;
        this._rowFilter = rowFilter;
        this._sparse = this.handlesSparseData() && FrameUtils.sparseRatio((Frame)dinfo._adaptedFrame) < 0.5;
    }

    public T setSparse(boolean b) {
        this._sparse = b;
        return (T)((Object)((FrameTask2)this.self()));
    }

    public void chunkInit() {
    }

    public void chunkDone() {
    }

    public double sparseOffset() {
        return 0.0;
    }

    public boolean handlesSparseData() {
        return false;
    }

    protected abstract void processRow(DataInfo.Row var1);

    public void map(Chunk[] chks) {
        if (!(this._jobKey == null || DKV.get((Key)this._jobKey) != null && Job.isRunning((Key)this._jobKey))) {
            throw new Job.JobCancelledException();
        }
        Chunk rowFilter = this._rowFilter == null ? null : this._rowFilter.chunkForChunkIdx(chks[0].cidx());
        this.chunkInit();
        if (this._sparse) {
            for (DataInfo.Row r : this._dinfo.extractSparseRows(chks, this.sparseOffset())) {
                if (rowFilter != null && rowFilter.at8((int)(r.rid - chks[0].start())) != 0L) continue;
                this.processRow(r);
            }
        } else {
            DataInfo.Row row = this._dinfo.newDenseRow();
            for (int r = 0; r < chks[0]._len; ++r) {
                if (rowFilter != null && rowFilter.at8(r) != 0L) continue;
                this.processRow(this._dinfo.extractDenseRow(chks, r, row));
            }
        }
        this.chunkDone();
    }
}

