/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.tree.CompressedTree;
import water.DKV;
import water.Key;
import water.MRTask;
import water.fvec.Chunk;

public abstract class DTreeScorer<T extends DTreeScorer<T>>
extends MRTask<T> {
    protected final int _ncols;
    protected final int _nclass;
    protected final int _skip;
    protected final Key[][] _treeKeys;
    protected transient CompressedTree[][] _trees;

    public DTreeScorer(int ncols, int nclass, int skip, Key[][] treeKeys) {
        this._ncols = ncols;
        this._nclass = nclass;
        this._treeKeys = treeKeys;
        this._skip = skip;
    }

    protected int ntrees() {
        return this._trees.length;
    }

    protected final void setupLocal() {
        int ntrees = this._treeKeys.length;
        this._trees = new CompressedTree[ntrees][];
        for (int t = 0; t < ntrees; ++t) {
            Key[] treek = this._treeKeys[t];
            this._trees[t] = new CompressedTree[treek.length];
            for (int i = 0; i < treek.length; ++i) {
                if (treek[i] == null) continue;
                this._trees[t][i] = (CompressedTree)DKV.get((Key)treek[i]).get();
            }
        }
    }

    public final Chunk chk_oobt(Chunk[] chks) {
        return chks[this._ncols + 1 + this._nclass + this._nclass + this._nclass + this._skip];
    }

    public final Chunk chk_tree(Chunk[] chks, int c) {
        return chks[this._ncols + 1 + c + this._skip];
    }

    public final Chunk chk_resp(Chunk[] chks) {
        return chks[this._ncols];
    }

    protected void score0(double[] data, double[] preds, CompressedTree[] ts) {
        DTreeScorer.scoreTree(data, preds, ts);
    }

    public static void scoreTree(double[] data, double[] preds, CompressedTree[] ts) {
        for (int c = 0; c < ts.length; ++c) {
            if (ts[c] == null) continue;
            int n = ts.length == 1 ? 0 : c + 1;
            preds[n] = preds[n] + ts[c].score(data);
        }
    }
}

