/*
 * Decompiled with CFR 0.152.
 */
package hex.deeplearning;

import java.util.Arrays;
import java.util.TreeMap;
import water.DKV;
import water.Iced;
import water.Key;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;

public class Storage {
    static Frame toFrame(Vector v, Key key) {
        int log_rows_per_chunk = Math.max(1, 22 - (int)Math.floor(Math.log(1.0) / Math.log(2.0)));
        Vec vv = Vec.makeCon((double)0.0, (long)v.size(), (int)log_rows_per_chunk, (boolean)false);
        Frame f = new Frame(key, new Vec[]{vv}, true);
        Vec.Writer vw = f.vecs()[0].open();
        Throwable throwable = null;
        try {
            for (int r = 0; r < v.size(); ++r) {
                vw.set((long)r, v.get(r));
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (vw != null) {
                if (throwable != null) {
                    try {
                        vw.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                } else {
                    vw.close();
                }
            }
        }
        DKV.put((Key)key, (Iced)f);
        return f;
    }

    static Frame toFrame(Matrix m, Key key) {
        int log_rows_per_chunk = Math.max(1, 22 - (int)Math.floor(Math.log(m.cols()) / Math.log(2.0)));
        Vec[] v = new Vec[m.cols()];
        for (int i = 0; i < m.cols(); ++i) {
            v[i] = Vec.makeCon((double)0.0, (long)m.rows(), (int)log_rows_per_chunk);
        }
        Frame f = ((FrameFiller)new FrameFiller((Matrix)m).doAll((Frame)new Frame((Key)key, (Vec[])v, (boolean)true)))._fr;
        DKV.put((Key)key, (Iced)f);
        return f;
    }

    static class FrameFiller
    extends MRTask<FrameFiller> {
        final DenseColMatrix dcm;
        final DenseRowMatrix drm;
        final SparseRowMatrix srm;
        final SparseColMatrix scm;

        FrameFiller(Matrix m) {
            if (m instanceof DenseColMatrix) {
                this.dcm = (DenseColMatrix)m;
                this.drm = null;
                this.srm = null;
                this.scm = null;
            } else if (m instanceof DenseRowMatrix) {
                this.dcm = null;
                this.drm = (DenseRowMatrix)m;
                this.srm = null;
                this.scm = null;
            } else if (m instanceof SparseRowMatrix) {
                this.dcm = null;
                this.drm = null;
                this.srm = (SparseRowMatrix)m;
                this.scm = null;
            } else {
                this.dcm = null;
                this.drm = null;
                this.srm = null;
                this.scm = (SparseColMatrix)m;
            }
        }

        public void map(Chunk[] cs) {
            Iced m = null;
            if (this.dcm != null) {
                m = this.dcm;
            }
            if (this.drm != null) {
                m = this.drm;
            }
            if (this.scm != null) {
                m = this.scm;
            }
            if (this.srm != null) {
                m = this.srm;
            }
            int off = (int)cs[0].start();
            assert (m.cols() == cs.length);
            for (int c = 0; c < cs.length; ++c) {
                for (int r = 0; r < cs[0]._len; ++r) {
                    cs[c].set(r, m.get(off + r, c));
                }
            }
        }
    }

    static final class SparseColMatrix
    extends Iced
    implements Matrix {
        private TreeMap<Integer, Float>[] _cols;
        private int _rows;

        SparseColMatrix(int rows, int cols) {
            this(null, rows, cols);
        }

        SparseColMatrix(Matrix v, int rows, int cols) {
            this._rows = rows;
            this._cols = new TreeMap[cols];
            for (int col = 0; col < cols; ++col) {
                this._cols[col] = new TreeMap();
            }
            if (v != null) {
                for (int row = 0; row < rows; ++row) {
                    for (int col = 0; col < cols; ++col) {
                        if (v.get(row, col) == 0.0f) continue;
                        this.add(row, col, v.get(row, col));
                    }
                }
            }
        }

        @Override
        public float get(int row, int col) {
            Float v = this._cols[col].get(row);
            if (v == null) {
                return 0.0f;
            }
            return v.floatValue();
        }

        @Override
        public void add(int row, int col, float val) {
            this.set(row, col, this.get(row, col) + val);
        }

        @Override
        public void set(int row, int col, float val) {
            this._cols[col].put(row, Float.valueOf(val));
        }

        @Override
        public int cols() {
            return this._cols.length;
        }

        @Override
        public int rows() {
            return this._rows;
        }

        @Override
        public long size() {
            return (long)this._rows * (long)this._cols.length;
        }

        TreeMap<Integer, Float> col(int col) {
            return this._cols[col];
        }

        @Override
        public float[] raw() {
            throw new UnsupportedOperationException("raw access to the data in a sparse matrix is not implemented.");
        }

        @Override
        public Frame toFrame(Key key) {
            return Storage.toFrame(this, key);
        }
    }

    public static final class SparseRowMatrix
    extends Iced
    implements Matrix {
        private TreeMap<Integer, Float>[] _rows;
        private int _cols;

        SparseRowMatrix(int rows, int cols) {
            this(null, rows, cols);
        }

        SparseRowMatrix(Matrix v, int rows, int cols) {
            int row;
            this._rows = new TreeMap[rows];
            for (row = 0; row < rows; ++row) {
                this._rows[row] = new TreeMap();
            }
            this._cols = cols;
            if (v != null) {
                for (row = 0; row < rows; ++row) {
                    for (int col = 0; col < cols; ++col) {
                        if (v.get(row, col) == 0.0f) continue;
                        this.add(row, col, v.get(row, col));
                    }
                }
            }
        }

        @Override
        public float get(int row, int col) {
            Float v = this._rows[row].get(col);
            if (v == null) {
                return 0.0f;
            }
            return v.floatValue();
        }

        @Override
        public void add(int row, int col, float val) {
            this.set(row, col, this.get(row, col) + val);
        }

        @Override
        public void set(int row, int col, float val) {
            this._rows[row].put(col, Float.valueOf(val));
        }

        @Override
        public int cols() {
            return this._cols;
        }

        @Override
        public int rows() {
            return this._rows.length;
        }

        @Override
        public long size() {
            return (long)this._rows.length * (long)this._cols;
        }

        TreeMap<Integer, Float> row(int row) {
            return this._rows[row];
        }

        @Override
        public float[] raw() {
            throw new UnsupportedOperationException("raw access to the data in a sparse matrix is not implemented.");
        }

        @Override
        public Frame toFrame(Key key) {
            return Storage.toFrame(this, key);
        }
    }

    public static final class DenseColMatrix
    extends Iced
    implements Matrix {
        private float[] _data;
        private int _cols;
        private int _rows;

        DenseColMatrix(int rows, int cols) {
            this(new float[cols * rows], rows, cols);
        }

        DenseColMatrix(float[] v, int rows, int cols) {
            this._data = v;
            this._rows = rows;
            this._cols = cols;
        }

        DenseColMatrix(DenseRowMatrix m, int rows, int cols) {
            this(rows, cols);
            for (int row = 0; row < rows; ++row) {
                for (int col = 0; col < cols; ++col) {
                    this.set(row, col, m.get(row, col));
                }
            }
        }

        @Override
        public float get(int row, int col) {
            assert (row < this._rows && col < this._cols);
            return this._data[col * this._rows + row];
        }

        @Override
        public void set(int row, int col, float val) {
            assert (row < this._rows && col < this._cols);
            this._data[col * this._rows + row] = val;
        }

        @Override
        public void add(int row, int col, float val) {
            assert (row < this._rows && col < this._cols);
            int n = col * this._rows + row;
            this._data[n] = this._data[n] + val;
        }

        @Override
        public int cols() {
            return this._cols;
        }

        @Override
        public int rows() {
            return this._rows;
        }

        @Override
        public long size() {
            return (long)this._rows * (long)this._cols;
        }

        @Override
        public float[] raw() {
            return this._data;
        }

        @Override
        public Frame toFrame(Key key) {
            return Storage.toFrame(this, key);
        }
    }

    public static final class DenseRowMatrix
    extends Iced
    implements Matrix {
        private float[] _data;
        private int _cols;
        private int _rows;

        DenseRowMatrix(int rows, int cols) {
            this(new float[cols * rows], rows, cols);
        }

        DenseRowMatrix(float[] v, int rows, int cols) {
            this._data = v;
            this._rows = rows;
            this._cols = cols;
        }

        @Override
        public float get(int row, int col) {
            assert (row < this._rows && col < this._cols) : "_data.length: " + this._data.length + ", checking: " + row + " < " + this._rows + " && " + col + " < " + this._cols;
            return this._data[row * this._cols + col];
        }

        @Override
        public void set(int row, int col, float val) {
            assert (row < this._rows && col < this._cols);
            this._data[row * this._cols + col] = val;
        }

        @Override
        public void add(int row, int col, float val) {
            assert (row < this._rows && col < this._cols);
            int n = row * this._cols + col;
            this._data[n] = this._data[n] + val;
        }

        @Override
        public int cols() {
            return this._cols;
        }

        @Override
        public int rows() {
            return this._rows;
        }

        @Override
        public long size() {
            return (long)this._rows * (long)this._cols;
        }

        @Override
        public float[] raw() {
            return this._data;
        }

        @Override
        public Frame toFrame(Key key) {
            return Storage.toFrame(this, key);
        }
    }

    public static class SparseVector
    extends Iced
    implements Vector {
        int[] _indices;
        double[] _values;
        private int _size;
        private int _nnz;

        @Override
        public int size() {
            return this._size;
        }

        public int nnz() {
            return this._nnz;
        }

        SparseVector(double[] v) {
            this(new DenseVector(v));
        }

        SparseVector(DenseVector dv) {
            this._size = dv.size();
            for (int i = 0; i < dv._data.length; ++i) {
                if (dv.get(i) == 0.0) continue;
                ++this._nnz;
            }
            this._indices = new int[this._nnz];
            this._values = new double[this._nnz];
            int idx = 0;
            for (int i = 0; i < dv._data.length; ++i) {
                if (dv.get(i) == 0.0) continue;
                this._indices[idx] = i;
                this._values[idx] = dv.get(i);
                ++idx;
            }
            assert (idx == this.nnz());
        }

        @Override
        public double get(int i) {
            int idx = Arrays.binarySearch(this._indices, i);
            return idx < 0 ? 0.0 : this._values[idx];
        }

        @Override
        public void set(int i, double val) {
            throw new UnsupportedOperationException("setting values in a sparse vector is not implemented.");
        }

        @Override
        public void add(int i, double val) {
            throw new UnsupportedOperationException("adding values in a sparse vector is not implemented.");
        }

        @Override
        public double[] raw() {
            throw new UnsupportedOperationException("raw access to the data in a sparse vector is not implemented.");
        }

        public Iterator begin() {
            return new Iterator(0);
        }

        public Iterator end() {
            return new Iterator(this._indices.length);
        }

        @Override
        public Frame toFrame(Key key) {
            return Storage.toFrame(this, key);
        }

        public class Iterator {
            int _idx;

            Iterator(int id) {
                this._idx = id;
            }

            Iterator next() {
                ++this._idx;
                return this;
            }

            boolean equals(Iterator other) {
                return this._idx == other._idx;
            }

            public String toString() {
                return this.index() + " -> " + this.value();
            }

            double value() {
                return SparseVector.this._values[this._idx];
            }

            int index() {
                return SparseVector.this._indices[this._idx];
            }

            void setValue(double val) {
                SparseVector.this._values[this._idx] = val;
            }
        }
    }

    public static class DenseVector
    extends Iced
    implements Vector {
        private double[] _data;

        DenseVector(int len) {
            this._data = new double[len];
        }

        DenseVector(double[] v) {
            this._data = v;
        }

        @Override
        public double get(int i) {
            return this._data[i];
        }

        @Override
        public void set(int i, double val) {
            this._data[i] = val;
        }

        @Override
        public void add(int i, double val) {
            int n = i;
            this._data[n] = this._data[n] + val;
        }

        @Override
        public int size() {
            return this._data.length;
        }

        @Override
        public double[] raw() {
            return this._data;
        }

        @Override
        public Frame toFrame(Key key) {
            return Storage.toFrame(this, key);
        }
    }

    public static interface Tensor {
        public float get(int var1, int var2, int var3);

        public void set(int var1, int var2, int var3, float var4);

        public void add(int var1, int var2, int var3, float var4);

        public int slices();

        public int cols();

        public int rows();

        public long size();

        public float[] raw();

        public Frame toFrame(int var1, Key var2);
    }

    public static interface Matrix {
        public float get(int var1, int var2);

        public void set(int var1, int var2, float var3);

        public void add(int var1, int var2, float var3);

        public int cols();

        public int rows();

        public long size();

        public float[] raw();

        public Frame toFrame(Key var1);
    }

    public static interface Vector {
        public double get(int var1);

        public void set(int var1, double var2);

        public void add(int var1, double var2);

        public int size();

        public double[] raw();

        public Frame toFrame(Key var1);
    }
}

