/*
 * Decompiled with CFR 0.152.
 */
package hex.glm;

import hex.AUC2;
import hex.Model;
import hex.ModelMetrics;
import hex.ModelMetricsBinomial;
import hex.ModelMetricsBinomialGLM;
import hex.ModelMetricsRegression;
import hex.ModelMetricsRegressionGLM;
import hex.glm.GLMModel;
import water.DKV;
import water.Iced;
import water.Key;
import water.fvec.Frame;
import water.util.ArrayUtils;
import water.util.MathUtils;

public class GLMValidation
extends ModelMetricsBinomial.MetricBuilderBinomial<GLMValidation> {
    double residual_deviance;
    double null_deviance;
    final double _ymu;
    final double _ymuLink;
    long nobs;
    double aic;
    private double _aic2;
    final GLMModel.GLMParameters _parms;
    private final int _rank;
    final double _threshold;
    AUC2 _auc2;
    ModelMetrics.MetricBuilder _metricBuilder;
    boolean _intercept = true;
    final boolean _computeMetrics;
    transient double[] _ds = new double[3];
    transient float[] _yact = new float[1];
    private transient ModelMetrics _metrics;

    public GLMValidation(String[] domain, boolean intercept, double ymu, GLMModel.GLMParameters parms, int rank, double threshold, boolean computeMetrics) {
        super(domain);
        this._intercept = intercept;
        this._rank = rank;
        this._parms = parms;
        this._threshold = threshold;
        this._computeMetrics = computeMetrics;
        this._ymu = parms._intercept ? ymu : (parms._family == GLMModel.GLMParameters.Family.binomial ? 0.5 : 0.0);
        this._ymuLink = this._parms.link(ymu);
        if (this._computeMetrics) {
            this._metricBuilder = this._parms._family == GLMModel.GLMParameters.Family.binomial ? new ModelMetricsBinomial.MetricBuilderBinomial(domain) : new ModelMetricsRegression.MetricBuilderRegression();
        }
    }

    public double explainedDev() {
        return 1.0 - this.residualDeviance() / this.nullDeviance();
    }

    public double[] perRow(double[] ds, float[] yact, Model m) {
        return this.perRow(ds, yact, 1.0, 0.0, m);
    }

    public double[] perRow(double[] ds, float[] yact, double weight, double offset, Model m) {
        if (weight == 0.0) {
            return ds;
        }
        this._metricBuilder.perRow(ds, yact, weight, offset, m);
        if (!ArrayUtils.hasNaNsOrInfs((double[])ds) && !ArrayUtils.hasNaNsOrInfs((float[])yact)) {
            if (this._parms._family == GLMModel.GLMParameters.Family.binomial) {
                this.add2(yact[0], ds[2], weight, offset);
            } else {
                this.add2(yact[0], ds[0], weight, offset);
            }
        }
        return ds;
    }

    public void add(double yreal, double ymodel, double weight, double offset) {
        if (weight == 0.0) {
            return;
        }
        this._yact[0] = (float)yreal;
        if (this._parms._family == GLMModel.GLMParameters.Family.binomial) {
            this._ds[0] = ymodel > this._threshold ? 1.0 : 0.0;
            this._ds[1] = 1.0 - ymodel;
            this._ds[2] = ymodel;
        } else {
            this._ds[0] = ymodel;
        }
        if (this._computeMetrics) {
            this._metricBuilder.perRow(this._ds, this._yact, weight, offset, null);
        }
        this.add2(yreal, ymodel, weight, offset);
    }

    private void add2(double yreal, double ymodel, double weight, double offset) {
        this._wcount += weight;
        this.residual_deviance += weight * this._parms.deviance(yreal, ymodel);
        double ynull = offset == 0.0 ? this._ymu : this._parms.linkInv(offset + this._ymuLink);
        this.null_deviance += weight * this._parms.deviance(yreal, ynull);
        ++this.nobs;
        if (this._parms._family == GLMModel.GLMParameters.Family.poisson) {
            long y = Math.round(yreal);
            double logfactorial = 0.0;
            for (long i = 2L; i <= y; ++i) {
                logfactorial += Math.log(i);
            }
            this._aic2 += weight * (yreal * Math.log(ymodel) - logfactorial - ymodel);
        }
    }

    public void reduce(GLMValidation v) {
        if (this._computeMetrics) {
            this._metricBuilder.reduce(v._metricBuilder);
        }
        this.residual_deviance += v.residual_deviance;
        this.null_deviance += v.null_deviance;
        this.nobs += v.nobs;
        this._aic2 += v._aic2;
        this._wcount += v._wcount;
    }

    public final double nullDeviance() {
        return this.null_deviance;
    }

    public final double residualDeviance() {
        return this.residual_deviance;
    }

    public final long nullDOF() {
        return this.nobs - (long)(this._intercept ? 1 : 0);
    }

    public final long resDOF() {
        return this.nobs - (long)this._rank;
    }

    protected double computeAUC() {
        if (this._parms._family != GLMModel.GLMParameters.Family.binomial) {
            throw new IllegalArgumentException("AUC only defined for family == 'binomial', got '" + (Object)((Object)this._parms._family) + "'");
        }
        return ((ModelMetricsBinomial.MetricBuilderBinomial)this._metricBuilder).auc();
    }

    protected void computeAIC() {
        this.aic = 0.0;
        switch (this._parms._family) {
            case gaussian: {
                this.aic = (double)this.nobs * (Math.log(this.residual_deviance / (double)this.nobs * 2.0 * Math.PI) + 1.0) + 2.0;
                break;
            }
            case binomial: {
                this.aic = this.residual_deviance;
                break;
            }
            case poisson: {
                this.aic = -2.0 * this._aic2;
                break;
            }
            case gamma: {
                this.aic = Double.NaN;
                break;
            }
            case tweedie: {
                this.aic = Double.NaN;
                break;
            }
            default: {
                assert (false) : "missing implementation for family " + (Object)((Object)this._parms._family);
                break;
            }
        }
        this.aic += (double)(2 * this._rank);
    }

    public String toString() {
        if (this._metricBuilder != null) {
            return this._metricBuilder.toString() + ", explained_dev = " + MathUtils.roundToNDigits((double)(1.0 - this.residual_deviance / this.null_deviance), (int)5);
        }
        return "explained dev = " + MathUtils.roundToNDigits((double)(1.0 - this.residual_deviance / this.null_deviance), (int)5);
    }

    public ModelMetrics makeModelMetrics(Model m, Frame f) {
        ModelMetrics metrics;
        GLMModel gm = (GLMModel)m;
        this.computeAIC();
        ModelMetrics modelMetrics = metrics = this._metrics == null ? this._metricBuilder.makeModelMetrics(m, f) : this._metrics;
        if (this._parms._family == GLMModel.GLMParameters.Family.binomial) {
            ModelMetricsBinomial metricsBinommial = (ModelMetricsBinomial)metrics;
            metrics = new ModelMetricsBinomialGLM(m, f, metrics._MSE, this._domain, metricsBinommial._sigma, metricsBinommial._auc, metricsBinommial._logloss, this.residualDeviance(), this.nullDeviance(), this.aic, this.nullDOF(), this.resDOF());
        } else {
            ModelMetricsRegression metricsRegression = (ModelMetricsRegression)metrics;
            metrics = new ModelMetricsRegressionGLM(m, f, metricsRegression._MSE, metricsRegression._sigma, this.residualDeviance(), this.residualDeviance() / this._wcount, this.nullDeviance(), this.aic, this.nullDOF(), this.resDOF());
        }
        DKV.put((Key)metrics._key, (Iced)metrics);
        return ((GLMModel.GLMOutput)gm._output).addModelMetrics(metrics);
    }
}

