/*
 * Decompiled with CFR 0.152.
 */
package hex.ensemble;

import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.StackedEnsembleModel;
import hex.deeplearning.DeepLearning;
import hex.deeplearning.DeepLearningModel;
import hex.glm.GLM;
import hex.glm.GLMModel;
import hex.schemas.DRFV3;
import hex.schemas.DeepLearningV3;
import hex.schemas.GBMV3;
import hex.schemas.GLMV3;
import hex.tree.drf.DRF;
import hex.tree.drf.DRFModel;
import hex.tree.gbm.GBM;
import hex.tree.gbm.GBMModel;
import water.DKV;
import water.Job;
import water.Key;
import water.exceptions.H2OIllegalArgumentException;
import water.fvec.Frame;
import water.util.Log;

class Metalearner {
    private Frame _levelOneTrainingFrame;
    private Frame _levelOneValidationFrame;
    private Model.Parameters _metalearner_parameters;
    private StackedEnsembleModel _model;
    private Job _job;
    private Key<Model> _metalearnerKey;
    private Job _metalearnerJob;
    private StackedEnsembleModel.StackedEnsembleParameters _parms;
    private boolean _hasMetalearnerParams;
    private long _metalearnerSeed;

    Metalearner(Frame levelOneTrainingFrame, Frame levelOneValidationFrame, Model.Parameters metalearner_parameters, StackedEnsembleModel model, Job StackedEnsembleJob, Key<Model> metalearnerKey, Job metalearnerJob, StackedEnsembleModel.StackedEnsembleParameters parms, boolean hasMetalearnerParams, long metalearnerSeed) {
        this._levelOneTrainingFrame = levelOneTrainingFrame;
        this._levelOneValidationFrame = levelOneValidationFrame;
        this._metalearner_parameters = metalearner_parameters;
        this._model = model;
        this._job = StackedEnsembleJob;
        this._metalearnerKey = metalearnerKey;
        this._metalearnerJob = metalearnerJob;
        this._parms = parms;
        this._hasMetalearnerParams = hasMetalearnerParams;
        this._metalearnerSeed = metalearnerSeed;
    }

    void computeAutoMetalearner() {
        GLM metaGLMBuilder = (GLM)ModelBuilder.make((String)"GLM", (Job)this._metalearnerJob, this._metalearnerKey);
        ((GLMModel.GLMParameters)metaGLMBuilder._parms)._seed = this._metalearnerSeed;
        ((GLMModel.GLMParameters)metaGLMBuilder._parms)._non_negative = true;
        ((GLMModel.GLMParameters)metaGLMBuilder._parms)._train = this._levelOneTrainingFrame._key;
        ((GLMModel.GLMParameters)metaGLMBuilder._parms)._valid = this._levelOneValidationFrame == null ? null : this._levelOneValidationFrame._key;
        ((GLMModel.GLMParameters)metaGLMBuilder._parms)._response_column = this._model.responseColumn;
        if (((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._metalearner_fold_column == null) {
            ((GLMModel.GLMParameters)metaGLMBuilder._parms)._nfolds = ((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._metalearner_nfolds;
            if (((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._metalearner_nfolds > 1) {
                ((GLMModel.GLMParameters)metaGLMBuilder._parms)._fold_assignment = ((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._metalearner_fold_assignment == null ? Model.Parameters.FoldAssignmentScheme.AUTO : ((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._metalearner_fold_assignment;
            }
        } else {
            ((GLMModel.GLMParameters)metaGLMBuilder._parms)._fold_column = ((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._metalearner_fold_column;
        }
        if (((GLMModel.GLMParameters)metaGLMBuilder._parms)._valid != null) {
            ((GLMModel.GLMParameters)metaGLMBuilder._parms)._lambda_search = true;
            ((GLMModel.GLMParameters)metaGLMBuilder._parms)._early_stopping = false;
        }
        if (this._model.modelCategory == ModelCategory.Regression) {
            ((GLMModel.GLMParameters)metaGLMBuilder._parms)._family = GLMModel.GLMParameters.Family.gaussian;
        } else if (this._model.modelCategory == ModelCategory.Binomial) {
            ((GLMModel.GLMParameters)metaGLMBuilder._parms)._family = GLMModel.GLMParameters.Family.binomial;
        } else if (this._model.modelCategory == ModelCategory.Multinomial) {
            ((GLMModel.GLMParameters)metaGLMBuilder._parms)._family = GLMModel.GLMParameters.Family.multinomial;
        } else {
            throw new H2OIllegalArgumentException("Family " + this._model.modelCategory + "  is not supported.");
        }
        metaGLMBuilder.init(false);
        Job j = metaGLMBuilder.trainModel();
        while (j.isRunning()) {
            try {
                this._job.update(j._work, "training metalearner(" + (Object)((Object)((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._metalearner_algorithm) + ")");
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        Log.info((Object[])new Object[]{"Finished training metalearner model(" + (Object)((Object)((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._metalearner_algorithm) + ")."});
        ((StackedEnsembleModel.StackedEnsembleOutput)this._model._output)._metalearner = metaGLMBuilder.get();
        this._model.doScoreOrCopyMetrics(this._job);
        if (this._parms._keep_levelone_frame) {
            ((StackedEnsembleModel.StackedEnsembleOutput)this._model._output)._levelone_frame_id = this._levelOneTrainingFrame;
        } else {
            DKV.remove((Key)this._levelOneTrainingFrame._key);
        }
        if (null != this._levelOneValidationFrame) {
            DKV.remove((Key)this._levelOneValidationFrame._key);
        }
        this._model.update(this._job);
        this._model.unlock(this._job);
    }

    void computeGBMMetalearner() {
        GBM metaGBMBuilder = (GBM)ModelBuilder.make((String)"GBM", (Job)this._metalearnerJob, this._metalearnerKey);
        GBMV3.GBMParametersV3 params = new GBMV3.GBMParametersV3();
        params.init_meta();
        params.fillFromImpl(metaGBMBuilder._parms);
        if (this._hasMetalearnerParams) {
            GBMModel.GBMParameters gbmParams = (GBMModel.GBMParameters)this._metalearner_parameters;
            metaGBMBuilder._parms = gbmParams;
        }
        if (((GBMModel.GBMParameters)metaGBMBuilder._parms)._seed == -1L) {
            ((GBMModel.GBMParameters)metaGBMBuilder._parms)._seed = this._metalearnerSeed;
        }
        ((GBMModel.GBMParameters)metaGBMBuilder._parms)._seed = this._metalearnerSeed;
        ((GBMModel.GBMParameters)metaGBMBuilder._parms)._train = this._levelOneTrainingFrame._key;
        ((GBMModel.GBMParameters)metaGBMBuilder._parms)._valid = this._levelOneValidationFrame == null ? null : this._levelOneValidationFrame._key;
        ((GBMModel.GBMParameters)metaGBMBuilder._parms)._response_column = this._model.responseColumn;
        ((GBMModel.GBMParameters)metaGBMBuilder._parms)._nfolds = ((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._metalearner_nfolds;
        if (((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._metalearner_fold_column == null) {
            ((GBMModel.GBMParameters)metaGBMBuilder._parms)._nfolds = ((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._metalearner_nfolds;
            if (((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._metalearner_nfolds > 1) {
                ((GBMModel.GBMParameters)metaGBMBuilder._parms)._fold_assignment = ((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._metalearner_fold_assignment == null ? Model.Parameters.FoldAssignmentScheme.AUTO : ((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._metalearner_fold_assignment;
            }
        } else {
            ((GBMModel.GBMParameters)metaGBMBuilder._parms)._fold_column = ((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._metalearner_fold_column;
        }
        metaGBMBuilder.init(false);
        Job j = metaGBMBuilder.trainModel();
        while (j.isRunning()) {
            try {
                this._job.update(j._work, "training metalearner(" + (Object)((Object)((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._metalearner_algorithm) + ")");
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        Log.info((Object[])new Object[]{"Finished training metalearner model(" + (Object)((Object)((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._metalearner_algorithm) + ")."});
        ((StackedEnsembleModel.StackedEnsembleOutput)this._model._output)._metalearner = metaGBMBuilder.get();
        this._model.doScoreOrCopyMetrics(this._job);
        if (this._parms._keep_levelone_frame) {
            ((StackedEnsembleModel.StackedEnsembleOutput)this._model._output)._levelone_frame_id = this._levelOneTrainingFrame;
        } else {
            DKV.remove((Key)this._levelOneTrainingFrame._key);
        }
        if (null != this._levelOneValidationFrame) {
            DKV.remove((Key)this._levelOneValidationFrame._key);
        }
        this._model.update(this._job);
        this._model.unlock(this._job);
    }

    void computeDRFMetalearner() {
        DRF metaDRFBuilder = (DRF)ModelBuilder.make((String)"DRF", (Job)this._metalearnerJob, this._metalearnerKey);
        DRFV3.DRFParametersV3 params = new DRFV3.DRFParametersV3();
        params.init_meta();
        params.fillFromImpl(metaDRFBuilder._parms);
        if (this._hasMetalearnerParams) {
            DRFModel.DRFParameters drfParams = (DRFModel.DRFParameters)this._metalearner_parameters;
            metaDRFBuilder._parms = drfParams;
        }
        if (((DRFModel.DRFParameters)metaDRFBuilder._parms)._seed == -1L) {
            ((DRFModel.DRFParameters)metaDRFBuilder._parms)._seed = this._metalearnerSeed;
        }
        ((DRFModel.DRFParameters)metaDRFBuilder._parms)._train = this._levelOneTrainingFrame._key;
        ((DRFModel.DRFParameters)metaDRFBuilder._parms)._valid = this._levelOneValidationFrame == null ? null : this._levelOneValidationFrame._key;
        ((DRFModel.DRFParameters)metaDRFBuilder._parms)._response_column = this._model.responseColumn;
        ((DRFModel.DRFParameters)metaDRFBuilder._parms)._nfolds = ((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._metalearner_nfolds;
        if (((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._metalearner_fold_column == null) {
            ((DRFModel.DRFParameters)metaDRFBuilder._parms)._nfolds = ((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._metalearner_nfolds;
            if (((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._metalearner_nfolds > 1) {
                ((DRFModel.DRFParameters)metaDRFBuilder._parms)._fold_assignment = ((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._metalearner_fold_assignment == null ? Model.Parameters.FoldAssignmentScheme.AUTO : ((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._metalearner_fold_assignment;
            }
        } else {
            ((DRFModel.DRFParameters)metaDRFBuilder._parms)._fold_column = ((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._metalearner_fold_column;
        }
        metaDRFBuilder.init(false);
        Job j = metaDRFBuilder.trainModel();
        while (j.isRunning()) {
            try {
                this._job.update(j._work, "training metalearner(" + (Object)((Object)((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._metalearner_algorithm) + ")");
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        Log.info((Object[])new Object[]{"Finished training metalearner model(" + (Object)((Object)((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._metalearner_algorithm) + ")."});
        ((StackedEnsembleModel.StackedEnsembleOutput)this._model._output)._metalearner = metaDRFBuilder.get();
        this._model.doScoreOrCopyMetrics(this._job);
        if (this._parms._keep_levelone_frame) {
            ((StackedEnsembleModel.StackedEnsembleOutput)this._model._output)._levelone_frame_id = this._levelOneTrainingFrame;
        } else {
            DKV.remove((Key)this._levelOneTrainingFrame._key);
        }
        if (null != this._levelOneValidationFrame) {
            DKV.remove((Key)this._levelOneValidationFrame._key);
        }
        this._model.update(this._job);
        this._model.unlock(this._job);
    }

    void computeGLMMetalearner() {
        GLM metaGLMBuilder = (GLM)ModelBuilder.make((String)"GLM", (Job)this._metalearnerJob, this._metalearnerKey);
        GLMV3.GLMParametersV3 params = new GLMV3.GLMParametersV3();
        params.init_meta();
        params.fillFromImpl(metaGLMBuilder._parms);
        if (this._hasMetalearnerParams) {
            GLMModel.GLMParameters glmParams = (GLMModel.GLMParameters)this._metalearner_parameters;
            metaGLMBuilder._parms = glmParams;
        }
        if (((GLMModel.GLMParameters)metaGLMBuilder._parms)._seed == -1L) {
            ((GLMModel.GLMParameters)metaGLMBuilder._parms)._seed = this._metalearnerSeed;
        }
        ((GLMModel.GLMParameters)metaGLMBuilder._parms)._train = this._levelOneTrainingFrame._key;
        ((GLMModel.GLMParameters)metaGLMBuilder._parms)._valid = this._levelOneValidationFrame == null ? null : this._levelOneValidationFrame._key;
        ((GLMModel.GLMParameters)metaGLMBuilder._parms)._response_column = this._model.responseColumn;
        ((GLMModel.GLMParameters)metaGLMBuilder._parms)._nfolds = ((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._metalearner_nfolds;
        if (((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._metalearner_fold_column == null) {
            ((GLMModel.GLMParameters)metaGLMBuilder._parms)._nfolds = ((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._metalearner_nfolds;
            if (((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._metalearner_nfolds > 1) {
                ((GLMModel.GLMParameters)metaGLMBuilder._parms)._fold_assignment = ((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._metalearner_fold_assignment == null ? Model.Parameters.FoldAssignmentScheme.AUTO : ((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._metalearner_fold_assignment;
            }
        } else {
            ((GLMModel.GLMParameters)metaGLMBuilder._parms)._fold_column = ((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._metalearner_fold_column;
        }
        if (this._model.modelCategory == ModelCategory.Regression) {
            ((GLMModel.GLMParameters)metaGLMBuilder._parms)._family = GLMModel.GLMParameters.Family.gaussian;
        } else if (this._model.modelCategory == ModelCategory.Binomial) {
            ((GLMModel.GLMParameters)metaGLMBuilder._parms)._family = GLMModel.GLMParameters.Family.binomial;
        } else if (this._model.modelCategory == ModelCategory.Multinomial) {
            ((GLMModel.GLMParameters)metaGLMBuilder._parms)._family = GLMModel.GLMParameters.Family.multinomial;
        } else {
            throw new H2OIllegalArgumentException("Family " + this._model.modelCategory + "  is not supported.");
        }
        metaGLMBuilder.init(false);
        Job j = metaGLMBuilder.trainModel();
        while (j.isRunning()) {
            try {
                this._job.update(j._work, "training metalearner(" + (Object)((Object)((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._metalearner_algorithm) + ")");
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        Log.info((Object[])new Object[]{"Finished training metalearner model(" + (Object)((Object)((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._metalearner_algorithm) + ")."});
        ((StackedEnsembleModel.StackedEnsembleOutput)this._model._output)._metalearner = metaGLMBuilder.get();
        this._model.doScoreOrCopyMetrics(this._job);
        if (this._parms._keep_levelone_frame) {
            ((StackedEnsembleModel.StackedEnsembleOutput)this._model._output)._levelone_frame_id = this._levelOneTrainingFrame;
        } else {
            DKV.remove((Key)this._levelOneTrainingFrame._key);
        }
        if (null != this._levelOneValidationFrame) {
            DKV.remove((Key)this._levelOneValidationFrame._key);
        }
        this._model.update(this._job);
        this._model.unlock(this._job);
    }

    void computeDeepLearningMetalearner() {
        DeepLearning metaDeepLearningBuilder = (DeepLearning)ModelBuilder.make((String)"DeepLearning", (Job)this._metalearnerJob, this._metalearnerKey);
        DeepLearningV3.DeepLearningParametersV3 params = new DeepLearningV3.DeepLearningParametersV3();
        params.init_meta();
        params.fillFromImpl(metaDeepLearningBuilder._parms);
        if (this._hasMetalearnerParams) {
            DeepLearningModel.DeepLearningParameters dlParams = (DeepLearningModel.DeepLearningParameters)this._metalearner_parameters;
            metaDeepLearningBuilder._parms = dlParams;
        }
        if (((DeepLearningModel.DeepLearningParameters)metaDeepLearningBuilder._parms)._seed == -1L) {
            ((DeepLearningModel.DeepLearningParameters)metaDeepLearningBuilder._parms)._seed = this._metalearnerSeed;
        }
        ((DeepLearningModel.DeepLearningParameters)metaDeepLearningBuilder._parms)._train = this._levelOneTrainingFrame._key;
        ((DeepLearningModel.DeepLearningParameters)metaDeepLearningBuilder._parms)._valid = this._levelOneValidationFrame == null ? null : this._levelOneValidationFrame._key;
        ((DeepLearningModel.DeepLearningParameters)metaDeepLearningBuilder._parms)._response_column = this._model.responseColumn;
        ((DeepLearningModel.DeepLearningParameters)metaDeepLearningBuilder._parms)._nfolds = ((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._metalearner_nfolds;
        if (((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._metalearner_fold_column == null) {
            ((DeepLearningModel.DeepLearningParameters)metaDeepLearningBuilder._parms)._nfolds = ((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._metalearner_nfolds;
            if (((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._metalearner_nfolds > 1) {
                ((DeepLearningModel.DeepLearningParameters)metaDeepLearningBuilder._parms)._fold_assignment = ((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._metalearner_fold_assignment == null ? Model.Parameters.FoldAssignmentScheme.AUTO : ((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._metalearner_fold_assignment;
            }
        } else {
            ((DeepLearningModel.DeepLearningParameters)metaDeepLearningBuilder._parms)._fold_column = ((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._metalearner_fold_column;
        }
        metaDeepLearningBuilder.init(false);
        Job j = metaDeepLearningBuilder.trainModel();
        while (j.isRunning()) {
            try {
                this._job.update(j._work, "training metalearner(" + (Object)((Object)((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._metalearner_algorithm) + ")");
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        Log.info((Object[])new Object[]{"Finished training metalearner model(" + (Object)((Object)((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._metalearner_algorithm) + ")."});
        ((StackedEnsembleModel.StackedEnsembleOutput)this._model._output)._metalearner = metaDeepLearningBuilder.get();
        this._model.doScoreOrCopyMetrics(this._job);
        if (this._parms._keep_levelone_frame) {
            ((StackedEnsembleModel.StackedEnsembleOutput)this._model._output)._levelone_frame_id = this._levelOneTrainingFrame;
        } else {
            DKV.remove((Key)this._levelOneTrainingFrame._key);
        }
        if (null != this._levelOneValidationFrame) {
            DKV.remove((Key)this._levelOneValidationFrame._key);
        }
        this._model.update(this._job);
        this._model.unlock(this._job);
    }
}

