/*
 * Decompiled with CFR 0.152.
 */
package hex.grep;

import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.grep.GrepModel;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import water.H2O;
import water.MRTask;
import water.fvec.ByteVec;
import water.fvec.Chunk;
import water.fvec.Vec;
import water.util.Log;

public class Grep
extends ModelBuilder<GrepModel, GrepModel.GrepParameters, GrepModel.GrepOutput> {
    Pattern _pattern = null;

    public Grep(GrepModel.GrepParameters parms) {
        super((Model.Parameters)parms);
        this.init(false);
    }

    protected GrepDriver trainModelImpl() {
        return new GrepDriver();
    }

    public ModelCategory[] can_build() {
        return new ModelCategory[]{ModelCategory.Unknown};
    }

    public ModelBuilder.BuilderVisibility builderVisibility() {
        return ModelBuilder.BuilderVisibility.Experimental;
    }

    public boolean isSupervised() {
        return false;
    }

    public void init(boolean expensive) {
        super.init(expensive);
        if (((GrepModel.GrepParameters)this._parms)._regex == null) {
            this.error("_regex", "regex is missing");
        } else {
            try {
                this._pattern = Pattern.compile(((GrepModel.GrepParameters)this._parms)._regex);
            }
            catch (PatternSyntaxException pse) {
                this.error("regex", pse.getMessage());
            }
        }
        if (((GrepModel.GrepParameters)this._parms)._train == null) {
            return;
        }
        Vec[] vecs = ((GrepModel.GrepParameters)this._parms).train().vecs();
        if (vecs.length != 1) {
            this.error("_train", "Frame must contain exactly 1 Vec (of raw text)");
        }
        if (!(vecs[0] instanceof ByteVec)) {
            this.error("_train", "Frame must contain exactly 1 Vec (of raw text)");
        }
    }

    private class GrepGrep
    extends MRTask<GrepGrep> {
        private final Pattern _pattern;
        String[] _matches;
        long[] _offsets;
        int _cnt;

        GrepGrep(Pattern pattern) {
            this._pattern = pattern;
        }

        public void map(Chunk chk) {
            this._matches = new String[1];
            this._offsets = new long[1];
            ByteSeq bs = new ByteSeq(chk, chk.nextChunk());
            Matcher m = this._pattern.matcher(bs);
            while (m.find() && m.start() < bs._bs0.length) {
                this.add(bs.str(m.start(), m.end()), chk.start() + (long)m.start());
            }
            Grep.this._job.update((long)chk._len);
        }

        public void reduce(GrepGrep gg1) {
            GrepGrep gg0 = this;
            if (gg0._cnt < gg1._cnt) {
                gg0 = gg1;
                gg1 = this;
            }
            for (int i = 0; i < gg1._cnt; ++i) {
                gg0.add(gg1._matches[i], gg1._offsets[i]);
            }
            if (gg0 != this) {
                this._matches = gg0._matches;
                this._offsets = gg0._offsets;
                this._cnt = gg0._cnt;
            }
        }

        private void add(String s, long off) {
            if (this._cnt == this._matches.length) {
                this._matches = Arrays.copyOf(this._matches, this._cnt << 1);
                this._offsets = Arrays.copyOf(this._offsets, this._cnt << 1);
            }
            this._matches[this._cnt] = s;
            this._offsets[this._cnt++] = off;
        }
    }

    private class ByteSeq
    implements CharSequence {
        private final byte[] _bs0;
        private final byte[] _bs1;

        ByteSeq(Chunk chk0, Chunk chk1) {
            this._bs0 = chk0.getBytes();
            this._bs1 = chk1 == null ? null : chk1.getBytes();
        }

        @Override
        public char charAt(int idx) {
            return (char)(idx < this._bs0.length ? this._bs0[idx] : this._bs1[idx - this._bs0.length]);
        }

        @Override
        public int length() {
            return this._bs0.length + (this._bs1 == null ? 0 : this._bs1.length);
        }

        @Override
        public ByteSeq subSequence(int start, int end) {
            throw H2O.unimpl();
        }

        @Override
        public String toString() {
            throw H2O.unimpl();
        }

        String str(int s, int e) {
            return new String(this._bs0, s, e - s);
        }
    }

    private class GrepDriver
    extends ModelBuilder.Driver {
        private GrepDriver() {
            super((ModelBuilder)Grep.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void computeImpl() {
            GrepModel model = null;
            try {
                Grep.this.init(true);
                model = new GrepModel(Grep.this.dest(), (GrepModel.GrepParameters)Grep.this._parms, new GrepModel.GrepOutput(Grep.this));
                model.delete_and_lock(Grep.this._job);
                GrepGrep gg = (GrepGrep)new GrepGrep(Grep.this._pattern).doAll(new Vec[]{Grep.this.train().vecs()[0]});
                ((GrepModel.GrepOutput)model._output)._matches = Arrays.copyOf(gg._matches, gg._cnt);
                ((GrepModel.GrepOutput)model._output)._offsets = Arrays.copyOf(gg._offsets, gg._cnt);
                StringBuilder sb = new StringBuilder("Grep: \n");
                sb.append(Arrays.toString(((GrepModel.GrepOutput)model._output)._matches)).append("\n");
                sb.append(Arrays.toString(((GrepModel.GrepOutput)model._output)._offsets)).append("\n");
                Log.info((Object[])new Object[]{sb});
            }
            finally {
                if (model != null) {
                    model.unlock(Grep.this._job);
                }
            }
        }
    }
}

