/*
 * Decompiled with CFR 0.152.
 */
package hex.deepwater;

import hex.DataInfo;
import hex.deepwater.DeepWaterIterator;
import hex.deepwater.DeepWaterModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Future;
import water.DKV;
import water.Freezable;
import water.Futures;
import water.H2O;
import water.Iced;
import water.Key;
import water.Value;
import water.fvec.Chunk;

class DeepWaterDatasetIterator
extends DeepWaterIterator {
    private final ArrayList<Integer> _rows_lst;
    private final ArrayList<Float> _label_lst;
    private final DataInfo _dinfo;

    DeepWaterDatasetIterator(ArrayList<Integer> rows, ArrayList<Float> labels, DataInfo dinfo, int batch_size, boolean cache) throws IOException {
        super(batch_size, dinfo.fullN(), cache);
        this._rows_lst = rows;
        this._label_lst = labels;
        this._dinfo = dinfo;
    }

    @Override
    public boolean Next(Futures fs) throws IOException {
        if (this._start_index < this._rows_lst.size()) {
            if (this._start_index + this._batch_size > this._rows_lst.size()) {
                this._start_index = this._rows_lst.size() - this._batch_size;
            }
            for (int i = 0; i < this._batch_size; ++i) {
                fs.add((Future)H2O.submitTask((H2O.H2OCountedCompleter)new FrameDataConverter(i, this._rows_lst.get(this._start_index + i), this._dinfo, this._label_lst == null ? -1.0f : this._label_lst.get(this._start_index + i).floatValue(), this._data[this.which()], this._label[this.which()], this._cache)));
            }
            fs.blockForPending();
            this.flip();
            this._start_index += this._batch_size;
            return true;
        }
        return false;
    }

    static class FrameDataConverter
    extends H2O.H2OCountedCompleter<FrameDataConverter> {
        int _index;
        int _globalIndex;
        DataInfo _dinfo;
        float _label;
        float[] _destData;
        float[] _destLabel;
        boolean _cache;

        FrameDataConverter(int index, int globalIndex, DataInfo dinfo, float label, float[] destData, float[] destLabel, boolean cache) {
            this._index = index;
            this._globalIndex = globalIndex;
            this._dinfo = dinfo;
            this._label = label;
            this._destData = destData;
            this._destLabel = destLabel;
            this._cache = cache;
        }

        public void compute2() {
            IcedRow icedRow;
            this._destLabel[this._index] = this._label;
            int start = this._index * this._dinfo.fullN();
            Key rowKey = Key.make((String)(this._dinfo._adaptedFrame._key + "_" + this._dinfo.fullN() + "_row_" + Integer.toString(this._globalIndex) + "_" + DeepWaterModel.CACHE_MARKER));
            boolean status = false;
            if (this._cache && (icedRow = (IcedRow)DKV.getGet((Key)rowKey)) != null) {
                icedRow.insertValuesIntoArray(this._destData, start);
                status = true;
            }
            if (!status) {
                int i;
                DataInfo.Row row = this._dinfo.newDenseRow();
                Chunk[] chks = new Chunk[this._dinfo._adaptedFrame.numCols()];
                for (i = 0; i < chks.length; ++i) {
                    chks[i] = this._dinfo._adaptedFrame.vec(i).chunkForRow((long)this._globalIndex);
                }
                this._dinfo.extractDenseRow(chks, this._globalIndex - (int)chks[0].start(), row);
                for (i = 0; i < this._dinfo.fullN(); ++i) {
                    this._destData[start + i] = (float)row.get(i);
                }
                if (this._cache) {
                    Value v = new Value(rowKey, (Freezable)new IcedRow(Arrays.copyOfRange(this._destData, start, start + this._dinfo.fullN())));
                    DKV.put((Key)rowKey, (Value)v);
                    v.freeMem();
                }
            }
            this.tryComplete();
        }
    }

    static class IcedRow
    extends Iced<IcedRow> {
        private float[] _data;

        int size() {
            return this._data.length;
        }

        float getVal(int i) {
            return this._data[i];
        }

        void insertValuesIntoArray(float[] vals, int offset) {
            for (int i = 0; i < this._data.length; ++i) {
                vals[offset + i] = this._data[i];
            }
        }

        public IcedRow() {
        }

        IcedRow(float[] fs) {
            this._data = fs;
        }
    }
}

