/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.ModelCategory;
import hex.genmodel.algos.tree.SharedTreeNode;
import hex.genmodel.algos.tree.SharedTreeSubgraph;
import hex.schemas.TreeV3;
import hex.tree.SharedTreeModel;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import water.MemoryManager;
import water.api.Handler;

public class TreeHandler
extends Handler {
    private static final int NO_CHILD = -1;

    public TreeV3 getTree(int version, TreeV3 args) {
        SharedTreeModel model = (SharedTreeModel)args.model.key().get();
        if (model == null) {
            throw new IllegalArgumentException("Given model does not exist: " + args.model.key().toString());
        }
        SharedTreeModel.SharedTreeOutput sharedTreeOutput = (SharedTreeModel.SharedTreeOutput)model._output;
        int treeClass = TreeHandler.getResponseLevelIndex(args.tree_class, sharedTreeOutput);
        TreeHandler.validateArgs(args, sharedTreeOutput, treeClass);
        SharedTreeSubgraph sharedTreeSubgraph = model.getSharedTreeSubgraph(args.tree_number, treeClass);
        TreeProperties treeProperties = TreeHandler.convertSharedTreeSubgraph(sharedTreeSubgraph);
        args.left_children = treeProperties._leftChildren;
        args.right_children = treeProperties._rightChildren;
        args.descriptions = treeProperties._descriptions;
        args.root_node_id = sharedTreeSubgraph.rootNode.getNodeNumber();
        args.thresholds = treeProperties._thresholds;
        args.features = treeProperties._features;
        args.nas = treeProperties._nas;
        args.levels = treeProperties.levels;
        args.tree_class = ModelCategory.Regression.equals((Object)sharedTreeOutput.getModelCategory()) ? null : sharedTreeOutput._domains[sharedTreeOutput.responseIdx()][treeClass];
        return args;
    }

    private static int getResponseLevelIndex(String categorical, SharedTreeModel.SharedTreeOutput sharedTreeOutput) {
        String[] responseColumnDomain = sharedTreeOutput._domains[sharedTreeOutput.responseIdx()];
        String trimmedCategorical = categorical.trim();
        switch (sharedTreeOutput.getModelCategory()) {
            case Binomial: {
                if (!trimmedCategorical.isEmpty() && !trimmedCategorical.equals(responseColumnDomain[0])) {
                    throw new IllegalArgumentException("For binomial, only one tree class has been built per each iteration: " + responseColumnDomain[0]);
                }
                return 0;
            }
            case Regression: {
                if (!trimmedCategorical.isEmpty()) {
                    throw new IllegalArgumentException("There are no tree classes for regression.");
                }
                return 0;
            }
        }
        for (int i = 0; i < responseColumnDomain.length; ++i) {
            if (!trimmedCategorical.equals(responseColumnDomain[i])) continue;
            return i;
        }
        return -1;
    }

    private static void validateArgs(TreeV3 args, SharedTreeModel.SharedTreeOutput output, int responseLevelIndex) {
        if (args.tree_number < 0) {
            throw new IllegalArgumentException("Tree number must be greater than 0.");
        }
        if (args.tree_number > output._treeKeys.length - 1) {
            throw new IllegalArgumentException("There is no such tree.");
        }
        if (responseLevelIndex < 0) {
            throw new IllegalArgumentException("There is no such tree class. Given categorical level does not exist in response column: " + args.tree_class.trim());
        }
    }

    static TreeProperties convertSharedTreeSubgraph(SharedTreeSubgraph sharedTreeSubgraph) {
        Objects.requireNonNull(sharedTreeSubgraph);
        TreeProperties treeprops = new TreeProperties();
        treeprops._leftChildren = MemoryManager.malloc4((int)sharedTreeSubgraph.nodesArray.size());
        treeprops._rightChildren = MemoryManager.malloc4((int)sharedTreeSubgraph.nodesArray.size());
        treeprops._descriptions = new String[sharedTreeSubgraph.nodesArray.size()];
        treeprops._thresholds = MemoryManager.malloc4f((int)sharedTreeSubgraph.nodesArray.size());
        treeprops._features = new String[sharedTreeSubgraph.nodesArray.size()];
        treeprops._nas = new String[sharedTreeSubgraph.nodesArray.size()];
        treeprops._rightChildren[0] = sharedTreeSubgraph.rootNode.getRightChild() != null ? sharedTreeSubgraph.rootNode.getRightChild().getNodeNumber() : -1;
        treeprops._leftChildren[0] = sharedTreeSubgraph.rootNode.getLeftChild() != null ? sharedTreeSubgraph.rootNode.getLeftChild().getNodeNumber() : -1;
        treeprops._thresholds[0] = sharedTreeSubgraph.rootNode.getSplitValue();
        treeprops._features[0] = sharedTreeSubgraph.rootNode.getColName();
        treeprops._nas[0] = TreeHandler.getNaDirection(sharedTreeSubgraph.rootNode);
        treeprops.levels = new int[sharedTreeSubgraph.nodesArray.size()][];
        ArrayList<SharedTreeNode> nodesToTraverse = new ArrayList<SharedTreeNode>();
        nodesToTraverse.add(sharedTreeSubgraph.rootNode);
        TreeHandler.append(treeprops._rightChildren, treeprops._leftChildren, treeprops._descriptions, treeprops._thresholds, treeprops._features, treeprops._nas, treeprops.levels, nodesToTraverse, -1, false);
        return treeprops;
    }

    private static void append(int[] rightChildren, int[] leftChildren, String[] nodesDescriptions, float[] thresholds, String[] splitColumns, String[] naHandlings, int[][] levels, List<SharedTreeNode> nodesToTraverse, int pointer, boolean visitedRoot) {
        if (nodesToTraverse.isEmpty()) {
            return;
        }
        ArrayList<SharedTreeNode> discoveredNodes = new ArrayList<SharedTreeNode>();
        for (SharedTreeNode node : nodesToTraverse) {
            ++pointer;
            SharedTreeNode leftChild = node.getLeftChild();
            SharedTreeNode rightChild = node.getRightChild();
            if (visitedRoot) {
                TreeHandler.fillnodeDescriptions(node, nodesDescriptions, thresholds, splitColumns, levels, naHandlings, pointer);
            } else {
                StringBuilder rootDescriptionBuilder = new StringBuilder();
                rootDescriptionBuilder.append("Root node has id ");
                rootDescriptionBuilder.append(node.getNodeNumber());
                rootDescriptionBuilder.append(". ");
                TreeHandler.fillNodeSplitTowardsChildren(rootDescriptionBuilder, node);
                nodesDescriptions[pointer] = rootDescriptionBuilder.toString();
                visitedRoot = true;
            }
            if (leftChild != null) {
                discoveredNodes.add(leftChild);
                leftChildren[pointer] = leftChild.getNodeNumber();
            } else {
                leftChildren[pointer] = -1;
            }
            if (rightChild != null) {
                discoveredNodes.add(rightChild);
                rightChildren[pointer] = rightChild.getNodeNumber();
                continue;
            }
            rightChildren[pointer] = -1;
        }
        TreeHandler.append(rightChildren, leftChildren, nodesDescriptions, thresholds, splitColumns, naHandlings, levels, discoveredNodes, pointer, true);
    }

    private static void fillnodeDescriptions(SharedTreeNode node, String[] nodeDescriptions, float[] thresholds, String[] splitColumns, int[][] levels, String[] naHandlings, int pointer) {
        StringBuilder nodeDescriptionBuilder = new StringBuilder();
        int[] nodeLevels = node.getParent().isBitset() ? TreeHandler.extractNodeLevels(node) : null;
        nodeDescriptionBuilder.append("Node has id ");
        nodeDescriptionBuilder.append(node.getNodeNumber());
        if (node.getColName() != null) {
            nodeDescriptionBuilder.append(" and splits on column [");
            nodeDescriptionBuilder.append(node.getColName());
            nodeDescriptionBuilder.append("]. ");
        } else {
            nodeDescriptionBuilder.append(" and is a terminal node. ");
        }
        TreeHandler.fillNodeSplitTowardsChildren(nodeDescriptionBuilder, node);
        if (!Float.isNaN(node.getParent().getSplitValue())) {
            nodeDescriptionBuilder.append(" Parent node split threshold is ");
            nodeDescriptionBuilder.append(node.getParent().getSplitValue());
            nodeDescriptionBuilder.append(".");
        } else if (node.getParent().isBitset()) {
            nodeLevels = TreeHandler.extractNodeLevels(node);
            assert (nodeLevels != null);
            nodeDescriptionBuilder.append(" Parent node split on column [");
            nodeDescriptionBuilder.append(node.getParent().getColName());
            nodeDescriptionBuilder.append("]. Inherited categorical levels from parent split: ");
            for (int nodeLevelsindex = 0; nodeLevelsindex < nodeLevels.length; ++nodeLevelsindex) {
                nodeDescriptionBuilder.append(node.getParent().getDomainValues()[nodeLevels[nodeLevelsindex]]);
                if (nodeLevelsindex == nodeLevels.length - 1) continue;
                nodeDescriptionBuilder.append(",");
            }
        } else {
            nodeDescriptionBuilder.append("NA only");
        }
        nodeDescriptions[pointer] = nodeDescriptionBuilder.toString();
        splitColumns[pointer] = node.getColName();
        naHandlings[pointer] = TreeHandler.getNaDirection(node);
        levels[pointer] = nodeLevels;
        thresholds[pointer] = node.getSplitValue();
    }

    private static void fillNodeSplitTowardsChildren(StringBuilder nodeDescriptionBuilder, SharedTreeNode node) {
        if (!Float.isNaN(node.getSplitValue())) {
            nodeDescriptionBuilder.append("Split threshold is ");
            if (node.getLeftChild() != null) {
                nodeDescriptionBuilder.append(" < ");
                nodeDescriptionBuilder.append(node.getSplitValue());
                nodeDescriptionBuilder.append(" to the left node (");
                nodeDescriptionBuilder.append(node.getLeftChild().getNodeNumber());
                nodeDescriptionBuilder.append(")");
            }
            if (node.getLeftChild() != null) {
                if (node.getLeftChild() != null) {
                    nodeDescriptionBuilder.append(", ");
                }
                nodeDescriptionBuilder.append(" >= ");
                nodeDescriptionBuilder.append(node.getSplitValue());
                nodeDescriptionBuilder.append(" to the right node (");
                nodeDescriptionBuilder.append(node.getRightChild().getNodeNumber());
                nodeDescriptionBuilder.append(")");
            }
            nodeDescriptionBuilder.append(".");
        } else if (node.isBitset()) {
            TreeHandler.fillNodeCategoricalSplitDescription(nodeDescriptionBuilder, node);
        }
    }

    private static int[] extractNodeLevels(SharedTreeNode node) {
        BitSet childInclusiveLevels = node.getInclusiveLevels();
        int cardinality = childInclusiveLevels.cardinality();
        if (cardinality > 0) {
            int[] nodeLevels = MemoryManager.malloc4((int)cardinality);
            int bitsignCounter = 0;
            int i = childInclusiveLevels.nextSetBit(0);
            while (i >= 0) {
                nodeLevels[bitsignCounter] = i;
                ++bitsignCounter;
                i = childInclusiveLevels.nextSetBit(i + 1);
            }
            return nodeLevels;
        }
        return null;
    }

    private static void fillNodeCategoricalSplitDescription(StringBuilder nodeDescriptionBuilder, SharedTreeNode node) {
        int nodeLevelsindex;
        SharedTreeNode leftChild = node.getLeftChild();
        SharedTreeNode rightChild = node.getRightChild();
        int[] leftChildLevels = TreeHandler.extractNodeLevels(leftChild);
        int[] rightChildLevels = TreeHandler.extractNodeLevels(rightChild);
        if (leftChild != null) {
            nodeDescriptionBuilder.append(" Left child node (");
            nodeDescriptionBuilder.append(leftChild.getNodeNumber());
            nodeDescriptionBuilder.append(") inherits categorical levels: ");
            for (nodeLevelsindex = 0; nodeLevelsindex < leftChildLevels.length; ++nodeLevelsindex) {
                nodeDescriptionBuilder.append(node.getDomainValues()[leftChildLevels[nodeLevelsindex]]);
                if (nodeLevelsindex == leftChildLevels.length - 1) continue;
                nodeDescriptionBuilder.append(",");
            }
        }
        if (rightChild != null) {
            nodeDescriptionBuilder.append(". Right child node (");
            nodeDescriptionBuilder.append(rightChild.getNodeNumber());
            nodeDescriptionBuilder.append(") inherits categorical levels: ");
            for (nodeLevelsindex = 0; nodeLevelsindex < rightChildLevels.length; ++nodeLevelsindex) {
                nodeDescriptionBuilder.append(node.getDomainValues()[rightChildLevels[nodeLevelsindex]]);
                if (nodeLevelsindex == rightChildLevels.length - 1) continue;
                nodeDescriptionBuilder.append(",");
            }
        }
        nodeDescriptionBuilder.append(". ");
    }

    private static String getNaDirection(SharedTreeNode node) {
        boolean rightNa;
        boolean leftNa = node.getLeftChild() != null && node.getLeftChild().isInclusiveNa();
        boolean bl = rightNa = node.getRightChild() != null && node.getRightChild().isInclusiveNa();
        assert (rightNa ^ leftNa || !rightNa && !leftNa);
        if (leftNa) {
            return "LEFT";
        }
        if (rightNa) {
            return "RIGHT";
        }
        return null;
    }

    public static class TreeProperties {
        public int[] _leftChildren;
        public int[] _rightChildren;
        public String[] _descriptions;
        public float[] _thresholds;
        public String[] _features;
        public int[][] levels;
        public String[] _nas;
    }
}

