/*
 * Decompiled with CFR 0.152.
 */
package hex.deepwater;

import java.io.IOException;
import water.Futures;

abstract class DeepWaterIterator {
    private int _which;
    int _start_index;
    final int _batch_size;
    final boolean _cache;
    final float[][] _data;
    final float[][] _label;

    DeepWaterIterator(int batch_size, int obsSize, boolean cache) throws IOException {
        this._batch_size = batch_size;
        this._start_index = 0;
        this._cache = cache;
        this._data = new float[2][];
        this._data[0] = new float[this._batch_size * obsSize];
        this._data[1] = new float[this._batch_size * obsSize];
        this._label = new float[2][];
        this._label[0] = new float[this._batch_size];
        this._label[1] = new float[this._batch_size];
    }

    public abstract boolean Next(Futures var1) throws IOException;

    public float[] getData() {
        return this._data[this._which ^ 1];
    }

    public float[] getLabel() {
        return this._label[this._which ^ 1];
    }

    void flip() {
        assert (this._which == 0 || this._which == 1);
        this._which ^= 1;
    }

    int which() {
        return this._which;
    }
}

