/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.tree.CompressedTree;
import hex.tree.DHistogram;
import hex.tree.SharedTreeModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import jsr166y.ForkJoinTask;
import jsr166y.RecursiveAction;
import water.AutoBuffer;
import water.H2O;
import water.Iced;
import water.MemoryManager;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.util.ArrayUtils;
import water.util.IcedBitSet;
import water.util.Log;
import water.util.MathUtils;
import water.util.RandomUtils;

public class DTree
extends Iced {
    final String[] _names;
    final int _ncols;
    final long _seed;
    private Node[] _ns;
    public int _len;
    public int _leaves;
    public int _depth;
    public final int _mtrys;
    public final int _mtrys_per_tree;
    public final transient Random _rand;
    public final transient int[] _cols;
    public transient SharedTreeModel.SharedTreeParameters _parms;
    public static final int NO_PARENT = -1;
    public transient AutoBuffer _abAux;

    public int actual_mtries() {
        return Math.min(Math.max(1, (int)((double)this._mtrys * Math.pow(this._parms._col_sample_rate_change_per_level, this._depth))), this._ncols);
    }

    public DTree(Frame fr, int ncols, int mtrys, int mtrys_per_tree, long seed, SharedTreeModel.SharedTreeParameters parms) {
        this._names = fr.names();
        this._ncols = ncols;
        this._parms = parms;
        this._ns = new Node[1];
        this._mtrys = mtrys;
        this._mtrys_per_tree = mtrys_per_tree;
        this._seed = seed;
        this._rand = RandomUtils.getRNG((long[])new long[]{seed});
        int[] activeCols = new int[this._ncols];
        for (int i = 0; i < activeCols.length; ++i) {
            activeCols[i] = i;
        }
        int len = this._ncols;
        if (mtrys_per_tree < this._ncols) {
            Random colSampleRNG = RandomUtils.getRNG((long[])new long[]{this._seed * 55930L});
            for (int i = 0; i < mtrys_per_tree && len != 0; ++i) {
                int idx2 = colSampleRNG.nextInt(len);
                int col = activeCols[idx2];
                activeCols[idx2] = activeCols[--len];
                activeCols[len] = col;
            }
            activeCols = Arrays.copyOfRange(activeCols, len, activeCols.length);
        }
        this._cols = activeCols;
    }

    public final Node root() {
        return this._ns[0];
    }

    void init_tree() {
        for (int j = 0; j < this._len; ++j) {
            this._ns[j]._tree = this;
        }
    }

    public final Node node(int i) {
        return this._ns[i];
    }

    public final UndecidedNode undecided(int i) {
        return (UndecidedNode)this.node(i);
    }

    public final DecidedNode decided(int i) {
        return (DecidedNode)this.node(i);
    }

    private synchronized int newIdx(Node n) {
        if (this._len == this._ns.length) {
            this._ns = Arrays.copyOf(this._ns, this._len << 1);
        }
        this._ns[this._len] = n;
        return this._len++;
    }

    public final int len() {
        return this._len;
    }

    public static boolean isRootNode(Node n) {
        return n._pid == -1;
    }

    public CompressedTree compress(int tid, int cls, String[][] domains) {
        int sz = this.root().size();
        if (this.root() instanceof LeafNode) {
            sz += 3;
        }
        AutoBuffer ab = new AutoBuffer(sz);
        this._abAux = new AutoBuffer();
        if (this.root() instanceof LeafNode) {
            ab.put1(0).put2('\uffff');
        }
        this.root().compress(ab, this._abAux);
        assert (ab.position() == sz);
        return new CompressedTree(ab.buf(), this._seed, tid, cls);
    }

    static Split findBestSplitPoint(DHistogram hs, int col, double min_rows) {
        if (hs._vals == null) {
            return null;
        }
        int nbins = hs.nbins();
        assert (nbins > 1);
        double[] vals = hs._vals;
        int[] idxs = null;
        if (hs._isInt == 2 && hs._step == 1.0) {
            int i;
            idxs = MemoryManager.malloc4((int)(nbins + 1));
            for (int i2 = 0; i2 < nbins + 1; ++i2) {
                idxs[i2] = i2;
            }
            double[] avgs = MemoryManager.malloc8d((int)(nbins + 1));
            for (i = 0; i < nbins; ++i) {
                avgs[i] = hs.w(i) == 0.0 ? -1.7976931348623157E308 : hs.wY(i) / hs.w(i);
            }
            avgs[nbins] = Double.MAX_VALUE;
            ArrayUtils.sort((int[])idxs, (double[])avgs);
            vals = MemoryManager.malloc8d((int)(3 * nbins));
            for (i = 0; i < nbins; ++i) {
                int id = idxs[i];
                vals[3 * i + 0] = hs._vals[3 * id + 0];
                vals[3 * i + 1] = hs._vals[3 * id + 1];
                vals[3 * i + 2] = hs._vals[3 * id + 2];
            }
        }
        double[] wlo = MemoryManager.malloc8d((int)(nbins + 1));
        double[] wYlo = MemoryManager.malloc8d((int)(nbins + 1));
        double[] wYYlo = MemoryManager.malloc8d((int)(nbins + 1));
        for (int b = 1; b <= nbins; ++b) {
            int id = 3 * (b - 1);
            double n0 = wlo[b - 1];
            double n1 = vals[id + 0];
            if (n0 == 0.0 && n1 == 0.0) continue;
            double m0 = wYlo[b - 1];
            double m1 = vals[id + 1];
            double s0 = wYYlo[b - 1];
            double s1 = vals[id + 2];
            wlo[b] = n0 + n1;
            wYlo[b] = m0 + m1;
            wYYlo[b] = s0 + s1;
        }
        double wNA = hs.wNA();
        double tot = wlo[nbins] + wNA;
        if (tot < 2.0 * min_rows) {
            return null;
        }
        double wYNA = hs.wYNA();
        double wYYNA = hs.wYYNA();
        double var = (wYYlo[nbins] + wYYNA) * tot - (wYlo[nbins] + wYNA) * (wYlo[nbins] + wYNA);
        if ((float)var == 0.0f) {
            return null;
        }
        double[] whi = MemoryManager.malloc8d((int)(nbins + 1));
        double[] wYhi = MemoryManager.malloc8d((int)(nbins + 1));
        double[] wYYhi = MemoryManager.malloc8d((int)(nbins + 1));
        for (int b = nbins - 1; b >= 0; --b) {
            double n0 = whi[b + 1];
            double n1 = vals[3 * b];
            if (n0 == 0.0 && n1 == 0.0) continue;
            double m0 = wYhi[b + 1];
            double m1 = vals[3 * b + 1];
            double s0 = wYYhi[b + 1];
            double s1 = vals[3 * b + 2];
            whi[b] = n0 + n1;
            wYhi[b] = m0 + m1;
            wYYhi[b] = s0 + s1;
            assert (MathUtils.compare((double)(wlo[b] + whi[b] + wNA), (double)tot, (double)1.0E-5, (double)1.0E-5));
        }
        double best_seL = Double.MAX_VALUE;
        double best_seR = Double.MAX_VALUE;
        DHistogram.NASplitDir nasplit = DHistogram.NASplitDir.None;
        double seNonNA = wYYhi[0] - wYhi[0] * wYhi[0] / whi[0];
        if (seNonNA < 0.0) {
            seNonNA = 0.0;
        }
        double seBefore = seNonNA;
        if (wNA >= min_rows) {
            double seAll = wYYhi[0] + wYYNA - (wYhi[0] + wYNA) * (wYhi[0] + wYNA) / (whi[0] + wNA);
            double seNA = wYYNA - wYNA * wYNA / wNA;
            if (seNA < 0.0) {
                seNA = 0.0;
            }
            best_seL = seNonNA;
            best_seR = seNA;
            nasplit = DHistogram.NASplitDir.NAvsREST;
            seBefore = seAll;
        }
        int best = 0;
        byte equal = 0;
        for (int b = 1; b <= nbins - 1; ++b) {
            double sehi;
            double selo;
            if (vals[3 * b] == 0.0 || wlo[b] + wNA < min_rows) continue;
            if (whi[b] + wNA < min_rows) break;
            if (wNA == 0.0) {
                selo = wYYlo[b] - wYlo[b] * wYlo[b] / wlo[b];
                sehi = wYYhi[b] - wYhi[b] * wYhi[b] / whi[b];
                if (selo < 0.0) {
                    selo = 0.0;
                }
                if (sehi < 0.0) {
                    sehi = 0.0;
                }
                if (!(selo + sehi < best_seL + best_seR) && (selo + sehi != best_seL + best_seR || Math.abs(b - (nbins >> 1)) >= Math.abs(best - (nbins >> 1)))) continue;
                best_seL = selo;
                best_seR = sehi;
                best = b;
                continue;
            }
            selo = wYYlo[b] + wYYNA - (wYlo[b] + wYNA) * (wYlo[b] + wYNA) / (wlo[b] + wNA);
            sehi = wYYhi[b] - wYhi[b] * wYhi[b] / whi[b];
            if (selo < 0.0) {
                selo = 0.0;
            }
            if (sehi < 0.0) {
                sehi = 0.0;
            }
            if ((selo + sehi < best_seL + best_seR || selo + sehi == best_seL + best_seR && Math.abs(b - (nbins >> 1)) < Math.abs(best - (nbins >> 1))) && wlo[b] + wNA >= min_rows && whi[b] >= min_rows) {
                best_seL = selo;
                best_seR = sehi;
                best = b;
                nasplit = DHistogram.NASplitDir.NALeft;
            }
            selo = wYYlo[b] - wYlo[b] * wYlo[b] / wlo[b];
            sehi = wYYhi[b] + wYYNA - (wYhi[b] + wYNA) * (wYhi[b] + wYNA) / (whi[b] + wNA);
            if (selo < 0.0) {
                selo = 0.0;
            }
            if (sehi < 0.0) {
                sehi = 0.0;
            }
            if (!(selo + sehi < best_seL + best_seR) && (selo + sehi != best_seL + best_seR || Math.abs(b - (nbins >> 1)) >= Math.abs(best - (nbins >> 1))) || !(wlo[b] >= min_rows) || !(whi[b] + wNA >= min_rows)) continue;
            best_seL = selo;
            best_seR = sehi;
            best = b;
            nasplit = DHistogram.NASplitDir.NARight;
        }
        double nLeft = wlo[best];
        double nRight = whi[best];
        IcedBitSet bs = null;
        if (idxs != null) {
            int off = (int)hs._min;
            bs = new IcedBitSet(nbins, off);
            for (int i = best; i < nbins; ++i) {
                bs.set(idxs[i] + off);
            }
            int nonEmptyThatWentRight = 0;
            int nonEmptyThatWentLeft = 0;
            for (int i = 0; i < nbins; ++i) {
                if (!(hs.w(i) > 0.0)) continue;
                if (bs.contains(i + off)) {
                    ++nonEmptyThatWentRight;
                    continue;
                }
                ++nonEmptyThatWentLeft;
            }
            boolean shouldGoLeft = nonEmptyThatWentLeft >= nonEmptyThatWentRight;
            for (int i = 0; i < nbins; ++i) {
                assert (bs.isInRange(i + off));
                if (hs.w(i) != 0.0) continue;
                if (bs.contains(i + off) && shouldGoLeft) {
                    bs.clear(i + off);
                }
                if (bs.contains(i + off) || shouldGoLeft) continue;
                bs.set(i + off);
            }
            if (bs.cardinality() == 0 || bs.cardinality() == bs.size()) {
                return null;
            }
            equal = (byte)(bs.max() <= 32 ? 2 : 3);
        }
        if (best == 0 && nasplit == DHistogram.NASplitDir.None) {
            return null;
        }
        if (!(best_seL + best_seR < seBefore * (1.0 - hs._minSplitImprovement))) {
            return null;
        }
        double predLeft = wYlo[best];
        double predRight = wYhi[best];
        if (nasplit == DHistogram.NASplitDir.NAvsREST) {
            assert (best == 0);
            nLeft = whi[0];
            predLeft = wYhi[0];
            nRight = wNA;
            predRight = wYNA;
        } else if (nasplit == DHistogram.NASplitDir.NALeft) {
            nLeft += wNA;
            predLeft += wYNA;
        } else if (nasplit == DHistogram.NASplitDir.NARight) {
            nRight += wNA;
            predRight += wYNA;
        }
        assert (Math.abs(tot - (nRight + nLeft)) < 1.0E-5 * tot);
        if (MathUtils.equalsWithinOneSmallUlp((float)((float)(predLeft / nLeft)), (float)((float)(predRight / nRight)))) {
            return null;
        }
        if (nLeft < min_rows || nRight < min_rows) {
            return null;
        }
        if (nasplit == DHistogram.NASplitDir.None) {
            nasplit = nLeft > nRight ? DHistogram.NASplitDir.Left : DHistogram.NASplitDir.Right;
        }
        Split split = new Split(col, best, nasplit, bs, equal, seBefore, best_seL, best_seR, nLeft, nRight, predLeft / nLeft, predRight / nRight);
        return split;
    }

    public static final class LeafNode
    extends Node {
        public float _pred;

        public LeafNode(DTree tree, int pid) {
            super(tree, pid);
            ++tree._leaves;
        }

        public LeafNode(DTree tree, int pid, int nid) {
            super(tree, pid, nid);
            ++tree._leaves;
        }

        public String toString() {
            return "Leaf#" + this._nid + " = " + this._pred;
        }

        @Override
        public final StringBuilder toString2(StringBuilder sb, int depth) {
            for (int d = 0; d < depth; ++d) {
                sb.append("  ");
            }
            sb.append(this._nid).append(" ");
            return sb.append("pred=").append(this._pred).append("\n");
        }

        @Override
        protected AutoBuffer compress(AutoBuffer ab, AutoBuffer abAux) {
            assert (!Double.isNaN(this._pred));
            return ab.put4f(this._pred);
        }

        @Override
        protected int size() {
            return 4;
        }

        @Override
        protected int numNodes() {
            return 0;
        }

        public final double pred() {
            return this._pred;
        }
    }

    public static class DecidedNode
    extends Node {
        public final Split _split;
        public final float _splat;
        public final int[] _nids = new int[2];
        transient byte _nodeType;
        transient int _size = 0;
        transient int _nnodes = 0;

        public UndecidedNode makeUndecidedNode(DHistogram[] hs) {
            return new UndecidedNode(this._tree, this._nid, hs);
        }

        public Split bestCol(UndecidedNode u, DHistogram[] hs) {
            Split best = null;
            if (hs == null) {
                return null;
            }
            int maxCols = u._scoreCols == null ? hs.length : u._scoreCols.length;
            ArrayList<FindSplits> findSplits = new ArrayList<FindSplits>();
            long nbinsSum = 0L;
            for (int i = 0; i < maxCols; ++i) {
                int col;
                int n = col = u._scoreCols == null ? i : u._scoreCols[i];
                if (hs[col] == null || hs[col].nbins() <= 1) continue;
                nbinsSum += (long)hs[col].nbins();
            }
            boolean isSmall = nbinsSum <= 1024L;
            for (int i = 0; i < maxCols; ++i) {
                int col;
                int n = col = u._scoreCols == null ? i : u._scoreCols[i];
                if (hs[col] == null || hs[col].nbins() <= 1) continue;
                FindSplits fs = new FindSplits(hs, col, u._nid);
                findSplits.add(fs);
                if (!isSmall) continue;
                fs.compute();
            }
            if (!isSmall) {
                ForkJoinTask.invokeAll(findSplits);
            }
            for (FindSplits fs : findSplits) {
                Split s = fs._s;
                if (s == null || best != null && !(s.se() < best.se())) continue;
                best = s;
            }
            return best;
        }

        public DecidedNode(UndecidedNode n, DHistogram[] hs) {
            super(n._tree, n._pid, n._nid);
            this._split = this.bestCol(n, hs);
            if (this._split == null) {
                this._splat = Float.NaN;
                Arrays.fill(this._nids, -1);
                return;
            }
            this._splat = this._split._nasplit != DHistogram.NASplitDir.NAvsREST && (this._split._equal == 0 || this._split._equal == 1) ? this._split.splat(hs) : -1.0f;
            for (int way = 0; way < 2; ++way) {
                DHistogram[] nhists = this._split.nextLevelHistos(hs, way, this._splat, this._tree._parms);
                assert (nhists == null || nhists.length == this._tree._ncols);
                this._nids[way] = nhists == null ? -1 : this.makeUndecidedNode((DHistogram[])nhists)._nid;
            }
        }

        public int getChildNodeID(Chunk[] chks, int row) {
            double d = chks[this._split._col].atd(row);
            int bin = -1;
            boolean isNA = Double.isNaN(d);
            if (!isNA) {
                if (this._split._nasplit == DHistogram.NASplitDir.NAvsREST) {
                    bin = 0;
                } else if (this._split._equal == 0) {
                    assert (!Float.isNaN(this._splat));
                    bin = d >= (double)this._splat ? 1 : 0;
                } else if (this._split._equal >= 2) {
                    int b = (int)d;
                    if (this._split._bs.isInRange(b)) {
                        bin = this._split._bs.contains(b) ? 1 : 0;
                    } else {
                        isNA = true;
                    }
                }
            }
            if (isNA) {
                if (this._split._nasplit == DHistogram.NASplitDir.NALeft || this._split._nasplit == DHistogram.NASplitDir.Left) {
                    bin = 0;
                } else if (this._split._nasplit == DHistogram.NASplitDir.NARight || this._split._nasplit == DHistogram.NASplitDir.Right || this._split._nasplit == DHistogram.NASplitDir.NAvsREST) {
                    bin = 1;
                } else if (this._split._nasplit == DHistogram.NASplitDir.None) {
                    bin = 1;
                } else {
                    throw H2O.unimpl();
                }
            }
            return this._nids[bin];
        }

        public double pred(int nid) {
            return nid == 0 ? this._split._p0 : this._split._p1;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("DecidedNode:\n");
            sb.append("_nid: " + this._nid + "\n");
            sb.append("_nids (children): " + Arrays.toString(this._nids) + "\n");
            if (this._split != null) {
                sb.append("_split:" + this._split.toString() + "\n");
            }
            sb.append("_splat:" + this._splat + "\n");
            if (this._split == null) {
                sb.append(" col = -1\n");
            } else {
                int col = this._split._col;
                if (this._split._equal == 1) {
                    sb.append(this._tree._names[col] + " != " + this._splat + "\n" + this._tree._names[col] + " == " + this._splat + "\n");
                } else if (this._split._equal == 2 || this._split._equal == 3) {
                    sb.append(this._tree._names[col] + " not in " + this._split._bs.toString() + "\n" + this._tree._names[col] + "  is in " + this._split._bs.toString() + "\n");
                } else {
                    sb.append(this._tree._names[col] + " < " + this._splat + "\n" + this._splat + " >=" + this._tree._names[col] + "\n");
                }
            }
            return sb.toString();
        }

        StringBuilder printChild(StringBuilder sb, int nid) {
            int i;
            int n = i = this._nids[0] == nid ? 0 : 1;
            assert (this._nids[i] == nid) : "No child nid " + nid + "? " + Arrays.toString(this._nids);
            sb.append("[").append(this._tree._names[this._split._col]);
            sb.append(this._split._equal != 0 ? (i == 0 ? " != " : " == ") : (i == 0 ? " <  " : " >= "));
            sb.append(this._split._equal == 2 || this._split._equal == 3 ? this._split._bs.toString() : Float.valueOf(this._splat)).append("]");
            return sb;
        }

        @Override
        public StringBuilder toString2(StringBuilder sb, int depth) {
            assert (this._nids.length == 2);
            for (int i = 0; i < this._nids.length; ++i) {
                for (int d = 0; d < depth; ++d) {
                    sb.append("  ");
                }
                sb.append(this._nid).append(" ");
                if (this._split._col < 0) {
                    sb.append("init");
                } else {
                    sb.append(this._tree._names[this._split._col]);
                    if (this._split._nasplit == DHistogram.NASplitDir.NAvsREST) {
                        if (i == 0) {
                            sb.append(" not NA");
                        }
                        if (i == 1) {
                            sb.append(" is NA");
                        }
                    } else {
                        if (this._split._equal < 2) {
                            if (this._split._nasplit == DHistogram.NASplitDir.NARight || this._split._nasplit == DHistogram.NASplitDir.Right || this._split._nasplit == DHistogram.NASplitDir.None) {
                                sb.append(this._split._equal != 0 ? (i == 0 ? " != " : " == ") : (i == 0 ? " <  " : " is NA or >= "));
                            }
                            if (this._split._nasplit == DHistogram.NASplitDir.NALeft || this._split._nasplit == DHistogram.NASplitDir.Left) {
                                sb.append(this._split._equal != 0 ? (i == 0 ? " is NA or != " : " == ") : (i == 0 ? " is NA or <  " : " >= "));
                            }
                        } else {
                            sb.append(i == 0 ? " not in " : "  is in ");
                        }
                        sb.append(this._split._equal == 2 || this._split._equal == 3 ? this._split._bs.toString() : Float.valueOf(this._splat)).append("\n");
                    }
                }
                if (this._nids[i] < 0 || this._nids[i] >= this._tree._len) continue;
                this._tree.node(this._nids[i]).toString2(sb, depth + 1);
            }
            return sb;
        }

        @Override
        public final int size() {
            if (this._size != 0) {
                return this._size;
            }
            assert (this._nodeType == 0) : "unexpected node type: " + this._nodeType;
            if (this._split._equal != 0) {
                this._nodeType = (byte)(this._nodeType | (this._split._equal == 1 ? 4 : (this._split._equal == 2 ? 8 : 12)));
            }
            int res = this._split._equal == 3 ? 9 + this._split._bs.numBytes() : 7;
            ++res;
            if (this._split._nasplit == DHistogram.NASplitDir.NAvsREST) {
                res -= this._split._equal == 3 ? 6 + this._split._bs.numBytes() : 4;
            }
            Node left = this._tree.node(this._nids[0]);
            int lsz = left.size();
            res += lsz;
            if (left instanceof LeafNode) {
                this._nodeType = (byte)(this._nodeType | 0x30);
            } else {
                int slen = lsz < 256 ? 0 : (lsz < 65535 ? 1 : (lsz < 0x1000000 ? 2 : 3));
                this._nodeType = (byte)(this._nodeType | slen);
                res += slen + 1;
            }
            Node right = this._tree.node(this._nids[1]);
            if (right instanceof LeafNode) {
                this._nodeType = (byte)(this._nodeType | 0xFFFFFFC0);
            }
            res += right.size();
            assert ((this._nodeType & 0x33) != 51);
            assert (res != 0);
            this._size = res;
            return this._size;
        }

        @Override
        protected int numNodes() {
            if (this._nnodes > 0) {
                return this._nnodes;
            }
            this._nnodes = 1 + this._tree.node(this._nids[0]).numNodes() + this._tree.node(this._nids[1]).numNodes();
            return this._nnodes;
        }

        @Override
        public AutoBuffer compress(AutoBuffer ab, AutoBuffer abAux) {
            int pos = ab.position();
            if (this._nodeType == 0) {
                this.size();
            }
            ab.put1((int)this._nodeType);
            assert (this._split != null);
            assert (this._split._col >= 0);
            ab.put2((short)this._split._col);
            ab.put1((int)((byte)this._split._nasplit.value()));
            if (this._split._nasplit != DHistogram.NASplitDir.NAvsREST) {
                if (this._split._equal == 0 || this._split._equal == 1) {
                    ab.put4f(this._splat);
                } else if (this._split._equal == 2) {
                    this._split._bs.compress2(ab);
                } else {
                    this._split._bs.compress3(ab);
                }
            }
            if (abAux != null) {
                abAux.put4(this._nid);
                abAux.put4(this._tree.node(this._nids[0]).numNodes());
                abAux.put4f((float)this._split._n0);
                abAux.put4f((float)this._split._n1);
                abAux.put4f((float)this._split._p0);
                abAux.put4f((float)this._split._p1);
                abAux.put4f((float)this._split._se0);
                abAux.put4f((float)this._split._se1);
                abAux.put4(this._nids[0]);
                abAux.put4(this._nids[1]);
            }
            Node left = this._tree.node(this._nids[0]);
            if ((this._nodeType & 0x30) == 0) {
                int sz = left.size();
                if (sz < 256) {
                    ab.put1(sz);
                } else if (sz < 65535) {
                    ab.put2((short)sz);
                } else if (sz < 0x1000000) {
                    ab.put3(sz);
                } else {
                    ab.put4(sz);
                }
            }
            left.compress(ab, abAux);
            Node rite = this._tree.node(this._nids[1]);
            rite.compress(ab, abAux);
            assert (this._size == ab.position() - pos) : "reported size = " + this._size + " , real size = " + (ab.position() - pos);
            return ab;
        }

        public final class FindSplits
        extends RecursiveAction {
            final DHistogram[] _hs;
            final int _col;
            final int _nid;
            Split _s;

            public FindSplits(DHistogram[] hs, int col, UndecidedNode node) {
                this(hs, col, node._nid);
            }

            private FindSplits(DHistogram[] hs, int col, int nid) {
                this._hs = hs;
                this._col = col;
                this._nid = nid;
            }

            public void compute() {
                this.computeSplit();
            }

            public final Split computeSplit() {
                this._s = DTree.findBestSplitPoint(this._hs[this._col], this._col, DecidedNode.this._tree._parms._min_rows);
                return this._s;
            }
        }
    }

    public static class UndecidedNode
    extends Node {
        public transient DHistogram[] _hs;
        public final int[] _scoreCols;

        public UndecidedNode(DTree tree, int pid, DHistogram[] hs) {
            super(tree, pid);
            assert (hs.length == tree._ncols);
            this._hs = hs;
            this._scoreCols = this.scoreCols();
        }

        public int[] scoreCols() {
            DTree tree = this._tree;
            if (tree.actual_mtries() == this._hs.length && tree._mtrys_per_tree == this._hs.length) {
                return null;
            }
            int[] activeCols = tree._cols;
            int[] cols = new int[activeCols.length];
            int len = 0;
            for (int i = 0; i < activeCols.length; ++i) {
                int idx = activeCols[i];
                assert (idx == i || tree._mtrys_per_tree < this._hs.length);
                if (this._hs[idx] == null) continue;
                assert (this._hs[idx]._min < this._hs[idx]._maxEx && this._hs[idx].nbins() > 1) : "broken histo range " + (Object)((Object)this._hs[idx]);
                cols[len++] = idx;
            }
            int choices = len;
            int mtries = tree.actual_mtries();
            if (choices > 0) {
                for (int i = 0; i < mtries && len != 0; ++i) {
                    int idx2 = tree._rand.nextInt(len);
                    int col = cols[idx2];
                    cols[idx2] = cols[--len];
                    cols[len] = col;
                }
                assert (len < choices);
            }
            return Arrays.copyOfRange(cols, len, choices);
        }

        public void do_not_split() {
            if (this._pid == -1) {
                return;
            }
            DecidedNode dn = this._tree.decided(this._pid);
            for (int i = 0; i < dn._nids.length; ++i) {
                if (dn._nids[i] != this._nid) continue;
                dn._nids[i] = -1;
                return;
            }
            throw H2O.fail();
        }

        public String toString() {
            String colPad = "  ";
            int cntW = 4;
            int mmmW = 4;
            int menW = 5;
            int varW = 5;
            int colW = 26;
            StringBuilder sb = new StringBuilder();
            sb.append("Nid# ").append(this._nid).append(", ");
            this.printLine(sb).append("\n");
            if (this._hs == null) {
                return sb.append("_hs==null").toString();
            }
            for (DHistogram hs : this._hs) {
                if (hs == null) continue;
                UndecidedNode.p(sb, hs._name + String.format(", %4.1f-%4.1f", hs._min, hs._maxEx), 26).append("  ");
            }
            sb.append('\n');
            for (DHistogram hs : this._hs) {
                if (hs == null) continue;
                UndecidedNode.p(sb, "cnt", 4).append('/');
                UndecidedNode.p(sb, "min", 4).append('/');
                UndecidedNode.p(sb, "max", 4).append('/');
                UndecidedNode.p(sb, "mean", 5).append('/');
                UndecidedNode.p(sb, "var", 5).append("  ");
            }
            sb.append('\n');
            int nbins = 0;
            for (DHistogram hs : this._hs) {
                if (hs == null || hs.nbins() <= nbins) continue;
                nbins = hs.nbins();
            }
            for (int i = 0; i < nbins; ++i) {
                for (DHistogram h : this._hs) {
                    if (h == null) continue;
                    if (i < h.nbins() && h._vals != null) {
                        UndecidedNode.p(sb, h.bins(i), 4).append('/');
                        UndecidedNode.p(sb, h.binAt(i), 4).append('/');
                        UndecidedNode.p(sb, h.binAt(i + 1), 4).append('/');
                        UndecidedNode.p(sb, h.mean(i), 5).append('/');
                        UndecidedNode.p(sb, h.var(i), 5).append("  ");
                        continue;
                    }
                    UndecidedNode.p(sb, "", 26).append("  ");
                }
                sb.append('\n');
            }
            sb.append("Nid# ").append(this._nid);
            return sb.toString();
        }

        private static StringBuilder p(StringBuilder sb, String s, int w) {
            return sb.append(Log.fixedLength((String)s, (int)w));
        }

        private static StringBuilder p(StringBuilder sb, double d, int w) {
            String s;
            String string = Double.isNaN(d) ? "NaN" : (d == 3.4028234663852886E38 || d == -3.4028234663852886E38 || d == Double.MAX_VALUE || d == -1.7976931348623157E308 ? " -" : (s = d == 0.0 ? " 0" : Double.toString(d)));
            if (s.length() <= w) {
                return UndecidedNode.p(sb, s, w);
            }
            s = String.format("% 4.2f", d);
            if (s.length() > w) {
                s = String.format("%4.1f", d);
            }
            if (s.length() > w) {
                s = String.format("%4.0f", d);
            }
            return UndecidedNode.p(sb, s, w);
        }

        @Override
        public StringBuilder toString2(StringBuilder sb, int depth) {
            for (int d = 0; d < depth; ++d) {
                sb.append("  ");
            }
            return sb.append("Undecided\n");
        }

        @Override
        protected AutoBuffer compress(AutoBuffer ab, AutoBuffer abAux) {
            throw H2O.fail();
        }

        @Override
        protected int size() {
            throw H2O.fail();
        }

        @Override
        protected int numNodes() {
            throw H2O.fail();
        }
    }

    public static class Split
    extends Iced {
        public final int _col;
        public final int _bin;
        final DHistogram.NASplitDir _nasplit;
        final IcedBitSet _bs;
        final byte _equal;
        final double _se;
        final double _se0;
        final double _se1;
        final double _n0;
        final double _n1;
        final double _p0;
        final double _p1;

        public Split(int col, int bin, DHistogram.NASplitDir nasplit, IcedBitSet bs, byte equal, double se, double se0, double se1, double n0, double n1, double p0, double p1) {
            assert (nasplit != DHistogram.NASplitDir.None);
            assert (equal != 1);
            assert (se > se0 + se1 || se == Double.MAX_VALUE);
            assert (col >= 0);
            assert (bin >= 0);
            this._col = col;
            this._bin = bin;
            this._nasplit = nasplit;
            this._bs = bs;
            this._equal = equal;
            this._se = se;
            this._n0 = n0;
            this._n1 = n1;
            this._se0 = se0;
            this._se1 = se1;
            this._p0 = p0;
            this._p1 = p1;
        }

        public final double pre_split_se() {
            return this._se;
        }

        public final double se() {
            return this._se0 + this._se1;
        }

        public final int col() {
            return this._col;
        }

        public final int bin() {
            return this._bin;
        }

        float splat(DHistogram[] hs) {
            int n;
            int x;
            DHistogram h = hs[this._col];
            assert (this._bin > 0 && this._bin < h.nbins());
            assert (this._bs == null) : "Dividing point is a bitset, not a bin#, so dont call splat() as result is meaningless";
            if (this._nasplit == DHistogram.NASplitDir.NAvsREST) {
                return -1.0f;
            }
            assert (this._equal != 1);
            assert (this._equal == 0);
            for (x = this._bin - 1; x >= 0 && h.bins(x) == 0.0; --x) {
            }
            for (n = this._bin; n < h.nbins() && h.bins(n) == 0.0; ++n) {
            }
            double lo = h.binAt(x + 1);
            double hi = h.binAt(n);
            if (h._isInt > 0) {
                double d = lo = h._step == 1.0 ? lo - 1.0 : Math.floor(lo);
            }
            if (h._isInt > 0) {
                hi = h._step == 1.0 ? hi : Math.ceil(hi);
            }
            return (float)((lo + hi) / 2.0);
        }

        public DHistogram[] nextLevelHistos(DHistogram[] currentHistos, int way, double splat, SharedTreeModel.SharedTreeParameters parms) {
            double se;
            double n;
            double d = n = way == 0 ? this._n0 : this._n1;
            if (n < parms._min_rows) {
                return null;
            }
            double d2 = se = way == 0 ? this._se0 : this._se1;
            if (se <= 1.0E-30) {
                return null;
            }
            int cnt = 0;
            DHistogram[] nhists = new DHistogram[currentHistos.length];
            block5: for (int j = 0; j < currentHistos.length; ++j) {
                double maxEx;
                double min;
                DHistogram h = currentHistos[j];
                if (h == null) continue;
                int adj_nbins = Math.max(h.nbins() >> 1, parms._nbins);
                if (h._vals == null || this._equal > 1) {
                    min = h._min;
                    maxEx = h._maxEx;
                } else {
                    min = h.find_min();
                    if (h.find_maxIn() == min) continue;
                    maxEx = h.find_maxEx();
                }
                if (this._nasplit == DHistogram.NASplitDir.NAvsREST && way == 1) continue;
                if (this._col == j) {
                    switch (this._equal) {
                        case 0: {
                            if (this._nasplit != DHistogram.NASplitDir.NAvsREST && h._vals[3 * this._bin] == 0.0) {
                                throw H2O.unimpl();
                            }
                            assert (this._bs == null) : "splat not defined for BitSet splits";
                            double split = splat;
                            if (h._isInt > 0) {
                                split = (float)Math.ceil(split);
                            }
                            if (this._nasplit == DHistogram.NASplitDir.NAvsREST) break;
                            if (way == 0) {
                                maxEx = split;
                                break;
                            }
                            min = split;
                            break;
                        }
                        case 1: {
                            if (way != 1) break;
                            continue block5;
                        }
                        case 2: 
                        case 3: {
                            break;
                        }
                        default: {
                            throw H2O.fail();
                        }
                    }
                }
                if (min > maxEx || MathUtils.equalsWithinOneSmallUlp((double)min, (double)maxEx) || Double.isInfinite((double)adj_nbins / (maxEx - min)) || h._isInt > 0 && !(min + 1.0 < maxEx)) continue;
                assert (min < maxEx && adj_nbins > 1) : "" + min + "<" + maxEx + " nbins=" + adj_nbins;
                nhists[j] = DHistogram.make(h._name, adj_nbins, h._isInt, min, maxEx, h._seed * 912559L + (long)(way + 1), parms, h._globalQuantilesKey);
                ++cnt;
            }
            return cnt == 0 ? null : nhists;
        }

        public String toString() {
            return "Splitting: col=" + this._col + " type=" + (this._equal == 0 ? " < " : "bitset") + ", splitpoint=" + this._bin + ", nadir=" + this._nasplit.toString() + ", se0=" + this._se0 + ", se1=" + this._se1 + ", n0=" + this._n0 + ", n1=" + this._n1;
        }
    }

    public static abstract class Node
    extends Iced {
        protected transient DTree _tree;
        public final int _pid;
        protected final int _nid;

        Node(DTree tree, int pid, int nid) {
            this._tree = tree;
            this._pid = pid;
            this._nid = nid;
            ((DTree)tree)._ns[this._nid] = this;
        }

        Node(DTree tree, int pid) {
            this._tree = tree;
            this._pid = pid;
            this._nid = tree.newIdx(this);
        }

        StringBuilder printLine(StringBuilder sb) {
            if (this._pid == -1) {
                return sb.append("[root]");
            }
            DecidedNode parent = this._tree.decided(this._pid);
            parent.printLine(sb).append(" to ");
            return parent.printChild(sb, this._nid);
        }

        public abstract StringBuilder toString2(StringBuilder var1, int var2);

        protected abstract AutoBuffer compress(AutoBuffer var1, AutoBuffer var2);

        protected abstract int size();

        protected abstract int numNodes();

        public final int nid() {
            return this._nid;
        }

        public final int pid() {
            return this._pid;
        }
    }
}

