/*
 * Decompiled with CFR 0.152.
 */
package hex.glm;

import hex.DataInfo;
import hex.FrameTask2;
import hex.glm.GLM;
import hex.glm.GLMModel;
import hex.gram.Gram;
import java.util.Arrays;
import water.H2O;
import water.Job;
import water.Key;
import water.MRTask;
import water.MemoryManager;
import water.fvec.C0DChunk;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.util.ArrayUtils;
import water.util.FrameUtils;
import water.util.MathUtils;

public abstract class GLMTask {
    static double computeMultinomialEtas(double[] etas, double[] exps) {
        double maxRow = ArrayUtils.maxValue((double[])etas);
        double sumExp = 0.0;
        int K = etas.length;
        for (int c = 0; c < K; ++c) {
            double x = Math.exp(etas[c] - maxRow);
            sumExp += x;
            exps[c + 1] = x;
        }
        double reg = 1.0 / sumExp;
        for (int c = 0; c < etas.length; ++c) {
            int n = c + 1;
            exps[n] = exps[n] * reg;
        }
        exps[0] = 0.0;
        exps[0] = ArrayUtils.maxIndex((double[])exps) - 1;
        return Math.log(sumExp) + maxRow;
    }

    static class GLMIncrementalGramTask
    extends MRTask<GLMIncrementalGramTask> {
        final int[] _newCols;
        final DataInfo _dinfo;
        double[][] _gram;
        double[] _xy;
        final double[] _beta;
        final GLMModel.GLMWeightsFun _glmf;

        public GLMIncrementalGramTask(int[] newCols, DataInfo dinfo, GLMModel.GLMWeightsFun glmf, double[] beta) {
            this._newCols = newCols;
            this._glmf = glmf;
            this._dinfo = dinfo;
            this._beta = beta;
        }

        public void map(Chunk[] chks) {
            GLMModel.GLMWeights glmw = new GLMModel.GLMWeights();
            double[] wsum = new double[this._dinfo.fullN() + 1];
            double ywsum = 0.0;
            DataInfo.Rows rows = this._dinfo.rows(chks);
            double[][] gram = new double[this._newCols.length][this._dinfo.fullN() + 1];
            double[] xy = new double[this._newCols.length];
            int ns = this._dinfo.numStart();
            double sparseOffset = rows._sparse ? GLM.sparseOffset(this._beta, this._dinfo) : 0.0;
            block0: for (int rid = 0; rid < rows._nrows; ++rid) {
                int i;
                int j = 0;
                DataInfo.Row r = rows.row(rid);
                if (r.weight == 0.0) continue;
                if (this._beta != null) {
                    this._glmf.computeWeights(r.response(0), r.innerProduct(this._beta) + sparseOffset, r.offset, r.weight, glmw);
                } else {
                    glmw.w = r.weight;
                    glmw.z = r.response(0);
                }
                r.addToArray(glmw.w, wsum);
                ywsum += glmw.z * glmw.w;
                for (i = 0; i < r.nBins; ++i) {
                    while (j < this._newCols.length && this._newCols[j] < r.binIds[i]) {
                        ++j;
                    }
                    if (j == this._newCols.length || this._newCols[j] >= ns) break;
                    if (r.binIds[i] != this._newCols[j]) continue;
                    r.addToArray(glmw.w, gram[j]);
                    int n = j++;
                    xy[n] = xy[n] + glmw.w * glmw.z;
                }
                while (j < this._newCols.length && this._newCols[j] < ns) {
                    ++j;
                }
                if (r.numIds != null) {
                    for (i = 0; i < r.nNums; ++i) {
                        while (j < this._newCols.length && this._newCols[j] < r.numIds[i]) {
                            ++j;
                        }
                        if (j == this._newCols.length) continue block0;
                        if (r.numIds[i] != this._newCols[j]) continue;
                        double wx = glmw.w * r.numVals[i];
                        r.addToArray(wx, gram[j]);
                        int n = j++;
                        xy[n] = xy[n] + wx * glmw.z;
                    }
                    continue;
                }
                while (j < this._newCols.length) {
                    int id = this._newCols[j];
                    double x = r.numVals[id - this._dinfo.numStart()];
                    if (x != 0.0) {
                        double wx = glmw.w * x;
                        r.addToArray(wx, gram[j]);
                        int n = j;
                        xy[n] = xy[n] + wx * glmw.z;
                    }
                    ++j;
                }
                assert (j == this._newCols.length);
            }
            if (rows._sparse && this._dinfo._normSub != null) {
                int k;
                int numstart = Arrays.binarySearch(this._newCols, ns);
                if (numstart < 0) {
                    numstart = -numstart - 1;
                }
                for (k = 0; k < numstart; ++k) {
                    int i = this._newCols[k];
                    double[] row = gram[k];
                    for (int j = ns; j < row.length - 1; ++j) {
                        double mean_j = this._dinfo.normSub(j - ns);
                        double scale_j = this._dinfo.normMul(j - ns);
                        gram[k][j] = gram[k][j] - mean_j * scale_j * wsum[i];
                    }
                }
                k = numstart;
                while (k < gram.length) {
                    int j;
                    int i = this._newCols[k];
                    double mean_i = this._dinfo.normSub(i - ns);
                    double scale_i = this._dinfo.normMul(i - ns);
                    for (j = 0; j < this._dinfo.numStart(); ++j) {
                        double[] dArray = gram[k];
                        int n = j;
                        dArray[n] = dArray[n] - mean_i * scale_i * wsum[j];
                    }
                    for (j = ns; j < gram[k].length - 1; ++j) {
                        double mean_j = this._dinfo.normSub(j - ns);
                        double scale_j = this._dinfo.normMul(j - ns);
                        gram[k][j] = gram[k][j] - mean_j * scale_j * wsum[i] - mean_i * scale_i * wsum[j] + mean_i * mean_j * scale_i * scale_j * wsum[wsum.length - 1];
                    }
                    double[] dArray = gram[k];
                    int n = gram[k].length - 1;
                    dArray[n] = dArray[n] - mean_i * scale_i * wsum[gram[k].length - 1];
                    int n2 = k++;
                    xy[n2] = xy[n2] - ywsum * mean_i * scale_i;
                }
            }
            this._gram = gram;
            this._xy = xy;
        }

        public void reduce(GLMIncrementalGramTask gt) {
            ArrayUtils.add((double[])this._xy, (double[])gt._xy);
            for (int i = 0; i < this._gram.length; ++i) {
                ArrayUtils.add((double[])this._gram[i], (double[])gt._gram[i]);
            }
        }
    }

    public static class ComputeSETsk
    extends FrameTask2<ComputeSETsk> {
        final double[] _betaNew;
        double _sumsqe;
        double _wsum;
        transient double _sparseOffsetOld = 0.0;
        transient double _sparseOffsetNew = 0.0;
        final GLMModel.GLMWeightsFun _glmf;
        transient GLMModel.GLMWeights _glmw;

        public ComputeSETsk(H2O.H2OCountedCompleter cmp, DataInfo dinfo, Key jobKey, double[] betaNew, GLMModel.GLMParameters parms) {
            super(cmp, dinfo, (Key<Job>)jobKey);
            this._glmf = new GLMModel.GLMWeightsFun(parms);
            this._betaNew = betaNew;
        }

        @Override
        public void chunkInit() {
            if (this._sparse) {
                this._sparseOffsetNew = GLM.sparseOffset(this._betaNew, this._dinfo);
            }
            this._glmw = new GLMModel.GLMWeights();
        }

        @Override
        protected void processRow(DataInfo.Row r) {
            double z = r.response(0) - r.offset;
            double w = r.weight;
            if (this._glmf._family != GLMModel.GLMParameters.Family.gaussian) {
                double etaOld = r.innerProduct(this._betaNew) + this._sparseOffsetNew;
                this._glmf.computeWeights(r.response(0), etaOld, r.offset, r.weight, this._glmw);
                z = this._glmw.z;
                w = this._glmw.w;
            }
            double eta = r.innerProduct(this._betaNew) + this._sparseOffsetNew;
            this._sumsqe += w * (eta - z) * (eta - z);
            this._wsum += Math.sqrt(w);
        }

        public void reduce(ComputeSETsk c) {
            this._sumsqe += c._sumsqe;
            this._wsum += c._wsum;
        }
    }

    public static class GLMGenerateWeightsTask
    extends MRTask<GLMGenerateWeightsTask> {
        final GLMModel.GLMParameters _params;
        final double[] _betaw;
        double[] denums;
        double wsum;
        double wsumu;
        DataInfo _dinfo;
        double _likelihood;

        public GLMGenerateWeightsTask(Key jobKey, DataInfo dinfo, GLMModel.GLMParameters glm, double[] betaw) {
            this._params = glm;
            this._betaw = betaw;
            this._dinfo = dinfo;
        }

        public void map(Chunk[] chunks) {
            Chunk wChunk = chunks[chunks.length - 3];
            Chunk zChunk = chunks[chunks.length - 2];
            Chunk zTilda = chunks[chunks.length - 1];
            chunks = Arrays.copyOf(chunks, chunks.length - 3);
            this.denums = new double[this._dinfo.fullN() + 1];
            DataInfo.Row r = this._dinfo.newDenseRow();
            for (int i = 0; i < chunks[0]._len; ++i) {
                int j;
                double mu;
                double z;
                double w;
                this._dinfo.extractDenseRow(chunks, i, r);
                if (r.isBad() || r.weight == 0.0) {
                    wChunk.set(i, 0L);
                    zChunk.set(i, 0L);
                    zTilda.set(i, 0L);
                    continue;
                }
                double y = r.response(0);
                assert (this._params._family != GLMModel.GLMParameters.Family.gamma || y > 0.0) : "illegal response column, y must be > 0  for family=Gamma.";
                assert (this._params._family != GLMModel.GLMParameters.Family.binomial || 0.0 <= y && y <= 1.0) : "illegal response column, y must be <0,1>  for family=Binomial. got " + y;
                int numStart = this._dinfo.numStart();
                double d = 1.0;
                double eta = r.innerProduct(this._betaw);
                if (this._params._family == GLMModel.GLMParameters.Family.gaussian && this._params._link == GLMModel.GLMParameters.Link.identity) {
                    w = r.weight;
                    z = y - r.offset;
                    mu = 0.0;
                } else {
                    mu = this._params.linkInv(eta + r.offset);
                    double var = Math.max(1.0E-6, this._params.variance(mu));
                    d = this._params.linkDeriv(mu);
                    z = eta + (y - mu) * d;
                    w = r.weight / (var * d * d);
                }
                this._likelihood += this._params.likelihood(y, mu);
                zTilda.set(i, eta - this._betaw[this._betaw.length - 1]);
                assert (w >= 0.0 || Double.isNaN(w)) : "invalid weight " + w;
                wChunk.set(i, w);
                zChunk.set(i, z);
                this.wsum += w;
                this.wsumu += r.weight;
                for (j = 0; j < r.nBins; ++j) {
                    int n = r.binIds[j];
                    this.denums[n] = this.denums[n] + w;
                }
                for (j = 0; j < r.nNums; ++j) {
                    int id;
                    int n = id = r.numIds == null ? j + numStart : r.numIds[j];
                    this.denums[n] = this.denums[n] + w * r.get(id) * r.get(id);
                }
            }
        }

        public void reduce(GLMGenerateWeightsTask git) {
            ArrayUtils.add((double[])this.denums, (double[])git.denums);
            this.wsum += git.wsum;
            this.wsumu += git.wsumu;
            this._likelihood += git._likelihood;
            super.reduce((MRTask)git);
        }
    }

    public static class GLMCoordinateDescentTaskSeqIntercept
    extends MRTask<GLMCoordinateDescentTaskSeqIntercept> {
        final double[] _betaold;
        public double _temp;
        DataInfo _dinfo;

        public GLMCoordinateDescentTaskSeqIntercept(double[] betaold, DataInfo dinfo) {
            this._betaold = betaold;
            this._dinfo = dinfo;
        }

        public void map(Chunk[] chunks) {
            int cnt = 0;
            Chunk wChunk = chunks[cnt++];
            Chunk zChunk = chunks[cnt++];
            Chunk filterChunk = chunks[cnt++];
            DataInfo.Row r = this._dinfo.newDenseRow();
            for (int i = 0; i < chunks[0]._len; ++i) {
                if (filterChunk.atd(i) == 1.0) continue;
                this._dinfo.extractDenseRow(chunks, i, r);
                this._temp = (double)wChunk.at8(i) * (zChunk.atd(i) - r.innerProduct(this._betaold));
            }
        }

        public void reduce(GLMCoordinateDescentTaskSeqIntercept git) {
            this._temp += git._temp;
            super.reduce((MRTask)git);
        }
    }

    public static class GLMCoordinateDescentTaskSeqNaive
    extends MRTask<GLMCoordinateDescentTaskSeqNaive> {
        public double[] _normMulold;
        public double[] _normSubold;
        public double[] _normMulnew;
        public double[] _normSubnew;
        final double[] _betaold;
        final double[] _betanew;
        final int[] _catLvls_new;
        final int[] _catLvls_old;
        public double[] _temp;
        boolean _skipFirst;
        long _nobs;
        int _cat_num;
        boolean _interceptnew;
        boolean _interceptold;

        public GLMCoordinateDescentTaskSeqNaive(boolean interceptold, boolean interceptnew, int cat_num, double[] betaold, double[] betanew, int[] catLvlsold, int[] catLvlsnew, double[] normMulold, double[] normSubold, double[] normMulnew, double[] normSubnew, boolean skipFirst) {
            this._normMulold = normMulold;
            this._normSubold = normSubold;
            this._normMulnew = normMulnew;
            this._normSubnew = normSubnew;
            this._cat_num = cat_num;
            this._betaold = betaold;
            this._betanew = betanew;
            this._interceptold = interceptold;
            this._interceptnew = interceptnew;
            this._catLvls_old = catLvlsold;
            this._catLvls_new = catLvlsnew;
            this._skipFirst = skipFirst;
        }

        public void map(Chunk[] chunks) {
            int cnt = 0;
            Chunk wChunk = chunks[cnt++];
            Chunk zChunk = chunks[cnt++];
            Chunk ztildaChunk = chunks[cnt++];
            Chunk xpChunk = null;
            Chunk xChunk = null;
            this._temp = new double[this._betaold.length];
            if (this._interceptnew) {
                xChunk = new C0DChunk(1.0, chunks[0]._len);
                xpChunk = chunks[cnt++];
            } else if (this._interceptold) {
                xChunk = chunks[cnt++];
                xpChunk = new C0DChunk(1.0, chunks[0]._len);
            } else {
                xChunk = chunks[cnt++];
                xpChunk = chunks[cnt++];
            }
            for (int i = 0; i < chunks[0]._len; ++i) {
                double betanew = 0.0;
                double betaold = 0.0;
                double w = wChunk.atd(i);
                if (w == 0.0) continue;
                ++this._nobs;
                int observation_level = 0;
                int observation_level_p = 0;
                double val = 1.0;
                double valp = 1.0;
                if (this._cat_num == 1) {
                    observation_level = (int)xChunk.at8(i);
                    if (this._catLvls_old != null) {
                        observation_level = Arrays.binarySearch(this._catLvls_old, observation_level);
                    }
                    observation_level_p = (int)xpChunk.at8(i);
                    if (this._catLvls_new != null) {
                        observation_level_p = Arrays.binarySearch(this._catLvls_new, observation_level_p);
                    }
                    if (this._skipFirst) {
                        --observation_level;
                        --observation_level_p;
                    }
                } else if (this._cat_num == 2) {
                    val = xChunk.atd(i);
                    if (this._normMulold != null && this._normSubold != null) {
                        val = (val - this._normSubold[0]) * this._normMulold[0];
                    }
                    observation_level_p = (int)xpChunk.at8(i);
                    if (this._catLvls_new != null) {
                        observation_level_p = Arrays.binarySearch(this._catLvls_new, observation_level_p);
                    }
                    if (this._skipFirst) {
                        --observation_level_p;
                    }
                } else if (this._cat_num == 3) {
                    val = xChunk.atd(i);
                    if (this._normMulold != null && this._normSubold != null) {
                        val = (val - this._normSubold[0]) * this._normMulold[0];
                    }
                    valp = xpChunk.atd(i);
                    if (this._normMulnew != null && this._normSubnew != null) {
                        valp = (valp - this._normSubnew[0]) * this._normMulnew[0];
                    }
                } else if (this._cat_num == 4) {
                    observation_level = (int)xChunk.at8(i);
                    if (this._catLvls_old != null) {
                        observation_level = Arrays.binarySearch(this._catLvls_old, observation_level);
                    }
                    if (this._skipFirst) {
                        --observation_level;
                    }
                    valp = xpChunk.atd(i);
                    if (this._normMulnew != null && this._normSubnew != null) {
                        valp = (valp - this._normSubnew[0]) * this._normMulnew[0];
                    }
                }
                if (observation_level >= 0) {
                    betaold = this._betaold[observation_level];
                }
                if (observation_level_p >= 0) {
                    betanew = this._betanew[observation_level_p];
                }
                if (this._interceptnew) {
                    ztildaChunk.set(i, ztildaChunk.atd(i) - betaold + valp * betanew);
                    this._temp[0] = this._temp[0] + w * (zChunk.atd(i) - ztildaChunk.atd(i));
                    continue;
                }
                ztildaChunk.set(i, ztildaChunk.atd(i) - val * betaold + valp * betanew);
                if (observation_level < 0) continue;
                int n = observation_level;
                this._temp[n] = this._temp[n] + w * val * (zChunk.atd(i) - ztildaChunk.atd(i));
            }
        }

        public void reduce(GLMCoordinateDescentTaskSeqNaive git) {
            ArrayUtils.add((double[])this._temp, (double[])git._temp);
            this._nobs += git._nobs;
            super.reduce((MRTask)git);
        }
    }

    public static class GLMIterationTask
    extends FrameTask2<GLMIterationTask> {
        final GLMModel.GLMWeightsFun _glmf;
        double[][] _beta_multinomial;
        double[] _beta;
        protected Gram _gram;
        double[] _xy;
        double _yy;
        final double[] _ymu;
        long _nobs;
        public double _likelihood;
        private transient GLMModel.GLMWeights _w;
        double wsum;
        double wsumu;
        double _sumsqe;
        int _c = -1;
        private transient double _sparseOffset;

        public GLMIterationTask(Key jobKey, DataInfo dinfo, GLMModel.GLMWeightsFun glmw, double[] beta) {
            super(null, dinfo, (Key<Job>)jobKey);
            this._beta = beta;
            this._ymu = null;
            this._glmf = glmw;
        }

        public GLMIterationTask(Key jobKey, DataInfo dinfo, GLMModel.GLMWeightsFun glmw, double[] beta, int c) {
            super(null, dinfo, (Key<Job>)jobKey);
            this._beta = beta;
            this._ymu = null;
            this._glmf = glmw;
            this._c = c;
        }

        @Override
        public boolean handlesSparseData() {
            return true;
        }

        @Override
        public void chunkInit() {
            this._gram = new Gram(this._dinfo.fullN(), this._dinfo.largestCat(), this._dinfo.numNums(), this._dinfo._cats, true);
            this._xy = MemoryManager.malloc8d((int)(this._dinfo.fullN() + 1));
            if (this._sparse) {
                this._sparseOffset = GLM.sparseOffset(this._beta, this._dinfo);
            }
            this._w = new GLMModel.GLMWeights();
        }

        @Override
        protected void processRow(DataInfo.Row r) {
            int i;
            double w;
            double wz;
            if (r.isBad() || r.weight == 0.0) {
                return;
            }
            ++this._nobs;
            double y = r.response(0);
            this._yy += y * y;
            int numStart = this._dinfo.numStart();
            if (this._glmf._family == GLMModel.GLMParameters.Family.multinomial) {
                y = y == (double)this._c ? 1.0 : 0.0;
                double mu = r.response(1);
                double eta = r.response(2);
                double d = mu * (1.0 - mu);
                if (d == 0.0) {
                    d = 1.0E-10;
                }
                wz = r.weight * (eta * d + (y - mu));
                w = r.weight * d;
            } else if (this._beta != null) {
                this._glmf.computeWeights(y, r.innerProduct(this._beta) + this._sparseOffset, r.offset, r.weight, this._w);
                w = this._w.w;
                wz = w * this._w.z;
                this._likelihood += this._w.l;
            } else {
                w = r.weight;
                wz = w * (y - r.offset);
            }
            this.wsum += w;
            this.wsumu += r.weight;
            for (i = 0; i < r.nBins; ++i) {
                int n = r.binIds[i];
                this._xy[n] = this._xy[n] + wz;
            }
            for (i = 0; i < r.nNums; ++i) {
                int id = r.numIds == null ? i + numStart : r.numIds[i];
                double val = r.numVals[i];
                int n = id;
                this._xy[n] = this._xy[n] + wz * val;
            }
            if (this._dinfo._intercept) {
                int n = this._xy.length - 1;
                this._xy[n] = this._xy[n] + wz;
            }
            this._gram.addRow(r, w);
        }

        @Override
        public void chunkDone() {
            this.adjustForSparseStandardizedZeros();
        }

        public void reduce(GLMIterationTask git) {
            ArrayUtils.add((double[])this._xy, (double[])git._xy);
            this._gram.add(git._gram);
            this._nobs += git._nobs;
            this.wsum += git.wsum;
            this.wsumu += git.wsumu;
            this._likelihood += git._likelihood;
            this._sumsqe += git._sumsqe;
            this._yy += git._yy;
            super.reduce((MRTask)git);
        }

        private void adjustForSparseStandardizedZeros() {
            if (this._sparse && this._dinfo._normSub != null) {
                int i;
                int ns = this._dinfo.numStart();
                int interceptIdx = this._xy.length - 1;
                double[] interceptRow = this._gram._xx[interceptIdx - this._gram._diagN];
                double nobs = interceptRow[interceptRow.length - 1];
                for (i = ns; i < this._dinfo.fullN(); ++i) {
                    int j;
                    double iMean = this._dinfo._normSub[i - ns] * this._dinfo._normMul[i - ns];
                    for (j = 0; j < ns; ++j) {
                        double[] dArray = this._gram._xx[i - this._gram._diagN];
                        int n = j;
                        dArray[n] = dArray[n] - interceptRow[j] * iMean;
                    }
                    for (j = ns; j <= i; ++j) {
                        double jMean = this._dinfo._normSub[j - ns] * this._dinfo._normMul[j - ns];
                        double[] dArray = this._gram._xx[i - this._gram._diagN];
                        int n = j;
                        dArray[n] = dArray[n] - (interceptRow[i] * jMean + interceptRow[j] * iMean - nobs * iMean * jMean);
                    }
                }
                if (this._dinfo._intercept) {
                    for (int j = ns; j < this._dinfo.fullN(); ++j) {
                        int n = j;
                        interceptRow[n] = interceptRow[n] - nobs * this._dinfo._normSub[j - ns] * this._dinfo._normMul[j - ns];
                    }
                }
                for (i = ns; i < this._dinfo.fullN(); ++i) {
                    int n = i;
                    this._xy[n] = this._xy[n] - this._xy[this._xy.length - 1] * this._dinfo._normSub[i - ns] * this._dinfo._normMul[i - ns];
                }
            }
        }

        public boolean hasNaNsOrInf() {
            return ArrayUtils.hasNaNsOrInfs((double[])this._xy) || this._gram.hasNaNsOrInfs();
        }
    }

    public static class GLMMultinomialUpdate
    extends FrameTask2<GLMMultinomialUpdate> {
        private final double[][] _beta;
        private final int _c;
        private transient double[] _sparseOffsets;
        private transient double[] _etas;
        private transient Chunk _sumExpChunk;
        private transient Chunk _maxRowChunk;

        public GLMMultinomialUpdate(DataInfo dinfo, Key jobKey, double[] beta, int c) {
            super(null, dinfo, (Key<Job>)jobKey);
            this._beta = ArrayUtils.convertTo2DMatrix((double[])beta, (int)(dinfo.fullN() + 1));
            this._c = c;
        }

        @Override
        public void chunkInit() {
            this._sparseOffsets = MemoryManager.malloc8d((int)this._beta.length);
            this._etas = MemoryManager.malloc8d((int)this._beta.length);
            if (this._sparse) {
                for (int i = 0; i < this._beta.length; ++i) {
                    this._sparseOffsets[i] = GLM.sparseOffset(this._beta[i], this._dinfo);
                }
            }
        }

        @Override
        public void map(Chunk[] chks) {
            this._sumExpChunk = chks[chks.length - 2];
            this._maxRowChunk = chks[chks.length - 1];
            super.map(chks);
        }

        @Override
        protected void processRow(DataInfo.Row r) {
            double maxrow = 0.0;
            for (int i = 0; i < this._beta.length; ++i) {
                this._etas[i] = r.innerProduct(this._beta[i]) + this._sparseOffsets[i];
                if (!(this._etas[i] > maxrow)) continue;
                maxrow = this._etas[i];
            }
            double sumExp = 0.0;
            for (int i = 0; i < this._beta.length; ++i) {
                sumExp += Math.exp(this._etas[i] - maxrow);
            }
            this._maxRowChunk.set(r.cid, this._etas[this._c]);
            this._sumExpChunk.set(r.cid, Math.exp(this._etas[this._c] - maxrow) / sumExp);
        }
    }

    public static class GLMIterationTaskMultinomial
    extends FrameTask2<GLMIterationTaskMultinomial> {
        final int _c;
        final double[] _beta;
        double[] _xy;
        Gram _gram;
        transient double _sparseOffset;

        public GLMIterationTaskMultinomial(DataInfo dinfo, Key jobKey, double[] beta, int c) {
            super(null, dinfo, (Key<Job>)jobKey);
            this._beta = beta;
            this._c = c;
        }

        @Override
        public void chunkInit() {
            this._gram = new Gram(this._dinfo.fullN(), this._dinfo.largestCat(), this._dinfo.numNums(), this._dinfo._cats, true);
            this._xy = MemoryManager.malloc8d((int)(this._dinfo.fullN() + 1));
            if (this._sparse) {
                this._sparseOffset = GLM.sparseOffset(this._beta, this._dinfo);
            }
        }

        @Override
        protected void processRow(DataInfo.Row r) {
            int i;
            double mu;
            double y = r.response(0);
            double sumExp = r.response(1);
            double maxRow = r.response(2);
            int numStart = this._dinfo.numStart();
            y = y == (double)this._c ? 1.0 : 0.0;
            double eta = r.innerProduct(this._beta) + this._sparseOffset;
            if (eta > maxRow) {
                maxRow = eta;
            }
            double etaExp = Math.exp(eta - maxRow);
            double d = mu = etaExp == Double.POSITIVE_INFINITY ? 1.0 : etaExp / (sumExp += etaExp);
            if (mu < 1.0E-16) {
                mu = 1.0E-16;
            }
            double d2 = mu * (1.0 - mu);
            double wz = r.weight * (eta * d2 + (y - mu));
            double w = r.weight * d2;
            for (i = 0; i < r.nBins; ++i) {
                int n = r.binIds[i];
                this._xy[n] = this._xy[n] + wz;
            }
            for (i = 0; i < r.nNums; ++i) {
                int id = r.numIds == null ? i + numStart : r.numIds[i];
                double val = r.numVals[i];
                int n = id;
                this._xy[n] = this._xy[n] + wz * val;
            }
            if (this._dinfo._intercept) {
                int n = this._xy.length - 1;
                this._xy[n] = this._xy[n] + wz;
            }
            this._gram.addRow(r, w);
        }

        public void reduce(GLMIterationTaskMultinomial glmt) {
            ArrayUtils.add((double[])this._xy, (double[])glmt._xy);
            this._gram.add(glmt._gram);
        }
    }

    public static class GLMMultinomialWLSTask
    extends LSTask {
        final GLMModel.GLMWeightsFun _glmw;
        final double[] _beta;
        double _sparseOffset;
        private transient GLMModel.GLMWeights _ws;

        public GLMMultinomialWLSTask(H2O.H2OCountedCompleter cmp, DataInfo dinfo, Key jobKey, GLMModel.GLMWeightsFun glmw, double[] beta) {
            super(cmp, dinfo, jobKey);
            this._glmw = glmw;
            this._beta = beta;
        }

        @Override
        public void chunkInit() {
            super.chunkInit();
            this._ws = new GLMModel.GLMWeights();
        }

        @Override
        public void processRow(DataInfo.Row r) {
            double eta = r.innerProduct(this._beta) + this._sparseOffset;
            this._glmw.computeWeights(r.response(0), eta, r.weight, r.offset, this._ws);
            r.weight = this._ws.w;
            r.offset = 0.0;
            r.setResponse(0, this._ws.z);
            super.processRow(r);
        }
    }

    public static class GLMWLSTask
    extends LSTask {
        final GLMModel.GLMWeightsFun _glmw;
        final double[] _beta;
        double _sparseOffset;
        private transient GLMModel.GLMWeights _ws;

        public GLMWLSTask(H2O.H2OCountedCompleter cmp, DataInfo dinfo, Key jobKey, GLMModel.GLMWeightsFun glmw, double[] beta) {
            super(cmp, dinfo, jobKey);
            this._glmw = glmw;
            this._beta = beta;
        }

        @Override
        public void chunkInit() {
            super.chunkInit();
            this._ws = new GLMModel.GLMWeights();
        }

        @Override
        public void processRow(DataInfo.Row r) {
            double eta = r.innerProduct(this._beta) + this._sparseOffset;
            this._glmw.computeWeights(r.response(0), eta, r.weight, r.offset, this._ws);
            r.weight = this._ws.w;
            r.offset = 0.0;
            r.setResponse(0, this._ws.z);
            super.processRow(r);
        }
    }

    public static class LSTask
    extends FrameTask2<LSTask> {
        public double[] _xy;
        public Gram _gram;
        final int numStart;

        public LSTask(H2O.H2OCountedCompleter cmp, DataInfo dinfo, Key jobKey) {
            super(cmp, dinfo, (Key<Job>)jobKey);
            this.numStart = this._dinfo.numStart();
        }

        @Override
        public void chunkInit() {
            this._gram = new Gram(this._dinfo.fullN(), this._dinfo.largestCat(), this._dinfo.numNums(), this._dinfo._cats, true);
            this._xy = MemoryManager.malloc8d((int)(this._dinfo.fullN() + 1));
        }

        @Override
        protected void processRow(DataInfo.Row r) {
            int i;
            double wz = r.weight * (r.response(0) - r.offset);
            for (i = 0; i < r.nBins; ++i) {
                int n = r.binIds[i];
                this._xy[n] = this._xy[n] + wz;
            }
            for (i = 0; i < r.nNums; ++i) {
                int id = r.numIds == null ? i + this.numStart : r.numIds[i];
                double val = r.numVals[i];
                int n = id;
                this._xy[n] = this._xy[n] + wz * val;
            }
            if (this._dinfo._intercept) {
                int n = this._xy.length - 1;
                this._xy[n] = this._xy[n] + wz;
            }
            this._gram.addRow(r, r.weight);
        }

        public void reduce(LSTask lst) {
            ArrayUtils.add((double[])this._xy, (double[])lst._xy);
            this._gram.add(lst._gram);
        }

        public void postGlobal() {
            if (this._sparse && this._dinfo._normSub != null) {
                int i;
                int ns = this._dinfo.numStart();
                int interceptIdx = this._xy.length - 1;
                double[] interceptRow = this._gram._xx[interceptIdx - this._gram._diagN];
                double nobs = interceptRow[interceptRow.length - 1];
                for (i = ns; i < this._dinfo.fullN(); ++i) {
                    int j;
                    double iMean = this._dinfo._normSub[i - ns] * this._dinfo._normMul[i - ns];
                    for (j = 0; j < ns; ++j) {
                        double[] dArray = this._gram._xx[i - this._gram._diagN];
                        int n = j;
                        dArray[n] = dArray[n] - interceptRow[j] * iMean;
                    }
                    for (j = ns; j <= i; ++j) {
                        double jMean = this._dinfo._normSub[j - ns] * this._dinfo._normMul[j - ns];
                        double[] dArray = this._gram._xx[i - this._gram._diagN];
                        int n = j;
                        dArray[n] = dArray[n] - (interceptRow[i] * jMean + interceptRow[j] * iMean - nobs * iMean * jMean);
                    }
                }
                if (this._dinfo._intercept) {
                    for (int j = ns; j < this._dinfo.fullN(); ++j) {
                        int n = j;
                        interceptRow[n] = interceptRow[n] - nobs * this._dinfo._normSub[j - ns] * this._dinfo._normMul[j - ns];
                    }
                }
                for (i = ns; i < this._dinfo.fullN(); ++i) {
                    int n = i;
                    this._xy[n] = this._xy[n] - this._xy[this._xy.length - 1] * this._dinfo._normSub[i - ns] * this._dinfo._normMul[i - ns];
                }
            }
        }
    }

    static class GLMMultinomialGradientTask
    extends GLMMultinomialGradientBaseTask {
        public GLMMultinomialGradientTask(Job job, DataInfo dinfo, double lambda, double[][] beta, double reg) {
            super(job, dinfo, lambda, beta, reg);
        }

        public GLMMultinomialGradientTask(Job job, DataInfo dinfo, double lambda, double[][] beta, GLMModel.GLMParameters glmp) {
            super(job, dinfo, lambda, beta, glmp);
        }

        @Override
        public void calMultipliersNGradients(double[][] etas, double[][] etasOffset, double[] ws, double[] vals, int[] ids, Chunk response, Chunk[] chks, int M, int P, int numStart) {
            int i;
            if (this._glmp != null && this._link == GLMModel.GLMParameters.Link.ologit && (this._glmp._solver.equals((Object)GLMModel.GLMParameters.Solver.AUTO) || this._glmp._solver.equals((Object)GLMModel.GLMParameters.Solver.GRADIENT_DESCENT_LH))) {
                this.computeGradientMultipliersLH(etas, etasOffset, response.getDoubles(vals, 0, M), ws);
            } else if (this._glmp != null && this._link == GLMModel.GLMParameters.Link.ologit && this._glmp._solver.equals((Object)GLMModel.GLMParameters.Solver.GRADIENT_DESCENT_SQERR)) {
                this.computeGradientMultipliersSQERR(etas, etasOffset, response.getDoubles(vals, 0, M), ws);
            } else {
                this.computeGradientMultipliers(etas, response.getDoubles(vals, 0, M), ws);
            }
            this.computeCategoricalGrads(chks, etas, vals, ids);
            this.computeNumericGrads(chks, etas, vals, ids);
            double[] g = this._gradient[P - 1];
            if (this._link == GLMModel.GLMParameters.Link.ologit) {
                for (i = 0; i < etasOffset.length; ++i) {
                    ArrayUtils.add((double[])g, (double[])etasOffset[i]);
                }
            } else {
                for (i = 0; i < etas.length; ++i) {
                    ArrayUtils.add((double[])g, (double[])etas[i]);
                }
            }
            if (this._dinfo._normSub != null) {
                double[] icpt = this._gradient[P - 1];
                for (int i2 = 0; i2 < this._dinfo._normSub.length; ++i2) {
                    if (!chks[this._dinfo._cats + i2].isSparseZero()) continue;
                    ArrayUtils.wadd((double[])this._gradient[numStart + i2], (double[])icpt, (double)(-this._dinfo._normSub[i2] * this._dinfo._normMul[i2]));
                }
            }
        }
    }

    static abstract class GLMMultinomialGradientBaseTask
    extends MRTask<GLMMultinomialGradientBaseTask> {
        final double[][] _beta;
        final transient double _currentLambda;
        final transient double _reg;
        public double[][] _gradient;
        double _likelihood;
        Job _job;
        final boolean _sparse;
        final DataInfo _dinfo;
        GLMModel.GLMParameters.Link _link;
        GLMModel.GLMParameters _glmp;
        int _secondToLast;
        int _theLast;
        int _interceptId;

        public GLMMultinomialGradientBaseTask(Job job, DataInfo dinfo, double lambda, double[][] beta, double reg) {
            this._currentLambda = lambda;
            this._reg = reg;
            this._beta = new double[beta[0].length][beta.length];
            for (int i = 0; i < this._beta.length; ++i) {
                for (int j = 0; j < this._beta[i].length; ++j) {
                    this._beta[i][j] = beta[j][i];
                }
            }
            this._job = job;
            this._sparse = FrameUtils.sparseRatio((Frame)dinfo._adaptedFrame) < 0.125;
            this._dinfo = dinfo;
            if (this._dinfo._offset) {
                throw H2O.unimpl();
            }
        }

        public GLMMultinomialGradientBaseTask(Job job, DataInfo dinfo, double lambda, double[][] beta, GLMModel.GLMParameters glmp) {
            this(job, dinfo, lambda, beta, glmp._obj_reg);
            this._theLast = beta.length - 1;
            this._secondToLast = this._theLast - 1;
            this._interceptId = this._beta.length - 1;
            this._link = glmp._link;
            this._glmp = glmp;
        }

        public final void computeCategoricalEtas(Chunk[] chks, double[][] etas, double[] vals, int[] ids) {
            for (int cid = 0; cid < this._dinfo._cats; ++cid) {
                Chunk c = chks[cid];
                if (c.isSparseZero()) {
                    int nvals = c.getSparseDoubles(vals, ids, -1.0);
                    for (int i = 0; i < nvals; ++i) {
                        int id = this._dinfo.getCategoricalId(cid, (int)vals[i]);
                        if (id < 0) continue;
                        ArrayUtils.add((double[])etas[ids[i]], (double[])this._beta[id]);
                    }
                    continue;
                }
                c.getIntegers(ids, 0, c._len, -1);
                for (int i = 0; i < ids.length; ++i) {
                    int id = this._dinfo.getCategoricalId(cid, ids[i]);
                    if (id < 0) continue;
                    ArrayUtils.add((double[])etas[i], (double[])this._beta[id]);
                }
            }
        }

        public final void computeCategoricalGrads(Chunk[] chks, double[][] etas, double[] vals, int[] ids) {
            for (int cid = 0; cid < this._dinfo._cats; ++cid) {
                Chunk c = chks[cid];
                if (c.isSparseZero()) {
                    int nvals = c.getSparseDoubles(vals, ids, -1.0);
                    for (int i = 0; i < nvals; ++i) {
                        int id = this._dinfo.getCategoricalId(cid, (int)vals[i]);
                        if (id < 0) continue;
                        ArrayUtils.add((double[])this._gradient[id], (double[])etas[ids[i]]);
                    }
                    continue;
                }
                c.getIntegers(ids, 0, c._len, -1);
                for (int i = 0; i < ids.length; ++i) {
                    int id = this._dinfo.getCategoricalId(cid, ids[i]);
                    if (id < 0) continue;
                    ArrayUtils.add((double[])this._gradient[id], (double[])etas[i]);
                }
            }
        }

        public final void computeNumericEtas(Chunk[] chks, double[][] etas, double[] vals, int[] ids) {
            int numOff = this._dinfo.numStart();
            for (int cid = 0; cid < this._dinfo._nums; ++cid) {
                double[] b = this._beta[numOff + cid];
                double scale = this._dinfo._normMul != null ? this._dinfo._normMul[cid] : 1.0;
                double NA = this._dinfo._numMeans[cid];
                Chunk c = chks[cid + this._dinfo._cats];
                if (c.isSparseZero() || c.isSparseNA()) {
                    int nvals = c.getSparseDoubles(vals, ids, NA);
                    for (int i = 0; i < nvals; ++i) {
                        double d = vals[i] * scale;
                        ArrayUtils.wadd((double[])etas[ids[i]], (double[])b, (double)d);
                    }
                    continue;
                }
                c.getDoubles(vals, 0, vals.length, NA);
                double off = this._dinfo._normSub != null ? this._dinfo._normSub[cid] : 0.0;
                for (int i = 0; i < vals.length; ++i) {
                    double d = (vals[i] - off) * scale;
                    ArrayUtils.wadd((double[])etas[i], (double[])b, (double)d);
                }
            }
        }

        public final void computeNumericGrads(Chunk[] chks, double[][] etas, double[] vals, int[] ids) {
            int numOff = this._dinfo.numStart();
            for (int cid = 0; cid < this._dinfo._nums; ++cid) {
                double scale;
                double[] g = this._gradient[numOff + cid];
                double NA = this._dinfo._numMeans[cid];
                Chunk c = chks[cid + this._dinfo._cats];
                double d = scale = this._dinfo._normMul == null ? 1.0 : this._dinfo._normMul[cid];
                if (c.isSparseZero() || c.isSparseNA()) {
                    int nVals = c.getSparseDoubles(vals, ids, NA);
                    for (int i = 0; i < nVals; ++i) {
                        ArrayUtils.wadd((double[])g, (double[])etas[ids[i]], (double)(vals[i] * scale));
                    }
                    continue;
                }
                double off = this._dinfo._normSub == null ? 0.0 : this._dinfo._normSub[cid];
                c.getDoubles(vals, 0, vals.length, NA);
                for (int i = 0; i < vals.length; ++i) {
                    ArrayUtils.wadd((double[])g, (double[])etas[i], (double)((vals[i] - off) * scale));
                }
            }
        }

        final void computeGradientMultipliersLH(double[][] etas, double[][] etasOffset, double[] ys, double[] ws) {
            int K = this._beta[0].length;
            double[] tempEtas = new double[K];
            for (int row = 0; row < etas.length; ++row) {
                double w = ws[row];
                if (w == 0.0) {
                    Arrays.fill(etas[row], 0.0);
                    continue;
                }
                System.arraycopy(etas[row], 0, tempEtas, 0, K);
                Arrays.fill(etas[row], 0.0);
                int y = (int)ys[row];
                if (y == 0) {
                    etasOffset[row][0] = this._glmp.linkInv(tempEtas[0]) - 1.0;
                    etas[row][0] = etasOffset[row][0];
                    this._likelihood -= w * tempEtas[y] - Math.log(1.0 + Math.exp(tempEtas[y]));
                } else if (y == this._theLast) {
                    etasOffset[row][this._secondToLast] = this._glmp.linkInv(tempEtas[this._secondToLast]);
                    etas[row][0] = etasOffset[row][this._secondToLast];
                    this._likelihood += w * Math.log(1.0 + Math.exp(tempEtas[this._secondToLast]));
                } else {
                    double yJm1;
                    int lastC = y - 1;
                    double yJ = this._glmp.linkInv(tempEtas[y]);
                    double den = yJ - (yJm1 = this._glmp.linkInv(tempEtas[lastC]));
                    den = den == 0.0 ? 1.0E-10 : den;
                    this._likelihood -= w * Math.log(den);
                    etas[row][0] = yJ + yJm1 - 1.0;
                    double oneMcdfPC = 1.0 - yJm1;
                    oneMcdfPC = oneMcdfPC == 0.0 ? 1.0E-10 : oneMcdfPC;
                    double oneOthreshold = 1.0 - Math.exp(this._beta[this._interceptId][lastC] - this._beta[this._interceptId][y]);
                    oneOthreshold = oneOthreshold == 0.0 ? 1.0E-10 : oneOthreshold;
                    double oneOverThreshold = 1.0 / oneOthreshold;
                    etasOffset[row][y] = (yJ - 1.0) * oneOverThreshold / oneMcdfPC;
                    yJ = yJ == 0.0 ? 1.0E-10 : yJ;
                    etasOffset[row][lastC] = yJm1 * oneOverThreshold / yJ;
                }
                for (int c = 1; c < K; ++c) {
                    etas[row][c] = etas[row][0];
                }
            }
        }

        final void computeGradientMultipliersSQERR(double[][] etas, double[][] etasOffset, double[] ys, double[] ws) {
            int K = this._beta[0].length;
            double[] tempEtas = new double[K];
            for (int row = 0; row < etas.length; ++row) {
                int c;
                double w = ws[row];
                if (w == 0.0) {
                    Arrays.fill(etas[row], 0.0);
                    continue;
                }
                System.arraycopy(etas[row], 0, tempEtas, 0, K);
                Arrays.fill(etas[row], 0.0);
                int y = (int)ys[row];
                for (c = 0; c < y; ++c) {
                    if (!(tempEtas[c] > 0.0)) continue;
                    etasOffset[row][c] = tempEtas[c];
                    double[] dArray = etas[row];
                    dArray[0] = dArray[0] + tempEtas[c];
                    this._likelihood += w * 0.5 * tempEtas[c] * tempEtas[c];
                }
                for (c = y; c < this._theLast; ++c) {
                    if (!(tempEtas[c] <= 0.0)) continue;
                    etasOffset[row][c] = tempEtas[c];
                    double[] dArray = etas[row];
                    dArray[0] = dArray[0] + tempEtas[c];
                    this._likelihood += w * 0.5 * tempEtas[c] * tempEtas[c];
                }
                for (c = 1; c < K; ++c) {
                    etas[row][c] = etas[row][0];
                }
            }
        }

        final void computeGradientMultipliers(double[][] etas, double[] ys, double[] ws) {
            int K = this._beta[0].length;
            double[] exps = new double[K + 1];
            for (int i = 0; i < etas.length; ++i) {
                double w = ws[i];
                if (w == 0.0) {
                    Arrays.fill(etas[i], 0.0);
                    continue;
                }
                int y = (int)ys[i];
                double logSumExp = GLMTask.computeMultinomialEtas(etas[i], exps);
                this._likelihood -= w * (etas[i][y] - logSumExp);
                for (int c = 0; c < K; ++c) {
                    etas[i][c] = w * (exps[c + 1] - (double)(y == c ? 1 : 0));
                }
            }
        }

        public void map(Chunk[] chks) {
            int i;
            if (this._job != null && this._job.stop_requested()) {
                throw new Job.JobCancelledException();
            }
            int numStart = this._dinfo.numStart();
            int K = this._beta[0].length;
            int P = this._beta.length;
            int M = chks[0]._len;
            this._gradient = new double[P][K];
            double[][] etas = new double[M][K];
            double[][] etasOffset = new double[M][K];
            double[] offsets = new double[K];
            for (int k = 0; k < K; ++k) {
                offsets[k] = this._beta[P - 1][k];
            }
            if (this._dinfo._normSub != null) {
                for (i = 0; i < this._dinfo._nums; ++i) {
                    if (!chks[this._dinfo._cats + i].isSparseZero()) continue;
                    ArrayUtils.wadd((double[])offsets, (double[])this._beta[numStart + i], (double)(-this._dinfo._normSub[i] * this._dinfo._normMul[i]));
                }
            }
            for (i = 0; i < chks[0]._len; ++i) {
                System.arraycopy(offsets, 0, etas[i], 0, K);
            }
            Chunk response = chks[this._dinfo.responseChunkId(0)];
            double[] ws = MemoryManager.malloc8d((int)M);
            if (this._dinfo._weights) {
                ws = chks[this._dinfo.weightChunkId()].getDoubles(ws, 0, M);
            } else {
                Arrays.fill(ws, 1.0);
            }
            chks = Arrays.copyOf(chks, chks.length - 1 - (this._dinfo._weights ? 1 : 0));
            double[] vals = MemoryManager.malloc8d((int)M);
            int[] ids = MemoryManager.malloc4((int)M);
            this.computeCategoricalEtas(chks, etas, vals, ids);
            this.computeNumericEtas(chks, etas, vals, ids);
            this.calMultipliersNGradients(etas, etasOffset, ws, vals, ids, response, chks, M, P, numStart);
        }

        public abstract void calMultipliersNGradients(double[][] var1, double[][] var2, double[] var3, double[] var4, int[] var5, Chunk var6, Chunk[] var7, int var8, int var9, int var10);

        public void reduce(GLMMultinomialGradientBaseTask gmgt) {
            if (this._gradient != gmgt._gradient) {
                ArrayUtils.add((double[][])this._gradient, (double[][])gmgt._gradient);
            }
            this._likelihood += gmgt._likelihood;
        }

        public void postGlobal() {
            ArrayUtils.mult((double[][])this._gradient, (double)this._reg);
            int P = this._beta.length;
            if (this._currentLambda > 0.0) {
                for (int c = 0; c < P - 1; ++c) {
                    for (int j = 0; j < this._beta[0].length; ++j) {
                        double[] dArray = this._gradient[c];
                        int n = j;
                        dArray[n] = dArray[n] + this._currentLambda * this._beta[c][j];
                    }
                }
            }
        }

        public double[] gradient() {
            double[] res = MemoryManager.malloc8d((int)(this._gradient.length * this._gradient[0].length));
            int P = this._gradient.length;
            for (int k = 0; k < this._gradient[0].length; ++k) {
                for (int i = 0; i < this._gradient.length; ++i) {
                    res[k * P + i] = this._gradient[i][k];
                }
            }
            return res;
        }
    }

    static class GLMMultinomialLikelihoodTask
    extends GLMMultinomialGradientBaseTask {
        public GLMMultinomialLikelihoodTask(Job job, DataInfo dinfo, double lambda, double[][] beta, double reg) {
            super(job, dinfo, lambda, beta, reg);
        }

        public GLMMultinomialLikelihoodTask(Job job, DataInfo dinfo, double lambda, double[][] beta, GLMModel.GLMParameters glmp) {
            super(job, dinfo, lambda, beta, glmp);
        }

        @Override
        public void calMultipliersNGradients(double[][] etas, double[][] etasOffset, double[] ws, double[] vals, int[] ids, Chunk response, Chunk[] chks, int M, int P, int numStart) {
            this.computeGradientMultipliers(etas, response.getDoubles(vals, 0, M), ws);
        }
    }

    static class GLMGaussianGradientTask
    extends GLMGradientTask {
        public GLMGaussianGradientTask(Key jobKey, DataInfo dinfo, GLMModel.GLMParameters parms, double lambda, double[] beta) {
            super(jobKey, dinfo, parms._obj_reg, lambda, beta);
            assert (parms._family == GLMModel.GLMParameters.Family.gaussian && parms._link == GLMModel.GLMParameters.Link.identity);
        }

        @Override
        protected void computeGradientMultipliers(double[] es, double[] ys, double[] ws) {
            for (int i = 0; i < es.length; ++i) {
                double w = ws[i];
                if (w == 0.0 || Double.isNaN(ys[i])) {
                    es[i] = 0.0;
                    continue;
                }
                double e = es[i];
                double y = ys[i];
                double d = e - y;
                double wd = w * d;
                this._likelihood += wd * d;
                es[i] = wd;
            }
        }
    }

    static class GLMBinomialGradientTask
    extends GLMGradientTask {
        public GLMBinomialGradientTask(Key jobKey, DataInfo dinfo, GLMModel.GLMParameters parms, double lambda, double[] beta) {
            super(jobKey, dinfo, parms._obj_reg, lambda, beta);
            assert (parms._family == GLMModel.GLMParameters.Family.binomial && parms._link == GLMModel.GLMParameters.Link.logit);
        }

        @Override
        protected void computeGradientMultipliers(double[] es, double[] ys, double[] ws) {
            for (int i = 0; i < es.length; ++i) {
                if (Double.isNaN(ys[i]) || ws[i] == 0.0) {
                    es[i] = 0.0;
                    continue;
                }
                double e = es[i];
                double w = ws[i];
                double yr = ys[i];
                double ym = 1.0 / (Math.exp(-e) + 1.0);
                if (ym != yr) {
                    this._likelihood += w * (MathUtils.y_log_y((double)yr, (double)ym) + MathUtils.y_log_y((double)(1.0 - yr), (double)(1.0 - ym)));
                }
                es[i] = ws[i] * (ym - yr);
            }
        }
    }

    static class GLMQuasiBinomialGradientTask
    extends GLMGradientTask {
        private final GLMModel.GLMWeightsFun _glmf;

        public GLMQuasiBinomialGradientTask(Key jobKey, DataInfo dinfo, GLMModel.GLMParameters parms, double lambda, double[] beta) {
            super(jobKey, dinfo, parms._obj_reg, lambda, beta);
            this._glmf = new GLMModel.GLMWeightsFun(parms);
        }

        @Override
        protected void computeGradientMultipliers(double[] es, double[] ys, double[] ws) {
            double l = 0.0;
            for (int i = 0; i < es.length; ++i) {
                double p = this._glmf.linkInv(es[i]);
                if (p == 0.0) {
                    p = 1.0E-15;
                }
                if (p == 1.0) {
                    p = 0.999999999999999;
                }
                es[i] = -ws[i] * (ys[i] - p);
                l += ys[i] * Math.log(p) + (1.0 - ys[i]) * Math.log(1.0 - p);
            }
            this._likelihood = -l;
        }
    }

    static class GLMPoissonGradientTask
    extends GLMGradientTask {
        private final GLMModel.GLMWeightsFun _glmf;

        public GLMPoissonGradientTask(Key jobKey, DataInfo dinfo, GLMModel.GLMParameters parms, double lambda, double[] beta) {
            super(jobKey, dinfo, parms._obj_reg, lambda, beta);
            this._glmf = new GLMModel.GLMWeightsFun(parms);
        }

        @Override
        protected void computeGradientMultipliers(double[] es, double[] ys, double[] ws) {
            double l = 0.0;
            for (int i = 0; i < es.length; ++i) {
                if (Double.isNaN(ys[i]) || ws[i] == 0.0) {
                    es[i] = 0.0;
                    continue;
                }
                double eta = es[i];
                double mu = Math.exp(eta);
                double yr = ys[i];
                double diff = mu - yr;
                l += ws[i] * (yr == 0.0 ? mu : yr * Math.log(yr / mu) + diff);
                es[i] = ws[i] * diff;
            }
            this._likelihood = 2.0 * l;
        }
    }

    static class GLMGenericGradientTask
    extends GLMGradientTask {
        private final GLMModel.GLMWeightsFun _glmf;

        public GLMGenericGradientTask(Key jobKey, DataInfo dinfo, GLMModel.GLMParameters parms, double lambda, double[] beta) {
            super(jobKey, dinfo, parms._obj_reg, lambda, beta);
            this._glmf = new GLMModel.GLMWeightsFun(parms);
        }

        @Override
        protected void computeGradientMultipliers(double[] es, double[] ys, double[] ws) {
            double l = 0.0;
            for (int i = 0; i < es.length; ++i) {
                if (Double.isNaN(ys[i]) || ws[i] == 0.0) {
                    es[i] = 0.0;
                    continue;
                }
                double mu = this._glmf.linkInv(es[i]);
                l += ws[i] * this._glmf.likelihood(ys[i], mu);
                double var = this._glmf.variance(mu);
                if (var < 1.0E-6) {
                    var = 1.0E-6;
                }
                es[i] = ws[i] * (mu - ys[i]) / (var * this._glmf.linkDeriv(mu));
            }
            this._likelihood = l;
        }
    }

    static abstract class GLMGradientTask
    extends MRTask<GLMGradientTask> {
        final double[] _beta;
        public double[] _gradient;
        public double _likelihood;
        final transient double _currentLambda;
        final transient double _reg;
        protected final DataInfo _dinfo;

        protected GLMGradientTask(Key jobKey, DataInfo dinfo, double reg, double lambda, double[] beta) {
            this._dinfo = dinfo;
            this._beta = (double[])beta.clone();
            this._reg = reg;
            this._currentLambda = lambda;
        }

        protected abstract void computeGradientMultipliers(double[] var1, double[] var2, double[] var3);

        private final void computeCategoricalEtas(Chunk[] chks, double[] etas, double[] vals, int[] ids) {
            for (int cid = 0; cid < this._dinfo._cats; ++cid) {
                Chunk c = chks[cid];
                if (c.isSparseZero()) {
                    int nvals = c.getSparseDoubles(vals, ids, -1.0);
                    for (int i = 0; i < nvals; ++i) {
                        int id = this._dinfo.getCategoricalId(cid, (int)vals[i]);
                        if (id < 0) continue;
                        int n = ids[i];
                        etas[n] = etas[n] + this._beta[id];
                    }
                    continue;
                }
                c.getIntegers(ids, 0, c._len, -1);
                for (int i = 0; i < ids.length; ++i) {
                    int id = this._dinfo.getCategoricalId(cid, ids[i]);
                    if (id < 0) continue;
                    int n = i;
                    etas[n] = etas[n] + this._beta[id];
                }
            }
        }

        private final void computeCategoricalGrads(Chunk[] chks, double[] etas, double[] vals, int[] ids) {
            for (int cid = 0; cid < this._dinfo._cats; ++cid) {
                Chunk c = chks[cid];
                if (c.isSparseZero()) {
                    int nvals = c.getSparseDoubles(vals, ids, -1.0);
                    for (int i = 0; i < nvals; ++i) {
                        int id = this._dinfo.getCategoricalId(cid, (int)vals[i]);
                        if (id < 0) continue;
                        int n = id;
                        this._gradient[n] = this._gradient[n] + etas[ids[i]];
                    }
                    continue;
                }
                c.getIntegers(ids, 0, c._len, -1);
                for (int i = 0; i < ids.length; ++i) {
                    int id = this._dinfo.getCategoricalId(cid, ids[i]);
                    if (id < 0) continue;
                    int n = id;
                    this._gradient[n] = this._gradient[n] + etas[i];
                }
            }
        }

        private final void computeNumericEtas(Chunk[] chks, double[] etas, double[] vals, int[] ids) {
            int numOff = this._dinfo.numStart();
            for (int cid = 0; cid < this._dinfo._nums; ++cid) {
                int i;
                int nvals;
                double scale = this._dinfo._normMul != null ? this._dinfo._normMul[cid] : 1.0;
                double off = this._dinfo._normSub != null ? this._dinfo._normSub[cid] : 0.0;
                double NA = this._dinfo._numMeans[cid];
                Chunk c = chks[cid + this._dinfo._cats];
                double b = scale * this._beta[numOff + cid];
                if (c.isSparseZero()) {
                    nvals = c.getSparseDoubles(vals, ids, NA);
                    for (i = 0; i < nvals; ++i) {
                        int n = ids[i];
                        etas[n] = etas[n] + vals[i] * b;
                    }
                    continue;
                }
                if (c.isSparseNA()) {
                    nvals = c.getSparseDoubles(vals, ids, NA);
                    for (i = 0; i < nvals; ++i) {
                        int n = ids[i];
                        etas[n] = etas[n] + (vals[i] - off) * b;
                    }
                    continue;
                }
                c.getDoubles(vals, 0, vals.length, NA);
                for (int i2 = 0; i2 < vals.length; ++i2) {
                    int n = i2;
                    etas[n] = etas[n] + (vals[i2] - off) * b;
                }
            }
        }

        private final void computeNumericGrads(Chunk[] chks, double[] etas, double[] vals, int[] ids) {
            int numOff = this._dinfo.numStart();
            for (int cid = 0; cid < this._dinfo._nums; ++cid) {
                double off;
                double scale;
                double NA = this._dinfo._numMeans[cid];
                Chunk c = chks[cid + this._dinfo._cats];
                double d = scale = this._dinfo._normMul == null ? 1.0 : this._dinfo._normMul[cid];
                if (c.isSparseZero()) {
                    double g = 0.0;
                    int nVals = c.getSparseDoubles(vals, ids, NA);
                    for (int i = 0; i < nVals; ++i) {
                        g += vals[i] * scale * etas[ids[i]];
                    }
                    this._gradient[numOff + cid] = g;
                    continue;
                }
                if (c.isSparseNA()) {
                    off = this._dinfo._normSub == null ? 0.0 : this._dinfo._normSub[cid];
                    double g = 0.0;
                    int nVals = c.getSparseDoubles(vals, ids, NA);
                    for (int i = 0; i < nVals; ++i) {
                        g += (vals[i] - off) * scale * etas[ids[i]];
                    }
                    this._gradient[numOff + cid] = g;
                    continue;
                }
                off = this._dinfo._normSub == null ? 0.0 : this._dinfo._normSub[cid];
                c.getDoubles(vals, 0, vals.length, NA);
                double g = 0.0;
                for (int i = 0; i < vals.length; ++i) {
                    g += (vals[i] - off) * scale * etas[i];
                }
                this._gradient[numOff + cid] = g;
            }
        }

        public void map(Chunk[] chks) {
            this._gradient = MemoryManager.malloc8d((int)this._beta.length);
            Chunk response = chks[chks.length - 1];
            C0DChunk weights = this._dinfo._weights ? chks[this._dinfo.weightChunkId()] : new C0DChunk(1.0, response._len);
            double[] ws = weights.getDoubles(MemoryManager.malloc8d((int)weights._len), 0, weights._len);
            double[] ys = response.getDoubles(MemoryManager.malloc8d((int)weights._len), 0, response._len);
            double[] etas = MemoryManager.malloc8d((int)response._len);
            if (this._dinfo._offset) {
                chks[this._dinfo.offsetChunkId()].getDoubles(etas, 0, etas.length);
            }
            double sparseOffset = 0.0;
            int numStart = this._dinfo.numStart();
            if (this._dinfo._normSub != null) {
                for (int i = 0; i < this._dinfo._nums; ++i) {
                    if (!chks[this._dinfo._cats + i].isSparseZero()) continue;
                    sparseOffset -= this._beta[numStart + i] * this._dinfo._normSub[i] * this._dinfo._normMul[i];
                }
            }
            ArrayUtils.add((double[])etas, (double)(sparseOffset + this._beta[this._beta.length - 1]));
            double[] vals = MemoryManager.malloc8d((int)response._len);
            int[] ids = MemoryManager.malloc4((int)response._len);
            this.computeCategoricalEtas(chks, etas, vals, ids);
            this.computeNumericEtas(chks, etas, vals, ids);
            this.computeGradientMultipliers(etas, ys, ws);
            this.computeCategoricalGrads(chks, etas, vals, ids);
            this.computeNumericGrads(chks, etas, vals, ids);
            this._gradient[this._gradient.length - 1] = ArrayUtils.sum((double[])etas);
            if (this._dinfo._normSub != null) {
                double icpt = this._gradient[this._gradient.length - 1];
                for (int i = 0; i < this._dinfo._nums; ++i) {
                    if (!chks[this._dinfo._cats + i].isSparseZero()) continue;
                    double d = this._dinfo._normSub[i] * this._dinfo._normMul[i];
                    int n = numStart + i;
                    this._gradient[n] = this._gradient[n] - d * icpt;
                }
            }
        }

        public final void reduce(GLMGradientTask gmgt) {
            ArrayUtils.add((double[])this._gradient, (double[])gmgt._gradient);
            this._likelihood += gmgt._likelihood;
        }

        public final void postGlobal() {
            ArrayUtils.mult((double[])this._gradient, (double)this._reg);
            for (int j = 0; j < this._beta.length - 1; ++j) {
                int n = j;
                this._gradient[n] = this._gradient[n] + this._currentLambda * this._beta[j];
            }
        }
    }

    static class GLMBinomialWeightsTask
    extends FrameTask2<GLMGenericWeightsTask> {
        final double[] _beta;
        double _sparseOffset;
        double _likelihood;

        public GLMBinomialWeightsTask(H2O.H2OCountedCompleter cmp, DataInfo dinfo, Key jobKey, double[] beta) {
            super(cmp, dinfo, (Key<Job>)jobKey);
            this._beta = beta;
        }

        @Override
        public void chunkInit() {
            if (this._sparse) {
                this._sparseOffset = GLM.sparseOffset(this._beta, this._dinfo);
            }
        }

        @Override
        protected void processRow(DataInfo.Row row) {
            double y = row.response(0);
            double eta = row.innerProduct(this._beta) + this._sparseOffset;
            double mu = 1.0 / (Math.exp(-eta) + 1.0);
            if (mu < 1.0E-16) {
                mu = 1.0E-16;
            }
            double d = mu * (1.0 - mu);
            row.setOutput(0, row.weight * d);
            row.setOutput(1, eta + (y - mu) / d);
            this._likelihood += row.weight * (MathUtils.y_log_y((double)y, (double)mu) + MathUtils.y_log_y((double)(1.0 - y), (double)(1.0 - mu)));
        }

        public void reduce(GLMGenericWeightsTask gwt) {
            this._likelihood += gwt._likelihood;
        }
    }

    static class GLMMultinomialWeightsTask
    extends FrameTask2<GLMGenericWeightsTask> {
        final double[] _beta;
        double _sparseOffset;
        double _likelihood;
        final int classId;

        public GLMMultinomialWeightsTask(H2O.H2OCountedCompleter cmp, DataInfo dinfo, Key jobKey, double[] beta, int cid) {
            super(cmp, dinfo, (Key<Job>)jobKey);
            this._beta = beta;
            this.classId = cid;
        }

        @Override
        public void chunkInit() {
            if (this._sparse) {
                this._sparseOffset = GLM.sparseOffset(this._beta, this._dinfo);
            }
        }

        @Override
        protected void processRow(DataInfo.Row row) {
            double sumExp;
            double etaExp;
            double mu;
            double y = row.response(0);
            double maxRow = row.getOutput(2);
            double etaY = row.getOutput(3);
            double eta = row.innerProduct(this._beta) + this._sparseOffset;
            if ((double)this.classId == y) {
                etaY = eta;
                row.setOutput(3, eta);
            }
            if (eta > maxRow) {
                maxRow = eta;
                row.setOutput(2, eta);
            }
            if ((mu = (etaExp = Math.exp(eta - maxRow)) / (sumExp = row.getOutput(4) + etaExp)) < 1.0E-16) {
                mu = 1.0E-16;
            }
            double d = mu * (1.0 - mu);
            row.setOutput(0, row.weight * d);
            row.setOutput(1, eta + (y - mu) / d);
            this._likelihood += row.weight * (etaY - Math.log(sumExp) - maxRow);
        }

        public void reduce(GLMGenericWeightsTask gwt) {
            this._likelihood += gwt._likelihood;
        }
    }

    static class GLMGenericWeightsTask
    extends FrameTask2<GLMGenericWeightsTask> {
        final double[] _beta;
        double _sparseOffset;
        private final GLMModel.GLMWeightsFun _glmw;
        private transient GLMModel.GLMWeights _ws;
        double _likelihood;

        public GLMGenericWeightsTask(H2O.H2OCountedCompleter cmp, DataInfo dinfo, Key jobKey, double[] beta, GLMModel.GLMWeightsFun glmw) {
            super(cmp, dinfo, (Key<Job>)jobKey);
            this._beta = beta;
            this._glmw = glmw;
            assert (this._glmw._family != GLMModel.GLMParameters.Family.multinomial) : "Generic glm weights task does not work for family multinomial";
        }

        @Override
        public void chunkInit() {
            this._ws = new GLMModel.GLMWeights();
            if (this._sparse) {
                this._sparseOffset = GLM.sparseOffset(this._beta, this._dinfo);
            }
        }

        @Override
        protected void processRow(DataInfo.Row row) {
            double eta = row.innerProduct(this._beta) + this._sparseOffset;
            this._glmw.computeWeights(row.response(0), eta, row.offset, row.weight, this._ws);
            row.setOutput(0, this._ws.w);
            row.setOutput(1, this._ws.z);
            this._likelihood += this._ws.l;
        }

        public void reduce(GLMGenericWeightsTask gwt) {
            this._likelihood += gwt._likelihood;
        }
    }

    public static class YMUTask
    extends MRTask<YMUTask> {
        double _yMin = Double.POSITIVE_INFINITY;
        double _yMax = Double.NEGATIVE_INFINITY;
        final int _responseId;
        final int _weightId;
        final int _offsetId;
        final int _nums;
        final int _numOff;
        final boolean _skipNAs;
        final boolean _computeWeightedMeanSigmaResponse;
        private MathUtils.BasicStats _basicStats;
        private MathUtils.BasicStats _basicStatsResponse;
        double[] _yMu;
        final int _nClasses;
        private double[] _predictorSDs;
        private final boolean _expandedResponse;

        public double[] predictorMeans() {
            return this._basicStats.mean();
        }

        public double[] predictorSDs() {
            if (this._predictorSDs != null) {
                return this._predictorSDs;
            }
            this._predictorSDs = this._basicStats.sigma();
            return this._predictorSDs;
        }

        public double[] responseMeans() {
            return this._basicStatsResponse.mean();
        }

        public double[] responseSDs() {
            return this._basicStatsResponse.sigma();
        }

        public YMUTask(DataInfo dinfo, int nclasses, boolean computeWeightedMeanSigmaResponse, boolean skipNAs, boolean haveResponse, boolean expandedResponse) {
            this._nums = dinfo._nums;
            this._numOff = dinfo._cats;
            this._responseId = haveResponse ? dinfo.responseChunkId(0) : -1;
            this._weightId = dinfo._weights ? dinfo.weightChunkId() : -1;
            this._offsetId = dinfo._offset ? dinfo.offsetChunkId() : -1;
            this._nClasses = nclasses;
            this._computeWeightedMeanSigmaResponse = computeWeightedMeanSigmaResponse;
            this._skipNAs = skipNAs;
            this._expandedResponse = this._nClasses == 1 || expandedResponse;
        }

        public void setupLocal() {
        }

        public void map(Chunk[] chunks) {
            int i;
            this._yMu = new double[this._nClasses];
            double[] ws = MemoryManager.malloc8d((int)chunks[0].len());
            if (this._weightId != -1) {
                chunks[this._weightId].getDoubles(ws, 0, ws.length);
            } else {
                Arrays.fill(ws, 1.0);
            }
            boolean changedWeights = false;
            if (this._skipNAs) {
                double[] vals = MemoryManager.malloc8d((int)chunks[0]._len);
                int[] ids = MemoryManager.malloc4((int)vals.length);
                for (i = 0; i < chunks.length; ++i) {
                    int n = vals.length;
                    if (chunks[i].isSparseZero()) {
                        n = chunks[i].getSparseDoubles(vals, ids);
                    } else {
                        chunks[i].getDoubles(vals, 0, n);
                    }
                    for (int r = 0; r < n; ++r) {
                        if (ws[r] == 0.0 || !Double.isNaN(vals[r])) continue;
                        ws[r] = 0.0;
                        changedWeights = true;
                    }
                }
                if (changedWeights && this._weightId != -1) {
                    chunks[this._weightId].set(ws);
                }
            }
            Chunk response = this._responseId < 0 ? null : chunks[this._responseId];
            double[] numsResponse = null;
            this._basicStats = new MathUtils.BasicStats(this._nums);
            if (this._computeWeightedMeanSigmaResponse) {
                this._basicStatsResponse = new MathUtils.BasicStats(this._nClasses);
                numsResponse = MemoryManager.malloc8d((int)this._nClasses);
            }
            for (i = 0; i < this._nums; ++i) {
                Chunk c = chunks[i + this._numOff];
                int r = c.nextNZ(-1);
                while (r < c._len) {
                    double w = ws[r];
                    if (w != 0.0) {
                        double d = c.atd(r);
                        this._basicStats.add(d, w, i);
                    }
                    r = c.nextNZ(r);
                }
            }
            if (response == null) {
                return;
            }
            long nobs = 0L;
            double wsum = 0.0;
            for (double w : ws) {
                if (w != 0.0) {
                    ++nobs;
                }
                wsum += w;
            }
            this._basicStats.setNobs(nobs, wsum);
            for (int r = 0; r < response._len; ++r) {
                double d;
                double w = ws[r];
                if (w == 0.0) continue;
                if (this._computeWeightedMeanSigmaResponse) {
                    if (this._expandedResponse) {
                        for (int i2 = 0; i2 < this._nClasses; ++i2) {
                            numsResponse[i2] = chunks[chunks.length - this._nClasses + i2].atd(r);
                        }
                    } else {
                        Arrays.fill(numsResponse, 0.0);
                        d = response.atd(r);
                        if (Double.isNaN(d)) {
                            Arrays.fill(numsResponse, Double.NaN);
                        } else {
                            numsResponse[(int)d] = 1.0;
                        }
                    }
                    this._basicStatsResponse.add(numsResponse, w);
                }
                if (Double.isNaN(d = response.atd(r))) continue;
                if (this._nClasses > 2) {
                    int n = (int)d;
                    this._yMu[n] = this._yMu[n] + w;
                } else {
                    this._yMu[0] = this._yMu[0] + w * d;
                }
                if (d < this._yMin) {
                    this._yMin = d;
                }
                if (!(d > this._yMax)) continue;
                this._yMax = d;
            }
            if (this._basicStatsResponse != null) {
                this._basicStatsResponse.setNobs(nobs, wsum);
            }
            for (int i3 = 0; i3 < this._nums; ++i3) {
                if (chunks[i3 + this._numOff].isSparseZero()) {
                    this._basicStats.fillSparseZeros(i3);
                    continue;
                }
                if (!chunks[i3 + this._numOff].isSparseNA()) continue;
                this._basicStats.fillSparseNAs(i3);
            }
        }

        public void postGlobal() {
            ArrayUtils.mult((double[])this._yMu, (double)(1.0 / this._basicStats._wsum));
        }

        public void reduce(YMUTask ymt) {
            if (ymt._basicStats.nobs() > 0L && ymt._basicStats.nobs() > 0L) {
                ArrayUtils.add((double[])this._yMu, (double[])ymt._yMu);
                if (this._yMin > ymt._yMin) {
                    this._yMin = ymt._yMin;
                }
                if (this._yMax < ymt._yMax) {
                    this._yMax = ymt._yMax;
                }
                this._basicStats.reduce(ymt._basicStats);
                if (this._computeWeightedMeanSigmaResponse) {
                    this._basicStatsResponse.reduce(ymt._basicStatsResponse);
                }
            } else if (this._basicStats.nobs() == 0L) {
                this._yMu = ymt._yMu;
                this._yMin = ymt._yMin;
                this._yMax = ymt._yMax;
                this._basicStats = ymt._basicStats;
                this._basicStatsResponse = ymt._basicStatsResponse;
            }
        }

        public double wsum() {
            return this._basicStats._wsum;
        }

        public long nobs() {
            return this._basicStats.nobs();
        }
    }

    static class WeightedSDTask
    extends MRTask<WeightedSDTask> {
        final int _weightId;
        final double[] _mean;
        public double[] _varSum;

        public WeightedSDTask(int wId, double[] mean) {
            this._weightId = wId;
            this._mean = mean;
        }

        public void map(Chunk[] chks) {
            double[] weights = null;
            if (this._weightId != -1) {
                weights = MemoryManager.malloc8d((int)chks[this._weightId]._len);
                chks[this._weightId].getDoubles(weights, 0, weights.length);
                chks = (Chunk[])ArrayUtils.remove((Object[])chks, (int)this._weightId);
            }
            this._varSum = MemoryManager.malloc8d((int)this._mean.length);
            double[] vals = MemoryManager.malloc8d((int)chks[0]._len);
            int[] ids = MemoryManager.malloc4((int)chks[0]._len);
            for (int c = 0; c < this._mean.length; ++c) {
                double mu = this._mean[c];
                int n = chks[c].getSparseDoubles(vals, ids);
                double s = 0.0;
                for (int i = 0; i < n; ++i) {
                    double d = vals[i];
                    if (Double.isNaN(d)) continue;
                    d -= mu;
                    if (this._weightId != -1) {
                        s += weights[ids[i]] * d * d;
                        continue;
                    }
                    s += d * d;
                }
                this._varSum[c] = s;
            }
        }

        public void reduce(WeightedSDTask t) {
            ArrayUtils.add((double[])this._varSum, (double[])t._varSum);
        }
    }

    static class GLMResDevTaskMultinomial
    extends FrameTask2<GLMResDevTaskMultinomial> {
        final double[][] _beta;
        double _likelihood;
        final int _nclasses;
        long _nobs;
        private transient double[] _sparseOffsets;

        public GLMResDevTaskMultinomial(Key jobKey, DataInfo dinfo, double[] beta, int nclasses) {
            super(null, dinfo, (Key<Job>)jobKey);
            this._beta = ArrayUtils.convertTo2DMatrix((double[])beta, (int)(beta.length / nclasses));
            this._nclasses = nclasses;
        }

        @Override
        public boolean handlesSparseData() {
            return true;
        }

        @Override
        public void chunkInit() {
            this._sparseOffsets = MemoryManager.malloc8d((int)this._nclasses);
            if (this._sparse) {
                for (int c = 0; c < this._nclasses; ++c) {
                    this._sparseOffsets[c] = GLM.sparseOffset(this._beta[c], this._dinfo);
                }
            }
        }

        @Override
        protected void processRow(DataInfo.Row r) {
            int c;
            ++this._nobs;
            double sumExp = 0.0;
            for (c = 0; c < this._nclasses; ++c) {
                sumExp += Math.exp(r.innerProduct(this._beta[c]) + this._sparseOffsets[c]);
            }
            c = (int)r.response(0);
            this._likelihood -= r.weight * (r.innerProduct(this._beta[c]) + this._sparseOffsets[c] - Math.log(sumExp));
        }

        public void reduce(GLMResDevTaskMultinomial gt) {
            this._nobs += gt._nobs;
            this._likelihood += gt._likelihood;
        }

        public double avgDev() {
            return this._likelihood * 2.0 / (double)this._nobs;
        }

        public double dev() {
            return this._likelihood * 2.0;
        }
    }

    static class GLMResDevTaskOrdinal
    extends FrameTask2<GLMResDevTaskOrdinal> {
        final double[][] _beta;
        double _likelihood;
        final int _nclasses;
        final int _lastClass;
        final int _secondToLast;
        long _nobs;
        private transient double[] _sparseOffsets;

        public GLMResDevTaskOrdinal(Key jobKey, DataInfo dinfo, double[] beta, int nclasses) {
            super(null, dinfo, (Key<Job>)jobKey);
            this._beta = ArrayUtils.convertTo2DMatrix((double[])beta, (int)(beta.length / nclasses));
            this._nclasses = nclasses;
            this._lastClass = nclasses - 1;
            this._secondToLast = this._lastClass - 1;
        }

        @Override
        public boolean handlesSparseData() {
            return true;
        }

        @Override
        public void chunkInit() {
            this._sparseOffsets = MemoryManager.malloc8d((int)this._nclasses);
            if (this._sparse) {
                for (int c = 0; c < this._nclasses; ++c) {
                    this._sparseOffsets[c] = GLM.sparseOffset(this._beta[c], this._dinfo);
                }
            }
        }

        @Override
        protected void processRow(DataInfo.Row r) {
            ++this._nobs;
            int c = (int)r.response(0);
            if (c == 0) {
                double eta = r.innerProduct(this._beta[0]) + this._sparseOffsets[c];
                this._likelihood -= r.weight * (eta - Math.log(1.0 + Math.exp(eta)));
            } else if (c == this._lastClass) {
                this._likelihood += r.weight * Math.log(1.0 + Math.exp(r.innerProduct(this._beta[this._secondToLast]) + this._sparseOffsets[c]));
            } else {
                double eta = Math.exp(r.innerProduct(this._beta[c]) + this._sparseOffsets[c]);
                double etaM1 = Math.exp(r.innerProduct(this._beta[c]) + this._sparseOffsets[c - 1]);
                this._likelihood -= r.weight * Math.log(eta / (1.0 + eta) - etaM1 / (1.0 + etaM1));
            }
        }

        public void reduce(GLMResDevTaskOrdinal gt) {
            this._nobs += gt._nobs;
            this._likelihood += gt._likelihood;
        }

        public double avgDev() {
            return this._likelihood * 2.0 / (double)this._nobs;
        }

        public double dev() {
            return this._likelihood * 2.0;
        }
    }

    static class GLMResDevTask
    extends FrameTask2<GLMResDevTask> {
        final GLMModel.GLMWeightsFun _glmf;
        final double[] _beta;
        double _resDev = 0.0;
        long _nobs;
        double _likelihood;
        private transient GLMModel.GLMWeights _glmw;
        private final double _sparseOffset;

        public GLMResDevTask(Key jobKey, DataInfo dinfo, GLMModel.GLMParameters parms, double[] beta) {
            super(null, dinfo, (Key<Job>)jobKey);
            this._glmf = new GLMModel.GLMWeightsFun(parms);
            this._beta = beta;
            this._sparseOffset = this._sparse ? GLM.sparseOffset(this._beta, this._dinfo) : 0.0;
        }

        @Override
        public boolean handlesSparseData() {
            return true;
        }

        @Override
        public void chunkInit() {
            this._glmw = new GLMModel.GLMWeights();
        }

        @Override
        protected void processRow(DataInfo.Row r) {
            this._glmf.computeWeights(r.response(0), r.innerProduct(this._beta) + this._sparseOffset, r.offset, r.weight, this._glmw);
            this._resDev += this._glmw.dev;
            this._likelihood += this._glmw.l;
            ++this._nobs;
        }

        public void reduce(GLMResDevTask gt) {
            this._nobs += gt._nobs;
            this._resDev += gt._resDev;
            this._likelihood += gt._likelihood;
        }

        public double avgDev() {
            return this._resDev / (double)this._nobs;
        }

        public double dev() {
            return this._resDev;
        }
    }

    static class NullDevTask
    extends MRTask<NullDevTask> {
        double _nullDev;
        final double[] _ymu;
        final GLMModel.GLMWeightsFun _glmf;
        final boolean _hasWeights;
        final boolean _hasOffset;

        public NullDevTask(GLMModel.GLMWeightsFun glmf, double[] ymu, boolean hasWeights, boolean hasOffset) {
            this._glmf = glmf;
            this._ymu = ymu;
            this._hasWeights = hasWeights;
            this._hasOffset = hasOffset;
        }

        public void map(Chunk[] chks) {
            int i = 0;
            int len = chks[0]._len;
            C0DChunk w = this._hasWeights ? chks[i++] : new C0DChunk(1.0, len);
            C0DChunk o = this._hasOffset ? chks[i++] : new C0DChunk(0.0, len);
            Chunk r = chks[i];
            if (this._glmf._family != GLMModel.GLMParameters.Family.multinomial) {
                double ymu = this._glmf.link(this._ymu[0]);
                for (int j = 0; j < len; ++j) {
                    this._nullDev += w.atd(j) * this._glmf.deviance(r.atd(j), this._glmf.linkInv(ymu + o.atd(j)));
                }
            } else {
                throw H2O.unimpl();
            }
        }

        public void reduce(NullDevTask ndt) {
            this._nullDev += ndt._nullDev;
        }
    }
}

