/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.isofor;

import hex.ModelBuilder;
import hex.ModelCategory;
import hex.ScoreKeeper;
import hex.genmodel.utils.DistributionFamily;
import hex.tree.DHistogram;
import hex.tree.DTree;
import hex.tree.Sample;
import hex.tree.ScoreBuildHistogram;
import hex.tree.SharedTree;
import hex.tree.SharedTreeModel;
import hex.tree.isofor.IsolationForestModel;
import java.util.ArrayList;
import java.util.Collections;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import water.Job;
import water.Key;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.PrettyPrint;
import water.util.RandomUtils;
import water.util.TwoDimTable;

public class IsolationForest
extends SharedTree<IsolationForestModel, IsolationForestModel.IsolationForestParameters, IsolationForestModel.IsolationForestOutput> {
    public ModelCategory[] can_build() {
        return new ModelCategory[]{ModelCategory.AnomalyDetection};
    }

    public ModelBuilder.BuilderVisibility builderVisibility() {
        return ModelBuilder.BuilderVisibility.Beta;
    }

    public IsolationForest(IsolationForestModel.IsolationForestParameters parms) {
        super(parms);
        this.init(false);
    }

    public IsolationForest(IsolationForestModel.IsolationForestParameters parms, Key<IsolationForestModel> key) {
        super(parms, key);
        this.init(false);
    }

    public IsolationForest(IsolationForestModel.IsolationForestParameters parms, Job job) {
        super(parms, job);
        this.init(false);
    }

    public IsolationForest(boolean startup_once) {
        super(new IsolationForestModel.IsolationForestParameters(), startup_once);
    }

    protected SharedTree.Driver trainModelImpl() {
        return new IsolationForestDriver();
    }

    @Override
    public boolean scoreZeroTrees() {
        return false;
    }

    @Override
    public boolean isSupervised() {
        return false;
    }

    @Override
    public void init(boolean expensive) {
        super.init(expensive);
        if (((IsolationForestModel.IsolationForestParameters)this._parms)._mtries < 1 && ((IsolationForestModel.IsolationForestParameters)this._parms)._mtries != -1 && ((IsolationForestModel.IsolationForestParameters)this._parms)._mtries != -2) {
            this.error("_mtries", "mtries must be -1 (converted to sqrt(features)) or -2 (All features) or >= 1 but it is " + ((IsolationForestModel.IsolationForestParameters)this._parms)._mtries);
        }
        if (this._train != null) {
            int ncols = this._train.numCols();
            if (((IsolationForestModel.IsolationForestParameters)this._parms)._mtries != -1 && ((IsolationForestModel.IsolationForestParameters)this._parms)._mtries != -2 && (1 > ((IsolationForestModel.IsolationForestParameters)this._parms)._mtries || ((IsolationForestModel.IsolationForestParameters)this._parms)._mtries >= ncols)) {
                this.error("_mtries", "Computed mtries should be -1 or -2 or in interval [1," + ncols + "[ but it is " + ((IsolationForestModel.IsolationForestParameters)this._parms)._mtries);
            }
        }
        if (((IsolationForestModel.IsolationForestParameters)this._parms)._distribution != DistributionFamily.AUTO && ((IsolationForestModel.IsolationForestParameters)this._parms)._distribution != DistributionFamily.gaussian) {
            throw new IllegalStateException("Isolation Forest doesn't expect the distribution to be specified by the user");
        }
        ((IsolationForestModel.IsolationForestParameters)this._parms)._distribution = DistributionFamily.gaussian;
    }

    @Override
    protected void validateRowSampleRate() {
        if (((IsolationForestModel.IsolationForestParameters)this._parms)._sample_rate == -1.0) {
            if (((IsolationForestModel.IsolationForestParameters)this._parms)._sample_size <= 0L) {
                this.error("_sample_size", "Sample size needs to be a positive integer number but it is " + ((IsolationForestModel.IsolationForestParameters)this._parms)._sample_size);
            } else if (this._train != null && this._train.numRows() > 0L) {
                ((IsolationForestModel.IsolationForestParameters)this._parms)._sample_rate = (double)((IsolationForestModel.IsolationForestParameters)this._parms)._sample_size / (double)this._train.numRows();
            }
        }
    }

    private void randomResp(final long seed, final int iteration) {
        new MRTask(){

            public void map(Chunk[] chks) {
                Chunk c = IsolationForest.this.chk_work(chks, 0);
                long chunk_seed = seed + c.start() * (long)(1 + iteration);
                for (int i = 0; i < c._len; ++i) {
                    double rnd = RandomUtils.getRNG((long[])new long[]{chunk_seed + (long)i}).nextDouble();
                    IsolationForest.this.chk_work(chks, 0).set(i, rnd);
                }
            }
        }.doAll(this._train);
    }

    @Override
    protected DTree.DecidedNode makeDecided(DTree.UndecidedNode udn, DHistogram[] hs) {
        return new IFDecidedNode(udn, hs);
    }

    @Override
    protected double score1(Chunk[] chks, double weight, double offset, double[] fs, int row) {
        assert (weight == 1.0);
        double len = this.chk_tree(chks, 0).atd(row);
        if (len < 0.0) {
            fs[0] = -1.0;
            fs[1] = 0.0;
            return fs[0];
        }
        fs[0] = ((IsolationForestModel)this._model).normalizePathLength(len);
        fs[1] = len / this.chk_oobt(chks).atd(row);
        return fs[0];
    }

    @Override
    protected TwoDimTable createScoringHistoryTable() {
        ArrayList<String> colHeaders = new ArrayList<String>();
        ArrayList<String> colTypes = new ArrayList<String>();
        ArrayList<String> colFormat = new ArrayList<String>();
        colHeaders.add("Timestamp");
        colTypes.add("string");
        colFormat.add("%s");
        colHeaders.add("Duration");
        colTypes.add("string");
        colFormat.add("%s");
        colHeaders.add("Number of Trees");
        colTypes.add("long");
        colFormat.add("%d");
        colHeaders.add("Mean Tree Path Length");
        colTypes.add("double");
        colFormat.add("%.5f");
        colHeaders.add("Mean Anomaly Score");
        colTypes.add("double");
        colFormat.add("%.5f");
        if (((IsolationForestModel.IsolationForestParameters)this._parms)._custom_metric_func != null) {
            colHeaders.add("Training Custom");
            colTypes.add("double");
            colFormat.add("%.5f");
        }
        ScoreKeeper[] sks = ((IsolationForestModel.IsolationForestOutput)((IsolationForestModel)this._model)._output)._scored_train;
        int rows = 0;
        for (int i = 0; i < sks.length; ++i) {
            if (i != 0 && Double.isNaN(sks[i]._anomaly_score)) continue;
            ++rows;
        }
        TwoDimTable table = new TwoDimTable("Scoring History", null, new String[rows], colHeaders.toArray(new String[0]), colTypes.toArray(new String[0]), colFormat.toArray(new String[0]), "");
        int row = 0;
        for (int i = 0; i < sks.length; ++i) {
            if (i != 0 && Double.isNaN(sks[i]._anomaly_score)) continue;
            int col = 0;
            DateTimeFormatter fmt = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
            table.set(row, col++, (Object)fmt.print(((IsolationForestModel.IsolationForestOutput)((IsolationForestModel)this._model)._output)._training_time_ms[i]));
            table.set(row, col++, (Object)PrettyPrint.msecs((long)(((IsolationForestModel.IsolationForestOutput)((IsolationForestModel)this._model)._output)._training_time_ms[i] - this._job.start_time()), (boolean)true));
            table.set(row, col++, (Object)i);
            ScoreKeeper st = sks[i];
            table.set(row, col++, (Object)st._anomaly_score);
            table.set(row, col++, (Object)st._anomaly_score_normalized);
            if (((IsolationForestModel.IsolationForestParameters)this._parms)._custom_metric_func != null) {
                table.set(row, col++, (Object)st._custom_metric);
            }
            assert (col == colHeaders.size());
            ++row;
        }
        return table;
    }

    @Override
    public boolean havePojo() {
        return false;
    }

    @Override
    public boolean haveMojo() {
        return true;
    }

    private class IsolationForestDriver
    extends SharedTree.Driver {
        private IsolationForestDriver() {
            super(IsolationForest.this);
        }

        @Override
        protected boolean doOOBScoring() {
            return false;
        }

        @Override
        protected void initializeModelSpecifics() {
            IsolationForest.this._mtry_per_tree = Math.max(1, (int)(((IsolationForestModel.IsolationForestParameters)IsolationForest.this._parms)._col_sample_rate_per_tree * (double)IsolationForest.this._ncols));
            if (1 > IsolationForest.this._mtry_per_tree || IsolationForest.this._mtry_per_tree > IsolationForest.this._ncols) {
                throw new IllegalArgumentException("Computed mtry_per_tree should be in interval <1," + IsolationForest.this._ncols + "> but it is " + IsolationForest.this._mtry_per_tree);
            }
            if (((IsolationForestModel.IsolationForestParameters)IsolationForest.this._parms)._mtries == -2) {
                IsolationForest.this._mtry = IsolationForest.this._ncols;
            } else if (((IsolationForestModel.IsolationForestParameters)IsolationForest.this._parms)._mtries == -1) {
                IsolationForest.this._mtry = IsolationForest.this.isClassifier() ? Math.max((int)Math.sqrt(IsolationForest.this._ncols), 1) : Math.max(IsolationForest.this._ncols / 3, 1);
            } else {
                IsolationForest.this._mtry = ((IsolationForestModel.IsolationForestParameters)IsolationForest.this._parms)._mtries;
            }
            if (1 > IsolationForest.this._mtry || IsolationForest.this._mtry > IsolationForest.this._ncols) {
                throw new IllegalArgumentException("Computed mtry should be in interval <1," + IsolationForest.this._ncols + "> but it is " + IsolationForest.this._mtry);
            }
            IsolationForest.this._initialPrediction = 0.0;
        }

        @Override
        protected boolean buildNextKTrees() {
            IsolationForest.this.randomResp(((IsolationForestModel.IsolationForestParameters)IsolationForest.this._parms)._seed, ((IsolationForestModel.IsolationForestOutput)((IsolationForestModel)((IsolationForest)IsolationForest.this)._model)._output)._ntrees);
            long rseed = IsolationForest.this._rand.nextLong();
            DTree tree = new DTree(IsolationForest.this._train, IsolationForest.this._ncols, IsolationForest.this._mtry, IsolationForest.this._mtry_per_tree, rseed, (SharedTreeModel.SharedTreeParameters)IsolationForest.this._parms);
            DTree[] ktrees = new DTree[]{tree};
            ((Sample)new Sample(tree, ((IsolationForestModel.IsolationForestParameters)IsolationForest.this._parms)._sample_rate, null).dfork(null, new Frame(new Vec[]{IsolationForest.this.vec_nids(IsolationForest.this._train, 0), IsolationForest.this.vec_work(IsolationForest.this._train, 0)}), ((IsolationForestModel.IsolationForestParameters)IsolationForest.this._parms)._build_tree_one_node)).getResult();
            this.growTree(rseed, ktrees);
            CalculatePaths stats = (CalculatePaths)new CalculatePaths(ktrees[0]).doAll(IsolationForest.this._train, ((IsolationForestModel.IsolationForestParameters)IsolationForest.this._parms)._build_tree_one_node);
            ((IsolationForestModel.IsolationForestOutput)((IsolationForestModel)((IsolationForest)IsolationForest.this)._model)._output).addKTrees(ktrees);
            ((IsolationForestModel.IsolationForestOutput)((IsolationForestModel)((IsolationForest)IsolationForest.this)._model)._output)._min_path_length = stats._minPathLength;
            ((IsolationForestModel.IsolationForestOutput)((IsolationForestModel)((IsolationForest)IsolationForest.this)._model)._output)._max_path_length = stats._maxPathLength;
            return false;
        }

        private void growTree(long rseed, DTree[] ktrees) {
            DHistogram[][][] hcs = new DHistogram[IsolationForest.this._nclass][1][IsolationForest.this._ncols];
            int adj_nbins = Math.max(((IsolationForestModel.IsolationForestParameters)IsolationForest.this._parms)._nbins_top_level, ((IsolationForestModel.IsolationForestParameters)IsolationForest.this._parms)._nbins);
            DTree tree = ktrees[0];
            new DTree.UndecidedNode(tree, -1, DHistogram.initialHist(IsolationForest.this._train, IsolationForest.this._ncols, adj_nbins, hcs[0][0], rseed, (SharedTreeModel.SharedTreeParameters)IsolationForest.this._parms, this.getGlobalQuantilesKeys()));
            int[] leafs = new int[1];
            for (int depth = 0; depth < ((IsolationForestModel.IsolationForestParameters)IsolationForest.this._parms)._max_depth && (hcs = IsolationForest.this.buildLayer(IsolationForest.this._train, ((IsolationForestModel.IsolationForestParameters)IsolationForest.this._parms)._nbins, ((IsolationForestModel.IsolationForestParameters)IsolationForest.this._parms)._nbins_cats, ktrees, leafs, hcs, ((IsolationForestModel.IsolationForestParameters)IsolationForest.this._parms)._build_tree_one_node)) != null; ++depth) {
            }
            int leaf = tree.len();
            int[] depths = new int[leaf];
            for (int nid = 0; nid < leaf; ++nid) {
                if (!(tree.node(nid) instanceof DTree.DecidedNode)) continue;
                DTree.DecidedNode dn = tree.decided(nid);
                if (dn._split == null) {
                    if (nid != 0) continue;
                    DTree.LeafNode ln = new DTree.LeafNode(tree, -1, 0);
                    ln._pred = 0.0f;
                    continue;
                }
                depths[nid] = dn._pid >= 0 ? depths[dn._pid] + 1 : 0;
                for (int i = 0; i < dn._nids.length; ++i) {
                    int cnid = dn._nids[i];
                    if (cnid != -1 && !(tree.node(cnid) instanceof DTree.UndecidedNode) && (!(tree.node(cnid) instanceof DTree.DecidedNode) || ((DTree.DecidedNode)tree.node((int)cnid))._split != null)) continue;
                    DTree.LeafNode ln = new DTree.LeafNode(tree, nid);
                    ln._pred = depths[nid];
                    dn._nids[i] = ln.nid();
                }
            }
        }

        protected IsolationForestModel makeModel(Key modelKey, IsolationForestModel.IsolationForestParameters parms) {
            return new IsolationForestModel((Key<IsolationForestModel>)modelKey, parms, new IsolationForestModel.IsolationForestOutput(IsolationForest.this));
        }

        private class CalculatePaths
        extends MRTask<CalculatePaths> {
            private final DTree _tree;
            private final int _ntrees;
            private long _minPathLength = Long.MAX_VALUE;
            private long _maxPathLength = 0L;

            private CalculatePaths(DTree tree) {
                this._tree = tree;
                this._ntrees = ((IsolationForestModel.IsolationForestOutput)((IsolationForestModel)((IsolationForest)IsolationForest.this)._model)._output)._ntrees;
            }

            public void map(Chunk[] chks) {
                Chunk tree = IsolationForest.this.chk_tree(chks, 0);
                Chunk nids = IsolationForest.this.chk_nids(chks, 0);
                Chunk oobt = IsolationForest.this.chk_oobt(chks);
                for (int row = 0; row < nids._len; ++row) {
                    boolean wasOOBRow = ScoreBuildHistogram.isOOBRow((int)IsolationForest.this.chk_nids(chks, 0).at8(row));
                    if (wasOOBRow) {
                        double oobcnt = oobt.atd(row) + 1.0;
                        int nid = ScoreBuildHistogram.oob2Nid((int)nids.at8(row));
                        int depth = this.getNodeDepth(chks, row, nid);
                        long len = tree.at8(row) + (long)depth;
                        long total_len = (long)((double)(len * (long)this._ntrees) / oobcnt);
                        tree.set(row, len);
                        this._maxPathLength = total_len > this._maxPathLength ? total_len : this._maxPathLength;
                        this._minPathLength = total_len < this._minPathLength ? total_len : this._minPathLength;
                        oobt.set(row, oobcnt);
                    }
                    nids.set(row, 0L);
                }
            }

            public void reduce(CalculatePaths mrt) {
                this._minPathLength = Math.min(this._minPathLength, mrt._minPathLength);
                this._maxPathLength = Math.max(this._maxPathLength, mrt._maxPathLength);
            }

            int getNodeDepth(Chunk[] chks, int row, int nid) {
                if (this._tree.root() instanceof DTree.LeafNode) {
                    return 0;
                }
                if (this._tree.node(nid) instanceof DTree.UndecidedNode) {
                    nid = this._tree.node(nid).pid();
                }
                DTree.DecidedNode dn = this._tree.decided(nid);
                if (dn._split == null) {
                    dn = this._tree.decided(this._tree.node(nid).pid());
                }
                int leafnid = dn.getChildNodeID(chks, row);
                double depth = ((DTree.LeafNode)this._tree.node(leafnid)).pred();
                assert ((double)((int)depth) == depth);
                return (int)depth;
            }
        }
    }

    private class IFDecidedNode
    extends DTree.DecidedNode {
        private IFDecidedNode(DTree.UndecidedNode n, DHistogram[] hs) {
            super(n, hs);
        }

        @Override
        public DTree.Split bestCol(DTree.UndecidedNode u, DHistogram[] hs) {
            if (hs == null) {
                return null;
            }
            int maxCols = u._scoreCols == null ? hs.length : u._scoreCols.length;
            ArrayList<DTree.DecidedNode.FindSplits> findSplits = new ArrayList<DTree.DecidedNode.FindSplits>();
            for (int i = 0; i < maxCols; ++i) {
                int col;
                int n = col = u._scoreCols == null ? i : u._scoreCols[i];
                if (hs[col] == null || hs[col].nbins() <= 1) continue;
                findSplits.add(new DTree.DecidedNode.FindSplits((DTree.DecidedNode)this, hs, col, u));
            }
            Collections.shuffle(findSplits, IsolationForest.this._rand);
            for (DTree.DecidedNode.FindSplits fs : findSplits) {
                DTree.Split s = fs.computeSplit();
                if (s == null) continue;
                return s;
            }
            return null;
        }
    }
}

