/*
 * Decompiled with CFR 0.152.
 */
package hex.deepwater;

import hex.deepwater.DeepWaterIterator;
import hex.deepwater.DeepWaterModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import water.DKV;
import water.Freezable;
import water.Futures;
import water.H2O;
import water.Key;
import water.Value;
import water.fvec.C4FChunk;
import water.util.StringUtils;
import water.util.UnsafeUtils;

class DeepWaterTextIterator
extends DeepWaterIterator {
    private static ConcurrentHashMap<String, Integer> dict;
    private final int _num_obs;
    private final int _wordsPerLine;
    private final ArrayList<String> _txt_list;
    private final ArrayList<Float> _label_lst;

    private static ConcurrentHashMap getDict() {
        if (dict == null) {
            dict = new ConcurrentHashMap();
            int count = 0;
            dict.put(StringUtils.PADDING_SYMBOL, count++);
        }
        return dict;
    }

    DeepWaterTextIterator(ArrayList<String> txt_lst, ArrayList<Float> label_lst, int batch_size, int dictLen, boolean cache) throws IOException {
        super(batch_size, dictLen, cache);
        this._wordsPerLine = dictLen;
        this._start_index = 0;
        this._txt_list = txt_lst;
        this._label_lst = label_lst;
        this._num_obs = txt_lst.size();
    }

    @Override
    public boolean Next(Futures fs) throws IOException {
        if (this._start_index < this._num_obs) {
            if (this._start_index + this._batch_size > this._num_obs) {
                this._start_index = this._num_obs - this._batch_size;
            }
            for (int i = 0; i < this._batch_size; ++i) {
                fs.add((Future)H2O.submitTask((H2O.H2OCountedCompleter)new TextConverter(i, this._start_index + i, this._txt_list.get(this._start_index + i), this._label_lst == null ? Float.NaN : this._label_lst.get(this._start_index + i).floatValue(), this._data[this.which()], this._wordsPerLine, this._label[this.which()], this._cache)));
            }
            fs.blockForPending();
            this.flip();
            this._start_index += this._batch_size;
            return true;
        }
        return false;
    }

    static class TextConverter
    extends H2O.H2OCountedCompleter<TextConverter> {
        String _text;
        float _label;
        float[] _destData;
        int _wordsPerLine;
        float[] _destLabel;
        int _index;
        int _globalId;
        boolean _cache;

        TextConverter(int index, int globalId, String text, float label, float[] destData, int wordsPerLine, float[] destLabel, boolean cache) {
            this._index = index;
            this._globalId = globalId;
            this._text = text;
            this._label = label;
            this._destData = destData;
            this._wordsPerLine = wordsPerLine;
            this._destLabel = destLabel;
            this._cache = cache;
        }

        public synchronized void compute2() {
            int i;
            C4FChunk icedTxt;
            this._destLabel[this._index] = this._label;
            int start = this._index * this._wordsPerLine;
            Key txtKey = Key.make((String)("line_" + this._globalId + DeepWaterModel.CACHE_MARKER));
            boolean status = false;
            if (this._cache && (icedTxt = (C4FChunk)DKV.getGet((Key)txtKey)) != null) {
                for (i = 0; i < icedTxt._len; ++i) {
                    this._destData[start + i] = (float)icedTxt.atd(i);
                }
                status = true;
            }
            if (!status) {
                int[] data = StringUtils.tokensToArray((String[])StringUtils.tokenize((String)this._text), (int)this._wordsPerLine, (Map)DeepWaterTextIterator.getDict());
                for (i = 0; i < this._wordsPerLine; ++i) {
                    this._destData[start + i] = data[i];
                }
                if (this._cache) {
                    byte[] mem = new byte[this._wordsPerLine * 4];
                    for (int i2 = 0; i2 < this._wordsPerLine; ++i2) {
                        UnsafeUtils.set4f((byte[])mem, (int)(i2 << 2), (float)this._destData[start + i2]);
                    }
                    Value v = new Value(txtKey, (Freezable)new C4FChunk(mem));
                    DKV.put((Key)txtKey, (Value)v);
                    v.freeMem();
                }
            }
            this.tryComplete();
        }
    }
}

