/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.KeyValue;
import hex.ModelBuilder;
import java.util.HashSet;
import water.fvec.Frame;
import water.fvec.Vec;

public class TreeUtils {
    public static void checkMonotoneConstraints(ModelBuilder<?, ?, ?> mb, Frame train, KeyValue[] constraints) {
        HashSet<String> constrained = new HashSet<String>();
        for (KeyValue constraint : constraints) {
            if (constrained.contains(constraint.getKey())) {
                mb.error("_monotone_constraints", "Feature '" + constraint.getKey() + "' has multiple constraints.");
                continue;
            }
            constrained.add(constraint.getKey());
            Vec v = train.vec(constraint.getKey());
            if (v == null) {
                mb.error("_monotone_constraints", "Invalid constraint - there is no column '" + constraint.getKey() + "' in the training frame.");
                continue;
            }
            if (v.get_type() == 3) continue;
            mb.error("_monotone_constraints", "Invalid constraint - column '" + constraint.getKey() + "' has type " + v.get_type_str() + ". Only numeric columns can have monotonic constraints.");
        }
    }
}

