/*
 * Decompiled with CFR 0.152.
 */
package hex.api;

import hex.ModelBuilder;
import hex.aggregator.Aggregator;
import hex.api.MakeGLMModelHandler;
import hex.api.Word2VecHandler;
import hex.coxph.CoxPH;
import hex.deeplearning.DeepLearning;
import hex.deepwater.DeepWater;
import hex.ensemble.StackedEnsemble;
import hex.generic.Generic;
import hex.glm.GLM;
import hex.glrm.GLRM;
import hex.kmeans.KMeans;
import hex.naivebayes.NaiveBayes;
import hex.pca.PCA;
import hex.svd.SVD;
import hex.tree.TreeHandler;
import hex.tree.drf.DRF;
import hex.tree.gbm.GBM;
import hex.tree.isofor.IsolationForest;
import hex.word2vec.Word2Vec;
import water.api.AlgoAbstractRegister;
import water.api.RestApiContext;
import water.api.SchemaServer;

public class RegisterAlgos
extends AlgoAbstractRegister {
    public void registerEndPoints(RestApiContext context) {
        ModelBuilder[] algos;
        for (ModelBuilder algo : algos = new ModelBuilder[]{new DeepLearning(true), new GLM(true), new GLRM(true), new KMeans(true), new NaiveBayes(true), new PCA(true), new SVD(true), new DRF(true), new GBM(true), new IsolationForest(true), new Aggregator(true), new DeepWater(true), new Word2Vec(true), new StackedEnsemble(true), new CoxPH(true), new Generic(true)}) {
            String base = algo.getClass().getSimpleName();
            int version = SchemaServer.getStableVersion();
            if (base.equals("SVD") || base.equals("Aggregator") || base.equals("StackedEnsemble")) {
                version = SchemaServer.getExperimentalVersion();
            }
            this.registerModelBuilder(context, algo, version);
        }
        context.registerEndpoint("make_glm_model", "POST /3/MakeGLMModel", MakeGLMModelHandler.class, "make_model", "Make a new GLM model based on existing one");
        context.registerEndpoint("glm_regularization_path", "GET /3/GetGLMRegPath", MakeGLMModelHandler.class, "extractRegularizationPath", "Get full regularization path");
        context.registerEndpoint("weighted_gram_matrix", "GET /3/ComputeGram", MakeGLMModelHandler.class, "computeGram", "Get weighted gram matrix");
        context.registerEndpoint("word2vec_synonyms", "GET /3/Word2VecSynonyms", Word2VecHandler.class, "findSynonyms", "Find synonyms using a word2vec model");
        context.registerEndpoint("word2vec_transform", "GET /3/Word2VecTransform", Word2VecHandler.class, "transform", "Transform words to vectors using a word2vec model");
        context.registerEndpoint("glm_datainfo_frame", "POST /3/DataInfoFrame", MakeGLMModelHandler.class, "getDataInfoFrame", "Test only");
        context.registerEndpoint("get_tree", "GET /3/Tree", TreeHandler.class, "getTree", "Obtain a traverseable representation of a specific tree");
    }

    public String getName() {
        return "Algos";
    }
}

