/*
 * Decompiled with CFR 0.152.
 */
package hex.generic;

import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.generic.GenericModel;
import hex.generic.GenericModelOutput;
import hex.generic.GenericModelParameters;
import hex.genmodel.ModelMojoReader;
import hex.genmodel.MojoModel;
import hex.genmodel.MojoReaderBackend;
import hex.genmodel.MojoReaderBackendFactory;
import hex.genmodel.algos.drf.DrfMojoModel;
import hex.genmodel.algos.gbm.GbmMojoModel;
import hex.genmodel.algos.glm.GlmMojoModel;
import hex.genmodel.algos.isofor.IsolationForestMojoModel;
import hex.genmodel.algos.kmeans.KMeansMojoModel;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import water.Key;
import water.fvec.ByteVec;
import water.fvec.Frame;
import water.util.ArrayUtils;

public class Generic
extends ModelBuilder<GenericModel, GenericModelParameters, GenericModelOutput> {
    private static final Class[] SUPPORTED_MOJOS = new Class[]{GlmMojoModel.class, GbmMojoModel.class, IsolationForestMojoModel.class, DrfMojoModel.class, KMeansMojoModel.class};

    public Generic(GenericModelParameters genericParameters) {
        super((Model.Parameters)genericParameters);
        this.init(false);
    }

    public Generic(boolean startup_once) {
        super((Model.Parameters)new GenericModelParameters(), startup_once);
    }

    protected ModelBuilder.Driver trainModelImpl() {
        return new MojoDelegatingModelDriver();
    }

    public ModelCategory[] can_build() {
        return ModelCategory.values();
    }

    public boolean haveMojo() {
        return true;
    }

    public boolean isSupervised() {
        return false;
    }

    private final ByteVec getUploadedMojo(Key<Frame> key) throws IllegalArgumentException {
        Objects.requireNonNull(key);
        Frame mojoFrame = (Frame)key.get();
        if (mojoFrame.numCols() > 1) {
            throw new IllegalArgumentException(String.format("Given MOJO frame with key '%s' should contain only 1 column with MOJO bytes. More columns found. Incorrect key provided ?", key));
        }
        ByteVec mojoData = (ByteVec)mojoFrame.anyVec();
        if (mojoData.length() < 1L) {
            throw new IllegalArgumentException(String.format("Given MOJO frame with key '%s' is empty (0 bytes). Please provide a non-empty MOJO file.", key));
        }
        return mojoData;
    }

    public ModelBuilder.BuilderVisibility builderVisibility() {
        return ModelBuilder.BuilderVisibility.Stable;
    }

    class MojoDelegatingModelDriver
    extends ModelBuilder.Driver {
        MojoDelegatingModelDriver() {
            super((ModelBuilder)Generic.this);
        }

        public void computeImpl() {
            ByteVec mojoBytes = Generic.this.getUploadedMojo((Key<Frame>)((GenericModelParameters)Generic.this._parms)._model_key);
            try {
                MojoReaderBackend readerBackend = MojoReaderBackendFactory.createReaderBackend((InputStream)mojoBytes.openStream(Generic.this._job._key), (MojoReaderBackendFactory.CachingStrategy)MojoReaderBackendFactory.CachingStrategy.MEMORY);
                MojoModel mojoModel = ModelMojoReader.readFrom((MojoReaderBackend)readerBackend, (boolean)true);
                if (!ArrayUtils.isInstance((Object)mojoModel, (Class[])SUPPORTED_MOJOS)) {
                    throw new IllegalArgumentException(String.format("Unsupported MOJO model %s. ", mojoModel.getClass().getName()));
                }
                GenericModelOutput genericModelOutput = new GenericModelOutput(mojoModel._modelDescriptor);
                GenericModel genericModel = new GenericModel((Key<GenericModel>)Generic.this._result, (GenericModelParameters)Generic.this._parms, genericModelOutput, mojoModel, mojoBytes);
                genericModel.write_lock(Generic.this._job);
                genericModel.unlock(Generic.this._job);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unreachable MOJO file: " + mojoBytes._key, e);
            }
        }
    }
}

