/*
 * Decompiled with CFR 0.152.
 */
package hex.generic;

import hex.Model;
import hex.ModelMetrics;
import hex.ModelMetricsAutoEncoder;
import hex.ModelMetricsBinomial;
import hex.ModelMetricsClustering;
import hex.ModelMetricsMultinomial;
import hex.ModelMetricsOrdinal;
import hex.ModelMetricsRegression;
import hex.generic.GenericModelMojoWriter;
import hex.generic.GenericModelOutput;
import hex.generic.GenericModelParameters;
import hex.genmodel.ModelMojoReader;
import hex.genmodel.MojoModel;
import hex.genmodel.MojoReaderBackend;
import hex.genmodel.MojoReaderBackendFactory;
import hex.genmodel.algos.kmeans.KMeansMojoModel;
import hex.tree.isofor.ModelMetricsAnomaly;
import java.io.IOException;
import java.io.InputStream;
import water.H2O;
import water.Key;
import water.fvec.ByteVec;

public class GenericModel
extends Model<GenericModel, GenericModelParameters, GenericModelOutput> {
    private transient MojoModel _mojoModel;
    private ByteVec _mojoBytes;

    public GenericModel(Key<GenericModel> selfKey, GenericModelParameters parms, GenericModelOutput output, MojoModel mojoModel, ByteVec mojoBytes) {
        super(selfKey, (Model.Parameters)parms, (Model.Output)output);
        this._mojoBytes = mojoBytes;
        this._mojoModel = mojoModel;
        this._output = new GenericModelOutput(this._mojoModel._modelDescriptor);
    }

    private static MojoModel reconstructMojo(ByteVec mojoBytes) {
        try {
            MojoReaderBackend readerBackend = MojoReaderBackendFactory.createReaderBackend((InputStream)mojoBytes.openStream(null), (MojoReaderBackendFactory.CachingStrategy)MojoReaderBackendFactory.CachingStrategy.MEMORY);
            return ModelMojoReader.readFrom((MojoReaderBackend)readerBackend, (boolean)true);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unreachable MOJO file: " + mojoBytes._key, e);
        }
    }

    public ModelMetrics.MetricBuilder makeMetricBuilder(String[] domain) {
        switch (((GenericModelOutput)this._output).getModelCategory()) {
            case Unknown: {
                throw new IllegalStateException("Model category is unknown");
            }
            case Binomial: {
                return new ModelMetricsBinomial.MetricBuilderBinomial(domain);
            }
            case Multinomial: {
                return new ModelMetricsMultinomial.MetricBuilderMultinomial(((GenericModelOutput)this._output).nclasses(), domain);
            }
            case Ordinal: {
                return new ModelMetricsOrdinal.MetricBuilderOrdinal(((GenericModelOutput)this._output).nclasses(), domain);
            }
            case Regression: {
                return new ModelMetricsRegression.MetricBuilderRegression();
            }
            case Clustering: {
                assert (this._mojoModel instanceof KMeansMojoModel);
                KMeansMojoModel kMeansMojoModel = (KMeansMojoModel)this._mojoModel;
                return new ModelMetricsClustering.MetricBuilderClustering(((GenericModelOutput)this._output).nfeatures(), kMeansMojoModel.getNumClusters());
            }
            case AutoEncoder: {
                return new ModelMetricsAutoEncoder.MetricBuilderAutoEncoder(((GenericModelOutput)this._output).nfeatures());
            }
            case DimReduction: {
                throw new UnsupportedOperationException("DimReduction is not supported.");
            }
            case WordEmbedding: {
                throw new UnsupportedOperationException("WordEmbedding is not supported.");
            }
            case CoxPH: {
                throw new UnsupportedOperationException("CoxPH is not supported.");
            }
            case AnomalyDetection: {
                return new ModelMetricsAnomaly.MetricBuilderAnomaly("");
            }
        }
        throw H2O.unimpl();
    }

    protected double[] score0(double[] data, double[] preds) {
        if (this._mojoModel == null) {
            assert (this._mojoBytes != null);
            this._mojoModel = GenericModel.reconstructMojo(this._mojoBytes);
        }
        return this._mojoModel.score0(data, preds);
    }

    public GenericModelMojoWriter getMojo() {
        return new GenericModelMojoWriter(this._mojoBytes);
    }
}

