/*
 * Decompiled with CFR 0.152.
 */
package hex.generic;

import hex.Model;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.genmodel.ModelDescriptor;
import hex.genmodel.descriptor.Table;
import hex.genmodel.descriptor.VariableImportances;
import water.util.TwoDimTable;

public class GenericModelOutput
extends Model.Output {
    private final ModelCategory _modelCategory;
    private final int _nfeatures;
    public final TwoDimTable _variable_importances;

    public GenericModelOutput(ModelDescriptor modelDescriptor) {
        this._isSupervised = modelDescriptor.isSupervised();
        this._domains = modelDescriptor.scoringDomains();
        this._origDomains = modelDescriptor.scoringDomains();
        this._hasOffset = modelDescriptor.offsetColumn() != null;
        this._hasWeights = modelDescriptor.weightsColumn() != null;
        this._hasFold = modelDescriptor.foldColumn() != null;
        this._distribution = modelDescriptor.modelClassDist();
        this._priorClassDist = modelDescriptor.priorClassDist();
        this._names = modelDescriptor.columnNames();
        this._modelCategory = modelDescriptor.getModelCategory();
        this._nfeatures = modelDescriptor.nfeatures();
        this._variable_importances = GenericModelOutput.readVariableImportances(modelDescriptor.variableImportances());
        this._model_summary = GenericModelOutput.convertTable(modelDescriptor.modelSummary());
    }

    public ModelCategory getModelCategory() {
        return this._modelCategory;
    }

    public int nfeatures() {
        return this._nfeatures;
    }

    private static TwoDimTable readVariableImportances(VariableImportances variableImportances) {
        if (variableImportances == null) {
            return null;
        }
        TwoDimTable varImps = ModelMetrics.calcVarImp((double[])variableImportances._importances, (String[])variableImportances._variables);
        return varImps;
    }

    private static TwoDimTable convertTable(Table convertedTable) {
        if (convertedTable == null) {
            return null;
        }
        TwoDimTable table = new TwoDimTable(convertedTable.getTableHeader(), convertedTable.getTableDescription(), convertedTable.getRowHeaders(), convertedTable.getColHeaders(), convertedTable.getColTypesString(), null, convertedTable.getColHeaderForRowHeaders());
        for (int i = 0; i < convertedTable.columns(); ++i) {
            for (int j = 0; j < convertedTable.rows(); ++j) {
                table.set(j, i, convertedTable.getCell(i, j));
            }
        }
        return table;
    }
}

