/*
 * Decompiled with CFR 0.152.
 */
package hex.glm;

import hex.DataInfo;
import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.deeplearning.DeepLearningModel;
import hex.glm.ComputationState;
import hex.glm.GLMModel;
import hex.glm.GLMTask;
import hex.gram.Gram;
import hex.optimization.ADMM;
import hex.optimization.L_BFGS;
import hex.optimization.OptimizationUtils;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;
import jsr166y.CountedCompleter;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import water.DKV;
import water.H2O;
import water.HeartBeat;
import water.Iced;
import water.Job;
import water.Key;
import water.Keyed;
import water.MemoryManager;
import water.Scope;
import water.exceptions.H2OModelBuilderIllegalArgumentException;
import water.fvec.Frame;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.util.ArrayUtils;
import water.util.FrameUtils;
import water.util.Log;
import water.util.PrettyPrint;
import water.util.RandomUtils;
import water.util.TwoDimTable;

public class GLM
extends ModelBuilder<GLMModel, GLMModel.GLMParameters, GLMModel.GLMOutput> {
    protected boolean _cv;
    static NumberFormat lambdaFormatter = new DecimalFormat(".##E0");
    static NumberFormat devFormatter = new DecimalFormat(".##");
    public static final int SCORING_INTERVAL_MSEC = 15000;
    public String _generatedWeights = null;
    private transient GLMDriver _driver;
    private double _lambdaCVEstimate = Double.NaN;
    private boolean _doInit = true;
    private double[] _xval_test_deviances;
    private double[] _xval_test_sd;
    DataInfo _dinfo;
    private transient DataInfo _validDinfo;
    private transient ScoringHistory _sc;
    private transient LambdaSearchScoringHistory _lsc;
    long _t0 = System.currentTimeMillis();
    private transient double _iceptAdjust = 0.0;
    private double _lmax;
    private transient long _nobs;
    private transient GLMModel _model;
    private transient double[] _nullBeta;
    protected static final long WORK_TOTAL = 1000000L;
    transient Key[] _toRemove;
    private transient ComputationState _state;

    public GLM(boolean startup_once) {
        super((Model.Parameters)new GLMModel.GLMParameters(), startup_once);
    }

    public GLM(GLMModel.GLMParameters parms) {
        super((Model.Parameters)parms);
        this.init(false);
    }

    public GLM(GLMModel.GLMParameters parms, Key dest) {
        super((Model.Parameters)parms, dest);
        this.init(false);
    }

    public boolean isSupervised() {
        return true;
    }

    public ModelCategory[] can_build() {
        return new ModelCategory[]{ModelCategory.Regression, ModelCategory.Binomial};
    }

    public boolean havePojo() {
        return true;
    }

    public boolean haveMojo() {
        return true;
    }

    public void computeCrossValidation() {
        this.init(true);
        this._cv = true;
        if (this.error_count() > 0) {
            throw H2OModelBuilderIllegalArgumentException.makeFromBuilder((ModelBuilder)this);
        }
        super.computeCrossValidation();
    }

    public void cv_computeAndSetOptimalParameters(ModelBuilder[] cvModelBuilders) {
        if (((GLMModel.GLMParameters)this._parms)._max_runtime_secs != 0.0) {
            ((GLMModel.GLMParameters)this._parms)._max_runtime_secs = 0.0;
        }
        if (((GLMModel.GLMParameters)this._parms)._lambda_search) {
            int bestId1se;
            GLM g;
            int i;
            this._xval_test_deviances = new double[((GLMModel.GLMParameters)this._parms)._lambda.length];
            this._xval_test_sd = new double[((GLMModel.GLMParameters)this._parms)._lambda.length];
            double bestTestDev = Double.POSITIVE_INFINITY;
            int lmin_max = 0;
            for (int i2 = 0; i2 < cvModelBuilders.length; ++i2) {
                GLM g2 = (GLM)cvModelBuilders[i2];
                lmin_max = Math.max(lmin_max, ((GLMModel.GLMOutput)g2._model._output)._best_lambda_idx);
            }
            int bestId = 0;
            int cnt = 0;
            for (int lidx = 0; lidx < lmin_max; ++lidx) {
                double testDev = 0.0;
                for (int i3 = 0; i3 < cvModelBuilders.length; ++i3) {
                    GLM g3 = (GLM)cvModelBuilders[i3];
                    double x = ((GLMModel.GLMParameters)this._parms)._lambda[lidx];
                    if (((GLMModel.GLMOutput)g3._model._output).getSubmodel(x) == null) {
                        g3._driver.computeSubmodel(lidx, x);
                    }
                    testDev += ((GLMModel.GLMOutput)g3._model._output).getSubmodel((double)x).devianceTest;
                }
                double testDevAvg = testDev / (double)cvModelBuilders.length;
                double testDevSE = 0.0;
                for (int i4 = 0; i4 < cvModelBuilders.length; ++i4) {
                    GLM g4 = (GLM)cvModelBuilders[i4];
                    double x = ((GLMModel.GLMParameters)this._parms)._lambda[lidx];
                    if (((GLMModel.GLMOutput)g4._model._output).getSubmodel(x) == null) {
                        g4._driver.computeSubmodel(lidx, x);
                    }
                    double diff = testDevAvg - ((GLMModel.GLMOutput)g4._model._output).getSubmodel((double)x).devianceTest;
                    testDevSE += diff * diff;
                }
                this._xval_test_sd[lidx] = Math.sqrt(testDevSE / (double)((cvModelBuilders.length - 1) * cvModelBuilders.length));
                this._xval_test_deviances[lidx] = testDevAvg;
                if (testDevAvg < bestTestDev) {
                    bestTestDev = testDevAvg;
                    bestId = lidx;
                }
                if (!(testDevAvg > bestTestDev) || ++cnt != 3) continue;
                lmin_max = lidx;
                break;
            }
            for (i = 0; i < cvModelBuilders.length; ++i) {
                g = (GLM)cvModelBuilders[i];
                if (g._toRemove == null) continue;
                for (Key k : g._toRemove) {
                    Keyed.remove((Key)k);
                }
            }
            ((GLMModel.GLMParameters)this._parms)._lambda = Arrays.copyOf(((GLMModel.GLMParameters)this._parms)._lambda, lmin_max + 1);
            this._xval_test_deviances = Arrays.copyOf(this._xval_test_deviances, lmin_max + 1);
            this._xval_test_sd = Arrays.copyOf(this._xval_test_sd, lmin_max + 1);
            for (i = 0; i < cvModelBuilders.length; ++i) {
                g = (GLM)cvModelBuilders[i];
                ((GLMModel.GLMOutput)g._model._output).setSubmodelIdx(bestId);
                g._model.update(this._job);
            }
            double bestDev = this._xval_test_deviances[bestId];
            double bestDev1se = bestDev + this._xval_test_sd[bestId];
            for (bestId1se = bestId; bestId1se > 0 && this._xval_test_deviances[bestId1se - 1] <= bestDev1se; --bestId1se) {
            }
            this._lambdaCVEstimate = ((GLMModel.GLMParameters)this._parms)._lambda[bestId];
            ((GLMModel.GLMOutput)this._model._output)._lambda_1se = bestId1se;
            ((GLMModel.GLMOutput)this._model._output)._best_lambda_idx = bestId;
        }
        for (int i = 0; i < cvModelBuilders.length; ++i) {
            GLM g = (GLM)cvModelBuilders[i];
            g._model.unlock(this._job);
        }
        this._doInit = false;
        this._cv = false;
    }

    protected void checkMemoryFootPrint(DataInfo activeData) {
        if (((GLMModel.GLMParameters)this._parms)._solver == GLMModel.GLMParameters.Solver.IRLSM || ((GLMModel.GLMParameters)this._parms)._solver == GLMModel.GLMParameters.Solver.COORDINATE_DESCENT) {
            long max_mem;
            int p = activeData.fullN();
            HeartBeat hb = H2O.SELF._heartbeat;
            long mem_usage = (long)((double)(hb._cpus_allowed * (p * p + activeData.largestCat()) * 8) * (1.0 + 0.5 * Math.log(this._train.lastVec().nChunks()) / Math.log(2.0)));
            if (mem_usage > (max_mem = hb.get_free_mem())) {
                String msg = "Gram matrices (one per thread) won't fit in the driver node's memory (" + PrettyPrint.bytes((long)mem_usage) + " > " + PrettyPrint.bytes((long)max_mem) + ") - try reducing the number of columns and/or the number of categorical factors (or switch to the L-BFGS solver).";
                this.error("_train", msg);
            }
        }
    }

    public int nclasses() {
        if (((GLMModel.GLMParameters)this._parms)._family == GLMModel.GLMParameters.Family.multinomial || ((GLMModel.GLMParameters)this._parms)._family == GLMModel.GLMParameters.Family.ordinal) {
            return this._nclass;
        }
        if (((GLMModel.GLMParameters)this._parms)._family == GLMModel.GLMParameters.Family.binomial || ((GLMModel.GLMParameters)this._parms)._family == GLMModel.GLMParameters.Family.quasibinomial) {
            return 2;
        }
        return 1;
    }

    private double[] getNullBeta() {
        if (this._nullBeta == null) {
            if (((GLMModel.GLMParameters)this._parms)._family == GLMModel.GLMParameters.Family.multinomial || ((GLMModel.GLMParameters)this._parms)._family == GLMModel.GLMParameters.Family.ordinal) {
                this._nullBeta = MemoryManager.malloc8d((int)((this._dinfo.fullN() + 1) * this.nclasses()));
                int N = this._dinfo.fullN() + 1;
                if (((GLMModel.GLMParameters)this._parms)._intercept) {
                    if (((GLMModel.GLMParameters)this._parms)._family == GLMModel.GLMParameters.Family.ordinal) {
                        int i;
                        Random rng = RandomUtils.getRNG((long[])new long[]{((GLMModel.GLMParameters)this._parms)._seed});
                        int lastClass = this.nclasses() - 1;
                        double[] tempIcpt = new double[lastClass];
                        for (i = 0; i < lastClass; ++i) {
                            tempIcpt[i] = (-1.0 + 2.0 * rng.nextDouble()) * (double)this.nclasses();
                        }
                        Arrays.sort(tempIcpt);
                        for (i = 0; i < lastClass; ++i) {
                            this._nullBeta[this._dinfo.fullN() + i * N] = tempIcpt[i];
                        }
                    } else {
                        for (int i = 0; i < this.nclasses(); ++i) {
                            this._nullBeta[this._dinfo.fullN() + i * N] = Math.log(this._state._ymu[i]);
                        }
                    }
                }
            } else {
                this._nullBeta = MemoryManager.malloc8d((int)(this._dinfo.fullN() + 1));
                this._nullBeta[this._dinfo.fullN()] = ((GLMModel.GLMParameters)this._parms)._intercept && ((GLMModel.GLMParameters)this._parms)._family != GLMModel.GLMParameters.Family.quasibinomial ? new GLMModel.GLMWeightsFun((GLMModel.GLMParameters)this._parms).link(this._state._ymu[0]) : 0.0;
            }
        }
        return this._nullBeta;
    }

    protected boolean computePriorClassDistribution() {
        return ((GLMModel.GLMParameters)this._parms)._family == GLMModel.GLMParameters.Family.multinomial || ((GLMModel.GLMParameters)this._parms)._family == GLMModel.GLMParameters.Family.ordinal;
    }

    public void init(boolean expensive) {
        super.init(expensive);
        this.hide("_balance_classes", "Not applicable since class balancing is not required for GLM.");
        this.hide("_max_after_balance_size", "Not applicable since class balancing is not required for GLM.");
        this.hide("_class_sampling_factors", "Not applicable since class balancing is not required for GLM.");
        ((GLMModel.GLMParameters)this._parms).validate(this);
        if (this._response != null) {
            if (!this.isClassifier() && this._response.isCategorical()) {
                this.error("_response", H2O.technote((int)2, (String)"Regression requires numeric response, got categorical."));
            }
            if ((((GLMModel.GLMParameters)this._parms)._solver.equals((Object)GLMModel.GLMParameters.Solver.GRADIENT_DESCENT_LH) || ((GLMModel.GLMParameters)this._parms)._solver.equals((Object)GLMModel.GLMParameters.Solver.GRADIENT_DESCENT_SQERR)) && !((GLMModel.GLMParameters)this._parms)._family.equals((Object)GLMModel.GLMParameters.Family.ordinal)) {
                this.error("_solver", "Solvers GRADIENT_DESCENT_LH and GRADIENT_DESCENT_SQERR are only supported for ordinal regression.  Do not choose them unless you specify your family to be ordinal");
            }
            switch (((GLMModel.GLMParameters)this._parms)._family) {
                case binomial: {
                    if (this._response.isBinary() || this._nclass == 2) break;
                    this.error("_family", H2O.technote((int)2, (String)"Binomial requires the response to be a 2-class categorical or a binary column (0/1)"));
                    break;
                }
                case multinomial: {
                    if (this._nclass > 2) break;
                    this.error("_family", H2O.technote((int)2, (String)"Multinomial requires a categorical response with at least 3 levels (for 2 class problem use family=binomial."));
                    break;
                }
                case poisson: 
                case negativebinomial: {
                    if (this._nclass != 1) {
                        this.error("_family", "Poisson and Negative Binomial require the response to be numeric.");
                    }
                    if (this._response.min() < 0.0) {
                        this.error("_family", "Poisson and Negative Binomial require response >= 0");
                    }
                    if (!this._response.isInt()) {
                        this.warn("_family", "Poisson and Negative Binomial expect non-negative integer response, got floats.");
                    }
                    if (!((GLMModel.GLMParameters)this._parms)._family.equals((Object)GLMModel.GLMParameters.Family.negativebinomial)) break;
                    if (((GLMModel.GLMParameters)this._parms)._theta <= 0.0 || ((GLMModel.GLMParameters)this._parms)._theta > 1.0) {
                        this.error("_family", "Illegal Negative Binomial theta value.  Valid theta values be > 0 and <= 1.");
                        break;
                    }
                    ((GLMModel.GLMParameters)this._parms)._invTheta = 1.0 / ((GLMModel.GLMParameters)this._parms)._theta;
                    break;
                }
                case gamma: {
                    if (this._nclass != 1) {
                        this.error("_distribution", H2O.technote((int)2, (String)"Gamma requires the response to be numeric."));
                    }
                    if (!(this._response.min() <= 0.0)) break;
                    this.error("_family", "Response value for gamma distribution must be greater than 0.");
                    break;
                }
                case tweedie: {
                    if (this._nclass == 1) break;
                    this.error("_family", H2O.technote((int)2, (String)"Tweedie requires the response to be numeric."));
                    break;
                }
                case quasibinomial: {
                    if (this._nclass == 1) break;
                    this.error("_family", H2O.technote((int)2, (String)"Quasi_binomial requires the response to be numeric."));
                    break;
                }
                case ordinal: {
                    if (this._nclass <= 2) {
                        this.error("_family", H2O.technote((int)2, (String)"Ordinal requires a categorical response with at least 3 levels (for 2 class problem use family=binomial."));
                    }
                    if (((GLMModel.GLMParameters)this._parms)._link != GLMModel.GLMParameters.Link.oprobit && ((GLMModel.GLMParameters)this._parms)._link != GLMModel.GLMParameters.Link.ologlog) break;
                    this.error("_link", "Ordinal regression only supports ologit as link.");
                    break;
                }
                case gaussian: {
                    break;
                }
                default: {
                    this.error("_family", "Invalid distribution: " + ((GLMModel.GLMParameters)this._parms)._distribution);
                }
            }
        }
        if (expensive) {
            BetaConstraint bc;
            boolean skippingRows;
            if (this.error_count() > 0) {
                return;
            }
            if (((GLMModel.GLMParameters)this._parms)._alpha == null) {
                ((GLMModel.GLMParameters)this._parms)._alpha = new double[]{((GLMModel.GLMParameters)this._parms)._solver == GLMModel.GLMParameters.Solver.L_BFGS ? 0.0 : 0.5};
            }
            if (((GLMModel.GLMParameters)this._parms)._lambda_search && ((GLMModel.GLMParameters)this._parms)._nlambdas == -1) {
                ((GLMModel.GLMParameters)this._parms)._nlambdas = ((GLMModel.GLMParameters)this._parms)._alpha[0] == 0.0 ? 30 : 100;
            }
            this._lsc = new LambdaSearchScoringHistory(((GLMModel.GLMParameters)this._parms)._valid != null, ((GLMModel.GLMParameters)this._parms)._nfolds > 1);
            this._sc = new ScoringHistory();
            this._train.bulkRollups();
            this._sc = new ScoringHistory();
            this._t0 = System.currentTimeMillis();
            if (((GLMModel.GLMParameters)this._parms)._lambda_search || !((GLMModel.GLMParameters)this._parms)._intercept || ((GLMModel.GLMParameters)this._parms)._lambda == null || ((GLMModel.GLMParameters)this._parms)._lambda[0] > 0.0) {
                ((GLMModel.GLMParameters)this._parms)._use_all_factor_levels = true;
            }
            if (((GLMModel.GLMParameters)this._parms)._link == GLMModel.GLMParameters.Link.family_default) {
                ((GLMModel.GLMParameters)this._parms)._link = ((GLMModel.GLMParameters)this._parms)._family.defaultLink;
            }
            this._dinfo = new DataInfo((Frame)this._train.clone(), this._valid, 1, ((GLMModel.GLMParameters)this._parms)._use_all_factor_levels || ((GLMModel.GLMParameters)this._parms)._lambda_search, ((GLMModel.GLMParameters)this._parms)._standardize ? DataInfo.TransformType.STANDARDIZE : DataInfo.TransformType.NONE, DataInfo.TransformType.NONE, ((GLMModel.GLMParameters)this._parms)._missing_values_handling == DeepLearningModel.DeepLearningParameters.MissingValuesHandling.Skip, ((GLMModel.GLMParameters)this._parms)._missing_values_handling == DeepLearningModel.DeepLearningParameters.MissingValuesHandling.MeanImputation, false, this.hasWeightCol(), this.hasOffsetCol(), this.hasFoldCol(), ((GLMModel.GLMParameters)this._parms).interactionSpec());
            if (((GLMModel.GLMParameters)this._parms)._max_iterations == -1) {
                int numclasses;
                int n = numclasses = ((GLMModel.GLMParameters)this._parms)._family == GLMModel.GLMParameters.Family.multinomial || ((GLMModel.GLMParameters)this._parms)._family == GLMModel.GLMParameters.Family.ordinal ? this.nclasses() : 1;
                if (((GLMModel.GLMParameters)this._parms)._solver == GLMModel.GLMParameters.Solver.L_BFGS) {
                    int n2 = ((GLMModel.GLMParameters)this._parms)._max_iterations = ((GLMModel.GLMParameters)this._parms)._lambda_search ? ((GLMModel.GLMParameters)this._parms)._nlambdas * 100 * numclasses : numclasses * Math.max(20, this._dinfo.fullN() >> 2);
                    if (((GLMModel.GLMParameters)this._parms)._alpha[0] > 0.0) {
                        ((GLMModel.GLMParameters)this._parms)._max_iterations *= 10;
                    }
                } else {
                    int n3 = ((GLMModel.GLMParameters)this._parms)._max_iterations = ((GLMModel.GLMParameters)this._parms)._lambda_search ? 10 * ((GLMModel.GLMParameters)this._parms)._nlambdas : 50;
                }
            }
            if (this._valid != null) {
                this._validDinfo = this._dinfo.validDinfo(this._valid);
            }
            this._state = new ComputationState(this._job, (GLMModel.GLMParameters)this._parms, this._dinfo, null, this.nclasses());
            boolean bl = skippingRows = ((GLMModel.GLMParameters)this._parms)._missing_values_handling == DeepLearningModel.DeepLearningParameters.MissingValuesHandling.Skip && this._train.hasNAs();
            if (this.hasWeightCol() || skippingRows) {
                GLMTask.YMUTask ymt;
                boolean setWeights = skippingRows;
                if (setWeights) {
                    Vec wc = this._weights == null ? this._dinfo._adaptedFrame.anyVec().makeCon(1.0) : this._weights.makeCopy();
                    this._generatedWeights = "__glm_gen_weights";
                    this._dinfo.setWeights("__glm_gen_weights", wc);
                }
                if ((ymt = (GLMTask.YMUTask)new GLMTask.YMUTask(this._dinfo, ((GLMModel.GLMParameters)this._parms)._family == GLMModel.GLMParameters.Family.multinomial || ((GLMModel.GLMParameters)this._parms)._family == GLMModel.GLMParameters.Family.ordinal ? this.nclasses() : 1, setWeights, skippingRows, true, false).doAll(this._dinfo._adaptedFrame)).wsum() == 0.0) {
                    throw new IllegalArgumentException("No rows left in the dataset after filtering out rows with missing values. Ignore columns with many NAs or impute your missing values prior to calling glm.");
                }
                Log.info((Object[])new Object[]{this.LogMsg("using " + ymt.nobs() + " nobs out of " + this._dinfo._adaptedFrame.numRows() + " total")});
                this._nobs = ymt.nobs();
                if (((GLMModel.GLMParameters)this._parms)._obj_reg == -1.0) {
                    ((GLMModel.GLMParameters)this._parms)._obj_reg = 1.0 / ymt.wsum();
                }
                if (!((GLMModel.GLMParameters)this._parms)._stdOverride) {
                    this._dinfo.updateWeightedSigmaAndMean(ymt.predictorSDs(), ymt.predictorMeans());
                }
                if (((GLMModel.GLMParameters)this._parms)._family == GLMModel.GLMParameters.Family.multinomial || ((GLMModel.GLMParameters)this._parms)._family == GLMModel.GLMParameters.Family.ordinal) {
                    this._state._ymu = MemoryManager.malloc8d((int)this._nclass);
                    for (int i = 0; i < this._state._ymu.length; ++i) {
                        this._state._ymu[i] = this._priorClassDist[i];
                    }
                } else {
                    double[] dArray;
                    if (((GLMModel.GLMParameters)this._parms)._intercept) {
                        dArray = ymt._yMu;
                    } else {
                        double[] dArray2 = new double[1];
                        dArray = dArray2;
                        dArray2[0] = ((GLMModel.GLMParameters)this._parms).linkInv(0.0);
                    }
                    this._state._ymu = dArray;
                }
            } else {
                this._nobs = this._train.numRows();
                if (((GLMModel.GLMParameters)this._parms)._obj_reg == -1.0) {
                    ((GLMModel.GLMParameters)this._parms)._obj_reg = 1.0 / (double)this._nobs;
                }
                if (((GLMModel.GLMParameters)this._parms)._family == GLMModel.GLMParameters.Family.multinomial || ((GLMModel.GLMParameters)this._parms)._family == GLMModel.GLMParameters.Family.ordinal) {
                    this._state._ymu = MemoryManager.malloc8d((int)this._nclass);
                    for (int i = 0; i < this._state._ymu.length; ++i) {
                        this._state._ymu[i] = this._priorClassDist[i];
                    }
                } else {
                    this._state._ymu = new double[]{((GLMModel.GLMParameters)this._parms)._intercept ? this._train.lastVec().mean() : ((GLMModel.GLMParameters)this._parms).linkInv(0.0)};
                }
            }
            BetaConstraint betaConstraint = bc = ((GLMModel.GLMParameters)this._parms)._beta_constraints != null ? new BetaConstraint((Frame)((GLMModel.GLMParameters)this._parms)._beta_constraints.get()) : new BetaConstraint();
            if ((bc.hasBounds() || bc.hasProximalPenalty()) && ((GLMModel.GLMParameters)this._parms)._compute_p_values) {
                this.error("_compute_p_values", "P-values can not be computed for constrained problems");
            }
            if (bc.hasBounds()) {
                ((GLMModel.GLMParameters)this._parms)._early_stopping = false;
            }
            this._state.setBC(bc);
            if (this.hasOffsetCol() && ((GLMModel.GLMParameters)this._parms)._intercept) {
                GLMGradientSolver gslvr = new GLMGradientSolver(this._job, (GLMModel.GLMParameters)this._parms, this._dinfo.filterExpandedColumns(new int[0]), 0.0, this._state.activeBC());
                double[] x = new L_BFGS().solve((OptimizationUtils.GradientSolver)gslvr, (double[])new double[]{-this._offset.mean()}).coefs;
                Log.info((Object[])new Object[]{this.LogMsg("fitted intercept = " + x[0])});
                x[0] = ((GLMModel.GLMParameters)this._parms).linkInv(x[0]);
                this._state._ymu = x;
            }
            if (((GLMModel.GLMParameters)this._parms)._prior > 0.0) {
                this._iceptAdjust = -Math.log(this._state._ymu[0] * (1.0 - ((GLMModel.GLMParameters)this._parms)._prior) / (((GLMModel.GLMParameters)this._parms)._prior * (1.0 - this._state._ymu[0])));
            }
            ArrayList<Vec> vecs = new ArrayList<Vec>();
            if (this._weights != null) {
                vecs.add(this._weights);
            }
            if (this._offset != null) {
                vecs.add(this._offset);
            }
            vecs.add(this._response);
            double[] beta = this.getNullBeta();
            GLMGradientInfo ginfo = new GLMGradientSolver(this._job, (GLMModel.GLMParameters)this._parms, this._dinfo, 0.0, this._state.activeBC()).getGradient(beta);
            this._lmax = this.lmax(ginfo._gradient);
            this._state.setLambdaMax(this._lmax);
            if (((GLMModel.GLMParameters)this._parms)._lambda_min_ratio == -1.0) {
                double d = ((GLMModel.GLMParameters)this._parms)._lambda_min_ratio = this._nobs >> 4 > (long)this._dinfo.fullN() ? 1.0E-4 : 0.01;
                if (((GLMModel.GLMParameters)this._parms)._alpha[0] == 0.0) {
                    ((GLMModel.GLMParameters)this._parms)._lambda_min_ratio *= 0.01;
                }
            }
            this._state.updateState(beta, ginfo);
            if (((GLMModel.GLMParameters)this._parms)._lambda == null) {
                if (((GLMModel.GLMParameters)this._parms)._lambda_search) {
                    ((GLMModel.GLMParameters)this._parms)._lambda = new double[((GLMModel.GLMParameters)this._parms)._nlambdas];
                    double dec = Math.pow(((GLMModel.GLMParameters)this._parms)._lambda_min_ratio, 1.0 / (double)(((GLMModel.GLMParameters)this._parms)._nlambdas - 1));
                    ((GLMModel.GLMParameters)this._parms)._lambda[0] = this._lmax;
                    double l = this._lmax;
                    for (int i = 1; i < ((GLMModel.GLMParameters)this._parms)._nlambdas; ++i) {
                        ((GLMModel.GLMParameters)this._parms)._lambda[i] = l *= dec;
                    }
                } else {
                    ((GLMModel.GLMParameters)this._parms)._lambda = new double[]{10.0 * ((GLMModel.GLMParameters)this._parms)._lambda_min_ratio * this._lmax};
                }
            }
            if (!Double.isNaN(this._lambdaCVEstimate)) {
                for (int i = 0; i < ((GLMModel.GLMParameters)this._parms)._lambda.length; ++i) {
                    if (!(((GLMModel.GLMParameters)this._parms)._lambda[i] < this._lambdaCVEstimate)) continue;
                    ((GLMModel.GLMParameters)this._parms)._lambda = Arrays.copyOf(((GLMModel.GLMParameters)this._parms)._lambda, i + 1);
                    break;
                }
                ((GLMModel.GLMParameters)this._parms)._lambda[((GLMModel.GLMParameters)this._parms)._lambda.length - 1] = this._lambdaCVEstimate;
            }
            if (((GLMModel.GLMParameters)this._parms)._objective_epsilon == -1.0) {
                if (((GLMModel.GLMParameters)this._parms)._lambda_search) {
                    ((GLMModel.GLMParameters)this._parms)._objective_epsilon = 1.0E-4;
                } else {
                    double d = ((GLMModel.GLMParameters)this._parms)._objective_epsilon = ((GLMModel.GLMParameters)this._parms)._lambda[0] == 0.0 ? 1.0E-6 : 1.0E-4;
                }
            }
            if (((GLMModel.GLMParameters)this._parms)._gradient_epsilon == -1.0) {
                double d = ((GLMModel.GLMParameters)this._parms)._gradient_epsilon = ((GLMModel.GLMParameters)this._parms)._lambda[0] == 0.0 ? 1.0E-6 : 1.0E-4;
                if (((GLMModel.GLMParameters)this._parms)._lambda_search) {
                    ((GLMModel.GLMParameters)this._parms)._gradient_epsilon *= 0.01;
                }
            }
            this.buildModel();
        }
    }

    private void buildModel() {
        this._model = new GLMModel(this._result, (GLMModel.GLMParameters)this._parms, this, this._state._ymu, this._dinfo._adaptedFrame.lastVec().sigma(), this._lmax, this._nobs);
        this._model.clone2().delete_and_lock(this._job._key);
    }

    private Key[] removeLater(Key ... k) {
        this._toRemove = this._toRemove == null ? k : (Key[])ArrayUtils.append((Object[])this._toRemove, (Object[])k);
        return k;
    }

    protected GLMDriver trainModelImpl() {
        this._driver = new GLMDriver();
        return this._driver;
    }

    private final double lmax(double[] grad) {
        return Math.max(ArrayUtils.maxValue((double[])grad), -ArrayUtils.minValue((double[])grad)) / Math.max(0.01, ((GLMModel.GLMParameters)this._parms)._alpha[0]);
    }

    private GLMModel.GLMParameters.Solver defaultSolver() {
        GLMModel.GLMParameters.Solver s = GLMModel.GLMParameters.Solver.IRLSM;
        int max_active = 0;
        if (((GLMModel.GLMParameters)this._parms)._family == GLMModel.GLMParameters.Family.multinomial) {
            for (int c = 0; c < this._nclass; ++c) {
                max_active += this._state.activeDataMultinomial(c).fullN();
            }
        } else {
            max_active = this._state.activeData().fullN();
        }
        if (max_active >= 5000) {
            s = GLMModel.GLMParameters.Solver.L_BFGS;
        } else if (((GLMModel.GLMParameters)this._parms)._lambda_search) {
            s = GLMModel.GLMParameters.Solver.COORDINATE_DESCENT;
        } else if (this._state.activeBC().hasBounds() && !this._state.activeBC().hasProximalPenalty()) {
            s = GLMModel.GLMParameters.Solver.COORDINATE_DESCENT;
        } else if (((GLMModel.GLMParameters)this._parms)._family == GLMModel.GLMParameters.Family.multinomial && ((GLMModel.GLMParameters)this._parms)._alpha[0] == 0.0) {
            s = GLMModel.GLMParameters.Solver.L_BFGS;
        } else {
            Log.info((Object[])new Object[]{this.LogMsg("picked solver " + (Object)((Object)s))});
        }
        if (s != GLMModel.GLMParameters.Solver.L_BFGS && ((GLMModel.GLMParameters)this._parms)._max_active_predictors == -1) {
            ((GLMModel.GLMParameters)this._parms)._max_active_predictors = 5000;
        }
        ((GLMModel.GLMParameters)this._parms)._solver = s;
        return s;
    }

    double objVal(double likelihood, double[] beta, double lambda) {
        double alpha = ((GLMModel.GLMParameters)this._parms)._alpha[0];
        double proximalPen = 0.0;
        BetaConstraint bc = this._state.activeBC();
        if (this._state.activeBC()._betaGiven != null && bc._rho != null) {
            for (int i = 0; i < bc._betaGiven.length; ++i) {
                double diff = beta[i] - bc._betaGiven[i];
                proximalPen += diff * diff * bc._rho[i];
            }
        }
        return likelihood * ((GLMModel.GLMParameters)this._parms)._obj_reg + 0.5 * proximalPen + lambda * (alpha * ArrayUtils.l1norm((double[])beta, (boolean)((GLMModel.GLMParameters)this._parms)._intercept) + (1.0 - alpha) * 0.5 * ArrayUtils.l2norm2((double[])beta, (boolean)((GLMModel.GLMParameters)this._parms)._intercept));
    }

    private String LogMsg(String msg) {
        return "GLM[dest=" + this.dest() + ", " + this._state + "] " + msg;
    }

    private static final double[] expandVec(double[] beta, int[] activeCols, int fullN) {
        return GLM.expandVec(beta, activeCols, fullN, 0.0);
    }

    private static final double[] expandVec(double[] beta, int[] activeCols, int fullN, double filler) {
        assert (beta != null);
        if (activeCols == null) {
            return beta;
        }
        double[] res = MemoryManager.malloc8d((int)fullN);
        Arrays.fill(res, filler);
        int i = 0;
        for (int c : activeCols) {
            res[c] = beta[i++];
        }
        res[res.length - 1] = beta[beta.length - 1];
        return res;
    }

    private static double[] doUpdateCD(double[] grads, double[] ary, double diff, int variable_min, int variable_max) {
        int i;
        for (i = 0; i < variable_min; ++i) {
            int n = i;
            grads[n] = grads[n] + diff * ary[i];
        }
        for (i = variable_max; i < grads.length; ++i) {
            int n = i;
            grads[n] = grads[n] + diff * ary[i];
        }
        return grads;
    }

    public double[] COD_solve(ComputationState.GramXY gram, double alpha, double lambda) {
        double[] res = this.COD_solve(gram.gram.getXX(), gram.xy, gram.getCODGradients(), gram.newCols, alpha, lambda);
        gram.newCols = new int[0];
        return res;
    }

    private double[] COD_solve(double[][] xx, double[] xy, double[] grads, int[] newCols, double alpha, double lambda) {
        double wsumInv = 1.0 / xx[xx.length - 1][xx.length - 1];
        double betaEpsilon = ((GLMModel.GLMParameters)this._parms)._beta_epsilon * ((GLMModel.GLMParameters)this._parms)._beta_epsilon;
        double updateEpsilon = 0.01 * betaEpsilon;
        double l1pen = lambda * alpha;
        double l2pen = lambda * (1.0 - alpha);
        double[] diagInv = MemoryManager.malloc8d((int)xx.length);
        for (int i = 0; i < diagInv.length; ++i) {
            diagInv[i] = 1.0 / (xx[i][i] + l2pen);
        }
        DataInfo activeData = this._state.activeData();
        int[][] nzs = new int[activeData.numStart()][];
        int sparseCnt = 0;
        if (nzs.length > 1000) {
            int[] nzs_ary = new int[xx.length];
            for (int i = 0; i < activeData._cats; ++i) {
                int var_min = activeData._catOffsets[i];
                int var_max = activeData._catOffsets[i + 1];
                for (int l = var_min; l < var_max; ++l) {
                    int j;
                    int k = 0;
                    double[] x = xx[l];
                    for (j = 0; j < var_min; ++j) {
                        if (x[j] == 0.0) continue;
                        nzs_ary[k++] = j;
                    }
                    for (j = var_max; j < activeData.numStart(); ++j) {
                        if (x[j] == 0.0) continue;
                        nzs_ary[k++] = j;
                    }
                    if (k >= nzs_ary.length - var_max + var_min >> 3) continue;
                    ++sparseCnt;
                    nzs[l] = Arrays.copyOf(nzs_ary, k);
                }
            }
        }
        BetaConstraint bc = this._state.activeBC();
        double[] beta = (double[])this._state.beta().clone();
        int numStart = activeData.numStart();
        if (newCols != null) {
            for (int id : newCols) {
                double b = bc.applyBounds(ADMM.shrinkage(grads[id], l1pen) * diagInv[id], id);
                if (b == 0.0) continue;
                GLM.doUpdateCD(grads, xx[id], -b, id, id + 1);
                beta[id] = b;
            }
        }
        int iter1 = 0;
        int P = xy.length - 1;
        double maxDiff = 0.0;
        while (iter1++ < Math.max(P, 500)) {
            int i;
            maxDiff = 0.0;
            for (i = 0; i < activeData._cats; ++i) {
                for (int j = activeData._catOffsets[i]; j < activeData._catOffsets[i + 1]; ++j) {
                    double b = bc.applyBounds(ADMM.shrinkage(grads[j], l1pen) * diagInv[j], j);
                    double bd = beta[j] - b;
                    if (bd == 0.0) continue;
                    double diff = bd * bd * xx[j][j];
                    if (diff > maxDiff) {
                        maxDiff = diff;
                    }
                    if (nzs[j] == null) {
                        GLM.doUpdateCD(grads, xx[j], bd, activeData._catOffsets[i], activeData._catOffsets[i + 1]);
                    } else {
                        int[] ids;
                        double[] x = xx[j];
                        int[] nArray = ids = nzs[j];
                        int n = nArray.length;
                        for (int k = 0; k < n; ++k) {
                            int id;
                            int n2 = id = nArray[k];
                            grads[n2] = grads[n2] + bd * x[id];
                        }
                        GLM.doUpdateCD(grads, x, bd, 0, activeData.numStart());
                    }
                    beta[j] = b;
                }
            }
            for (i = numStart; i < P; ++i) {
                double b = bc.applyBounds(ADMM.shrinkage(grads[i], l1pen) * diagInv[i], i);
                double bd = beta[i] - b;
                double diff = bd * bd * xx[i][i];
                if (diff > maxDiff) {
                    maxDiff = diff;
                }
                if (!(diff > updateEpsilon)) continue;
                GLM.doUpdateCD(grads, xx[i], bd, i, i + 1);
                beta[i] = b;
            }
            if (((GLMModel.GLMParameters)this._parms)._intercept) {
                double b = bc.applyBounds(grads[P] * wsumInv, P);
                double bd = beta[P] - b;
                double diff = bd * bd * xx[P][P];
                if (diff > maxDiff) {
                    maxDiff = diff;
                }
                GLM.doUpdateCD(grads, xx[P], bd, P, P + 1);
                beta[P] = b;
            }
            if (!(maxDiff < betaEpsilon)) continue;
        }
        long tend = System.currentTimeMillis();
        return beta;
    }

    protected static double sparseOffset(double[] beta, DataInfo dinfo) {
        double etaOffset = 0.0;
        if (dinfo._normMul != null && dinfo._normSub != null && beta != null) {
            int ns = dinfo.numStart();
            for (int i = 0; i < dinfo._nums; ++i) {
                etaOffset -= beta[i + ns] * dinfo._normSub[i] * dinfo._normMul[i];
            }
        }
        return etaOffset;
    }

    public final class BetaConstraint
    extends Iced {
        double[] _betaStart;
        double[] _betaGiven;
        double[] _rho;
        double[] _betaLB;
        double[] _betaUB;

        public BetaConstraint() {
            if (((GLMModel.GLMParameters)GLM.this._parms)._non_negative) {
                this.setNonNegative();
            }
        }

        public void setNonNegative() {
            if (this._betaLB == null) {
                this._betaLB = MemoryManager.malloc8d((int)(GLM.this._dinfo.fullN() + 1));
                this._betaLB[GLM.this._dinfo.fullN()] = Double.NEGATIVE_INFINITY;
            } else {
                for (int i = 0; i < this._betaLB.length - 1; ++i) {
                    this._betaLB[i] = Math.max(0.0, this._betaLB[i]);
                }
            }
            if (this._betaUB == null) {
                this._betaUB = MemoryManager.malloc8d((int)(GLM.this._dinfo.fullN() + 1));
                Arrays.fill(this._betaUB, Double.POSITIVE_INFINITY);
            }
        }

        public double applyBounds(double d, int i) {
            if (this._betaLB != null && d < this._betaLB[i]) {
                return this._betaLB[i];
            }
            if (this._betaUB != null && d > this._betaUB[i]) {
                return this._betaUB[i];
            }
            return d;
        }

        public BetaConstraint(Frame beta_constraints) {
            int idx;
            Object[] names;
            int i;
            int[] map;
            Object[] dom;
            Vec v = beta_constraints.vec("names");
            if (v.isString()) {
                dom = new String[(int)v.length()];
                map = new int[dom.length];
                BufferedString tmpStr = new BufferedString();
                for (int i2 = 0; i2 < dom.length; ++i2) {
                    dom[i2] = v.atStr(tmpStr, (long)i2).toString();
                    map[i2] = i2;
                }
                Object[] sortedDom = (String[])dom.clone();
                Arrays.sort(sortedDom);
                for (i = 1; i < sortedDom.length; ++i) {
                    if (!((String)sortedDom[i - 1]).equals(sortedDom[i])) continue;
                    throw new IllegalArgumentException("Illegal beta constraints file, got duplicate constraint for predictor '" + (String)sortedDom[i - 1] + "'!");
                }
            } else if (v.isCategorical()) {
                dom = v.domain();
                map = FrameUtils.asInts((Vec)v);
                int[] sortedMap = MemoryManager.arrayCopyOf((int[])map, (int)map.length);
                Arrays.sort(sortedMap);
                for (int i3 = 1; i3 < sortedMap.length; ++i3) {
                    if (sortedMap[i3 - 1] != sortedMap[i3]) continue;
                    throw new IllegalArgumentException("Illegal beta constraints file, got duplicate constraint for predictor '" + (String)dom[sortedMap[i3 - 1]] + "'!");
                }
            } else {
                throw new IllegalArgumentException("Illegal beta constraints file, names column expected to contain column names (strings)");
            }
            if (!Arrays.deepEquals(dom, names = (String[])ArrayUtils.append((Object[])GLM.this._dinfo.coefNames(), (Object[])new String[]{"Intercept"}))) {
                HashMap<Object, Integer> m = new HashMap<Object, Integer>();
                for (i = 0; i < names.length; ++i) {
                    m.put(names[i], i);
                }
                int[] newMap = MemoryManager.malloc4((int)dom.length);
                for (int i4 = 0; i4 < map.length; ++i4) {
                    if (GLM.this._removedCols.contains(dom[map[i4]])) {
                        newMap[i4] = -1;
                        continue;
                    }
                    Integer I = (Integer)m.get(dom[map[i4]]);
                    if (I == null) {
                        throw new IllegalArgumentException("Unrecognized coefficient name in beta-constraint file, unknown name '" + (String)dom[map[i4]] + "'");
                    }
                    newMap[i4] = I;
                }
                map = newMap;
            }
            int numoff = GLM.this._dinfo.numStart();
            Object[] valid_col_names = new String[]{"names", "beta_given", "beta_start", "lower_bounds", "upper_bounds", "rho", "mean", "std_dev"};
            Arrays.sort(valid_col_names);
            for (String s : beta_constraints.names()) {
                if (Arrays.binarySearch(valid_col_names, s) >= 0) continue;
                GLM.this.error("beta_constraints", "Unknown column name '" + s + "'");
            }
            v = beta_constraints.vec("beta_start");
            if (v != null) {
                this._betaStart = MemoryManager.malloc8d((int)(GLM.this._dinfo.fullN() + (GLM.this._dinfo._intercept ? 1 : 0)));
                for (int i5 = 0; i5 < (int)v.length(); ++i5) {
                    if (map[i5] == -1) continue;
                    this._betaStart[map[i5]] = v.at((long)i5);
                }
            }
            if ((v = beta_constraints.vec("beta_given")) != null) {
                this._betaGiven = MemoryManager.malloc8d((int)(GLM.this._dinfo.fullN() + (GLM.this._dinfo._intercept ? 1 : 0)));
                for (int i6 = 0; i6 < (int)v.length(); ++i6) {
                    if (map[i6] == -1) continue;
                    this._betaGiven[map[i6]] = v.at((long)i6);
                }
            }
            if ((v = beta_constraints.vec("upper_bounds")) != null) {
                this._betaUB = MemoryManager.malloc8d((int)(GLM.this._dinfo.fullN() + (GLM.this._dinfo._intercept ? 1 : 0)));
                Arrays.fill(this._betaUB, Double.POSITIVE_INFINITY);
                for (int i7 = 0; i7 < (int)v.length(); ++i7) {
                    if (map[i7] == -1) continue;
                    this._betaUB[map[i7]] = v.at((long)i7);
                }
            }
            if ((v = beta_constraints.vec("lower_bounds")) != null) {
                this._betaLB = MemoryManager.malloc8d((int)(GLM.this._dinfo.fullN() + (GLM.this._dinfo._intercept ? 1 : 0)));
                Arrays.fill(this._betaLB, Double.NEGATIVE_INFINITY);
                for (int i8 = 0; i8 < (int)v.length(); ++i8) {
                    if (map[i8] == -1) continue;
                    this._betaLB[map[i8]] = v.at((long)i8);
                }
            }
            if ((v = beta_constraints.vec("rho")) != null) {
                this._rho = MemoryManager.malloc8d((int)(GLM.this._dinfo.fullN() + (GLM.this._dinfo._intercept ? 1 : 0)));
                for (int i9 = 0; i9 < (int)v.length(); ++i9) {
                    if (map[i9] == -1) continue;
                    this._rho[map[i9]] = v.at((long)i9);
                }
            }
            if ((v = beta_constraints.vec("mean")) != null) {
                ((GLMModel.GLMParameters)GLM.this._parms)._stdOverride = true;
                int i10 = 0;
                while ((long)i10 < v.length()) {
                    if (!v.isNA((long)i10) && map[i10] != -1) {
                        int n = idx = map == null ? i10 : map[i10];
                        if (idx > GLM.this._dinfo.numStart() && idx < GLM.this._dinfo.fullN()) {
                            GLM.this._dinfo._normSub[idx - GLM.this._dinfo.numStart()] = v.at((long)i10);
                        }
                    }
                    ++i10;
                }
            }
            if ((v = beta_constraints.vec("std_dev")) != null) {
                ((GLMModel.GLMParameters)GLM.this._parms)._stdOverride = true;
                int i11 = 0;
                while ((long)i11 < v.length()) {
                    if (!v.isNA((long)i11) && map[i11] != -1) {
                        int n = idx = map == null ? i11 : map[i11];
                        if (idx > GLM.this._dinfo.numStart() && idx < GLM.this._dinfo.fullN()) {
                            GLM.this._dinfo._normMul[idx - GLM.this._dinfo.numStart()] = 1.0 / v.at((long)i11);
                        }
                    }
                    ++i11;
                }
            }
            if (GLM.this._dinfo._normMul != null) {
                double normG = 0.0;
                double normS = 0.0;
                double normLB = 0.0;
                double normUB = 0.0;
                for (int i12 = numoff; i12 < GLM.this._dinfo.fullN(); ++i12) {
                    double s = GLM.this._dinfo._normSub[i12 - numoff];
                    double d = 1.0 / GLM.this._dinfo._normMul[i12 - numoff];
                    if (this._betaUB != null && !Double.isInfinite(this._betaUB[i12])) {
                        normUB *= s;
                        int n = i12;
                        this._betaUB[n] = this._betaUB[n] * d;
                    }
                    if (this._betaLB != null && !Double.isInfinite(this._betaUB[i12])) {
                        normLB *= s;
                        int n = i12;
                        this._betaLB[n] = this._betaLB[n] * d;
                    }
                    if (this._betaGiven != null) {
                        normG += this._betaGiven[i12] * s;
                        int n = i12;
                        this._betaGiven[n] = this._betaGiven[n] * d;
                    }
                    if (this._betaStart == null) continue;
                    normS += this._betaStart[i12] * s;
                    int n = i12;
                    this._betaStart[n] = this._betaStart[n] * d;
                }
                if (GLM.this._dinfo._intercept) {
                    int n = GLM.this._dinfo.fullN();
                    if (this._betaGiven != null) {
                        int n2 = n;
                        this._betaGiven[n2] = this._betaGiven[n2] + normG;
                    }
                    if (this._betaStart != null) {
                        int n3 = n;
                        this._betaStart[n3] = this._betaStart[n3] + normS;
                    }
                    if (this._betaLB != null) {
                        int n4 = n;
                        this._betaLB[n4] = this._betaLB[n4] + normLB;
                    }
                    if (this._betaUB != null) {
                        int n5 = n;
                        this._betaUB[n5] = this._betaUB[n5] + normUB;
                    }
                }
            }
            if (this._betaStart == null && this._betaGiven != null) {
                this._betaStart = (double[])this._betaGiven.clone();
            }
            if (this._betaStart != null && (this._betaLB != null || this._betaUB != null)) {
                for (int i13 = 0; i13 < this._betaStart.length; ++i13) {
                    if (this._betaLB != null && this._betaLB[i13] > this._betaStart[i13]) {
                        this._betaStart[i13] = this._betaLB[i13];
                    }
                    if (this._betaUB == null || !(this._betaUB[i13] < this._betaStart[i13])) continue;
                    this._betaStart[i13] = this._betaUB[i13];
                }
            }
            if (((GLMModel.GLMParameters)GLM.this._parms)._non_negative) {
                this.setNonNegative();
            }
            this.check();
        }

        public String toString() {
            double[][] ary = new double[this._betaGiven.length][3];
            for (int i = 0; i < this._betaGiven.length; ++i) {
                ary[i][0] = this._betaGiven[i];
                ary[i][1] = this._betaLB[i];
                ary[i][2] = this._betaUB[i];
            }
            return ArrayUtils.pprint((double[][])ary);
        }

        public boolean hasBounds() {
            if (this._betaLB != null) {
                for (double d : this._betaLB) {
                    if (Double.isInfinite(d)) continue;
                    return true;
                }
            }
            if (this._betaUB != null) {
                for (double d : this._betaUB) {
                    if (Double.isInfinite(d)) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean hasProximalPenalty() {
            return this._betaGiven != null && this._rho != null && ArrayUtils.countNonzeros((double[])this._rho) > 0;
        }

        public void adjustGradient(double[] beta, double[] grad) {
            if (this._betaGiven != null && this._rho != null) {
                for (int i = 0; i < this._betaGiven.length; ++i) {
                    double diff = beta[i] - this._betaGiven[i];
                    int n = i;
                    grad[n] = grad[n] + this._rho[i] * diff;
                }
            }
        }

        double proxPen(double[] beta) {
            double res = 0.0;
            if (this._betaGiven != null && this._rho != null) {
                for (int i = 0; i < this._betaGiven.length; ++i) {
                    double diff = beta[i] - this._betaGiven[i];
                    res += this._rho[i] * diff * diff;
                }
                res *= 0.5;
            }
            return res;
        }

        public void check() {
            if (this._betaLB != null && this._betaUB != null) {
                for (int i = 0; i < this._betaLB.length; ++i) {
                    if (this._betaLB[i] <= this._betaUB[i]) continue;
                    throw new IllegalArgumentException("lower bounds must be <= upper bounds, " + this._betaLB[i] + " !<= " + this._betaUB[i]);
                }
            }
        }

        public BetaConstraint filterExpandedColumns(int[] activeCols) {
            BetaConstraint res = new BetaConstraint();
            if (this._betaLB != null) {
                res._betaLB = ArrayUtils.select((double[])this._betaLB, (int[])activeCols);
            }
            if (this._betaUB != null) {
                res._betaUB = ArrayUtils.select((double[])this._betaUB, (int[])activeCols);
            }
            if (this._betaGiven != null) {
                res._betaGiven = ArrayUtils.select((double[])this._betaGiven, (int[])activeCols);
            }
            if (this._rho != null) {
                res._rho = ArrayUtils.select((double[])this._rho, (int[])activeCols);
            }
            if (this._betaStart != null) {
                res._betaStart = ArrayUtils.select((double[])this._betaStart, (int[])activeCols);
            }
            return res;
        }
    }

    public static final class GLMGradientSolver
    implements OptimizationUtils.GradientSolver {
        final GLMModel.GLMParameters _parms;
        final DataInfo _dinfo;
        final BetaConstraint _bc;
        final double _l2pen;
        double[][] _betaMultinomial;
        final Job _job;

        public GLMGradientSolver(Job job, GLMModel.GLMParameters glmp, DataInfo dinfo, double l2pen, BetaConstraint bc) {
            this._job = job;
            this._bc = bc;
            this._parms = glmp;
            this._dinfo = dinfo;
            this._l2pen = l2pen;
        }

        public GLMGradientInfo getMultinomialLikelihood(double[] beta) {
            assert (this._parms._family.equals((Object)GLMModel.GLMParameters.Family.multinomial)) : "GLMGradientInfo.getMultinomialLikelihood is only used by multinomial GLM";
            assert (this._betaMultinomial != null) : "Multinomial coefficents cannot be null.";
            int off = 0;
            for (int i = 0; i < this._betaMultinomial.length; ++i) {
                System.arraycopy(beta, off, this._betaMultinomial[i], 0, this._betaMultinomial[i].length);
                off += this._betaMultinomial[i].length;
            }
            GLMTask.GLMMultinomialGradientBaseTask gt = (GLMTask.GLMMultinomialGradientBaseTask)new GLMTask.GLMMultinomialLikelihoodTask(this._job, this._dinfo, this._l2pen, this._betaMultinomial, this._parms).doAll(this._dinfo._adaptedFrame);
            double l2pen = 0.0;
            for (double[] b : this._betaMultinomial) {
                l2pen += ArrayUtils.l2norm2((double[])b, (boolean)this._dinfo._intercept);
            }
            return new GLMGradientInfo(gt._likelihood, gt._likelihood * this._parms._obj_reg + 0.5 * this._l2pen * l2pen, null);
        }

        @Override
        public GLMGradientInfo getGradient(double[] beta) {
            if (this._parms._family == GLMModel.GLMParameters.Family.multinomial || this._parms._family == GLMModel.GLMParameters.Family.ordinal) {
                int i;
                if (this._betaMultinomial == null) {
                    int nclasses = beta.length / (this._dinfo.fullN() + 1);
                    assert (beta.length % (this._dinfo.fullN() + 1) == 0) : "beta len = " + beta.length + ", fullN +1  == " + (this._dinfo.fullN() + 1);
                    this._betaMultinomial = new double[nclasses][];
                    for (i = 0; i < nclasses; ++i) {
                        this._betaMultinomial[i] = MemoryManager.malloc8d((int)(this._dinfo.fullN() + 1));
                    }
                }
                int off = 0;
                for (i = 0; i < this._betaMultinomial.length; ++i) {
                    System.arraycopy(beta, off, this._betaMultinomial[i], 0, this._betaMultinomial[i].length);
                    off += this._betaMultinomial[i].length;
                }
                GLMTask.GLMMultinomialGradientBaseTask gt = (GLMTask.GLMMultinomialGradientBaseTask)new GLMTask.GLMMultinomialGradientTask(this._job, this._dinfo, this._l2pen, this._betaMultinomial, this._parms).doAll(this._dinfo._adaptedFrame);
                double l2pen = 0.0;
                for (double[] b : this._betaMultinomial) {
                    l2pen += ArrayUtils.l2norm2((double[])b, (boolean)this._dinfo._intercept);
                    if (this._parms._family == GLMModel.GLMParameters.Family.ordinal) break;
                }
                double[] grad = gt.gradient();
                if (!this._parms._intercept) {
                    for (int i2 = this._dinfo.fullN(); i2 < beta.length; i2 += this._dinfo.fullN() + 1) {
                        grad[i2] = 0.0;
                    }
                }
                return new GLMGradientInfo(gt._likelihood, gt._likelihood * this._parms._obj_reg + 0.5 * this._l2pen * l2pen, grad);
            }
            assert (beta.length == this._dinfo.fullN() + 1);
            assert (this._parms._intercept || beta[beta.length - 1] == 0.0);
            GLMTask.GLMGradientTask gt = this._parms._family == GLMModel.GLMParameters.Family.binomial && this._parms._link == GLMModel.GLMParameters.Link.logit ? (GLMTask.GLMGradientTask)new GLMTask.GLMBinomialGradientTask(this._job == null ? null : this._job._key, this._dinfo, this._parms, this._l2pen, beta).doAll(this._dinfo._adaptedFrame) : (this._parms._family == GLMModel.GLMParameters.Family.gaussian && this._parms._link == GLMModel.GLMParameters.Link.identity ? (GLMTask.GLMGradientTask)new GLMTask.GLMGaussianGradientTask(this._job == null ? null : this._job._key, this._dinfo, this._parms, this._l2pen, beta).doAll(this._dinfo._adaptedFrame) : (this._parms._family.equals((Object)GLMModel.GLMParameters.Family.negativebinomial) ? (GLMTask.GLMGradientTask)new GLMTask.GLMNegativeBinomialGradientTask(this._job == null ? null : this._job._key, this._dinfo, this._parms, this._l2pen, beta).doAll(this._dinfo._adaptedFrame) : (this._parms._family == GLMModel.GLMParameters.Family.poisson && this._parms._link == GLMModel.GLMParameters.Link.log ? (GLMTask.GLMGradientTask)new GLMTask.GLMPoissonGradientTask(this._job == null ? null : this._job._key, this._dinfo, this._parms, this._l2pen, beta).doAll(this._dinfo._adaptedFrame) : (this._parms._family == GLMModel.GLMParameters.Family.quasibinomial ? (GLMTask.GLMGradientTask)new GLMTask.GLMQuasiBinomialGradientTask(this._job == null ? null : this._job._key, this._dinfo, this._parms, this._l2pen, beta).doAll(this._dinfo._adaptedFrame) : (GLMTask.GLMGradientTask)new GLMTask.GLMGenericGradientTask(this._job == null ? null : this._job._key, this._dinfo, this._parms, this._l2pen, beta).doAll(this._dinfo._adaptedFrame)))));
            double[] gradient = gt._gradient;
            double likelihood = gt._likelihood;
            if (!this._parms._intercept) {
                gradient[gradient.length - 1] = 0.0;
            }
            double obj = likelihood * this._parms._obj_reg + 0.5 * this._l2pen * ArrayUtils.l2norm2((double[])beta, (boolean)true);
            if (this._bc != null && this._bc._betaGiven != null && this._bc._rho != null) {
                obj = ProximalGradientSolver.proximal_gradient(gradient, obj, beta, this._bc._betaGiven, this._bc._rho);
            }
            return new GLMGradientInfo(likelihood, obj, gradient);
        }

        @Override
        public OptimizationUtils.GradientInfo getObjective(double[] beta) {
            double l = ((GLMTask.GLMResDevTask)new GLMTask.GLMResDevTask((Key)this._job._key, (DataInfo)this._dinfo, (GLMModel.GLMParameters)this._parms, (double[])beta).doAll((Frame)this._dinfo._adaptedFrame))._likelihood;
            return new GLMGradientInfo(l, l * this._parms._obj_reg + 0.5 * this._l2pen * ArrayUtils.l2norm2((double[])beta, (boolean)true), null);
        }
    }

    public static class GLMGradientInfo
    extends OptimizationUtils.GradientInfo {
        final double _likelihood;

        public GLMGradientInfo(double likelihood, double objVal, double[] grad) {
            super(objVal, grad);
            this._likelihood = likelihood;
        }

        @Override
        public String toString() {
            return "GLM grad info: likelihood = " + this._likelihood + super.toString();
        }
    }

    public static class ProximalGradientSolver
    implements OptimizationUtils.GradientSolver,
    ADMM.ProximalSolver {
        final OptimizationUtils.GradientSolver _solver;
        double[] _betaGiven;
        double[] _beta;
        private ProximalGradientInfo _ginfo;
        private final L_BFGS.ProgressMonitor _pm;
        final double[] _rho;
        private final double _objEps;
        private final double _gradEps;
        private int _iter;

        public ProximalGradientSolver(OptimizationUtils.GradientSolver s, double[] betaStart, double[] rho, double objEps, double gradEps, OptimizationUtils.GradientInfo ginfo, L_BFGS.ProgressMonitor pm) {
            this._solver = s;
            this._rho = rho;
            this._objEps = objEps;
            this._gradEps = gradEps;
            this._pm = pm;
            this._beta = betaStart;
            this._betaGiven = MemoryManager.malloc8d((int)betaStart.length);
        }

        public static double proximal_gradient(double[] grad, double obj, double[] beta, double[] beta_given, double[] rho) {
            for (int i = 0; i < beta.length; ++i) {
                double diff = beta[i] - beta_given[i];
                double pen = rho[i] * diff;
                if (grad != null) {
                    int n = i;
                    grad[n] = grad[n] + pen;
                }
                obj += 0.5 * pen * diff;
            }
            return obj;
        }

        private ProximalGradientInfo computeProxGrad(OptimizationUtils.GradientInfo ginfo, double[] beta) {
            assert (!(ginfo instanceof ProximalGradientInfo));
            double[] gradient = (double[])ginfo._gradient.clone();
            double obj = ProximalGradientSolver.proximal_gradient(gradient, ginfo._objVal, beta, this._betaGiven, this._rho);
            return new ProximalGradientInfo(ginfo, obj, gradient);
        }

        @Override
        public ProximalGradientInfo getGradient(double[] beta) {
            return this.computeProxGrad(this._solver.getGradient(beta), beta);
        }

        @Override
        public OptimizationUtils.GradientInfo getObjective(double[] beta) {
            OptimizationUtils.GradientInfo ginfo = this._solver.getObjective(beta);
            double obj = ProximalGradientSolver.proximal_gradient(null, ginfo._objVal, beta, this._betaGiven, this._rho);
            return new ProximalGradientInfo(ginfo, obj, null);
        }

        @Override
        public double[] rho() {
            return this._rho;
        }

        @Override
        public boolean solve(double[] beta_given, double[] beta) {
            OptimizationUtils.GradientInfo origGinfo = this._ginfo == null || !Arrays.equals(this._beta, beta) ? this._solver.getGradient(beta) : this._ginfo._origGinfo;
            System.arraycopy(beta_given, 0, this._betaGiven, 0, beta_given.length);
            this._ginfo = this.computeProxGrad(origGinfo, beta);
            L_BFGS.Result r = new L_BFGS().setObjEps(this._objEps).setGradEps(this._gradEps).solve(this, beta, this._ginfo, this._pm);
            System.arraycopy(r.coefs, 0, beta, 0, r.coefs.length);
            this._beta = r.coefs;
            this._iter += r.iter;
            this._ginfo = (ProximalGradientInfo)r.ginfo;
            return r.converged;
        }

        @Override
        public boolean hasGradient() {
            return true;
        }

        @Override
        public OptimizationUtils.GradientInfo gradient(double[] beta) {
            return this.getGradient((double[])beta)._origGinfo;
        }

        @Override
        public int iter() {
            return this._iter;
        }
    }

    public static class ProximalGradientInfo
    extends OptimizationUtils.GradientInfo {
        final OptimizationUtils.GradientInfo _origGinfo;

        public ProximalGradientInfo(OptimizationUtils.GradientInfo origGinfo, double objVal, double[] gradient) {
            super(objVal, gradient);
            this._origGinfo = origGinfo;
        }
    }

    public static final class GramSolver
    implements ADMM.ProximalSolver {
        private final Gram _gram;
        private Gram.Cholesky _chol;
        private final double[] _xy;
        final double _lambda;
        double[] _rho;
        boolean _addedL2;
        double _betaEps;

        private static double boundedX(double x, double lb, double ub) {
            if (x < lb) {
                x = lb;
            }
            if (x > ub) {
                x = ub;
            }
            return x;
        }

        public GramSolver(Gram gram, double[] xy, double lmax, double betaEps, boolean intercept) {
            this._gram = gram;
            this._lambda = 0.0;
            this._betaEps = betaEps;
            this._xy = xy;
            double[] rhos = MemoryManager.malloc8d((int)xy.length);
            this.computeCholesky(gram, rhos, lmax * 1.0E-8, intercept);
            this._addedL2 = rhos[0] != 0.0;
            this._rho = (double[])(this._addedL2 ? rhos : null);
        }

        public void solve(double[] result) {
            System.arraycopy(this._xy, 0, result, 0, this._xy.length);
            this._chol.solve(result);
            double gerr = Double.POSITIVE_INFINITY;
            if (this._addedL2) {
                double[] oldRes = MemoryManager.arrayCopyOf((double[])result, (int)result.length);
                for (int i = 0; i < 1000; ++i) {
                    this.solve(oldRes, result);
                    double[] g = this.gradient((double[])result)._gradient;
                    gerr = Math.max(-ArrayUtils.minValue((double[])g), ArrayUtils.maxValue((double[])g));
                    if (gerr < 1.0E-4) {
                        return;
                    }
                    System.arraycopy(result, 0, oldRes, 0, result.length);
                }
                Log.warn((Object[])new Object[]{"Gram solver did not converge, gerr = " + gerr});
            }
        }

        public GramSolver(Gram gram, double[] xy, boolean intercept, double l2pen, double l1pen, double[] beta_given, double[] proxPen, double[] lb, double[] ub) {
            int i;
            if (ub != null && lb != null) {
                for (int i2 = 0; i2 < ub.length; ++i2) {
                    assert (ub[i2] >= lb[i2]) : i2 + ": ub < lb, ub = " + Arrays.toString(ub) + ", lb = " + Arrays.toString(lb);
                }
            }
            this._lambda = l2pen;
            this._gram = gram;
            int ii = intercept ? 1 : 0;
            int icptCol = gram.fullN() - 1;
            double[] rhos = MemoryManager.malloc8d((int)xy.length);
            double min = Double.POSITIVE_INFINITY;
            for (int i3 = 0; i3 < xy.length - ii; ++i3) {
                double d = xy[i3];
                double d2 = d = d >= 0.0 ? d : -d;
                if (!(d < min) || d == 0.0) continue;
                min = d;
            }
            double ybar = xy[icptCol];
            for (i = 0; i < rhos.length - ii; ++i) {
                double y = xy[i];
                if (y == 0.0) {
                    y = min;
                }
                double xbar = gram.get(icptCol, i);
                double x = (y - ybar * xbar) / (gram.get(i, i) - xbar * xbar + l2pen);
                rhos[i] = ADMM.L1Solver.estimateRho(x, l1pen, lb == null ? Double.NEGATIVE_INFINITY : lb[i], ub == null ? Double.POSITIVE_INFINITY : ub[i]);
            }
            if (intercept && (lb != null && !Double.isInfinite(lb[icptCol]) || ub != null && !Double.isInfinite(ub[icptCol]))) {
                int icpt = xy.length - 1;
                rhos[icpt] = 1.0;
            }
            if (l2pen > 0.0) {
                gram.addDiag(l2pen);
            }
            if (proxPen != null && beta_given != null) {
                gram.addDiag(proxPen);
                xy = (double[])xy.clone();
                for (i = 0; i < xy.length; ++i) {
                    int n = i;
                    xy[n] = xy[n] + proxPen[i] * beta_given[i];
                }
            }
            this._xy = xy;
            this._rho = rhos;
            this.computeCholesky(gram, rhos, 1.0E-5, intercept);
        }

        private void computeCholesky(Gram gram, double[] rhos, double rhoAdd, boolean intercept) {
            gram.addDiag(rhos);
            if (!intercept) {
                gram.dropIntercept();
                rhos = Arrays.copyOf(rhos, rhos.length - 1);
                this._xy[this._xy.length - 1] = 0.0;
            }
            this._chol = gram.cholesky(null, true, null);
            if (!this._chol.isSPD()) {
                gram.addDiag(ArrayUtils.mult((double[])rhos, (double)-1.0));
                gram.addDiag(rhoAdd, !intercept);
                Log.info((Object[])new Object[]{"Got NonSPD matrix with original rho, re-computing with rho = " + (this._rho[0] + rhoAdd)});
                this._chol = gram.cholesky(null, true, null);
                int cnt = 0;
                double rhoAddSum = rhoAdd;
                while (!this._chol.isSPD() && cnt++ < 5) {
                    gram.addDiag(rhoAdd, !intercept);
                    Log.warn((Object[])new Object[]{"Still NonSPD matrix, re-computing with rho = " + (rhos[0] + (rhoAddSum += rhoAdd))});
                    this._chol = gram.cholesky(null, true, null);
                }
                if (!this._chol.isSPD()) {
                    throw new Gram.NonSPDMatrixException();
                }
            }
            gram.addDiag(ArrayUtils.mult((double[])rhos, (double)-1.0));
            ArrayUtils.mult((double[])rhos, (double)-1.0);
        }

        @Override
        public double[] rho() {
            return this._rho;
        }

        @Override
        public boolean solve(double[] beta_given, double[] result) {
            if (beta_given != null) {
                for (int i = 0; i < this._xy.length; ++i) {
                    result[i] = this._xy[i] + this._rho[i] * beta_given[i];
                }
            } else {
                System.arraycopy(this._xy, 0, result, 0, this._xy.length);
            }
            this._chol.solve(result);
            return true;
        }

        @Override
        public boolean hasGradient() {
            return false;
        }

        @Override
        public OptimizationUtils.GradientInfo gradient(double[] beta) {
            double[] grad = this._gram.mul(beta);
            for (int i = 0; i < this._xy.length; ++i) {
                int n = i;
                grad[n] = grad[n] - this._xy[i];
            }
            return new OptimizationUtils.GradientInfo(Double.NaN, grad);
        }

        @Override
        public int iter() {
            return 0;
        }
    }

    public final class GLMDriver
    extends ModelBuilder.Driver
    implements L_BFGS.ProgressMonitor {
        private long _workPerIteration;
        private transient double[][] _vcov;
        private transient Gram.Cholesky _chol;
        private transient ADMM.L1Solver _lslvr;
        private long _lastScore;
        private transient double _nullDevTrain;
        private transient double _nullDevTest;
        private transient long _scoringInterval;

        public GLMDriver() {
            super((ModelBuilder)GLM.this);
            this._lastScore = System.currentTimeMillis();
            this._nullDevTrain = Double.NaN;
            this._nullDevTest = Double.NaN;
            this._scoringInterval = 15000L;
        }

        private void doCleanup() {
            try {
                if (((GLMModel.GLMParameters)GLM.this._parms)._lambda_search && ((GLMModel.GLMParameters)GLM.this._parms)._is_cv_model) {
                    Scope.untrack((Key[])GLM.this.removeLater(new Key[]{GLM.this._dinfo.getWeightsVec()._key}));
                }
                if (!GLM.this._cv && GLM.this._model != null) {
                    GLM.this._model.unlock(GLM.this._job);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        int[] findZeros(double[] vals) {
            int[] res = new int[4];
            int cnt = 0;
            for (int i = 0; i < vals.length; ++i) {
                if (vals[i] != 0.0) continue;
                if (res.length == cnt) {
                    res = Arrays.copyOf(res, res.length * 2);
                }
                res[cnt++] = i;
            }
            return Arrays.copyOf(res, cnt);
        }

        private double[] ADMM_solve(Gram gram, double[] xy) {
            if (((GLMModel.GLMParameters)GLM.this._parms)._remove_collinear_columns || ((GLMModel.GLMParameters)GLM.this._parms)._compute_p_values) {
                Gram.Cholesky chol;
                if (!((GLMModel.GLMParameters)GLM.this._parms)._intercept) {
                    throw H2O.unimpl();
                }
                ArrayList<Integer> ignoredCols = new ArrayList<Integer>();
                Gram.Cholesky cholesky = chol = ((GLM)GLM.this)._state._iter == 0 ? gram.qrCholesky(ignoredCols, ((GLMModel.GLMParameters)GLM.this._parms)._standardize) : gram.cholesky(null);
                if (!ignoredCols.isEmpty() && !((GLMModel.GLMParameters)GLM.this._parms)._remove_collinear_columns) {
                    int[] collinear_cols = new int[ignoredCols.size()];
                    for (int i = 0; i < collinear_cols.length; ++i) {
                        collinear_cols[i] = ignoredCols.get(i);
                    }
                    throw new Gram.CollinearColumnsException("Found collinear columns in the dataset. P-values can not be computed with collinear columns in the dataset. Set remove_collinear_columns flag to true to remove collinear columns automatically. Found collinear columns " + Arrays.toString(ArrayUtils.select((String[])GLM.this._dinfo.coefNames(), (int[])collinear_cols)));
                }
                if (!chol.isSPD()) {
                    throw new Gram.NonSPDMatrixException();
                }
                this._chol = chol;
                if (!ignoredCols.isEmpty()) {
                    int[] collinear_cols = new int[ignoredCols.size()];
                    for (int i = 0; i < collinear_cols.length; ++i) {
                        collinear_cols[i] = ignoredCols.get(i);
                    }
                    Object[] collinear_col_names = ArrayUtils.select((String[])GLM.this._state.activeData().coefNames(), (int[])collinear_cols);
                    GLM.this._model.addWarning("Removed collinear columns " + Arrays.toString(collinear_col_names));
                    Log.warn((Object[])new Object[]{"Removed collinear columns " + Arrays.toString(collinear_col_names)});
                    GLM.this._state.removeCols(collinear_cols);
                    gram.dropCols(collinear_cols);
                    xy = ArrayUtils.removeIds((double[])xy, (int[])collinear_cols);
                }
                xy = (double[])xy.clone();
                chol.solve(xy);
            } else {
                gram = gram.deep_clone();
                xy = (double[])xy.clone();
                GramSolver slvr = new GramSolver((Gram)gram.clone(), (double[])xy.clone(), ((GLMModel.GLMParameters)GLM.this._parms)._intercept, GLM.this._state.l2pen(), GLM.this._state.l1pen(), ((GLM)GLM.this)._state.activeBC()._betaGiven, ((GLM)GLM.this)._state.activeBC()._rho, ((GLM)GLM.this)._state.activeBC()._betaLB, ((GLM)GLM.this)._state.activeBC()._betaUB);
                this._chol = slvr._chol;
                if (GLM.this._state.l1pen() == 0.0 && !GLM.this._state.activeBC().hasBounds()) {
                    slvr.solve(xy);
                } else {
                    xy = MemoryManager.malloc8d((int)xy.length);
                    if (((GLM)GLM.this)._state._u == null && ((GLMModel.GLMParameters)GLM.this._parms)._family != GLMModel.GLMParameters.Family.multinomial) {
                        ((GLM)GLM.this)._state._u = MemoryManager.malloc8d((int)(GLM.this._state.activeData().fullN() + 1));
                    }
                    this._lslvr = new ADMM.L1Solver(1.0E-4, 10000, ((GLM)GLM.this)._state._u);
                    this._lslvr.solve(slvr, xy, GLM.this._state.l1pen(), ((GLMModel.GLMParameters)GLM.this._parms)._intercept, ((GLM)GLM.this)._state.activeBC()._betaLB, ((GLM)GLM.this)._state.activeBC()._betaUB);
                }
            }
            return xy;
        }

        private void fitCOD_multinomial(GLMModel.GLMParameters.Solver s) {
            double[] beta = GLM.this._state.betaMultinomial();
            do {
                beta = (double[])beta.clone();
                for (int c = 0; c < GLM.this._nclass; ++c) {
                    OptimizationUtils.LineSearchSolver ls;
                    boolean onlyIcpt;
                    GLM.this._state.setActiveClass(c);
                    boolean bl = onlyIcpt = GLM.this._state.activeDataMultinomial(c).fullN() == 0;
                    if (GLM.this._state.l1pen() == 0.0) {
                        if (GLM.this._state.ginfoNull()) {
                            GLM.this._state.updateState(beta, GLM.this._state.gslvr().getGradient(beta));
                        }
                        ls = new OptimizationUtils.MoreThuente(GLM.this._state.gslvrMultinomial(c), GLM.this._state.betaMultinomial(c, beta), GLM.this._state.ginfoMultinomial(c));
                    } else {
                        ls = new OptimizationUtils.SimpleBacktrackingLS(GLM.this._state.gslvrMultinomial(c), GLM.this._state.betaMultinomial(c, beta), GLM.this._state.l1pen());
                    }
                    new GLMTask.GLMMultinomialUpdate(GLM.this._state.activeDataMultinomial(), GLM.this._job._key, beta, c).doAll(((GLM)GLM.this)._state.activeDataMultinomial()._adaptedFrame);
                    ComputationState.GramXY gram = GLM.this._state.computeGram(GLM.this._state.betaMultinomial(c, beta), s);
                    double[] betaCnd = GLM.this.COD_solve(gram, ((GLM)GLM.this)._state._alpha, GLM.this._state.lambda());
                    if (!onlyIcpt && !ls.evaluate(ArrayUtils.subtract((double[])betaCnd, (double[])ls.getX(), (double[])betaCnd))) {
                        Log.info((Object[])new Object[]{GLM.this.LogMsg("Ls failed " + ls)});
                        continue;
                    }
                    GLM.this._state.setBetaMultinomial(c, beta, ls.getX());
                }
                GLM.this._state.setActiveClass(-1);
            } while (this.progress(beta, GLM.this._state.gslvr().getMultinomialLikelihood(beta)));
            if (((GLMModel.GLMParameters)GLM.this._parms)._lambda_search) {
                GLM.this._state.updateState(beta, GLM.this._state.gslvr().getGradient(beta));
            }
        }

        private void fitIRLSM_multinomial(GLMModel.GLMParameters.Solver s) {
            assert (GLM.this._dinfo._responses == 3) : "IRLSM for multinomial needs extra information encoded in additional reponses, expected 3 response vecs, got " + GLM.this._dinfo._responses;
            if (s.equals((Object)GLMModel.GLMParameters.Solver.COORDINATE_DESCENT)) {
                this.fitCOD_multinomial(s);
            } else {
                double[] beta = GLM.this._state.betaMultinomial();
                do {
                    beta = (double[])beta.clone();
                    for (int c = 0; c < GLM.this._nclass; ++c) {
                        boolean onlyIcpt = GLM.this._state.activeDataMultinomial(c).fullN() == 0;
                        GLM.this._state.setActiveClass(c);
                        OptimizationUtils.LineSearchSolver ls = GLM.this._state.l1pen() == 0.0 ? new OptimizationUtils.MoreThuente(GLM.this._state.gslvrMultinomial(c), GLM.this._state.betaMultinomial(c, beta), GLM.this._state.ginfoMultinomial(c)) : new OptimizationUtils.SimpleBacktrackingLS(GLM.this._state.gslvrMultinomial(c), GLM.this._state.betaMultinomial(c, beta), GLM.this._state.l1pen());
                        long t1 = System.currentTimeMillis();
                        new GLMTask.GLMMultinomialUpdate(GLM.this._state.activeDataMultinomial(), GLM.this._job._key, beta, c).doAll(((GLM)GLM.this)._state.activeDataMultinomial()._adaptedFrame);
                        long t2 = System.currentTimeMillis();
                        ComputationState.GramXY gram = GLM.this._state.computeGram(ls.getX(), s);
                        long t3 = System.currentTimeMillis();
                        double[] betaCnd = this.ADMM_solve(gram.gram, gram.xy);
                        long t4 = System.currentTimeMillis();
                        if (!onlyIcpt && !ls.evaluate(ArrayUtils.subtract((double[])betaCnd, (double[])ls.getX(), (double[])betaCnd))) {
                            Log.info((Object[])new Object[]{GLM.this.LogMsg("Ls failed " + ls)});
                            continue;
                        }
                        long t5 = System.currentTimeMillis();
                        GLM.this._state.setBetaMultinomial(c, beta, ls.getX());
                        Log.info((Object[])new Object[]{GLM.this.LogMsg("computed in " + (t2 - t1) + "+" + (t3 - t2) + "+" + (t4 - t3) + "+" + (t5 - t4) + "=" + (t5 - t1) + "ms, step = " + ls.step() + (this._lslvr != null ? ", l1solver " + this._lslvr : ""))});
                    }
                    GLM.this._state.setActiveClass(-1);
                } while (this.progress(beta, GLM.this._state.gslvr().getGradient(beta)));
            }
        }

        private void fitIRLSM_ordinal_default(GLMModel.GLMParameters.Solver s) {
            assert (GLM.this._dinfo._responses == 3) : "Solver for ordinal needs extra information encoded in additional reponses, expected 3 response vecs, got " + GLM.this._dinfo._responses;
            double[] beta = GLM.this._state.betaMultinomial();
            int predSize = GLM.this._dinfo.fullN();
            int predSizeP1 = predSize + 1;
            int numClass = ((GLM)GLM.this)._state._nclasses;
            int numIcpt = numClass - 1;
            double[] betaCnd = new double[predSize];
            GLM.this._state.gslvr().getGradient(beta);
            double l1pen = GLM.this._state.lambda() * ((GLM)GLM.this)._state._alpha;
            boolean stopNow = false;
            do {
                int pindex;
                beta = (double[])beta.clone();
                double[] grads = ((GLM)GLM.this)._state.ginfo()._gradient;
                for (pindex = 0; pindex < numIcpt; ++pindex) {
                    int previousIcpt;
                    int icptindex;
                    int n = icptindex = (pindex + 1) * predSizeP1 - 1;
                    beta[n] = beta[n] - grads[icptindex];
                    if (pindex <= 0 || !(beta[icptindex] < beta[previousIcpt = pindex * predSizeP1 - 1])) continue;
                    GLM.this.warn("Ordinal regression training: ", " intercepts of previous class exceed that of current class.  Make sure your training parameters are set properly.  Training will stop now with the last eligible parameters.");
                    stopNow = true;
                    for (int index = 0; index <= pindex; ++index) {
                        int n2 = icptindex = (index + 1) * predSizeP1 - 1;
                        beta[n2] = beta[n2] + grads[icptindex];
                    }
                    break;
                }
                if (stopNow) break;
                for (pindex = 0; pindex < predSize; ++pindex) {
                    betaCnd[pindex] = grads[pindex];
                    if (l1pen > 0.0) {
                        int n = pindex;
                        betaCnd[n] = betaCnd[n] + (beta[pindex] > 0.0 ? l1pen : (beta[pindex] == 0.0 ? 0.0 : -l1pen));
                    }
                    int n = pindex;
                    beta[n] = beta[n] - betaCnd[pindex];
                }
                for (int indC = 1; indC < numIcpt; ++indC) {
                    int indOffset = indC * predSizeP1;
                    for (int index = 0; index < predSize; ++index) {
                        beta[indOffset + index] = beta[index];
                    }
                }
                GLM.this._state.setActiveClass(-1);
            } while (this.progress(beta, GLM.this._state.gslvr().getGradient(beta)));
        }

        private void fitLSM(GLMModel.GLMParameters.Solver s) {
            long t0 = System.currentTimeMillis();
            ComputationState.GramXY gramXY = GLM.this._state.computeGram(GLM.this._state.beta(), s);
            Log.info((Object[])new Object[]{GLM.this.LogMsg("Gram computed in " + (System.currentTimeMillis() - t0) + "ms")});
            double[] beta = ((GLMModel.GLMParameters)GLM.this._parms)._solver == GLMModel.GLMParameters.Solver.COORDINATE_DESCENT ? GLM.this.COD_solve(gramXY, ((GLM)GLM.this)._state._alpha, GLM.this._state.lambda()) : this.ADMM_solve(gramXY.gram, gramXY.xy);
            double[] x = ArrayUtils.mmul((double[][])gramXY.gram.getXX(), (double[])beta);
            for (int i = 0; i < x.length; ++i) {
                x[i] = x[i] - 2.0 * gramXY.xy[i];
            }
            double l = 0.5 * (ArrayUtils.innerProduct((double[])x, (double[])beta) / ((GLMModel.GLMParameters)GLM.this._parms)._obj_reg + gramXY.yy);
            ++((GLM)GLM.this)._state._iter;
            GLM.this._state.updateState(beta, l);
        }

        private void fitIRLSM(GLMModel.GLMParameters.Solver s) {
            GLMModel.GLMWeightsFun glmw = new GLMModel.GLMWeightsFun((GLMModel.GLMParameters)GLM.this._parms);
            double[] betaCnd = GLM.this._state.beta();
            OptimizationUtils.LineSearchSolver ls = null;
            boolean firstIter = true;
            int iterCnt = 0;
            try {
                while (true) {
                    ++iterCnt;
                    long t1 = System.currentTimeMillis();
                    ComputationState.GramXY gram = GLM.this._state.computeGram(betaCnd, s);
                    long t2 = System.currentTimeMillis();
                    if (!((GLM)GLM.this)._state._lsNeeded && (Double.isNaN(gram.likelihood) || GLM.this._state.objective(gram.beta, gram.likelihood) > GLM.this._state.objective() + ((GLMModel.GLMParameters)GLM.this._parms)._objective_epsilon)) {
                        ((GLM)GLM.this)._state._lsNeeded = true;
                    } else {
                        if (!(firstIter || ((GLM)GLM.this)._state._lsNeeded || this.progress(gram.beta, gram.likelihood))) {
                            System.out.println("DONE after " + (iterCnt - 1) + " iterations (1)");
                            return;
                        }
                        betaCnd = s == GLMModel.GLMParameters.Solver.COORDINATE_DESCENT ? GLM.this.COD_solve(gram, ((GLM)GLM.this)._state._alpha, GLM.this._state.lambda()) : this.ADMM_solve(gram.gram, gram.xy);
                    }
                    firstIter = false;
                    long t3 = System.currentTimeMillis();
                    if (((GLM)GLM.this)._state._lsNeeded) {
                        if (ls == null) {
                            OptimizationUtils.LineSearchSolver lineSearchSolver = ls = GLM.this._state.l1pen() == 0.0 && !GLM.this._state.activeBC().hasBounds() ? new OptimizationUtils.MoreThuente(GLM.this._state.gslvr(), GLM.this._state.beta(), GLM.this._state.ginfo()) : new OptimizationUtils.SimpleBacktrackingLS(GLM.this._state.gslvr(), (double[])GLM.this._state.beta().clone(), GLM.this._state.l1pen(), GLM.this._state.ginfo());
                        }
                        if (!ls.evaluate(ArrayUtils.subtract((double[])betaCnd, (double[])ls.getX(), (double[])betaCnd))) {
                            Log.info((Object[])new Object[]{GLM.this.LogMsg("Ls failed " + ls)});
                            return;
                        }
                        betaCnd = ls.getX();
                        if (!this.progress(betaCnd, ls.ginfo())) {
                            return;
                        }
                        long t4 = System.currentTimeMillis();
                        Log.info((Object[])new Object[]{GLM.this.LogMsg("computed in " + (t2 - t1) + "+" + (t3 - t2) + "+" + (t4 - t3) + "=" + (t4 - t1) + "ms, step = " + ls.step() + (this._lslvr != null ? ", l1solver " + this._lslvr : ""))});
                        continue;
                    }
                    Log.info((Object[])new Object[]{GLM.this.LogMsg("computed in " + (t2 - t1) + "+" + (t3 - t2) + "=" + (t3 - t1) + "ms, step = " + 1 + (this._lslvr != null ? ", l1solver " + this._lslvr : ""))});
                }
            }
            catch (Gram.NonSPDMatrixException e) {
                Log.warn((Object[])new Object[]{GLM.this.LogMsg("Got Non SPD matrix, stopped.")});
                return;
            }
        }

        private void fitLBFGS() {
            double[] beta = GLM.this._state.beta();
            double l1pen = GLM.this._state.l1pen();
            GLMGradientSolver gslvr = GLM.this._state.gslvr();
            GLMModel.GLMWeightsFun glmw = new GLMModel.GLMWeightsFun((GLMModel.GLMParameters)GLM.this._parms);
            if (beta == null && (((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.multinomial || ((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.ordinal)) {
                beta = MemoryManager.malloc8d((int)((GLM.this._state.activeData().fullN() + 1) * GLM.this._nclass));
                int P = GLM.this._state.activeData().fullN() + 1;
                if (((GLMModel.GLMParameters)GLM.this._parms)._intercept) {
                    for (int i = 0; i < GLM.this._nclass; ++i) {
                        beta[i * P + P - 1] = glmw.link(((GLM)GLM.this)._state._ymu[i]);
                    }
                }
            }
            if (beta == null) {
                beta = MemoryManager.malloc8d((int)(GLM.this._state.activeData().fullN() + 1));
                if (((GLMModel.GLMParameters)GLM.this._parms)._intercept) {
                    beta[beta.length - 1] = glmw.link(((GLM)GLM.this)._state._ymu[0]);
                }
            }
            L_BFGS lbfgs = new L_BFGS().setObjEps(((GLMModel.GLMParameters)GLM.this._parms)._objective_epsilon).setGradEps(((GLMModel.GLMParameters)GLM.this._parms)._gradient_epsilon).setMaxIter(((GLMModel.GLMParameters)GLM.this._parms)._max_iterations);
            assert (beta.length == ((GLM)GLM.this)._state.ginfo()._gradient.length);
            int P = GLM.this._dinfo.fullN();
            if (l1pen > 0.0 || GLM.this._state.activeBC().hasBounds()) {
                double[] nullBeta = MemoryManager.malloc8d((int)beta.length);
                if (GLM.this._dinfo._intercept) {
                    if (((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.multinomial) {
                        for (int c = 0; c < GLM.this._nclass; ++c) {
                            nullBeta[(c + 1) * (P + 1) - 1] = glmw.link(((GLM)GLM.this)._state._ymu[c]);
                        }
                    } else {
                        nullBeta[nullBeta.length - 1] = glmw.link(((GLM)GLM.this)._state._ymu[0]);
                    }
                }
                GLMGradientInfo ginfo = gslvr.getGradient(nullBeta);
                double[] direction = ArrayUtils.mult((double[])((double[])ginfo._gradient.clone()), (double)-1.0);
                double t = 1.0;
                if (l1pen > 0.0) {
                    OptimizationUtils.MoreThuente mt = new OptimizationUtils.MoreThuente(gslvr, nullBeta);
                    mt.evaluate(direction);
                    t = mt.step();
                }
                double[] rho = MemoryManager.malloc8d((int)beta.length);
                double r = GLM.this._state.activeBC().hasBounds() ? 1.0 : 0.1;
                BetaConstraint bc = GLM.this._state.activeBC();
                for (int i = 0; i < rho.length - 1; ++i) {
                    rho[i] = r * ADMM.L1Solver.estimateRho(nullBeta[i] + t * direction[i], l1pen, bc._betaLB == null ? Double.NEGATIVE_INFINITY : bc._betaLB[i], bc._betaUB == null ? Double.POSITIVE_INFINITY : bc._betaUB[i]);
                }
                for (int ii = P; ii < rho.length; ii += P + 1) {
                    rho[ii] = r * ADMM.L1Solver.estimateRho(nullBeta[ii] + t * direction[ii], 0.0, bc._betaLB == null ? Double.NEGATIVE_INFINITY : bc._betaLB[ii], bc._betaUB == null ? Double.POSITIVE_INFINITY : bc._betaUB[ii]);
                }
                double[] objvals = new double[2];
                objvals[1] = Double.POSITIVE_INFINITY;
                double reltol = ADMM.L1Solver.DEFAULT_RELTOL;
                double abstol = ADMM.L1Solver.DEFAULT_ABSTOL;
                double ADMM_gradEps = 0.001;
                ProximalGradientSolver innerSolver = new ProximalGradientSolver(gslvr, beta, rho, ((GLMModel.GLMParameters)GLM.this._parms)._objective_epsilon * 0.1, ((GLMModel.GLMParameters)GLM.this._parms)._gradient_epsilon, GLM.this._state.ginfo(), this);
                ADMM.L1Solver l1Solver = new ADMM.L1Solver(ADMM_gradEps, 250, reltol, abstol, ((GLM)GLM.this)._state._u);
                l1Solver._pm = this;
                l1Solver.solve(innerSolver, beta, l1pen, true, ((GLM)GLM.this)._state.activeBC()._betaLB, ((GLM)GLM.this)._state.activeBC()._betaUB);
                ((GLM)GLM.this)._state._u = l1Solver._u;
                GLM.this._state.updateState(beta, gslvr.getGradient(beta));
            } else {
                if (!((GLMModel.GLMParameters)GLM.this._parms)._lambda_search && ((GLM)GLM.this)._state._iter == 0) {
                    this.updateProgress(false);
                }
                L_BFGS.Result r = lbfgs.solve(gslvr, beta, GLM.this._state.ginfo(), new L_BFGS.ProgressMonitor(){

                    @Override
                    public boolean progress(double[] beta, OptimizationUtils.GradientInfo ginfo) {
                        if (((GLM)GLM.this)._state._iter < 4 || (((GLM)GLM.this)._state._iter & 3) == 0) {
                            Log.info((Object[])new Object[]{GLM.this.LogMsg("LBFGS, gradient norm = " + ArrayUtils.linfnorm((double[])ginfo._gradient, (boolean)false))});
                        }
                        return GLMDriver.this.progress(beta, ginfo);
                    }
                });
                Log.info((Object[])new Object[]{GLM.this.LogMsg(r.toString())});
                GLM.this._state.updateState(r.coefs, (GLMGradientInfo)r.ginfo);
            }
        }

        private void fitCOD() {
            double[] beta = GLM.this._state.beta();
            int p = GLM.this._state.activeData().fullN() + 1;
            boolean skipFirstLevel = !((GLM)GLM.this)._state.activeData()._useAllFactorLevels;
            double[] betaold = (double[])beta.clone();
            double objold = GLM.this._state.objective();
            int iter2 = 0;
            Vec[] newVecs = ((GLM)GLM.this)._state.activeData()._adaptedFrame.anyVec().makeZeros(3);
            Vec w = newVecs[0];
            Vec z = newVecs[1];
            Vec zTilda = newVecs[2];
            long startTimeTotalNaive = System.currentTimeMillis();
            while (iter2++ < 30) {
                double percdiff;
                Frame fr = new Frame(((GLM)GLM.this)._state.activeData()._adaptedFrame);
                fr.add("w", w);
                fr.add("z", z);
                fr.add("zTilda", zTilda);
                GLMTask.GLMGenerateWeightsTask gt = (GLMTask.GLMGenerateWeightsTask)new GLMTask.GLMGenerateWeightsTask(GLM.this._job._key, GLM.this._state.activeData(), (GLMModel.GLMParameters)GLM.this._parms, beta).doAll(fr);
                double objVal = GLM.this.objVal(gt._likelihood, gt._betaw, GLM.this._state.lambda());
                double[] denums = gt.denums;
                double wsum = gt.wsum;
                double wsumu = gt.wsumu;
                int iter1 = 0;
                while (iter1++ < 100) {
                    boolean intercept;
                    Frame fr2 = new Frame(new Vec[0]);
                    fr2.add("w", w);
                    fr2.add("z", z);
                    fr2.add("zTilda", zTilda);
                    for (int i = 0; i < ((GLM)GLM.this)._state.activeData()._cats; ++i) {
                        Frame fr3 = new Frame(fr2);
                        int level_num = ((GLM)GLM.this)._state.activeData()._catOffsets[i + 1] - ((GLM)GLM.this)._state.activeData()._catOffsets[i];
                        int prev_level_num = 0;
                        fr3.add("xj", ((GLM)GLM.this)._state.activeData()._adaptedFrame.vec(i));
                        boolean bl = intercept = i == 0;
                        if (!intercept) {
                            prev_level_num = ((GLM)GLM.this)._state.activeData()._catOffsets[i] - ((GLM)GLM.this)._state.activeData()._catOffsets[i - 1];
                            fr3.add("xjm1", ((GLM)GLM.this)._state.activeData()._adaptedFrame.vec(i - 1));
                        }
                        int start_old = ((GLM)GLM.this)._state.activeData()._catOffsets[i];
                        GLMTask.GLMCoordinateDescentTaskSeqNaive stupdate = intercept ? (GLMTask.GLMCoordinateDescentTaskSeqNaive)new GLMTask.GLMCoordinateDescentTaskSeqNaive(intercept, false, 4, Arrays.copyOfRange(betaold, start_old, start_old + level_num), new double[]{beta[p - 1]}, ((GLM)GLM.this)._state.activeData()._catLvls[i], null, null, null, null, null, skipFirstLevel).doAll(fr3) : (GLMTask.GLMCoordinateDescentTaskSeqNaive)new GLMTask.GLMCoordinateDescentTaskSeqNaive(intercept, false, 1, Arrays.copyOfRange(betaold, start_old, start_old + level_num), Arrays.copyOfRange(beta, ((GLM)GLM.this)._state.activeData()._catOffsets[i - 1], ((GLM)GLM.this)._state.activeData()._catOffsets[i]), ((GLM)GLM.this)._state.activeData()._catLvls[i], ((GLM)GLM.this)._state.activeData()._catLvls[i - 1], null, null, null, null, skipFirstLevel).doAll(fr3);
                        for (int j = 0; j < level_num; ++j) {
                            beta[((GLM)GLM.this)._state.activeData()._catOffsets[i] + j] = ADMM.shrinkage(stupdate._temp[j] / wsumu, GLM.this._state.lambda() * ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]) / (denums[((GLM)GLM.this)._state.activeData()._catOffsets[i] + j] / wsumu + GLM.this._state.lambda() * (1.0 - ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]));
                        }
                    }
                    int cat_num = 2;
                    for (int i = 0; i < ((GLM)GLM.this)._state.activeData()._nums; ++i) {
                        GLMTask.GLMCoordinateDescentTaskSeqNaive stupdate;
                        Frame fr3 = new Frame(fr2);
                        fr3.add("xj", ((GLM)GLM.this)._state.activeData()._adaptedFrame.vec(i + ((GLM)GLM.this)._state.activeData()._cats));
                        intercept = i == 0 && GLM.this._state.activeData().numStart() == 0;
                        double[] meannew = null;
                        double[] meanold = null;
                        double[] varnew = null;
                        double[] varold = null;
                        if (i > 0 || intercept) {
                            cat_num = 3;
                            if (!intercept) {
                                fr3.add("xjm1", ((GLM)GLM.this)._state.activeData()._adaptedFrame.vec(i - 1 + ((GLM)GLM.this)._state.activeData()._cats));
                            }
                            if (((GLM)GLM.this)._state.activeData()._normMul != null) {
                                varold = new double[]{((GLM)GLM.this)._state.activeData()._normMul[i]};
                                meanold = new double[]{((GLM)GLM.this)._state.activeData()._normSub[i]};
                                if (i != 0) {
                                    varnew = new double[]{((GLM)GLM.this)._state.activeData()._normMul[i - 1]};
                                    meannew = new double[]{((GLM)GLM.this)._state.activeData()._normSub[i - 1]};
                                }
                            }
                            stupdate = (GLMTask.GLMCoordinateDescentTaskSeqNaive)new GLMTask.GLMCoordinateDescentTaskSeqNaive(intercept, false, cat_num, new double[]{betaold[GLM.this._state.activeData().numStart() + i]}, new double[]{beta[(GLM.this._state.activeData().numStart() + i - 1 + p) % p]}, null, null, varold, meanold, varnew, meannew, skipFirstLevel).doAll(fr3);
                            beta[i + ((GLM)GLM.this)._state.activeData().numStart()] = ADMM.shrinkage(stupdate._temp[0] / wsumu, GLM.this._state.lambda() * ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]) / (denums[i + GLM.this._state.activeData().numStart()] / wsumu + GLM.this._state.lambda() * (1.0 - ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]));
                            continue;
                        }
                        if (i != 0 || intercept) continue;
                        int prev_level_num = GLM.this._state.activeData().numStart() - ((GLM)GLM.this)._state.activeData()._catOffsets[((GLM)GLM.this)._state.activeData()._cats - 1];
                        fr3.add("xjm1", ((GLM)GLM.this)._state.activeData()._adaptedFrame.vec(((GLM)GLM.this)._state.activeData()._cats - 1));
                        if (((GLM)GLM.this)._state.activeData()._normMul != null) {
                            varold = new double[]{((GLM)GLM.this)._state.activeData()._normMul[i]};
                            meanold = new double[]{((GLM)GLM.this)._state.activeData()._normSub[i]};
                        }
                        stupdate = (GLMTask.GLMCoordinateDescentTaskSeqNaive)new GLMTask.GLMCoordinateDescentTaskSeqNaive(intercept, false, cat_num, new double[]{betaold[GLM.this._state.activeData().numStart()]}, Arrays.copyOfRange(beta, ((GLM)GLM.this)._state.activeData()._catOffsets[((GLM)GLM.this)._state.activeData()._cats - 1], GLM.this._state.activeData().numStart()), null, ((GLM)GLM.this)._state.activeData()._catLvls[((GLM)GLM.this)._state.activeData()._cats - 1], varold, meanold, null, null, skipFirstLevel).doAll(fr3);
                        beta[((GLM)GLM.this)._state.activeData().numStart()] = ADMM.shrinkage(stupdate._temp[0] / wsumu, GLM.this._state.lambda() * ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]) / (denums[GLM.this._state.activeData().numStart()] / wsumu + GLM.this._state.lambda() * (1.0 - ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]));
                    }
                    if (((GLM)GLM.this)._state.activeData()._nums + ((GLM)GLM.this)._state.activeData()._cats > 0) {
                        GLMTask.GLMCoordinateDescentTaskSeqNaive iupdate;
                        Frame fr3 = new Frame(fr2);
                        fr3.add("xjm1", ((GLM)GLM.this)._state.activeData()._adaptedFrame.vec(((GLM)GLM.this)._state.activeData()._cats + ((GLM)GLM.this)._state.activeData()._nums - 1));
                        if (((GLM)GLM.this)._state.activeData()._adaptedFrame.vec(((GLM)GLM.this)._state.activeData()._cats + ((GLM)GLM.this)._state.activeData()._nums - 1).isCategorical()) {
                            cat_num = 2;
                            iupdate = (GLMTask.GLMCoordinateDescentTaskSeqNaive)new GLMTask.GLMCoordinateDescentTaskSeqNaive(false, true, cat_num, new double[]{betaold[betaold.length - 1]}, Arrays.copyOfRange(beta, ((GLM)GLM.this)._state.activeData()._catOffsets[((GLM)GLM.this)._state.activeData()._cats - 1], ((GLM)GLM.this)._state.activeData()._catOffsets[((GLM)GLM.this)._state.activeData()._cats]), null, ((GLM)GLM.this)._state.activeData()._catLvls[((GLM)GLM.this)._state.activeData()._cats - 1], null, null, null, null, skipFirstLevel).doAll(fr3);
                        } else {
                            cat_num = 3;
                            double[] meannew = null;
                            double[] varnew = null;
                            if (((GLM)GLM.this)._state.activeData()._normMul != null) {
                                varnew = new double[]{((GLM)GLM.this)._state.activeData()._normMul[((GLM)GLM.this)._state.activeData()._normMul.length - 1]};
                                meannew = new double[]{((GLM)GLM.this)._state.activeData()._normSub[((GLM)GLM.this)._state.activeData()._normSub.length - 1]};
                            }
                            iupdate = (GLMTask.GLMCoordinateDescentTaskSeqNaive)new GLMTask.GLMCoordinateDescentTaskSeqNaive(false, true, cat_num, new double[]{betaold[betaold.length - 1]}, new double[]{beta[beta.length - 2]}, null, null, null, null, varnew, meannew, skipFirstLevel).doAll(fr3);
                        }
                        if (((GLMModel.GLMParameters)GLM.this._parms)._intercept) {
                            beta[beta.length - 1] = iupdate._temp[0] / wsum;
                        }
                    }
                    double maxdiff = ArrayUtils.linfnorm((double[])ArrayUtils.subtract((double[])beta, (double[])betaold), (boolean)false);
                    System.arraycopy(beta, 0, betaold, 0, beta.length);
                    if (!(maxdiff < ((GLMModel.GLMParameters)GLM.this._parms)._beta_epsilon)) continue;
                    break;
                }
                if ((percdiff = Math.abs((objold - objVal) / objold)) < ((GLMModel.GLMParameters)GLM.this._parms)._objective_epsilon & iter2 > 1) break;
                objold = objVal;
                System.out.println("iter1 = " + iter1);
            }
            System.out.println("iter2 = " + iter2);
            long endTimeTotalNaive = System.currentTimeMillis();
            long durationTotalNaive = (endTimeTotalNaive - startTimeTotalNaive) / 1000L;
            System.out.println("Time to run Naive Coordinate Descent " + durationTotalNaive);
            ((GLM)GLM.this)._state._iter = iter2;
            for (Vec v : newVecs) {
                v.remove();
            }
            GLM.this._state.updateState(beta, objold);
        }

        private void fitModel() {
            GLMModel.GLMParameters.Solver solver = ((GLMModel.GLMParameters)GLM.this._parms)._solver == GLMModel.GLMParameters.Solver.AUTO ? GLM.this.defaultSolver() : ((GLMModel.GLMParameters)GLM.this._parms)._solver;
            switch (solver) {
                case COORDINATE_DESCENT: 
                case IRLSM: {
                    if (((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.multinomial) {
                        this.fitIRLSM_multinomial(solver);
                        break;
                    }
                    if (((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.ordinal) {
                        this.fitIRLSM_ordinal_default(solver);
                        break;
                    }
                    if (((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.gaussian && ((GLMModel.GLMParameters)GLM.this._parms)._link == GLMModel.GLMParameters.Link.identity) {
                        this.fitLSM(solver);
                        break;
                    }
                    this.fitIRLSM(solver);
                    break;
                }
                case GRADIENT_DESCENT_LH: 
                case GRADIENT_DESCENT_SQERR: {
                    if (!((GLMModel.GLMParameters)GLM.this._parms)._family.equals((Object)GLMModel.GLMParameters.Family.ordinal)) break;
                    this.fitIRLSM_ordinal_default(solver);
                    break;
                }
                case L_BFGS: {
                    this.fitLBFGS();
                    break;
                }
                case COORDINATE_DESCENT_NAIVE: {
                    this.fitCOD();
                    break;
                }
                default: {
                    throw H2O.unimpl();
                }
            }
            if (((GLMModel.GLMParameters)GLM.this._parms)._compute_p_values) {
                double se = 1.0;
                boolean seEst = false;
                double[] beta = GLM.this._state.beta();
                if (((GLMModel.GLMParameters)GLM.this._parms)._family != GLMModel.GLMParameters.Family.binomial && ((GLMModel.GLMParameters)GLM.this._parms)._family != GLMModel.GLMParameters.Family.poisson) {
                    seEst = true;
                    GLMTask.ComputeSETsk ct = (GLMTask.ComputeSETsk)new GLMTask.ComputeSETsk(null, GLM.this._state.activeData(), GLM.this._job._key, beta, (GLMModel.GLMParameters)GLM.this._parms).doAll(((GLM)GLM.this)._state.activeData()._adaptedFrame);
                    se = ct._sumsqe / (double)(GLM.this._nobs - 1L - (long)GLM.this._state.activeData().fullN());
                }
                double[] zvalues = MemoryManager.malloc8d((int)(GLM.this._state.activeData().fullN() + 1));
                Gram.Cholesky chol = this._chol;
                if (((GLMModel.GLMParameters)GLM.this._parms)._standardize) {
                    DataInfo activeData = GLM.this._state.activeData();
                    double[] beta_nostd = activeData.denormalizeBeta(beta);
                    DataInfo.TransformType transform = activeData._predictor_transform;
                    activeData.setPredictorTransform(DataInfo.TransformType.NONE);
                    Gram g = ((GLMTask.GLMIterationTask)new GLMTask.GLMIterationTask((Key)GLM.this._job._key, (DataInfo)activeData, (GLMModel.GLMWeightsFun)new GLMModel.GLMWeightsFun((GLMModel.GLMParameters)((GLMModel.GLMParameters)GLM.this._parms)), (double[])beta_nostd).doAll((Frame)activeData._adaptedFrame))._gram;
                    activeData.setPredictorTransform(transform);
                    g.mul(((GLMModel.GLMParameters)GLM.this._parms)._obj_reg);
                    chol = g.cholesky(null);
                    beta = beta_nostd;
                }
                double[][] inv = chol.getInv();
                ArrayUtils.mult((double[][])inv, (double)(((GLMModel.GLMParameters)GLM.this._parms)._obj_reg * se));
                this._vcov = inv;
                for (int i = 0; i < zvalues.length; ++i) {
                    zvalues[i] = beta[i] / Math.sqrt(inv[i][i]);
                }
                GLM.this._model.setZValues(GLM.expandVec(zvalues, ((GLM)GLM.this)._state.activeData()._activeCols, GLM.this._dinfo.fullN() + 1, Double.NaN), se, seEst);
            }
        }

        private long timeSinceLastScoring() {
            return System.currentTimeMillis() - this._lastScore;
        }

        private void scoreAndUpdateModel() {
            Log.info((Object[])new Object[]{GLM.this.LogMsg("Scoring after " + this.timeSinceLastScoring() + "ms")});
            long t1 = System.currentTimeMillis();
            Frame train = (Frame)DKV.getGet((Key)((GLMModel.GLMParameters)GLM.this._parms)._train);
            GLM.this._model.score(train).delete();
            ModelMetrics mtrain = ModelMetrics.getFromDKV((Model)GLM.this._model, (Frame)train);
            long t2 = System.currentTimeMillis();
            if (mtrain != null) {
                ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._training_metrics = mtrain;
                Log.info((Object[])new Object[]{GLM.this.LogMsg(mtrain.toString())});
            } else {
                Log.info((Object[])new Object[]{GLM.this.LogMsg("ModelMetrics mtrain is null")});
            }
            Log.info((Object[])new Object[]{GLM.this.LogMsg("Training metrics computed in " + (t2 - t1) + "ms")});
            if (GLM.this._valid != null) {
                Frame valid = (Frame)DKV.getGet((Key)((GLMModel.GLMParameters)GLM.this._parms)._valid);
                GLM.this._model.score(valid).delete();
                ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._validation_metrics = ModelMetrics.getFromDKV((Model)GLM.this._model, (Frame)valid);
            }
            ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._scoring_history = ((GLMModel.GLMParameters)GLM.this._parms)._lambda_search ? GLM.this._lsc.to2dTable() : GLM.this._sc.to2dTable();
            GLM.this._model.update(GLM.this._job._key);
            GLM.this._model.generateSummary(((GLMModel.GLMParameters)GLM.this._parms)._train, ((GLM)GLM.this)._state._iter);
            this._lastScore = System.currentTimeMillis();
            long scoringTime = System.currentTimeMillis() - t1;
            this._scoringInterval = Math.max(this._scoringInterval, 20L * scoringTime);
        }

        protected GLMModel.Submodel computeSubmodel(int i, double lambda) {
            GLMModel.Submodel sm;
            if (lambda >= GLM.this._lmax && GLM.this._state.l1pen() > 0.0) {
                sm = new GLMModel.Submodel(lambda, GLM.this.getNullBeta(), ((GLM)GLM.this)._state._iter, this._nullDevTrain, this._nullDevTest);
                GLM.this._model.addSubmodel(sm);
            } else {
                sm = new GLMModel.Submodel(lambda, GLM.this._state.beta(), ((GLM)GLM.this)._state._iter, -1.0, -1.0);
                GLM.this._model.addSubmodel(sm);
                GLM.this._state.setLambda(lambda);
                GLM.this.checkMemoryFootPrint(GLM.this._state.activeData());
                do {
                    if (((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.multinomial || ((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.ordinal) {
                        for (int c = 0; c < GLM.this._nclass; ++c) {
                            Log.info((Object[])new Object[]{GLM.this.LogMsg("Class " + c + " got " + GLM.this._state.activeDataMultinomial(c).fullN() + " active columns out of " + ((GLM)GLM.this)._state._dinfo.fullN() + " total")});
                        }
                    } else {
                        Log.info((Object[])new Object[]{GLM.this.LogMsg("Got " + GLM.this._state.activeData().fullN() + " active columns out of " + ((GLM)GLM.this)._state._dinfo.fullN() + " total")});
                    }
                    this.fitModel();
                } while (!GLM.this._state.checkKKTs());
                Log.info((Object[])new Object[]{GLM.this.LogMsg("solution has " + ArrayUtils.countNonzeros((double[])GLM.this._state.beta()) + " nonzeros")});
                if (((GLMModel.GLMParameters)GLM.this._parms)._lambda_search) {
                    double trainDev = GLM.this._state.deviance() / (double)GLM.this._nobs;
                    double testDev = Double.NaN;
                    if (GLM.this._validDinfo != null) {
                        testDev = ((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.ordinal ? ((GLMTask.GLMResDevTaskOrdinal)new GLMTask.GLMResDevTaskOrdinal(GLM.this._job._key, GLM.this._validDinfo, GLM.this._dinfo.denormalizeBeta(GLM.this._state.beta()), GLM.this._nclass).doAll(((GLM)GLM.this)._validDinfo._adaptedFrame)).avgDev() : (((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.multinomial ? ((GLMTask.GLMResDevTaskMultinomial)new GLMTask.GLMResDevTaskMultinomial(GLM.this._job._key, GLM.this._validDinfo, GLM.this._dinfo.denormalizeBeta(GLM.this._state.beta()), GLM.this._nclass).doAll(((GLM)GLM.this)._validDinfo._adaptedFrame)).avgDev() : ((GLMTask.GLMResDevTask)new GLMTask.GLMResDevTask(GLM.this._job._key, GLM.this._validDinfo, (GLMModel.GLMParameters)GLM.this._parms, GLM.this._dinfo.denormalizeBeta(GLM.this._state.beta())).doAll(((GLM)GLM.this)._validDinfo._adaptedFrame)).avgDev());
                    }
                    Log.info((Object[])new Object[]{GLM.this.LogMsg("train deviance = " + trainDev + ", test deviance = " + testDev)});
                    double xvalDev = GLM.this._xval_test_deviances == null ? -1.0 : GLM.this._xval_test_deviances[i];
                    double xvalDevSE = GLM.this._xval_test_sd == null ? -1.0 : GLM.this._xval_test_sd[i];
                    GLM.this._lsc.addLambdaScore(((GLM)GLM.this)._state._iter, ArrayUtils.countNonzeros((double[])GLM.this._state.beta()), GLM.this._state.lambda(), trainDev, testDev, xvalDev, xvalDevSE);
                    sm = new GLMModel.Submodel(GLM.this._state.lambda(), GLM.this._state.beta(), ((GLM)GLM.this)._state._iter, trainDev, testDev);
                    GLM.this._model.updateSubmodel(sm);
                } else {
                    sm = new GLMModel.Submodel(lambda, GLM.this._state.beta(), ((GLM)GLM.this)._state._iter, -1.0, -1.0);
                    GLM.this._model.updateSubmodel(sm);
                }
            }
            GLM.this._model.update(GLM.this._job);
            return sm;
        }

        public void computeImpl() {
            if (GLM.this._doInit) {
                GLM.this.init(true);
            }
            if (GLM.this.error_count() > 0) {
                throw H2OModelBuilderIllegalArgumentException.makeFromBuilder((ModelBuilder)GLM.this);
            }
            ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._start_time = System.currentTimeMillis();
            if (((GLMModel.GLMParameters)GLM.this._parms)._lambda_search) {
                if (((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.ordinal) {
                    this._nullDevTrain = ((GLMTask.GLMResDevTaskOrdinal)new GLMTask.GLMResDevTaskOrdinal(GLM.this._job._key, ((GLM)GLM.this)._state._dinfo, GLM.this.getNullBeta(), GLM.this._nclass).doAll(((GLM)GLM.this)._state._dinfo._adaptedFrame)).avgDev();
                } else {
                    double d = this._nullDevTrain = ((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.multinomial ? ((GLMTask.GLMResDevTaskMultinomial)new GLMTask.GLMResDevTaskMultinomial(GLM.this._job._key, ((GLM)GLM.this)._state._dinfo, GLM.this.getNullBeta(), GLM.this._nclass).doAll(((GLM)GLM.this)._state._dinfo._adaptedFrame)).avgDev() : ((GLMTask.GLMResDevTask)new GLMTask.GLMResDevTask(GLM.this._job._key, ((GLM)GLM.this)._state._dinfo, (GLMModel.GLMParameters)GLM.this._parms, GLM.this.getNullBeta()).doAll(((GLM)GLM.this)._state._dinfo._adaptedFrame)).avgDev();
                }
                if (GLM.this._validDinfo != null) {
                    this._nullDevTest = ((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.ordinal ? ((GLMTask.GLMResDevTaskOrdinal)new GLMTask.GLMResDevTaskOrdinal(GLM.this._job._key, GLM.this._validDinfo, GLM.this.getNullBeta(), GLM.this._nclass).doAll(((GLM)GLM.this)._validDinfo._adaptedFrame)).avgDev() : (((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.multinomial ? ((GLMTask.GLMResDevTaskMultinomial)new GLMTask.GLMResDevTaskMultinomial(GLM.this._job._key, GLM.this._validDinfo, GLM.this.getNullBeta(), GLM.this._nclass).doAll(((GLM)GLM.this)._validDinfo._adaptedFrame)).avgDev() : ((GLMTask.GLMResDevTask)new GLMTask.GLMResDevTask(GLM.this._job._key, GLM.this._validDinfo, (GLMModel.GLMParameters)GLM.this._parms, GLM.this.getNullBeta()).doAll(((GLM)GLM.this)._validDinfo._adaptedFrame)).avgDev());
                }
                this._workPerIteration = 1000000L / (long)((GLMModel.GLMParameters)GLM.this._parms)._nlambdas;
            } else {
                this._workPerIteration = 1L + 1000000L / (long)((GLMModel.GLMParameters)GLM.this._parms)._max_iterations;
            }
            if ((((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.multinomial || ((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.ordinal) && ((GLMModel.GLMParameters)GLM.this._parms)._solver != GLMModel.GLMParameters.Solver.L_BFGS) {
                double[] nb = GLM.this.getNullBeta();
                double maxRow = ArrayUtils.maxValue((double[])nb);
                double sumExp = 0.0;
                if (((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.multinomial) {
                    int P = GLM.this._dinfo.fullN();
                    int N = GLM.this._dinfo.fullN() + 1;
                    for (int i = 1; i < GLM.this._nclass; ++i) {
                        sumExp += Math.exp(nb[i * N + P] - maxRow);
                    }
                }
                Vec[] vecs = GLM.this._dinfo._adaptedFrame.anyVec().makeDoubles(2, new double[]{sumExp, maxRow});
                if (((GLMModel.GLMParameters)GLM.this._parms)._lambda_search && ((GLMModel.GLMParameters)GLM.this._parms)._is_cv_model) {
                    Scope.untrack((Key[])new Key[]{vecs[0]._key, vecs[1]._key});
                    GLM.this.removeLater(new Key[]{vecs[0]._key, vecs[1]._key});
                }
                if (((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.ordinal) {
                    GLM.this._dinfo.addResponse(new String[]{"__glm_ExpC", "__glm_ExpNPC"}, vecs);
                } else {
                    GLM.this._dinfo.addResponse(new String[]{"__glm_sumExp", "__glm_maxRow"}, vecs);
                }
            }
            double oldDevTrain = this._nullDevTrain;
            double oldDevTest = this._nullDevTest;
            double[] devHistoryTrain = new double[5];
            double[] devHistoryTest = new double[5];
            if (!((GLMModel.GLMParameters)GLM.this._parms)._lambda_search) {
                this.updateProgress(false);
            }
            for (int i = 0; !(i >= ((GLMModel.GLMParameters)GLM.this._parms)._lambda.length || GLM.this._job.stop_requested() || GLM.this.timeout() && ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._submodels.length > 0 || ((GLMModel.GLMParameters)GLM.this._parms)._max_iterations != -1 && ((GLM)GLM.this)._state._iter >= ((GLMModel.GLMParameters)GLM.this._parms)._max_iterations); ++i) {
                GLMModel.Submodel sm = this.computeSubmodel(i, ((GLMModel.GLMParameters)GLM.this._parms)._lambda[i]);
                double trainDev = sm.devianceTrain;
                double testDev = sm.devianceTest;
                devHistoryTest[i % devHistoryTest.length] = (oldDevTest - testDev) / oldDevTest;
                oldDevTest = testDev;
                devHistoryTrain[i % devHistoryTrain.length] = (oldDevTrain - trainDev) / oldDevTrain;
                oldDevTrain = trainDev;
                if (((GLMModel.GLMParameters)GLM.this._parms)._lambda[i] < GLM.this._lmax && Double.isNaN(GLM.this._lambdaCVEstimate) && ((GLMModel.GLMParameters)GLM.this._parms)._early_stopping && ((GLM)GLM.this)._state._iter >= devHistoryTrain.length) {
                    double s = ArrayUtils.maxValue((double[])devHistoryTrain);
                    if (s < 1.0E-4) {
                        Log.info((Object[])new Object[]{GLM.this.LogMsg("converged at lambda[" + i + "] = " + ((GLMModel.GLMParameters)GLM.this._parms)._lambda[i] + ", improvement on train = " + s)});
                        break;
                    }
                    if (GLM.this._validDinfo != null && ((GLMModel.GLMParameters)GLM.this._parms)._nfolds <= 1 && (s = ArrayUtils.maxValue((double[])devHistoryTest)) < 0.0) {
                        Log.info((Object[])new Object[]{GLM.this.LogMsg("converged at lambda[" + i + "] = " + ((GLMModel.GLMParameters)GLM.this._parms)._lambda[i] + ", improvement on test = " + s)});
                        break;
                    }
                }
                if (((GLMModel.GLMParameters)GLM.this._parms)._lambda_search && (((GLMModel.GLMParameters)GLM.this._parms)._score_each_iteration || this.timeSinceLastScoring() > this._scoringInterval)) {
                    ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._best_lambda_idx = i;
                    ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output).setSubmodelIdx(((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._best_lambda_idx);
                    this.scoreAndUpdateModel();
                }
                GLM.this._job.update(this._workPerIteration, "iter=" + ((GLM)GLM.this)._state._iter + " lmb=" + lambdaFormatter.format(GLM.this._state.lambda()) + "deviance trn/tst= " + devFormatter.format(trainDev) + "/" + devFormatter.format(testDev) + " P=" + ArrayUtils.countNonzeros((double[])GLM.this._state.beta()));
            }
            if (GLM.this.stop_requested()) {
                if (GLM.this.timeout()) {
                    Log.info((Object[])new Object[]{"Stopping GLM training because of timeout"});
                } else {
                    throw new Job.JobCancelledException();
                }
            }
            if (((GLM)GLM.this)._state._iter >= ((GLMModel.GLMParameters)GLM.this._parms)._max_iterations) {
                GLM.this._job.warn("Reached maximum number of iterations " + ((GLMModel.GLMParameters)GLM.this._parms)._max_iterations + "!");
            }
            if (((GLMModel.GLMParameters)GLM.this._parms)._nfolds > 1 && !Double.isNaN(GLM.this._lambdaCVEstimate)) {
                ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output).setSubmodel(GLM.this._lambdaCVEstimate);
            } else {
                ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output).pickBestModel();
            }
            this.scoreAndUpdateModel();
            if (this._vcov != null) {
                GLM.this._model.setVcov(this._vcov);
                GLM.this._model.update(GLM.this._job._key);
            }
            if (!((GLMModel.GLMParameters)GLM.this._parms)._lambda_search && ((GLM)GLM.this)._state._iter < ((GLMModel.GLMParameters)GLM.this._parms)._max_iterations) {
                GLM.this._job.update(this._workPerIteration * (long)(((GLMModel.GLMParameters)GLM.this._parms)._max_iterations - ((GLM)GLM.this)._state._iter));
            }
            if (GLM.this._iceptAdjust != 0.0) {
                assert (((GLMModel.GLMParameters)GLM.this._parms)._intercept);
                double[] b = ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._global_beta;
                int n = b.length - 1;
                b[n] = b[n] + GLM.this._iceptAdjust;
                for (GLMModel.Submodel sm : ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._submodels) {
                    int n2 = sm.beta.length - 1;
                    sm.beta[n2] = sm.beta[n2] + GLM.this._iceptAdjust;
                }
                GLM.this._model.update(GLM.this._job._key);
            }
            this.doCleanup();
        }

        public boolean onExceptionalCompletion(Throwable t, CountedCompleter caller) {
            this.doCleanup();
            return true;
        }

        @Override
        public boolean progress(double[] beta, OptimizationUtils.GradientInfo ginfo) {
            boolean converged;
            ++((GLM)GLM.this)._state._iter;
            if (ginfo instanceof ProximalGradientInfo) {
                ginfo = ((ProximalGradientInfo)ginfo)._origGinfo;
                GLMGradientInfo gginfo = (GLMGradientInfo)ginfo;
                GLM.this._state.updateState(beta, gginfo);
                if (!((GLMModel.GLMParameters)GLM.this._parms)._lambda_search) {
                    this.updateProgress(false);
                }
                return !GLM.this.stop_requested() && ((GLM)GLM.this)._state._iter < ((GLMModel.GLMParameters)GLM.this._parms)._max_iterations;
            }
            GLMGradientInfo gginfo = (GLMGradientInfo)ginfo;
            if (gginfo._gradient == null) {
                GLM.this._state.updateState(beta, gginfo._likelihood);
            } else {
                GLM.this._state.updateState(beta, gginfo);
            }
            if (!((GLMModel.GLMParameters)GLM.this._parms)._lambda_search) {
                this.updateProgress(true);
            }
            if (converged = GLM.this._state.converged()) {
                Log.info((Object[])new Object[]{GLM.this.LogMsg(((GLM)GLM.this)._state.convergenceMsg)});
            }
            return !GLM.this.stop_requested() && !converged && ((GLM)GLM.this)._state._iter < ((GLMModel.GLMParameters)GLM.this._parms)._max_iterations;
        }

        public boolean progress(double[] beta, double likelihood) {
            boolean converged;
            ++((GLM)GLM.this)._state._iter;
            GLM.this._state.updateState(beta, likelihood);
            if (!((GLMModel.GLMParameters)GLM.this._parms)._lambda_search) {
                this.updateProgress(true);
            }
            if (converged = GLM.this._state.converged()) {
                Log.info((Object[])new Object[]{GLM.this.LogMsg(((GLM)GLM.this)._state.convergenceMsg)});
            }
            return !GLM.this.stop_requested() && !converged && ((GLM)GLM.this)._state._iter < ((GLMModel.GLMParameters)GLM.this._parms)._max_iterations;
        }

        protected void updateProgress(boolean canScore) {
            assert (!((GLMModel.GLMParameters)GLM.this._parms)._lambda_search);
            GLM.this._sc.addIterationScore(((GLM)GLM.this)._state._iter, GLM.this._state.likelihood(), GLM.this._state.objective());
            GLM.this._job.update(this._workPerIteration, GLM.this._state.toString());
            if (canScore && (((GLMModel.GLMParameters)GLM.this._parms)._score_each_iteration || this.timeSinceLastScoring() > this._scoringInterval)) {
                GLM.this._model.update(GLM.this._state.expandBeta(GLM.this._state.beta()), -1.0, -1.0, ((GLM)GLM.this)._state._iter);
                this.scoreAndUpdateModel();
            }
        }
    }

    private static class LambdaSearchScoringHistory {
        ArrayList<Long> _scoringTimes = new ArrayList();
        private ArrayList<Double> _lambdas = new ArrayList();
        private ArrayList<Integer> _lambdaIters = new ArrayList();
        private ArrayList<Integer> _lambdaPredictors = new ArrayList();
        private ArrayList<Double> _lambdaDevTrain = new ArrayList();
        private ArrayList<Double> _lambdaDevTest;
        private ArrayList<Double> _lambdaDevXval;
        private ArrayList<Double> _lambdaDevXvalSE;

        public LambdaSearchScoringHistory(boolean hasTest, boolean hasXval) {
            if (!hasTest) {
                // empty if block
            }
            this._lambdaDevTest = new ArrayList();
            if (hasXval) {
                this._lambdaDevXval = new ArrayList();
                this._lambdaDevXvalSE = new ArrayList();
            }
        }

        public synchronized void addLambdaScore(int iter, int predictors, double lambda, double devRatioTrain, double devRatioTest, double devRatioXval, double devRatoioXvalSE) {
            this._scoringTimes.add(System.currentTimeMillis());
            this._lambdaIters.add(iter);
            this._lambdas.add(lambda);
            this._lambdaPredictors.add(predictors);
            this._lambdaDevTrain.add(devRatioTrain);
            if (this._lambdaDevTest != null) {
                this._lambdaDevTest.add(devRatioTest);
            }
            if (this._lambdaDevXval != null) {
                this._lambdaDevXval.add(devRatioXval);
            }
            if (this._lambdaDevXvalSE != null) {
                this._lambdaDevXvalSE.add(devRatoioXvalSE);
            }
        }

        public synchronized TwoDimTable to2dTable() {
            Object[] cnames = new String[]{"timestamp", "duration", "iteration", "lambda", "predictors", "deviance_train"};
            if (this._lambdaDevTest != null) {
                cnames = (String[])ArrayUtils.append((Object[])cnames, (Object[])new String[]{"deviance_test"});
            }
            if (this._lambdaDevXval != null) {
                cnames = ArrayUtils.append((String[])cnames, (String[])new String[]{"deviance_xval", "deviance_se"});
            }
            Object[] ctypes = new String[]{"string", "string", "int", "string", "int", "double"};
            if (this._lambdaDevTest != null) {
                ctypes = (String[])ArrayUtils.append((Object[])ctypes, (Object[])new String[]{"double"});
            }
            if (this._lambdaDevXval != null) {
                ctypes = ArrayUtils.append((String[])ctypes, (String[])new String[]{"double", "double"});
            }
            Object[] cformats = new String[]{"%s", "%s", "%d", "%s", "%d", "%.3f"};
            if (this._lambdaDevTest != null) {
                cformats = (String[])ArrayUtils.append((Object[])cformats, (Object[])new String[]{"%.3f"});
            }
            if (this._lambdaDevXval != null) {
                cformats = ArrayUtils.append((String[])cformats, (String[])new String[]{"%.3f", "%.3f"});
            }
            TwoDimTable res = new TwoDimTable("Scoring History", "", new String[this._lambdaIters.size()], (String[])cnames, (String[])ctypes, (String[])cformats, "");
            boolean j = false;
            DateTimeFormatter fmt = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
            for (int i = 0; i < this._lambdaIters.size(); ++i) {
                int col = 0;
                res.set(i, col++, (Object)fmt.print(this._scoringTimes.get(i).longValue()));
                res.set(i, col++, (Object)PrettyPrint.msecs((long)(this._scoringTimes.get(i) - this._scoringTimes.get(0)), (boolean)true));
                res.set(i, col++, (Object)this._lambdaIters.get(i));
                res.set(i, col++, (Object)lambdaFormatter.format(this._lambdas.get(i)));
                res.set(i, col++, (Object)this._lambdaPredictors.get(i));
                res.set(i, col++, (Object)this._lambdaDevTrain.get(i));
                if (this._lambdaDevTest != null && this._lambdaDevTest.size() > i) {
                    res.set(i, col++, (Object)this._lambdaDevTest.get(i));
                }
                if (this._lambdaDevXval == null || this._lambdaDevXval.size() <= i) continue;
                res.set(i, col++, (Object)this._lambdaDevXval.get(i));
                res.set(i, col++, (Object)this._lambdaDevXvalSE.get(i));
            }
            return res;
        }
    }

    private static class ScoringHistory {
        private ArrayList<Integer> _scoringIters = new ArrayList();
        private ArrayList<Long> _scoringTimes = new ArrayList();
        private ArrayList<Double> _likelihoods = new ArrayList();
        private ArrayList<Double> _objectives = new ArrayList();

        private ScoringHistory() {
        }

        public synchronized void addIterationScore(int iter, double likelihood, double obj) {
            if (this._scoringIters.size() > 0 && this._scoringIters.get(this._scoringIters.size() - 1) == iter) {
                return;
            }
            this._scoringIters.add(iter);
            this._scoringTimes.add(System.currentTimeMillis());
            this._likelihoods.add(likelihood);
            this._objectives.add(obj);
        }

        public synchronized TwoDimTable to2dTable() {
            String[] cnames = new String[]{"timestamp", "duration", "iterations", "negative_log_likelihood", "objective"};
            String[] ctypes = new String[]{"string", "string", "int", "double", "double"};
            String[] cformats = new String[]{"%s", "%s", "%d", "%.5f", "%.5f"};
            TwoDimTable res = new TwoDimTable("Scoring History", "", new String[this._scoringIters.size()], cnames, ctypes, cformats, "");
            boolean j = false;
            DateTimeFormatter fmt = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
            for (int i = 0; i < this._scoringIters.size(); ++i) {
                int col = 0;
                res.set(i, col++, (Object)fmt.print(this._scoringTimes.get(i).longValue()));
                res.set(i, col++, (Object)PrettyPrint.msecs((long)(this._scoringTimes.get(i) - this._scoringTimes.get(0)), (boolean)true));
                res.set(i, col++, (Object)this._scoringIters.get(i));
                res.set(i, col++, (Object)this._likelihoods.get(i));
                res.set(i, col++, (Object)this._objectives.get(i));
            }
            return res;
        }
    }

    static class TooManyPredictorsException
    extends RuntimeException {
        TooManyPredictorsException() {
        }
    }
}

