/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.isofor;

import hex.CustomMetric;
import hex.Model;
import hex.ModelMetrics;
import hex.ModelMetricsUnsupervised;
import hex.ScoreKeeper;
import water.fvec.Frame;

public class ModelMetricsAnomaly
extends ModelMetricsUnsupervised
implements ScoreKeeper.ScoreKeeperAware {
    public final double _mean_score;
    public final double _mean_normalized_score;

    public ModelMetricsAnomaly(Model model, Frame frame, CustomMetric customMetric, long nobs, double totalScore, double totalNormScore, String description) {
        super(model, frame, nobs, description, customMetric);
        this._mean_score = totalScore / (double)nobs;
        this._mean_normalized_score = totalNormScore / (double)nobs;
    }

    public void fillTo(ScoreKeeper sk) {
        sk._anomaly_score = this._mean_score;
        sk._anomaly_score_normalized = this._mean_normalized_score;
    }

    protected StringBuilder appendToStringMetrics(StringBuilder sb) {
        sb.append(" Number of Observations: ").append(this._nobs).append("\n");
        sb.append(" Mean Anomaly Score: ").append(this._mean_score).append("\n");
        sb.append(" Mean Normalized Anomaly Score: ").append(this._mean_normalized_score).append("\n");
        return sb;
    }

    public static class MetricBuilderAnomaly
    extends ModelMetricsUnsupervised.MetricBuilderUnsupervised<MetricBuilderAnomaly> {
        private transient String _description;
        private double _total_score = 0.0;
        private double _total_norm_score = 0.0;
        private long _nobs = 0L;

        public MetricBuilderAnomaly(String description) {
            this._work = new double[2];
            this._description = description;
        }

        public double[] perRow(double[] preds, float[] dataRow, Model m) {
            if (preds[0] < 0.0) {
                return preds;
            }
            this._total_norm_score += preds[0];
            this._total_score += preds[1];
            ++this._nobs;
            return preds;
        }

        public void reduce(MetricBuilderAnomaly mb) {
            this._total_score += mb._total_score;
            this._total_norm_score += mb._total_norm_score;
            this._nobs += mb._nobs;
            super.reduce((ModelMetrics.MetricBuilder)mb);
        }

        public ModelMetrics makeModelMetrics(Model m, Frame f, Frame adaptedFrame, Frame preds) {
            return m.addModelMetrics((ModelMetrics)new ModelMetricsAnomaly(m, f, this._customMetric, this._nobs, this._total_score, this._total_norm_score, this._description));
        }
    }
}

