/*
 * Decompiled with CFR 0.152.
 */
package hex.deeplearning;

import hex.CustomMetric;
import hex.DataInfo;
import hex.DistributionFactory;
import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.ModelMetricsAutoEncoder;
import hex.ModelMetricsBinomial;
import hex.ModelMetricsMultinomial;
import hex.ModelMetricsRegression;
import hex.ModelMetricsSupervised;
import hex.ScoreKeeper;
import hex.ScoringInfo;
import hex.ToEigenVec;
import hex.VarImp;
import hex.deeplearning.DeepLearning;
import hex.deeplearning.DeepLearningModelInfo;
import hex.deeplearning.DeepLearningMojoWriter;
import hex.deeplearning.DeepLearningScoringInfo;
import hex.deeplearning.DeepLearningTask;
import hex.deeplearning.Neurons;
import hex.deeplearning.Storage;
import hex.genmodel.utils.DistributionFamily;
import hex.quantile.Quantile;
import hex.quantile.QuantileModel;
import hex.util.LinearAlgebraUtils;
import java.lang.reflect.Field;
import java.util.Arrays;
import water.AutoBuffer;
import water.DKV;
import water.Freezable;
import water.Futures;
import water.H2O;
import water.H2ONode;
import water.Iced;
import water.IcedUtils;
import water.Job;
import water.Key;
import water.Keyed;
import water.MRTask;
import water.Scope;
import water.codegen.CodeGenerator;
import water.codegen.CodeGeneratorPipeline;
import water.exceptions.H2OIllegalArgumentException;
import water.exceptions.JCodeSB;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.udf.CFuncRef;
import water.util.ArrayUtils;
import water.util.JCodeGen;
import water.util.Log;
import water.util.MathUtils;
import water.util.PrettyPrint;
import water.util.SBPrintStream;
import water.util.Timer;
import water.util.TwoDimTable;

public class DeepLearningModel
extends Model<DeepLearningModel, DeepLearningParameters, DeepLearningModelOutput>
implements Model.DeepFeatures {
    private volatile DeepLearningModelInfo model_info;
    public long total_checkpointed_run_time_ms;
    public long total_training_time_ms;
    public long total_scoring_time_ms;
    public long total_setup_time_ms;
    private long time_of_start_ms;
    public long actual_train_samples_per_iteration;
    public double time_for_communication_us;
    public double epoch_counter;
    public int iterations;
    public boolean stopped_early;
    public long training_rows;
    public long validation_rows;
    private float _bestLoss = Float.POSITIVE_INFINITY;
    public Key actual_best_model_key;
    public Key model_info_key;
    public long _timeLastIterationEnter;
    public long _timeLastScoreStart;
    private long _timeLastScoreEnd;
    private long _timeLastPrintStart;
    private final String unstable_msg = H2O.technote((int)4, (String)"\n\nTrying to predict with an unstable model.\nJob was aborted due to observed numerical instability (exponential growth).\nEither the weights or the bias values are unreasonably large or lead to large activation values.\nTry a different initial distribution, a bounded activation function (Tanh), adding regularization\n(via max_w2, l1, l2, dropout) or learning rate (either enable adaptive_rate or use a smaller learning rate or faster annealing).");

    public ToEigenVec getToEigenVec() {
        return LinearAlgebraUtils.toEigen;
    }

    void set_model_info(DeepLearningModelInfo mi) {
        assert (mi != null);
        this.model_info = mi;
    }

    public final DeepLearningModelInfo model_info() {
        return this.model_info;
    }

    public final VarImp varImp() {
        return ((DeepLearningModelOutput)this._output).errors.variable_importances;
    }

    public DeepLearningScoringInfo last_scored() {
        return (DeepLearningScoringInfo)super.last_scored();
    }

    public final DeepLearningParameters get_params() {
        return this.model_info.get_params();
    }

    public ModelMetrics.MetricBuilder makeMetricBuilder(String[] domain) {
        switch (((DeepLearningModelOutput)this._output).getModelCategory()) {
            case Binomial: {
                return new ModelMetricsBinomial.MetricBuilderBinomial(domain);
            }
            case Multinomial: {
                return new ModelMetricsMultinomial.MetricBuilderMultinomial(((DeepLearningModelOutput)this._output).nclasses(), domain);
            }
            case Regression: {
                return new ModelMetricsRegression.MetricBuilderRegression();
            }
            case AutoEncoder: {
                return new ModelMetricsAutoEncoder.MetricBuilderAutoEncoder(((DeepLearningModelOutput)this._output).nfeatures());
            }
        }
        throw H2O.unimpl((String)("Invalid ModelCategory " + ((DeepLearningModelOutput)this._output).getModelCategory()));
    }

    private void makeWeightsBiases(Key destKey) {
        if (!this.model_info.get_params()._export_weights_and_biases) {
            ((DeepLearningModelOutput)this._output).weights = null;
            ((DeepLearningModelOutput)this._output).biases = null;
            ((DeepLearningModelOutput)this._output).normmul = null;
            ((DeepLearningModelOutput)this._output).normsub = null;
            ((DeepLearningModelOutput)this._output).normrespmul = null;
            ((DeepLearningModelOutput)this._output).normrespsub = null;
            ((DeepLearningModelOutput)this._output).catoffsets = null;
        } else {
            int i;
            ((DeepLearningModelOutput)this._output).weights = new Key[this.get_params()._hidden.length + 1];
            for (i = 0; i < ((DeepLearningModelOutput)this._output).weights.length; ++i) {
                ((DeepLearningModelOutput)this._output).weights[i] = Key.make((String)(destKey + ".weights." + i));
            }
            ((DeepLearningModelOutput)this._output).biases = new Key[this.get_params()._hidden.length + 1];
            for (i = 0; i < ((DeepLearningModelOutput)this._output).biases.length; ++i) {
                ((DeepLearningModelOutput)this._output).biases[i] = Key.make((String)(destKey + ".biases." + i));
            }
            ((DeepLearningModelOutput)this._output).normmul = this.model_info.data_info._normMul;
            ((DeepLearningModelOutput)this._output).normsub = this.model_info.data_info._normSub;
            ((DeepLearningModelOutput)this._output).normrespmul = this.model_info.data_info._normRespMul;
            ((DeepLearningModelOutput)this._output).normrespsub = this.model_info.data_info._normRespSub;
            ((DeepLearningModelOutput)this._output).catoffsets = this.model_info.data_info._catOffsets;
        }
    }

    public DeepLearningModel(Key destKey, DeepLearningParameters parms, DeepLearningModel cp, boolean store_best_model, DataInfo dataInfo) {
        super(destKey, (Model.Parameters)(parms == null ? (DeepLearningParameters)((DeepLearningParameters)cp._parms).clone() : parms), (Model.Output)((DeepLearningModelOutput)((DeepLearningModelOutput)cp._output).clone()));
        assert (this._parms != cp._parms);
        this.model_info = (DeepLearningModelInfo)IcedUtils.deepCopy((Iced)cp.model_info);
        if (store_best_model) {
            this.model_info.data_info = (DataInfo)IcedUtils.deepCopy((Iced)dataInfo);
        } else {
            this.model_info.data_info = dataInfo;
            if (parms != null) {
                assert (this._parms == parms);
                assert (((DeepLearningParameters)this._parms)._checkpoint == parms._checkpoint);
                assert (((DeepLearningParameters)this._parms)._checkpoint == cp._key);
            }
        }
        assert (this.get_params() != cp.model_info().get_params());
        this._dist = DistributionFactory.getDistribution((Model.Parameters)this.get_params());
        assert (this._dist._family != DistributionFamily.AUTO);
        this.actual_best_model_key = cp.actual_best_model_key;
        if (this.actual_best_model_key.get() == null) {
            DeepLearningModel best = (DeepLearningModel)IcedUtils.deepCopy((Iced)cp);
            this.actual_best_model_key = Key.make((H2ONode)H2O.SELF);
            DKV.put((Key)this.actual_best_model_key, (Iced)best);
        }
        this.time_of_start_ms = cp.time_of_start_ms;
        this.total_training_time_ms = cp.total_training_time_ms;
        this.total_checkpointed_run_time_ms = cp.total_training_time_ms;
        this.total_scoring_time_ms = cp.total_scoring_time_ms;
        this.total_setup_time_ms = cp.total_setup_time_ms;
        this.training_rows = cp.training_rows;
        this.validation_rows = cp.validation_rows;
        this._bestLoss = cp._bestLoss;
        this.epoch_counter = cp.epoch_counter;
        this.iterations = cp.iterations;
        this.scoringInfo = (ScoringInfo[])cp.scoringInfo.clone();
        for (int i = 0; i < this.scoringInfo.length; ++i) {
            this.scoringInfo[i] = (ScoringInfo)IcedUtils.deepCopy((Iced)cp.scoringInfo[i]);
        }
        ((DeepLearningModelOutput)this._output).errors = this.last_scored();
        this.makeWeightsBiases(destKey);
        ((DeepLearningModelOutput)this._output)._scoring_history = DeepLearningScoringInfo.createScoringHistoryTable((ScoringInfo[])this.scoringInfo, (null != this.get_params()._valid ? 1 : 0) != 0, (boolean)false, (ModelCategory)((DeepLearningModelOutput)this._output).getModelCategory(), (boolean)((DeepLearningModelOutput)this._output).isAutoencoder());
        ((DeepLearningModelOutput)this._output)._variable_importances = ModelMetrics.calcVarImp((VarImp)this.last_scored().variable_importances);
        ((DeepLearningModelOutput)this._output).setNames(dataInfo._adaptedFrame.names(), dataInfo._adaptedFrame.typesStr());
        ((DeepLearningModelOutput)this._output)._domains = dataInfo._adaptedFrame.domains();
        assert (Arrays.equals(this._key._kb, destKey._kb));
    }

    public DeepLearningModel(Key destKey, DeepLearningParameters parms, DeepLearningModelOutput output, Frame train, Frame valid, int nClasses) {
        super(destKey, (Model.Parameters)parms, (Model.Output)output);
        DataInfo dinfo = DeepLearning.makeDataInfo(train, valid, (DeepLearningParameters)this._parms, nClasses);
        DKV.put((Keyed)dinfo);
        ((DeepLearningModelOutput)this._output).setNames(dinfo._adaptedFrame.names(), dinfo._adaptedFrame.typesStr());
        ((DeepLearningModelOutput)this._output)._domains = dinfo._adaptedFrame.domains();
        ((DeepLearningModelOutput)this._output)._origNames = ((Frame)parms._train.get()).names();
        ((DeepLearningModelOutput)this._output)._origDomains = ((Frame)parms._train.get()).domains();
        Log.info((Object[])new Object[]{"Building the model on " + dinfo.numNums() + " numeric features and " + dinfo.numCats() + " (one-hot encoded) categorical features."});
        this.model_info = new DeepLearningModelInfo(parms, destKey, dinfo, nClasses, train, valid);
        this.model_info_key = Key.make((H2ONode)H2O.SELF);
        this._dist = DistributionFactory.getDistribution((Model.Parameters)this.get_params());
        assert (this._dist._family != DistributionFamily.AUTO);
        this.actual_best_model_key = Key.make((H2ONode)H2O.SELF);
        if (parms._nfolds != 0) {
            this.actual_best_model_key = null;
        }
        if (!parms._autoencoder) {
            this.scoringInfo = new DeepLearningScoringInfo[1];
            this.scoringInfo[0] = new DeepLearningScoringInfo();
            this.scoringInfo[0].validation = parms._valid != null;
            this.scoringInfo[0].time_stamp_ms = System.currentTimeMillis();
            ((DeepLearningModelOutput)this._output).errors = this.last_scored();
            ((DeepLearningModelOutput)this._output)._scoring_history = DeepLearningScoringInfo.createScoringHistoryTable((ScoringInfo[])this.scoringInfo, (null != this.get_params()._valid ? 1 : 0) != 0, (boolean)false, (ModelCategory)((DeepLearningModelOutput)this._output).getModelCategory(), (boolean)((DeepLearningModelOutput)this._output).isAutoencoder());
            ((DeepLearningModelOutput)this._output)._variable_importances = ModelMetrics.calcVarImp((VarImp)this.last_scored().variable_importances);
        }
        this.time_of_start_ms = System.currentTimeMillis();
        this.makeWeightsBiases(destKey);
        assert (this._key.equals((Object)destKey));
        boolean fail = false;
        long byte_size = 0L;
        try {
            byte_size = new AutoBuffer().put((Freezable)this).buf().length;
        }
        catch (Throwable t) {
            fail = true;
        }
        if (byte_size > Integer.MAX_VALUE || fail) {
            throw new IllegalArgumentException(H2O.technote((int)5, (String)"Model is too large"));
        }
    }

    private void checkTimingConsistency() {
        assert (this.total_scoring_time_ms <= this.total_training_time_ms);
        assert (this.total_setup_time_ms <= this.total_training_time_ms);
        assert (this.total_setup_time_ms + this.total_scoring_time_ms <= this.total_training_time_ms);
        assert (this.total_training_time_ms >= this.total_checkpointed_run_time_ms);
        assert (this.total_checkpointed_run_time_ms >= 0L);
        assert (this.total_training_time_ms >= 0L);
        assert (this.total_scoring_time_ms >= 0L);
    }

    void updateTiming(Key<Job> job_key) {
        long now = System.currentTimeMillis();
        long start_time_current_model = ((Job)job_key.get()).start_time();
        this.total_training_time_ms = this.total_checkpointed_run_time_ms + (now - start_time_current_model);
        this.checkTimingConsistency();
    }

    boolean doScoring(Frame fTrain, Frame fValid, Key<Job> jobKey, int iteration, boolean finalScoring) {
        long now = System.currentTimeMillis();
        double time_since_last_iter = now - this._timeLastIterationEnter;
        this.updateTiming(jobKey);
        this._timeLastIterationEnter = now;
        this.epoch_counter = (double)this.model_info().get_processed_total() / (double)this.training_rows;
        if (H2O.CLOUD.size() > 1 && this.get_params()._train_samples_per_iteration == -2L && iteration > 1) {
            Log.debug((Object[])new Object[]{"Auto-tuning train_samples_per_iteration."});
            if (this.time_for_communication_us > 10000.0) {
                Log.debug((Object[])new Object[]{"  Time taken for communication: " + PrettyPrint.usecs((long)((long)this.time_for_communication_us))});
                Log.debug((Object[])new Object[]{"  Time taken for Map/Reduce iteration: " + PrettyPrint.msecs((long)((long)time_since_last_iter), (boolean)true)});
                double comm_to_work_ratio = this.time_for_communication_us * 0.001 / time_since_last_iter;
                Log.debug((Object[])new Object[]{"  Ratio of network communication to computation: " + String.format("%.5f", comm_to_work_ratio)});
                Log.debug((Object[])new Object[]{"  target_comm_to_work: " + this.get_params()._target_ratio_comm_to_comp});
                Log.debug((Object[])new Object[]{"Old value of train_samples_per_iteration: " + this.actual_train_samples_per_iteration});
                double correction = this.get_params()._target_ratio_comm_to_comp / comm_to_work_ratio;
                correction = Math.max(0.5, Math.min(2.0, correction));
                if (Math.abs(correction) < 0.8 || Math.abs(correction) > 1.2) {
                    this.actual_train_samples_per_iteration = (long)((double)this.actual_train_samples_per_iteration / correction);
                    this.actual_train_samples_per_iteration = Math.max(1L, this.actual_train_samples_per_iteration);
                    Log.debug((Object[])new Object[]{"New value of train_samples_per_iteration: " + this.actual_train_samples_per_iteration});
                } else {
                    Log.debug((Object[])new Object[]{"Keeping value of train_samples_per_iteration the same (would deviate too little from previous value): " + this.actual_train_samples_per_iteration});
                }
            } else {
                Log.debug((Object[])new Object[]{"Communication is faster than 10 ms. Not modifying train_samples_per_iteration: " + this.actual_train_samples_per_iteration});
            }
        }
        boolean keep_running = this.epoch_counter < this.get_params()._epochs && !this.stopped_early;
        long sinceLastScore = now - this._timeLastScoreStart;
        if (!keep_running || this.get_params()._score_each_iteration || (double)sinceLastScore > this.get_params()._score_interval * 1000.0 && (double)(this._timeLastScoreEnd - this._timeLastScoreStart) / (double)sinceLastScore < this.get_params()._score_duty_cycle) {
            ((Job)jobKey.get()).update(0L, "Scoring on " + fTrain.numRows() + " training samples" + (fValid != null ? ", " + fValid.numRows() + " validation samples" : ""));
            boolean printme = !this.get_params()._quiet_mode;
            this._timeLastScoreStart = System.currentTimeMillis();
            this.model_info().computeStats();
            DeepLearningScoringInfo scoringInfo = new DeepLearningScoringInfo();
            scoringInfo.time_stamp_ms = this._timeLastScoreStart;
            this.updateTiming(jobKey);
            scoringInfo.total_training_time_ms = this.total_training_time_ms;
            scoringInfo.total_scoring_time_ms = this.total_scoring_time_ms;
            scoringInfo.total_setup_time_ms = this.total_setup_time_ms;
            scoringInfo.epoch_counter = this.epoch_counter;
            scoringInfo.iterations = this.iterations;
            scoringInfo.training_samples = this.model_info().get_processed_total();
            scoringInfo.validation = fValid != null;
            scoringInfo.score_training_samples = fTrain.numRows();
            scoringInfo.is_classification = ((DeepLearningModelOutput)this._output).isClassifier();
            scoringInfo.is_autoencoder = ((DeepLearningModelOutput)this._output).isAutoencoder();
            if (this.get_params()._autoencoder) {
                ModelMetrics mtrain;
                if (printme) {
                    Log.info((Object[])new Object[]{"Scoring the auto-encoder."});
                }
                Frame mse_frame = this.scoreAutoEncoder(fTrain, Key.make(), false);
                mse_frame.delete();
                ((DeepLearningModelOutput)this._output)._training_metrics = mtrain = ModelMetrics.getFromDKV((Model)this, (Frame)fTrain);
                scoringInfo.scored_train = new ScoreKeeper(mtrain);
                if (fValid != null) {
                    ModelMetrics mtest;
                    mse_frame = this.scoreAutoEncoder(fValid, Key.make(), false);
                    mse_frame.delete();
                    ((DeepLearningModelOutput)this._output)._validation_metrics = mtest = ModelMetrics.getFromDKV((Model)this, (Frame)fValid);
                    scoringInfo.scored_valid = new ScoreKeeper(mtest);
                }
            } else {
                ModelMetrics mtrain;
                String m;
                if (printme) {
                    Log.info((Object[])new Object[]{"Scoring the model."});
                }
                if ((m = this.model_info().toString()).length() > 0) {
                    Log.info((Object[])new Object[]{m});
                }
                boolean needPreds = ((DeepLearningModelOutput)this._output).nclasses() == 2 || this.get_params()._distribution == DistributionFamily.huber;
                Frame preds = null;
                if (needPreds) {
                    preds = this.score(fTrain);
                    mtrain = ModelMetrics.getFromDKV((Model)this, (Frame)fTrain);
                    if (this.get_params()._distribution == DistributionFamily.huber) {
                        Vec absdiff = ((MathUtils.ComputeAbsDiff)new MathUtils.ComputeAbsDiff().doAll(1, (byte)3, new Frame(new String[]{"a", "p"}, new Vec[]{fTrain.vec(this.get_params()._response_column), preds.anyVec()}))).outputFrame().anyVec();
                        double huberDelta = MathUtils.computeWeightedQuantile((Vec)fTrain.vec(this.get_params()._weights_column), (Vec)absdiff, (double)this.get_params()._huber_alpha);
                        this.model_info();
                        if (DeepLearningModelInfo.gradientCheck == null) {
                            this._dist.setHuberDelta(huberDelta);
                        }
                    }
                } else {
                    ModelMetrics.MetricBuilder mb = this.scoreMetrics(fTrain);
                    mtrain = mb.makeModelMetrics((Model)this, fTrain, fTrain, null);
                }
                if (preds != null) {
                    preds.remove();
                }
                ((DeepLearningModelOutput)this._output)._training_metrics = mtrain;
                scoringInfo.scored_train = new ScoreKeeper(mtrain);
                ModelMetricsSupervised mm1 = (ModelMetricsSupervised)mtrain;
                if (mm1 instanceof ModelMetricsBinomial) {
                    ModelMetricsBinomial mm = (ModelMetricsBinomial)mm1;
                    scoringInfo.training_AUC = mm._auc;
                }
                ((DeepLearningModelOutput)this._output)._training_metrics._description = fTrain.numRows() != this.training_rows ? "Metrics reported on temporary training frame with " + fTrain.numRows() + " samples" : (fTrain._key != null && fTrain._key.toString().contains("chunks") ? "Metrics reported on temporary (load-balanced) training frame" : "Metrics reported on full training frame");
                if (fValid != null) {
                    ModelMetrics mvalid;
                    preds = null;
                    if (needPreds) {
                        preds = this.score(fValid);
                        mvalid = ModelMetrics.getFromDKV((Model)this, (Frame)fValid);
                    } else {
                        ModelMetrics.MetricBuilder mb = this.scoreMetrics(fValid);
                        mvalid = mb.makeModelMetrics((Model)this, fValid, fValid, null);
                    }
                    if (preds != null) {
                        preds.remove();
                    }
                    ((DeepLearningModelOutput)this._output)._validation_metrics = mvalid;
                    scoringInfo.scored_valid = new ScoreKeeper(mvalid);
                    if (mvalid != null) {
                        if (mvalid instanceof ModelMetricsBinomial) {
                            ModelMetricsBinomial mm = (ModelMetricsBinomial)mvalid;
                            scoringInfo.validation_AUC = mm._auc;
                        }
                        if (fValid.numRows() != this.validation_rows) {
                            ((DeepLearningModelOutput)this._output)._validation_metrics._description = "Metrics reported on temporary validation frame with " + fValid.numRows() + " samples";
                            if (this.get_params()._score_validation_sampling == DeepLearningParameters.ClassSamplingMethod.Stratified) {
                                ((DeepLearningModelOutput)this._output)._validation_metrics._description = ((DeepLearningModelOutput)this._output)._validation_metrics._description + " (stratified sampling)";
                            }
                        } else {
                            ((DeepLearningModelOutput)this._output)._validation_metrics._description = fValid._key != null && fValid._key.toString().contains("chunks") ? "Metrics reported on temporary (load-balanced) validation frame" : "Metrics reported on full validation frame";
                        }
                    }
                }
            }
            if (this.get_params()._variable_importances) {
                if (!this.get_params()._quiet_mode) {
                    Log.info((Object[])new Object[]{"Computing variable importances."});
                }
                float[] vi = this.model_info().computeVariableImportances();
                scoringInfo.variable_importances = new VarImp(vi, Arrays.copyOfRange(this.model_info().data_info().coefNames(), 0, vi.length));
            }
            this._timeLastScoreEnd = System.currentTimeMillis();
            long scoringTime = this._timeLastScoreEnd - this._timeLastScoreStart;
            this.total_scoring_time_ms += scoringTime;
            this.updateTiming(jobKey);
            scoringInfo.total_training_time_ms = this.total_training_time_ms;
            scoringInfo.total_scoring_time_ms = this.total_scoring_time_ms;
            scoringInfo.this_scoring_time_ms = scoringTime;
            if (this.scoringInfo == null) {
                this.scoringInfo = new DeepLearningScoringInfo[]{scoringInfo};
            } else {
                DeepLearningScoringInfo[] err2 = new DeepLearningScoringInfo[this.scoringInfo.length + 1];
                System.arraycopy(this.scoringInfo, 0, err2, 0, this.scoringInfo.length);
                err2[err2.length - 1] = scoringInfo;
                this.scoringInfo = err2;
            }
            ((DeepLearningModelOutput)this._output).errors = this.last_scored();
            this.makeWeightsBiases(this._key);
            Timer t = new Timer();
            if (((DeepLearningModelOutput)this._output).weights != null && ((DeepLearningModelOutput)this._output).biases != null) {
                int i;
                for (i = 0; i < ((DeepLearningModelOutput)this._output).weights.length; ++i) {
                    Frame f = this.model_info.get_weights(i).toFrame(((DeepLearningModelOutput)this._output).weights[i]);
                    if (i != 0) continue;
                    f.setNames(this.model_info.data_info.coefNames());
                    DKV.put((Keyed)f);
                }
                for (i = 0; i < ((DeepLearningModelOutput)this._output).biases.length; ++i) {
                    this.model_info.get_biases(i).toFrame(((DeepLearningModelOutput)this._output).biases[i]);
                }
                if (!this.get_params()._quiet_mode) {
                    Log.info((Object[])new Object[]{"Writing weights and biases to Frames took " + (double)t.time() / 1000.0 + " seconds."});
                }
            }
            ((DeepLearningModelOutput)this._output)._scoring_history = DeepLearningScoringInfo.createScoringHistoryTable((ScoringInfo[])this.scoringInfo, (null != this.get_params()._valid ? 1 : 0) != 0, (boolean)false, (ModelCategory)((DeepLearningModelOutput)this._output).getModelCategory(), (boolean)((DeepLearningModelOutput)this._output).isAutoencoder());
            ((DeepLearningModelOutput)this._output)._variable_importances = ModelMetrics.calcVarImp((VarImp)this.last_scored().variable_importances);
            ((DeepLearningModelOutput)this._output)._model_summary = this.model_info.createSummaryTable();
            if (!finalScoring) {
                if (this.actual_best_model_key != null && this.get_params()._overwrite_with_best_model && (DKV.get((Key)this.actual_best_model_key) != null && (!(this.loss() >= ((DeepLearningModel)DKV.get((Key)this.actual_best_model_key).get()).loss()) || !Arrays.equals(this.model_info().units, ((DeepLearningModel)DKV.get((Key)this.actual_best_model_key).get()).model_info().units)) || DKV.get((Key)this.actual_best_model_key) == null && this.loss() < this._bestLoss)) {
                    this._bestLoss = this.loss();
                    this.putMeAsBestModel(this.actual_best_model_key);
                }
                if (keep_running && printme) {
                    Log.info((Object[])new Object[]{this.toString()});
                }
                if (((DeepLearningModelOutput)this._output).isClassifier() && this.last_scored().scored_train._classError <= this.get_params()._classification_stop || !((DeepLearningModelOutput)this._output).isClassifier() && this.last_scored().scored_train._mse <= this.get_params()._regression_stop) {
                    Log.info((Object[])new Object[]{"Achieved requested predictive accuracy on the training data. Model building completed."});
                    this.stopped_early = true;
                }
                if (ScoreKeeper.stopEarly((ScoreKeeper[])ScoringInfo.scoreKeepers((ScoringInfo[])this.scoring_history()), (int)this.get_params()._stopping_rounds, (ScoreKeeper.ProblemType)ScoreKeeper.ProblemType.forSupervised((boolean)((DeepLearningModelOutput)this._output).isClassifier()), (ScoreKeeper.IStoppingMetric)this.get_params()._stopping_metric, (double)this.get_params()._stopping_tolerance, (String)"model's last", (boolean)true)) {
                    Log.info((Object[])new Object[]{"Convergence detected based on simple moving average of the loss function for the past " + this.get_params()._stopping_rounds + " scoring events. Model building completed."});
                    this.stopped_early = true;
                }
                if (printme) {
                    Log.info((Object[])new Object[]{"Time taken for scoring and diagnostics: " + PrettyPrint.msecs((long)scoringInfo.this_scoring_time_ms, (boolean)true)});
                }
            }
        }
        if (this.stopped_early) {
            ((Job)DKV.getGet(jobKey)).update((long)(this.get_params()._epochs * (double)this.training_rows));
            this.update(jobKey);
            return false;
        }
        this.progressUpdate(jobKey, keep_running);
        this.update(jobKey);
        return keep_running;
    }

    private void progressUpdate(Key<Job> job_key, boolean keep_running) {
        this.updateTiming(job_key);
        Job job = (Job)job_key.get();
        double progress = job.progress();
        int speed = (int)((double)this.model_info().get_processed_total() * 1000.0 / (double)(this.total_training_time_ms - this.total_scoring_time_ms - this.total_setup_time_ms));
        assert (speed >= 0) : "negative speed computed! (total_run_time: " + this.total_training_time_ms + ", total_scoring_time: " + this.total_scoring_time_ms + ", total_setup_time: " + this.total_setup_time_ms + ")";
        String msg = "Iterations: " + String.format("%,d", this.iterations) + ". Epochs: " + String.format("%g", this.epoch_counter) + ". Speed: " + String.format("%,d", speed) + " samples/sec." + (progress == 0.0 ? "" : " Estimated time left: " + PrettyPrint.msecs((long)((long)((double)this.total_training_time_ms * (1.0 - progress) / progress)), (boolean)true));
        job.update(this.actual_train_samples_per_iteration, msg);
        long now = System.currentTimeMillis();
        long sinceLastPrint = now - this._timeLastPrintStart;
        if (!keep_running || (double)sinceLastPrint > this.get_params()._score_interval * 1000.0) {
            this._timeLastPrintStart = now;
            if (!this.get_params()._quiet_mode) {
                Log.info((Object[])new Object[]{"Training time: " + PrettyPrint.msecs((long)this.total_training_time_ms, (boolean)true) + " (scoring: " + PrettyPrint.msecs((long)this.total_scoring_time_ms, (boolean)true) + "). Processed " + String.format("%,d", this.model_info().get_processed_total()) + " samples (" + String.format("%.3f", this.epoch_counter) + " epochs).\n"});
                Log.info((Object[])new Object[]{msg});
            }
        }
    }

    protected Frame predictScoreImpl(Frame orig, Frame adaptedFr, String destination_key, Job j, boolean computeMetrics, CFuncRef customMetricFunc) {
        if (!this.get_params()._autoencoder) {
            return super.predictScoreImpl(orig, adaptedFr, destination_key, j, computeMetrics, customMetricFunc);
        }
        final int len = this.model_info().data_info().fullN();
        assert (this.model_info().data_info()._responses == 0);
        String[] coefnames = this.model_info().data_info().coefNames();
        assert (len == coefnames.length);
        String[] names = new String[len];
        for (int i = 0; i < names.length; ++i) {
            names[i] = "reconstr_" + coefnames[i];
        }
        Frame f = new MRTask(){

            public void map(Chunk[] chks, NewChunk[] recon) {
                double[] tmp = new double[((DeepLearningModelOutput)DeepLearningModel.this._output)._names.length];
                double[] preds = new double[len];
                Neurons[] neurons = DeepLearningTask.makeNeuronsForTesting(DeepLearningModel.this.model_info);
                for (int row = 0; row < chks[0]._len; ++row) {
                    double[] p = DeepLearningModel.this.score_autoencoder(chks, row, tmp, preds, neurons, true, false);
                    for (int c = 0; c < len; ++c) {
                        recon[c].addNum(p[c]);
                    }
                }
            }
        }.doAll(len, (byte)3, adaptedFr).outputFrame();
        Frame of = new Frame(Key.make((String)destination_key), names, f.vecs());
        DKV.put((Keyed)of);
        this.makeMetricBuilder(null).makeModelMetrics((Model)this, orig, null, null);
        return of;
    }

    protected double[] score0(double[] data, double[] preds) {
        return this.score0(data, preds, 0.0);
    }

    public double meanLoss(DataInfo.Row[] myRows) {
        int i;
        DataInfo.Row myRow;
        int mb;
        double loss = 0.0;
        Neurons[] neurons = DeepLearningTask.makeNeuronsForTraining(this.model_info());
        long seed = -1L;
        double[] responses = new double[myRows.length];
        double[] offsets = new double[myRows.length];
        int n = 0;
        for (mb = 0; mb < myRows.length; ++mb) {
            myRow = myRows[mb];
            if (myRow == null) continue;
            ++n;
            ((Neurons.Input)neurons[0]).setInput(seed, myRow.numIds, myRow.numVals, myRow.nBins, myRow.binIds, mb);
            responses[mb] = myRow.response(0);
            offsets[mb] = myRow.offset;
            for (i = 0; i < neurons.length - 1; ++i) {
                Storage.DenseVector e;
                Storage.DenseVector denseVector = e = neurons[i]._e == null ? null : neurons[i]._e[mb];
                if (e != null) assert (ArrayUtils.sum((double[])e.raw()) == 0.0);
            }
        }
        DeepLearningTask.fpropMiniBatch(seed, neurons, this.model_info(), null, false, responses, offsets, myRows.length);
        for (mb = 0; mb < myRows.length; ++mb) {
            myRow = myRows[mb];
            if (myRow == null) continue;
            for (i = 0; i < neurons.length - 1; ++i) {
                Storage.DenseVector e;
                Storage.DenseVector denseVector = e = neurons[i]._e == null ? null : neurons[i]._e[mb];
                if (e != null) assert (ArrayUtils.sum((double[])e.raw()) == 0.0);
            }
            if (this.get_params()._loss == DeepLearningParameters.Loss.CrossEntropy) {
                if (this.get_params()._balance_classes) {
                    throw H2O.unimpl();
                }
                int actual = (int)myRow.response[0];
                double pred = neurons[neurons.length - 1]._a[mb].get(actual);
                loss += -Math.log(Math.max(1.0E-15, pred));
            } else {
                if (this.model_info.get_params()._autoencoder) {
                    throw H2O.unimpl();
                }
                double pred = neurons[neurons.length - 1]._a[mb].get(0);
                double actual = myRow.response[0];
                pred = this._dist.linkInv(pred);
                loss += this._dist.deviance(1.0, actual, pred);
            }
            for (i = 0; i <= this.get_params()._hidden.length + 1; ++i) {
                if (neurons[i]._w != null) {
                    for (int row = 0; row < neurons[i]._w.rows(); ++row) {
                        for (int col = 0; col < neurons[i]._w.cols(); ++col) {
                            loss += this.get_params()._l1 * (double)Math.abs(neurons[i]._w.get(row, col));
                            loss += 0.5 * this.get_params()._l2 * Math.pow(neurons[i]._w.get(row, col), 2.0);
                        }
                    }
                }
                if (neurons[i]._b == null) continue;
                for (int row = 0; row < neurons[i]._b.size(); ++row) {
                    loss += this.get_params()._l1 * Math.abs(neurons[i]._b.get(row));
                    loss += 0.5 * this.get_params()._l2 * Math.pow(neurons[i]._b.get(row), 2.0);
                }
            }
        }
        return n > 0 ? loss / (double)n : loss;
    }

    public double[] score0(double[] data, double[] preds, double offset) {
        int mb = 0;
        int n = 1;
        if (this.model_info().isUnstable()) {
            Log.err((Object[])new Object[]{this.unstable_msg});
            throw new UnsupportedOperationException(this.unstable_msg);
        }
        Neurons[] neurons = DeepLearningTask.makeNeuronsForTesting(this.model_info);
        ((Neurons.Input)neurons[0]).setInput(-1L, data, mb);
        DeepLearningTask.fpropMiniBatch(-1L, neurons, this.model_info, null, false, null, new double[]{offset}, n);
        double[] out = neurons[neurons.length - 1]._a[mb].raw();
        if (this.get_params()._distribution == DistributionFamily.modified_huber) {
            preds[0] = -1.0;
            preds[2] = this._dist.linkInv(out[0]);
            preds[1] = 1.0 - preds[2];
            return preds;
        }
        if (((DeepLearningModelOutput)this._output).isClassifier()) {
            assert (preds.length == out.length + 1);
            for (int i = 0; i < preds.length - 1; ++i) {
                preds[i + 1] = out[i];
                if (!Double.isNaN(preds[i + 1])) continue;
                throw new RuntimeException("Predicted class probability NaN!");
            }
            preds[0] = -1.0;
        } else {
            preds[0] = this.model_info().data_info()._normRespMul != null ? out[0] / this.model_info().data_info()._normRespMul[0] + this.model_info().data_info()._normRespSub[0] : out[0];
            preds[0] = this._dist.linkInv(preds[0]);
            if (Double.isNaN(preds[0])) {
                throw new RuntimeException("Predicted regression target NaN!");
            }
        }
        return preds;
    }

    public Frame scoreAutoEncoder(Frame frame, Key destination_key, final boolean reconstruction_error_per_feature) {
        String[] names;
        if (!this.get_params()._autoencoder) {
            throw new H2OIllegalArgumentException("Only for AutoEncoder Deep Learning model.", "");
        }
        final int len = ((DeepLearningModelOutput)this._output)._names.length;
        Frame adaptFrm = new Frame(frame);
        this.adaptTestForTrain(adaptFrm, true, false);
        final int outputcols = reconstruction_error_per_feature ? this.model_info.data_info.fullN() : 1;
        Frame mse = new MRTask(){

            public void map(Chunk[] chks, NewChunk[] mse) {
                double[] tmp = new double[len];
                double[] out = new double[outputcols];
                Neurons[] neurons = DeepLearningTask.makeNeuronsForTesting(DeepLearningModel.this.model_info);
                for (int row = 0; row < chks[0]._len; ++row) {
                    int i;
                    for (i = 0; i < len; ++i) {
                        tmp[i] = chks[i].atd(row);
                    }
                    DeepLearningModel.this.score_autoencoder(tmp, out, neurons, false, reconstruction_error_per_feature);
                    for (i = 0; i < outputcols; ++i) {
                        mse[i].addNum(out[i]);
                    }
                }
            }
        }.doAll(outputcols, (byte)3, adaptFrm).outputFrame();
        if (reconstruction_error_per_feature) {
            String[] coefnames = this.model_info().data_info().coefNames();
            assert (outputcols == coefnames.length);
            names = new String[outputcols];
            for (int i = 0; i < names.length; ++i) {
                names[i] = "reconstr_" + coefnames[i] + ".SE";
            }
        } else {
            names = new String[]{"Reconstruction.MSE"};
        }
        Frame res = new Frame(destination_key, names, mse.vecs());
        DKV.put((Keyed)res);
        this.addModelMetrics((ModelMetrics)new ModelMetricsAutoEncoder((Model)this, frame, res.numRows(), res.vecs()[0].mean(), CustomMetric.EMPTY));
        return res;
    }

    public Frame scoreDeepFeatures(Frame frame, int layer) {
        return this.scoreDeepFeatures(frame, layer, null);
    }

    public Frame scoreDeepFeatures(Frame frame, final int layer, final Job job) {
        Vec[] vecs;
        int ridx;
        if (layer < 0 || layer >= this.model_info().get_params()._hidden.length) {
            throw new H2OIllegalArgumentException("hidden layer (index) to extract must be between 0 and " + (this.model_info().get_params()._hidden.length - 1), "");
        }
        final int len = ((DeepLearningModelOutput)this._output).nfeatures();
        if (this.isSupervised() && (ridx = frame.find(((DeepLearningModelOutput)this._output).responseName())) != -1) {
            frame = new Frame(frame);
            frame.remove(ridx);
        }
        Frame adaptFrm = new Frame(frame);
        final int features = this.model_info().get_params()._hidden[layer];
        Vec v = adaptFrm.anyVec();
        Vec[] vecArray = vecs = v != null ? v.makeZeros(features) : null;
        if (vecs == null) {
            throw new IllegalArgumentException("Cannot create deep features from a frame with no columns.");
        }
        Scope.enter();
        this.adaptTestForTrain(adaptFrm, true, false);
        for (int j = 0; j < features; ++j) {
            adaptFrm.add("DF.L" + (layer + 1) + ".C" + (j + 1), vecs[j]);
        }
        boolean mb = false;
        boolean n = true;
        new MRTask(){

            public void map(Chunk[] chks) {
                if (this.isCancelled() || job != null && job.stop_requested()) {
                    throw new Job.JobCancelledException();
                }
                double[] tmp = new double[len];
                Neurons[] neurons = DeepLearningTask.makeNeuronsForTesting(DeepLearningModel.this.model_info);
                for (int row = 0; row < chks[0]._len; ++row) {
                    for (int i = 0; i < len; ++i) {
                        tmp[i] = chks[i].atd(row);
                    }
                    ((Neurons.Input)neurons[0]).setInput(-1L, tmp, 0);
                    DeepLearningTask.fpropMiniBatch(-1L, neurons, DeepLearningModel.this.model_info, null, false, null, null, 1);
                    double[] out = neurons[layer + 1]._a[0].raw();
                    for (int c = 0; c < features; ++c) {
                        chks[((DeepLearningModelOutput)DeepLearningModel.this._output)._names.length + c].set(row, out[c]);
                    }
                }
                if (job != null) {
                    job.update(1L);
                }
            }
        }.doAll(adaptFrm);
        int x = ((DeepLearningModelOutput)this._output)._names.length;
        int y = adaptFrm.numCols();
        Frame ret = adaptFrm.extractFrame(x, y);
        Scope.exit((Key[])new Key[0]);
        return ret;
    }

    public Frame scoreDeepFeatures(Frame frame, String layer, Job j) {
        throw H2O.unimpl((String)("Cannot extract named hidden layer '" + layer + "' for H2O DeepLearning."));
    }

    private double[] score_autoencoder(Chunk[] chks, int row_in_chunk, double[] tmp, double[] preds, Neurons[] neurons, boolean reconstruction, boolean reconstruction_error_per_feature) {
        assert (this.get_params()._autoencoder);
        assert (tmp.length == ((DeepLearningModelOutput)this._output)._names.length);
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = chks[i].atd(row_in_chunk);
        }
        this.score_autoencoder(tmp, preds, neurons, reconstruction, reconstruction_error_per_feature);
        return preds;
    }

    private void score_autoencoder(double[] data, double[] preds, Neurons[] neurons, boolean reconstruction, boolean reconstruction_error_per_feature) {
        boolean mb = false;
        boolean n = true;
        assert (this.model_info().get_params()._autoencoder);
        if (this.model_info().isUnstable()) {
            Log.err((Object[])new Object[]{this.unstable_msg});
            throw new UnsupportedOperationException(this.unstable_msg);
        }
        ((Neurons.Input)neurons[0]).setInput(-1L, data, 0);
        DeepLearningTask.fpropMiniBatch(-1L, neurons, this.model_info, null, false, null, null, 1);
        double[] in = neurons[0]._a[0].raw();
        double[] out = neurons[neurons.length - 1]._a[0].raw();
        assert (in.length == out.length);
        if (reconstruction) {
            this.model_info().data_info().unScaleNumericals(out, out);
            System.arraycopy(out, 0, preds, 0, out.length);
        } else if (reconstruction_error_per_feature) {
            for (int i = 0; i < in.length; ++i) {
                preds[i] = Math.pow(out[i] - in[i], 2.0);
            }
        } else {
            assert (preds.length == 1);
            double l2 = 0.0;
            for (int i = 0; i < in.length; ++i) {
                l2 += Math.pow(out[i] - in[i], 2.0);
            }
            preds[0] = l2 /= (double)in.length;
        }
    }

    public double calcOutlierThreshold(Vec mse, double quantile) {
        Frame mse_frame = new Frame(Key.make(), new String[]{"Reconstruction.MSE"}, new Vec[]{mse});
        DKV.put((Key)mse_frame._key, (Iced)mse_frame);
        QuantileModel.QuantileParameters parms = new QuantileModel.QuantileParameters();
        parms._train = mse_frame._key;
        parms._probs = new double[]{quantile};
        Job job = new Quantile(parms).trainModel();
        QuantileModel kmm = (QuantileModel)job.get();
        job.remove();
        double q = ((QuantileModel.QuantileOutput)kmm._output)._quantiles[0][0];
        kmm.delete();
        DKV.remove((Key)mse_frame._key);
        return q;
    }

    private void putMeAsBestModel(Key bestModelKey) {
        DeepLearningModelInfo eamodel;
        DeepLearningModel bestModel = (DeepLearningModel)IcedUtils.deepCopy((Iced)this);
        DKV.put((Key)bestModelKey, (Iced)bestModel);
        if (this.model_info().get_params()._elastic_averaging && (eamodel = (DeepLearningModelInfo)DKV.getGet((Key)this.model_info.elasticAverageModelInfoKey())) != null) {
            DKV.put((Key)bestModel.model_info().elasticAverageModelInfoKey(), (Iced)eamodel);
        }
        assert (DKV.get((Key)bestModelKey) != null);
        assert (bestModel.compareTo(this) <= 0);
    }

    protected Futures remove_impl(Futures fs, boolean cascade) {
        if (((DeepLearningModelOutput)this._output).weights != null && ((DeepLearningModelOutput)this._output).biases != null) {
            for (Key k : ((DeepLearningModelOutput)this._output).weights) {
                Keyed.remove((Key)k, (Futures)fs, (boolean)true);
            }
            for (Key k : ((DeepLearningModelOutput)this._output).biases) {
                Keyed.remove((Key)k, (Futures)fs, (boolean)true);
            }
        }
        if (this.actual_best_model_key != null) {
            DKV.remove((Key)this.actual_best_model_key);
        }
        DKV.remove((Key)this.model_info().data_info()._key, (Futures)fs);
        this.deleteElasticAverageModels();
        return super.remove_impl(fs, cascade);
    }

    void deleteElasticAverageModels() {
        if (this.model_info().get_params()._elastic_averaging) {
            DKV.remove((Key)this.model_info().elasticAverageModelInfoKey());
            for (H2ONode node : H2O.CLOUD._memary) {
                DKV.remove((Key)this.model_info().localModelInfoKey(node));
            }
        }
    }

    private String getHeader() {
        assert (this.get_params()._autoencoder);
        StringBuilder sb = new StringBuilder();
        int len = this.model_info().data_info().fullN();
        String prefix = "reconstr_";
        assert (this.model_info().data_info()._responses == 0);
        String[] coefnames = this.model_info().data_info().coefNames();
        assert (len == coefnames.length);
        for (int c = 0; c < len; ++c) {
            if (c > 0) {
                sb.append(",");
            }
            sb.append(prefix).append(coefnames[c]);
        }
        return sb.toString();
    }

    protected SBPrintStream toJavaInit(SBPrintStream sb, CodeGeneratorPipeline fileCtx) {
        String colInfoClazz;
        int i;
        sb = super.toJavaInit(sb, fileCtx);
        final String mname = JCodeGen.toJavaId((String)this._key.toString());
        final Neurons[] neurons = DeepLearningTask.makeNeuronsForTesting(this.model_info());
        DeepLearningParameters p = this.model_info.get_params();
        if (p._categorical_encoding != Model.Parameters.CategoricalEncodingScheme.AUTO && p._categorical_encoding != Model.Parameters.CategoricalEncodingScheme.OneHotInternal) {
            throw new IllegalArgumentException("Only default categorical_encoding scheme is supported for POJO/MOJO");
        }
        sb.ip("public boolean isSupervised() { return " + this.isSupervised() + "; }").nl();
        sb.ip("public int nfeatures() { return " + ((DeepLearningModelOutput)this._output).nfeatures() + "; }").nl();
        sb.ip("public int nclasses() { return " + (p._autoencoder ? neurons[neurons.length - 1].units : ((DeepLearningModelOutput)this._output).nclasses()) + "; }").nl();
        if (this.model_info().data_info()._nums > 0) {
            sb.i(0).p("// Thread-local storage for input neuron activation values.").nl();
            sb.i(0).p("final double[] NUMS = new double[" + this.model_info().data_info()._nums + "];").nl();
            JCodeGen.toClassWithArray((JCodeSB)sb, (String)"static", (String)"NORMMUL", (double[])this.model_info().data_info()._normMul);
            JCodeGen.toClassWithArray((JCodeSB)sb, (String)"static", (String)"NORMSUB", (double[])this.model_info().data_info()._normSub);
        }
        if (this.model_info().data_info()._cats > 0) {
            sb.i(0).p("// Thread-local workspace for storing categorical input variables.").nl();
            sb.i(0).p("final int[] CATS = new int[" + this.model_info().data_info()._cats + "];").nl();
        }
        JCodeGen.toStaticVar((JCodeSB)sb, (String)"CATOFFSETS", (int[])this.model_info().data_info()._catOffsets, (String)"Offset into the workspace for categorical variables.");
        if (this.model_info().data_info()._normRespMul != null) {
            JCodeGen.toStaticVar((JCodeSB)sb, (String)"NORMRESPMUL", (double[])this.model_info().data_info()._normRespMul, (String)"Standardization/Normalization scaling factor for response.");
            JCodeGen.toStaticVar((JCodeSB)sb, (String)"NORMRESPSUB", (double[])this.model_info().data_info()._normRespSub, (String)"Standardization/Normalization offset for response.");
        }
        if (p._hidden_dropout_ratios != null) {
            JCodeGen.toStaticVar((JCodeSB)sb, (String)"HIDDEN_DROPOUT_RATIOS", (double[])p._hidden_dropout_ratios, (String)"Hidden layer dropout ratios.");
        }
        int[] layers = new int[neurons.length];
        for (i = 0; i < neurons.length; ++i) {
            layers[i] = neurons[i].units;
        }
        JCodeGen.toStaticVar((JCodeSB)sb, (String)"NEURONS", (int[])layers, (String)"Number of neurons for each layer.");
        if (this.get_params()._autoencoder) {
            sb.i(1).p("public int getPredsSize() { return " + this.model_info.units[this.model_info.units.length - 1] + "; }").nl();
            sb.i(1).p("public boolean isAutoEncoder() { return true; }").nl();
            sb.i(1).p("public String getHeader() { return \"" + this.getHeader() + "\"; }").nl();
        }
        sb.i(1).p("// Thread-local storage for neuron activation values.").nl();
        sb.i(1).p("final double[][] ACTIVATION = new double[][] {").nl();
        for (i = 0; i < neurons.length; ++i) {
            sb.i(2).p("/* ").p(neurons[i].getClass().getSimpleName()).p(" */ ").p("new double[").p(layers[i]).p("]");
            if (i != neurons.length - 1) {
                sb.p(',');
            }
            sb.nl();
        }
        sb.i(1).p("};").nl();
        sb.i(1).p("// Neuron bias values.").nl();
        sb.i(1).p("public static final double[][] BIAS = new double[][] {").nl();
        for (i = 0; i < neurons.length; ++i) {
            colInfoClazz = mname + "_Bias_" + i;
            sb.i(2).p("/* ").p(neurons[i].getClass().getSimpleName()).p(" */ ");
            sb.p(colInfoClazz).p(".VALUES");
            if (i != neurons.length - 1) {
                sb.p(',');
            }
            sb.nl();
        }
        sb.i(1).p("};").nl();
        fileCtx.add((Object)new CodeGenerator(){

            public void generate(JCodeSB out) {
                for (int i = 0; i < neurons.length; ++i) {
                    double[] bias;
                    String colInfoClazz = mname + "_Bias_" + i;
                    out.i().p("// Neuron bias values for ").p(neurons[i].getClass().getSimpleName()).p(" layer").nl();
                    double[] dArray = bias = i == 0 ? null : new double[DeepLearningModel.this.model_info().get_biases(i - 1).size()];
                    if (i > 0) {
                        for (int j = 0; j < bias.length; ++j) {
                            bias[j] = DeepLearningModel.this.model_info().get_biases(i - 1).get(j);
                        }
                    }
                    JCodeGen.toClassWithArray((JCodeSB)out, null, (String)colInfoClazz, (double[])bias);
                }
            }
        });
        sb.i(1).p("// Connecting weights between neurons.").nl();
        sb.i(1).p("public static final float[][] WEIGHT = new float[][] {").nl();
        for (i = 0; i < neurons.length; ++i) {
            colInfoClazz = mname + "_Weight_" + i;
            sb.i(2).p("/* ").p(neurons[i].getClass().getSimpleName()).p(" */ ");
            sb.p(colInfoClazz).p(".VALUES");
            if (i != neurons.length - 1) {
                sb.p(',');
            }
            sb.nl();
        }
        sb.i(1).p("};").nl();
        fileCtx.add((Object)new CodeGenerator(){

            public void generate(JCodeSB out) {
                for (int i = 0; i < neurons.length; ++i) {
                    float[] weights;
                    String colInfoClazz = mname + "_Weight_" + i;
                    if (i > 0) {
                        out.i().p("// Neuron weights connecting ").p(neurons[i - 1].getClass().getSimpleName()).p(" and ").p(neurons[i].getClass().getSimpleName()).p(" layer").nl();
                    }
                    float[] fArray = weights = i == 0 ? null : new float[DeepLearningModel.this.model_info().get_weights(i - 1).rows() * DeepLearningModel.this.model_info().get_weights(i - 1).cols()];
                    if (i > 0) {
                        int rows = DeepLearningModel.this.model_info().get_weights(i - 1).rows();
                        int cols = DeepLearningModel.this.model_info().get_weights(i - 1).cols();
                        for (int j = 0; j < rows; ++j) {
                            for (int k = 0; k < cols; ++k) {
                                weights[j * cols + k] = DeepLearningModel.this.model_info().get_weights(i - 1).get(j, k);
                            }
                        }
                    }
                    JCodeGen.toClassWithArray((JCodeSB)out, null, (String)colInfoClazz, weights);
                }
            }
        });
        return sb;
    }

    protected boolean toJavaCheckTooBig() {
        return (double)this.model_info.size() > 1000000.0;
    }

    private SBPrintStream pureMatVec(SBPrintStream bodySb) {
        bodySb.i(1).p("int cols = ACTIVATION[i-1].length;").nl();
        bodySb.i(1).p("int rows = ACTIVATION[i].length;").nl();
        bodySb.i(1).p("int extra=cols-cols%8;").nl();
        bodySb.i(1).p("int multiple = (cols/8)*8-1;").nl();
        bodySb.i(1).p("int idx = 0;").nl();
        bodySb.i(1).p("float[] a = WEIGHT[i];").nl();
        bodySb.i(1).p("double[] x = ACTIVATION[i-1];").nl();
        bodySb.i(1).p("double[] y = BIAS[i];").nl();
        bodySb.i(1).p("double[] res = ACTIVATION[i];").nl();
        bodySb.i(1).p("for (int row=0; row<rows; ++row) {").nl();
        bodySb.i(2).p("double psum0 = 0, psum1 = 0, psum2 = 0, psum3 = 0, psum4 = 0, psum5 = 0, psum6 = 0, psum7 = 0;").nl();
        bodySb.i(2).p("for (int col = 0; col < multiple; col += 8) {").nl();
        bodySb.i(3).p("int off = idx + col;").nl();
        bodySb.i(3).p("psum0 += a[off    ] * x[col    ];").nl();
        bodySb.i(3).p("psum1 += a[off + 1] * x[col + 1];").nl();
        bodySb.i(3).p("psum2 += a[off + 2] * x[col + 2];").nl();
        bodySb.i(3).p("psum3 += a[off + 3] * x[col + 3];").nl();
        bodySb.i(3).p("psum4 += a[off + 4] * x[col + 4];").nl();
        bodySb.i(3).p("psum5 += a[off + 5] * x[col + 5];").nl();
        bodySb.i(3).p("psum6 += a[off + 6] * x[col + 6];").nl();
        bodySb.i(3).p("psum7 += a[off + 7] * x[col + 7];").nl();
        bodySb.i(2).p("}").nl();
        bodySb.i(2).p("res[row] += psum0 + psum1 + psum2 + psum3;").nl();
        bodySb.i(2).p("res[row] += psum4 + psum5 + psum6 + psum7;").nl();
        bodySb.i(2).p("for (int col = extra; col < cols; col++)").nl();
        bodySb.i(3).p("res[row] += a[idx + col] * x[col];").nl();
        bodySb.i(2).p("res[row] += y[row];").nl();
        bodySb.i(2).p("idx += cols;").nl();
        bodySb.i(1).p("}").nl();
        return bodySb;
    }

    protected void toJavaPredictBody(SBPrintStream bodySb, CodeGeneratorPipeline classCtx, CodeGeneratorPipeline fileCtx, boolean verboseCode) {
        DeepLearningParameters p = this.model_info.get_params();
        bodySb.i().p("java.util.Arrays.fill(preds,0);").nl();
        int cats = this.model_info().data_info()._cats;
        int nums = this.model_info().data_info()._nums;
        if (nums > 0) {
            bodySb.i().p("java.util.Arrays.fill(NUMS,0);").nl();
        }
        if (cats > 0) {
            bodySb.i().p("java.util.Arrays.fill(CATS,0);").nl();
        }
        bodySb.i().p("int i = 0, ncats = 0;").nl();
        if (cats > 0) {
            bodySb.i().p("for(; i<" + cats + "; ++i) {").nl();
            bodySb.i(1).p("if (!Double.isNaN(data[i])) {").nl();
            bodySb.i(2).p("int c = (int) data[i];").nl();
            if (this.model_info().data_info()._useAllFactorLevels) {
                bodySb.i(2).p("CATS[ncats] = c + CATOFFSETS[i];").nl();
            } else {
                bodySb.i(2).p("if (c != 0) {").nl();
                bodySb.i(3).p("CATS[ncats] = c + CATOFFSETS[i] - 1;").nl();
                bodySb.i(2).p("} else {").nl();
                bodySb.i(3).p("CATS[ncats] = -1;").nl();
                bodySb.i(2).p("}").nl();
            }
            bodySb.i(1).p("} else {").nl();
            bodySb.i(2).p("CATS[ncats] = CATOFFSETS[i+1]-1;").nl();
            bodySb.i(1).p("}").nl();
            bodySb.i(1).p("ncats++;").nl();
            bodySb.i().p("}").nl();
        }
        if (nums > 0) {
            bodySb.i().p("final int n = data.length;").nl();
            bodySb.i().p("for(; i<n; ++i) {").nl();
            bodySb.i(1).p("NUMS[i" + (cats > 0 ? "-" + cats : "") + "] = Double.isNaN(data[i]) ? 0 : ");
            if (this.model_info().data_info()._normMul != null) {
                bodySb.p("(data[i] - NORMSUB.VALUES[i" + (cats > 0 ? "-" + cats : "") + "])*NORMMUL.VALUES[i" + (cats > 0 ? "-" + cats : "") + "];").nl();
            } else {
                bodySb.p("data[i];").nl();
            }
            bodySb.i(0).p("}").nl();
        }
        bodySb.i().p("java.util.Arrays.fill(ACTIVATION[0],0);").nl();
        if (cats > 0) {
            bodySb.i().p("for (i=0; i<ncats; ++i) {").nl();
            bodySb.i(1).p("if(CATS[i] >= 0) ACTIVATION[0][CATS[i]] = 1;").nl();
            bodySb.i(0).p("}").nl();
        }
        if (nums > 0) {
            bodySb.i().p("for (i=0; i<NUMS.length; ++i) {").nl();
            bodySb.i(1).p("ACTIVATION[0][CATOFFSETS[CATOFFSETS.length-1] + i] = Double.isNaN(NUMS[i]) ? 0 : NUMS[i];").nl();
            bodySb.i().p("}").nl();
        }
        boolean tanh = p._activation == DeepLearningParameters.Activation.Tanh || p._activation == DeepLearningParameters.Activation.TanhWithDropout;
        boolean relu = p._activation == DeepLearningParameters.Activation.Rectifier || p._activation == DeepLearningParameters.Activation.RectifierWithDropout;
        boolean maxout = p._activation == DeepLearningParameters.Activation.Maxout || p._activation == DeepLearningParameters.Activation.MaxoutWithDropout;
        String stopping = p._autoencoder ? "(i<=ACTIVATION.length-1)" : "(i<ACTIVATION.length-1)";
        bodySb.i().p("for (i=1; i<ACTIVATION.length; ++i) {").nl();
        bodySb.i(1).p("java.util.Arrays.fill(ACTIVATION[i],0);").nl();
        if (maxout) {
            bodySb.i(1).p("int _k = 2; // channels").nl();
            bodySb.i(1).p("if " + stopping + " {").nl();
            bodySb.i(2).p("double[] channel = new double[_k];").nl();
            bodySb.i(2).p("for (int r=0; r<ACTIVATION[i].length; ++r) {").nl();
            bodySb.i(3).p("final int cols = ACTIVATION[i-1].length;").nl();
            bodySb.i(3).p("short maxK = 0;").nl();
            bodySb.i(3).p("for (short k = 0; k < _k; ++k) {").nl();
            bodySb.i(4).p("channel[k] = 0;").nl();
            bodySb.i(4).p("for (int c=0; c<cols; ++c) {").nl();
            bodySb.i(5).p("channel[k] += WEIGHT[i][_k*(r * cols + c) + k] * ACTIVATION[i-1][c];").nl();
            bodySb.i(4).p("}").nl();
            bodySb.i(4).p("channel[k] += BIAS[i][_k*r+k];").nl();
            bodySb.i(4).p("if (channel[k] > channel[maxK]) maxK=k;").nl();
            bodySb.i(3).p("}").nl();
            bodySb.i(3).p("ACTIVATION[i][r] = channel[maxK];").nl();
        } else {
            this.pureMatVec(bodySb);
            bodySb.i(1).p("if " + stopping + " {").nl();
            bodySb.i(2).p("for (int r=0; r<ACTIVATION[i].length; ++r) {").nl();
            if (tanh) {
                bodySb.i(3).p("ACTIVATION[i][r] = 1 - 2 / (1 + Math.exp(2*ACTIVATION[i][r]));").nl();
            } else if (relu) {
                bodySb.i(3).p("ACTIVATION[i][r] = Math.max(0, ACTIVATION[i][r]);").nl();
            }
        }
        if (p._hidden_dropout_ratios != null) {
            bodySb.i(3).p("if (i<ACTIVATION.length-1) {").nl();
            bodySb.i(4).p("ACTIVATION[i][r] *= 1 - HIDDEN_DROPOUT_RATIOS[i-1];").nl();
            bodySb.i(3).p("}").nl();
        }
        bodySb.i(2).p("}").nl();
        bodySb.i(1).p("}").nl();
        if (maxout) {
            bodySb.i(1).p("if (i == ACTIVATION.length-1) {").nl();
            this.pureMatVec(bodySb);
            bodySb.i(1).p("}").nl();
        }
        if (((DeepLearningModelOutput)this._output).isClassifier() && ((DeepLearningParameters)this._parms)._distribution != DistributionFamily.modified_huber) {
            bodySb.i(1).p("if (i == ACTIVATION.length-1) {").nl();
            bodySb.i(2).p("double max = ACTIVATION[i][0];").nl();
            bodySb.i(2).p("for (int r=1; r<ACTIVATION[i].length; r++) {").nl();
            bodySb.i(3).p("if (ACTIVATION[i][r]>max) max = ACTIVATION[i][r];").nl();
            bodySb.i(2).p("}").nl();
            bodySb.i(2).p("double scale = 0;").nl();
            bodySb.i(2).p("for (int r=0; r<ACTIVATION[i].length; r++) {").nl();
            bodySb.i(3).p("ACTIVATION[i][r] = Math.exp(ACTIVATION[i][r] - max);").nl();
            bodySb.i(3).p("scale += ACTIVATION[i][r];").nl();
            bodySb.i(2).p("}").nl();
            bodySb.i(2).p("for (int r=0; r<ACTIVATION[i].length; r++) {").nl();
            bodySb.i(3).p("if (Double.isNaN(ACTIVATION[i][r]))").nl();
            bodySb.i(4).p("throw new RuntimeException(\"Numerical instability, predicted NaN.\");").nl();
            bodySb.i(3).p("ACTIVATION[i][r] /= scale;").nl();
            bodySb.i(3).p("preds[r+1] = ACTIVATION[i][r];").nl();
            bodySb.i(2).p("}").nl();
            bodySb.i(1).p("}").nl();
            bodySb.i().p("}").nl();
        } else if (!p._autoencoder) {
            bodySb.i(1).p("if (i == ACTIVATION.length-1) {").nl();
            if (this.model_info().data_info()._normRespMul != null) {
                bodySb.i(2).p("preds[1] = (ACTIVATION[i][0] / NORMRESPMUL[0] + NORMRESPSUB[0]);").nl();
            } else {
                bodySb.i(2).p("preds[1] = ACTIVATION[i][0];").nl();
            }
            bodySb.i(2).p("preds[1] = " + this._dist.linkInvString("preds[1]") + ";").nl();
            if (((DeepLearningParameters)this._parms)._distribution == DistributionFamily.modified_huber) {
                bodySb.i(2).p("preds[2] = preds[1];").nl();
                bodySb.i(2).p("preds[1] = 1-preds[2];").nl();
            }
            bodySb.i(2).p("if (Double.isNaN(preds[1])) throw new RuntimeException(\"Predicted regression target NaN!\");").nl();
            bodySb.i(1).p("}").nl();
            bodySb.i().p("}").nl();
        } else {
            bodySb.i(1).p("if (i == ACTIVATION.length-1) {").nl();
            bodySb.i(2).p("for (int r=0; r<ACTIVATION[i].length; r++) {").nl();
            bodySb.i(3).p("if (Double.isNaN(ACTIVATION[i][r]))").nl();
            bodySb.i(4).p("throw new RuntimeException(\"Numerical instability, reconstructed NaN.\");").nl();
            bodySb.i(3).p("preds[r] = ACTIVATION[i][r];").nl();
            bodySb.i(2).p("}").nl();
            if (this.model_info().data_info()._nums > 0) {
                int ns = this.model_info().data_info().numStart();
                bodySb.i(2).p("for (int k=" + ns + "; k<" + this.model_info().data_info().fullN() + "; ++k) {").nl();
                bodySb.i(3).p("preds[k] = preds[k] / NORMMUL.VALUES[k-" + ns + "] + NORMSUB.VALUES[k-" + ns + "];").nl();
                bodySb.i(2).p("}").nl();
            }
            bodySb.i(1).p("}").nl();
            bodySb.i().p("}").nl();
        }
        if (((DeepLearningModelOutput)this._output).autoencoder) {
            return;
        }
        if (((DeepLearningModelOutput)this._output).isClassifier()) {
            if (this.get_params()._balance_classes) {
                bodySb.ip("hex.genmodel.GenModel.correctProbabilities(preds, PRIOR_CLASS_DISTRIB, MODEL_CLASS_DISTRIB);").nl();
            }
            bodySb.ip("preds[0] = hex.genmodel.GenModel.getPrediction(preds, PRIOR_CLASS_DISTRIB, data, " + this.defaultThreshold() + ");").nl();
        } else {
            bodySb.ip("preds[0] = preds[1];").nl();
        }
    }

    protected long checksum_impl() {
        return super.checksum_impl() * this.model_info.checksum_impl();
    }

    public DeepLearningMojoWriter getMojo() {
        return new DeepLearningMojoWriter(this);
    }

    public static class DeepLearningParameters
    extends Model.Parameters {
        public boolean _overwrite_with_best_model = true;
        public boolean _autoencoder = false;
        public boolean _use_all_factor_levels = true;
        public boolean _standardize = true;
        public Activation _activation = Activation.Rectifier;
        public int[] _hidden = new int[]{200, 200};
        public double _epochs = 10.0;
        public long _train_samples_per_iteration = -2L;
        public double _target_ratio_comm_to_comp = 0.05;
        public boolean _adaptive_rate = true;
        public double _rho = 0.99;
        public double _epsilon = 1.0E-8;
        public double _rate = 0.005;
        public double _rate_annealing = 1.0E-6;
        public double _rate_decay = 1.0;
        public double _momentum_start = 0.0;
        public double _momentum_ramp = 1000000.0;
        public double _momentum_stable = 0.0;
        public boolean _nesterov_accelerated_gradient = true;
        public double _input_dropout_ratio = 0.0;
        public double[] _hidden_dropout_ratios;
        public double _l1 = 0.0;
        public double _l2 = 0.0;
        public float _max_w2 = Float.MAX_VALUE;
        public InitialWeightDistribution _initial_weight_distribution = InitialWeightDistribution.UniformAdaptive;
        public double _initial_weight_scale = 1.0;
        public Key[] _initial_weights;
        public Key[] _initial_biases;
        public Loss _loss = Loss.Automatic;
        public double _score_interval = 5.0;
        public long _score_training_samples = 10000L;
        public long _score_validation_samples = 0L;
        public double _score_duty_cycle = 0.1;
        public double _classification_stop = 0.0;
        public double _regression_stop = 1.0E-6;
        public boolean _quiet_mode = false;
        public ClassSamplingMethod _score_validation_sampling = ClassSamplingMethod.Uniform;
        public boolean _diagnostics = true;
        public boolean _variable_importances = true;
        public boolean _fast_mode = true;
        public boolean _force_load_balance = true;
        public boolean _replicate_training_data = true;
        public boolean _single_node_mode = false;
        public boolean _shuffle_training_data = false;
        public MissingValuesHandling _missing_values_handling = MissingValuesHandling.MeanImputation;
        public boolean _sparse = false;
        public boolean _col_major = false;
        public double _average_activation = 0.0;
        public double _sparsity_beta = 0.0;
        public int _max_categorical_features = Integer.MAX_VALUE;
        public boolean _reproducible = false;
        public boolean _export_weights_and_biases = false;
        public boolean _elastic_averaging = false;
        public double _elastic_averaging_moving_rate = 0.9;
        public double _elastic_averaging_regularization = 0.001;
        public int _mini_batch_size = 1;

        public String algoName() {
            return "DeepLearning";
        }

        public String fullName() {
            return "Deep Learning";
        }

        public String javaName() {
            return DeepLearningModel.class.getName();
        }

        protected double defaultStoppingTolerance() {
            return 0.0;
        }

        public DeepLearningParameters() {
            this._stopping_rounds = 5;
        }

        public long progressUnits() {
            if (this.train() == null) {
                return 1L;
            }
            return (long)Math.ceil(this._epochs * (double)this.train().numRows());
        }

        public double missingColumnsType() {
            return this._sparse ? 0.0 : Double.NaN;
        }

        void validate(DeepLearning dl, boolean expensive) {
            boolean classification;
            boolean bl = expensive || dl.nclasses() != 0 ? dl.isClassifier() : (classification = this._loss == Loss.CrossEntropy || this._loss == Loss.ModifiedHuber);
            if (this._loss == Loss.ModifiedHuber) {
                dl.error("_loss", "ModifiedHuber loss function is not supported yet.");
            }
            if (this._hidden == null) {
                this._hidden = new int[0];
            }
            for (int h : this._hidden) {
                if (h > 0) continue;
                dl.error("_hidden", "Hidden layer size must be positive.");
            }
            if (this._mini_batch_size < 1) {
                dl.error("_mini_batch_size", "Mini-batch size must be >= 1");
            }
            if (!this._diagnostics) {
                dl.warn("_diagnostics", "Deprecated option: Diagnostics are always enabled.");
            }
            if (!this._autoencoder) {
                if (this._valid == null) {
                    dl.hide("_score_validation_samples", "score_validation_samples requires a validation frame.");
                }
                if (classification) {
                    dl.hide("_regression_stop", "regression_stop is used only with regression.");
                } else {
                    dl.hide("_classification_stop", "classification_stop is used only with classification.");
                }
                if (!classification && this._valid != null || this._valid == null) {
                    dl.hide("_score_validation_sampling", "score_validation_sampling requires classification and a validation frame.");
                }
            } else if (this._nfolds > 1) {
                dl.error("_nfolds", "N-fold cross-validation is not supported for Autoencoder.");
            }
            if (this._categorical_encoding == Model.Parameters.CategoricalEncodingScheme.Enum) {
                dl.error("_categorical_encoding", "Cannot use Enum encoding for categoricals - need numbers!");
            }
            if (this._categorical_encoding == Model.Parameters.CategoricalEncodingScheme.OneHotExplicit) {
                dl.error("_categorical_encoding", "Won't use explicit Enum encoding for categoricals - it's much faster with OneHotInternal!");
            }
            if (this._activation != Activation.TanhWithDropout && this._activation != Activation.MaxoutWithDropout && this._activation != Activation.RectifierWithDropout && this._activation != Activation.ExpRectifierWithDropout) {
                dl.hide("_hidden_dropout_ratios", "hidden_dropout_ratios requires a dropout activation function.");
            }
            if (this._hidden_dropout_ratios != null) {
                if (this._hidden_dropout_ratios.length != this._hidden.length) {
                    dl.error("_hidden_dropout_ratios", "Must have " + this._hidden.length + " hidden layer dropout ratios.");
                } else if (this._activation != Activation.TanhWithDropout && this._activation != Activation.MaxoutWithDropout && this._activation != Activation.RectifierWithDropout && this._activation != Activation.ExpRectifierWithDropout) {
                    dl.error("_hidden_dropout_ratios", "Cannot specify hidden_dropout_ratios with a non-dropout activation function. Use 'RectifierWithDropout', 'TanhWithDropout', etc.");
                } else if (ArrayUtils.maxValue((double[])this._hidden_dropout_ratios) >= 1.0 || ArrayUtils.minValue((double[])this._hidden_dropout_ratios) < 0.0) {
                    dl.error("_hidden_dropout_ratios", "Hidden dropout ratios must be >= 0 and <1.");
                }
            }
            if (this._input_dropout_ratio < 0.0 || this._input_dropout_ratio >= 1.0) {
                dl.error("_input_dropout_ratio", "Input dropout must be >= 0 and <1.");
            }
            if (this._score_duty_cycle < 0.0 || this._score_duty_cycle > 1.0) {
                dl.error("_score_duty_cycle", "Score duty cycle must be >= 0 and <=1.");
            }
            if (this._l1 < 0.0) {
                dl.error("_l1", "L1 penalty must be >= 0.");
            }
            if (this._l2 < 0.0) {
                dl.error("_l2", "L2 penalty must be >= 0.");
            }
            if (H2O.CLOUD.size() == 1 && this._replicate_training_data) {
                dl.hide("_replicate_training_data", "replicate_training_data is only valid with cloud size greater than 1.");
            }
            if (this._single_node_mode && (H2O.CLOUD.size() == 1 || !this._replicate_training_data)) {
                dl.hide("_single_node_mode", "single_node_mode is only used with multi-node operation with replicated training data.");
            }
            if (H2O.ARGS.client && this._single_node_mode) {
                dl.error("_single_node_mode", "Cannot run on a single node in client mode");
            }
            if (this._autoencoder) {
                dl.hide("_use_all_factor_levels", "use_all_factor_levels is mandatory in combination with autoencoder.");
            }
            if (this._nfolds != 0) {
                dl.hide("_overwrite_with_best_model", "overwrite_with_best_model is unsupported in combination with n-fold cross-validation.");
            }
            if (this._adaptive_rate) {
                dl.hide("_rate", "rate is not used with adaptive_rate.");
                dl.hide("_rate_annealing", "rate_annealing is not used with adaptive_rate.");
                dl.hide("_rate_decay", "rate_decay is not used with adaptive_rate.");
                dl.hide("_momentum_start", "momentum_start is not used with adaptive_rate.");
                dl.hide("_momentum_ramp", "momentum_ramp is not used with adaptive_rate.");
                dl.hide("_momentum_stable", "momentum_stable is not used with adaptive_rate.");
                if (this._rate != 0.005) {
                    dl.warn("_rate", "rate cannot be specified if adaptive_rate is enabled.");
                }
                if (this._rate_annealing != 1.0E-6) {
                    dl.warn("_rate_annealing", "rate_annealing cannot be specified if adaptive_rate is enabled.");
                }
                if (this._rate_decay != 1.0) {
                    dl.warn("_rate_decay", "rate_decay cannot be specified if adaptive_rate is enabled.");
                }
                if (this._momentum_start != 0.0) {
                    dl.warn("_momentum_start", "momentum_start cannot be specified if adaptive_rate is enabled.");
                }
                if (this._momentum_ramp != 1000000.0) {
                    dl.warn("_momentum_ramb", "momentum_ramp cannot be specified if adaptive_rate is enabled.");
                }
                if (this._momentum_stable != 0.0) {
                    dl.warn("_momentum_stable", "momentum_stable cannot be specified if adaptive_rate is enabled.");
                }
            } else {
                dl.hide("_rho", "rho is only used with adaptive_rate.");
                dl.hide("_epsilon", "epsilon is only used with adaptive_rate.");
            }
            if (this._initial_weight_distribution == InitialWeightDistribution.UniformAdaptive) {
                dl.hide("_initial_weight_scale", "initial_weight_scale is not used if initial_weight_distribution == UniformAdaptive.");
            }
            if ((this._initial_weights != null || this._initial_biases != null) && this._checkpoint != null) {
                dl.error("_checkpoint", "Cannot specify initial weights or biases during checkpoint restart. Will use the checkpoint model's weights and biases.");
            }
            if (this._initial_weights != null && this._initial_weights.length != this._hidden.length + 1) {
                dl.error("_initial_weights", "The number of initial weights matrices must be " + (this._hidden.length + 1) + " (some weight matrices can be NULL/None/null).");
            }
            if (this._initial_biases != null && this._initial_biases.length != this._hidden.length + 1) {
                dl.error("_initial_biases", "The number of initial bias vectors must be " + (this._hidden.length + 1) + " (some bias vectors can be NULL/None/null).");
            }
            if (this._loss == null) {
                if (expensive || dl.nclasses() != 0) {
                    dl.error("_loss", "Loss function must be specified. Try CrossEntropy for categorical response (classification), ModifiedHuber for binomial response, Quadratic, Absolute or Huber for numerical response (regression).");
                }
            } else {
                if (this._autoencoder && this._loss == Loss.CrossEntropy) {
                    dl.error("_loss", "Cannot use CrossEntropy loss for auto-encoder.");
                }
                if (!classification && this._loss == Loss.CrossEntropy) {
                    dl.error("_loss", H2O.technote((int)2, (String)"For CrossEntropy loss, the response must be categorical."));
                }
            }
            if (!classification && this._loss == Loss.CrossEntropy) {
                dl.error("_loss", "For CrossEntropy loss, the response must be categorical.");
            }
            if (classification && this._loss != Loss.Automatic && this._loss != Loss.CrossEntropy && this._loss != Loss.Quadratic && this._loss != Loss.ModifiedHuber) {
                dl.error("_loss", "For classification tasks, the loss must be one of: Automatic, Quadratic, CrossEntropy or ModifiedHuber.");
            }
            if (classification) {
                switch (this._distribution) {
                    case gaussian: 
                    case huber: 
                    case laplace: 
                    case quantile: 
                    case tweedie: 
                    case gamma: 
                    case poisson: {
                        dl.error("_distribution", H2O.technote((int)2, (String)(this._distribution + " distribution is not allowed for classification.")));
                        break;
                    }
                }
            } else {
                switch (this._distribution) {
                    case bernoulli: 
                    case modified_huber: 
                    case multinomial: {
                        dl.error("_distribution", H2O.technote((int)2, (String)(this._distribution + " distribution is not allowed for regression.")));
                        break;
                    }
                    case tweedie: 
                    case gamma: 
                    case poisson: {
                        if (this._loss == Loss.Automatic) break;
                        dl.error("_distribution", "Only Automatic loss (deviance) is allowed for " + this._distribution + " distribution.");
                        break;
                    }
                    case laplace: {
                        if (this._loss == Loss.Absolute || this._loss == Loss.Automatic) break;
                        dl.error("_distribution", "Only Automatic or Absolute loss is allowed for " + this._distribution + " distribution.");
                        break;
                    }
                    case quantile: {
                        if (this._loss == Loss.Quantile || this._loss == Loss.Automatic) break;
                        dl.error("_distribution", "Only Automatic or Quantile loss is allowed for " + this._distribution + " distribution.");
                        break;
                    }
                    case huber: {
                        if (this._loss == Loss.Huber || this._loss == Loss.Automatic) break;
                        dl.error("_distribution", "Only Automatic or Huber loss is allowed for " + this._distribution + " distribution.");
                        break;
                    }
                }
            }
            if (this._distribution == DistributionFamily.quasibinomial) {
                dl.error("_distribution", "Quasibinomial is not supported for deeplearning in current H2O.");
            }
            if (expensive) {
                dl.checkDistributions();
            }
            if (this._score_training_samples < 0L) {
                dl.error("_score_training_samples", "Number of training samples for scoring must be >= 0 (0 for all).");
            }
            if (this._score_validation_samples < 0L) {
                dl.error("_score_validation_samples", "Number of training samples for scoring must be >= 0 (0 for all).");
            }
            if (this._autoencoder && this._sparsity_beta > 0.0) {
                if (this._activation == Activation.Tanh || this._activation == Activation.TanhWithDropout || this._activation == Activation.ExpRectifier || this._activation == Activation.ExpRectifierWithDropout) {
                    if (this._average_activation >= 1.0 || this._average_activation <= -1.0) {
                        dl.error("_average_activation", "Tanh average activation must be in (-1,1).");
                    }
                } else if ((this._activation == Activation.Rectifier || this._activation == Activation.RectifierWithDropout) && this._average_activation <= 0.0) {
                    dl.error("_average_activation", "Rectifier average activation must be positive.");
                }
            }
            if (!this._autoencoder && this._sparsity_beta != 0.0) {
                dl.error("_sparsity_beta", "Sparsity beta can only be used for autoencoder.");
            }
            if (classification && dl.hasOffsetCol()) {
                dl.error("_offset_column", "Offset is only supported for regression.");
            }
            if (this._autoencoder && this._activation == Activation.Maxout) {
                dl.error("_activation", "Maxout activation is not supported for auto-encoder.");
            }
            if (this._max_categorical_features < 1) {
                dl.error("_max_categorical_features", "max_categorical_features must be at least 1.");
            }
            if (this._col_major) {
                dl.error("_col_major", "Deprecated: Column major data handling not supported anymore - not faster.");
            }
            if (!this._sparse && this._col_major) {
                dl.error("_col_major", "Cannot use column major storage for non-sparse data handling.");
            }
            if (this._sparse && this._elastic_averaging) {
                dl.error("_elastic_averaging", "Cannot use elastic averaging for sparse data handling.");
            }
            if (this._max_w2 <= 0.0f) {
                dl.error("_max_w2", "Cannot use max_w2 <= 0.");
            }
            if (expensive) {
                if (!classification && this._balance_classes) {
                    dl.error("_balance_classes", "balance_classes requires classification.");
                }
                if (this._class_sampling_factors != null && !this._balance_classes) {
                    dl.error("_class_sampling_factors", "class_sampling_factors requires balance_classes to be enabled.");
                }
                if (this._replicate_training_data && null != this.train() && (double)this.train().byteSize() > 0.9 * (double)H2O.CLOUD.free_mem() / (double)H2O.CLOUD.size() && H2O.CLOUD.size() > 1) {
                    dl.error("_replicate_training_data", "Compressed training dataset takes more than 90% of avg. free available memory per node (" + 0.9 * (double)H2O.CLOUD.free_mem() / (double)H2O.CLOUD.size() + "), cannot run with replicate_training_data.");
                }
            }
            if (!this._elastic_averaging) {
                dl.hide("_elastic_averaging_moving_rate", "Elastic averaging is required for this parameter.");
                dl.hide("_elastic_averaging_regularization", "Elastic averaging is required for this parameter.");
            } else {
                if (this._elastic_averaging_moving_rate > 1.0 || this._elastic_averaging_moving_rate < 0.0) {
                    dl.error("_elastic_averaging_moving_rate", "Elastic averaging moving rate must be between 0 and 1.");
                }
                if (this._elastic_averaging_regularization < 0.0) {
                    dl.error("_elastic_averaging_regularization", "Elastic averaging regularization strength must be >= 0.");
                }
            }
            if (this._autoencoder && this._stopping_metric != ScoreKeeper.StoppingMetric.AUTO && this._stopping_metric != ScoreKeeper.StoppingMetric.MSE) {
                dl.error("_stopping_metric", "Stopping metric must either be AUTO or MSE for autoencoder.");
            }
        }

        static class Sanity {
            private static final transient String[] cp_modifiable = new String[]{"_seed", "_checkpoint", "_epochs", "_score_interval", "_train_samples_per_iteration", "_target_ratio_comm_to_comp", "_score_duty_cycle", "_score_training_samples", "_score_validation_samples", "_score_validation_sampling", "_classification_stop", "_regression_stop", "_stopping_rounds", "_stopping_metric", "_stopping_tolerance", "_quiet_mode", "_max_confusion_matrix_size", "_max_hit_ratio_k", "_diagnostics", "_variable_importances", "_initial_weight_distribution", "_initial_weight_scale", "_initial_weights", "_initial_biases", "_force_load_balance", "_replicate_training_data", "_shuffle_training_data", "_single_node_mode", "_fast_mode", "_l1", "_l2", "_max_w2", "_input_dropout_ratio", "_hidden_dropout_ratios", "_loss", "_overwrite_with_best_model", "_missing_values_handling", "_average_activation", "_reproducible", "_export_weights_and_biases", "_elastic_averaging", "_elastic_averaging_moving_rate", "_elastic_averaging_regularization", "_mini_batch_size", "_pretrained_autoencoder"};
            private static final transient String[] cp_not_modifiable = new String[]{"_drop_na20_cols", "_response_column", "_activation", "_use_all_factor_levels", "_standardize", "_adaptive_rate", "_autoencoder", "_rho", "_epsilon", "_sparse", "_sparsity_beta", "_col_major", "_rate", "_rate_annealing", "_rate_decay", "_momentum_start", "_momentum_ramp", "_momentum_stable", "_nesterov_accelerated_gradient", "_ignore_const_cols", "_max_categorical_features", "_nfolds", "_distribution", "_quantile_alpha", "_huber_alpha", "_tweedie_power"};

            Sanity() {
            }

            static void checkCompleteness() {
                for (Field f : DeepLearningParameters.class.getDeclaredFields()) {
                    if (ArrayUtils.contains((Object[])cp_not_modifiable, (Object)f.getName()) || ArrayUtils.contains((Object[])cp_modifiable, (Object)f.getName()) || f.getName().equals("_hidden") || f.getName().equals("_ignored_columns") || f.getName().equals("$jacocoData")) continue;
                    throw H2O.unimpl((String)("Please add " + f.getName() + " to either cp_modifiable or cp_not_modifiable"));
                }
            }

            static void checkIfParameterChangeAllowed(DeepLearningParameters oldP, DeepLearningParameters newP) {
                Sanity.checkCompleteness();
                if (newP._nfolds != 0) {
                    throw new UnsupportedOperationException("nfolds must be 0: Cross-validation is not supported during checkpoint restarts.");
                }
                if (newP._valid == null != (oldP._valid == null)) {
                    throw new H2OIllegalArgumentException("Presence of validation dataset must agree with the checkpointed model.");
                }
                if (!(newP._autoencoder || newP._response_column != null && newP._response_column.equals(oldP._response_column))) {
                    throw new H2OIllegalArgumentException("Response column (" + newP._response_column + ") is not the same as for the checkpointed model: " + oldP._response_column);
                }
                if (!Arrays.equals(newP._hidden, oldP._hidden)) {
                    throw new H2OIllegalArgumentException("Hidden layers (" + Arrays.toString(newP._hidden) + ") is not the same as for the checkpointed model: " + Arrays.toString(oldP._hidden));
                }
                if (!Arrays.equals(newP._ignored_columns, oldP._ignored_columns)) {
                    throw new H2OIllegalArgumentException("Ignored columns must be the same as for the checkpointed model.");
                }
                for (Field fBefore : ((Object)((Object)oldP)).getClass().getFields()) {
                    if (!ArrayUtils.contains((Object[])cp_not_modifiable, (Object)fBefore.getName())) continue;
                    for (Field fAfter : ((Object)((Object)newP)).getClass().getFields()) {
                        if (!fBefore.equals(fAfter)) continue;
                        try {
                            if (fAfter.get((Object)newP) != null && fBefore.get((Object)oldP) != null && fBefore.get((Object)oldP).toString().equals(fAfter.get((Object)newP).toString()) || fBefore.get((Object)oldP) == null && fAfter.get((Object)newP) == null) continue;
                            throw new H2OIllegalArgumentException("Cannot change parameter: '" + fBefore.getName() + "': " + fBefore.get((Object)oldP) + " -> " + fAfter.get((Object)newP));
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }

            static void updateParametersDuringCheckpointRestart(DeepLearningParameters srcParms, DeepLearningParameters tgtParms, boolean doIt, boolean quiet) {
                for (Field fTarget : ((Object)((Object)tgtParms)).getClass().getFields()) {
                    if (!ArrayUtils.contains((Object[])cp_modifiable, (Object)fTarget.getName())) continue;
                    for (Field fSource : ((Object)((Object)srcParms)).getClass().getFields()) {
                        if (!fTarget.equals(fSource)) continue;
                        try {
                            if (fSource.get((Object)srcParms) != null && fTarget.get((Object)tgtParms) != null && fTarget.get((Object)tgtParms).toString().equals(fSource.get((Object)srcParms).toString()) || fTarget.get((Object)tgtParms) == null && fSource.get((Object)srcParms) == null) continue;
                            if (!tgtParms._quiet_mode && !quiet) {
                                Log.info((Object[])new Object[]{"Applying user-requested modification of '" + fTarget.getName() + "': " + fTarget.get((Object)tgtParms) + " -> " + fSource.get((Object)srcParms)});
                            }
                            if (!doIt) continue;
                            fTarget.set((Object)tgtParms, fSource.get((Object)srcParms));
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }

            static void modifyParms(DeepLearningParameters fromParms, DeepLearningParameters toParms, int nClasses) {
                if (fromParms._hidden_dropout_ratios == null) {
                    if (fromParms._activation == Activation.TanhWithDropout || fromParms._activation == Activation.MaxoutWithDropout || fromParms._activation == Activation.RectifierWithDropout || fromParms._activation == Activation.ExpRectifierWithDropout) {
                        toParms._hidden_dropout_ratios = new double[fromParms._hidden.length];
                        if (!fromParms._quiet_mode) {
                            Log.info((Object[])new Object[]{"_hidden_dropout_ratios: Automatically setting all hidden dropout ratios to 0.5."});
                        }
                        Arrays.fill(toParms._hidden_dropout_ratios, 0.5);
                    }
                } else {
                    toParms._hidden_dropout_ratios = (double[])fromParms._hidden_dropout_ratios.clone();
                }
                if (H2O.CLOUD.size() == 1 && fromParms._replicate_training_data) {
                    if (!fromParms._quiet_mode) {
                        Log.info((Object[])new Object[]{"_replicate_training_data: Disabling replicate_training_data on 1 node."});
                    }
                    toParms._replicate_training_data = false;
                }
                if (fromParms._single_node_mode && (H2O.CLOUD.size() == 1 || !fromParms._replicate_training_data)) {
                    if (!fromParms._quiet_mode) {
                        Log.info((Object[])new Object[]{"_single_node_mode: Disabling single_node_mode (only for multi-node operation with replicated training data)."});
                    }
                    toParms._single_node_mode = false;
                }
                if (!fromParms._use_all_factor_levels && fromParms._autoencoder) {
                    if (!fromParms._quiet_mode) {
                        Log.info((Object[])new Object[]{"_use_all_factor_levels: Automatically enabling all_factor_levels for auto-encoders."});
                    }
                    toParms._use_all_factor_levels = true;
                }
                if (fromParms._overwrite_with_best_model && fromParms._nfolds != 0) {
                    if (!fromParms._quiet_mode) {
                        Log.info((Object[])new Object[]{"_overwrite_with_best_model: Disabling overwrite_with_best_model in combination with n-fold cross-validation."});
                    }
                    toParms._overwrite_with_best_model = false;
                }
                if (fromParms._categorical_encoding == Model.Parameters.CategoricalEncodingScheme.AUTO) {
                    if (!fromParms._quiet_mode) {
                        Log.info((Object[])new Object[]{"_categorical_encoding: Automatically enabling OneHotInternal categorical encoding."});
                    }
                    toParms._categorical_encoding = Model.Parameters.CategoricalEncodingScheme.OneHotInternal;
                }
                if (fromParms._mini_batch_size > 1) {
                    Log.warn((Object[])new Object[]{"_mini_batch_size", "Only mini-batch size = 1 is supported right now."});
                    toParms._mini_batch_size = 1;
                }
                if (fromParms._adaptive_rate) {
                    if (!fromParms._quiet_mode) {
                        Log.info((Object[])new Object[]{"_adaptive_rate: Using automatic learning rate. Ignoring the following input parameters: rate, rate_decay, rate_annealing, momentum_start, momentum_ramp, momentum_stable."});
                    }
                    toParms._rate = 0.0;
                    toParms._rate_decay = 0.0;
                    toParms._rate_annealing = 0.0;
                    toParms._momentum_start = 0.0;
                    toParms._momentum_ramp = 0.0;
                    toParms._momentum_stable = 0.0;
                } else {
                    if (!fromParms._quiet_mode) {
                        Log.info((Object[])new Object[]{"_adaptive_rate: Using manual learning rate. Ignoring the following input parameters: rho, epsilon."});
                    }
                    toParms._rho = 0.0;
                    toParms._epsilon = 0.0;
                }
                if ((fromParms._activation == Activation.Rectifier || fromParms._activation == Activation.RectifierWithDropout) && fromParms._max_w2 == Float.POSITIVE_INFINITY) {
                    if (!fromParms._quiet_mode) {
                        Log.info((Object[])new Object[]{"_max_w2: Automatically setting max_w2 to 1000 to keep (unbounded) Rectifier activation in check."});
                    }
                    toParms._max_w2 = 1000.0f;
                }
                if (fromParms._nfolds != 0 && fromParms._overwrite_with_best_model) {
                    if (!fromParms._quiet_mode) {
                        Log.info((Object[])new Object[]{"_overwrite_with_best_model: Automatically disabling overwrite_with_best_model, since the final model is the only scored model with n-fold cross-validation."});
                    }
                    toParms._overwrite_with_best_model = false;
                }
                if (fromParms._autoencoder && fromParms._stopping_metric == ScoreKeeper.StoppingMetric.AUTO) {
                    if (!fromParms._quiet_mode) {
                        Log.info((Object[])new Object[]{"_stopping_metric: Automatically setting stopping_metric to MSE for autoencoder."});
                    }
                    toParms._stopping_metric = ScoreKeeper.StoppingMetric.MSE;
                }
                if (fromParms._distribution == DistributionFamily.AUTO) {
                    if (nClasses > 1) {
                        toParms._distribution = nClasses == 2 ? DistributionFamily.bernoulli : DistributionFamily.multinomial;
                    } else {
                        switch (fromParms._loss) {
                            case Automatic: 
                            case Quadratic: {
                                toParms._distribution = DistributionFamily.gaussian;
                                break;
                            }
                            case Absolute: {
                                toParms._distribution = DistributionFamily.laplace;
                                break;
                            }
                            case Quantile: {
                                toParms._distribution = DistributionFamily.quantile;
                                break;
                            }
                            case Huber: {
                                toParms._distribution = DistributionFamily.huber;
                                break;
                            }
                            case ModifiedHuber: {
                                toParms._distribution = DistributionFamily.modified_huber;
                                break;
                            }
                            default: {
                                throw H2O.unimpl();
                            }
                        }
                    }
                }
                if (fromParms._loss == Loss.Automatic) {
                    switch (toParms._distribution) {
                        case gaussian: {
                            toParms._loss = Loss.Quadratic;
                            break;
                        }
                        case quantile: {
                            toParms._loss = Loss.Quantile;
                            break;
                        }
                        case laplace: {
                            toParms._loss = Loss.Absolute;
                            break;
                        }
                        case huber: {
                            toParms._loss = Loss.Huber;
                            break;
                        }
                        case tweedie: 
                        case gamma: 
                        case poisson: {
                            toParms._loss = Loss.Automatic;
                            break;
                        }
                        case bernoulli: 
                        case multinomial: {
                            toParms._loss = Loss.CrossEntropy;
                            break;
                        }
                        case modified_huber: {
                            toParms._loss = Loss.ModifiedHuber;
                            break;
                        }
                        default: {
                            throw H2O.unimpl();
                        }
                    }
                }
                if (fromParms._reproducible) {
                    if (!fromParms._quiet_mode) {
                        Log.info((Object[])new Object[]{"_reproducibility: Automatically enabling force_load_balancing and score_each_iteration to enforce reproducibility. Turning off replicate_training_data."});
                    }
                    toParms._force_load_balance = true;
                    toParms._score_each_iteration = true;
                    toParms._replicate_training_data = false;
                    if (fromParms._train_samples_per_iteration == -2L) {
                        toParms._train_samples_per_iteration = -1L;
                        Log.info((Object[])new Object[]{"_reproducibility: Also setting train_samples_per_iteration to -1 since auto-tuning (-2) was specified."});
                    }
                }
            }
        }

        public static enum Loss {
            Automatic,
            Quadratic,
            CrossEntropy,
            ModifiedHuber,
            Huber,
            Absolute,
            Quantile;

        }

        public static enum Activation {
            Tanh,
            TanhWithDropout,
            Rectifier,
            RectifierWithDropout,
            Maxout,
            MaxoutWithDropout,
            ExpRectifier,
            ExpRectifierWithDropout;

        }

        public static enum InitialWeightDistribution {
            UniformAdaptive,
            Uniform,
            Normal;

        }

        public static enum ClassSamplingMethod {
            Uniform,
            Stratified;

        }

        public static enum MissingValuesHandling {
            MeanImputation,
            Skip;

        }
    }

    public static class DeepLearningModelOutput
    extends Model.Output {
        final boolean autoencoder;
        DeepLearningScoringInfo errors;
        Key[] weights;
        Key[] biases;
        double[] normmul;
        double[] normsub;
        double[] normrespmul;
        double[] normrespsub;
        int[] catoffsets;
        public TwoDimTable _variable_importances;

        public DeepLearningModelOutput(DeepLearning b) {
            super((ModelBuilder)b);
            this.autoencoder = ((DeepLearningParameters)b._parms)._autoencoder;
            assert (b.isSupervised() == !this.autoencoder);
        }

        public boolean isAutoencoder() {
            return this.autoencoder;
        }

        public ModelCategory getModelCategory() {
            return this.autoencoder ? ModelCategory.AutoEncoder : super.getModelCategory();
        }

        public boolean isSupervised() {
            return !this.autoencoder;
        }
    }
}

