/*
 * Decompiled with CFR 0.152.
 */
package hex.deepwater;

import hex.deepwater.DeepWaterIterator;
import hex.deepwater.DeepWaterModel;
import hex.genmodel.GenModel;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Future;
import javax.imageio.ImageIO;
import water.DKV;
import water.Freezable;
import water.Futures;
import water.H2O;
import water.Iced;
import water.Key;
import water.Keyed;
import water.Value;
import water.util.Log;

class DeepWaterImageIterator
extends DeepWaterIterator {
    private final int _num_obs;
    private int _start_index;
    private final int _width;
    private final int _height;
    private final int _channels;
    private final float[] _meanData;
    private final String[][] _file;
    private final ArrayList<String> _img_lst;
    private final ArrayList<Float> _label_lst;

    DeepWaterImageIterator(ArrayList<String> images, ArrayList<Float> labels, float[] meanData, int batch_size, int width, int height, int channels, boolean cache) throws IOException {
        super(batch_size, width * height * channels, cache);
        this._img_lst = images;
        this._label_lst = labels;
        this._meanData = meanData;
        this._num_obs = images.size();
        this._width = width;
        this._height = height;
        this._channels = channels;
        this._file = new String[2][];
        this._file[0] = new String[batch_size];
        this._file[1] = new String[batch_size];
    }

    @Override
    public boolean Next(Futures fs) throws IOException {
        if (this._start_index < this._num_obs) {
            if (this._start_index + this._batch_size > this._num_obs) {
                this._start_index = this._num_obs - this._batch_size;
            }
            Conversion conv = new Conversion();
            conv._dim._height = this._height;
            conv._dim._width = this._width;
            conv._dim._channels = this._channels;
            for (int i = 0; i < this._batch_size; ++i) {
                fs.add((Future)H2O.submitTask((H2O.H2OCountedCompleter)new ImageConverter(i, this._img_lst.get(this._start_index + i), this._label_lst == null ? Float.NaN : this._label_lst.get(this._start_index + i).floatValue(), conv, this._data[this.which()], this._meanData, this._label[this.which()], this._cache)));
            }
            fs.blockForPending();
            this.flip();
            this._start_index += this._batch_size;
            return true;
        }
        return false;
    }

    public String[] getFiles() {
        return this._file[this.which() ^ 1];
    }

    static class ImageConverter
    extends H2O.H2OCountedCompleter<ImageConverter> {
        String _file;
        float _label;
        Conversion _conv;
        float[] _destData;
        float[] _meanData;
        float[] _destLabel;
        int _index;
        boolean _cache;

        ImageConverter(int index, String file, float label, Conversion conv, float[] destData, float[] meanData, float[] destLabel, boolean cache) {
            this._index = index;
            this._file = file;
            this._label = label;
            this._conv = conv;
            this._destData = destData;
            this._meanData = meanData;
            this._destLabel = destLabel;
            this._cache = cache;
        }

        public void compute2() {
            this._destLabel[this._index] = this._label;
            File file = new File(this._file);
            try {
                IcedImage icedIm;
                int start = this._index * this._conv.len();
                Key imgKey = Key.make((String)(this._file + DeepWaterModel.CACHE_MARKER));
                boolean status = false;
                if (this._cache && (icedIm = (IcedImage)DKV.getGet((Key)imgKey)) != null && icedIm._dim.compareTo(this._conv._dim) == 0) {
                    System.arraycopy(icedIm._data, 0, this._destData, start, icedIm._data.length);
                    status = true;
                }
                if (!status) {
                    boolean isURL = this._file.matches("^(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]") && !file.exists();
                    BufferedImage img = isURL ? ImageIO.read(new URL(this._file.trim())) : ImageIO.read(new File(this._file.trim()));
                    GenModel.img2pixels((BufferedImage)img, (int)this._conv._dim._width, (int)this._conv._dim._height, (int)this._conv._dim._channels, (float[])this._destData, (int)start, (float[])this._meanData);
                    if (this._cache) {
                        Value v = new Value(imgKey, (Freezable)new IcedImage(this._conv._dim, Arrays.copyOfRange(this._destData, start, start + this._conv.len())));
                        DKV.put((Key)imgKey, (Value)v);
                        v.freeMem();
                    }
                }
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
            catch (Throwable e) {
                Log.warn((Object[])new Object[]{e.getMessage()});
            }
            this.tryComplete();
        }
    }

    static class IcedImage
    extends Keyed<IcedImage> {
        Dimensions _dim;
        float[] _data;

        public IcedImage() {
        }

        IcedImage(Dimensions dim, float[] data) {
            this._dim = dim;
            this._data = data;
        }
    }

    private static class Conversion {
        Dimensions _dim = new Dimensions();

        Conversion() {
        }

        public int len() {
            return this._dim.len();
        }
    }

    public static class Dimensions
    extends Iced<Dimensions>
    implements Comparable<Dimensions> {
        int _width;
        int _height;
        int _channels;

        public int len() {
            return this._width * this._height * this._channels;
        }

        @Override
        public int compareTo(Dimensions o) {
            return o._width == this._width && o._height == this._height && o._channels == this._channels ? 0 : (this.len() < o.len() ? -1 : 1);
        }
    }
}

