/*
 * Decompiled with CFR 0.152.
 */
package hex.generic;

import hex.Model;
import hex.ModelMetrics;
import hex.ModelMetricsAutoEncoder;
import hex.ModelMetricsBinomial;
import hex.ModelMetricsClustering;
import hex.ModelMetricsMultinomial;
import hex.ModelMetricsOrdinal;
import hex.ModelMetricsRegression;
import hex.generic.GenericModelMojoWriter;
import hex.generic.GenericModelOutput;
import hex.generic.GenericModelParameters;
import hex.genmodel.ModelMojoReader;
import hex.genmodel.MojoModel;
import hex.genmodel.MojoReaderBackend;
import hex.genmodel.MojoReaderBackendFactory;
import hex.genmodel.algos.kmeans.KMeansMojoModel;
import hex.tree.isofor.ModelMetricsAnomaly;
import java.io.IOException;
import java.io.InputStream;
import water.Futures;
import water.H2O;
import water.Iced;
import water.Key;
import water.fvec.ByteVec;
import water.fvec.Frame;
import water.util.Log;

public class GenericModel
extends Model<GenericModel, GenericModelParameters, GenericModelOutput> {
    private MojoModelSource _mojoModelSource;

    public GenericModel(Key<GenericModel> selfKey, GenericModelParameters parms, GenericModelOutput output, MojoModel mojoModel, Key<Frame> mojoSource) {
        super(selfKey, (Model.Parameters)parms, (Model.Output)output);
        this._mojoModelSource = new MojoModelSource(mojoSource, mojoModel);
        this._output = new GenericModelOutput(mojoModel._modelDescriptor, mojoModel._modelAttributes);
    }

    private static MojoModel reconstructMojo(ByteVec mojoBytes) {
        try {
            MojoReaderBackend readerBackend = MojoReaderBackendFactory.createReaderBackend((InputStream)mojoBytes.openStream(null), (MojoReaderBackendFactory.CachingStrategy)MojoReaderBackendFactory.CachingStrategy.MEMORY);
            return ModelMojoReader.readFrom((MojoReaderBackend)readerBackend, (boolean)true);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unreachable MOJO file: " + mojoBytes._key, e);
        }
    }

    public ModelMetrics.MetricBuilder makeMetricBuilder(String[] domain) {
        switch (((GenericModelOutput)this._output).getModelCategory()) {
            case Unknown: {
                throw new IllegalStateException("Model category is unknown");
            }
            case Binomial: {
                return new ModelMetricsBinomial.MetricBuilderBinomial(domain);
            }
            case Multinomial: {
                return new ModelMetricsMultinomial.MetricBuilderMultinomial(((GenericModelOutput)this._output).nclasses(), domain);
            }
            case Ordinal: {
                return new ModelMetricsOrdinal.MetricBuilderOrdinal(((GenericModelOutput)this._output).nclasses(), domain);
            }
            case Regression: {
                return new ModelMetricsRegression.MetricBuilderRegression();
            }
            case Clustering: {
                if (this.mojoModel() instanceof KMeansMojoModel) {
                    KMeansMojoModel kMeansMojoModel = (KMeansMojoModel)this.mojoModel();
                    return new ModelMetricsClustering.MetricBuilderClustering(((GenericModelOutput)this._output).nfeatures(), kMeansMojoModel.getNumClusters());
                }
                return this.unsupportedMetricsBuilder();
            }
            case AutoEncoder: {
                return new ModelMetricsAutoEncoder.MetricBuilderAutoEncoder(((GenericModelOutput)this._output).nfeatures());
            }
            case DimReduction: {
                return this.unsupportedMetricsBuilder();
            }
            case WordEmbedding: {
                return this.unsupportedMetricsBuilder();
            }
            case CoxPH: {
                return this.unsupportedMetricsBuilder();
            }
            case AnomalyDetection: {
                return new ModelMetricsAnomaly.MetricBuilderAnomaly();
            }
        }
        throw H2O.unimpl();
    }

    private ModelMetrics.MetricBuilder unsupportedMetricsBuilder() {
        if (((GenericModelParameters)this._parms)._disable_algo_check) {
            Log.warn((Object[])new Object[]{"Model category `" + ((GenericModelOutput)this._output)._modelCategory + "` currently doesn't support calculating model metrics. Model metrics will not be available."});
            return new MetricBuilderGeneric(this.mojoModel().getPredsSize(((GenericModelOutput)this._output)._modelCategory));
        }
        throw new UnsupportedOperationException(((GenericModelOutput)this._output)._modelCategory + " is not supported.");
    }

    protected double[] score0(double[] data, double[] preds) {
        return this.mojoModel().score0(data, preds);
    }

    public GenericModelMojoWriter getMojo() {
        return new GenericModelMojoWriter(this._mojoModelSource.mojoByteVec());
    }

    private MojoModel mojoModel() {
        return this._mojoModelSource.get();
    }

    protected Futures remove_impl(Futures fs, boolean cascade) {
        Frame mojoFrame;
        if (((GenericModelParameters)this._parms)._path != null && (mojoFrame = (Frame)this._mojoModelSource._mojoSource.get()) != null) {
            mojoFrame.remove(fs, cascade);
        }
        return super.remove_impl(fs, cascade);
    }

    private static class MojoModelSource
    extends Iced<MojoModelSource> {
        private Key<Frame> _mojoSource;
        private transient MojoModel _mojoModel;

        MojoModelSource(Key<Frame> mojoSource, MojoModel mojoModel) {
            this._mojoSource = mojoSource;
            this._mojoModel = mojoModel;
        }

        private ByteVec mojoByteVec() {
            return (ByteVec)((Frame)this._mojoSource.get()).anyVec();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        MojoModel get() {
            if (this._mojoModel == null) {
                MojoModelSource mojoModelSource = this;
                synchronized (mojoModelSource) {
                    if (this._mojoModel == null) {
                        this._mojoModel = GenericModel.reconstructMojo(this.mojoByteVec());
                    }
                }
            }
            assert (this._mojoModel != null);
            return this._mojoModel;
        }
    }

    private static class MetricBuilderGeneric
    extends ModelMetrics.MetricBuilder<MetricBuilderGeneric> {
        private MetricBuilderGeneric(int predsSize) {
            this._work = new double[predsSize];
        }

        public double[] perRow(double[] ds, float[] yact, Model m) {
            return ds;
        }

        public ModelMetrics makeModelMetrics(Model m, Frame f, Frame adaptedFrame, Frame preds) {
            return null;
        }
    }
}

