/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.CMetricScoringTask;
import hex.Model;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.genmodel.GenModel;
import hex.genmodel.utils.DistributionFamily;
import hex.tree.SharedTree;
import hex.tree.SharedTreeModel;
import water.Iced;
import water.Key;
import water.fvec.C0DChunk;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.udf.CFuncRef;
import water.util.Log;

public class Score
extends CMetricScoringTask<Score> {
    final SharedTree _bldr;
    final boolean _is_train;
    final boolean _oob;
    final Key<Vec> _kresp;
    final ModelCategory _mcat;
    final boolean _computeGainsLift;
    final ScoreIncInfo _sii;
    final Frame _preds;
    ModelMetrics.MetricBuilder _mb;

    public Score(SharedTree bldr, boolean is_train, boolean oob, Vec kresp, ModelCategory mcat, boolean computeGainsLift, Frame preds, CFuncRef customMetricFunc) {
        this(bldr, is_train, null, oob, kresp, mcat, computeGainsLift, preds, customMetricFunc);
    }

    public Score(SharedTree bldr, ScoreIncInfo sii, boolean oob, Vec kresp, ModelCategory mcat, boolean computeGainsLift, Frame preds, CFuncRef customMetricFunc) {
        this(bldr, false, sii, oob, kresp, mcat, computeGainsLift, preds, customMetricFunc);
    }

    private Score(SharedTree bldr, boolean is_train, ScoreIncInfo sii, boolean oob, Vec kresp, ModelCategory mcat, boolean computeGainsLift, Frame preds, CFuncRef customMetricFunc) {
        super(customMetricFunc);
        this._bldr = bldr;
        this._is_train = is_train;
        this._sii = sii;
        this._oob = oob;
        this._kresp = kresp != null ? kresp._key : null;
        this._mcat = mcat;
        this._computeGainsLift = computeGainsLift;
        Object object = this._preds = computeGainsLift ? preds : null;
        assert (this._kresp != null || !this._bldr.isSupervised());
        assert (!this._is_train || this._sii == null);
    }

    public void map(Chunk[] allchks) {
        String[] domain;
        Chunk[] chks = this.getScoringChunks(allchks);
        C0DChunk ys = this._bldr.isSupervised() ? this._bldr.chk_resp(chks) : new C0DChunk(0.0, chks[0]._len);
        Object m = this._bldr._model;
        Chunk weightsChunk = ((SharedTreeModel)((Object)m))._output.hasWeights() ? chks[((SharedTreeModel)((Object)m))._output.weightsIdx()] : null;
        Chunk offsetChunk = ((SharedTreeModel)((Object)m))._output.hasOffset() ? chks[((SharedTreeModel)((Object)m))._output.offsetIdx()] : null;
        int nclass = this._bldr.nclasses();
        String[] stringArray = domain = this._kresp != null ? ((Vec)this._kresp.get()).domain() : null;
        if (domain == null && ((SharedTreeModel)((Object)m))._parms._distribution == DistributionFamily.quasibinomial) {
            domain = new String[]{"0", "1"};
        }
        int oobColIdx = this._bldr.idx_oobt();
        this._mb = ((SharedTreeModel)((Object)m)).makeMetricBuilder(domain);
        double[] cdists = this._mb._work;
        double[] tmp = (double[])(this._is_train && this._bldr._ntrees > 0 ? null : new double[this._bldr._ncols]);
        float[] val = new float[1];
        for (int row = 0; row < ys._len; ++row) {
            double offset;
            double weight;
            if (ys.isNA(row) || this._oob && chks[oobColIdx].atd(row) == 0.0) continue;
            double d = weight = weightsChunk != null ? weightsChunk.atd(row) : 1.0;
            if (weight == 0.0) continue;
            double d2 = offset = offsetChunk != null ? offsetChunk.atd(row) : 0.0;
            if (this._is_train) {
                this._bldr.score2(chks, weight, offset, cdists, row);
            } else if (this._sii != null) {
                ((SharedTreeModel)((Object)m)).score0Incremental(this._sii, chks, offset, row, tmp, cdists);
            } else {
                m.score0(chks, offset, row, tmp, cdists);
            }
            if (this._is_train && this._bldr._ntrees == 0) {
                for (int i = 0; i < tmp.length; ++i) {
                    tmp[i] = chks[i].atd(row);
                }
            }
            if (nclass > 1) {
                cdists[0] = GenModel.getPrediction((double[])cdists, (double[])((SharedTreeModel)((Object)m))._output._priorClassDist, (double[])tmp, (double)m.defaultThreshold());
            }
            val[0] = (float)ys.atd(row);
            this._mb.perRow(cdists, val, weight, offset, m);
            if (this._preds != null) {
                this._mb.cachePrediction(cdists, allchks, row, chks.length, m);
            }
            this.customMetricPerRow(cdists, val, weight, offset, (Model)m);
        }
    }

    private Chunk[] getScoringChunks(Chunk[] allChunks) {
        if (this._preds == null) {
            return allChunks;
        }
        Chunk[] chks = new Chunk[allChunks.length - this._preds.numCols()];
        System.arraycopy(allChunks, 0, chks, 0, chks.length);
        return chks;
    }

    protected boolean modifiesVolatileVecs() {
        return this._sii != null || this._preds != null;
    }

    public void reduce(Score t) {
        super.reduce((CMetricScoringTask)t);
        this._mb.reduce(t._mb);
    }

    protected void postGlobal() {
        super.postGlobal();
        if (this._mb != null) {
            this._mb.postGlobal(this.getComputedCustomMetric());
        }
    }

    ModelMetrics scoreAndMakeModelMetrics(SharedTreeModel model, Frame fr, Frame adaptedFr, boolean buildTreeOneNode) {
        Frame input = this._preds != null ? new Frame(adaptedFr).add(this._preds) : adaptedFr;
        return ((Score)this.doAll(input, buildTreeOneNode)).makeModelMetrics(model, fr, adaptedFr, this._preds);
    }

    private ModelMetrics makeModelMetrics(SharedTreeModel model, Frame fr, Frame adaptedFr, Frame preds) {
        ModelMetrics mm;
        if (model._output.nclasses() == 2 && this._computeGainsLift) {
            assert (preds != null) : "Predictions were pre-created";
            mm = this._mb.makeModelMetrics((Model)model, fr, adaptedFr, preds);
        } else {
            boolean calculatePreds;
            boolean bl = calculatePreds = preds == null && model._parms._distribution == DistributionFamily.huber;
            if (calculatePreds) {
                Log.warn((Object[])new Object[]{"Going to calculate predictions from scratch. This can be expensive for large models! See PUBDEV-4992"});
                preds = model.score(fr);
            }
            mm = this._mb.makeModelMetrics((Model)model, fr, null, preds);
            if (calculatePreds && preds != null) {
                preds.remove();
            }
        }
        return mm;
    }

    static Frame makePredictionCache(SharedTreeModel model, Vec resp) {
        String[] domain = resp.domain();
        if (domain == null && model._parms._distribution == DistributionFamily.quasibinomial) {
            domain = new String[]{"0", "1"};
        }
        ModelMetrics.MetricBuilder mb = model.makeMetricBuilder(domain);
        return mb.makePredictionCache((Model)model, resp);
    }

    public static class ScoreIncInfo
    extends Iced<ScoreIncInfo> {
        public final int _startTree;
        public final int _workspaceColIdx;
        public final int _workspaceColCnt;
        public final int _predsAryOffset;

        public ScoreIncInfo(int startTree, int workspaceColIdx, int workspaceColCnt, int predsAryOffset) {
            this._startTree = startTree;
            this._workspaceColIdx = workspaceColIdx;
            this._workspaceColCnt = workspaceColCnt;
            this._predsAryOffset = predsAryOffset;
        }
    }
}

