/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.isofor;

import hex.ModelCategory;
import hex.ModelMetrics;
import hex.genmodel.utils.DistributionFamily;
import hex.tree.SharedTreeModel;
import hex.tree.isofor.IsolationForest;
import hex.tree.isofor.IsolationForestMojoWriter;
import hex.tree.isofor.ModelMetricsAnomaly;
import water.Key;
import water.fvec.Frame;
import water.util.SBPrintStream;
import water.util.TwoDimTable;

public class IsolationForestModel
extends SharedTreeModel<IsolationForestModel, IsolationForestParameters, IsolationForestOutput> {
    public IsolationForestModel(Key<IsolationForestModel> selfKey, IsolationForestParameters parms, IsolationForestOutput output) {
        super(selfKey, parms, output);
    }

    @Override
    public ModelMetrics.MetricBuilder makeMetricBuilder(String[] domain) {
        return new ModelMetricsAnomaly.MetricBuilderAnomaly("Isolation Forest Metrics");
    }

    protected String[] makeScoringNames() {
        return new String[]{"predict", "mean_length"};
    }

    protected String[][] makeScoringDomains(Frame adaptFrm, boolean computeMetrics, String[] names) {
        assert (names.length == 2);
        return new String[2][];
    }

    @Override
    protected double[] score0(double[] data, double[] preds, double offset, int ntrees) {
        super.score0(data, preds, offset, ntrees);
        if (ntrees >= 1) {
            preds[1] = preds[0] / (double)ntrees;
        }
        preds[0] = this.normalizePathLength(preds[0]);
        return preds;
    }

    final double normalizePathLength(double pathLength) {
        if (((IsolationForestOutput)this._output)._max_path_length > ((IsolationForestOutput)this._output)._min_path_length) {
            return ((double)((IsolationForestOutput)this._output)._max_path_length - pathLength) / (double)(((IsolationForestOutput)this._output)._max_path_length - ((IsolationForestOutput)this._output)._min_path_length);
        }
        return 1.0;
    }

    @Override
    protected void toJavaUnifyPreds(SBPrintStream body) {
        throw new UnsupportedOperationException("Isolation Forest support only MOJOs.");
    }

    public IsolationForestMojoWriter getMojo() {
        return new IsolationForestMojoWriter(this);
    }

    public static class IsolationForestOutput
    extends SharedTreeModel.SharedTreeOutput {
        public int _max_path_length;
        public int _min_path_length;
        public IsolationForest.VarSplits _var_splits;
        public TwoDimTable _variable_splits;

        public IsolationForestOutput(IsolationForest b) {
            super(b);
        }

        public ModelCategory getModelCategory() {
            return ModelCategory.AnomalyDetection;
        }
    }

    public static class IsolationForestParameters
    extends SharedTreeModel.SharedTreeParameters {
        public int _mtries = -1;
        public long _sample_size = 256L;

        public String algoName() {
            return "IsolationForest";
        }

        public String fullName() {
            return "Isolation Forest";
        }

        public String javaName() {
            return IsolationForestModel.class.getName();
        }

        public IsolationForestParameters() {
            this._max_depth = 8;
            this._sample_rate = -1.0;
            this._min_rows = 1.0;
            this._min_split_improvement = 0.0;
            this._nbins = 2;
            this._nbins_cats = 2;
            this._histogram_type = SharedTreeModel.SharedTreeParameters.HistogramType.Random;
            this._distribution = DistributionFamily.gaussian;
            this._stopping_tolerance = 0.01;
        }
    }
}

