/*
 * Decompiled with CFR 0.152.
 */
package hex.word2vec;

import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.word2vec.Word2VecModel;
import hex.word2vec.WordVectorConverter;
import hex.word2vec.WordVectorTrainer;
import java.util.LinkedList;
import water.Job;
import water.Key;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.Log;
import water.util.StringUtils;

public class Word2Vec
extends ModelBuilder<Word2VecModel, Word2VecModel.Word2VecParameters, Word2VecModel.Word2VecOutput> {
    public ModelCategory[] can_build() {
        return new ModelCategory[]{ModelCategory.WordEmbedding};
    }

    public ModelBuilder.BuilderVisibility builderVisibility() {
        return ModelBuilder.BuilderVisibility.Stable;
    }

    public boolean isSupervised() {
        return false;
    }

    public Word2Vec(boolean startup_once) {
        super((Model.Parameters)new Word2VecModel.Word2VecParameters(), startup_once);
    }

    public Word2Vec(Word2VecModel.Word2VecParameters parms) {
        super((Model.Parameters)parms);
        this.init(false);
    }

    protected Word2VecDriver trainModelImpl() {
        return new Word2VecDriver();
    }

    public void init(boolean expensive) {
        super.init(expensive);
        if (!(((Word2VecModel.Word2VecParameters)this._parms)._train == null || ((Word2VecModel.Word2VecParameters)this._parms).train().vecs().length != 0 && ((Word2VecModel.Word2VecParameters)this._parms).trainVec().isString())) {
            this.error("_train", "The first column of the training input frame has to be column of Strings.");
        }
        if (((Word2VecModel.Word2VecParameters)this._parms)._vec_size > 10000) {
            this.error("_vec_size", "Requested vector size of " + ((Word2VecModel.Word2VecParameters)this._parms)._vec_size + " in Word2Vec, exceeds limit of " + 10000 + ".");
        }
        if (((Word2VecModel.Word2VecParameters)this._parms)._vec_size < 1) {
            this.error("_vec_size", "Requested vector size of " + ((Word2VecModel.Word2VecParameters)this._parms)._vec_size + " in Word2Vec, is not allowed.");
        }
        if (((Word2VecModel.Word2VecParameters)this._parms)._window_size < 1) {
            this.error("_window_size", "Negative window size not allowed for Word2Vec.  Expected value > 0, received " + ((Word2VecModel.Word2VecParameters)this._parms)._window_size);
        }
        if ((double)((Word2VecModel.Word2VecParameters)this._parms)._sent_sample_rate < 0.0) {
            this.error("_sent_sample_rate", "Negative sentence sample rate not allowed for Word2Vec.  Expected a value > 0.0, received " + ((Word2VecModel.Word2VecParameters)this._parms)._sent_sample_rate);
        }
        if ((double)((Word2VecModel.Word2VecParameters)this._parms)._init_learning_rate < 0.0) {
            this.error("_init_learning_rate", "Negative learning rate not allowed for Word2Vec.  Expected a value > 0.0, received " + ((Word2VecModel.Word2VecParameters)this._parms)._init_learning_rate);
        }
        if (((Word2VecModel.Word2VecParameters)this._parms)._epochs < 1) {
            this.error("_epochs", "Negative epoch count not allowed for Word2Vec.  Expected value > 0, received " + ((Word2VecModel.Word2VecParameters)this._parms)._epochs);
        }
    }

    protected void ignoreBadColumns(int npredictors, boolean expensive) {
    }

    public boolean haveMojo() {
        return true;
    }

    public static Job<Word2VecModel> fromPretrainedModel(Frame model) {
        if (model == null || model.numCols() < 2) {
            throw new IllegalArgumentException("Frame representing an external word2vec needs to have at least 2 columns.");
        }
        if (model.vec(0).get_type() != 2) {
            throw new IllegalArgumentException("First column is expected to contain the dictionary words and be represented as String, instead got " + model.vec(0).get_type_str());
        }
        LinkedList<String> colErrors = new LinkedList<String>();
        for (int i = 1; i < model.numCols(); ++i) {
            if (model.vec(i).get_type() == 3) continue;
            colErrors.add(model.name(i) + " (type " + model.vec(i).get_type_str() + ")");
        }
        if (!colErrors.isEmpty()) {
            throw new IllegalArgumentException("All components of word2vec mapping are expected to be numeric. Invalid columns: " + StringUtils.join((String)", ", colErrors));
        }
        Word2VecModel.Word2VecParameters p = new Word2VecModel.Word2VecParameters();
        p._vec_size = model.numCols() - 1;
        p._pre_trained = model._key;
        return new Word2Vec(p).trainModel();
    }

    private class Word2VecDriver
    extends ModelBuilder.Driver {
        private Word2VecDriver() {
            super((ModelBuilder)Word2Vec.this);
        }

        public void computeImpl() {
            Word2VecModel model = null;
            try {
                Word2Vec.this.init(!((Word2VecModel.Word2VecParameters)Word2Vec.this._parms).isPreTrained());
                model = new Word2VecModel((Key<Word2VecModel>)Word2Vec.this._job._result, (Word2VecModel.Word2VecParameters)Word2Vec.this._parms, new Word2VecModel.Word2VecOutput(Word2Vec.this));
                model.delete_and_lock(Word2Vec.this._job);
                if (((Word2VecModel.Word2VecParameters)Word2Vec.this._parms).isPreTrained()) {
                    this.convertToModel((Frame)((Word2VecModel.Word2VecParameters)Word2Vec.this._parms)._pre_trained.get(), model);
                } else {
                    this.trainModel(model);
                }
            }
            finally {
                if (model != null) {
                    model.unlock(Word2Vec.this._job);
                }
            }
        }

        private void trainModel(Word2VecModel model) {
            Log.info((Object[])new Object[]{"Word2Vec: Initializing model training."});
            Word2VecModel.Word2VecModelInfo modelInfo = Word2VecModel.Word2VecModelInfo.createInitialModelInfo((Word2VecModel.Word2VecParameters)Word2Vec.this._parms);
            Log.info((Object[])new Object[]{"Word2Vec: Starting to train model, " + ((Word2VecModel.Word2VecParameters)Word2Vec.this._parms)._epochs + " epochs."});
            long tstart = System.currentTimeMillis();
            int i = 0;
            while (i < ((Word2VecModel.Word2VecParameters)Word2Vec.this._parms)._epochs) {
                long start = System.currentTimeMillis();
                WordVectorTrainer trainer = (WordVectorTrainer)new WordVectorTrainer((Job<Word2VecModel>)Word2Vec.this._job, modelInfo).doAll(new Vec[]{((Word2VecModel.Word2VecParameters)Word2Vec.this._parms).trainVec()});
                long stop = System.currentTimeMillis();
                long estProcessedWords = trainer._nodeProcessedWords._val;
                long actProcessedWords = trainer._processedWords;
                if ((double)estProcessedWords < 0.95 * (double)actProcessedWords) {
                    Log.warn((Object[])new Object[]{"Estimated number processed words " + estProcessedWords + " is significantly lower than actual number processed words " + actProcessedWords});
                }
                trainer.updateModelInfo(modelInfo);
                model.update(Word2Vec.this._job);
                double duration = (double)(stop - start) / 1000.0;
                Log.info((Object[])new Object[]{"Epoch " + i + " took " + duration + "s; Words trained/s: " + (double)actProcessedWords / duration});
                ((Word2VecModel.Word2VecOutput)model._output)._epochs = i++;
                if (Word2Vec.this.stop_requested()) break;
            }
            long tstop = System.currentTimeMillis();
            Log.info((Object[])new Object[]{"Total time: " + (double)(tstop - tstart) / 1000.0});
            Log.info((Object[])new Object[]{"Finished training the Word2Vec model."});
            model.buildModelOutput(modelInfo);
        }

        private void convertToModel(Frame preTrained, Word2VecModel model) {
            if (((Word2VecModel.Word2VecParameters)Word2Vec.this._parms)._vec_size != preTrained.numCols() - 1) {
                throw new IllegalStateException("Frame with pre-trained model doesn't conform to the specified vector length.");
            }
            WordVectorConverter result = (WordVectorConverter)new WordVectorConverter((Job<Word2VecModel>)Word2Vec.this._job, ((Word2VecModel.Word2VecParameters)Word2Vec.this._parms)._vec_size, (int)preTrained.numRows()).doAll(preTrained);
            model.buildModelOutput(result._words, result._syn0);
        }
    }

    public static enum NormModel {
        HSM;

    }

    public static enum WordModel {
        SkipGram;

    }
}

