/*
 * Decompiled with CFR 0.152.
 */
package hex.generic;

import hex.Model;
import hex.generic.GenericModel;
import hex.genmodel.attributes.parameters.ColumnSpecifier;
import hex.genmodel.attributes.parameters.ModelParameter;
import hex.genmodel.attributes.parameters.ParameterKey;
import water.Iced;
import water.IcedWrapper;
import water.Key;
import water.api.schemas3.FrameV3;
import water.api.schemas3.ModelParameterSchemaV3;
import water.fvec.Frame;

public class GenericModelParameters
extends Model.Parameters {
    public String _path;
    public Key<Frame> _model_key;
    public boolean _disable_algo_check;
    public ModelParameterSchemaV3[] _modelParameters;

    protected static ModelParameterSchemaV3[] convertParameters(ModelParameter[] originalParams) {
        ModelParameterSchemaV3[] convertedParams = new ModelParameterSchemaV3[originalParams.length];
        for (int i = 0; i < originalParams.length; ++i) {
            ModelParameter originalParam = originalParams[i];
            ModelParameterSchemaV3 convertedParam = new ModelParameterSchemaV3();
            convertedParam.name = originalParam.name;
            convertedParam.label = originalParam.label;
            convertedParam.is_mutually_exclusive_with = originalParam.is_mutually_exclusive_with;
            convertedParam.is_member_of_frames = originalParam.is_member_of_frames;
            convertedParam.values = originalParam.values;
            convertedParam.help = originalParam.help;
            convertedParam.level = originalParam.level;
            convertedParam.gridable = originalParam.gridable;
            convertedParam.required = originalParam.required;
            convertedParam.type = originalParam.type;
            convertedParam.actual_value = GenericModelParameters.convertObjectToIced(originalParam.actual_value);
            convertedParam.default_value = GenericModelParameters.convertObjectToIced(originalParam.default_value);
            convertedParams[i] = convertedParam;
        }
        return convertedParams;
    }

    private static Iced convertObjectToIced(Object original) {
        Key converted;
        if (original == null) {
            converted = null;
        } else if (original instanceof ParameterKey) {
            ParameterKey parameterKey = (ParameterKey)original;
            converted = Key.makeUserHidden((String)parameterKey.getName());
        } else if (original instanceof ColumnSpecifier) {
            ColumnSpecifier columnSpecifier = (ColumnSpecifier)original;
            converted = new FrameV3.ColSpecifierV3(columnSpecifier.getColumnName(), columnSpecifier.getIsMemberOfFrames());
        } else {
            converted = new IcedWrapper(original);
        }
        return converted;
    }

    public String algoName() {
        return "Generic";
    }

    public String fullName() {
        return "Import MOJO Model";
    }

    public String javaName() {
        return GenericModel.class.getName();
    }

    public long progressUnits() {
        return 100L;
    }
}

