/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.gbm;

import hex.Distribution;
import hex.DistributionFactory;
import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.genmodel.GenModel;
import hex.genmodel.utils.DistributionFamily;
import hex.quantile.Quantile;
import hex.quantile.QuantileModel;
import hex.tree.Constraints;
import hex.tree.DHistogram;
import hex.tree.DTree;
import hex.tree.Sample;
import hex.tree.ScoreBuildHistogram;
import hex.tree.SharedTree;
import hex.tree.SharedTreeModel;
import hex.tree.TreeUtils;
import hex.tree.gbm.GBMModel;
import java.util.Arrays;
import java.util.Random;
import water.DKV;
import water.H2O;
import water.H2ONode;
import water.Job;
import water.Key;
import water.Keyed;
import water.MRTask;
import water.exceptions.H2OModelBuilderIllegalArgumentException;
import water.fvec.C0DChunk;
import water.fvec.C4VolatileChunk;
import water.fvec.C8DVolatileChunk;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.util.ArrayUtils;
import water.util.Log;
import water.util.MathUtils;
import water.util.RandomUtils;

public class GBM
extends SharedTree<GBMModel, GBMModel.GBMParameters, GBMModel.GBMOutput> {
    public ModelCategory[] can_build() {
        return new ModelCategory[]{ModelCategory.Regression, ModelCategory.Binomial, ModelCategory.Multinomial};
    }

    public GBM(GBMModel.GBMParameters parms) {
        super(parms);
        this.init(false);
    }

    public GBM(GBMModel.GBMParameters parms, Key<GBMModel> key) {
        super(parms, key);
        this.init(false);
    }

    public GBM(boolean startup_once) {
        super(new GBMModel.GBMParameters(), startup_once);
    }

    protected int nModelsInParallel(int folds) {
        return this.nModelsInParallel(folds, 2);
    }

    protected GBMDriver trainModelImpl() {
        return new GBMDriver();
    }

    @Override
    public void init(boolean expensive) {
        super.init(expensive);
        if (expensive) {
            if (this.error_count() > 0) {
                throw H2OModelBuilderIllegalArgumentException.makeFromBuilder((ModelBuilder)this);
            }
            if (((GBMModel.GBMParameters)this._parms)._distribution == DistributionFamily.AUTO) {
                if (this._nclass == 1) {
                    ((GBMModel.GBMParameters)this._parms)._distribution = DistributionFamily.gaussian;
                }
                if (this._nclass == 2) {
                    ((GBMModel.GBMParameters)this._parms)._distribution = DistributionFamily.bernoulli;
                }
                if (this._nclass >= 3) {
                    ((GBMModel.GBMParameters)this._parms)._distribution = DistributionFamily.multinomial;
                }
            }
            this.checkDistributions();
            if (this.hasOffsetCol() && this.isClassifier() && (((GBMModel.GBMParameters)this._parms)._distribution == DistributionFamily.multinomial || ((GBMModel.GBMParameters)this._parms)._distribution == DistributionFamily.custom)) {
                this.error("_offset_column", "Offset is not supported for " + ((GBMModel.GBMParameters)this._parms)._distribution + " distribution.");
            }
            if (((GBMModel.GBMParameters)this._parms)._monotone_constraints != null && ((GBMModel.GBMParameters)this._parms)._monotone_constraints.length > 0 && !DistributionFamily.gaussian.equals((Object)((GBMModel.GBMParameters)this._parms)._distribution) && !DistributionFamily.bernoulli.equals((Object)((GBMModel.GBMParameters)this._parms)._distribution)) {
                this.error("_monotone_constraints", "Monotone constraints are only supported for Gaussian and Bernoulli distributions, your distribution: " + ((GBMModel.GBMParameters)this._parms)._distribution + ".");
            }
        }
        switch (((GBMModel.GBMParameters)this._parms)._distribution) {
            case bernoulli: {
                if (this._nclass == 2) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Binomial requires the response to be a 2-class categorical"));
                break;
            }
            case quasibinomial: {
                if (!this._response.isNumeric()) {
                    this.error("_distribution", H2O.technote((int)2, (String)"Quasibinomial requires the response to be numeric."));
                }
                if (this._nclass == 2) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Quasibinomial requires the response to be binary."));
                break;
            }
            case modified_huber: {
                if (this._nclass == 2) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Modified Huber requires the response to be a 2-class categorical."));
                break;
            }
            case multinomial: {
                if (this.isClassifier()) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Multinomial requires an categorical response."));
                break;
            }
            case huber: {
                if (!this.isClassifier()) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Huber requires the response to be numeric."));
                break;
            }
            case poisson: {
                if (!this.isClassifier()) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Poisson requires the response to be numeric."));
                break;
            }
            case gamma: {
                if (!this.isClassifier()) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Gamma requires the response to be numeric."));
                break;
            }
            case tweedie: {
                if (!this.isClassifier()) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Tweedie requires the response to be numeric."));
                break;
            }
            case gaussian: {
                if (!this.isClassifier()) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Gaussian requires the response to be numeric."));
                break;
            }
            case laplace: {
                if (!this.isClassifier()) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Laplace requires the response to be numeric."));
                break;
            }
            case quantile: {
                if (!this.isClassifier()) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Quantile requires the response to be numeric."));
                break;
            }
            case custom: {
                if (((GBMModel.GBMParameters)this._parms)._custom_distribution_func != null) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Custom requires custom function loaded."));
                break;
            }
            case AUTO: {
                break;
            }
            default: {
                this.error("_distribution", "Invalid distribution: " + ((GBMModel.GBMParameters)this._parms)._distribution);
            }
        }
        if (!(0.0 < ((GBMModel.GBMParameters)this._parms)._learn_rate) || !(((GBMModel.GBMParameters)this._parms)._learn_rate <= 1.0)) {
            this.error("_learn_rate", "learn_rate must be between 0 and 1");
        }
        if (!(0.0 < ((GBMModel.GBMParameters)this._parms)._learn_rate_annealing) || !(((GBMModel.GBMParameters)this._parms)._learn_rate_annealing <= 1.0)) {
            this.error("_learn_rate_annealing", "learn_rate_annealing must be between 0 and 1");
        }
        if (!(0.0 < ((GBMModel.GBMParameters)this._parms)._col_sample_rate) || !(((GBMModel.GBMParameters)this._parms)._col_sample_rate <= 1.0)) {
            this.error("_col_sample_rate", "col_sample_rate must be between 0 and 1");
        }
        if (((GBMModel.GBMParameters)this._parms)._max_abs_leafnode_pred <= 0.0) {
            this.error("_max_abs_leafnode_pred", "max_abs_leafnode_pred must be larger than 0.");
        }
        if (((GBMModel.GBMParameters)this._parms)._pred_noise_bandwidth < 0.0) {
            this.error("_pred_noise_bandwidth", "pred_noise_bandwidth must be >= 0.");
        }
        if (this._train != null && ((GBMModel.GBMParameters)this._parms)._monotone_constraints != null) {
            TreeUtils.checkMonotoneConstraints(this, this._train, ((GBMModel.GBMParameters)this._parms)._monotone_constraints);
        }
    }

    @Override
    protected double score1(Chunk[] chks, double weight, double offset, double[] fs, int row) {
        return GBM.score1static(chks, this.idx_tree(0), offset, fs, row, DistributionFactory.getDistribution((Model.Parameters)this._parms), this._nclass);
    }

    private static double score1static(Chunk[] chks, int treeIdx, double offset, double[] fs, int row, Distribution dist, int nClasses) {
        double f = chks[treeIdx].atd(row) + offset;
        double p = dist.linkInv(f);
        if (dist._family == DistributionFamily.modified_huber || dist._family == DistributionFamily.bernoulli || dist._family == DistributionFamily.quasibinomial || dist._family == DistributionFamily.custom && nClasses == 2) {
            fs[2] = p;
            fs[1] = 1.0 - p;
            return 1.0;
        }
        if (dist._family == DistributionFamily.multinomial || dist._family == DistributionFamily.custom && nClasses > 2) {
            if (nClasses == 2) {
                fs[1] = p;
                fs[2] = 1.0 / p;
                return fs[1] + fs[2];
            }
            assert (offset == 0.0);
            fs[1] = f;
            for (int k = 1; k < nClasses; ++k) {
                fs[k + 1] = chks[treeIdx + k].atd(row);
            }
            return GenModel.log_rescale((double[])fs);
        }
        fs[0] = p;
        return fs[0];
    }

    private static class AddTreeContributions
    extends MRTask<AddTreeContributions> {
        private SharedTree.FrameMap fm;
        private DTree[] _ktrees;
        private int _nclass;
        private double _pred_noise_bandwidth;
        private long _seed;
        private int _ntrees1;
        private int _ntrees2;

        public AddTreeContributions(SharedTree.FrameMap frameMap, DTree[] ktrees, double predictionNoiseBandwidth, long seed, int nTreesInp, int nTreesOut) {
            this.fm = frameMap;
            this._ktrees = ktrees;
            this._nclass = ktrees.length;
            this._pred_noise_bandwidth = predictionNoiseBandwidth;
            this._seed = seed;
            this._ntrees1 = nTreesInp;
            this._ntrees2 = nTreesOut;
        }

        protected boolean modifiesVolatileVecs() {
            return true;
        }

        public void map(Chunk[] chks) {
            Random rand = RandomUtils.getRNG((long[])new long[]{this._seed});
            for (int k = 0; k < this._nclass; ++k) {
                DTree tree = this._ktrees[k];
                if (tree == null) continue;
                C4VolatileChunk nids = (C4VolatileChunk)chks[this.fm.nids0Index + k];
                int[] nids_vals = nids.getValues();
                C8DVolatileChunk ct = (C8DVolatileChunk)chks[this.fm.tree0Index + k];
                double[] ct_vals = ct.getValues();
                Chunk y = chks[this.fm.responseIndex];
                C0DChunk weights = this.fm.weightIndex >= 0 ? chks[this.fm.weightIndex] : new C0DChunk(1.0, chks[0]._len);
                long baseseed = (912559L + this._seed) * (long)(-89478485 + k * this._ntrees1 + this._ntrees2);
                for (int row = 0; row < nids._len; ++row) {
                    int nid = nids_vals[row];
                    nids_vals[row] = 0;
                    if (nid < 0 || y.isNA(row) || weights.atd(row) == 0.0) continue;
                    double factor = 1.0;
                    if (this._pred_noise_bandwidth != 0.0) {
                        rand.setSeed(baseseed + (long)nid);
                        factor += rand.nextGaussian() * this._pred_noise_bandwidth;
                    }
                    ct_vals[row] = (float)(ct.atd(row) + factor * (double)((DTree.LeafNode)tree.node((int)nid))._pred);
                }
            }
        }
    }

    private static class GammaPass
    extends MRTask<GammaPass> {
        private final SharedTree.FrameMap fm;
        private final DTree[] _trees;
        private final int[] _leafs;
        private final Distribution _dist;
        private final int _nclass;
        private double[][] _num;
        private double[][] _denom;

        public GammaPass(SharedTree.FrameMap frameMap, DTree[] trees, int[] leafs, Distribution distribution, int nClasses) {
            this.fm = frameMap;
            this._leafs = leafs;
            this._trees = trees;
            this._dist = distribution;
            this._nclass = nClasses;
        }

        double gamma(int tree, int nid) {
            return this.gamma(tree, nid, this._num[tree][nid]);
        }

        double gamma(int tree, int nid, double num) {
            if (this._denom[tree][nid] == 0.0) {
                return 0.0;
            }
            double g = num / this._denom[tree][nid];
            assert (!Double.isInfinite(g) && !Double.isNaN(g));
            if (this._dist._family == DistributionFamily.poisson || this._dist._family == DistributionFamily.gamma || this._dist._family == DistributionFamily.tweedie) {
                return this._dist.link(g);
            }
            return g;
        }

        protected boolean modifiesVolatileVecs() {
            return true;
        }

        public void map(Chunk[] chks) {
            this._denom = new double[this._nclass][];
            this._num = new double[this._nclass][];
            Chunk resp = chks[this.fm.responseIndex];
            for (int k = 0; k < this._nclass; ++k) {
                C0DChunk weights;
                DTree tree = this._trees[k];
                int leaf = this._leafs[k];
                if (tree == null) continue;
                assert (tree._len - leaf >= 0);
                this._denom[k] = new double[tree._len - leaf];
                double[] denom = this._denom[k];
                this._num[k] = new double[tree._len - leaf];
                double[] num = this._num[k];
                C4VolatileChunk nids = (C4VolatileChunk)chks[this.fm.nids0Index + k];
                int[] nids_vals = nids.getValues();
                Chunk ress = chks[this.fm.work0Index + k];
                C0DChunk offset = this.fm.offsetIndex >= 0 ? chks[this.fm.offsetIndex] : new C0DChunk(0.0, chks[0]._len);
                Chunk preds = chks[this.fm.tree0Index + k];
                Object object = weights = this.fm.weightIndex >= 0 ? chks[this.fm.weightIndex] : new C0DChunk(1.0, chks[0]._len);
                if (tree.root() instanceof DTree.LeafNode) continue;
                for (int row = 0; row < nids._len; ++row) {
                    int idx;
                    double y;
                    double w = weights.atd(row);
                    if (w == 0.0 || Double.isNaN(y = resp.atd(row))) continue;
                    int nid = (int)nids.at8(row);
                    boolean wasOOBRow = ScoreBuildHistogram.isOOBRow(nid);
                    if (wasOOBRow) {
                        nid = ScoreBuildHistogram.oob2Nid(nid);
                    }
                    if (nid < 0) continue;
                    DTree.DecidedNode dn = tree.decided(nid);
                    if (dn._split == null) {
                        dn = tree.decided(dn.pid());
                    }
                    int leafnid = dn.getChildNodeID(chks, row);
                    assert (leaf <= leafnid && leafnid < tree._len) : "leaf: " + leaf + " leafnid: " + leafnid + " tree._len: " + tree._len + "\ndn: " + (Object)((Object)dn);
                    assert (tree.node(leafnid) instanceof DTree.LeafNode);
                    nids_vals[row] = leafnid;
                    assert (!ress.isNA(row));
                    if (wasOOBRow || this._dist._family == DistributionFamily.laplace || this._dist._family == DistributionFamily.huber || this._dist._family == DistributionFamily.quantile) continue;
                    double z = ress.atd(row);
                    double f = preds.atd(row) + offset.atd(row);
                    int n = idx = leafnid - leaf;
                    num[n] = num[n] + this._dist.gammaNum(w, y, z, f);
                    int n2 = idx;
                    denom[n2] = denom[n2] + this._dist.gammaDenom(w, y, z, f);
                }
            }
        }

        public void reduce(GammaPass gp) {
            ArrayUtils.add((double[][])this._denom, (double[][])gp._denom);
            ArrayUtils.add((double[][])this._num, (double[][])gp._num);
        }
    }

    private static class StoreResiduals
    extends MRTask<StoreResiduals> {
        private SharedTree.FrameMap fm;
        private Distribution dist;

        public StoreResiduals(SharedTree.FrameMap frameMap, Distribution distribution) {
            this.fm = frameMap;
            this.dist = distribution;
        }

        protected boolean modifiesVolatileVecs() {
            return true;
        }

        public void map(Chunk[] chks) {
            Chunk ys = chks[this.fm.responseIndex];
            C0DChunk offset = this.fm.offsetIndex >= 0 ? chks[this.fm.offsetIndex] : new C0DChunk(0.0, chks[0]._len);
            Chunk preds = chks[this.fm.tree0Index];
            C8DVolatileChunk wk = (C8DVolatileChunk)chks[this.fm.work0Index];
            C0DChunk weights = this.fm.weightIndex >= 0 ? chks[this.fm.weightIndex] : new C0DChunk(1.0, chks[0]._len);
            for (int row = 0; row < wk._len; ++row) {
                double weight = weights.atd(row);
                if (weight == 0.0 || ys.isNA(row)) continue;
                double f = preds.atd(row) + offset.atd(row);
                double y = ys.atd(row);
                wk.getValues()[row] = (float)this.dist.negHalfGradient(y, f);
            }
        }
    }

    private static final class HuberLeafMath
    extends MRTask<HuberLeafMath> {
        final SharedTree.FrameMap fm;
        final double _huberDelta;
        final Vec _strata;
        final int _strataMin;
        final int _strataMax;
        double[] _huberGamma;
        double[] _wcounts;

        public HuberLeafMath(SharedTree.FrameMap frameMap, double huberDelta, Vec strata) {
            this.fm = frameMap;
            this._huberDelta = huberDelta;
            this._strata = strata;
            this._strataMin = (int)this._strata.min();
            this._strataMax = (int)this._strata.max();
        }

        public void map(Chunk[] cs) {
            if (this._strata.length() == 0L) {
                Log.warn((Object[])new Object[]{"No Huber math can be done since there's no strata."});
                this._huberGamma = new double[0];
                return;
            }
            int nstrata = this._strataMax - this._strataMin + 1;
            Log.info((Object[])new Object[]{"Computing Huber math for (up to) " + nstrata + " different strata."});
            this._huberGamma = new double[nstrata];
            this._wcounts = new double[nstrata];
            C0DChunk weights = this.fm.weightIndex >= 0 ? cs[this.fm.weightIndex] : new C0DChunk(1.0, cs[0]._len);
            Chunk stratum = cs[this.fm.nids0Index];
            Chunk diffMinusMedianDiff = cs[cs.length - 1];
            for (int row = 0; row < cs[0]._len; ++row) {
                int nidx;
                int n = nidx = (int)stratum.at8(row) - this._strataMin;
                this._huberGamma[n] = this._huberGamma[n] + weights.atd(row) * Math.signum(diffMinusMedianDiff.atd(row)) * Math.min(Math.abs(diffMinusMedianDiff.atd(row)), this._huberDelta);
                int n2 = nidx;
                this._wcounts[n2] = this._wcounts[n2] + weights.atd(row);
            }
        }

        public void reduce(HuberLeafMath mrt) {
            ArrayUtils.add((double[])this._huberGamma, (double[])mrt._huberGamma);
            ArrayUtils.add((double[])this._wcounts, (double[])mrt._wcounts);
        }

        protected void postGlobal() {
            for (int i = 0; i < this._huberGamma.length; ++i) {
                int n = i;
                this._huberGamma[n] = this._huberGamma[n] / this._wcounts[i];
            }
        }
    }

    public static class DiffMinusMedianDiff
    extends MRTask<DiffMinusMedianDiff> {
        private final int _strataMin;
        private double[] _terminalMedians;

        public DiffMinusMedianDiff(Vec strata, double[] terminalMedians) {
            this._strataMin = (int)strata.min();
            this._terminalMedians = terminalMedians;
        }

        public void map(Chunk[] chks) {
            Chunk strata = chks[0];
            Chunk diff = chks[1];
            for (int i = 0; i < chks[0].len(); ++i) {
                int nid = (int)strata.atd(i);
                diff.set(i, diff.atd(i) - this._terminalMedians[nid - this._strataMin]);
            }
        }
    }

    private static class ComputeAbsDiff
    extends MRTask<ComputeAbsDiff> {
        private SharedTree.FrameMap fm;

        public ComputeAbsDiff(SharedTree.FrameMap frameMap) {
            this.fm = frameMap;
        }

        public void map(Chunk[] chks, NewChunk[] nc) {
            Chunk y = chks[this.fm.responseIndex];
            C0DChunk o = this.fm.offsetIndex >= 0 ? chks[this.fm.offsetIndex] : new C0DChunk(0.0, chks[0]._len);
            Chunk f = chks[this.fm.tree0Index];
            for (int i = 0; i < chks[0].len(); ++i) {
                nc[0].addNum(Math.abs(y.atd(i) - (f.atd(i) + o.atd(i))));
            }
        }
    }

    private static class ComputeDiff
    extends MRTask<ComputeDiff> {
        private SharedTree.FrameMap fm;

        public ComputeDiff(SharedTree.FrameMap frameMap) {
            this.fm = frameMap;
        }

        public void map(Chunk[] chks, NewChunk[] nc) {
            Chunk y = chks[this.fm.responseIndex];
            C0DChunk o = this.fm.offsetIndex >= 0 ? chks[this.fm.offsetIndex] : new C0DChunk(0.0, chks[0]._len);
            Chunk f = chks[this.fm.tree0Index];
            for (int i = 0; i < chks[0].len(); ++i) {
                nc[0].addNum(y.atd(i) - (f.atd(i) + o.atd(i)));
            }
        }
    }

    private static class ComputeMinMax
    extends MRTask<ComputeMinMax> {
        private SharedTree.FrameMap fm;
        int firstLeafIdx;
        int _totalNumNodes;
        float[] _mins;
        float[] _maxs;

        public ComputeMinMax(SharedTree.FrameMap frameMap, int firstLeafIndex, int totalNumNodes) {
            this.fm = frameMap;
            this.firstLeafIdx = firstLeafIndex;
            this._totalNumNodes = totalNumNodes;
        }

        public void map(Chunk[] chks) {
            int len = this._totalNumNodes - this.firstLeafIdx;
            this._mins = new float[len];
            this._maxs = new float[len];
            Arrays.fill(this._mins, Float.MAX_VALUE);
            Arrays.fill(this._maxs, -3.4028235E38f);
            Chunk ys = chks[this.fm.responseIndex];
            C0DChunk offset = this.fm.offsetIndex >= 0 ? chks[this.fm.offsetIndex] : new C0DChunk(0.0, chks[0]._len);
            Chunk preds = chks[this.fm.tree0Index];
            Chunk nids = chks[this.fm.nids0Index];
            C0DChunk weights = this.fm.weightIndex >= 0 ? chks[this.fm.weightIndex] : new C0DChunk(1.0, chks[0]._len);
            for (int row = 0; row < preds._len; ++row) {
                if (ys.isNA(row) || weights.atd(row) == 0.0) continue;
                int nid = (int)nids.at8(row);
                assert (nid != -1);
                if (nid < 0) continue;
                float f = (float)(preds.atd(row) + offset.atd(row));
                int idx = nid - this.firstLeafIdx;
                this._mins[idx] = Math.min(this._mins[idx], f);
                this._maxs[idx] = Math.max(this._maxs[idx], f);
            }
        }

        public void reduce(ComputeMinMax mrt) {
            ArrayUtils.reduceMin((float[])this._mins, (float[])mrt._mins);
            ArrayUtils.reduceMax((float[])this._maxs, (float[])mrt._maxs);
        }
    }

    private static class ComputePredAndRes
    extends MRTask<ComputePredAndRes> {
        private SharedTree.FrameMap fm;
        private int nclass;
        private boolean[] out;
        private Distribution dist;

        public ComputePredAndRes(SharedTree.FrameMap frameMap, int nClasses, double[] outputDistribution, Distribution distribution) {
            this.fm = frameMap;
            this.nclass = nClasses;
            this.dist = distribution;
            this.out = new boolean[outputDistribution.length];
            for (int i = 0; i < this.out.length; ++i) {
                this.out[i] = outputDistribution[i] != 0.0;
            }
        }

        public void map(Chunk[] chks) {
            Chunk ys = chks[this.fm.responseIndex];
            C0DChunk offset = this.fm.offsetIndex >= 0 ? chks[this.fm.offsetIndex] : new C0DChunk(0.0, chks[0]._len);
            Chunk preds = chks[this.fm.tree0Index];
            C8DVolatileChunk wk = (C8DVolatileChunk)chks[this.fm.work0Index];
            C0DChunk weights = this.fm.weightIndex >= 0 ? chks[this.fm.weightIndex] : new C0DChunk(1.0, chks[0]._len);
            double[] fs = this.nclass > 1 ? new double[this.nclass + 1] : null;
            for (int row = 0; row < wk._len; ++row) {
                double weight = weights.atd(row);
                if (weight == 0.0 || ys.isNA(row)) continue;
                double f = preds.atd(row) + offset.atd(row);
                double y = ys.atd(row);
                if (this.dist._family == DistributionFamily.multinomial && fs != null || this.dist._family == DistributionFamily.custom && this.nclass > 2) {
                    int k;
                    double sum = GBM.score1static(chks, this.fm.tree0Index, 0.0, fs, row, this.dist, this.nclass);
                    if (Double.isInfinite(sum)) {
                        for (k = 0; k < this.nclass; ++k) {
                            wk = (C8DVolatileChunk)chks[this.fm.work0Index + k];
                            wk.getValues()[row] = (float)this.dist.negHalfGradient(y, (double)(Double.isInfinite(fs[k + 1]) ? 1.0f : 0.0f), k);
                        }
                        continue;
                    }
                    for (k = 0; k < this.nclass; ++k) {
                        if (!this.out[k]) continue;
                        wk = (C8DVolatileChunk)chks[this.fm.work0Index + k];
                        wk.getValues()[row] = (float)this.dist.negHalfGradient(y, (double)((float)(fs[k + 1] / sum)), k);
                    }
                    continue;
                }
                wk.getValues()[row] = (float)this.dist.negHalfGradient(y, f);
            }
        }
    }

    private static class NewtonRaphson
    extends MRTask<NewtonRaphson> {
        private SharedTree.FrameMap fm;
        private Distribution dist;
        private double _init;
        private double _numerator;
        private double _denominator;

        public NewtonRaphson(SharedTree.FrameMap frameMap, Distribution distribution, double initialValue) {
            assert (frameMap != null && distribution != null);
            this.fm = frameMap;
            this.dist = distribution;
            this._init = initialValue;
            this._numerator = 0.0;
            this._denominator = 0.0;
        }

        public double value() {
            return this._init + this._numerator / this._denominator;
        }

        public void map(Chunk[] chks) {
            Chunk ys = chks[this.fm.responseIndex];
            Chunk offset = chks[this.fm.offsetIndex];
            C0DChunk weight = this.fm.weightIndex >= 0 ? chks[this.fm.weightIndex] : new C0DChunk(1.0, chks[0]._len);
            for (int row = 0; row < ys._len; ++row) {
                double w = weight.atd(row);
                if (w == 0.0 || ys.isNA(row)) continue;
                double y = ys.atd(row);
                double o = offset.atd(row);
                double p = this.dist.linkInv(o + this._init);
                this._numerator += w * (y - p);
                this._denominator += w * p * (1.0 - p);
            }
        }

        public void reduce(NewtonRaphson mrt) {
            this._numerator += mrt._numerator;
            this._denominator += mrt._denominator;
        }
    }

    private static class ResponseLessOffsetTask
    extends MRTask<ResponseLessOffsetTask> {
        private SharedTree.FrameMap fm;

        public ResponseLessOffsetTask(SharedTree.FrameMap frameMap) {
            this.fm = frameMap;
        }

        public void map(Chunk[] chks, NewChunk[] nc) {
            Chunk resp = chks[this.fm.responseIndex];
            Chunk offset = chks[this.fm.offsetIndex];
            for (int i = 0; i < chks[0]._len; ++i) {
                nc[0].addNum(resp.atd(i) - offset.atd(i));
            }
        }
    }

    private static class FillVecWithConstant
    extends MRTask<FillVecWithConstant> {
        private double init;

        public FillVecWithConstant(double d) {
            this.init = d;
        }

        protected boolean modifiesVolatileVecs() {
            return true;
        }

        public void map(Chunk tree) {
            if (tree instanceof C8DVolatileChunk) {
                Arrays.fill(((C8DVolatileChunk)tree).getValues(), this.init);
            } else {
                for (int i = 0; i < tree._len; ++i) {
                    tree.set(i, this.init);
                }
            }
        }
    }

    private class GBMDriver
    extends SharedTree.Driver {
        private transient SharedTree.FrameMap frameMap;
        private static final double MIN_LOG_TRUNC = -19.0;
        private static final double MAX_LOG_TRUNC = 19.0;

        private GBMDriver() {
        }

        @Override
        protected Frame makeValidWorkspace() {
            Vec[] tmp = GBM.this._valid.anyVec().makeVolatileDoubles(this.numClassTrees());
            String[] tmpNames = new String[tmp.length];
            for (int i = 0; i < tmpNames.length; ++i) {
                tmpNames[i] = "__P_" + i;
            }
            return new Frame(tmpNames, tmp);
        }

        @Override
        protected boolean doOOBScoring() {
            return false;
        }

        @Override
        protected void initializeModelSpecifics() {
            this.frameMap = new SharedTree.FrameMap(GBM.this);
            GBM.this._mtry_per_tree = Math.max(1, (int)(((GBMModel.GBMParameters)GBM.this._parms)._col_sample_rate_per_tree * (double)GBM.this._ncols));
            if (1 > GBM.this._mtry_per_tree || GBM.this._mtry_per_tree > GBM.this._ncols) {
                throw new IllegalArgumentException("Computed mtry_per_tree should be in interval <1," + GBM.this._ncols + "> but it is " + GBM.this._mtry_per_tree);
            }
            GBM.this._mtry = Math.max(1, (int)(((GBMModel.GBMParameters)GBM.this._parms)._col_sample_rate * ((GBMModel.GBMParameters)GBM.this._parms)._col_sample_rate_per_tree * (double)GBM.this._ncols));
            if (1 > GBM.this._mtry || GBM.this._mtry > GBM.this._ncols) {
                throw new IllegalArgumentException("Computed mtry should be in interval <1," + GBM.this._ncols + "> but it is " + GBM.this._mtry);
            }
            DistributionFamily distr = ((GBMModel.GBMParameters)GBM.this._parms)._distribution;
            GBM.this._initialPrediction = GBM.this._nclass > 2 || distr == DistributionFamily.laplace || distr == DistributionFamily.huber || distr == DistributionFamily.quantile ? 0.0 : GBM.this.getInitialValue();
            if (distr == DistributionFamily.bernoulli || distr == DistributionFamily.quasibinomial) {
                if (GBM.this.hasOffsetCol()) {
                    GBM.this._initialPrediction = this.getInitialValueBernoulliOffset(GBM.this._train);
                }
            } else if (distr == DistributionFamily.laplace || distr == DistributionFamily.huber) {
                GBM.this._initialPrediction = this.getInitialValueQuantile(0.5);
            } else if (distr == DistributionFamily.quantile) {
                GBM.this._initialPrediction = this.getInitialValueQuantile(((GBMModel.GBMParameters)GBM.this._parms)._quantile_alpha);
            }
            ((GBMModel.GBMOutput)((GBMModel)((GBM)GBM.this)._model)._output)._init_f = GBM.this._initialPrediction;
            if (GBM.this._initialPrediction != 0.0) {
                new FillVecWithConstant(GBM.this._initialPrediction).doAll(GBM.this.vec_tree(GBM.this._train, 0), ((GBMModel.GBMParameters)GBM.this._parms)._build_tree_one_node);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private double getInitialValueQuantile(double quantile) {
            double res;
            Vec y = GBM.this.hasOffsetCol() ? ((ResponseLessOffsetTask)new ResponseLessOffsetTask(this.frameMap).doAll(1, (byte)3, GBM.this._train)).outputFrame().anyVec() : GBM.this.response();
            QuantileModel qm = null;
            Frame tempFrame = null;
            try {
                tempFrame = new Frame(Key.make((H2ONode)H2O.SELF), new String[]{"y"}, new Vec[]{y});
                if (GBM.this.hasWeightCol()) {
                    tempFrame.add("w", GBM.this._weights);
                }
                DKV.put((Keyed)tempFrame);
                QuantileModel.QuantileParameters parms = new QuantileModel.QuantileParameters();
                parms._train = tempFrame._key;
                parms._probs = new double[]{quantile};
                parms._weights_column = GBM.this.hasWeightCol() ? "w" : null;
                Job job1 = new Quantile(parms).trainModel();
                qm = (QuantileModel)job1.get();
                res = ((QuantileModel.QuantileOutput)qm._output)._quantiles[0][0];
            }
            finally {
                if (qm != null) {
                    qm.remove();
                }
                if (tempFrame != null) {
                    DKV.remove((Key)tempFrame._key);
                }
            }
            return res;
        }

        private double getInitialValueBernoulliOffset(Frame train) {
            double delta;
            Log.info((Object[])new Object[]{"Running Newton-Raphson iteration to find the initial value since offsets are specified."});
            int count = 0;
            double tol = 1.0E-4;
            int N = 1;
            double init = 0.0;
            do {
                double newInit = ((NewtonRaphson)new NewtonRaphson(this.frameMap, DistributionFactory.getDistribution((Model.Parameters)GBM.this._parms), init).doAll(train)).value();
                delta = Math.abs(init - newInit);
                init = newInit;
                Log.info((Object[])new Object[]{"Iteration " + ++count + ": initial value: " + init});
            } while (count < N && delta >= tol);
            if (delta > tol) {
                Log.warn((Object[])new Object[]{"Not fully converged."});
            }
            Log.info((Object[])new Object[]{"Newton-Raphson iteration ran for " + count + " iteration(s). Final residual: " + delta});
            return init;
        }

        private void truncatePreds(DTree tree, int firstLeafIndex, DistributionFamily dist) {
            if (firstLeafIndex == tree._len) {
                return;
            }
            ComputeMinMax minMax = (ComputeMinMax)new ComputeMinMax(this.frameMap, firstLeafIndex, tree._len).doAll(GBM.this._train);
            for (int i = 0; i < tree._len - firstLeafIndex; ++i) {
                DTree.LeafNode node = (DTree.LeafNode)tree.node(firstLeafIndex + i);
                int nidx = node.nid();
                float nodeMin = minMax._mins[nidx - firstLeafIndex];
                float nodeMax = minMax._maxs[nidx - firstLeafIndex];
                double val = node._pred;
                if (dist == DistributionFamily.gamma || dist == DistributionFamily.tweedie) {
                    val += (double)nodeMax;
                }
                if (val > 19.0) {
                    node._pred = (float)(19.0 - (double)nodeMax);
                }
                val = node._pred;
                if (dist == DistributionFamily.gamma || dist == DistributionFamily.tweedie) {
                    val += (double)nodeMin;
                }
                if (val < -19.0) {
                    node._pred = (float)(-19.0 - (double)nodeMin);
                }
                if (!((double)node._pred < -19.0) || !((double)node._pred > 19.0)) continue;
                Log.warn((Object[])new Object[]{"Terminal node prediction outside of allowed interval in log-space: " + node._pred + " (should be in " + -19.0 + "..." + 19.0 + ")."});
            }
        }

        @Override
        protected boolean buildNextKTrees() {
            boolean converged;
            DTree[] ktrees = new DTree[GBM.this._nclass];
            int[] leaves = new int[GBM.this._nclass];
            Distribution distributionImpl = DistributionFactory.getDistribution((Model.Parameters)GBM.this._parms);
            double huberDelta = Double.NaN;
            if (((GBMModel.GBMParameters)GBM.this._parms)._distribution == DistributionFamily.huber) {
                Vec diff = ((ComputeAbsDiff)new ComputeAbsDiff(this.frameMap).doAll(1, (byte)3, GBM.this._train)).outputFrame().anyVec();
                huberDelta = MathUtils.computeWeightedQuantile((Vec)GBM.this._weights, (Vec)diff, (double)((GBMModel.GBMParameters)GBM.this._parms)._huber_alpha);
                distributionImpl.setHuberDelta(huberDelta);
                new StoreResiduals(this.frameMap, distributionImpl).doAll(GBM.this._train, ((GBMModel.GBMParameters)GBM.this._parms)._build_tree_one_node);
            } else {
                new ComputePredAndRes(this.frameMap, GBM.this._nclass, ((GBMModel.GBMOutput)((GBMModel)((GBM)GBM.this)._model)._output)._distribution, distributionImpl).doAll(GBM.this._train, ((GBMModel.GBMParameters)GBM.this._parms)._build_tree_one_node);
            }
            for (int k = 0; k < GBM.this._nclass; ++k) {
            }
            Constraints cs = ((GBMModel.GBMParameters)GBM.this._parms).constraints(GBM.this._train);
            this.growTrees(ktrees, leaves, GBM.this._rand, cs);
            for (int k = 0; k < GBM.this._nclass; ++k) {
            }
            GammaPass gp = new GammaPass(this.frameMap, ktrees, leaves, distributionImpl, GBM.this._nclass);
            gp.doAll(GBM.this._train);
            if (((GBMModel.GBMParameters)GBM.this._parms)._distribution == DistributionFamily.laplace) {
                this.fitBestConstantsQuantile(ktrees, leaves[0], 0.5);
            } else if (((GBMModel.GBMParameters)GBM.this._parms)._distribution == DistributionFamily.quantile) {
                this.fitBestConstantsQuantile(ktrees, leaves[0], ((GBMModel.GBMParameters)GBM.this._parms)._quantile_alpha);
            } else if (((GBMModel.GBMParameters)GBM.this._parms)._distribution == DistributionFamily.huber) {
                this.fitBestConstantsHuber(ktrees, leaves[0], huberDelta);
            } else {
                this.fitBestConstants(ktrees, leaves, gp, cs);
            }
            if (((GBMModel.GBMParameters)GBM.this._parms)._distribution == DistributionFamily.gamma || ((GBMModel.GBMParameters)GBM.this._parms)._distribution == DistributionFamily.poisson || ((GBMModel.GBMParameters)GBM.this._parms)._distribution == DistributionFamily.tweedie) {
                assert (GBM.this._nclass == 1);
                this.truncatePreds(ktrees[0], leaves[0], ((GBMModel.GBMParameters)GBM.this._parms)._distribution);
            }
            if (cs != null && this.constraintCheckEnabled()) {
                GBM.this._job.update(0L, "Checking monotonicity constraints on the final model");
                this.checkConstraints(ktrees, leaves, cs);
            }
            new AddTreeContributions(this.frameMap, ktrees, ((GBMModel.GBMParameters)GBM.this._parms)._pred_noise_bandwidth, ((GBMModel.GBMParameters)GBM.this._parms)._seed, ((GBMModel.GBMParameters)GBM.this._parms)._ntrees, ((GBMModel.GBMOutput)((GBMModel)((GBM)GBM.this)._model)._output)._ntrees).doAll(GBM.this._train);
            for (int k = 0; k < GBM.this._nclass; ++k) {
                if (ktrees[k] != null) assert (GBM.this.vec_nids(GBM.this._train, k).mean() == 0.0);
            }
            ((GBMModel.GBMOutput)((GBMModel)((GBM)GBM.this)._model)._output).addKTrees(ktrees);
            boolean bl = converged = this.effective_learning_rate() < 1.0E-6;
            if (converged) {
                Log.warn((Object[])new Object[]{"Effective learning rate dropped below 1e-6 (" + ((GBMModel.GBMParameters)GBM.this._parms)._learn_rate + " * " + ((GBMModel.GBMParameters)GBM.this._parms)._learn_rate_annealing + "^" + (((GBMModel.GBMOutput)((GBMModel)((GBM)GBM.this)._model)._output)._ntrees - 1) + ") - stopping the model now."});
            }
            return converged;
        }

        private int numClassTrees() {
            return GBM.this._nclass == 2 ? 1 : GBM.this._nclass;
        }

        private void growTrees(DTree[] ktrees, int[] leaves, Random rand, Constraints cs) {
            DHistogram[][][] hcs = new DHistogram[GBM.this._nclass][1][GBM.this._ncols];
            int adj_nbins = Math.max(((GBMModel.GBMParameters)GBM.this._parms)._nbins_top_level, ((GBMModel.GBMParameters)GBM.this._parms)._nbins);
            long rseed = rand.nextLong();
            for (int k = 0; k < this.numClassTrees(); ++k) {
                if (((GBMModel.GBMOutput)((GBMModel)((GBM)GBM.this)._model)._output)._distribution[k] == 0.0) continue;
                ktrees[k] = new DTree(GBM.this._train, GBM.this._ncols, GBM.this._mtry, GBM.this._mtry_per_tree, rseed, (SharedTreeModel.SharedTreeParameters)GBM.this._parms);
                DHistogram[] hist = DHistogram.initialHist(GBM.this._train, GBM.this._ncols, adj_nbins, hcs[k][0], rseed, (SharedTreeModel.SharedTreeParameters)GBM.this._parms, this.getGlobalQuantilesKeys(), cs);
                new DTree.UndecidedNode(ktrees[k], -1, hist, cs);
            }
            if (((GBMModel.GBMParameters)GBM.this._parms)._sample_rate < 1.0 || ((GBMModel.GBMParameters)GBM.this._parms)._sample_rate_per_class != null) {
                int k;
                Sample[] ss = new Sample[GBM.this._nclass];
                for (k = 0; k < GBM.this._nclass; ++k) {
                    if (ktrees[k] == null) continue;
                    ss[k] = (Sample)new Sample(ktrees[k], ((GBMModel.GBMParameters)GBM.this._parms)._sample_rate, ((GBMModel.GBMParameters)GBM.this._parms)._sample_rate_per_class).dfork(null, new Frame(new Vec[]{GBM.this.vec_nids(GBM.this._train, k), GBM.this._response}), ((GBMModel.GBMParameters)GBM.this._parms)._build_tree_one_node);
                }
                for (k = 0; k < GBM.this._nclass; ++k) {
                    if (ss[k] == null) continue;
                    ss[k].getResult();
                }
            }
            for (int depth = 0; depth < ((GBMModel.GBMParameters)GBM.this._parms)._max_depth && (hcs = GBM.this.buildLayer(GBM.this._train, ((GBMModel.GBMParameters)GBM.this._parms)._nbins, ((GBMModel.GBMParameters)GBM.this._parms)._nbins_cats, ktrees, leaves, hcs, ((GBMModel.GBMParameters)GBM.this._parms)._build_tree_one_node)) != null; ++depth) {
            }
            for (int k = 0; k < GBM.this._nclass; ++k) {
                int leaf;
                DTree tree = ktrees[k];
                if (tree == null) continue;
                leaves[k] = leaf = tree.len();
                for (int nid = 0; nid < leaf; ++nid) {
                    if (!(tree.node(nid) instanceof DTree.DecidedNode)) continue;
                    DTree.DecidedNode dn = tree.decided(nid);
                    if (dn._split == null) {
                        if (nid != 0) continue;
                        new DTree.LeafNode(tree, -1, 0);
                        continue;
                    }
                    for (int i = 0; i < dn._nids.length; ++i) {
                        int cnid = dn._nids[i];
                        if (cnid != -1 && !(tree.node(cnid) instanceof DTree.UndecidedNode) && (!(tree.node(cnid) instanceof DTree.DecidedNode) || ((DTree.DecidedNode)tree.node((int)cnid))._split != null)) continue;
                        dn._nids[i] = new DTree.LeafNode(tree, nid).nid();
                    }
                }
            }
        }

        private void fitBestConstantsQuantile(DTree[] ktrees, int firstLeafIndex, double quantile) {
            if (firstLeafIndex == ktrees[0]._len) {
                return;
            }
            assert (GBM.this._nclass == 1);
            Vec diff = ((ComputeDiff)new ComputeDiff(this.frameMap).doAll(1, (byte)3, GBM.this._train)).outputFrame().anyVec();
            Vec weights = GBM.this.hasWeightCol() ? GBM.this._train.vecs()[GBM.this.idx_weight()] : null;
            Vec strata = GBM.this.vec_nids(GBM.this._train, 0);
            Quantile.StratifiedQuantilesTask sqt = new Quantile.StratifiedQuantilesTask(null, quantile, diff, weights, strata, QuantileModel.CombineMethod.INTERPOLATE);
            H2O.submitTask((H2O.H2OCountedCompleter)sqt);
            sqt.join();
            DTree tree = ktrees[0];
            for (int i = 0; i < sqt._quantiles.length; ++i) {
                if (Double.isNaN(sqt._quantiles[i])) continue;
                double val = this.effective_learning_rate() * sqt._quantiles[i];
                assert (!Double.isNaN(val) && !Double.isInfinite(val));
                if (val > ((GBMModel.GBMParameters)GBM.this._parms)._max_abs_leafnode_pred) {
                    val = ((GBMModel.GBMParameters)GBM.this._parms)._max_abs_leafnode_pred;
                }
                if (val < -((GBMModel.GBMParameters)GBM.this._parms)._max_abs_leafnode_pred) {
                    val = -((GBMModel.GBMParameters)GBM.this._parms)._max_abs_leafnode_pred;
                }
                ((DTree.LeafNode)tree.node((int)sqt._nids[i]))._pred = (float)val;
            }
        }

        private void fitBestConstantsHuber(DTree[] ktrees, int firstLeafIndex, double huberDelta) {
            if (firstLeafIndex == ktrees[0]._len) {
                return;
            }
            assert (GBM.this._nclass == 1);
            Vec diff = ((ComputeDiff)new ComputeDiff(this.frameMap).doAll(1, (byte)3, GBM.this._train)).outputFrame().anyVec();
            Vec weights = GBM.this.hasWeightCol() ? GBM.this._train.vecs()[GBM.this.idx_weight()] : null;
            Vec strata = GBM.this.vec_nids(GBM.this._train, 0);
            Quantile.StratifiedQuantilesTask sqt = new Quantile.StratifiedQuantilesTask(null, 0.5, diff, weights, strata, QuantileModel.CombineMethod.INTERPOLATE);
            H2O.submitTask((H2O.H2OCountedCompleter)sqt);
            sqt.join();
            DiffMinusMedianDiff hp = new DiffMinusMedianDiff(strata, sqt._quantiles);
            Frame tmpFrame1 = new Frame(new String[]{"strata", "diff"}, new Vec[]{strata, diff});
            hp.doAll(tmpFrame1);
            Vec diffMinusMedianDiff = diff;
            Frame tmpFrame2 = new Frame(GBM.this._train.vecs());
            tmpFrame2.add("resMinusMedianRes", diffMinusMedianDiff);
            double[] huberGamma = ((HuberLeafMath)new HuberLeafMath((SharedTree.FrameMap)this.frameMap, (double)huberDelta, (Vec)strata).doAll((Frame)tmpFrame2))._huberGamma;
            DTree tree = ktrees[0];
            for (int i = 0; i < sqt._quantiles.length; ++i) {
                double huber = sqt._quantiles[i] + huberGamma[i];
                if (Double.isNaN(sqt._quantiles[i])) continue;
                double val = this.effective_learning_rate() * huber;
                assert (!Double.isNaN(val) && !Double.isInfinite(val));
                if (val > ((GBMModel.GBMParameters)GBM.this._parms)._max_abs_leafnode_pred) {
                    val = ((GBMModel.GBMParameters)GBM.this._parms)._max_abs_leafnode_pred;
                }
                if (val < -((GBMModel.GBMParameters)GBM.this._parms)._max_abs_leafnode_pred) {
                    val = -((GBMModel.GBMParameters)GBM.this._parms)._max_abs_leafnode_pred;
                }
                ((DTree.LeafNode)tree.node((int)sqt._nids[i]))._pred = (float)val;
            }
            diffMinusMedianDiff.remove();
        }

        private double effective_learning_rate() {
            return ((GBMModel.GBMParameters)GBM.this._parms)._learn_rate * Math.pow(((GBMModel.GBMParameters)GBM.this._parms)._learn_rate_annealing, ((GBMModel.GBMOutput)((GBMModel)((GBM)GBM.this)._model)._output)._ntrees - 1);
        }

        private void fitBestConstants(DTree[] ktrees, int[] leafs, GammaPass gp, Constraints cs) {
            boolean useSplitPredictions = cs != null && cs.useBounds();
            double m1class = GBM.this._nclass > 1 && ((GBMModel.GBMParameters)GBM.this._parms)._distribution == DistributionFamily.multinomial || GBM.this._nclass > 2 && ((GBMModel.GBMParameters)GBM.this._parms)._distribution == DistributionFamily.custom ? (double)(GBM.this._nclass - 1) / (double)GBM.this._nclass : 1.0;
            for (int k = 0; k < GBM.this._nclass; ++k) {
                DTree tree = ktrees[k];
                if (tree == null) continue;
                for (int i = 0; i < tree._len - leafs[k]; ++i) {
                    DTree.LeafNode leafNode = (DTree.LeafNode)ktrees[k].node(leafs[k] + i);
                    double gamma = useSplitPredictions ? leafNode.getSplitPrediction() : gp.gamma(k, i);
                    double gf = this.effective_learning_rate() * m1class * gamma;
                    if (((GBMModel.GBMParameters)GBM.this._parms)._distribution == DistributionFamily.multinomial || ((GBMModel.GBMParameters)GBM.this._parms)._distribution == DistributionFamily.custom && GBM.this._nclass > 2) {
                        if (gf > 10000.0) {
                            gf = 10000.0;
                        } else if (gf < -10000.0) {
                            gf = -10000.0;
                        }
                    }
                    if (Double.isNaN(gf)) {
                        gf = 0.0;
                    } else if (Double.isInfinite(gf)) {
                        gf = Math.signum(gf) * 10000.0;
                    }
                    if (gf > ((GBMModel.GBMParameters)GBM.this._parms)._max_abs_leafnode_pred) {
                        gf = ((GBMModel.GBMParameters)GBM.this._parms)._max_abs_leafnode_pred;
                    }
                    if (gf < -((GBMModel.GBMParameters)GBM.this._parms)._max_abs_leafnode_pred) {
                        gf = -((GBMModel.GBMParameters)GBM.this._parms)._max_abs_leafnode_pred;
                    }
                    leafNode._pred = (float)gf;
                }
            }
        }

        private boolean constraintCheckEnabled() {
            return Boolean.parseBoolean(GBM.this.getSysProperty("gbm.monotonicity.checkEnabled", "true"));
        }

        private void checkConstraints(DTree[] ktrees, int[] leafs, Constraints cs) {
            for (int k = 0; k < GBM.this._nclass; ++k) {
                DTree tree = ktrees[k];
                if (tree == null) continue;
                float[] mins = new float[tree._len];
                int[] min_ids = new int[tree._len];
                float[] maxs = new float[tree._len];
                int[] max_ids = new int[tree._len];
                this.rollupMinMaxPreds(tree, tree.root(), mins, min_ids, maxs, max_ids);
                for (int i = 0; i < tree._len - leafs.length; ++i) {
                    DTree.Node node = tree.node(i);
                    if (!(node instanceof DTree.DecidedNode)) continue;
                    DTree.DecidedNode dn = (DTree.DecidedNode)node;
                    if (dn._split == null) continue;
                    int constraint = cs.getColumnConstraint(dn._split._col);
                    if (dn._split.naSplitDir() == DHistogram.NASplitDir.NAvsREST) continue;
                    if (constraint > 0) {
                        if (!(maxs[dn._nids[0]] > mins[dn._nids[1]])) continue;
                        throw new IllegalStateException("Monotonicity constraint " + constraint + " violated on column '" + GBM.this._train.name(dn._split._col) + "' (max(left) > min(right)): " + maxs[dn._nids[0]] + " > " + mins[dn._nids[1]] + "\nNode: " + (Object)((Object)node) + "\nLeft Node (max): " + (Object)((Object)tree.node(max_ids[dn._nids[0]])) + "\nRight Node (min): " + (Object)((Object)tree.node(min_ids[dn._nids[1]])));
                    }
                    if (constraint >= 0 || !(mins[dn._nids[0]] < maxs[dn._nids[1]])) continue;
                    throw new IllegalStateException("Monotonicity constraint " + constraint + " violated on column '" + GBM.this._train.name(dn._split._col) + "' (min(left) < max(right)): " + mins[dn._nids[0]] + " < " + maxs[dn._nids[1]] + "\nNode: " + (Object)((Object)node) + "\nLeft Node (min): " + (Object)((Object)tree.node(min_ids[dn._nids[0]])) + "\nRight Node (max): " + (Object)((Object)tree.node(max_ids[dn._nids[1]])));
                }
            }
        }

        private void rollupMinMaxPreds(DTree tree, DTree.Node node, float[] mins, int[] min_ids, float[] maxs, int[] max_ids) {
            if (node instanceof DTree.LeafNode) {
                mins[node.nid()] = ((DTree.LeafNode)node)._pred;
                min_ids[node.nid()] = node.nid();
                maxs[node.nid()] = ((DTree.LeafNode)node)._pred;
                max_ids[node.nid()] = node.nid();
                return;
            }
            DTree.DecidedNode dn = (DTree.DecidedNode)node;
            this.rollupMinMaxPreds(tree, tree.node(dn._nids[0]), mins, min_ids, maxs, max_ids);
            this.rollupMinMaxPreds(tree, tree.node(dn._nids[1]), mins, min_ids, maxs, max_ids);
            int min_id = mins[dn._nids[0]] < mins[dn._nids[1]] ? dn._nids[0] : dn._nids[1];
            mins[node.nid()] = mins[min_id];
            min_ids[node.nid()] = min_ids[min_id];
            int max_id = maxs[dn._nids[0]] > maxs[dn._nids[1]] ? dn._nids[0] : dn._nids[1];
            maxs[node.nid()] = maxs[max_id];
            max_ids[node.nid()] = max_ids[max_id];
        }

        protected GBMModel makeModel(Key<GBMModel> modelKey, GBMModel.GBMParameters parms) {
            return new GBMModel(modelKey, parms, new GBMModel.GBMOutput(GBM.this));
        }
    }
}

