/*
 * Decompiled with CFR 0.152.
 */
package hex.util;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import hex.DataInfo;
import hex.FrameTask;
import hex.Interaction;
import hex.ToEigenVec;
import hex.gram.Gram;
import hex.util.EigenPair;
import java.util.Arrays;
import jsr166y.ForkJoinTask;
import jsr166y.RecursiveAction;
import org.apache.commons.lang.ArrayUtils;
import water.DKV;
import water.Job;
import water.Key;
import water.Keyed;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.util.Log;

public class LinearAlgebraUtils {
    public static ToEigenVec toEigen = new ToEigenVec(){

        public Vec toEigenVec(Vec src) {
            return LinearAlgebraUtils.toEigen(src);
        }
    };

    public static double[] forwardSolve(double[][] L, double[] b) {
        assert (L != null && L.length == L[0].length && L.length == b.length);
        double[] res = new double[b.length];
        for (int i = 0; i < b.length; ++i) {
            res[i] = b[i];
            for (int j = 0; j < i; ++j) {
                int n = i;
                res[n] = res[n] - L[i][j] * res[j];
            }
            int n = i;
            res[n] = res[n] / L[i][i];
        }
        return res;
    }

    public static double[] sqrtDiag(double[][] aMat) {
        int matrixSize = aMat.length;
        double[] answer = new double[matrixSize];
        for (int index = 0; index < matrixSize; ++index) {
            answer[index] = Math.sqrt(aMat[index][index]);
        }
        return answer;
    }

    public static double[][] chol2Inv(final double[][] cholR) {
        int i;
        double[] oneColumn;
        final int matrixSize = cholR.length;
        final double[][] cholL = water.util.ArrayUtils.transpose((double[][])cholR);
        final double[][] inverted = new double[matrixSize][];
        RecursiveAction[] ras = new RecursiveAction[matrixSize];
        int index = 0;
        while (index < matrixSize) {
            oneColumn = new double[matrixSize];
            oneColumn[index] = 1.0;
            i = index++;
            ras[i] = new RecursiveAction(){

                protected void compute() {
                    double[] upperColumn = LinearAlgebraUtils.forwardSolve(cholL, oneColumn);
                    inverted[i] = Arrays.copyOf(upperColumn, matrixSize);
                }
            };
        }
        ForkJoinTask.invokeAll((ForkJoinTask[])ras);
        index = 0;
        while (index < matrixSize) {
            oneColumn = new double[matrixSize];
            oneColumn[index] = 1.0;
            i = index++;
            ras[i] = new RecursiveAction(){

                protected void compute() {
                    double[] lowerColumn = new double[matrixSize];
                    LinearAlgebraUtils.backwardSolve(cholR, inverted[i], lowerColumn);
                    inverted[i] = Arrays.copyOf(lowerColumn, matrixSize);
                }
            };
        }
        ForkJoinTask.invokeAll((ForkJoinTask[])ras);
        return inverted;
    }

    public static double[][] matrixMultiply(final double[][] A, final double[][] B) {
        final int arow = A[0].length;
        int acol = A.length;
        int bcol = B.length;
        final double[][] result = new double[bcol][];
        RecursiveAction[] ras = new RecursiveAction[acol];
        int index = 0;
        while (index < acol) {
            final int i = index++;
            final double[] tempResult = new double[arow];
            ras[i] = new RecursiveAction(){

                protected void compute() {
                    water.util.ArrayUtils.multArrVec((double[][])A, (double[])B[i], (double[])tempResult);
                    result[i] = Arrays.copyOf(tempResult, arow);
                }
            };
        }
        ForkJoinTask.invokeAll((ForkJoinTask[])ras);
        return result;
    }

    public static double[] backwardSolve(double[][] L, double[] b, double[] res) {
        assert (L != null && L.length == L[0].length && L.length == b.length);
        if (res == null) {
            res = new double[b.length];
        }
        for (int rowIndex = b.length - 1; rowIndex >= 0; --rowIndex) {
            res[rowIndex] = b[rowIndex];
            for (int colIndex = b.length - 1; colIndex > rowIndex; --colIndex) {
                int n = rowIndex;
                res[n] = res[n] - L[rowIndex][colIndex] * res[colIndex];
            }
            int n = rowIndex;
            res[n] = res[n] / L[rowIndex][rowIndex];
        }
        return res;
    }

    private static double modifyNumeric(double x, int col, DataInfo dinfo) {
        double y;
        double d = y = Double.isNaN(x) && dinfo._imputeMissing ? dinfo._numNAFill[col] : x;
        if (dinfo._normSub != null && dinfo._normMul != null) {
            y = (y - dinfo._normSub[col]) * dinfo._normMul[col];
        }
        return y;
    }

    public static double[] expandRow(double[] row, DataInfo dinfo, double[] tmp, boolean modify_numeric) {
        for (int col = 0; col < dinfo._cats; ++col) {
            int cidx;
            if (Double.isNaN(row[col])) {
                if (dinfo._imputeMissing) {
                    cidx = dinfo.catNAFill()[col];
                } else {
                    if (!dinfo._catMissing[col]) continue;
                    cidx = dinfo._catOffsets[col + 1] - 1;
                }
            } else {
                cidx = dinfo._catOffsets[col + 1] - dinfo._catOffsets[col] == 1 ? dinfo.getCategoricalId(col, 0) : dinfo.getCategoricalId(col, (int)row[col]);
            }
            if (dinfo._catOffsets[col + 1] - dinfo._catOffsets[col] == 1 && cidx >= 0) {
                tmp[cidx] = row[col];
                continue;
            }
            if (cidx < 0) continue;
            tmp[cidx] = 1.0;
        }
        int chk_cnt = dinfo._cats;
        int exp_cnt = dinfo.numStart();
        for (int col = 0; col < dinfo._nums; ++col) {
            tmp[exp_cnt] = modify_numeric ? LinearAlgebraUtils.modifyNumeric(row[chk_cnt], col, dinfo) : row[chk_cnt];
            ++exp_cnt;
            ++chk_cnt;
        }
        return tmp;
    }

    public static double[][] reshape1DArray(double[] arr, int m, int n) {
        double[][] arr2D = new double[m][n];
        for (int i = 0; i < m; ++i) {
            System.arraycopy(arr, i * n, arr2D[i], 0, n);
        }
        return arr2D;
    }

    public static EigenPair[] createSortedEigenpairs(double[] eigenvalues, double[][] eigenvectors) {
        int count = eigenvalues.length;
        Object[] eigenPairs = new EigenPair[count];
        for (int i = 0; i < count; ++i) {
            eigenPairs[i] = new EigenPair(eigenvalues[i], eigenvectors[i]);
        }
        Arrays.sort(eigenPairs);
        return eigenPairs;
    }

    public static EigenPair[] createReverseSortedEigenpairs(double[] eigenvalues, double[][] eigenvectors) {
        Object[] eigenPairs = LinearAlgebraUtils.createSortedEigenpairs(eigenvalues, eigenvectors);
        ArrayUtils.reverse((Object[])eigenPairs);
        return eigenPairs;
    }

    public static double[] extractEigenvaluesFromEigenpairs(EigenPair[] eigenPairs) {
        int count = eigenPairs.length;
        double[] eigenvalues = new double[count];
        for (int i = 0; i < count; ++i) {
            eigenvalues[i] = eigenPairs[i].eigenvalue;
        }
        return eigenvalues;
    }

    public static double[][] extractEigenvectorsFromEigenpairs(EigenPair[] eigenPairs) {
        int count = eigenPairs.length;
        double[][] eigenvectors = new double[count][];
        for (int i = 0; i < count; ++i) {
            eigenvectors[i] = eigenPairs[i].eigenvector;
        }
        return eigenvectors;
    }

    public static double[][] computeR(Key<Job> jobKey, DataInfo yinfo, boolean transpose) {
        Gram.GramTask gtsk = new Gram.GramTask(jobKey, yinfo);
        gtsk.doAll(yinfo._adaptedFrame);
        Gram.Cholesky chol = gtsk._gram.cholesky(null);
        double[][] L = chol.getL();
        water.util.ArrayUtils.mult((double[][])L, (double)Math.sqrt(gtsk._nobs));
        return transpose ? L : water.util.ArrayUtils.transpose((double[][])L);
    }

    public static double computeQ(Key<Job> jobKey, DataInfo yinfo, Frame ywfrm, double[][] xx) {
        xx = LinearAlgebraUtils.computeR(jobKey, yinfo, true);
        ForwardSolve qrtsk = new ForwardSolve(yinfo, xx);
        qrtsk.doAll(ywfrm);
        return qrtsk._sse;
    }

    public static double[][] computeQ(Key<Job> jobKey, DataInfo yinfo, Frame ywfrm) {
        double[][] xx = LinearAlgebraUtils.computeR(jobKey, yinfo, true);
        ForwardSolve qrtsk = new ForwardSolve(yinfo, xx);
        qrtsk.doAll(ywfrm);
        return xx;
    }

    public static double[][] computeQInPlace(Key<Job> jobKey, DataInfo yinfo) {
        double[][] cholL = LinearAlgebraUtils.computeR(jobKey, yinfo, true);
        ForwardSolveInPlace qrtsk = new ForwardSolveInPlace(yinfo, cholL);
        qrtsk.doAll(yinfo._adaptedFrame);
        return cholL;
    }

    public static int numColsExp(Frame fr, boolean useAllFactorLevels) {
        int uAFL = useAllFactorLevels ? 0 : 1;
        int cols = 0;
        for (Vec vec : fr.vecs()) {
            cols += vec.isCategorical() && vec.domain() != null ? vec.domain().length - uAFL : 1;
        }
        return cols;
    }

    static double[] multiple(double[] diagYY, int nTot, int nVars) {
        int ny = diagYY.length;
        int i = 0;
        while (i < ny) {
            int n = i++;
            diagYY[n] = diagYY[n] * (double)nTot;
        }
        double[][] uu = new double[ny][ny];
        for (int i2 = 0; i2 < ny; ++i2) {
            for (int j = 0; j < ny; ++j) {
                double yyij = i2 == j ? diagYY[i2] : 0.0;
                uu[i2][j] = (yyij - diagYY[i2] * diagYY[j] / (double)nTot) / ((double)nVars * Math.sqrt(diagYY[i2] * diagYY[j]));
                if (!Double.isNaN(uu[i2][j])) continue;
                uu[i2][j] = 0.0;
            }
        }
        EigenvalueDecomposition eigen = new EigenvalueDecomposition(new Matrix(uu));
        double[] eigenvalues = eigen.getRealEigenvalues();
        double[][] eigenvectors = eigen.getV().getArray();
        int maxIndex = water.util.ArrayUtils.maxIndex((double[])eigenvalues);
        return eigenvectors[maxIndex];
    }

    public static Vec toEigen(Vec src) {
        Key source = Key.make();
        Key dest = Key.make();
        Frame train = new Frame(source, new String[]{"enum"}, new Vec[]{src});
        int maxLevels = 1024;
        boolean created = false;
        if (src.cardinality() > maxLevels) {
            DKV.put((Keyed)train);
            created = true;
            Log.info((Object[])new Object[]{"Reducing the cardinality of a categorical column with " + src.cardinality() + " levels to " + maxLevels});
            Interaction inter = new Interaction();
            inter._source_frame = train._key;
            inter._max_factors = maxLevels;
            inter._min_occurrence = 2;
            inter._pairwise = false;
            inter._factor_columns = train.names();
            train = (Frame)inter.execImpl(dest).get();
        }
        DataInfo dinfo = new DataInfo(train, null, 0, true, DataInfo.TransformType.NONE, DataInfo.TransformType.NONE, false, true, false, false, false, false, false);
        DKV.put((Keyed)dinfo);
        Gram.GramTask gtsk = (Gram.GramTask)new Gram.GramTask(null, dinfo).doAll(dinfo._adaptedFrame);
        double[] rounded = new double[gtsk._gram._diag.length];
        for (int i = 0; i < rounded.length; ++i) {
            rounded[i] = (float)gtsk._gram._diag[i];
        }
        dinfo.remove();
        Vec v = ((ProjectOntoEigenVector)new ProjectOntoEigenVector(LinearAlgebraUtils.multiple(rounded, (int)gtsk._nobs, 1)).doAll(1, (byte)3, train)).outputFrame().anyVec();
        if (created) {
            train.remove();
            DKV.remove((Key)source);
        }
        return v;
    }

    public static String getMatrixInString(double[][] matrix) {
        int dimX = matrix.length;
        if (dimX <= 0) {
            return "";
        }
        int dimY = matrix[0].length;
        for (int x = 1; x < dimX; ++x) {
            if (matrix[x].length == dimY) continue;
            return "Stacked matrix!";
        }
        StringBuilder stringOfMatrix = new StringBuilder();
        for (int x = 0; x < dimX; ++x) {
            for (int y = 0; y < dimY; ++y) {
                if (matrix[x][y] > 0.0) {
                    stringOfMatrix.append(' ');
                }
                stringOfMatrix.append(String.format("%.4f\t", matrix[x][y]));
            }
            stringOfMatrix.append('\n');
        }
        return stringOfMatrix.toString();
    }

    static class ProjectOntoEigenVector
    extends MRTask<ProjectOntoEigenVector> {
        final double[] _yCoord;

        ProjectOntoEigenVector(double[] yCoord) {
            this._yCoord = yCoord;
        }

        public void map(Chunk[] cs, NewChunk[] nc) {
            for (int i = 0; i < cs[0]._len; ++i) {
                if (cs[0].isNA(i)) {
                    nc[0].addNA();
                    continue;
                }
                int which = (int)cs[0].at8(i);
                nc[0].addNum((double)((float)this._yCoord[which]));
            }
        }
    }

    public static class ForwardSolveInPlace
    extends MRTask<ForwardSolveInPlace> {
        final DataInfo _ainfo;
        final int _ncols;
        final double[][] _L;

        public ForwardSolveInPlace(DataInfo ainfo, double[][] L) {
            assert (L != null && L.length == L[0].length && L.length == ainfo._adaptedFrame.numCols());
            this._ainfo = ainfo;
            this._ncols = ainfo._adaptedFrame.numCols();
            this._L = L;
        }

        public void map(Chunk[] cs) {
            assert (this._ncols == cs.length);
            Chunk[] achks = new Chunk[this._ncols];
            System.arraycopy(cs, 0, achks, 0, this._ncols);
            for (int row = 0; row < cs[0]._len; ++row) {
                DataInfo.Row arow = this._ainfo.newDenseRow();
                this._ainfo.extractDenseRow(achks, row, arow);
                if (arow.isBad()) continue;
                double[] aexp = arow.expandCats();
                double[] qrow = LinearAlgebraUtils.forwardSolve(this._L, aexp);
                assert (qrow.length == this._ncols);
                for (int d = 0; d < this._ncols; ++d) {
                    cs[d].set(row, qrow[d]);
                }
            }
        }
    }

    public static class ForwardSolve
    extends MRTask<ForwardSolve> {
        final DataInfo _ainfo;
        final int _ncols;
        final double[][] _L;
        public double _sse;

        public ForwardSolve(DataInfo ainfo, double[][] L) {
            assert (L != null && L.length == L[0].length && L.length == ainfo._adaptedFrame.numCols());
            this._ainfo = ainfo;
            this._ncols = ainfo._adaptedFrame.numCols();
            this._L = L;
            this._sse = 0.0;
        }

        public void map(Chunk[] cs) {
            assert (2 * this._ncols == cs.length);
            Chunk[] achks = new Chunk[this._ncols];
            System.arraycopy(cs, 0, achks, 0, this._ncols);
            for (int row = 0; row < cs[0]._len; ++row) {
                DataInfo.Row arow = this._ainfo.newDenseRow();
                this._ainfo.extractDenseRow(achks, row, arow);
                if (arow.isBad()) continue;
                double[] aexp = arow.expandCats();
                double[] qrow = LinearAlgebraUtils.forwardSolve(this._L, aexp);
                int i = 0;
                for (int d = this._ncols; d < 2 * this._ncols; ++d) {
                    double qold = cs[d].atd(row);
                    double diff = qrow[i] - qold;
                    this._sse += diff * diff;
                    cs[d].set(row, qrow[i++]);
                }
                assert (i == qrow.length);
            }
        }
    }

    public static class SMulTask
    extends MRTask<SMulTask> {
        final DataInfo _ainfo;
        final int _ncolA;
        final int _ncolExp;
        final int _ncolQ;
        public double[][] _atq;

        public SMulTask(DataInfo ainfo, int ncolQ) {
            this._ainfo = ainfo;
            this._ncolA = ainfo._adaptedFrame.numCols();
            this._ncolExp = LinearAlgebraUtils.numColsExp(ainfo._adaptedFrame, true);
            this._ncolQ = ncolQ;
        }

        public SMulTask(DataInfo ainfo, int ncolQ, int ncolExp) {
            this._ainfo = ainfo;
            this._ncolA = ainfo._adaptedFrame.numCols();
            this._ncolExp = ncolExp;
            this._ncolQ = ncolQ;
        }

        public void map(Chunk[] cs) {
            assert (this._ncolA + this._ncolQ == cs.length);
            this._atq = new double[this._ncolExp][this._ncolQ];
            for (int k = this._ncolA; k < this._ncolA + this._ncolQ; ++k) {
                for (int p = 0; p < this._ainfo._cats; ++p) {
                    for (int row = 0; row < cs[0]._len; ++row) {
                        int cidx;
                        if (cs[p].isNA(row) && this._ainfo._skipMissing) continue;
                        double q = cs[k].atd(row);
                        double a = cs[p].atd(row);
                        if (Double.isNaN(a)) {
                            if (this._ainfo._imputeMissing) {
                                cidx = this._ainfo.catNAFill()[p];
                            } else {
                                if (!this._ainfo._catMissing[p]) continue;
                                cidx = this._ainfo._catOffsets[p + 1] - 1;
                            }
                        } else {
                            cidx = this._ainfo.getCategoricalId(p, (int)a);
                        }
                        if (cidx < 0) continue;
                        double[] dArray = this._atq[cidx];
                        int n = k - this._ncolA;
                        dArray[n] = dArray[n] + q;
                    }
                }
                int pnum = 0;
                int pexp = this._ainfo.numStart();
                for (int p = this._ainfo._cats; p < this._ncolA; ++p) {
                    for (int row = 0; row < cs[0]._len; ++row) {
                        if (cs[p].isNA(row) && this._ainfo._skipMissing) continue;
                        double q = cs[k].atd(row);
                        double a = cs[p].atd(row);
                        a = LinearAlgebraUtils.modifyNumeric(a, pnum, this._ainfo);
                        double[] dArray = this._atq[pexp];
                        int n = k - this._ncolA;
                        dArray[n] = dArray[n] + q * a;
                    }
                    ++pexp;
                    ++pnum;
                }
                assert (pexp == this._atq.length);
            }
        }

        public void reduce(SMulTask other) {
            water.util.ArrayUtils.add((double[][])this._atq, (double[][])other._atq);
        }
    }

    public static class BMulInPlaceTask
    extends MRTask<BMulInPlaceTask> {
        final DataInfo _xinfo;
        final double[][] _yt;
        final int _ncolX;

        public BMulInPlaceTask(DataInfo xinfo, double[][] yt) {
            assert (yt != null && yt[0].length == LinearAlgebraUtils.numColsExp(xinfo._adaptedFrame, true));
            this._xinfo = xinfo;
            this._ncolX = xinfo._adaptedFrame.numCols();
            this._yt = yt;
        }

        public BMulInPlaceTask(DataInfo xinfo, double[][] yt, int nColsExp) {
            assert (yt != null && yt[0].length == nColsExp);
            this._xinfo = xinfo;
            this._ncolX = xinfo._adaptedFrame.numCols();
            this._yt = yt;
        }

        public void map(Chunk[] cs) {
            assert (cs.length == this._ncolX + this._yt.length);
            Chunk[] xchk = new Chunk[this._ncolX];
            DataInfo.Row xrow = this._xinfo.newDenseRow();
            System.arraycopy(cs, 0, xchk, 0, this._ncolX);
            for (int row = 0; row < cs[0]._len; ++row) {
                this._xinfo.extractDenseRow(xchk, row, xrow);
                if (xrow.isBad()) continue;
                int bidx = this._ncolX;
                for (double[] ps : this._yt) {
                    double sum = xrow.innerProduct(ps);
                    cs[bidx].set(row, sum);
                    ++bidx;
                }
                assert (bidx == cs.length);
            }
        }
    }

    public static class BMulTaskMatrices
    extends MRTask<BMulTaskMatrices> {
        final Frame _y;
        final int _nyChunks;
        final int _yColNum;

        public BMulTaskMatrices(Frame y) {
            this._y = y;
            this._nyChunks = this._y.anyVec().nChunks();
            this._yColNum = this._y.numCols();
        }

        private void mulResultPerYChunk(Chunk[] xChunk, Chunk[] yChunk) {
            int xChunkLen = xChunk[0].len();
            int yColLen = yChunk.length;
            int yChunkLen = yChunk[0].len();
            int resultColOffset = xChunk.length - yColLen;
            int xChunkColOffset = (int)yChunk[0].start();
            for (int colIndex = 0; colIndex < yColLen; ++colIndex) {
                int resultColIndex = colIndex + resultColOffset;
                for (int rowIndex = 0; rowIndex < xChunkLen; ++rowIndex) {
                    double origResult = xChunk[resultColIndex].atd(rowIndex);
                    for (int interIndex = 0; interIndex < yChunkLen; ++interIndex) {
                        origResult += xChunk[interIndex + xChunkColOffset].atd(rowIndex) * yChunk[colIndex].atd(interIndex);
                    }
                    xChunk[resultColIndex].set(rowIndex, origResult);
                }
            }
        }

        public void map(Chunk[] xChunk) {
            Chunk[] ychunk = new Chunk[this._y.numCols()];
            for (int ychunkInd = 0; ychunkInd < this._nyChunks; ++ychunkInd) {
                for (int chkIndex = 0; chkIndex < this._yColNum; ++chkIndex) {
                    ychunk[chkIndex] = this._y.vec(chkIndex).chunkForChunkIdx(ychunkInd);
                }
                this.mulResultPerYChunk(xChunk, ychunk);
            }
        }
    }

    public static class BMulTask
    extends FrameTask<BMulTask> {
        final double[][] _yt;

        public BMulTask(Key<Job> jobKey, DataInfo dinfo, double[][] yt) {
            super(jobKey, dinfo);
            this._yt = yt;
        }

        @Override
        protected void processRow(long gid, DataInfo.Row row, NewChunk[] outputs) {
            for (int p = 0; p < this._yt.length; ++p) {
                double x = row.innerProduct(this._yt[p]);
                outputs[p].addNum(x);
            }
        }
    }

    public static class CopyQtoQMatrix
    extends MRTask<CopyQtoQMatrix> {
        public void map(Chunk[] cs) {
            int totColumn = cs.length;
            int halfColumn = totColumn / 2;
            int totRows = cs[0].len();
            for (int rowIndex = 0; rowIndex < totRows; ++rowIndex) {
                for (int colIndex = 0; colIndex < halfColumn; ++colIndex) {
                    cs[colIndex].set(rowIndex, cs[colIndex + halfColumn].atd(rowIndex));
                }
            }
        }
    }

    public static class FindMaxIndex
    extends MRTask<FindMaxIndex> {
        public long _maxIndex = -1L;
        int _colIndex;
        double _maxValue;

        public FindMaxIndex(int colOfInterest, double maxValue) {
            this._colIndex = colOfInterest;
            this._maxValue = maxValue;
        }

        public void map(Chunk[] cs) {
            int rowLen = cs[0].len();
            long startRowIndex = cs[0].start();
            for (int rowIndex = 0; rowIndex < rowLen; ++rowIndex) {
                double rowVal = cs[this._colIndex].atd(rowIndex);
                if (rowVal != this._maxValue) continue;
                this._maxIndex = startRowIndex + (long)rowIndex;
            }
        }

        public void reduce(FindMaxIndex other) {
            if (this._maxIndex < 0L) {
                this._maxIndex = other._maxIndex;
            } else if (this._maxIndex > other._maxIndex) {
                this._maxIndex = other._maxIndex;
            }
        }
    }
}

