/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.Model;
import java.util.ArrayList;
import java.util.Arrays;
import water.DKV;
import water.H2O;
import water.Iced;
import water.IcedUtils;
import water.Key;
import water.Keyed;
import water.MemoryManager;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.InteractionWrappedVec;
import water.fvec.Vec;
import water.util.ArrayUtils;

public class DataInfo
extends Keyed<DataInfo> {
    public int[] _activeCols;
    public Frame _adaptedFrame;
    public int _responses;
    public int _outpus;
    public TransformType _predictor_transform;
    public TransformType _response_transform;
    public boolean _useAllFactorLevels;
    public int _nums;
    public int _cats;
    public int[] _catOffsets;
    public boolean[] _catMissing;
    private int[] _catNAFill;
    public double[] _numNAFill;
    public int[] _permutation;
    public double[] _normMul;
    public double[] _normSub;
    public double[] _normSigmaStandardizationOff;
    public double[] _normSubStandardizationOff;
    public double[] _normRespMul;
    public double[] _normRespSub;
    public double[] _numMeans;
    public boolean _intercept = true;
    public boolean _offset;
    public boolean _weights;
    public boolean _fold;
    public Model.InteractionPair[] _interactions;
    public Model.InteractionSpec _interactionSpec;
    public int[] _interactionVecs;
    public int[] _numOffsets;
    public final boolean _skipMissing;
    public final boolean _imputeMissing;
    public boolean _valid;
    public final int[][] _catLvls;
    public final int[][] _intLvls;
    public String[] _coefNames;
    private int[] _fullCatOffsets;
    private int[][] _catMap;

    public Vec setWeights(String name, Vec vec) {
        if (this._weights) {
            return this._adaptedFrame.replace(this.weightChunkId(), vec);
        }
        this._adaptedFrame.insertVec(this.weightChunkId(), name, vec);
        this._weights = true;
        return null;
    }

    public void dropWeights() {
        if (!this._weights) {
            return;
        }
        this._adaptedFrame.remove(this.weightChunkId());
        this._weights = false;
    }

    public void dropInteractions() {
        if (this._interactions != null) {
            Vec[] vecs;
            for (Vec v : vecs = this._adaptedFrame.remove(this._interactionVecs)) {
                v.remove();
            }
            this._interactions = null;
        }
    }

    public int[] activeCols() {
        if (this._activeCols != null) {
            return this._activeCols;
        }
        int[] res = new int[this.fullN() + 1];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i;
        }
        return res;
    }

    public void addResponse(String[] names, Vec[] vecs) {
        this._adaptedFrame.add(names, vecs);
        this._responses += vecs.length;
    }

    public int[] catNAFill() {
        return this._catNAFill;
    }

    public int catNAFill(int cid) {
        return this._catNAFill[cid];
    }

    public double[] numNAFill() {
        return this._numNAFill;
    }

    public double numNAFill(int nid) {
        return this._numNAFill[nid];
    }

    public void setCatNAFill(int[] catNAFill) {
        this._catNAFill = catNAFill;
    }

    public double normSub(int i) {
        return this._normSub == null ? 0.0 : this._normSub[i];
    }

    public double normMul(int i) {
        return this._normMul == null ? 1.0 : this._normMul[i];
    }

    public int responseChunkId(int n) {
        return n + this._cats + this._nums + (this._weights ? 1 : 0) + (this._offset ? 1 : 0) + (this._fold ? 1 : 0);
    }

    public int foldChunkId() {
        return this._cats + this._nums + (this._weights ? 1 : 0) + (this._offset ? 1 : 0);
    }

    public int offsetChunkId() {
        return this._cats + this._nums + (this._weights ? 1 : 0);
    }

    public int weightChunkId() {
        return this._cats + this._nums;
    }

    public int outputChunkId() {
        return this.outputChunkId(0);
    }

    public int outputChunkId(int n) {
        return n + this._cats + this._nums + (this._weights ? 1 : 0) + (this._offset ? 1 : 0) + (this._fold ? 1 : 0) + this._responses;
    }

    public void addOutput(String name, Vec v) {
        this._adaptedFrame.add(name, v);
    }

    public Vec getOutputVec(int i) {
        return this._adaptedFrame.vec(this.outputChunkId(i));
    }

    public void setResponse(String name, Vec v) {
        this.setResponse(name, v, 0);
    }

    public void setResponse(String name, Vec v, int n) {
        this._adaptedFrame.insertVec(this.responseChunkId(n), name, v);
    }

    private DataInfo() {
        this._intLvls = null;
        this._catLvls = null;
        this._skipMissing = true;
        this._imputeMissing = false;
        this._valid = false;
        this._offset = false;
        this._weights = false;
        this._fold = false;
    }

    protected long checksum_impl() {
        throw H2O.unimpl();
    }

    public DataInfo(Frame train, Frame valid, boolean useAllFactorLevels, TransformType predictor_transform, boolean skipMissing, boolean imputeMissing, boolean missingBucket) {
        this(train, valid, 0, useAllFactorLevels, predictor_transform, TransformType.NONE, skipMissing, imputeMissing, missingBucket, false, false, false, false);
    }

    public DataInfo(Frame train, Frame valid, int nResponses, boolean useAllFactorLevels, TransformType predictor_transform, TransformType response_transform, boolean skipMissing, boolean imputeMissing, boolean missingBucket, boolean weight, boolean offset, boolean fold) {
        this(train, valid, nResponses, useAllFactorLevels, predictor_transform, response_transform, skipMissing, imputeMissing, missingBucket, weight, offset, fold, null);
    }

    public DataInfo(Frame train, Frame valid, int nResponses, boolean useAllFactorLevels, TransformType predictor_transform, TransformType response_transform, boolean skipMissing, boolean imputeMissing, boolean missingBucket, boolean weight, boolean offset, boolean fold, Model.InteractionSpec interactions) {
        this(train, valid, nResponses, useAllFactorLevels, predictor_transform, response_transform, skipMissing, imputeMissing, new MeanImputer(), missingBucket, weight, offset, fold, interactions);
    }

    public DataInfo(Frame train, Frame valid, int nResponses, boolean useAllFactorLevels, TransformType predictor_transform, TransformType response_transform, boolean skipMissing, boolean imputeMissing, Imputer imputer, boolean missingBucket, boolean weight, boolean offset, boolean fold, Model.InteractionSpec interactions) {
        super(Key.make());
        int i;
        int i2;
        int i3;
        assert (predictor_transform != null);
        assert (response_transform != null);
        this._valid = valid != null;
        this._offset = offset;
        this._weights = weight;
        this._fold = fold;
        assert (!skipMissing || !imputeMissing) : "skipMissing and imputeMissing cannot both be true";
        this._skipMissing = skipMissing;
        this._imputeMissing = imputeMissing;
        this._predictor_transform = predictor_transform;
        this._response_transform = response_transform;
        this._responses = nResponses;
        this._useAllFactorLevels = useAllFactorLevels;
        this._interactionSpec = interactions;
        if (interactions != null) {
            train = interactions.reorderColumns(train);
            valid = interactions.reorderColumns(valid);
            this._interactions = interactions.makeInteractionPairs(train);
        }
        if (this._interactions != null) {
            this._interactionVecs = new int[this._interactions.length];
            Frame inter = Model.makeInteractions((Frame)train, (boolean)false, (Model.InteractionPair[])this._interactions, (boolean)this._useAllFactorLevels, (boolean)this._skipMissing, (predictor_transform == TransformType.STANDARDIZE ? 1 : 0) != 0);
            train = inter.add(this._interactionSpec.removeInteractionOnlyColumns(train));
            if (valid != null) {
                inter = Model.makeInteractions((Frame)valid, (boolean)true, (Model.InteractionPair[])this._interactions, (boolean)this._useAllFactorLevels, (boolean)this._skipMissing, (predictor_transform == TransformType.STANDARDIZE ? 1 : 0) != 0);
                valid = inter.add(this._interactionSpec.removeInteractionOnlyColumns(valid));
            }
        }
        this._permutation = new int[train.numCols()];
        Vec[] tvecs = train.vecs();
        int n = tvecs.length - this._responses - (offset ? 1 : 0) - (weight ? 1 : 0) - (fold ? 1 : 0);
        int[] nums = MemoryManager.malloc4((int)n);
        int[] cats = MemoryManager.malloc4((int)n);
        int nnums = 0;
        int ncats = 0;
        for (i3 = 0; i3 < n; ++i3) {
            if (tvecs[i3].isCategorical()) {
                cats[ncats++] = i3;
                continue;
            }
            nums[nnums++] = i3;
        }
        this._nums = nnums;
        this._cats = ncats;
        this._catLvls = new int[ncats][];
        for (i3 = 0; i3 < ncats; ++i3) {
            for (int j = i3 + 1; j < ncats; ++j) {
                if (tvecs[cats[i3]].domain().length >= tvecs[cats[j]].domain().length) continue;
                int x = cats[i3];
                cats[i3] = cats[j];
                cats[j] = x;
            }
        }
        String[] names = new String[train.numCols()];
        Vec[] tvecs2 = new Vec[train.numCols()];
        this._catNAFill = new int[ncats];
        this._catOffsets = MemoryManager.malloc4((int)(ncats + 1));
        this._catMissing = new boolean[ncats];
        this._catOffsets[0] = 0;
        int len = 0;
        int interactionIdx = 0;
        if (this._interactions == null) {
            ArrayList<Integer> interactionIds = new ArrayList<Integer>();
            for (i2 = 0; i2 < tvecs.length; ++i2) {
                if (!(tvecs[i2] instanceof InteractionWrappedVec)) continue;
                interactionIds.add(i2);
            }
            if (interactionIds.size() > 0) {
                this._interactionVecs = new int[interactionIds.size()];
                for (i2 = 0; i2 < this._interactionVecs.length; ++i2) {
                    this._interactionVecs[i2] = (Integer)interactionIds.get(i2);
                }
            }
        }
        for (i2 = 0; i2 < ncats; ++i2) {
            names[i2] = train._names[cats[i2]];
            Vec v = tvecs2[i2] = tvecs[cats[i2]];
            this._catMissing[i2] = missingBucket;
            if (v instanceof InteractionWrappedVec) {
                this._interactionVecs[interactionIdx++] = i2;
                this._catOffsets[i2 + 1] = len += v.domain().length + (missingBucket ? 1 : 0);
            } else {
                this._catOffsets[i2 + 1] = len += v.domain().length - (useAllFactorLevels ? 0 : 1) + (missingBucket ? 1 : 0);
            }
            this._catNAFill[i2] = imputeMissing ? imputer.imputeCat(names[i2], train.vec(cats[i2]), this._useAllFactorLevels) : (this._catMissing[i2] ? v.domain().length - (this._useAllFactorLevels || this.isInteractionVec(i2) ? 0 : 1) : -100);
            this._permutation[i2] = cats[i2];
        }
        this._numOffsets = MemoryManager.malloc4((int)(nnums + 1));
        this._numOffsets[0] = len;
        for (int i4 = 0; i4 < nnums; ++i4) {
            Vec v;
            names[i4 + ncats] = train._names[nums[i4]];
            tvecs2[i4 + ncats] = v = train.vec(nums[i4]);
            boolean isIWV = v instanceof InteractionWrappedVec;
            if (isIWV) {
                this._interactionVecs[interactionIdx++] = i4 + ncats;
            }
            this._numOffsets[i4 + 1] = len += isIWV ? ((InteractionWrappedVec)v).expandedLength() : 1;
            this._permutation[i4 + ncats] = nums[i4];
        }
        this._numMeans = new double[this.numNums()];
        this._numNAFill = new double[this.numNums()];
        int numIdx = 0;
        for (i = 0; i < nnums; ++i) {
            String name = train.name(nums[i]);
            Vec v = train.vec(nums[i]);
            if (v instanceof InteractionWrappedVec) {
                InteractionWrappedVec iwv = (InteractionWrappedVec)v;
                int start = iwv._useAllFactorLevels ? 0 : 1;
                int length = iwv.expandedLength();
                double[] means = iwv.getMeans();
                System.arraycopy(means, start, this._numMeans, numIdx, length);
                double[] naFill = imputer.imputeInteraction(name, iwv, means);
                System.arraycopy(naFill, start, this._numNAFill, numIdx, length);
                numIdx += length;
                continue;
            }
            this._numMeans[numIdx] = v.mean();
            this._numNAFill[numIdx] = imputer.imputeNum(name, v);
            ++numIdx;
        }
        for (i = names.length - nResponses - (weight ? 1 : 0) - (offset ? 1 : 0) - (fold ? 1 : 0); i < names.length; ++i) {
            names[i] = train._names[i];
            tvecs2[i] = train.vec(i);
        }
        this._adaptedFrame = new Frame(names, tvecs2);
        train.restructure(names, tvecs2);
        if (valid != null) {
            valid.restructure(names, valid.vecs(names));
        }
        this.setPredictorTransform(predictor_transform);
        if (this._responses > 0) {
            this.setResponseTransform(response_transform);
        }
        this._intLvls = new int[this._interactionVecs == null ? 0 : this._interactionVecs.length][];
    }

    public DataInfo disableIntercept() {
        this._intercept = false;
        return this;
    }

    public DataInfo(Frame train, Frame valid, int nResponses, boolean useAllFactorLevels, TransformType predictor_transform, TransformType response_transform, boolean skipMissing, boolean imputeMissing, boolean missingBucket, boolean weight, boolean offset, boolean fold, boolean intercept) {
        this(train, valid, nResponses, useAllFactorLevels, predictor_transform, response_transform, skipMissing, imputeMissing, missingBucket, weight, offset, fold);
        this._intercept = intercept;
    }

    public DataInfo validDinfo(Frame valid) {
        DataInfo res = new DataInfo(this._adaptedFrame, null, 1, this._useAllFactorLevels, TransformType.NONE, TransformType.NONE, this._skipMissing, this._imputeMissing, !this._skipMissing && !this._imputeMissing, this._weights, this._offset, this._fold);
        res._interactions = this._interactions;
        res._interactionSpec = this._interactionSpec;
        if (this._interactionSpec != null) {
            valid = Model.makeInteractions((Frame)valid, (boolean)true, (Model.InteractionPair[])this._interactions, (boolean)this._useAllFactorLevels, (boolean)this._skipMissing, (boolean)false).add(valid);
        }
        res._adaptedFrame = new Frame(this._adaptedFrame.names(), valid.vecs(this._adaptedFrame.names()));
        res._valid = true;
        return res;
    }

    public double[] denormalizeBeta(double[] beta) {
        int N = this.fullN() + 1;
        assert (beta.length % N == 0) : "beta len = " + beta.length + " expected multiple of" + N;
        int nclasses = beta.length / N;
        beta = MemoryManager.arrayCopyOf((double[])beta, (int)beta.length);
        if (this._predictor_transform == TransformType.STANDARDIZE) {
            for (int c = 0; c < nclasses; ++c) {
                int numoff;
                int off = N * c;
                double norm = 0.0;
                for (int i = numoff = this.numStart(); i < N - 1; ++i) {
                    double b = beta[off + i] * this._normMul[i - numoff];
                    norm += b * this._normSub[i - numoff];
                    beta[off + i] = b;
                }
                int n = off + N - 1;
                beta[n] = beta[n] - norm;
            }
        }
        return beta;
    }

    public double[] normalizeBeta(double[] beta, boolean standardize) {
        int N = this.fullN() + 1;
        assert (beta.length % N == 0) : "beta len = " + beta.length + " expected multiple of" + N;
        int nclasses = beta.length / N;
        beta = MemoryManager.arrayCopyOf((double[])beta, (int)beta.length);
        if (!standardize && this._predictor_transform == TransformType.NONE && this._normSubStandardizationOff != null && this._normSigmaStandardizationOff != null) {
            for (int c = 0; c < nclasses; ++c) {
                int numoff;
                int off = N * c;
                double norm = 0.0;
                for (int i = numoff = this.numStart(); i < N - 1; ++i) {
                    double b = beta[off + i] * this._normSigmaStandardizationOff[i - numoff];
                    norm += beta[off + i] * this._normSubStandardizationOff[i - numoff];
                    beta[off + i] = b;
                }
                int n = off + N - 1;
                beta[n] = beta[n] + norm;
            }
        }
        return beta;
    }

    protected int[] fullCatOffsets() {
        return this._fullCatOffsets == null ? this._catOffsets : this._fullCatOffsets;
    }

    private DataInfo(DataInfo dinfo, Frame fr, double[] normMul, double[] normSub, int[][] catLevels, int[][] intLvls, int[] catModes, int[] activeCols) {
        int i;
        this._activeCols = activeCols;
        this._fullCatOffsets = dinfo._catOffsets;
        if (!dinfo._useAllFactorLevels) {
            this._fullCatOffsets = (int[])dinfo._catOffsets.clone();
            for (int i2 = 0; i2 < this._fullCatOffsets.length; ++i2) {
                int n = i2;
                this._fullCatOffsets[n] = this._fullCatOffsets[n] + i2;
            }
        }
        this._cats = catLevels.length;
        this._catMap = new int[this._cats][];
        this._offset = dinfo._offset;
        this._weights = dinfo._weights;
        this._fold = dinfo._fold;
        this._valid = false;
        this._interactions = null;
        ArrayList<Integer> interactionVecs = new ArrayList<Integer>();
        for (i = 0; i < fr.numCols(); ++i) {
            if (!(fr.vec(i) instanceof InteractionWrappedVec)) continue;
            interactionVecs.add(i);
        }
        if (interactionVecs.size() > 0) {
            this._interactionVecs = new int[interactionVecs.size()];
            for (i = 0; i < this._interactionVecs.length; ++i) {
                this._interactionVecs[i] = (Integer)interactionVecs.get(i);
            }
        }
        assert (dinfo._predictor_transform != null);
        assert (dinfo._response_transform != null);
        this._predictor_transform = dinfo._predictor_transform;
        this._response_transform = dinfo._response_transform;
        this._skipMissing = dinfo._skipMissing;
        this._imputeMissing = dinfo._imputeMissing;
        this._adaptedFrame = fr;
        this._catOffsets = MemoryManager.malloc4((int)(catLevels.length + 1));
        this._catMissing = new boolean[catLevels.length];
        Arrays.fill(this._catMissing, !dinfo._imputeMissing && !dinfo._skipMissing);
        int s = 0;
        for (int i3 = 0; i3 < catLevels.length; ++i3) {
            if (catLevels[i3] != null) {
                this._catMap[i3] = new int[this._adaptedFrame.vec(i3).cardinality()];
                Arrays.fill(this._catMap[i3], -1);
                for (int j = 0; j < catLevels[i3].length; ++j) {
                    this._catMap[i3][catLevels[i3][j]] = j;
                }
            }
            this._catOffsets[i3] = s;
            s += catLevels[i3].length;
        }
        this._catOffsets[this._catOffsets.length - 1] = s;
        this._catLvls = catLevels;
        this._intLvls = intLvls;
        this._responses = dinfo._responses;
        this._useAllFactorLevels = true;
        this._normMul = normMul;
        this._normSub = normSub;
        this._catNAFill = catModes;
    }

    public static int imputeCat(Vec v) {
        return DataInfo.imputeCat(v, true);
    }

    public static int imputeCat(Vec v, boolean useAllFactorLevels) {
        if (v.isCategorical()) {
            if (useAllFactorLevels) {
                return v.mode();
            }
            long[] bins = v.bins();
            return ArrayUtils.maxIndex((long[])bins, (int)0);
        }
        return (int)Math.round(v.mean());
    }

    public DataInfo filterExpandedColumns(int[] cols) {
        int k;
        assert (this._activeCols == null);
        assert (this._predictor_transform != null);
        assert (this._response_transform != null);
        if (cols == null) {
            return (DataInfo)IcedUtils.deepCopy((Iced)this);
        }
        int hasIcpt = cols.length > 0 && cols[cols.length - 1] == this.fullN() ? 1 : 0;
        int i = 0;
        int j = 0;
        int ignoredCnt = 0;
        int[][] catLvls = new int[this._cats][];
        int[][] intLvls = new int[this._interactionVecs == null ? 0 : this._interactionVecs.length][];
        int[] ignoredCols = MemoryManager.malloc4((int)(this._nums + this._cats));
        if (this._catOffsets != null) {
            int coff;
            int n = coff = this._useAllFactorLevels ? 0 : 1;
            while (i < cols.length && cols[i] < this.numStart()) {
                int[] levels = MemoryManager.malloc4((int)(this._catOffsets[j + 1] - this._catOffsets[j]));
                k = 0;
                while (i < cols.length && cols[i] < this._catOffsets[j + 1]) {
                    levels[k++] = cols[i++] - this._catOffsets[j] + coff;
                }
                if (k > 0) {
                    catLvls[j] = Arrays.copyOf(levels, k);
                }
                ++j;
            }
        }
        int[] catModes = this._catNAFill;
        for (int k2 = 0; k2 < catLvls.length; ++k2) {
            if (catLvls[k2] != null) continue;
            ignoredCols[ignoredCnt++] = k2;
        }
        if (ignoredCnt > 0) {
            int[][] cs = new int[this._cats - ignoredCnt][];
            catModes = new int[this._cats - ignoredCnt];
            int y = 0;
            for (int c = 0; c < catLvls.length; ++c) {
                if (catLvls[c] == null) continue;
                catModes[y] = this._catNAFill[c];
                cs[y++] = catLvls[c];
            }
            assert (y == cs.length);
            catLvls = cs;
        }
        j = 0;
        int prev = 0;
        if (this._interactionVecs != null && this._numOffsets.length > intLvls.length) {
            int k3;
            while (i < cols.length && cols[i] < this._numOffsets[intLvls.length]) {
                int[] lvls = MemoryManager.malloc4((int)(this._numOffsets[j + 1] - this._numOffsets[j]));
                k3 = 0;
                while (i < cols.length && cols[i] < this._numOffsets[j + 1]) {
                    lvls[k3++] = cols[i++] - this._numOffsets[j];
                }
                if (k3 > 0) {
                    intLvls[j] = Arrays.copyOf(lvls, k3);
                }
                ++j;
            }
            int preIgnoredCnt = ignoredCnt;
            for (k3 = 0; k3 < intLvls.length; ++k3) {
                if (null != intLvls[k3]) continue;
                ignoredCols[ignoredCnt++] = k3 + this._cats;
            }
            if (ignoredCnt > preIgnoredCnt) {
                int[][] is = new int[this._interactionVecs.length - (ignoredCnt - preIgnoredCnt)][];
                int y = 0;
                for (int[] intLvl : intLvls) {
                    if (intLvl == null) continue;
                    is[y++] = intLvl;
                }
                intLvls = is;
            }
        }
        j = this._interactionVecs == null ? 0 : this._interactionVecs.length;
        prev = j;
        while (i < cols.length && j < this._numOffsets.length) {
            int numsToIgnore = cols[i] - this._numOffsets[j];
            for (int k4 = 0; k4 < numsToIgnore; ++k4) {
                ignoredCols[ignoredCnt++] = this._cats + prev++;
                ++j;
            }
            prev = ++j;
            ++i;
        }
        for (k = prev; k < this._nums; ++k) {
            ignoredCols[ignoredCnt++] = k + this._cats;
        }
        Frame f = new Frame((String[])this._adaptedFrame.names().clone(), (Vec[])this._adaptedFrame.vecs().clone());
        if (ignoredCnt > 0) {
            f.remove(Arrays.copyOf(ignoredCols, ignoredCnt));
        }
        assert (catLvls.length <= f.numCols()) : "cats = " + catLvls.length + " numcols = " + f.numCols();
        double[] normSub = null;
        double[] normMul = null;
        int id = Arrays.binarySearch(cols, this.numStart());
        if (id < 0) {
            id = -id - 1;
        }
        int nnums = cols.length - id - hasIcpt;
        int off = this.numStart();
        if (this._normSub != null) {
            normSub = new double[nnums];
            for (int k5 = id; k5 < id + nnums; ++k5) {
                normSub[k5 - id] = this._normSub[cols[k5] - off];
            }
        }
        if (this._normMul != null) {
            normMul = new double[nnums];
            for (int k6 = id; k6 < id + nnums; ++k6) {
                normMul[k6 - id] = this._normMul[cols[k6] - off];
            }
        }
        DataInfo dinfo = new DataInfo(this, f, normMul, normSub, catLvls, intLvls, catModes, cols);
        dinfo._nums = f.numCols() - dinfo._cats - dinfo._responses - (dinfo._offset ? 1 : 0) - (dinfo._weights ? 1 : 0) - (dinfo._fold ? 1 : 0);
        dinfo._numMeans = new double[nnums];
        dinfo._numNAFill = new double[nnums];
        for (int k7 = id; k7 < id + nnums; ++k7) {
            dinfo._numMeans[k7 - id] = this._numMeans[cols[k7] - off];
            dinfo._numNAFill[k7 - id] = this._numNAFill[cols[k7] - off];
        }
        return dinfo;
    }

    public void updateWeightedSigmaAndMean(double[] sigmas, double[] mean) {
        int i;
        int sub = this.numNums() - this._nums;
        if (this._predictor_transform.isSigmaScaled()) {
            if (sigmas.length + sub != this._normMul.length) {
                throw new IllegalArgumentException("Length of sigmas does not match number of scaled columns.");
            }
            for (i = 0; i < this._normMul.length; ++i) {
                this._normMul[i] = i < sub ? this._normMul[i] : (sigmas[i - sub] != 0.0 ? 1.0 / sigmas[i - sub] : 1.0);
            }
        }
        if (this._predictor_transform.isMeanAdjusted()) {
            if (mean.length + sub != this._normSub.length) {
                throw new IllegalArgumentException("Length of means does not match number of scaled columns.");
            }
            for (i = 0; i < this._normSub.length; ++i) {
                this._normSub[i] = i < sub ? this._normSub[i] : mean[i - sub];
            }
        }
    }

    public void updateWeightedSigmaAndMeanForResponse(double[] sigmas, double[] mean) {
        if (this._response_transform.isSigmaScaled()) {
            if (sigmas.length != this._normRespMul.length) {
                throw new IllegalArgumentException("Length of sigmas does not match number of scaled columns.");
            }
            for (int i = 0; i < sigmas.length; ++i) {
                this._normRespMul[i] = sigmas[i] != 0.0 ? 1.0 / sigmas[i] : 1.0;
            }
        }
        if (this._response_transform.isMeanAdjusted()) {
            if (mean.length != this._normRespSub.length) {
                throw new IllegalArgumentException("Length of means does not match number of scaled columns.");
            }
            System.arraycopy(mean, 0, this._normRespSub, 0, mean.length);
        }
    }

    private void setTransform(TransformType t, double[] normMul, double[] normSub, int vecStart, int n) {
        int idx = 0;
        for (int i = 0; i < n; ++i) {
            Vec v = this._adaptedFrame.vec(vecStart + i);
            boolean isIWV = v instanceof InteractionWrappedVec;
            switch (t) {
                case STANDARDIZE: {
                    int offset;
                    InteractionWrappedVec iwv;
                    if (isIWV) {
                        iwv = (InteractionWrappedVec)v;
                        for (offset = 0; offset < iwv.expandedLength(); ++offset) {
                            normMul[idx + offset] = iwv.getMul(offset + (iwv._useAllFactorLevels ? 0 : 1));
                            normSub[idx + offset] = iwv.getSub(offset + (iwv._useAllFactorLevels ? 0 : 1));
                        }
                        break;
                    }
                    normMul[idx] = v.sigma() != 0.0 ? 1.0 / v.sigma() : 1.0;
                    normSub[idx] = v.mean();
                    break;
                }
                case NONE: {
                    int offset;
                    InteractionWrappedVec iwv;
                    if (isIWV) {
                        iwv = (InteractionWrappedVec)v;
                        for (offset = 0; offset < iwv.expandedLength(); ++offset) {
                            normMul[idx + offset] = iwv.getSigma(offset + (iwv._useAllFactorLevels ? 0 : 1));
                            normSub[idx + offset] = iwv.getSub(offset + (iwv._useAllFactorLevels ? 0 : 1));
                        }
                        break;
                    }
                    normMul[idx] = v.sigma();
                    normSub[idx] = v.mean();
                    break;
                }
                case NORMALIZE: {
                    if (isIWV) {
                        throw H2O.unimpl();
                    }
                    normMul[idx] = v.max() - v.min() > 0.0 ? 1.0 / (v.max() - v.min()) : 1.0;
                    normSub[idx] = v.mean();
                    break;
                }
                case DEMEAN: {
                    int offset;
                    InteractionWrappedVec iwv;
                    if (isIWV) {
                        iwv = (InteractionWrappedVec)v;
                        for (offset = 0; offset < iwv.expandedLength(); ++offset) {
                            normSub[idx + offset] = iwv.getMeans()[offset];
                            normMul[idx + offset] = 1.0;
                        }
                        break;
                    }
                    normSub[idx] = v.mean();
                    normMul[idx] = 1.0;
                    break;
                }
                case DESCALE: {
                    if (isIWV) {
                        throw H2O.unimpl();
                    }
                    normMul[idx] = v.sigma() != 0.0 ? 1.0 / v.sigma() : 1.0;
                    normSub[idx] = 0.0;
                    break;
                }
                default: {
                    throw H2O.unimpl();
                }
            }
            assert (!Double.isNaN(normMul[idx]));
            assert (!Double.isNaN(normSub[idx]));
            idx = isIWV ? idx + this.nextNumericIdx(i) : idx + 1;
        }
    }

    public void setPredictorTransform(TransformType t) {
        this._predictor_transform = t;
        if (t == TransformType.NONE) {
            this._normMul = null;
            this._normSub = null;
            if (this._adaptedFrame != null) {
                this._normSigmaStandardizationOff = MemoryManager.malloc8d((int)this.numNums());
                this._normSubStandardizationOff = MemoryManager.malloc8d((int)this.numNums());
                this.setTransform(t, this._normSigmaStandardizationOff, this._normSubStandardizationOff, this._cats, this._nums);
            }
        } else {
            this._normMul = MemoryManager.malloc8d((int)this.numNums());
            this._normSub = MemoryManager.malloc8d((int)this.numNums());
            this.setTransform(t, this._normMul, this._normSub, this._cats, this._nums);
        }
    }

    public void setResponseTransform(TransformType t) {
        this._response_transform = t;
        if (t == TransformType.NONE) {
            this._normRespMul = null;
            this._normRespSub = null;
        } else {
            this._normRespMul = MemoryManager.malloc8d((int)this._responses);
            this._normRespSub = MemoryManager.malloc8d((int)this._responses);
            this.setTransform(t, this._normRespMul, this._normRespSub, this._adaptedFrame.numCols() - this._responses, this._responses);
        }
    }

    public boolean isInteractionVec(int colid) {
        if (null == this._interactions && null == this._interactionVecs) {
            return false;
        }
        if (this._adaptedFrame != null) {
            return this._adaptedFrame.vec(colid) instanceof InteractionWrappedVec;
        }
        return Arrays.binarySearch(this._interactionVecs, colid) >= 0;
    }

    public final int fullN() {
        return this.numNums() + this.numCats();
    }

    public final int largestCat() {
        return this._cats > 0 ? this._catOffsets[1] : 0;
    }

    public final int numStart() {
        return this._catOffsets[this._cats];
    }

    public final int numCats() {
        return this._catOffsets[this._cats];
    }

    public final int numNums() {
        int nnums = 0;
        if (this._numOffsets == null && this._intLvls.length > 0) {
            for (int[] _intLvl : this._intLvls) {
                nnums += _intLvl == null ? 0 : _intLvl.length - 1;
            }
            return nnums + this._nums;
        }
        return this._interactionVecs != null && this._numOffsets != null ? this._numOffsets[this._numOffsets.length - 1] - this.numStart() : this._nums;
    }

    public final int nextNumericIdx(int currentColIdx) {
        if (this._numOffsets == null) {
            if (currentColIdx < this._interactionVecs.length) {
                return this._intLvls[currentColIdx].length;
            }
            return 1;
        }
        if (currentColIdx + 1 >= this._numOffsets.length) {
            return this.fullN() - this._numOffsets[currentColIdx];
        }
        return this._numOffsets[currentColIdx + 1] - this._numOffsets[currentColIdx];
    }

    public final String[] coefNames() {
        int i;
        if (this._coefNames != null) {
            return this._coefNames;
        }
        int k = 0;
        int n = this.fullN();
        String[] res = new String[n];
        Vec[] vecs = this._adaptedFrame.vecs();
        for (i = 0; i < this._cats; ++i) {
            InteractionWrappedVec iwv;
            int j;
            int n2 = j = this._useAllFactorLevels || vecs[i] instanceof InteractionWrappedVec ? 0 : 1;
            while (j < vecs[i].domain().length) {
                int jj = this.getCategoricalId(i, j);
                if (jj >= 0) {
                    res[k++] = this._adaptedFrame._names[i] + "." + vecs[i].domain()[j];
                }
                ++j;
            }
            if (this._catMissing[i] && this.getCategoricalId(i, -1) >= 0) {
                res[k++] = this._adaptedFrame._names[i] + ".missing(NA)";
            }
            if (!(vecs[i] instanceof InteractionWrappedVec) || null == (iwv = (InteractionWrappedVec)vecs[i]).missingDomains()) continue;
            for (String s : iwv.missingDomains()) {
                res[k++] = s + ".missing(NA)";
            }
        }
        if (this._interactions == null) {
            int nums = n - k;
            System.arraycopy(this._adaptedFrame._names, this._cats, res, k, nums);
        } else {
            for (i = 0; i <= this._nums && i + this._cats < n && k < n; ++i) {
                InteractionWrappedVec v;
                if (vecs[i + this._cats] instanceof InteractionWrappedVec && (v = (InteractionWrappedVec)vecs[i + this._cats]).domain() != null) {
                    int j;
                    int n3 = j = v._useAllFactorLevels ? 0 : 1;
                    while (j < v.domain().length) {
                        if (this.getCategoricalIdFromInteraction(this._cats + i, j) >= 0) {
                            res[k++] = this._adaptedFrame._names[i + this._cats] + "." + v.domain()[j];
                        }
                        ++j;
                    }
                    continue;
                }
                res[k++] = this._adaptedFrame._names[i + this._cats];
            }
        }
        this._coefNames = res;
        return res;
    }

    public int[] mapNames(String[] names) {
        assert (names.length == this._adaptedFrame._names.length) : "Names must be the same length!";
        int[] idx = new int[names.length];
        Arrays.fill(idx, -1);
        block0: for (int i = 0; i < this._adaptedFrame._names.length; ++i) {
            for (int j = 0; j < names.length; ++j) {
                if (!names[j].equals(this._adaptedFrame.name(i))) continue;
                idx[i] = j;
                continue block0;
            }
        }
        return idx;
    }

    public final void unScaleNumericals(double[] in, double[] out) {
        if (this._nums == 0) {
            return;
        }
        assert (in.length == out.length);
        assert (in.length == this.fullN());
        for (int k = this.numStart(); k < this.fullN(); ++k) {
            double m = this._normMul == null ? 1.0 : this._normMul[k - this.numStart()];
            double s = this._normSub == null ? 0.0 : this._normSub[k - this.numStart()];
            out[k] = in[k] / m + s;
        }
    }

    public final int getCategoricalId(int cid, double val) {
        if (Double.isNaN(val)) {
            return this.getCategoricalId(cid, -1);
        }
        int ival = (int)val;
        if ((double)ival != val) {
            throw new IllegalArgumentException("Categorical id must be an integer or NA (missing).");
        }
        return this.getCategoricalId(cid, ival);
    }

    public final int getCategoricalId(int cid, int val) {
        boolean isIWV = this.isInteractionVec(cid);
        if (val == -1) {
            val = isIWV && !this._useAllFactorLevels ? this._catNAFill[cid] - 1 : this._catNAFill[cid];
        }
        if (!this._useAllFactorLevels && !isIWV) {
            --val;
        }
        if (val < 0) {
            return -1;
        }
        int[] offs = this.fullCatOffsets();
        int expandedVal = val + offs[cid];
        if (expandedVal >= offs[cid + 1]) {
            assert (isIWV && !this._useAllFactorLevels || this._valid) : "Categorical value out of bounds, got " + val + ", next cat starts at " + this.fullCatOffsets()[cid + 1];
            if (this._skipMissing) {
                return -1;
            }
            val = this._catNAFill[cid];
            if (!this._useAllFactorLevels && !isIWV) {
                --val;
            }
        }
        if (this._catMap != null && this._catMap[cid] != null) {
            val = this._catMap[cid][val];
            assert (this._useAllFactorLevels);
        }
        return val < 0 ? -1 : val + this._catOffsets[cid];
    }

    public final int getCategoricalIdFromInteraction(int cid, int val) {
        InteractionWrappedVec v = (InteractionWrappedVec)this._adaptedFrame.vec(cid);
        if (v.isCategorical()) {
            return this.getCategoricalId(cid, val);
        }
        assert (v.domain() != null) : "No domain levels found for interactions! cid: " + cid + " val: " + val;
        cid -= this._cats;
        if (!v._useAllFactorLevels) {
            --val;
        }
        assert (val >= 0);
        if (val >= this._numOffsets[cid + 1]) {
            assert (this._valid) : "interaction value out of bounds, got " + val + ", next cat starts at " + this._numOffsets[cid + 1];
            val = v.mode();
        }
        if (cid < this._intLvls.length && this._intLvls[cid] != null) {
            assert (this._useAllFactorLevels);
            val = Arrays.binarySearch(this._intLvls[cid], val);
        }
        return val < 0 ? -1 : val + this._numOffsets[cid];
    }

    public final Row extractDenseRow(Chunk[] chunks, int rid, Row row) {
        int i;
        int i2;
        row.predictors_bad = false;
        row.response_bad = false;
        row.rid = (long)rid + chunks[0].start();
        row.cid = rid;
        if (this._weights) {
            row.weight = chunks[this.weightChunkId()].atd(rid);
        }
        if (row.weight == 0.0) {
            return row;
        }
        if (this._skipMissing) {
            int N = this._cats + this._nums;
            for (i2 = 0; i2 < N; ++i2) {
                if (!chunks[i2].isNA(rid)) continue;
                row.predictors_bad = true;
                return row;
            }
        }
        int nbins = 0;
        for (i2 = 0; i2 < this._cats; ++i2) {
            int cid = this.getCategoricalId(i2, chunks[i2].isNA(rid) ? this._catNAFill[i2] : (int)chunks[i2].at8(rid));
            if (cid < 0) continue;
            row.binIds[nbins++] = cid;
        }
        row.nBins = nbins;
        int n = this._nums;
        int numValsIdx = 0;
        for (i = 0; i < n; ++i) {
            if (this.isInteractionVec(this._cats + i)) {
                InteractionWrappedVec iwv = (InteractionWrappedVec)this._adaptedFrame.vec(this._cats + i);
                int interactionOffset = this.getInteractionOffset(chunks, this._cats + i, rid);
                for (int offset = 0; offset < iwv.expandedLength(); ++offset) {
                    if (i < this._intLvls.length && this._intLvls[i] != null && Arrays.binarySearch(this._intLvls[i], offset) < 0) continue;
                    double d = 0.0;
                    if (offset == interactionOffset) {
                        d = chunks[this._cats + i].atd(rid);
                    }
                    if (Double.isNaN(d)) {
                        d = this._numNAFill[numValsIdx];
                    }
                    if (this._normMul != null && this._normSub != null) {
                        d = (d - this._normSub[numValsIdx]) * this._normMul[numValsIdx];
                    }
                    row.numVals[numValsIdx++] = d;
                }
                continue;
            }
            double d = chunks[this._cats + i].atd(rid);
            if (Double.isNaN(d)) {
                d = this._numNAFill[numValsIdx];
            }
            if (this._normMul != null && this._normSub != null) {
                d = (d - this._normSub[numValsIdx]) * this._normMul[numValsIdx];
            }
            row.numVals[numValsIdx++] = d;
        }
        for (i = 0; i < this._responses; ++i) {
            row.response[i] = chunks[this.responseChunkId(i)].atd(rid);
            if (Double.isNaN(row.response[i])) {
                row.response_bad = true;
                break;
            }
            if (this._normRespMul == null) continue;
            row.response[i] = (row.response[i] - this._normRespSub[i]) * this._normRespMul[i];
        }
        if (this._offset) {
            row.offset = chunks[this.offsetChunkId()].atd(rid);
        }
        return row;
    }

    public int getInteractionOffset(Chunk[] chunks, int cid, int rid) {
        boolean useAllFactors = ((InteractionWrappedVec)chunks[cid].vec())._useAllFactorLevels;
        InteractionWrappedVec.InteractionWrappedChunk c = (InteractionWrappedVec.InteractionWrappedChunk)chunks[cid];
        if (c._c1IsCat) {
            if (!c._c[0].isNA(rid)) {
                return (int)c._c[0].at8(rid) - (useAllFactors ? 0 : 1);
            }
            return c._c[0].vec().mode() - (useAllFactors ? 0 : 1);
        }
        if (c._c2IsCat) {
            if (!c._c[1].isNA(rid)) {
                return (int)c._c[1].at8(rid) - (useAllFactors ? 0 : 1);
            }
            return c._c[1].vec().mode() - (useAllFactors ? 0 : 1);
        }
        return 0;
    }

    public Vec getWeightsVec() {
        return this._adaptedFrame.vec(this.weightChunkId());
    }

    public Vec getOffsetVec() {
        return this._adaptedFrame.vec(this.offsetChunkId());
    }

    public Row newDenseRow() {
        return new Row(false, this.numNums(), this._cats, this._responses, 0, 0L);
    }

    public Row newDenseRow(double[] numVals, long start) {
        return new Row(false, numVals, null, null, 0, start);
    }

    public Rows rows(Chunk[] chks) {
        int cnt = 0;
        for (Chunk c : chks) {
            if (!c.isSparseZero()) continue;
            ++cnt;
        }
        return this.rows(chks, cnt > chks.length >> 1);
    }

    public Rows rows(Chunk[] chks, boolean sparse) {
        return new Rows(chks, sparse);
    }

    public final Row[] extractSparseRows(Chunk[] chunks) {
        int i;
        Row[] rows = new Row[chunks[0]._len];
        long startOff = chunks[0].start();
        for (i = 0; i < rows.length; ++i) {
            rows[i] = new Row(true, Math.min(this._nums, 16), this._cats, this._responses, i, startOff);
            rows[i].rid = chunks[0].start() + (long)i;
            if (this._offset) {
                rows[i].offset = chunks[this.offsetChunkId()].atd(i);
                if (Double.isNaN(rows[i].offset)) {
                    rows[i].predictors_bad = true;
                    continue;
                }
            }
            if (!this._weights) continue;
            rows[i].weight = chunks[this.weightChunkId()].atd(i);
            if (!Double.isNaN(rows[i].weight)) continue;
            rows[i].predictors_bad = true;
        }
        for (i = 0; i < this._cats; ++i) {
            for (int r = 0; r < chunks[0]._len; ++r) {
                Row row = rows[r];
                boolean isMissing = chunks[i].isNA(r);
                if (this._skipMissing && isMissing) {
                    row.predictors_bad = true;
                    continue;
                }
                int cid = this.getCategoricalId(i, isMissing ? -1 : (int)chunks[i].at8(r));
                if (cid < 0) continue;
                row.binIds[row.nBins++] = cid;
            }
        }
        int interactionOffset = 0;
        for (int cid = 0; cid < this._nums; ++cid) {
            Chunk c = chunks[this._cats + cid];
            int oldRow = -1;
            if (c instanceof InteractionWrappedVec.InteractionWrappedChunk) {
                InteractionWrappedVec iwv = (InteractionWrappedVec)c.vec();
                for (int r = 0; r < c._len; ++r) {
                    int cidVirtualOffset;
                    Row row = rows[r];
                    if (c.isNA(r) && this._skipMissing) {
                        row.predictors_bad = true;
                    }
                    if (row.predictors_bad || (cidVirtualOffset = this.getInteractionOffset(chunks, this._cats + cid, r)) < 0 || cid < this._intLvls.length && this._intLvls[cid] != null && Arrays.binarySearch(this._intLvls[cid], cidVirtualOffset) < 0 || c.atd(r) == 0.0) continue;
                    double d = c.atd(r);
                    if (Double.isNaN(d)) {
                        d = this._numNAFill[interactionOffset + cidVirtualOffset];
                    }
                    if (this._normMul != null) {
                        d *= this._normMul[interactionOffset + cidVirtualOffset];
                    }
                    row.addNum(this.numStart() + interactionOffset + cidVirtualOffset, d);
                }
                interactionOffset += this.nextNumericIdx(cid);
                continue;
            }
            int r = c.nextNZ(-1, this._imputeMissing);
            while (r < c._len) {
                if (c.atd(r) != 0.0) {
                    assert (r > oldRow);
                    oldRow = r;
                    Row row = rows[r];
                    if (c.isNA(r) && this._skipMissing) {
                        row.predictors_bad = true;
                    }
                    if (!row.predictors_bad) {
                        double d = c.atd(r);
                        if (Double.isNaN(d)) {
                            d = this._numNAFill[cid];
                        }
                        if (this._normMul != null) {
                            d *= this._normMul[interactionOffset];
                        }
                        row.addNum(this.numStart() + interactionOffset, d);
                    }
                }
                r = c.nextNZ(r, this._imputeMissing);
            }
            ++interactionOffset;
        }
        for (int i2 = 1; i2 <= this._responses; ++i2) {
            int rid = this.responseChunkId(i2 - 1);
            Chunk rChunk = chunks[rid];
            for (int r = 0; r < chunks[0]._len; ++r) {
                Row row = rows[r];
                row.response[i2 - 1] = rChunk.atd(r);
                if (Double.isNaN(row.response[i2 - 1])) {
                    row.response_bad = true;
                }
                if (this._normRespMul == null) continue;
                row.response[i2 - 1] = (row.response[i2 - 1] - this._normRespSub[i2 - 1]) * this._normRespMul[i2 - 1];
            }
        }
        return rows;
    }

    public DataInfo scoringInfo(String[] names, Frame adaptFrame) {
        return this.scoringInfo(names, adaptFrame, -1, true);
    }

    public DataInfo scoringInfo(String[] names, Frame adaptFrame, int nResponses, boolean fixIVW) {
        int resId;
        DataInfo res = (DataInfo)IcedUtils.deepCopy((Iced)this);
        res._normMul = null;
        res._normRespSub = null;
        res._normRespMul = null;
        res._normRespSub = null;
        res._predictor_transform = TransformType.NONE;
        res._response_transform = TransformType.NONE;
        res._adaptedFrame = adaptFrame;
        res._weights = this._weights && adaptFrame.find(names[this.weightChunkId()]) != -1;
        res._offset = this._offset && adaptFrame.find(names[this.offsetChunkId()]) != -1;
        boolean bl = res._fold = this._fold && adaptFrame.find(names[this.foldChunkId()]) != -1;
        res._responses = nResponses != -1 ? nResponses : ((resId = adaptFrame.find(names[this.responseChunkId(0)])) == -1 || adaptFrame.vec(resId).isBad() ? 0 : 1);
        res._valid = true;
        res._interactions = this._interactions;
        res._interactionSpec = this._interactionSpec;
        if (fixIVW) {
            for (Vec v : res._adaptedFrame.vecs()) {
                if (!(v instanceof InteractionWrappedVec)) continue;
                ((InteractionWrappedVec)v)._useAllFactorLevels = this._useAllFactorLevels;
                ((InteractionWrappedVec)v)._skipMissing = this._skipMissing;
                DKV.put((Keyed)v);
            }
        }
        return res;
    }

    public DataInfo scoringInfo() {
        DataInfo res = (DataInfo)IcedUtils.deepCopy((Iced)this);
        res._valid = true;
        return res;
    }

    public static class MeanImputer
    implements Imputer {
        @Override
        public int imputeCat(String name, Vec v, boolean useAllFactorLevels) {
            return DataInfo.imputeCat(v, useAllFactorLevels);
        }

        @Override
        public double imputeNum(String name, Vec v) {
            return v.mean();
        }

        @Override
        public double[] imputeInteraction(String name, InteractionWrappedVec iv, double[] means) {
            return means;
        }
    }

    public static interface Imputer {
        public int imputeCat(String var1, Vec var2, boolean var3);

        public double imputeNum(String var1, Vec var2);

        public double[] imputeInteraction(String var1, InteractionWrappedVec var2, double[] var3);
    }

    public final class Rows {
        public final int _nrows;
        private final Row _denseRow;
        private final Row[] _sparseRows;
        public final boolean _sparse;
        private final Chunk[] _chks;

        private Rows(Chunk[] chks, boolean sparse) {
            this._nrows = chks[0]._len;
            this._sparse = sparse;
            long start = chks[0].start();
            if (sparse) {
                this._denseRow = null;
                this._chks = null;
                this._sparseRows = DataInfo.this.extractSparseRows(chks);
            } else {
                this._denseRow = DataInfo.this.newDenseRow();
                this._chks = chks;
                this._sparseRows = null;
            }
        }

        public Row row(int i) {
            return this._sparse ? this._sparseRows[i] : DataInfo.this.extractDenseRow(this._chks, i, this._denseRow);
        }
    }

    public final class Row
    extends Iced {
        public boolean predictors_bad;
        public boolean response_bad;
        public double[] numVals;
        public double[] response;
        public int[] numIds;
        public int[] binIds;
        public long rid;
        public int cid;
        public int nBins;
        public int nNums;
        public double offset = 0.0;
        public double weight = 1.0;

        public boolean isBad() {
            return this.predictors_bad || this.response_bad;
        }

        public final boolean isSparse() {
            return this.numIds != null;
        }

        public double[] mtrxMul(double[][] m, double[] res) {
            for (int i = 0; i < m.length; ++i) {
                res[i] = this.innerProduct(m[i], false);
            }
            return res;
        }

        public Row(boolean sparse, int nNums, int nBins, int nresponses, int i, long start) {
            this.binIds = MemoryManager.malloc4((int)nBins);
            this.numVals = MemoryManager.malloc8d((int)nNums);
            this.response = MemoryManager.malloc8d((int)nresponses);
            if (sparse) {
                this.numIds = MemoryManager.malloc4((int)nNums);
            }
            this.nNums = sparse ? 0 : nNums;
            this.cid = i;
            this.rid = start + (long)i;
        }

        public Row(boolean sparse, double[] numVals, int[] binIds, double[] response, int i, long start) {
            int nNums = numVals == null ? 0 : numVals.length;
            this.numVals = numVals;
            if (sparse) {
                this.numIds = MemoryManager.malloc4((int)nNums);
            }
            this.nNums = sparse ? 0 : nNums;
            this.nBins = binIds == null ? 0 : binIds.length;
            this.binIds = binIds;
            this.response = response;
            this.cid = i;
            this.rid = start + (long)i;
        }

        public Row(double[] nums) {
            this.numVals = nums;
            this.nNums = nums.length;
        }

        public double response(int i) {
            return this.response[i];
        }

        public double get(int i) {
            int off = DataInfo.this.numStart();
            if (i >= off) {
                if (this.numIds == null) {
                    return this.numVals[i - off];
                }
                int j = Arrays.binarySearch(this.numIds, 0, this.nNums, i);
                return j >= 0 ? this.numVals[j] : 0.0;
            }
            int j = Arrays.binarySearch(this.binIds, 0, this.nBins, i);
            return j >= 0 ? 1.0 : 0.0;
        }

        public void addNum(int id, double val) {
            if (this.numIds.length == this.nNums) {
                int newSz = Math.max(4, this.numIds.length + (this.numIds.length >> 1));
                this.numIds = Arrays.copyOf(this.numIds, newSz);
                this.numVals = Arrays.copyOf(this.numVals, newSz);
            }
            int i = this.nNums++;
            this.numIds[i] = id;
            this.numVals[i] = val;
        }

        public final double dotSame(Row rowj) {
            double elementij = 0.0;
            for (int i = 0; i < this.nNums; ++i) {
                elementij += this.numVals[i] * rowj.numVals[i];
            }
            if (this.binIds.length > 0) {
                for (int j = 0; j < this.nBins; ++j) {
                    if (this.binIds[j] != rowj.binIds[j]) continue;
                    elementij += 1.0;
                }
            }
            return elementij * this.weight * rowj.weight;
        }

        public final double innerProduct(double[] vec) {
            return this.innerProduct(vec, false);
        }

        public final double innerProduct(double[] vec, boolean icptFirst) {
            int i;
            double res = 0.0;
            int off = 0;
            if (icptFirst) {
                off = 1;
                res = vec[0];
            }
            int numStart = off + DataInfo.this.numStart();
            for (i = 0; i < this.nBins; ++i) {
                res += vec[off + this.binIds[i]];
            }
            if (this.numIds == null) {
                for (i = 0; i < this.numVals.length; ++i) {
                    res += this.numVals[i] * vec[numStart + i];
                }
            } else {
                for (i = 0; i < this.nNums; ++i) {
                    res += this.numVals[i] * vec[off + this.numIds[i]];
                }
            }
            if (DataInfo.this._intercept && !icptFirst) {
                res += vec[vec.length - 1];
            }
            return res;
        }

        public final double innerProduct(Row row) {
            int i;
            assert (!DataInfo.this._intercept);
            assert (this.numIds == null);
            double res = 0.0;
            for (i = 0; i < this.nBins; ++i) {
                if (this.binIds[i] != row.binIds[i]) continue;
                res += 1.0;
            }
            for (i = 0; i < this.numVals.length; ++i) {
                res += this.numVals[i] * row.numVals[i];
            }
            return res;
        }

        public double[] scalarProduct(double w, double[] rowContent, int catOffsets) {
            int i;
            rowContent[0] = w;
            for (i = 0; i < this.nBins; ++i) {
                rowContent[this.binIds[i] + 1] = w;
            }
            for (i = 0; i < this.numVals.length; ++i) {
                int n = i + catOffsets + 1;
                rowContent[n] = rowContent[n] + this.numVals[i] * w;
            }
            return rowContent;
        }

        public final double twoNormSq() {
            assert (!DataInfo.this._intercept);
            assert (this.numIds == null);
            double res = this.nBins;
            for (double v : this.numVals) {
                res += v * v;
            }
            return res;
        }

        public double[] expandCats() {
            int i;
            if (this.isSparse() || DataInfo.this._responses > 0) {
                throw H2O.unimpl();
            }
            int N = DataInfo.this.fullN();
            int numStart = DataInfo.this.numStart();
            double[] res = new double[N + (DataInfo.this._intercept ? 1 : 0)];
            for (i = 0; i < this.nBins; ++i) {
                res[this.binIds[i]] = 1.0;
            }
            if (this.numIds == null) {
                System.arraycopy(this.numVals, 0, res, numStart, this.numVals.length);
            } else {
                for (i = 0; i < this.nNums; ++i) {
                    res[this.numIds[i]] = this.numVals[i];
                }
            }
            if (DataInfo.this._intercept) {
                res[res.length - 1] = 1.0;
            }
            return res;
        }

        public String toString() {
            return this.rid + Arrays.toString(Arrays.copyOf(this.binIds, this.nBins)) + ", " + Arrays.toString(this.numVals);
        }

        public void setResponse(int i, double z) {
            this.response[i] = z;
        }

        public void standardize(double[] normSub, double[] normMul) {
            if (this.numIds == null) {
                for (int i = 0; i < this.numVals.length; ++i) {
                    this.numVals[i] = (this.numVals[i] - normSub[i]) * normMul[i];
                }
            } else {
                for (int i = 0; i < this.nNums; ++i) {
                    int j = this.numIds[i];
                    this.numVals[i] = (this.numVals[i] - normSub[j]) * normMul[j];
                }
            }
        }

        public Row deepClone() {
            Row cloned = (Row)this.clone();
            cloned.numVals = (double[])this.numVals.clone();
            if (this.numIds != null) {
                cloned.numIds = (int[])this.numIds.clone();
            }
            cloned.response = (double[])this.response.clone();
            cloned.binIds = (int[])this.binIds.clone();
            return cloned;
        }

        public void addToArray(double scale, double[] res) {
            for (int i = 0; i < this.nBins; ++i) {
                int n = this.binIds[i];
                res[n] = res[n] + scale;
            }
            int numstart = DataInfo.this.numStart();
            if (this.numIds != null) {
                for (int i = 0; i < this.nNums; ++i) {
                    int n = this.numIds[i];
                    res[n] = res[n] + scale * this.numVals[i];
                }
            } else {
                for (int i = 0; i < this.numVals.length; ++i) {
                    if (this.numVals[i] == 0.0) continue;
                    int n = numstart + i;
                    res[n] = res[n] + scale * this.numVals[i];
                }
            }
            if (DataInfo.this._intercept) {
                int n = res.length - 1;
                res[n] = res[n] + scale;
            }
        }
    }

    public static enum TransformType {
        NONE,
        STANDARDIZE,
        NORMALIZE,
        DEMEAN,
        DESCALE;


        public boolean isMeanAdjusted() {
            switch (this) {
                case NONE: 
                case DESCALE: 
                case NORMALIZE: {
                    return false;
                }
                case STANDARDIZE: 
                case DEMEAN: {
                    return true;
                }
            }
            throw H2O.unimpl();
        }

        public boolean isSigmaScaled() {
            switch (this) {
                case NONE: 
                case NORMALIZE: 
                case DEMEAN: {
                    return false;
                }
                case DESCALE: 
                case STANDARDIZE: {
                    return true;
                }
            }
            throw H2O.unimpl();
        }
    }
}

