/*
 * Decompiled with CFR 0.152.
 */
package hex.gam;

import hex.DataInfo;
import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.StringPair;
import hex.deeplearning.DeepLearningModel;
import hex.gam.GAM;
import hex.gam.MatrixFrameUtils.AddGamColumns;
import hex.gam.MatrixFrameUtils.GamUtils;
import hex.gam.MetricBuilderGAM;
import hex.glm.GLM;
import hex.glm.GLMModel;
import java.io.Serializable;
import java.util.Arrays;
import water.AutoBuffer;
import water.Futures;
import water.Job;
import water.Key;
import water.Keyed;
import water.MRTask;
import water.MemoryManager;
import water.Scope;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.udf.CFuncRef;
import water.util.ArrayUtils;
import water.util.FrameUtils;
import water.util.Log;
import water.util.TwoDimTable;

public class GAMModel
extends Model<GAMModel, GAMParameters, GAMModelOutput> {
    public String[][] _gamColNamesNoCentering;
    public String[][] _gamColNames;
    public Key<Frame>[] _gamFrameKeysCenter;
    public int _nclass;
    public double[] _ymu;
    public long _nobs;
    public long _nullDOF;
    public int _rank;

    public String[] makeScoringNames() {
        Object[] names = super.makeScoringNames();
        if (((GAMModelOutput)this._output)._glm_vcov != null) {
            names = (String[])ArrayUtils.append((Object[])names, (Object[])new String[]{"StdErr"});
        }
        return names;
    }

    public ModelMetrics.MetricBuilder makeMetricBuilder(String[] domain) {
        if (domain == null && (((GAMParameters)this._parms)._family == GLMModel.GLMParameters.Family.binomial || ((GAMParameters)this._parms)._family == GLMModel.GLMParameters.Family.quasibinomial || ((GAMParameters)this._parms)._family == GLMModel.GLMParameters.Family.negativebinomial || ((GAMParameters)this._parms)._family == GLMModel.GLMParameters.Family.fractionalbinomial)) {
            domain = new String[]{"0", "1"};
        }
        GLMModel.GLMWeightsFun glmf = new GLMModel.GLMWeightsFun(((GAMParameters)this._parms)._family, ((GAMParameters)this._parms)._link, ((GAMParameters)this._parms)._tweedie_variance_power, ((GAMParameters)this._parms)._tweedie_link_power, ((GAMParameters)this._parms)._theta);
        return new MetricBuilderGAM(domain, this._ymu, glmf, this._rank, true, ((GAMParameters)this._parms)._intercept, this._nclass);
    }

    public GAMModel(Key<GAMModel> selfKey, GAMParameters parms, GAMModelOutput output) {
        super(selfKey, (Model.Parameters)parms, (Model.Output)output);
        assert (Arrays.equals(this._key._kb, selfKey._kb));
    }

    public TwoDimTable copyTwoDimTable(TwoDimTable table) {
        String[] rowHeaders = table.getRowHeaders();
        String[] colTypes = table.getColTypes();
        int tableSize = rowHeaders.length;
        int colSize = colTypes.length;
        TwoDimTable tableCopy = new TwoDimTable("glm scoring history", "", rowHeaders, table.getColHeaders(), colTypes, table.getColFormats(), "names");
        for (int rowIndex = 0; rowIndex < tableSize; ++rowIndex) {
            for (int colIndex = 0; colIndex < colSize; ++colIndex) {
                tableCopy.set(rowIndex, colIndex, table.get(rowIndex, colIndex));
            }
        }
        return tableCopy;
    }

    TwoDimTable genCoefficientTable(String[] colHeaders, double[] coefficients, double[] coefficientsStand, String[] coefficientNames, String tableHeader) {
        String[] colTypes = new String[]{"double", "double"};
        String[] colFormat = new String[]{"%5f", "%5f"};
        int nCoeff = coefficients.length;
        String[] coeffNames = new String[nCoeff];
        System.arraycopy(coefficientNames, 0, coeffNames, 0, nCoeff);
        Log.info((Object[])new Object[]{"genCoefficientMagTableMultinomial", String.format("coemffNames length: %d.  coefficients length: %d, coeffSigns length: %d", coeffNames.length, coefficients.length, coefficientsStand.length)});
        TwoDimTable table = new TwoDimTable(tableHeader, "", coeffNames, colHeaders, colTypes, colFormat, "names");
        this.fillUpCoeffs(coefficients, coefficientsStand, table, 0);
        return table;
    }

    TwoDimTable genCoefficientMagTableMultinomial(String[] colHeaders, double[][] coefficients, String[] coefficientNames, String tableHeader) {
        String[] colTypes = new String[]{"double", "string"};
        String[] colFormat = new String[]{"%5f", ""};
        int nCoeff = coefficients[0].length;
        int nClass = coefficients.length;
        String[] coeffNames = new String[nCoeff - 1];
        String[] coeffNames2 = new String[coeffNames.length];
        double[] coeffMags = new double[coeffNames.length];
        double[] coeffMags2 = new double[coeffNames.length];
        String[] coeffSigns = new String[coeffNames.length];
        Log.info((Object[])new Object[]{"genCoefficientMagTableMultinomial", String.format("coeffNames length: %d.  coeffMags length: %d, coeffSigns length: %d", coeffNames.length, coeffMags.length, coeffSigns.length)});
        int countIndex = 0;
        for (int index = 0; index < nCoeff; ++index) {
            if (coefficientNames[index].equals("Intercept")) continue;
            for (int classInd = 0; classInd < nClass; ++classInd) {
                int n = countIndex;
                coeffMags[n] = coeffMags[n] + Math.abs(coefficients[classInd][index]);
            }
            coeffNames[countIndex] = coefficientNames[index];
            coeffSigns[countIndex] = "POS";
            ++countIndex;
        }
        Integer[] indices = GamUtils.sortCoeffMags(coeffMags.length, coeffMags);
        for (int index = 0; index < coeffMags.length; ++index) {
            coeffMags2[index] = coeffMags[indices[index]];
            coeffNames2[index] = coeffNames[indices[index]];
        }
        Log.info((Object[])new Object[]{"genCoefficientMagTableMultinomial", String.format("coeffNames2 length: %d.  coeffMags2 length: %d, coeffSigns length: %d", coeffNames2.length, coeffMags2.length, coeffSigns.length)});
        TwoDimTable table = new TwoDimTable(tableHeader, "Standardized Coefficient Magnitutes", coeffNames2, colHeaders, colTypes, colFormat, "names");
        this.fillUpCoeffsMag(coeffMags2, coeffSigns, table, 0);
        return table;
    }

    TwoDimTable genCoefficientMagTable(String[] colHeaders, double[] coefficients, String[] coefficientNames, String tableHeader) {
        String[] colTypes = new String[]{"double", "string"};
        String[] colFormat = new String[]{"%5f", ""};
        int nCoeff = coefficients.length;
        String[] coeffNames = new String[nCoeff - 1];
        double[] coeffMags = new double[nCoeff - 1];
        String[] coeffSigns = new String[nCoeff - 1];
        int countMagIndex = 0;
        for (int index = 0; index < nCoeff; ++index) {
            if (coefficientNames[index].equals("Intercept")) continue;
            coeffMags[countMagIndex] = Math.abs(coefficients[index]);
            coeffSigns[countMagIndex] = coefficients[index] > 0.0 ? "POS" : "NEG";
            coeffNames[countMagIndex++] = coefficientNames[index];
        }
        Integer[] indices = GamUtils.sortCoeffMags(coeffMags.length, coeffMags);
        String[] names2 = new String[coeffNames.length];
        double[] mag2 = new double[coeffNames.length];
        String[] sign2 = new String[coeffNames.length];
        for (int i = 0; i < coeffNames.length; ++i) {
            names2[i] = coeffNames[indices[i]];
            mag2[i] = coeffMags[indices[i]];
            sign2[i] = coeffSigns[indices[i]];
        }
        Log.info((Object[])new Object[]{"genCoefficientMagTableMultinomial", String.format("coeffNames length: %d.  coeffMags length: %d, coeffSigns length: %d", coeffNames.length, coeffMags.length, coeffSigns.length)});
        TwoDimTable table = new TwoDimTable(tableHeader, "", names2, colHeaders, colTypes, colFormat, "names");
        this.fillUpCoeffsMag(mag2, sign2, table, 0);
        return table;
    }

    private void fillUpCoeffsMag(double[] coeffMags, String[] coeffSigns, TwoDimTable tdt, int rowStart) {
        int arrLength = coeffMags.length + rowStart;
        int arrCounter = 0;
        for (int i = rowStart; i < arrLength; ++i) {
            tdt.set(i, 0, (Object)coeffMags[arrCounter]);
            tdt.set(i, 1, (Object)coeffSigns[arrCounter]);
            ++arrCounter;
        }
    }

    TwoDimTable genCoefficientTableMultinomial(String[] colHeaders, double[][] coefficients, double[][] coefficients_stand, String[] coefficientNames, String tableHeader) {
        String[] colTypes = new String[]{"double", "double"};
        String[] colFormat = new String[]{"%5f", "%5f"};
        int nCoeff = coefficients[0].length;
        int nclass = coefficients.length;
        int totCoeff = nCoeff * nclass;
        String[] coeffNames = new String[totCoeff];
        int coeffCounter = 0;
        for (int classInd = 0; classInd < nclass; ++classInd) {
            for (int ind = 0; ind < nCoeff; ++ind) {
                coeffNames[coeffCounter++] = coefficientNames[ind] + "_class_" + classInd;
            }
        }
        TwoDimTable table = new TwoDimTable(tableHeader, "", coeffNames, colHeaders, colTypes, colFormat, "names");
        for (int classInd = 0; classInd < nclass; ++classInd) {
            this.fillUpCoeffs(coefficients[classInd], coefficients_stand[classInd], table, classInd * nCoeff);
        }
        return table;
    }

    private void fillUpCoeffs(double[] coeffValues, double[] coeffValuesStand, TwoDimTable tdt, int rowStart) {
        int arrLength = coeffValues.length + rowStart;
        int arrCounter = 0;
        for (int i = rowStart; i < arrLength; ++i) {
            tdt.set(i, 0, (Object)coeffValues[arrCounter]);
            tdt.set(i, 1, (Object)coeffValuesStand[arrCounter]);
            ++arrCounter;
        }
    }

    public String[] adaptTestForTrain(Frame test, boolean expensive, boolean computeMetrics) {
        String[] testNames = test.names();
        if (!GamUtils.equalColNames(testNames, ((GAMModelOutput)this._output)._dinfo._adaptedFrame.names(), ((GAMParameters)this._parms)._response_column)) {
            Frame adptedF = this.cleanUpInputFrame(test);
            int testNumCols = test.numCols();
            for (int index = 0; index < testNumCols; ++index) {
                test.remove(0);
            }
            int adaptNumCols = adptedF.numCols();
            for (int index = 0; index < adaptNumCols; ++index) {
                test.add(adptedF.name(index), adptedF.vec(index));
            }
            return super.adaptTestForTrain(test, expensive, computeMetrics);
        }
        return super.adaptTestForTrain(test, expensive, computeMetrics);
    }

    public Frame cleanUpInputFrame(Frame test) {
        Frame adptedF = new Frame(Key.make(), test.names(), (Vec[])test.vecs().clone());
        return GAMModel.cleanUpInputFrame(adptedF, (GAMParameters)this._parms, this._gamColNames, ((GAMModelOutput)this._output)._binvD, ((GAMModelOutput)this._output)._zTranspose, ((GAMModelOutput)this._output)._knots, ((GAMModelOutput)this._output)._numKnots);
    }

    public static Frame cleanUpInputFrame(Frame adptedF, GAMParameters parms, String[][] gamColNames, double[][][] binvD, double[][][] zTranspose, double[][] knots, int[] numKnots) {
        int numGamCols = parms._gam_columns.length;
        Object[] testNames = adptedF.names();
        Vec[] gamCols = new Vec[numGamCols];
        for (int vind = 0; vind < numGamCols; ++vind) {
            gamCols[vind] = (Vec)adptedF.vec(parms._gam_columns[vind]).clone();
        }
        Frame onlyGamCols = new Frame(parms._gam_columns, gamCols);
        AddGamColumns genGamCols = new AddGamColumns(binvD, zTranspose, knots, numKnots, onlyGamCols);
        genGamCols.doAll(genGamCols._gamCols2Add, (byte)3, onlyGamCols);
        String[] gamColsNames = new String[genGamCols._gamCols2Add];
        int offset = 0;
        for (int ind = 0; ind < genGamCols._numGAMcols; ++ind) {
            System.arraycopy(gamColNames[ind], 0, gamColsNames, offset, gamColNames[ind].length);
            offset += gamColNames[ind].length;
        }
        Frame oneAugmentedColumn = genGamCols.outputFrame(Key.make(), gamColsNames, null);
        if (parms._ignored_columns != null) {
            for (String iname : parms._ignored_columns) {
                if (!ArrayUtils.contains((Object[])testNames, (Object)iname)) continue;
                adptedF.remove(iname);
            }
        }
        int numCols = adptedF.numCols();
        for (int vInd = 0; vInd < numCols; ++vInd) {
            Vec v = adptedF.vec(vInd);
            if ((!parms._ignore_const_cols || !v.isConst()) && !v.isBad()) continue;
            adptedF.remove(vInd);
        }
        Vec respV = null;
        if (ArrayUtils.contains((Object[])testNames, (Object)parms._response_column)) {
            respV = adptedF.remove(parms._response_column);
        }
        adptedF.add(oneAugmentedColumn.names(), oneAugmentedColumn.removeAll());
        Scope.track((Frame[])new Frame[]{oneAugmentedColumn});
        if (respV != null) {
            adptedF.add(parms._response_column, respV);
        }
        return adptedF;
    }

    protected Frame predictScoreImpl(Frame fr, Frame adaptFrm, String destination_key, Job j, boolean computeMetrics, CFuncRef customMetricFunc) {
        String[] predictNames = this.makeScoringNames();
        String[][] domains = new String[predictNames.length][];
        GAMScore gs = this.makeScoringTask(adaptFrm, j, computeMetrics);
        gs.doAll(predictNames.length, (byte)3, ((GAMScore)gs)._dinfo._adaptedFrame);
        if (gs._computeMetrics) {
            gs._mb.makeModelMetrics((Model)this, fr, adaptFrm, gs.outputFrame());
        }
        domains[0] = gs._predDomains;
        return gs.outputFrame(Key.make((String)destination_key), predictNames, domains);
    }

    private GAMScore makeScoringTask(Frame adaptFrm, Job j, boolean computeMetrics) {
        boolean detectedComputeMetrics;
        int responseId = adaptFrm.find(((GAMModelOutput)this._output).responseName());
        if (responseId > -1 && adaptFrm.vec(responseId).isBad()) {
            adaptFrm = new Frame(adaptFrm.names(), adaptFrm.vecs());
            adaptFrm.remove(responseId);
        }
        boolean bl = detectedComputeMetrics = computeMetrics && adaptFrm.vec(((GAMModelOutput)this._output).responseName()) != null && !adaptFrm.vec(((GAMModelOutput)this._output).responseName()).isBad();
        String[] domain = ((GAMModelOutput)this._output).nclasses() <= 1 ? null : (!detectedComputeMetrics ? ((GAMModelOutput)this._output)._domains[((GAMModelOutput)this._output)._domains.length - 1] : adaptFrm.lastVec().domain());
        return new GAMScore(j, this, ((GAMModelOutput)this._output)._dinfo.scoringInfo(((GAMModelOutput)this._output)._names, adaptFrm), domain, detectedComputeMetrics);
    }

    public double[] score0(double[] data, double[] preds) {
        throw new UnsupportedOperationException("GAMModel.score0 should never be called");
    }

    protected Futures remove_impl(Futures fs, boolean cascade) {
        Keyed.remove(((GAMModelOutput)this._output)._gamTransformedTrainCenter, (Futures)fs, (boolean)true);
        super.remove_impl(fs, cascade);
        return fs;
    }

    protected AutoBuffer writeAll_impl(AutoBuffer ab) {
        if (((GAMModelOutput)this._output)._gamTransformedTrainCenter != null) {
            ab.putKey(((GAMModelOutput)this._output)._gamTransformedTrainCenter);
        }
        return super.writeAll_impl(ab);
    }

    protected Keyed readAll_impl(AutoBuffer ab, Futures fs) {
        return super.readAll_impl(ab, fs);
    }

    private class GAMScore
    extends MRTask<GAMScore> {
        private DataInfo _dinfo;
        private double[] _coeffs;
        private double[][] _coeffs_multinomial;
        private int _nclass;
        private boolean _computeMetrics;
        final Job _j;
        GLMModel.GLMParameters.Family _family;
        private transient double[] _eta;
        private String[] _predDomains;
        final GAMModel _m;
        private final double _defaultThreshold;
        private int _lastClass;
        ModelMetrics.MetricBuilder _mb;
        final boolean _sparse;
        private transient double[][] _vcov;
        private transient double[] _tmp;

        private GAMScore(Job j, GAMModel m, DataInfo dinfo, String[] domain, boolean computeMetrics) {
            this._j = j;
            this._m = m;
            this._computeMetrics = computeMetrics;
            this._sparse = FrameUtils.sparseRatio((Frame)dinfo._adaptedFrame) < 0.5;
            this._predDomains = domain;
            this._m._parms = m._parms;
            this._nclass = ((GAMModelOutput)m._output).nclasses();
            if (((GAMParameters)this._m._parms)._family == GLMModel.GLMParameters.Family.multinomial || ((GAMParameters)this._m._parms)._family == GLMModel.GLMParameters.Family.ordinal) {
                this._coeffs = null;
                this._coeffs_multinomial = ((GAMModelOutput)m._output)._model_beta_multinomial;
            } else {
                double[] beta = ((GAMModelOutput)m._output)._model_beta;
                int[] ids = new int[beta.length - 1];
                int k = 0;
                for (int i = 0; i < beta.length - 1; ++i) {
                    if (beta[i] == 0.0) continue;
                    ids[k++] = i;
                }
                if (k < beta.length - 1) {
                    ids = Arrays.copyOf(ids, k);
                    dinfo = dinfo.filterExpandedColumns(ids);
                    double[] beta2 = MemoryManager.malloc8d((int)(ids.length + 1));
                    int l = 0;
                    for (int x : ids) {
                        beta2[l++] = beta[x];
                    }
                    beta2[l] = beta[beta.length - 1];
                    beta = beta2;
                }
                this._coeffs_multinomial = null;
                this._coeffs = beta;
            }
            this._dinfo = dinfo;
            this._dinfo._valid = true;
            this._defaultThreshold = m.defaultThreshold();
            this._family = ((GAMParameters)m._parms)._family;
            this._lastClass = this._nclass - 1;
        }

        public void map(Chunk[] chks, NewChunk[] nc) {
            if (this.isCancelled() || this._j != null && this._j.stop_requested()) {
                return;
            }
            if (this._family.equals((Object)GLMModel.GLMParameters.Family.ordinal) || this._family.equals((Object)GLMModel.GLMParameters.Family.multinomial)) {
                this._eta = MemoryManager.malloc8d((int)this._nclass);
            }
            this._vcov = ((GAMModelOutput)this._m._output)._glm_vcov;
            if (this._vcov != null) {
                this._tmp = MemoryManager.malloc8d((int)this._vcov.length);
            }
            int numPredVals = this._nclass <= 1 ? 1 : this._nclass + 1;
            double[] predictVals = MemoryManager.malloc8d((int)numPredVals);
            float[] trueResponse = null;
            if (this._computeMetrics) {
                this._mb = this._m.makeMetricBuilder(this._predDomains);
                trueResponse = new float[1];
            }
            DataInfo.Row r = this._dinfo.newDenseRow();
            int chkLen = chks[0]._len;
            for (int rid = 0; rid < chkLen; ++rid) {
                this._dinfo.extractDenseRow(chks, rid, r);
                this.processRow(r, predictVals, nc, numPredVals);
                if (!this._computeMetrics || r.response_bad) continue;
                trueResponse[0] = (float)r.response[0];
                this._mb.perRow(predictVals, trueResponse, r.weight, r.offset, (Model)this._m);
            }
            if (this._j != null) {
                this._j.update(1L);
            }
        }

        private void processRow(DataInfo.Row r, double[] ps, NewChunk[] preds, int ncols) {
            if (r.predictors_bad) {
                Arrays.fill(ps, Double.NaN);
            } else if (r.weight == 0.0) {
                Arrays.fill(ps, 0.0);
            }
            switch (this._family) {
                case multinomial: {
                    ps = this.scoreMultinomialRow(r, r.offset, ps);
                    break;
                }
                case ordinal: {
                    ps = this.scoreOrdinalRow(r, r.offset, ps);
                    break;
                }
                default: {
                    ps = this.scoreRow(r, r.offset, ps);
                }
            }
            for (int predCol = 0; predCol < ncols; ++predCol) {
                preds[predCol].addNum(ps[predCol]);
            }
            if (this._vcov != null) {
                preds[ncols].addNum(Math.sqrt(r.innerProduct(r.mtrxMul(this._vcov, this._tmp))));
            }
        }

        public double[] scoreRow(DataInfo.Row r, double offset, double[] preds) {
            GAMParameters cfr_ignored_0 = (GAMParameters)this._m._parms;
            double mu = GAMParameters.linkInv(r.innerProduct(this._coeffs) + offset, ((GAMParameters)this._m._parms)._link, ((GAMParameters)this._m._parms)._tweedie_link_power);
            if (((GAMParameters)this._m._parms)._family == GLMModel.GLMParameters.Family.binomial || ((GAMParameters)this._m._parms)._family == GLMModel.GLMParameters.Family.quasibinomial || ((GAMParameters)this._m._parms)._family == GLMModel.GLMParameters.Family.negativebinomial || ((GAMParameters)this._m._parms)._family == GLMModel.GLMParameters.Family.fractionalbinomial) {
                preds[0] = mu >= this._defaultThreshold ? 1.0 : 0.0;
                preds[1] = 1.0 - mu;
                preds[2] = mu;
            } else {
                preds[0] = mu;
            }
            return preds;
        }

        public double[] scoreOrdinalRow(DataInfo.Row r, double offset, double[] preds) {
            int cInd;
            double[][] bm = this._coeffs_multinomial;
            Arrays.fill(preds, 0.0);
            preds[0] = this._lastClass;
            double previousCDF = 0.0;
            for (cInd = 0; cInd < this._lastClass; ++cInd) {
                double eta = r.innerProduct(bm[cInd]) + offset;
                double currCDF = 1.0 / (1.0 + Math.exp(-eta));
                preds[cInd + 1] = currCDF - previousCDF;
                previousCDF = currCDF;
                if (!(eta > 0.0)) continue;
                preds[0] = cInd;
                break;
            }
            for (cInd = (int)preds[0] + 1; cInd < this._lastClass; ++cInd) {
                double currCDF = 1.0 / (1.0 + Math.exp(-r.innerProduct(bm[cInd]) + offset));
                preds[cInd + 1] = currCDF - previousCDF;
                previousCDF = currCDF;
            }
            preds[this._nclass] = 1.0 - previousCDF;
            return preds;
        }

        public double[] scoreMultinomialRow(DataInfo.Row r, double offset, double[] preds) {
            int c;
            double[] eta = this._eta;
            double[][] bm = this._coeffs_multinomial;
            double sumExp = 0.0;
            double maxRow = Double.NEGATIVE_INFINITY;
            for (c = 0; c < bm.length; ++c) {
                eta[c] = r.innerProduct(bm[c]) + offset;
                if (!(eta[c] > maxRow)) continue;
                maxRow = eta[c];
            }
            for (c = 0; c < bm.length; ++c) {
                eta[c] = Math.exp(eta[c] - maxRow);
                sumExp += eta[c];
            }
            sumExp = 1.0 / sumExp;
            for (c = 0; c < bm.length; ++c) {
                preds[c + 1] = eta[c] * sumExp;
            }
            preds[0] = ArrayUtils.maxIndex((double[])eta);
            return preds;
        }

        public void reduce(GAMScore other) {
            if (this._mb != null) {
                this._mb.reduce(other._mb);
            }
        }

        protected void postGlobal() {
            if (this._mb != null) {
                this._mb.postGlobal();
            }
        }
    }

    public static class GAMModelOutput
    extends Model.Output {
        public String[] _coefficient_names_no_centering;
        public String[] _coefficient_names;
        public TwoDimTable _glm_model_summary;
        public ModelMetrics _glm_training_metrics;
        public ModelMetrics _glm_validation_metrics;
        public ModelMetrics _glm_cross_validation_metrics;
        public double _glm_dispersion;
        public double[] _glm_zvalues;
        public double[] _glm_pvalues;
        public double[][] _glm_vcov;
        public double[] _glm_stdErr;
        public double _glm_best_lamda_value;
        public TwoDimTable _glm_scoring_history;
        public TwoDimTable _coefficients_table;
        public TwoDimTable _coefficients_table_no_centering;
        public TwoDimTable _standardized_coefficient_magnitudes;
        public int _best_lambda_idx;
        public int _lambda_1se = -1;
        public int _selected_lambda_idx;
        public double[] _model_beta_no_centering;
        public double[] _standardized_model_beta_no_centering;
        public double[] _model_beta;
        public double[] _standardized_model_beta;
        public double[][] _model_beta_multinomial_no_centering;
        public double[][] _standardized_model_beta_multinomial_no_centering;
        public double[][] _model_beta_multinomial;
        public double[][] _standardized_model_beta_multinomial;
        private double[] _zvalues;
        private double _dispersion;
        private boolean _dispersionEstimated;
        public double[][][] _zTranspose;
        public double[][][] _penaltyMatrices_center;
        public double[][][] _penaltyMatrices;
        public double[][][] _binvD;
        public double[][] _knots;
        public int[] _numKnots;
        public Key<Frame> _gamTransformedTrainCenter;
        public DataInfo _dinfo;
        public String[] _responseDomains;
        public String _gam_transformed_center_key;
        final GLMModel.GLMParameters.Family _family;

        public double dispersion() {
            return this._dispersion;
        }

        public int nclasses() {
            if (this._family == GLMModel.GLMParameters.Family.multinomial || this._family == GLMModel.GLMParameters.Family.ordinal) {
                return super.nclasses();
            }
            if (GLMModel.GLMParameters.Family.binomial == this._family || GLMModel.GLMParameters.Family.quasibinomial == this._family || GLMModel.GLMParameters.Family.fractionalbinomial == this._family) {
                return 2;
            }
            return 1;
        }

        public String[] classNames() {
            if (this._family == GLMModel.GLMParameters.Family.fractionalbinomial) {
                return new String[]{"0", "1"};
            }
            return super.classNames();
        }

        public GAMModelOutput(GAM b, Frame adaptr, DataInfo dinfo) {
            super((ModelBuilder)b, adaptr);
            this._dinfo = dinfo;
            this._domains = dinfo._adaptedFrame.domains();
            this._responseDomains = dinfo._adaptedFrame.lastVec().domain();
            this._family = ((GAMParameters)b._parms)._family;
        }

        public ModelCategory getModelCategory() {
            switch (this._family) {
                case binomial: {
                    return ModelCategory.Binomial;
                }
                case multinomial: {
                    return ModelCategory.Multinomial;
                }
                case ordinal: {
                    return ModelCategory.Ordinal;
                }
            }
            return ModelCategory.Regression;
        }
    }

    public static class GAMParameters
    extends Model.Parameters {
        public boolean _standardize = false;
        public GLMModel.GLMParameters.Family _family;
        public GLMModel.GLMParameters.Link _link;
        public GLMModel.GLMParameters.Solver _solver = GLMModel.GLMParameters.Solver.AUTO;
        public double _tweedie_variance_power;
        public double _tweedie_link_power;
        public double _theta;
        public double _invTheta;
        public double[] _alpha;
        public double[] _lambda;
        public Serializable _missing_values_handling = GLMModel.GLMParameters.MissingValuesHandling.MeanImputation;
        public double _prior = -1.0;
        public boolean _lambda_search = false;
        public int _nlambdas = -1;
        public boolean _non_negative = false;
        public boolean _exactLambdas = false;
        public double _lambda_min_ratio = -1.0;
        public boolean _use_all_factor_levels = false;
        public int _max_iterations = -1;
        public boolean _intercept = true;
        public double _beta_epsilon = 1.0E-4;
        public double _objective_epsilon = -1.0;
        public double _gradient_epsilon = -1.0;
        public double _obj_reg = -1.0;
        public boolean _compute_p_values = false;
        public boolean _remove_collinear_columns = false;
        public String[] _interactions = null;
        public StringPair[] _interaction_pairs = null;
        public boolean _early_stopping = true;
        public Key<Frame> _beta_constraints = null;
        public Key<Frame> _plug_values = null;
        public int _max_active_predictors = -1;
        public boolean _stdOverride;
        public int[] _num_knots;
        public double[][] _knots;
        public String[] _knot_ids;
        public String[] _gam_columns;
        public int[] _bs;
        public double[] _scale;
        public GLMModel.GLMParameters.GLMType _glmType = GLMModel.GLMParameters.GLMType.gam;
        public boolean _saveZMatrix = false;
        public boolean _keep_gam_cols = false;
        public boolean _savePenaltyMat = false;
        public long _seed = -1L;

        public String algoName() {
            return "GAM";
        }

        public String fullName() {
            return "General Additive Model";
        }

        public String javaName() {
            return GAMModel.class.getName();
        }

        public long progressUnits() {
            return 1L;
        }

        public Model.InteractionSpec interactionSpec() {
            return Model.InteractionSpec.create((String[])this._interactions, (StringPair[])this._interaction_pairs);
        }

        public GLMModel.GLMParameters.MissingValuesHandling missingValuesHandling() {
            if (this._missing_values_handling instanceof GLMModel.GLMParameters.MissingValuesHandling) {
                return (GLMModel.GLMParameters.MissingValuesHandling)((Object)this._missing_values_handling);
            }
            assert (this._missing_values_handling instanceof DeepLearningModel.DeepLearningParameters.MissingValuesHandling);
            switch ((DeepLearningModel.DeepLearningParameters.MissingValuesHandling)((Object)this._missing_values_handling)) {
                case MeanImputation: {
                    return GLMModel.GLMParameters.MissingValuesHandling.MeanImputation;
                }
                case Skip: {
                    return GLMModel.GLMParameters.MissingValuesHandling.Skip;
                }
            }
            throw new IllegalStateException("Unsupported missing values handling value: " + this._missing_values_handling);
        }

        public DataInfo.Imputer makeImputer() {
            if (this.missingValuesHandling() == GLMModel.GLMParameters.MissingValuesHandling.PlugValues) {
                if (this._plug_values == null || this._plug_values.get() == null) {
                    throw new IllegalStateException("Plug values frame needs to be specified when Missing Value Handling = PlugValues.");
                }
                return new GLM.PlugValuesImputer((Frame)this._plug_values.get());
            }
            return new DataInfo.MeanImputer();
        }

        public static final double linkInv(double x, GLMModel.GLMParameters.Link link, double tweedie_link_power) {
            switch (link) {
                case identity: {
                    return x;
                }
                case ologlog: {
                    return 1.0 - Math.exp(-1.0 * Math.exp(x));
                }
                case ologit: 
                case logit: {
                    return 1.0 / (Math.exp(-x) + 1.0);
                }
                case log: {
                    return Math.exp(x);
                }
                case inverse: {
                    double xx = x < 0.0 ? Math.min(-1.0E-5, x) : Math.max(1.0E-5, x);
                    return 1.0 / xx;
                }
                case tweedie: {
                    return tweedie_link_power == 0.0 ? Math.max(2.0E-16, Math.exp(x)) : Math.pow(x, 1.0 / tweedie_link_power);
                }
            }
            throw new RuntimeException("unexpected link function  " + link.toString());
        }

        public static enum BSType {
            cr;

        }
    }
}

