/*
 * Decompiled with CFR 0.152.
 */
package hex.gam.GamSplines;

import hex.gam.MatrixFrameUtils.TriDiagonalMatrix;
import hex.util.LinearAlgebraUtils;
import water.util.ArrayUtils;

public class CubicRegressionSplines {
    public double[] _knots;
    public double[] _hj;
    int _knotNum;

    public CubicRegressionSplines(int knotNum, double[] knots) {
        this._knotNum = knotNum;
        this._knots = knots;
        this._hj = ArrayUtils.eleDiff((double[])this._knots);
    }

    public double[][] gen_BIndvD(double[] hj) {
        TriDiagonalMatrix matrixD = new TriDiagonalMatrix(hj);
        double[][] matB = LinearAlgebraUtils.generateTriDiagMatrix(hj);
        LinearAlgebraUtils.choleskySymDiagMat(matB);
        double[][] fullmatB = LinearAlgebraUtils.expandLowTrian2Ful(matB);
        double[][] bInve = LinearAlgebraUtils.chol2Inv(fullmatB, false);
        return LinearAlgebraUtils.matrixMultiplyTriagonal(bInve, matrixD, true);
    }

    public double[][] gen_penalty_matrix(double[] hj, double[][] binvD) {
        TriDiagonalMatrix matrixD = new TriDiagonalMatrix(hj);
        return LinearAlgebraUtils.matrixMultiplyTriagonal(ArrayUtils.transpose((double[][])binvD), matrixD, false);
    }

    public static double gen_a_m_j(double xjp1, double x, double hj) {
        return (xjp1 - x) / hj;
    }

    public static double gen_a_p_j(double xj, double x, double hj) {
        return (x - xj) / hj;
    }

    public static double gen_c_m_j(double xjp1, double x, double hj) {
        double t = xjp1 - x;
        double t3 = t * t * t;
        return (t3 / hj - t * hj) / 6.0;
    }

    public static double gen_c_p_j(double xj, double x, double hj) {
        double t = x - xj;
        double t3 = t * t * t;
        return (t3 / hj - t * hj) / 6.0;
    }
}

