/*
 * Decompiled with CFR 0.152.
 */
package hex.gam.MatrixFrameUtils;

import hex.gam.GamSplines.CubicRegressionSplines;
import hex.gam.MatrixFrameUtils.GamUtils;
import hex.gam.MatrixFrameUtils.GenerateGamMatrixOneColumn;
import water.MRTask;
import water.MemoryManager;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.util.ArrayUtils;

public class AddGamColumns
extends MRTask<AddGamColumns> {
    double[][][] _binvD;
    double[][] _knotsMat;
    double[][][] _ztransp;
    int[] _numKnots;
    public int _numGAMcols;
    public int _gamCols2Add = 0;
    double[] _vmax;
    double[] _vmin;
    int[] _gamColsOffsets;
    Frame _gamFrame;

    public AddGamColumns(double[][][] binvD, double[][][] ztransp, double[][] knotsMat, int[] numKnots, Frame gamColFrames) {
        this._binvD = binvD;
        this._knotsMat = knotsMat;
        this._numKnots = numKnots;
        this._numGAMcols = numKnots.length;
        this._vmax = MemoryManager.malloc8d((int)this._numGAMcols);
        this._vmin = MemoryManager.malloc8d((int)this._numGAMcols);
        this._gamColsOffsets = MemoryManager.malloc4((int)this._numGAMcols);
        this._gamFrame = gamColFrames;
        this._ztransp = ztransp;
        int firstOffset = 0;
        for (int ind = 0; ind < this._numGAMcols; ++ind) {
            this._vmax[ind] = gamColFrames.vec(ind).max();
            this._vmin[ind] = gamColFrames.vec(ind).min();
            this._gamCols2Add += this._numKnots[ind] - 1;
            int n = ind;
            this._gamColsOffsets[n] = this._gamColsOffsets[n] + firstOffset;
            firstOffset += this._numKnots[ind] - 1;
        }
    }

    public void map(Chunk[] chk, NewChunk[] newChunks) {
        CubicRegressionSplines[] crSplines = new CubicRegressionSplines[this._numGAMcols];
        double[][] basisVals = new double[this._numGAMcols][];
        double[][] basisValsCenter = new double[this._numGAMcols][];
        for (int gcolInd = 0; gcolInd < this._numGAMcols; ++gcolInd) {
            crSplines[gcolInd] = new CubicRegressionSplines(this._numKnots[gcolInd], this._knotsMat[gcolInd]);
            basisValsCenter[gcolInd] = MemoryManager.malloc8d((int)(this._numKnots[gcolInd] - 1));
            basisVals[gcolInd] = MemoryManager.malloc8d((int)this._numKnots[gcolInd]);
        }
        int chkLen = chk[0]._len;
        for (int rInd = 0; rInd < chkLen; ++rInd) {
            for (int cInd = 0; cInd < this._numGAMcols; ++cInd) {
                this.generateOneGAMcols(cInd, this._gamColsOffsets[cInd], basisVals[cInd], basisValsCenter[cInd], this._binvD[cInd], crSplines[cInd], chk[cInd].atd(rInd), newChunks);
            }
        }
    }

    public void generateOneGAMcols(int colInd, int colOffset, double[] basisVals, double[] basisValCenter, double[][] bInvD, CubicRegressionSplines splines, double xval, NewChunk[] newChunks) {
        int centerKnots = this._numKnots[colInd] - 1;
        if (!Double.isNaN(xval)) {
            int binIndex = GamUtils.locateBin(xval, splines._knots);
            GenerateGamMatrixOneColumn.updateFMatrixCFunc(basisVals, xval, binIndex, splines, bInvD);
            GenerateGamMatrixOneColumn.updateAFunc(basisVals, xval, binIndex, splines);
            basisValCenter = ArrayUtils.multArrVec((double[][])this._ztransp[colInd], (double[])basisVals, (double[])basisValCenter);
            for (int colIndex = 0; colIndex < centerKnots; ++colIndex) {
                newChunks[colIndex + colOffset].addNum(basisValCenter[colIndex]);
            }
        } else {
            for (int colIndex = 0; colIndex < centerKnots; ++colIndex) {
                newChunks[colIndex + colOffset].addNum(Double.NaN);
            }
        }
    }
}

